/*
 * Decompiled with CFR 0.152.
 */
package Messages;

import Messages.Message_Status_SceneBridgeCursor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Message_Scenebook
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    private ArrayList<ScenebookRow> m_ScenebookRows;
    private ArrayList<Integer> m_VIPTypes;

    public Message_Scenebook() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_VIPTypes = new ArrayList();
        this.m_ScenebookRows = new ArrayList();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        int intVIPTypeCount = this.m_VIPTypes.size();
        out.writeInt(intVIPTypeCount);
        for (int intType = 0; intType < intVIPTypeCount; ++intType) {
            int intVIPType = this.m_VIPTypes.get(intType);
            out.writeInt(intVIPType);
        }
        int intScenebookRowCount = this.m_ScenebookRows.size();
        out.writeInt(intScenebookRowCount);
        for (int intRow = 0; intRow < intScenebookRowCount; ++intRow) {
            ScenebookRow o_ScenebookEow = this.m_ScenebookRows.get(intRow);
            o_ScenebookEow.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intVIPTypeCount = in.readInt();
        for (int intType = 0; intType < intVIPTypeCount; ++intType) {
            int intVIPType = in.readInt();
            this.m_VIPTypes.add(intVIPType);
        }
        int intScenebookRowCount = in.readInt();
        for (int intBridge = 0; intBridge < intScenebookRowCount; ++intBridge) {
            ScenebookRow o_ScenebookRow = new ScenebookRow();
            o_ScenebookRow.readExternal(in);
            this.addScenebookRow(o_ScenebookRow);
        }
    }

    public void addVIPType(int p_VIPType) {
        if (this.m_VIPTypes.contains(p_VIPType)) {
            return;
        }
        this.m_VIPTypes.add(p_VIPType);
    }

    public int getVIPTypeCount() {
        return this.m_VIPTypes.size();
    }

    public int getVIPType(int p_Index) {
        if (p_Index < 0) {
            return -1;
        }
        if (p_Index >= this.m_VIPTypes.size()) {
            return -1;
        }
        return this.m_VIPTypes.get(p_Index);
    }

    public void addScenebookRow(ScenebookRow p_ScenebookRow) {
        if (p_ScenebookRow == null) {
            return;
        }
        if (this.m_ScenebookRows.contains(p_ScenebookRow)) {
            return;
        }
        this.m_ScenebookRows.add(p_ScenebookRow);
    }

    public void addScenebookRow(ArrayList<Message_Status_SceneBridgeCursor.BridgeDescription> p_BridgeDescriptions) {
        if (p_BridgeDescriptions == null) {
            return;
        }
        if (p_BridgeDescriptions.size() <= 0) {
            return;
        }
        ScenebookRow o_ScenebookRow = new ScenebookRow();
        for (int intBridge = 0; intBridge < p_BridgeDescriptions.size(); ++intBridge) {
            o_ScenebookRow.addBridgeDescription(p_BridgeDescriptions.get(intBridge));
        }
        this.m_ScenebookRows.add(o_ScenebookRow);
    }

    public int getScenebookRowCount() {
        return this.m_ScenebookRows.size();
    }

    public ScenebookRow getScenebookRow(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_ScenebookRows.size()) {
            return null;
        }
        return this.m_ScenebookRows.get(p_Index);
    }

    public static class ScenebookRow
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        ArrayList<Message_Status_SceneBridgeCursor.BridgeDescription> m_BridgeDescriptions;

        public ScenebookRow() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_BridgeDescriptions = new ArrayList();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            int intBridgeCount = this.m_BridgeDescriptions.size();
            out.writeInt(intBridgeCount);
            for (int intBridge = 0; intBridge < intBridgeCount; ++intBridge) {
                Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription = this.m_BridgeDescriptions.get(intBridge);
                o_BridgeDescription.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            int intBridgeCount = in.readInt();
            for (int intBridge = 0; intBridge < intBridgeCount; ++intBridge) {
                Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription = new Message_Status_SceneBridgeCursor.BridgeDescription();
                o_BridgeDescription.readExternal(in);
                this.addBridgeDescription(o_BridgeDescription);
            }
        }

        public void addBridgeDescription(Message_Status_SceneBridgeCursor.BridgeDescription p_BridgeDescription) {
            if (p_BridgeDescription == null) {
                return;
            }
            if (this.m_BridgeDescriptions.contains(p_BridgeDescription)) {
                return;
            }
            this.m_BridgeDescriptions.add(p_BridgeDescription);
        }

        public int getBridgeDescriptionCount() {
            return this.m_BridgeDescriptions.size();
        }

        public Message_Status_SceneBridgeCursor.BridgeDescription getBridgeDescription(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_BridgeDescriptions.size()) {
                return null;
            }
            return this.m_BridgeDescriptions.get(p_Index);
        }
    }
}

