/*
 * Decompiled with CFR 0.152.
 */
package Messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Message_Permission
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String ELEMENTID_DIRECTION = "elementid_direction";
    public static final String ELEMENTID_PLAYCONTROL = "elementid_playcontrol";
    public static final String ELEMENTID_SCENEBOOK = "elementid_scenebook";
    public static final String ELEMENTID_JINGLE = "elementid_jingle";
    public static final String ELEMENTID_MASTER = "elementid_master";
    public static final String ELEMENTID_DMXSTAGE = "elementid_dmxstage";
    public static final String ELEMENTID_REMOTEBOARD = "elementid_remoteboard";
    RemoteUserDescription m_RemoteUserDescription;

    public Message_Permission() {
    }

    public Message_Permission(RemoteUserDescription p_RemoteUserDescription) {
        if (p_RemoteUserDescription == null) {
            p_RemoteUserDescription = new RemoteUserDescription();
        }
        this.m_RemoteUserDescription = p_RemoteUserDescription;
    }

    public RemoteUserDescription getRemoteUserDescription() {
        return this.m_RemoteUserDescription;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_RemoteUserDescription.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_RemoteUserDescription = new RemoteUserDescription();
        this.m_RemoteUserDescription.readExternal(in);
    }

    public static class RemoteUserDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private String m_UserName;
        private String m_UserPassword;
        private boolean m_PermissionControl;
        private boolean m_PermissionListen;
        private ArrayList<String> m_RemoteElements;

        public RemoteUserDescription() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_UserName = "";
            this.m_UserPassword = "";
            this.m_PermissionControl = false;
            this.m_PermissionListen = false;
            this.m_RemoteElements = new ArrayList();
        }

        public void setUserName(String p_UserName) {
            if (p_UserName == null) {
                p_UserName = "";
            }
            this.m_UserName = p_UserName;
        }

        public String getUserName() {
            return this.m_UserName;
        }

        public void setUserPassword(String p_UserNamePassword) {
            if (p_UserNamePassword == null) {
                p_UserNamePassword = "";
            }
            this.m_UserPassword = p_UserNamePassword;
        }

        public String getUserPassword() {
            return this.m_UserPassword;
        }

        public void setPermissionControl(boolean p_Allow) {
            this.m_PermissionControl = p_Allow;
        }

        public boolean getPermissionControl() {
            return this.m_PermissionControl;
        }

        public void setPermissionListen(boolean p_Allow) {
            this.m_PermissionListen = p_Allow;
        }

        public boolean getPermissionListen() {
            return this.m_PermissionListen;
        }

        public void addRemoteElement(String p_RemoteElementID) {
            if (p_RemoteElementID == null) {
                return;
            }
            if (this.m_RemoteElements.contains(p_RemoteElementID)) {
                return;
            }
            this.m_RemoteElements.add(p_RemoteElementID);
        }

        public void removeRemoteElement(String p_RemoteElementID) {
            if (p_RemoteElementID == null) {
                return;
            }
            this.m_RemoteElements.remove(p_RemoteElementID);
        }

        public int getRemoteElementCount() {
            return this.m_RemoteElements.size();
        }

        public String getRemoteElement(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_RemoteElements.size()) {
                return null;
            }
            return this.m_RemoteElements.get(p_Index);
        }

        public boolean hasRemoteElement(String p_ElementsID) {
            if (p_ElementsID == null) {
                return false;
            }
            return this.m_RemoteElements.contains(p_ElementsID);
        }

        public void clearRemoteElements() {
            this.m_RemoteElements.clear();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_UserName);
            out.writeUTF(this.m_UserPassword);
            out.writeBoolean(this.m_PermissionControl);
            out.writeBoolean(this.m_PermissionListen);
            out.writeInt(this.m_RemoteElements.size());
            for (int intElement = 0; intElement < this.m_RemoteElements.size(); ++intElement) {
                out.writeUTF(this.m_RemoteElements.get(intElement));
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_UserName = in.readUTF();
            this.m_UserPassword = in.readUTF();
            this.m_PermissionControl = in.readBoolean();
            this.m_PermissionListen = in.readBoolean();
            this.m_RemoteElements.clear();
            int intRemoteElementCount = in.readInt();
            for (int intElement = 0; intElement < intRemoteElementCount; ++intElement) {
                String stringRemoteElementID = in.readUTF();
                if (this.m_RemoteElements.contains(stringRemoteElementID)) continue;
                this.m_RemoteElements.add(stringRemoteElementID);
            }
        }
    }
}

