/*
 * Decompiled with CFR 0.152.
 */
package StartPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlGroup;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import PlaySoundPackage.PlaySound;
import SoundGraphics.LiveShowSoundHDView;
import SoundGraphics.LiveShowSoundMixersInternalFrame;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundSamplePackage.LiveShowSoundHDListener;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundVIP;
import SwingFramePackage.JOptionDialog;
import java.awt.Font;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.sound.sampled.AudioFormat;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LiveShowSoundSystem
implements LiveShowSoundHDListener {
    public static boolean DEBUG_ON = false;
    public static FileNameExtensionFilter FILENAME_FILTER_SOUND = FileSelection.createFileNameExtensionFilter((String)"Sound/Video Files", (String[])new String[]{"avi", "mp4", "mpg", "mp2", "wmv", "mov", "ogg", "amv", "asf", "divx", "flv", "dv", "iso", "mpeg1", "mpeg2", "mpeg4", "mkv", "vob", "wav", "mp3", "wma", "aac", "aif", "aiff"});
    public static String FILENAME_SOUNDDIRECTORY = "/SoundFiles";
    public static final String FOLDER_LANGUAGES = "Languages";
    public static final String FOLDER_STYLES = "Styles";
    public static Locale s_LanguageLocale;
    public static Font s_FontDefault;
    @LiveLanguageString
    public static String FILENOTFOUND_TITEL;
    @LiveLanguageString
    public static String FILENOTFOUND_REMARK;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_SEARCH;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_DISCARD;
    @LiveLanguageString
    public static String FILENOTFOUND_BUTTON_DISCARDALL;
    public static boolean s_FIleNotFoundCancelAll;
    @LiveLanguageString
    public static String SOUNDFILEERROR_REMARK;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_TITEL;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_REASON;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_EFFECT;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_REMARK;
    @LiveLanguageString
    public static String FILENOTWRITEPERMISSION_QUESTION;
    @LiveLanguageString
    public static String FILEDUPLICATION_TITEL;
    @LiveLanguageString
    public static String FILEDUPLICATION_REASON;
    @LiveLanguageString
    public static String FILEDUPLICATION_EFFECT;
    @LiveLanguageString
    public static String FILEDUPLICATION_REMARK;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_TITEL;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_REASON;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_EFFECT;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_REMARK;
    @LiveLanguageString
    public static String FILEDUPLICATIONSAMECONTENT_QUESTION;
    @LiveLanguageString
    public static String FILEREPLACEMENT_REASON;
    @LiveLanguageString
    public static String FILEREPLACEMENT_EFFECT;
    @LiveLanguageString
    public static String FILEREPLACEMENT_REMARK;
    @LiveLanguageString
    public static String FILEREPLACEMENT_QUESTION;
    @LiveLanguageString
    public static String ERROR_NOMIXERFOUND;
    @LiveLanguageString
    public static String LOAD_SOUNDFILE;
    private static LiveShowProjectDescription s_LiveShowProjectDescription;
    private static LiveShowSoundHD.SoundHDTableModel s_SoundHDTableModel;
    public static LiveShowSoundHDView s_LiveShowSoundHDView;
    private static LiveShowSoundMixersInternalFrame s_LiveShowSoundMixersInternalFrame;
    private static LiveShowSoundVIP s_LiveShowSoundVIP;
    private static ArrayList<LiveShowSoundObject> s_JingleObjects;
    private static final Object s_SyncJingles;
    private static ArrayList<PlayPrefetchBuffer> s_PlayBuffersReleased;
    public static LiveShowSoundSystem s_SingleInstance;
    private static final Object s_SyncVIP;
    private static final Object s_SyncHD;
    private static final Object s_SyncPlayBuffer;
    public static PlayBufferThread s_ThreadFillPlayBuffer;
    private static ArrayList<PlaySound> s_PlaySounds;
    private static final Object s_SyncExport;
    private static ArrayList<File> s_ExportedFiles;
    private static ArrayList<String> s_ExportedFileCheckSums;
    private static HashMap<String, String> s_ExportedReplacement;
    public static File s_LastOpenFilePath;
    public static ControlGroup s_ControlGroup_Active;
    public static JarResources s_JarResources_Default;
    public static WindowFocusListener s_HelpFocusListener;
    public static LiveShowJingle.JingleCreatorInterface s_JingleCreatorInterface;
    public static LiveShowJingle.JingleContainerInterface s_JingleContainerInterface;

    public LiveShowSoundSystem() {
        this.initMembers();
        LiveShowSoundSystem.init();
        LiveLanguage.addLanguageListener((Object)this, null);
        SoundMixers.showNotificationSoundCardLost((boolean)true);
    }

    private static void init() {
        s_LanguageLocale = Locale.getDefault();
        s_FontDefault = UIManager.getFont(s_LanguageLocale);
    }

    private void initMembers() {
    }

    public static void closeProject() {
        LiveShowSoundObjectDescription.poolClear();
    }

    public static void setLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        s_LiveShowProjectDescription = p_LiveShowProjectDescription;
        LiveShowSoundObject.clearHashMapFilePositions();
        s_FIleNotFoundCancelAll = false;
    }

    public static LiveShowProjectDescription getLiveShowProjectDescription() {
        return s_LiveShowProjectDescription;
    }

    public static String getFolderStyles() {
        return FOLDER_STYLES;
    }

    public static Locale getLanguageLocale() {
        if (s_LanguageLocale == null) {
            return Locale.getDefault();
        }
        return s_LanguageLocale;
    }

    public static Font getFontDefault() {
        return s_FontDefault;
    }

    public static void notifyError(Exception p_Exception, String p_Titel, String p_Remark1, String p_Remark2) {
        String stringRemark = "<html>" + p_Remark1 + "<br>" + p_Remark2 + "</html>";
        JOptionDialog.showMessageDialog(null, stringRemark, p_Titel, 0);
    }

    public static void addPlaySound(PlaySound p_PlaySound) {
        if (p_PlaySound == null) {
            return;
        }
        if (s_PlaySounds != null) {
            if (s_PlaySounds.contains(p_PlaySound)) {
                return;
            }
            s_PlaySounds.add(p_PlaySound);
        }
    }

    public static void removePlaySound(PlaySound p_PlaySound) {
        if (p_PlaySound == null) {
            return;
        }
        if (s_PlaySounds != null) {
            if (!s_PlaySounds.contains(p_PlaySound)) {
                return;
            }
            s_PlaySounds.remove(p_PlaySound);
        }
    }

    public static ArrayList<PlaySound> getPlaySounds() {
        return s_PlaySounds;
    }

    public static AudioFormat getAudioFormatMatching(AudioFormat p_AudioFormat) {
        if (p_AudioFormat == null) {
            return SoundMixers.DEFAULT_AUDIOFORMAT;
        }
        AudioFormat o_AudioFormat = new AudioFormat(SoundMixers.DEFAULT_AUDIOFORMAT.getEncoding(), SoundMixers.DEFAULT_AUDIOFORMAT.getSampleRate(), SoundMixers.DEFAULT_AUDIOFORMAT.getSampleSizeInBits(), p_AudioFormat.getChannels(), p_AudioFormat.getChannels() * SoundMixers.DEFAULT_AUDIOFORMAT.getSampleSizeInBits() / 8, SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate(), SoundMixers.DEFAULT_AUDIOFORMAT.isBigEndian());
        return o_AudioFormat;
    }

    public static boolean matchesAudioFormat(File p_SoundFile, AudioFormat p_AudioFormat, boolean p_IgnoreChannels) {
        if (p_SoundFile == null) {
            return false;
        }
        if (p_AudioFormat == null) {
            return false;
        }
        AudioFormat o_AudioFormat = null;
        o_AudioFormat = SoundMixers.getAudioFormat((File)p_SoundFile);
        return LiveShowSoundSystem.matchesAudioFormat(o_AudioFormat, p_AudioFormat, p_IgnoreChannels);
    }

    public static boolean matchesAudioFormat(AudioFormat p_AudioFormat1, AudioFormat p_AudioFormat2, boolean p_IgnoreChannels) {
        if (p_AudioFormat1 == null) {
            return false;
        }
        if (p_AudioFormat2 == null) {
            return false;
        }
        if (!p_AudioFormat1.getEncoding().equals(p_AudioFormat2.getEncoding())) {
            return false;
        }
        if (p_AudioFormat1.getFrameRate() != p_AudioFormat2.getFrameRate()) {
            return false;
        }
        if (p_AudioFormat1.getSampleRate() != p_AudioFormat2.getSampleRate()) {
            return false;
        }
        if (p_AudioFormat1.getSampleSizeInBits() != p_AudioFormat2.getSampleSizeInBits()) {
            return false;
        }
        if (p_AudioFormat1.isBigEndian() != p_AudioFormat2.isBigEndian()) {
            return false;
        }
        if (!p_IgnoreChannels) {
            if (p_AudioFormat1.getChannels() != p_AudioFormat2.getChannels()) {
                return false;
            }
            if (p_AudioFormat1.getFrameSize() != p_AudioFormat2.getFrameSize()) {
                return false;
            }
        }
        return true;
    }

    public static String calculateConvertedSoundFileName(File p_SoundFile, AudioFormat p_AudioFormat) {
        if (p_SoundFile == null) {
            return null;
        }
        if (p_AudioFormat == null) {
            return null;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        String stringFileNameBase = FileTools.getFileNameBase((File)p_SoundFile);
        int intPosition = stringFileNameBase.indexOf("_PCM_");
        if (intPosition > 0) {
            stringFileNameBase = stringFileNameBase.substring(0, intPosition);
        }
        stringFileNameBase = FileTools.validateName((String)stringFileNameBase);
        o_StringBuilder.append(stringFileNameBase);
        o_StringBuilder.append("_PCM_");
        o_StringBuilder.append(String.valueOf((int)p_AudioFormat.getSampleRate()));
        o_StringBuilder.append("_");
        o_StringBuilder.append(String.valueOf(p_AudioFormat.getChannels()));
        o_StringBuilder.append("_");
        if (p_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_FLOAT) {
            o_StringBuilder.append("F");
        } else if (p_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            o_StringBuilder.append("S");
        } else if (p_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            o_StringBuilder.append("U");
        }
        o_StringBuilder.append(String.valueOf(p_AudioFormat.getSampleSizeInBits()));
        if (p_AudioFormat.isBigEndian()) {
            o_StringBuilder.append("BE");
        } else {
            o_StringBuilder.append("LE");
        }
        o_StringBuilder.append(".wav");
        return o_StringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkSoundFileNameDuplicated_load(File p_SoundFile, AudioFormat p_AudioFormat) {
        if (p_SoundFile == null) {
            return null;
        }
        LiveShowSoundHD o_LiveShowSoundHD = null;
        String stringSoundFileName = LiveShowSoundSystem.matchesAudioFormat(p_SoundFile, p_AudioFormat, true) ? p_SoundFile.getName() : LiveShowSoundSystem.calculateConvertedSoundFileName(p_SoundFile, p_AudioFormat);
        Object object = s_SyncHD;
        synchronized (object) {
            for (int intHD = 0; intHD < s_SoundHDTableModel.size(); ++intHD) {
                File o_SoundFile;
                o_LiveShowSoundHD = (LiveShowSoundHD)s_SoundHDTableModel.get(intHD);
                if (o_LiveShowSoundHD == null || (o_SoundFile = o_LiveShowSoundHD.getSoundFile()) == null) continue;
                if (FileTools.getPathName((File)p_SoundFile).equals(FileTools.getPathName((File)o_SoundFile))) {
                    return null;
                }
                if (o_SoundFile.getName().equals(stringSoundFileName)) {
                    return o_SoundFile;
                }
                o_LiveShowSoundHD = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSoundHD getLiveShowSoundHDByFileName(String p_FileName) {
        Object object = s_SyncHD;
        synchronized (object) {
            for (int intHD = 0; intHD < s_SoundHDTableModel.size(); ++intHD) {
                File o_SoundFile;
                LiveShowSoundHD o_LiveShowSoundHD = (LiveShowSoundHD)s_SoundHDTableModel.get(intHD);
                if (o_LiveShowSoundHD == null || (o_SoundFile = o_LiveShowSoundHD.getSoundFile()) == null) continue;
                if (o_SoundFile.getName().equals(p_FileName)) {
                    return o_LiveShowSoundHD;
                }
                o_LiveShowSoundHD = null;
            }
        }
        return null;
    }

    public static int showOptionPane_WarningWritable(File p_MediaFile, File p_Directory) {
        JLabel o_LabelMessage = new JLabel();
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        if (p_MediaFile != null) {
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(p_MediaFile.getName());
            o_StringBuffer.append("</b><br>");
        }
        o_StringBuffer.append(FILENOTWRITEPERMISSION_REASON);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_EFFECT);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_REMARK);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append(FILENOTWRITEPERMISSION_QUESTION);
        o_StringBuffer.append("</html>");
        o_LabelMessage.setText(o_StringBuffer.toString());
        int intAnswer = JOptionDialog.showConfirmDialog(null, o_LabelMessage, FILENOTWRITEPERMISSION_TITEL + p_Directory.getAbsolutePath(), 0, 0, 1);
        return intAnswer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkSoundFileNameDuplicated_save(File p_SoundFile, AudioFormat p_AudioFormat, File o_NewDirectory) {
        if (p_SoundFile == null) {
            return null;
        }
        if (o_NewDirectory == null) {
            return null;
        }
        String stringSoundFileName = LiveShowSoundSystem.matchesAudioFormat(p_SoundFile, p_AudioFormat, true) ? p_SoundFile.getName() : LiveShowSoundSystem.calculateConvertedSoundFileName(p_SoundFile, p_AudioFormat);
        Object object = s_SyncHD;
        synchronized (object) {
            File[] o_Files = o_NewDirectory.listFiles();
            if (o_Files == null) {
                return null;
            }
            for (int intFile = 0; intFile < o_Files.length; ++intFile) {
                File o_SoundFile = o_Files[intFile];
                if (o_SoundFile == null) continue;
                if (FileTools.getPathName((File)p_SoundFile).equals(FileTools.getPathName((File)o_SoundFile))) {
                    return null;
                }
                if (!o_SoundFile.getName().equals(stringSoundFileName)) continue;
                if (FileTools.getCheckSum_MD5_Partial((File)o_SoundFile).equals(FileTools.getCheckSum_MD5_Partial((File)p_SoundFile))) {
                    return null;
                }
                return o_SoundFile;
            }
        }
        return null;
    }

    public static int showOptionPane_WarningFileDuplication(File p_SoundFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName((File)p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br>" + FileTools.getPathName((File)p_SoundFile) + File.separator + p_SoundFile.getName() + "<br>" + FILEDUPLICATION_REASON + "<br>" + FILEDUPLICATION_EFFECT + "<br><br>" + FILEDUPLICATION_REMARK + "<br></html>");
        JOptionDialog.showMessageDialog(null, o_LabelMessage, FILEDUPLICATION_TITEL + p_SoundFile.getAbsolutePath(), 0);
        return 1;
    }

    public static int showOptionPane_WarningFileDuplication_SameContent(File p_MediaFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName((File)p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br>" + FileTools.getPathName((File)p_MediaFile) + File.separator + p_MediaFile.getName() + "<br>" + FILEDUPLICATIONSAMECONTENT_REASON + "<br>" + FILEDUPLICATIONSAMECONTENT_EFFECT + "<br><br>" + FILEDUPLICATIONSAMECONTENT_REMARK + "<br><br>" + FILEDUPLICATIONSAMECONTENT_QUESTION + "<br>" + FileTools.getPathName((File)p_MediaFile) + File.separator + p_MediaFile.getName() + "<br></html>");
        return JOptionDialog.showConfirmDialog(null, o_LabelMessage, FILEDUPLICATIONSAMECONTENT_TITEL + " " + p_ProblemFile.getAbsolutePath(), 0, 2, 1);
    }

    public static String showOptionPane_ReplaceFileDuplication(File p_SoundFile, File p_ProblemFile) {
        JLabel o_LabelMessage = new JLabel();
        o_LabelMessage.setText("<html>" + FileTools.getPathName((File)p_ProblemFile) + File.separator + p_ProblemFile.getName() + "<br>" + FileTools.getPathName((File)p_SoundFile) + File.separator + p_SoundFile.getName() + "<br>" + FILEREPLACEMENT_REASON + "<br>" + FILEREPLACEMENT_EFFECT + "<br><br>" + FILEREPLACEMENT_REMARK + "<br>" + FileTools.getPathName((File)p_SoundFile) + File.separator + p_SoundFile.getName() + "<br><br>" + FILEREPLACEMENT_QUESTION + "</html>");
        String o_String = JOptionDialog.showInputDialog(null, o_LabelMessage, FILEDUPLICATION_TITEL + p_SoundFile.getAbsolutePath(), 2);
        return o_String;
    }

    public static LiveShowSoundHD createLiveShowSoundHD(String p_SoundFilePathName) {
        File o_File = new File(p_SoundFilePathName);
        return LiveShowSoundSystem.createLiveShowSoundHD(o_File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSoundHD createLiveShowSoundHD(File p_SoundFile) {
        LiveShowSoundHD o_LiveShowSoundHD = null;
        Object object = s_SyncHD;
        synchronized (object) {
            block7: {
                o_LiveShowSoundHD = LiveShowSoundSystem.getLiveShowSoundHD(p_SoundFile);
                if (o_LiveShowSoundHD == null) {
                    try {
                        o_LiveShowSoundHD = new LiveShowSoundHD(p_SoundFile);
                        o_LiveShowSoundHD.addLiveShowSoundHDListener(s_SingleInstance);
                        o_LiveShowSoundHD.load();
                        LiveShowSoundSystem.addLiveShowSoundHD(o_LiveShowSoundHD);
                    }
                    catch (Exception e) {
                        if (o_LiveShowSoundHD != null) {
                            o_LiveShowSoundHD.close();
                        }
                        o_LiveShowSoundHD = null;
                        if (!p_SoundFile.exists()) break block7;
                        JOptionDialog.showMessageDialog(null, SOUNDFILEERROR_REMARK, p_SoundFile.getPath(), 0);
                    }
                }
            }
        }
        return o_LiveShowSoundHD;
    }

    public static LiveShowSoundHD.SoundHDTableModel getSoundHDTableModel() {
        return s_SoundHDTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLiveShowSoundHDCount() {
        int intHDCount = 0;
        Object object = s_SyncHD;
        synchronized (object) {
            intHDCount = s_SoundHDTableModel.size();
        }
        return intHDCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSoundHD getLiveShowSoundHD(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowSoundHD o_LiveShowSoundHD = null;
        Object object = s_SyncHD;
        synchronized (object) {
            if (p_Index < s_SoundHDTableModel.size()) {
                o_LiveShowSoundHD = (LiveShowSoundHD)s_SoundHDTableModel.get(p_Index);
            }
        }
        return o_LiveShowSoundHD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowSoundHD getLiveShowSoundHD(File p_SoundFile) {
        if (p_SoundFile == null) {
            return null;
        }
        LiveShowSoundHD o_LiveShowSoundHD = null;
        Object object = s_SyncHD;
        synchronized (object) {
            for (int intHD = 0; intHD < s_SoundHDTableModel.size(); ++intHD) {
                o_LiveShowSoundHD = (LiveShowSoundHD)s_SoundHDTableModel.get(intHD);
                if (o_LiveShowSoundHD == null) continue;
                File o_SoundFile = o_LiveShowSoundHD.getSoundFile();
                if (p_SoundFile.equals(o_SoundFile)) break;
                o_LiveShowSoundHD = null;
            }
        }
        return o_LiveShowSoundHD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addLiveShowSoundHD(LiveShowSoundHD p_LiveShowSoundHD) {
        if (p_LiveShowSoundHD == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = s_SyncHD;
        synchronized (object) {
            if (s_SoundHDTableModel.contains(p_LiveShowSoundHD)) {
                boolAdded = true;
            } else {
                s_SoundHDTableModel.add(p_LiveShowSoundHD);
                p_LiveShowSoundHD.addLiveShowSoundHDListener(s_SingleInstance);
                boolAdded = true;
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeLiveShowSoundHD(LiveShowSoundHD p_LiveShowSoundHD) {
        if (p_LiveShowSoundHD == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = s_SyncHD;
        synchronized (object) {
            boolRemoved = s_SoundHDTableModel.remove(p_LiveShowSoundHD);
            if (boolRemoved) {
                p_LiveShowSoundHD.removeLiveShowSoundHDListener(s_SingleInstance);
            }
        }
        return boolRemoved;
    }

    public static LiveShowSoundHDView getLiveShowSoundHDView() {
        return s_LiveShowSoundHDView;
    }

    @Override
    public void eventHDNoMixerFound(LiveShowSoundHD p_LiveShowSoundHD, AudioFormat p_AudioFormat) {
    }

    @Override
    public void eventHDInvalidSoundFile(LiveShowSoundHD p_LiveShowSoundHD, File p_SoundFile) {
    }

    @Override
    public void eventHDOpened(LiveShowSoundHD p_LiveShowSoundHD, File p_SoundFile, long p_SectionStart, long p_SectionEnd) {
    }

    @Override
    public void eventHDClosing(LiveShowSoundHD p_LiveShowSoundHD) {
        LiveShowSoundSystem.removeLiveShowSoundHD(p_LiveShowSoundHD);
    }

    public static File searchLostSoundFile(File p_File) {
        File o_SelectedFile = null;
        if (p_File == null) {
            return null;
        }
        if (s_FIleNotFoundCancelAll) {
            return null;
        }
        Object[] options = new Object[]{FILENOTFOUND_BUTTON_SEARCH, FILENOTFOUND_BUTTON_DISCARD, FILENOTFOUND_BUTTON_DISCARDALL};
        StringBuffer stringBufferRemark = new StringBuffer();
        stringBufferRemark.append("<html>");
        stringBufferRemark.append("<b>");
        stringBufferRemark.append("<center>");
        stringBufferRemark.append(p_File.getName());
        stringBufferRemark.append("</center>");
        stringBufferRemark.append("</b>");
        stringBufferRemark.append("<br>");
        stringBufferRemark.append(FILENOTFOUND_REMARK);
        stringBufferRemark.append("</html>");
        int intResult = JOptionDialog.showOptionDialog(null, stringBufferRemark.toString(), p_File.getName() + " " + FILENOTFOUND_TITEL, 1, -1, null, options, options[0]);
        switch (intResult) {
            case 0: {
                break;
            }
            case 1: {
                return null;
            }
            case 2: {
                s_FIleNotFoundCancelAll = true;
                return null;
            }
        }
        if (p_File.getParentFile() == null && s_LastOpenFilePath != null) {
            p_File = new File(s_LastOpenFilePath.getAbsolutePath() + File.separator + p_File.getName());
        }
        if ((o_SelectedFile = LiveShowSoundSystem.loadSoundFile(p_File.getName() + " " + FILENOTFOUND_TITEL, p_File.getParentFile())) != null) {
            if (o_SelectedFile.isDirectory()) {
                o_SelectedFile = null;
            } else {
                s_LastOpenFilePath = o_SelectedFile.getParentFile();
            }
        }
        return o_SelectedFile;
    }

    public static File loadSoundFile(String p_Title, File p_LastDirectory) {
        if (p_LastDirectory == null) {
            p_LastDirectory = s_LastOpenFilePath;
        }
        return FileSelection.showOpen(null, (String)p_Title, (File)p_LastDirectory, (FileNameExtensionFilter)FILENAME_FILTER_SOUND, (boolean)true, (boolean)false, null, (FileNameExtensionFilter)FILENAME_FILTER_SOUND, null, null);
    }

    public static File getLastOpenedFilePath() {
        return s_LastOpenFilePath;
    }

    public static void setLastOpenedFilePath(File p_File) {
        if (p_File == null) {
            if (s_LastOpenFilePath == null) {
                return;
            }
        } else {
            if (!p_File.isDirectory()) {
                p_File = p_File.getParentFile();
            }
            if (p_File.equals(s_LastOpenFilePath)) {
                return;
            }
        }
        s_LastOpenFilePath = p_File;
        PlaySound.writeIni();
    }

    public static void setLiveShowSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP) {
        s_LiveShowSoundVIP = p_LiveShowSoundVIP;
    }

    public static void removeLiveShowSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP) {
        if (s_LiveShowSoundVIP != p_LiveShowSoundVIP) {
            return;
        }
        s_LiveShowSoundVIP = null;
    }

    public static LiveShowSoundVIP getLiveShowSoundVIP() {
        return s_LiveShowSoundVIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportedFileList_Clear() {
        Object object = s_SyncExport;
        synchronized (object) {
            s_ExportedFiles.clear();
            s_ExportedFileCheckSums.clear();
            s_ExportedReplacement.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Add(File p_File) {
        if (p_File == null) {
            return false;
        }
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex >= 0) {
                s_ExportedFileCheckSums.set(intIndex, FileTools.getCheckSum_MD5_Partial((File)p_File));
                return false;
            }
            s_ExportedFiles.add(p_File);
            s_ExportedFileCheckSums.add(FileTools.getCheckSum_MD5_Partial((File)p_File));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Remove(File p_File) {
        if (p_File == null) {
            return false;
        }
        File o_FileRemoved = null;
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex >= 0) {
                try {
                    o_FileRemoved = s_ExportedFiles.remove(intIndex);
                    s_ExportedFileCheckSums.remove(intIndex);
                }
                catch (Exception e) {
                    if (o_FileRemoved != null) {
                        // empty if block
                    }
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportedFileList_Contains(File p_File) {
        if (p_File == null) {
            return false;
        }
        Object object = s_SyncExport;
        synchronized (object) {
            return s_ExportedFiles.contains(p_File);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exported_FileList_CheckSum(File p_File) {
        if (p_File == null) {
            return "";
        }
        Object object = s_SyncExport;
        synchronized (object) {
            int intIndex = s_ExportedFiles.indexOf(p_File);
            if (intIndex < 0) {
                return "";
            }
            try {
                return s_ExportedFileCheckSums.get(intIndex);
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public static boolean exportLiveShowSoundObject(ObjectOutput out, LiveShowSoundObject p_LiveShowSoundObject, LiveShowProjectDescription p_LiveShowProjectDescription) throws IOException {
        if (p_LiveShowSoundObject == null) {
            return false;
        }
        File o_SoundFile = null;
        String o_StringReplacement = null;
        boolean boolSuccess = true;
        LiveShowSoundHD o_LiveShowSoundHD = p_LiveShowSoundObject.getLiveShowSoundHD();
        if (o_LiveShowSoundHD != null) {
            String stringNewPath = p_LiveShowProjectDescription.getProjectPath();
            o_SoundFile = o_LiveShowSoundHD.getSoundFile();
            if (o_SoundFile != null) {
                if (s_ExportedReplacement != null) {
                    o_StringReplacement = s_ExportedReplacement.get(o_SoundFile.getPath());
                }
                if (o_StringReplacement == null) {
                    String stringNewName;
                    o_StringReplacement = o_SoundFile.getName();
                    File o_NewDirectory = new File(stringNewPath + FILENAME_SOUNDDIRECTORY);
                    File o_ProblemFile = LiveShowSoundSystem.checkSoundFileNameDuplicated_save(o_SoundFile, o_LiveShowSoundHD.getAudioFormat(), o_NewDirectory);
                    if (o_ProblemFile != null && (stringNewName = LiveShowSoundSystem.showOptionPane_ReplaceFileDuplication(o_SoundFile, o_ProblemFile)) != null) {
                        File o_File = new File(stringNewName);
                        o_StringReplacement = o_File.getName();
                    }
                }
            }
        }
        if (o_SoundFile != null && (boolSuccess = p_LiveShowSoundObject.exportExternal(out, p_LiveShowProjectDescription, o_StringReplacement)) && s_ExportedReplacement != null) {
            s_ExportedReplacement.put(o_SoundFile.getPath(), o_StringReplacement);
        }
        return boolSuccess;
    }

    public static void setControlGroupActive(ControlGroup p_ControlGroup) {
        s_ControlGroup_Active = p_ControlGroup;
    }

    public static ControlGroup getControlGroupActive() {
        return s_ControlGroup_Active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlayPrefetchBuffer getPlayBuffer() {
        PlayPrefetchBuffer o_PlayBuffer;
        Object object = s_SyncPlayBuffer;
        synchronized (object) {
            if (s_PlayBuffersReleased.size() <= 0) {
                o_PlayBuffer = new PlayPrefetchBuffer();
            } else {
                o_PlayBuffer = s_PlayBuffersReleased.get(0);
                s_PlayBuffersReleased.remove(0);
            }
        }
        return o_PlayBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasePlayBuffer(PlayPrefetchBuffer p_PlayBuffer) {
        if (p_PlayBuffer == null) {
            return;
        }
        p_PlayBuffer.release();
        Object object = s_SyncPlayBuffer;
        synchronized (object) {
            if (s_PlayBuffersReleased.contains(p_PlayBuffer)) {
                return;
            }
            s_PlayBuffersReleased.add(p_PlayBuffer);
        }
    }

    public static void setLiveShowSoundMixersInternalFrame(LiveShowSoundMixersInternalFrame p_InternalFrame) {
        s_LiveShowSoundMixersInternalFrame = p_InternalFrame;
    }

    public static void setJingleCreator(LiveShowJingle.JingleCreatorInterface p_JingleCreatorInterface) {
        s_JingleCreatorInterface = p_JingleCreatorInterface;
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectDescription);
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectInterface);
    }

    public static void setJingleContainer(LiveShowJingle.JingleContainerInterface p_JingleContainerInterface) {
        s_JingleContainerInterface = p_JingleContainerInterface;
    }

    public static LiveShowJingle.JingleContainerInterface getJingleContainerInterface() {
        return s_JingleContainerInterface;
    }

    public static int getJingleObjectCount() {
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return 0;
        }
        return o_JingleContainerInterface.getJingleViewCount();
    }

    public static LiveShowSoundObject getJingleObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(p_Index);
        if (o_JingleInterface == null) {
            return null;
        }
        return (LiveShowSoundObject)o_JingleInterface.getLiveShowObject();
    }

    public static LiveShowObjectInterface getJingleObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        for (int intObject = 0; intObject < o_JingleContainerInterface.getJingleViewCount(); ++intObject) {
            LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(intObject);
            LiveShowObject o_LiveShowObjectInterface = o_JingleInterface.getLiveShowObject();
            if (o_LiveShowObjectInterface == null || !p_ID.equals(o_LiveShowObjectInterface.getID())) continue;
            return o_LiveShowObjectInterface;
        }
        return null;
    }

    public static void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        s_HelpFocusListener = p_HelpFocusListener;
    }

    public static WindowFocusListener getHelpFocusListener() {
        return s_HelpFocusListener;
    }

    static {
        FILENOTFOUND_TITEL = "not found - search new position";
        FILENOTFOUND_REMARK = "<html>not found!<br>You can: <br>search for the file not found<br>or discard all media objects that use this file<br>or discard all media objects whose media file is not found.</html>";
        FILENOTFOUND_BUTTON_SEARCH = "search";
        FILENOTFOUND_BUTTON_DISCARD = "discard";
        FILENOTFOUND_BUTTON_DISCARDALL = "discard all";
        s_FIleNotFoundCancelAll = false;
        SOUNDFILEERROR_REMARK = "<html>The soundfile could not be opened or converted.<br>Either the file is cor</html>";
        FILENOTWRITEPERMISSION_TITEL = "No write permission: ";
        FILENOTWRITEPERMISSION_REASON = "You want to load the soundfile from a location with no write permission.";
        FILENOTWRITEPERMISSION_EFFECT = "No graphics can be calculated and saved by the software.";
        FILENOTWRITEPERMISSION_REMARK = "It's better to copy the file to another location with write permissions and load it from there!";
        FILENOTWRITEPERMISSION_QUESTION = "Do you want to load the file nevertheless?";
        FILEDUPLICATION_TITEL = "Soundfile names duplicated";
        FILEDUPLICATION_REASON = "The sound-files will have identically names.";
        FILEDUPLICATION_EFFECT = "This may occur problems when the soundfiles will be exported!";
        FILEDUPLICATION_REMARK = "You should first rename the file and then load it again!";
        FILEDUPLICATIONSAMECONTENT_TITEL = "Soundfile already exists";
        FILEDUPLICATIONSAMECONTENT_REASON = "The sound-files have identically names but different location.";
        FILEDUPLICATIONSAMECONTENT_EFFECT = "Problems occurs when files with the same name but different content are used.";
        FILEDUPLICATIONSAMECONTENT_REMARK = "The contents of the files seems to be equal!";
        FILEDUPLICATIONSAMECONTENT_QUESTION = "Do you want to load the existing file instead?";
        FILEREPLACEMENT_REASON = "The sound-files have identically names.";
        FILEREPLACEMENT_EFFECT = "If You don't change the name the files will be overwritten!";
        FILEREPLACEMENT_REMARK = "The following file should be renamed, except you are shure that the contents are identically!";
        FILEREPLACEMENT_QUESTION = "Enter a new name:";
        ERROR_NOMIXERFOUND = "No matching mixer was found!";
        LOAD_SOUNDFILE = "Load Soundfile";
        s_SoundHDTableModel = LiveShowSoundHD.s_SoundHDTableModel;
        s_LiveShowSoundHDView = new LiveShowSoundHDView();
        s_JingleObjects = new ArrayList();
        s_SyncJingles = new Object();
        s_PlayBuffersReleased = new ArrayList();
        s_SingleInstance = new LiveShowSoundSystem();
        s_SyncVIP = new Object();
        s_SyncHD = new Object();
        s_SyncPlayBuffer = new Object();
        s_ThreadFillPlayBuffer = new PlayBufferThread();
        s_PlaySounds = new ArrayList();
        s_SyncExport = new Object();
        s_ExportedFiles = new ArrayList();
        s_ExportedFileCheckSums = new ArrayList();
        s_ExportedReplacement = new HashMap();
        s_LastOpenFilePath = null;
        s_ControlGroup_Active = null;
        s_JarResources_Default = new JarResources(LiveShowSoundSystem.getFolderStyles() + File.separator + "LiveShowControls_Black.jar");
        s_JingleCreatorInterface = null;
        s_JingleContainerInterface = null;
    }

    public static class PlayBufferThread {
        private ArrayList<Runnable> m_Runnables;
        private Thread m_HandlerThread;
        private boolean m_HandlerStop = false;
        private final Object m_SyncRunnables = new Object();
        private final Object m_SyncThread = new Object();
        private Runnable m_Runnable_handleInvokeLater;

        public PlayBufferThread() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_Runnables = new ArrayList(2);
            this.m_Runnable_handleInvokeLater = new Runnable(){

                @Override
                public void run() {
                    this.handleInvokeLater();
                }
            };
            this.invokeLater(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncThread;
            synchronized (object) {
                this.m_HandlerStop = true;
                Object object2 = this.m_SyncRunnables;
                synchronized (object2) {
                    this.m_SyncRunnables.notifyAll();
                }
                Thread o_HandlerThread = this.m_HandlerThread;
                try {
                    if (o_HandlerThread != null) {
                        o_HandlerThread.join(500L);
                        this.m_HandlerThread = null;
                    }
                }
                catch (Exception e) {
                    this.m_HandlerThread = null;
                }
                this.clearRunnables();
                s_ThreadFillPlayBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearRunnables() {
            Object object = this.m_SyncRunnables;
            synchronized (object) {
                this.m_Runnables.clear();
                this.m_SyncRunnables.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeLater(Runnable p_Runnable) {
            Object object = this.m_SyncThread;
            synchronized (object) {
                if (this.m_HandlerThread == null) {
                    this.m_HandlerThread = new Thread(this.m_Runnable_handleInvokeLater, this.getClass().getSimpleName());
                    try {
                        this.m_HandlerThread.setPriority(5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_HandlerStop = false;
                    this.m_HandlerThread.start();
                }
            }
            if (p_Runnable == null) {
                return;
            }
            object = this.m_SyncRunnables;
            synchronized (object) {
                if (this.m_Runnables.contains(p_Runnable)) {
                    return;
                }
                this.m_Runnables.add(p_Runnable);
                this.m_SyncRunnables.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInvokeLater() {
            Object object;
            while (!this.m_HandlerStop) {
                Runnable o_Runnable;
                object = this.m_SyncRunnables;
                synchronized (object) {
                    if (this.m_Runnables.size() <= 0) {
                        o_Runnable = null;
                        try {
                            this.m_SyncRunnables.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.m_Runnables.size() > 0) {
                            o_Runnable = this.m_Runnables.get(0);
                            this.m_Runnables.remove(0);
                        }
                    } else {
                        o_Runnable = this.m_Runnables.get(0);
                        this.m_Runnables.remove(0);
                    }
                }
                if (o_Runnable == null) continue;
                try {
                    o_Runnable.run();
                }
                catch (Exception e_Run) {
                    if (!DEBUG_ON) continue;
                    System.out.println("LiveShowSoundSysrem FillBufferThread Error: " + e_Run.getMessage());
                    System.out.println(e_Run.getStackTrace());
                }
            }
            object = this.m_SyncThread;
            synchronized (object) {
                if (this.m_HandlerStop) {
                    this.m_HandlerThread = null;
                }
            }
        }

        public int getRunnableCount() {
            return this.m_Runnables.size();
        }
    }

    public static class PlayBufferRunnable
    implements Runnable {
        private PlayPrefetchBuffer m_PlayBuffer;

        public PlayBufferRunnable(PlayPrefetchBuffer p_PlayBuffer) {
            this.m_PlayBuffer = p_PlayBuffer;
        }

        @Override
        public void run() {
            this.m_PlayBuffer.fillBufferRun();
        }
    }

    public static class PlayPrefetchBuffer {
        private static final int PLAYBUFFER_FACTOR = 40;
        private static final int PLAYBUFFER_MILLISECONDS = PlaySound.BUFFER_MILLISECONDS * 40;
        private static double[] s_NullBytes = new double[(int)((double)SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate() * ((double)PLAYBUFFER_MILLISECONDS / 1000.0)) * 32];
        RandomAccessFile m_RandomAccessFile;
        FileInputStream m_FileInputStream;
        private boolean m_RandomAccessFileClosed;
        private LiveShowSoundObject m_LiveShowSoundObject;
        private AudioFormat m_AudioFormat;
        private long m_FileFirstDataByte;
        private long m_FileFramesCount;
        private long m_FileDataByteCount;
        private long m_FileUnusedBytesEOF;
        private DoubleBuffer m_PrefetchSampleBuffer;
        private int m_PrefetchBufferFramesCount;
        private int m_Read_FrameIndex;
        private long m_File_Read_FramePosition;
        private int m_Prefetch_FrameIndex;
        private long m_File_Prefetch_FramePosition;
        private boolean m_File_WillSet_FramePosition;
        private ByteBuffer m_ByteBufferFrame;
        private PlayBufferRunnable m_RunnableFill;
        private final Object m_SyncObject = new Object();
        private final Object m_SyncFile = new Object();
        private final Object m_SyncObject_Buffer = new Object();

        public PlayPrefetchBuffer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_LiveShowSoundObject = null;
            this.m_PrefetchBufferFramesCount = 0;
            this.m_File_Read_FramePosition = 0L;
            this.m_Read_FrameIndex = 0;
            this.m_File_WillSet_FramePosition = false;
            this.m_File_Prefetch_FramePosition = 0L;
            this.m_Prefetch_FrameIndex = 0;
            this.m_RandomAccessFileClosed = false;
            this.m_RandomAccessFile = null;
            this.m_FileInputStream = null;
            this.m_RunnableFill = new PlayBufferRunnable(this);
            this.m_FileFramesCount = 0L;
            this.m_FileFirstDataByte = 0L;
            this.m_FileDataByteCount = 0L;
            this.m_FileUnusedBytesEOF = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                Object object2 = this.m_SyncObject_Buffer;
                synchronized (object2) {
                    this.m_PrefetchSampleBuffer = null;
                    this.closeFile();
                    this.m_LiveShowSoundObject = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeFile() {
            Object object = this.m_SyncFile;
            synchronized (object) {
                try {
                    if (this.m_RandomAccessFile != null) {
                        this.m_FileInputStream.close();
                        this.m_RandomAccessFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_RandomAccessFile = null;
                this.m_FileInputStream = null;
                this.m_RandomAccessFileClosed = true;
            }
        }

        public void release() {
            this.closeFile();
            this.m_LiveShowSoundObject = null;
            this.m_PrefetchBufferFramesCount = 0;
            this.m_File_Read_FramePosition = 0L;
            this.m_Read_FrameIndex = 0;
            this.m_File_WillSet_FramePosition = false;
            this.m_File_Prefetch_FramePosition = 0L;
            this.m_Prefetch_FrameIndex = 0;
            this.m_RandomAccessFileClosed = true;
            this.m_RandomAccessFile = null;
            this.m_FileInputStream = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPlay(LiveShowSoundObject p_LiveShowSoundObject) {
            LiveShowSoundHD o_LiveShowSoundHD;
            if (p_LiveShowSoundObject == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_LiveShowSoundObject = p_LiveShowSoundObject;
                o_LiveShowSoundHD = this.m_LiveShowSoundObject.getLiveShowSoundHD();
                this.m_AudioFormat = this.m_LiveShowSoundObject.getAudioFormat();
                this.m_PrefetchBufferFramesCount = (int)((double)this.m_AudioFormat.getFrameRate() * ((double)PLAYBUFFER_MILLISECONDS / 1000.0));
                if (s_NullBytes.length < this.m_PrefetchBufferFramesCount * this.m_AudioFormat.getChannels()) {
                    s_NullBytes = new double[this.m_PrefetchBufferFramesCount * this.m_AudioFormat.getChannels()];
                    for (int intValue = 0; intValue < s_NullBytes.length; ++intValue) {
                        PlayPrefetchBuffer.s_NullBytes[intValue] = 0.0;
                    }
                }
                if (this.m_PrefetchSampleBuffer == null || this.m_PrefetchSampleBuffer.capacity() / this.m_AudioFormat.getChannels() < this.m_PrefetchBufferFramesCount) {
                    this.m_PrefetchSampleBuffer = DoubleBuffer.allocate(this.m_PrefetchBufferFramesCount * this.m_AudioFormat.getChannels());
                } else {
                    this.m_PrefetchBufferFramesCount = this.m_PrefetchSampleBuffer.capacity() / this.m_AudioFormat.getChannels();
                }
            }
            object = this.m_SyncFile;
            synchronized (object) {
                if (this.m_RandomAccessFile != null) {
                    try {
                        if (this.m_FileInputStream != null) {
                            this.m_FileInputStream.close();
                        }
                        this.m_RandomAccessFile.close();
                    }
                    catch (Exception intValue) {
                        // empty catch block
                    }
                }
                this.m_RandomAccessFile = null;
                this.m_FileInputStream = null;
                this.m_RandomAccessFileClosed = true;
                this.m_FileFirstDataByte = 0L;
                this.m_FileDataByteCount = 0L;
                this.m_FileUnusedBytesEOF = 0L;
                if (o_LiveShowSoundHD != null) {
                    File o_SoundFile = o_LiveShowSoundHD.getSoundFile();
                    if (o_SoundFile == null) {
                        if (DEBUG_ON) {
                            System.out.println("LiveShowSoundSystem initPlay Error: no SoundFile " + this.m_LiveShowSoundObject.getSourceName());
                        }
                        return;
                    }
                    try {
                        this.m_RandomAccessFile = new RandomAccessFile(o_SoundFile, "r");
                        this.m_FileFramesCount = o_LiveShowSoundHD.getFrameLength();
                        this.m_FileFirstDataByte = o_LiveShowSoundHD.getFirstDataBytePosition();
                        this.m_FileDataByteCount = this.m_FileFramesCount * (long)this.m_AudioFormat.getFrameSize();
                        this.m_FileUnusedBytesEOF = o_LiveShowSoundHD.getUnusedBytesEOF();
                        this.m_RandomAccessFileClosed = false;
                        this.m_FileInputStream = new FileInputStream(this.m_RandomAccessFile.getFD());
                    }
                    catch (Exception e) {
                        System.err.println("LiveShowSoundSystem PlayPrefetchBuffer initPlay Error: Open RandomAccessFile " + o_SoundFile.getPath());
                        if (this.m_RandomAccessFile != null) {
                            try {
                                if (this.m_FileInputStream != null) {
                                    this.m_FileInputStream.close();
                                }
                                this.m_RandomAccessFile.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.m_RandomAccessFile = null;
                        this.m_FileInputStream = null;
                        this.m_RandomAccessFileClosed = true;
                        return;
                    }
                }
            }
            object = this.m_SyncObject;
            synchronized (object) {
                int intByteBufferFrameCount = this.m_PrefetchBufferFramesCount / 40;
                if (this.m_ByteBufferFrame == null || this.m_ByteBufferFrame.capacity() != intByteBufferFrameCount * this.m_AudioFormat.getFrameSize()) {
                    this.m_ByteBufferFrame = ByteBuffer.allocate(intByteBufferFrameCount * this.m_AudioFormat.getFrameSize());
                }
                if (this.m_AudioFormat.isBigEndian()) {
                    this.m_ByteBufferFrame.order(ByteOrder.BIG_ENDIAN);
                } else {
                    this.m_ByteBufferFrame.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
            this.setPositionInsideObject_Frame(0L, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long readPlay(double[] p_SoundObjectChannelFrames, long p_FrameStartRead, long p_FramesToRead) throws IOException {
            if (p_SoundObjectChannelFrames == null) {
                return 0L;
            }
            long longFrames_Offset = 0L;
            long longFrames_ToRead = 0L;
            long longObjectInside_FrameStart = 0L;
            long longFramesTransferred = 0L;
            boolean boolFillBuffer = false;
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            DoubleBuffer o_PrefetchSampleBuffer = this.m_PrefetchSampleBuffer;
            if (o_LiveShowSoundObject == null || o_AudioFormat == null || o_AudioFormat.getFrameSize() <= 0 || o_PrefetchSampleBuffer == null) {
                for (int intChannelFrame = 0; intChannelFrame < p_SoundObjectChannelFrames.length; ++intChannelFrame) {
                    p_SoundObjectChannelFrames[intChannelFrame] = 0.0;
                }
                return 0L;
            }
            int intArrayFramesCount = p_SoundObjectChannelFrames.length / o_AudioFormat.getChannels();
            longFrames_ToRead = p_FramesToRead > (long)intArrayFramesCount ? (long)intArrayFramesCount : p_FramesToRead;
            if (p_FrameStartRead > o_LiveShowSoundObject.getFrameStart() + o_LiveShowSoundObject.getFrameLengthToPlay()) {
                return 0L;
            }
            if (p_FrameStartRead + longFrames_ToRead < o_LiveShowSoundObject.getFrameStart()) {
                return 0L;
            }
            if (p_FrameStartRead + longFrames_ToRead > o_LiveShowSoundObject.getFrameStart() + o_LiveShowSoundObject.getFrameLengthToPlay()) {
                longFrames_ToRead = o_LiveShowSoundObject.getFrameStart() + o_LiveShowSoundObject.getFrameLengthToPlay() - p_FrameStartRead;
            }
            if (p_FrameStartRead < o_LiveShowSoundObject.getFrameStart()) {
                longFrames_Offset = o_LiveShowSoundObject.getFrameStart() - p_FrameStartRead;
                longFrames_ToRead -= longFrames_Offset;
                longObjectInside_FrameStart = 0L;
            } else {
                longObjectInside_FrameStart = p_FrameStartRead - o_LiveShowSoundObject.getFrameStart();
            }
            if (longFrames_Offset >= p_FramesToRead) {
                longFrames_Offset = longFrames_ToRead;
                longFrames_ToRead = 0L;
            }
            if (longFrames_ToRead <= 0L) {
                return 0L;
            }
            long longFile_FramePosition = o_LiveShowSoundObject.getFrameStartOffset() + longObjectInside_FrameStart;
            int intDestArrayFrameIndex = 0;
            System.arraycopy(s_NullBytes, 0, p_SoundObjectChannelFrames, 0, p_SoundObjectChannelFrames.length);
            if (longFrames_Offset > 0L) {
                intDestArrayFrameIndex = (int)((long)intDestArrayFrameIndex + longFrames_Offset);
            }
            longFramesTransferred += (long)this.transferFrames(p_SoundObjectChannelFrames, intDestArrayFrameIndex, longFile_FramePosition, (int)longFrames_ToRead);
            Object object = this.m_SyncObject_Buffer;
            synchronized (object) {
                int intFramesFilled = (int)(this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition);
                if ((double)intFramesFilled <= (double)this.m_PrefetchBufferFramesCount * 0.4 && this.m_File_Prefetch_FramePosition < this.m_FileFramesCount) {
                    boolFillBuffer = true;
                }
            }
            if (boolFillBuffer) {
                s_ThreadFillPlayBuffer.invokeLater(this.m_RunnableFill);
            }
            if (DEBUG_ON && longFrames_Offset + longFramesTransferred != p_FramesToRead) {
                System.out.println("    -> LiveShowSoundSystem readPlay Frames to read : " + p_FramesToRead + " readen: " + (longFrames_Offset + longFramesTransferred) + " m_File_Read_FramePosition: " + this.m_File_Read_FramePosition + " " + o_LiveShowSoundObject.getSourceName());
            }
            return longFrames_Offset + longFramesTransferred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int transferFrames(double[] p_SoundObjectChannelFrames, int p_ArrayFrameOffset, long p_File_Read_FramePosition, int p_FramesToTransfer) {
            int intFramesToReadSecond;
            int intFramesToReadFirst;
            if (p_SoundObjectChannelFrames == null) {
                return 0;
            }
            if (p_ArrayFrameOffset < 0) {
                return 0;
            }
            if (p_FramesToTransfer <= 0) {
                return 0;
            }
            int intFramesToTransfer = 0;
            long longFramesFilled = 0L;
            DoubleBuffer o_PrefetchSampleBuffer = this.m_PrefetchSampleBuffer;
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            if (o_PrefetchSampleBuffer == null || o_LiveShowSoundObject == null || o_AudioFormat == null) {
                return 0;
            }
            int intArrayFramesCount = p_SoundObjectChannelFrames.length / this.m_AudioFormat.getChannels();
            if (p_ArrayFrameOffset >= intArrayFramesCount) {
                return 0;
            }
            intFramesToTransfer = p_ArrayFrameOffset + p_FramesToTransfer > intArrayFramesCount ? intArrayFramesCount - p_ArrayFrameOffset : p_FramesToTransfer;
            if (intFramesToTransfer <= 0) {
                return 0;
            }
            Object object = this.m_SyncObject_Buffer;
            synchronized (object) {
                longFramesFilled = this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition;
                long longStartFramesDiff = p_File_Read_FramePosition - this.m_File_Read_FramePosition;
                if (longStartFramesDiff < 0L) {
                    if (DEBUG_ON) {
                        System.out.println("   LiveShowSoundSystem <- Jumped back longStartFramesDiff: " + longStartFramesDiff + " will set position    " + o_LiveShowSoundObject.getSourceName());
                    }
                    this.setPosition_Frame(p_File_Read_FramePosition, false);
                    return 0;
                }
                if (longStartFramesDiff > 0L) {
                    boolean boolSetPosition = false;
                    if (this.m_File_WillSet_FramePosition) {
                        if (p_File_Read_FramePosition + (long)p_FramesToTransfer > this.m_File_Prefetch_FramePosition + (long)this.m_PrefetchBufferFramesCount) {
                            boolSetPosition = true;
                        }
                    } else if (p_File_Read_FramePosition + (long)p_FramesToTransfer > this.m_File_Prefetch_FramePosition) {
                        boolSetPosition = true;
                    }
                    if (boolSetPosition) {
                        if (DEBUG_ON) {
                            System.out.println("   LiveShowSoundSystem -> Jumped forward longStartFramesDiff: " + longStartFramesDiff + " will set position    " + o_LiveShowSoundObject.getSourceName());
                        }
                        this.setPosition_Frame(p_File_Read_FramePosition, false);
                        return 0;
                    }
                    if (DEBUG_ON) {
                        System.out.println("   LiveShowSoundSystem -> Jumped forward longStartFramesDiff: " + longStartFramesDiff + " inside the buffered frames    " + o_LiveShowSoundObject.getSourceName());
                    }
                    this.m_File_Read_FramePosition = p_File_Read_FramePosition;
                    longFramesFilled = this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition;
                    if (longFramesFilled < 0L) {
                        longFramesFilled = 0L;
                    }
                    this.m_Read_FrameIndex = (int)((long)this.m_Read_FrameIndex + longStartFramesDiff);
                    if (this.m_Read_FrameIndex > this.m_PrefetchBufferFramesCount) {
                        this.m_Read_FrameIndex -= this.m_PrefetchBufferFramesCount;
                    }
                }
                if ((long)intFramesToTransfer > longFramesFilled) {
                    intFramesToTransfer = (int)longFramesFilled;
                }
                if (intFramesToTransfer <= 0) {
                    return 0;
                }
                double[] o_PrefetchSampleBufferArray = o_PrefetchSampleBuffer.array();
                if (o_PrefetchSampleBufferArray == null) {
                    return 0;
                }
                int intChannels = o_AudioFormat.getChannels();
                if (this.m_Read_FrameIndex + intFramesToTransfer > this.m_PrefetchBufferFramesCount) {
                    intFramesToReadFirst = this.m_PrefetchBufferFramesCount - this.m_Read_FrameIndex;
                    intFramesToReadSecond = intFramesToTransfer - intFramesToReadFirst;
                } else {
                    intFramesToReadFirst = intFramesToTransfer;
                    intFramesToReadSecond = 0;
                }
                int intRead_FrameIndex = this.m_Read_FrameIndex;
                if (intFramesToReadFirst > 0) {
                    try {
                        System.arraycopy(o_PrefetchSampleBufferArray, intRead_FrameIndex * intChannels, p_SoundObjectChannelFrames, p_ArrayFrameOffset * intChannels, intFramesToReadFirst * intChannels);
                    }
                    catch (Exception e) {
                        intFramesToReadFirst = 0;
                    }
                    p_ArrayFrameOffset += intFramesToReadFirst;
                    intRead_FrameIndex += intFramesToReadFirst;
                }
                if (intFramesToReadSecond > 0) {
                    intRead_FrameIndex = 0;
                    try {
                        System.arraycopy(o_PrefetchSampleBufferArray, intRead_FrameIndex * intChannels, p_SoundObjectChannelFrames, p_ArrayFrameOffset * intChannels, intFramesToReadSecond * intChannels);
                    }
                    catch (Exception e) {
                        intFramesToReadFirst = 0;
                    }
                    p_ArrayFrameOffset += intFramesToReadSecond;
                    intRead_FrameIndex += intFramesToReadSecond;
                }
                this.m_Read_FrameIndex = intRead_FrameIndex;
                this.m_File_Read_FramePosition += (long)(intFramesToReadFirst + intFramesToReadSecond);
            }
            return intFramesToReadFirst + intFramesToReadSecond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition_Frame(long p_FramePosition, boolean p_Immediately) {
            boolean boolFillBuffer = false;
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            DoubleBuffer o_PrefetchSampleBuffer = this.m_PrefetchSampleBuffer;
            if (o_LiveShowSoundObject == null || o_AudioFormat == null || o_PrefetchSampleBuffer == null) {
                return;
            }
            if (p_FramePosition < 0L) {
                p_FramePosition = 0L;
            }
            if (p_FramePosition > o_LiveShowSoundObject.getFrameStartOffset() + o_LiveShowSoundObject.getFrameLength()) {
                if (DEBUG_ON) {
                    System.out.println("LiveShowSoundSystem PlayPrefetchBuffer setPosition_Frame p_FramePosition " + p_FramePosition + " greater than Object startoffset+length" + this.m_LiveShowSoundObject.getSourceName());
                }
                p_FramePosition = 0L;
            }
            Object object = this.m_SyncObject_Buffer;
            synchronized (object) {
                if (DEBUG_ON) {
                    System.out.println("LiveShowSoundSystem PlayPrefetchBuffer setPosition_Frame p_FramePosition: " + p_FramePosition + " " + this.m_LiveShowSoundObject.getSourceName());
                }
                this.m_File_Prefetch_FramePosition = p_FramePosition;
                this.m_Prefetch_FrameIndex = 0;
                this.m_File_WillSet_FramePosition = true;
                this.m_File_Read_FramePosition = p_FramePosition;
                this.m_Read_FrameIndex = 0;
                boolFillBuffer = true;
            }
            if (boolFillBuffer) {
                if (p_Immediately) {
                    this.fillBufferRun();
                } else {
                    s_ThreadFillPlayBuffer.invokeLater(this.m_RunnableFill);
                }
            }
        }

        public void setPositionInsideObject_Frame(long p_FramePositionInside, boolean p_Immediately) {
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            if (o_LiveShowSoundObject == null || o_AudioFormat == null) {
                return;
            }
            if (p_FramePositionInside < 0L) {
                p_FramePositionInside = 0L;
            }
            if (p_FramePositionInside > o_LiveShowSoundObject.getFrameLength()) {
                p_FramePositionInside = o_LiveShowSoundObject.getFrameLength();
            }
            long longPrefetch_FileFramePosition = o_LiveShowSoundObject.getFrameStartOffset() + p_FramePositionInside;
            this.setPosition_Frame(longPrefetch_FileFramePosition, p_Immediately);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBufferRun() {
            int intPrefetch_FrameIndex;
            int intFetchFramesSecond;
            int intFetchFramesFirst;
            int intFramesToFill = 0;
            boolean boolFileEnd = false;
            int intFrames = 0;
            int intFramesReaden = 0;
            DoubleBuffer o_PrefetchSampleBuffer = this.m_PrefetchSampleBuffer;
            if (o_PrefetchSampleBuffer == null) {
                return;
            }
            long longFile_Prefetch_FramePosition = this.m_File_Prefetch_FramePosition;
            Exception o_Exception = this.seek(longFile_Prefetch_FramePosition);
            if (o_Exception != null) {
                System.err.println("LiveShowSoundSystem fillBufferRun() seek Error " + o_Exception.getStackTrace());
                return;
            }
            Object object = this.m_SyncObject_Buffer;
            synchronized (object) {
                int intFramesFilled = (int)(this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition);
                intFramesToFill = intFramesFilled <= 0 ? this.m_PrefetchBufferFramesCount : this.m_PrefetchBufferFramesCount - intFramesFilled;
                if (intFramesToFill > this.m_PrefetchBufferFramesCount) {
                    intFramesToFill = this.m_PrefetchBufferFramesCount;
                }
                if (longFile_Prefetch_FramePosition + (long)intFramesToFill > this.m_FileFramesCount) {
                    intFramesToFill = (int)(this.m_FileFramesCount - longFile_Prefetch_FramePosition);
                }
                if (intFramesToFill <= 0) {
                    if (DEBUG_ON) {
                        System.out.println("LiveShowSoundSystem fillBufferRun <= 0 Bytes to fetch, filled: " + (this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition) + " " + this.m_LiveShowSoundObject.getSourceName());
                    }
                    return;
                }
                intFetchFramesFirst = intFramesToFill;
                intFetchFramesSecond = 0;
                if (this.m_Prefetch_FrameIndex + intFetchFramesFirst > this.m_PrefetchBufferFramesCount) {
                    intFetchFramesFirst = this.m_PrefetchBufferFramesCount - this.m_Prefetch_FrameIndex;
                    intFetchFramesSecond = intFramesToFill - intFetchFramesFirst;
                }
                intPrefetch_FrameIndex = this.m_Prefetch_FrameIndex;
                if (DEBUG_ON) {
                    System.out.println("            LivehowSoundSystem PrefetchBuffer prefetch m_File_Prefetch_FramePosition: " + this.m_File_Prefetch_FramePosition + " p_FramesToFill: " + (intFetchFramesFirst + intFetchFramesSecond) + " FramesFilled: " + (this.m_File_Prefetch_FramePosition - this.m_File_Read_FramePosition) + " " + this.m_LiveShowSoundObject.getSourceName());
                }
            }
            try {
                if (intFetchFramesFirst > 0) {
                    intFrames = this.prefetch(o_PrefetchSampleBuffer.array(), intPrefetch_FrameIndex, intFetchFramesFirst);
                    if (intFrames < 0) {
                        intFrames = 0;
                    }
                    intPrefetch_FrameIndex = intPrefetch_FrameIndex + intFrames >= this.m_PrefetchBufferFramesCount ? intPrefetch_FrameIndex + intFrames - this.m_PrefetchBufferFramesCount : (intPrefetch_FrameIndex += intFrames);
                    intFramesReaden += intFrames;
                }
                if (intFetchFramesSecond > 0) {
                    intFrames = this.prefetch(o_PrefetchSampleBuffer.array(), intPrefetch_FrameIndex, intFetchFramesSecond);
                    if (intFrames < 0) {
                        intFrames = 0;
                    }
                    intPrefetch_FrameIndex = intPrefetch_FrameIndex + intFrames >= this.m_PrefetchBufferFramesCount ? intPrefetch_FrameIndex + intFrames - this.m_PrefetchBufferFramesCount : (intPrefetch_FrameIndex += intFrames);
                    intFramesReaden += intFrames;
                }
            }
            catch (Exception e) {
                System.err.println("LiveShowSoundSystem fillBufferRun() Exception: " + e.getStackTrace());
                intPrefetch_FrameIndex = this.m_Prefetch_FrameIndex;
                intFramesReaden = 0;
            }
            object = this.m_SyncObject_Buffer;
            synchronized (object) {
                if (longFile_Prefetch_FramePosition == this.m_File_Prefetch_FramePosition) {
                    if (DEBUG_ON) {
                        System.out.println("            LivehowSoundSystem PrefetchBuffer prefetch END m_File_Prefetch_FramePosition: " + this.m_File_Prefetch_FramePosition + " intFramesReaden: " + intFramesReaden + " " + this.m_LiveShowSoundObject.getSourceName());
                    }
                    this.m_Prefetch_FrameIndex = intPrefetch_FrameIndex;
                    this.m_File_Prefetch_FramePosition += (long)intFramesReaden;
                    this.m_File_WillSet_FramePosition = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Exception seek(long p_FramePosition) {
            long longRandomAccessFilePosition = this.m_FileFirstDataByte + p_FramePosition * (long)this.m_AudioFormat.getFrameSize();
            Object object = this.m_SyncFile;
            synchronized (object) {
                RandomAccessFile o_RandomAccessFile = this.m_RandomAccessFile;
                if (o_RandomAccessFile == null) {
                    return new Exception("LiveShowSoundSystem No SoundFile");
                }
                if (this.m_RandomAccessFileClosed) {
                    return new Exception("LiveShowSoundSystem SoundFile closed");
                }
                try {
                    if (o_RandomAccessFile.getFilePointer() == longRandomAccessFilePosition) {
                        return null;
                    }
                }
                catch (Exception e) {
                    return e;
                }
                try {
                    o_RandomAccessFile.seek(longRandomAccessFilePosition);
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int prefetch(double[] p_PrefetchBufferArray, int p_Prefetch_FrameIndex, int p_FramesToFill) throws IOException {
            if (p_PrefetchBufferArray == null) {
                return -1;
            }
            FileInputStream o_FileInputStream = null;
            o_FileInputStream = this.m_FileInputStream;
            LiveShowSoundObject o_LiveShowSoundObject = this.m_LiveShowSoundObject;
            AudioFormat o_AudioFormat = this.m_AudioFormat;
            if (o_FileInputStream == null || o_LiveShowSoundObject == null || o_AudioFormat == null || this.m_RandomAccessFileClosed) {
                return -1;
            }
            int intPrefetchFrameIndex = p_Prefetch_FrameIndex;
            int intBytesReaden = 0;
            int intFramesReaden = 0;
            int intChannels = o_AudioFormat.getChannels();
            int intFramesToRead = 0;
            try {
                int intByteBufferFrameCount = this.m_ByteBufferFrame.capacity() / o_AudioFormat.getFrameSize();
                this.m_ByteBufferFrame.position(this.m_ByteBufferFrame.capacity());
                int intPrefetchSampleIndexChannels = p_Prefetch_FrameIndex * intChannels;
                for (int intFrame = 0; intFrame < p_FramesToFill; ++intFrame) {
                    if (intPrefetchFrameIndex >= this.m_PrefetchBufferFramesCount) {
                        intPrefetchFrameIndex = 0;
                    }
                    if (this.m_ByteBufferFrame.position() >= this.m_ByteBufferFrame.capacity()) {
                        intFramesToRead = p_FramesToFill - intFrame;
                        if (intFramesToRead > intByteBufferFrameCount) {
                            intFramesToRead = intByteBufferFrameCount;
                        }
                        int intBytesToRead = intFramesToRead * o_AudioFormat.getFrameSize();
                        intBytesReaden = 0;
                        for (int intBytePosition = 0; intBytePosition < intBytesToRead && intBytesReaden >= 0; intBytePosition += intBytesReaden) {
                            Object object = this.m_SyncFile;
                            synchronized (object) {
                                if (this.m_RandomAccessFileClosed) {
                                    intBytesReaden = -1;
                                    break;
                                }
                                try {
                                    intBytesReaden = o_FileInputStream.read(this.m_ByteBufferFrame.array(), intBytePosition, intBytesToRead - intBytePosition);
                                    if (intBytesReaden <= 0) {
                                        int intFramesRest = intBytePosition / o_AudioFormat.getFrameSize();
                                        p_FramesToFill = intFrame + intFramesRest;
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    intBytesReaden = -1;
                                    e.printStackTrace();
                                    break;
                                }
                            }
                        }
                        if (intBytesReaden <= 0) break;
                        this.m_ByteBufferFrame.position(0);
                    }
                    for (int intChannel = 0; intChannel < intChannels; ++intChannel) {
                        double doubleSampleValue = 0.0;
                        if (o_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                            try {
                                switch (o_AudioFormat.getSampleSizeInBits()) {
                                    case 8: {
                                        doubleSampleValue = (double)this.m_ByteBufferFrame.get() / 256.0;
                                        break;
                                    }
                                    case 16: {
                                        short shortSampleValue = this.m_ByteBufferFrame.getShort();
                                        doubleSampleValue = (double)shortSampleValue / 32768.0;
                                        break;
                                    }
                                    case 24: {
                                        int intSampleValue;
                                        byte byteSampleValue;
                                        if (o_AudioFormat.isBigEndian()) {
                                            byteSampleValue = this.m_ByteBufferFrame.get();
                                            intSampleValue = (byteSampleValue & 0xFF) << 24;
                                            byteSampleValue = this.m_ByteBufferFrame.get();
                                            intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                            byteSampleValue = this.m_ByteBufferFrame.get();
                                            doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 8) / 2.147483648E9;
                                            break;
                                        }
                                        byteSampleValue = this.m_ByteBufferFrame.get();
                                        intSampleValue = (byteSampleValue & 0xFF) << 8;
                                        byteSampleValue = this.m_ByteBufferFrame.get();
                                        intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                        byteSampleValue = this.m_ByteBufferFrame.get();
                                        doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 24) / 2.147483648E9;
                                        break;
                                    }
                                    case 32: {
                                        doubleSampleValue = (double)this.m_ByteBufferFrame.getInt() / 2.147483648E9;
                                        break;
                                    }
                                    case 64: {
                                        doubleSampleValue = (double)this.m_ByteBufferFrame.getLong() / 9.223372036854776E18;
                                    }
                                }
                            }
                            catch (Exception e) {
                                boolean bl = false;
                            }
                        } else {
                            doubleSampleValue = o_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED ? 0.0 : 0.0;
                        }
                        p_PrefetchBufferArray[intPrefetchSampleIndexChannels] = doubleSampleValue;
                        ++intPrefetchSampleIndexChannels;
                    }
                    if (intBytesReaden >= 0) {
                        ++intPrefetchFrameIndex;
                        ++intFramesReaden;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            return intFramesReaden;
        }
    }
}

