/*
 * Decompiled with CFR 0.152.
 */
package SoundTools;

import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.sound.sampled.AudioFormat;

public class LiveShowWaveHeader {
    public static Charset CHARSET_DATA = Charset.forName("ISO-8859-15");
    public static int WAVEFILE_CANONICALHEADER_LENGTH = 44;
    private int m_FirstDataBytePosition;
    private int m_FormatID;
    private int m_Channels;
    private int m_SampleRate;
    private int m_BitsPerSample;
    private int m_ByteRate;
    private int m_BlockAlign;
    private long m_DataBytesLength;
    private long m_FrameLength;
    private long m_UnusedBytesEOF;
    private String m_Info_Title;
    private String m_Info_Artist;
    private String m_Info_Product;

    public LiveShowWaveHeader() {
        this.initMembers();
    }

    public LiveShowWaveHeader(int p_Channels, int p_SampleRate, int p_BitsPerSample, int p_DataLength) {
        this.initMembers();
        this.m_Channels = p_Channels;
        this.m_SampleRate = p_SampleRate;
        this.m_BitsPerSample = p_BitsPerSample;
        this.m_DataBytesLength = p_DataLength;
        this.calculateProperties();
        this.m_FirstDataBytePosition = WAVEFILE_CANONICALHEADER_LENGTH;
    }

    public LiveShowWaveHeader(AudioFormat p_AudioFormat, int p_DataLength) {
        this.initMembers();
        this.m_Channels = p_AudioFormat.getChannels();
        this.m_SampleRate = (int)p_AudioFormat.getSampleRate();
        this.m_BitsPerSample = p_AudioFormat.getSampleSizeInBits();
        this.m_DataBytesLength = p_DataLength;
        this.calculateProperties();
        this.m_FirstDataBytePosition = WAVEFILE_CANONICALHEADER_LENGTH;
    }

    private void initMembers() {
        this.m_FormatID = -1;
        this.m_Channels = -1;
        this.m_SampleRate = -1;
        this.m_ByteRate = -1;
        this.m_BlockAlign = -1;
        this.m_BitsPerSample = -1;
        this.m_FirstDataBytePosition = -1;
        this.m_DataBytesLength = -1L;
        this.m_Info_Title = "";
        this.m_Info_Artist = "";
        this.m_Info_Product = "";
    }

    private void calculateProperties() {
        this.m_ByteRate = this.m_SampleRate * this.m_Channels * (this.m_BitsPerSample / 8);
        this.m_BlockAlign = this.m_Channels * (this.m_BitsPerSample / 8);
        this.m_FrameLength = this.m_BlockAlign > 0 ? this.m_DataBytesLength / (long)this.m_BlockAlign : -1L;
    }

    public int getFormatID() {
        return this.m_FormatID;
    }

    private void setFormatID(int p_FormatID) {
        this.m_FormatID = p_FormatID;
    }

    public int getChannels() {
        return this.m_Channels;
    }

    private void setChannels(int p_Channels) {
        this.m_Channels = p_Channels;
        this.calculateProperties();
    }

    public int getSampleRate() {
        return this.m_SampleRate;
    }

    private void setSampleRate(int p_SampleRate) {
        this.m_SampleRate = p_SampleRate;
        this.calculateProperties();
    }

    public int getByteRate() {
        return this.m_ByteRate;
    }

    private void setByteRate(int p_ByteRate) {
        this.m_ByteRate = p_ByteRate;
    }

    public int getBlockAlign() {
        return this.m_BlockAlign;
    }

    private void setBlockAlign(int p_BlockAlign) {
        this.m_BlockAlign = p_BlockAlign;
    }

    public int getBitsPerSample() {
        return this.m_BitsPerSample;
    }

    private void setBitsPerSample(int p_BitsPerSample) {
        this.m_BitsPerSample = p_BitsPerSample;
        this.calculateProperties();
    }

    public int getFirstDataBytePosition() {
        return this.m_FirstDataBytePosition;
    }

    private void setFirstDataBytePosition(int p_FirstDataBytePosition) {
        this.m_FirstDataBytePosition = p_FirstDataBytePosition;
    }

    public long getDataBytesLength() {
        return this.m_DataBytesLength;
    }

    public void setDataBytesLength(long p_DataLength) {
        this.m_DataBytesLength = p_DataLength;
        this.calculateProperties();
    }

    public void setUnusedBytesEOF(long p_UnusedBytesEOF) {
        this.m_UnusedBytesEOF = p_UnusedBytesEOF;
    }

    public long getUnusedBytesEOF() {
        return this.m_UnusedBytesEOF;
    }

    public long getFrameLength() {
        return this.m_FrameLength;
    }

    public static LiveShowWaveHeader getWaveHeader(File p_WaveFile) {
        if (p_WaveFile == null) {
            return null;
        }
        LiveShowWaveHeader o_LiveShowWaveHeader = new LiveShowWaveHeader();
        long longFirstDataPosition = -1L;
        FileInputStream o_FileInputStream = null;
        long longChunkSize = 0L;
        ByteBuffer o_ByteBuffer = ByteBuffer.allocate(4);
        o_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        boolean boolFound = false;
        p_WaveFile.length();
        try {
            o_FileInputStream = new FileInputStream(p_WaveFile);
            if (!LiveShowWaveHeader.readBytes(o_FileInputStream, o_ByteBuffer, 4)) {
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
                return null;
            }
            String stringChunkName = new String(o_ByteBuffer.array(), CHARSET_DATA);
            if (!stringChunkName.toLowerCase().equals("riff")) {
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
                return null;
            }
            if (!LiveShowWaveHeader.readBytes(o_FileInputStream, o_ByteBuffer, 4)) {
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
                return null;
            }
            longChunkSize = o_ByteBuffer.getInt();
            if (!LiveShowWaveHeader.readBytes(o_FileInputStream, o_ByteBuffer, 4)) {
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
                return null;
            }
            stringChunkName = new String(o_ByteBuffer.array(), CHARSET_DATA);
            if (!stringChunkName.toLowerCase().equals("wave")) {
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
                return null;
            }
            longFirstDataPosition = 12L;
            while (!boolFound) {
                o_ByteBuffer.clear();
                if (!LiveShowWaveHeader.readBytes(o_FileInputStream, o_ByteBuffer, 4)) break;
                stringChunkName = new String(o_ByteBuffer.array(), CHARSET_DATA);
                o_ByteBuffer.clear();
                if (!LiveShowWaveHeader.readBytes(o_FileInputStream, o_ByteBuffer, 4)) break;
                longChunkSize = 0L;
                longChunkSize += (long)(o_ByteBuffer.array()[0] & 0xFF);
                longChunkSize += (long)((o_ByteBuffer.array()[1] & 0xFF) * 256);
                longChunkSize += (long)((o_ByteBuffer.array()[2] & 0xFF) * 65536);
                longChunkSize += (long)(o_ByteBuffer.array()[3] & 0xFF) * 0x1000000L;
                longFirstDataPosition += 8L;
                if (stringChunkName.toLowerCase().equals("list")) {
                    if (!LiveShowWaveHeader.readListChunk(o_FileInputStream, (int)longChunkSize, o_LiveShowWaveHeader)) {
                        break;
                    }
                } else if (stringChunkName.toLowerCase().equals("fmt ")) {
                    if (!LiveShowWaveHeader.readFormatChunk(o_FileInputStream, (int)longChunkSize, o_LiveShowWaveHeader)) {
                        break;
                    }
                } else {
                    if (stringChunkName.toLowerCase().equals("data")) {
                        if (p_WaveFile.length() - longFirstDataPosition - longChunkSize < 0L) {
                            longChunkSize = p_WaveFile.length() - longFirstDataPosition;
                            longChunkSize = longChunkSize / (long)o_LiveShowWaveHeader.getBlockAlign() * (long)o_LiveShowWaveHeader.getBlockAlign();
                        }
                        o_LiveShowWaveHeader.setDataBytesLength(longChunkSize);
                        o_LiveShowWaveHeader.setUnusedBytesEOF(p_WaveFile.length() - longFirstDataPosition - longChunkSize);
                        boolFound = true;
                        break;
                    }
                    o_FileInputStream.skip(longChunkSize);
                }
                longFirstDataPosition += longChunkSize;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        try {
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!boolFound) {
            return null;
        }
        o_LiveShowWaveHeader.setFirstDataBytePosition((int)longFirstDataPosition);
        return o_LiveShowWaveHeader;
    }

    public static boolean writeWaveHeader(File p_WaveFile, LiveShowWaveHeader p_LiveShowWaveHeader) {
        if (p_WaveFile == null) {
            return false;
        }
        if (p_LiveShowWaveHeader == null) {
            return false;
        }
        RandomAccessFile o_RandomAccessFile = null;
        try {
            boolean boolSuccess = false;
            o_RandomAccessFile = new RandomAccessFile(p_WaveFile, "rw");
            boolSuccess = LiveShowWaveHeader.writeWaveHeader(o_RandomAccessFile, p_LiveShowWaveHeader);
            o_RandomAccessFile.close();
            return boolSuccess;
        }
        catch (Exception e) {
            if (o_RandomAccessFile != null) {
                try {
                    o_RandomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static boolean writeWaveHeader(RandomAccessFile p_RandomAccessFile, LiveShowWaveHeader p_LiveShowWaveHeader) {
        if (p_RandomAccessFile == null) {
            return false;
        }
        if (p_LiveShowWaveHeader == null) {
            return false;
        }
        ByteBuffer o_ByteBufferHeader = ByteBuffer.allocate(44);
        o_ByteBufferHeader.order(ByteOrder.LITTLE_ENDIAN);
        try {
            o_ByteBufferHeader.put("RIFF".getBytes(CHARSET_DATA));
            o_ByteBufferHeader.putInt((int)(p_LiveShowWaveHeader.getDataBytesLength() + 36L));
            o_ByteBufferHeader.put("WAVE".getBytes(CHARSET_DATA));
            o_ByteBufferHeader.put("fmt ".getBytes(CHARSET_DATA));
            o_ByteBufferHeader.putInt(16);
            o_ByteBufferHeader.putShort((short)1);
            o_ByteBufferHeader.putShort((short)p_LiveShowWaveHeader.getChannels());
            o_ByteBufferHeader.putInt(p_LiveShowWaveHeader.getSampleRate());
            o_ByteBufferHeader.putInt(p_LiveShowWaveHeader.getByteRate());
            o_ByteBufferHeader.putShort((short)p_LiveShowWaveHeader.getBlockAlign());
            o_ByteBufferHeader.putShort((short)p_LiveShowWaveHeader.getBitsPerSample());
            o_ByteBufferHeader.put("data".getBytes(CHARSET_DATA));
            o_ByteBufferHeader.putInt((int)p_LiveShowWaveHeader.getDataBytesLength());
            p_RandomAccessFile.seek(0L);
            p_RandomAccessFile.write(o_ByteBufferHeader.array());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean readFormatChunk(FileInputStream p_FileInputStream, int p_FormatLength, LiveShowWaveHeader p_LiveShowWaveHeader) {
        if (p_FileInputStream == null) {
            return false;
        }
        if (p_FormatLength <= 0) {
            return false;
        }
        if (p_LiveShowWaveHeader == null) {
            return false;
        }
        ByteBuffer o_ByteBuffer = ByteBuffer.allocate(p_FormatLength);
        o_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (!LiveShowWaveHeader.readBytes(p_FileInputStream, o_ByteBuffer, p_FormatLength)) {
            return false;
        }
        p_LiveShowWaveHeader.setFormatID(o_ByteBuffer.getShort());
        p_LiveShowWaveHeader.setChannels(o_ByteBuffer.getShort());
        p_LiveShowWaveHeader.setSampleRate(o_ByteBuffer.getInt());
        p_LiveShowWaveHeader.setByteRate(o_ByteBuffer.getInt());
        p_LiveShowWaveHeader.setBlockAlign(o_ByteBuffer.getShort());
        p_LiveShowWaveHeader.setBitsPerSample(o_ByteBuffer.getShort());
        return true;
    }

    private static boolean readListChunk(FileInputStream p_FileInputStream, int p_FormatLength, LiveShowWaveHeader p_LiveShowWaveHeader) {
        if (p_FileInputStream == null) {
            return false;
        }
        if (p_FormatLength <= 0) {
            return false;
        }
        if (p_LiveShowWaveHeader == null) {
            return false;
        }
        byte[] arrayByteChunkName = new byte[p_FormatLength];
        boolean boolFound_INFO = false;
        ByteBuffer o_ByteBuffer = ByteBuffer.allocate(p_FormatLength);
        o_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (!LiveShowWaveHeader.readBytes(p_FileInputStream, o_ByteBuffer, p_FormatLength)) {
            return false;
        }
        try {
            String stringSubChunk;
            int intBuffer_Position = 0;
            while (intBuffer_Position < p_FormatLength - 4) {
                stringSubChunk = "";
                o_ByteBuffer.get(arrayByteChunkName, 0, 4);
                stringSubChunk = new String(arrayByteChunkName, 0, 4, CHARSET_DATA);
                if (stringSubChunk.toLowerCase().equals("info")) {
                    intBuffer_Position = o_ByteBuffer.position();
                    boolFound_INFO = true;
                    break;
                }
                o_ByteBuffer.position(++intBuffer_Position);
            }
            if (!boolFound_INFO) {
                return true;
            }
            while (o_ByteBuffer.position() < p_FormatLength - 8) {
                stringSubChunk = "";
                o_ByteBuffer.get(arrayByteChunkName, 0, 4);
                stringSubChunk = new String(arrayByteChunkName, 0, 4, CHARSET_DATA);
                long longChunkSize = 0L;
                longChunkSize += (long)(o_ByteBuffer.array()[o_ByteBuffer.position()] & 0xFF);
                longChunkSize += (long)((o_ByteBuffer.array()[o_ByteBuffer.position() + 1] & 0xFF) * 256);
                longChunkSize += (long)((o_ByteBuffer.array()[o_ByteBuffer.position() + 2] & 0xFF) * 65536);
                o_ByteBuffer.position(o_ByteBuffer.position() + 4);
                o_ByteBuffer.get(arrayByteChunkName, 0, (int)(longChunkSize += (long)(o_ByteBuffer.array()[o_ByteBuffer.position() + 3] & 0xFF) * 0x1000000L));
                String stringContent = new String(arrayByteChunkName, 0, (int)longChunkSize - 1, CHARSET_DATA);
                switch (stringSubChunk.toLowerCase()) {
                    case "inam": {
                        p_LiveShowWaveHeader.setInfo_Title(stringContent);
                        break;
                    }
                    case "iart": {
                        p_LiveShowWaveHeader.setInfo_Artist(stringContent);
                        break;
                    }
                    case "iprd": {
                        p_LiveShowWaveHeader.setInfo_Product(stringContent);
                    }
                }
                while (o_ByteBuffer.position() < p_FormatLength - 8 && o_ByteBuffer.get() == 0) {
                }
                o_ByteBuffer.position(o_ByteBuffer.position() - 1);
                boolean bl = false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public void setInfo_Title(String p_Info_Title) {
        if (p_Info_Title == null) {
            this.m_Info_Title = "";
            return;
        }
        this.m_Info_Title = p_Info_Title;
    }

    public String getInfo_Title() {
        return this.m_Info_Title;
    }

    public void setInfo_Artist(String p_Info_Artist) {
        if (p_Info_Artist == null) {
            this.m_Info_Artist = "";
            return;
        }
        this.m_Info_Artist = p_Info_Artist;
    }

    public String getInfo_Artist() {
        return this.m_Info_Artist;
    }

    public void setInfo_Product(String p_Info_Product) {
        if (p_Info_Product == null) {
            this.m_Info_Product = "";
            return;
        }
        this.m_Info_Product = p_Info_Product;
    }

    public String getInfo_Product() {
        return this.m_Info_Product;
    }

    private static boolean readBytes(FileInputStream p_FileInputStream, ByteBuffer p_ByteBuffer, int p_Length) {
        if (p_FileInputStream == null) {
            return false;
        }
        if (p_ByteBuffer == null) {
            return false;
        }
        if (p_Length <= 0) {
            return false;
        }
        if (p_Length > p_ByteBuffer.capacity()) {
            return false;
        }
        p_ByteBuffer.clear();
        int intReadBytes = 0;
        for (int intReadBlockBytes = 0; intReadBytes >= 0 && intReadBlockBytes < p_Length; intReadBlockBytes += intReadBytes) {
            try {
                intReadBytes = p_FileInputStream.read(p_ByteBuffer.array(), 0, p_Length);
            }
            catch (Exception e) {
                p_ByteBuffer.clear();
                return false;
            }
            if (intReadBytes >= 0) {
                continue;
            }
            return false;
        }
        for (int intByte = p_Length; intByte < p_ByteBuffer.capacity(); ++intByte) {
            p_ByteBuffer.array()[intByte] = 0;
        }
        p_ByteBuffer.position(0);
        return true;
    }

    public boolean equalFormat(LiveShowWaveHeader p_LiveShowWaveHeader) {
        if (p_LiveShowWaveHeader == null) {
            return false;
        }
        if (this.m_BitsPerSample != p_LiveShowWaveHeader.getBitsPerSample()) {
            return false;
        }
        if (this.m_Channels != p_LiveShowWaveHeader.getChannels()) {
            return false;
        }
        if (this.m_FormatID != p_LiveShowWaveHeader.getFormatID()) {
            return false;
        }
        return this.m_SampleRate == p_LiveShowWaveHeader.getSampleRate();
    }

    public boolean equalFormat(AudioFormat p_AudioFormat) {
        if (p_AudioFormat == null) {
            return false;
        }
        if (this.m_BitsPerSample != p_AudioFormat.getSampleSizeInBits()) {
            return false;
        }
        if (this.m_Channels != p_AudioFormat.getChannels()) {
            return false;
        }
        if (this.m_BitsPerSample == 8 && this.m_FormatID == 1 && p_AudioFormat.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            return false;
        }
        if (this.m_BitsPerSample > 16 && this.m_FormatID == 1 && p_AudioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            return false;
        }
        return (float)this.m_SampleRate == p_AudioFormat.getSampleRate();
    }
}

