/*
 * Decompiled with CFR 0.152.
 */
package SoundTools;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import org.bytedeco.ffmpeg.ffmpeg;
import org.bytedeco.javacpp.Loader;

public class LiveShowSoundConverter {
    public static boolean s_AudioConvertCancelled = false;

    public static File convertAudioFile(File p_InputFile, AudioFormat p_OutputAudioFormat, File p_OutputFile) {
        if (p_InputFile == null) {
            return null;
        }
        if (p_OutputAudioFormat == null) {
            return null;
        }
        if (p_OutputFile == null) {
            return null;
        }
        int intAVCodec = -1;
        String stringAVCodec = "";
        File o_FileResult = p_OutputFile;
        if (p_OutputFile.exists() && !p_OutputFile.delete()) {
            return null;
        }
        int intChannels = p_OutputAudioFormat.getChannels();
        int intSampleRate = (int)p_OutputAudioFormat.getSampleRate();
        int intSampleSizeBits = p_OutputAudioFormat.getSampleSizeInBits();
        boolean boolIsBigEndian = p_OutputAudioFormat.isBigEndian();
        AudioFormat.Encoding o_Encoding = p_OutputAudioFormat.getEncoding();
        int intSampleFormat = -1;
        if (intSampleSizeBits == 16) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 1;
                if (boolIsBigEndian) {
                    intAVCodec = 65537;
                    stringAVCodec = "pcm_s16be";
                } else {
                    intAVCodec = 65536;
                    stringAVCodec = "pcm_s16le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65539;
                    stringAVCodec = "pcm_u16be";
                } else {
                    intAVCodec = 65538;
                    stringAVCodec = "pcm_u16le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                // empty if block
            }
        } else if (intSampleSizeBits == 24) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65549;
                    stringAVCodec = "pcm_s24be";
                } else {
                    intAVCodec = 65548;
                    stringAVCodec = "pcm_s24le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65551;
                    stringAVCodec = "pcm_u24be";
                } else {
                    intAVCodec = 65550;
                    stringAVCodec = "pcm_u24le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                // empty if block
            }
        } else if (intSampleSizeBits == 32) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 2;
                if (boolIsBigEndian) {
                    intAVCodec = 65545;
                    stringAVCodec = "pcm_s32be";
                } else {
                    intAVCodec = 65544;
                    stringAVCodec = "pcm_s32le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65547;
                    stringAVCodec = "pcm_u32be";
                } else {
                    intAVCodec = 65546;
                    stringAVCodec = "pcm_u32le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                intSampleFormat = 3;
                if (boolIsBigEndian) {
                    intAVCodec = 65556;
                    stringAVCodec = "pcm_f32be";
                } else {
                    intAVCodec = 65557;
                    stringAVCodec = "pcm_f32le";
                }
            }
        } else if (intSampleSizeBits == 64) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 10;
                if (boolIsBigEndian) {
                    intAVCodec = 65568;
                    stringAVCodec = "pcm_s64be";
                } else {
                    intAVCodec = 65567;
                    stringAVCodec = "pcm_s64le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                intSampleFormat = 3;
                if (boolIsBigEndian) {
                    intAVCodec = 65558;
                    stringAVCodec = "pcm_f64be";
                } else {
                    intAVCodec = 65559;
                    stringAVCodec = "pcm_f64le";
                }
            }
        }
        if (intAVCodec < 0) {
            return null;
        }
        try {
            String ffmpeg2 = Loader.load(ffmpeg.class);
            ProcessBuilder pb = new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-acodec", stringAVCodec, "-ac", String.valueOf(intChannels), "-ar", String.valueOf(intSampleRate), p_OutputFile.getAbsolutePath());
            pb.inheritIO().start().waitFor();
            if (!p_OutputFile.exists() || p_OutputFile.length() < 1000L) {
                o_FileResult = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            o_FileResult = null;
        }
        if (o_FileResult == null && p_OutputFile.exists()) {
            p_OutputFile.delete();
        }
        return o_FileResult;
    }

    public static boolean matchAudioFormat(AudioFormat p_AudioFormat1, AudioFormat p_AudioFormat2) {
        if (p_AudioFormat1 == null) {
            return false;
        }
        if (p_AudioFormat2 == null) {
            return false;
        }
        if (p_AudioFormat1.isBigEndian() != p_AudioFormat2.isBigEndian()) {
            return false;
        }
        if (p_AudioFormat1.getChannels() != p_AudioFormat2.getChannels()) {
            return false;
        }
        if (!p_AudioFormat1.getEncoding().equals(p_AudioFormat2.getEncoding())) {
            return false;
        }
        if (p_AudioFormat1.getSampleRate() != p_AudioFormat2.getSampleRate()) {
            return false;
        }
        if (p_AudioFormat1.getFrameRate() != p_AudioFormat2.getFrameRate()) {
            return false;
        }
        if (p_AudioFormat1.getFrameSize() != p_AudioFormat2.getFrameSize()) {
            return false;
        }
        return p_AudioFormat1.getSampleSizeInBits() == p_AudioFormat2.getSampleSizeInBits();
    }
}

