/*
 * Decompiled with CFR 0.152.
 */
package SoundSamplePackage;

import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundStreamListener;
import SoundTools.LiveShowWaveHeader;
import StartPackage.LiveShowSoundSystem;
import SynchronizationPackage.LiveCloseSemaphore;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class LiveShowSoundStream {
    ArrayList<LiveShowSoundStreamListener> m_LiveShowSoundStreamListeners;
    File m_SoundFile;
    LiveShowWaveHeader m_LiveShowWaveHeader;
    AudioFormat m_OutputAudioFormat;
    AudioFormat m_InputAudioFormat;
    LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncStreamListeners = new Object();

    public LiveShowSoundStream(LiveShowSoundStreamListener p_LiveShowSoundStreamListener, AudioFormat p_OutputAudioFormat, File p_AudioFile) throws Exception {
        this.initMembers();
        this.addLiveShowSoundStreamListener(p_LiveShowSoundStreamListener);
        if (p_OutputAudioFormat != null) {
            this.m_OutputAudioFormat = p_OutputAudioFormat;
        }
        if (!this.loadSoundFile(p_AudioFile)) {
            throw new Exception("SoundFile no valid");
        }
        this.m_LiveShowWaveHeader = LiveShowWaveHeader.getWaveHeader(this.m_SoundFile);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowSoundStreamListeners = new ArrayList();
        this.m_SoundFile = null;
        this.m_InputAudioFormat = null;
        this.m_OutputAudioFormat = SoundMixers.DEFAULT_AUDIOFORMAT;
        this.m_LiveShowWaveHeader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.notifyListener_Closing();
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundStreamListeners != null) {
                this.m_LiveShowSoundStreamListeners.clear();
                this.m_LiveShowSoundStreamListeners = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    private boolean loadSoundFile(File p_SoundFile) {
        if (p_SoundFile == null) {
            return false;
        }
        boolean boolReady = false;
        this.m_SoundFile = p_SoundFile;
        while (!boolReady) {
            block9: {
                File o_NewFile;
                try {
                    AudioFormat o_AudioFormat_Input = SoundMixers.getAudioFormat((File)this.m_SoundFile);
                    if (o_AudioFormat_Input == null) {
                        return false;
                    }
                    if (LiveShowSoundSystem.matchesAudioFormat(o_AudioFormat_Input, this.m_OutputAudioFormat, true)) break block9;
                    AudioFormat o_AudioFormat_Output = new AudioFormat(this.m_OutputAudioFormat.getEncoding(), this.m_OutputAudioFormat.getSampleRate(), this.m_OutputAudioFormat.getSampleSizeInBits(), o_AudioFormat_Input.getChannels(), o_AudioFormat_Input.getChannels() * this.m_OutputAudioFormat.getSampleSizeInBits() / 8, this.m_OutputAudioFormat.getFrameRate(), this.m_OutputAudioFormat.isBigEndian());
                    String stringConvertedFileName = LiveShowSoundSystem.calculateConvertedSoundFileName(this.m_SoundFile, o_AudioFormat_Output);
                    o_NewFile = new File(this.m_SoundFile.getParentFile().getAbsoluteFile() + stringConvertedFileName);
                    if (!o_NewFile.exists()) {
                        o_NewFile = null;
                    }
                    if (o_NewFile == null) {
                        o_NewFile = this.notifyListener_NoMatchingFormat();
                    }
                    this.m_SoundFile = null;
                    if (o_NewFile == null) {
                        boolReady = true;
                        break block9;
                    }
                    this.m_SoundFile = o_NewFile;
                }
                catch (Exception e) {
                    o_NewFile = this.notifyListener_NoInputFile();
                    this.m_SoundFile = null;
                    if (o_NewFile == null) {
                        boolReady = true;
                        break block9;
                    }
                    this.m_SoundFile = o_NewFile;
                }
                continue;
            }
            boolReady = true;
        }
        return this.m_SoundFile != null;
    }

    public File getSoundFile() {
        return this.m_SoundFile;
    }

    public LiveShowWaveHeader getLiveShowWaveHeader() {
        return this.m_LiveShowWaveHeader;
    }

    public long getDataBytesLength() {
        if (this.m_LiveShowWaveHeader == null) {
            return -1L;
        }
        return this.m_LiveShowWaveHeader.getDataBytesLength();
    }

    public long getFrameLength() {
        if (this.m_LiveShowWaveHeader == null) {
            return -1L;
        }
        return this.m_LiveShowWaveHeader.getFrameLength();
    }

    public long getFirstDataBytePosition() {
        if (this.m_LiveShowWaveHeader == null) {
            return -1L;
        }
        return this.m_LiveShowWaveHeader.getFirstDataBytePosition();
    }

    public long getUnusedBytesEOF() {
        if (this.m_LiveShowWaveHeader == null) {
            return -1L;
        }
        return this.m_LiveShowWaveHeader.getUnusedBytesEOF();
    }

    public RandomAccessFile createReadableRandomAccessFile() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        RandomAccessFile o_RandomAccessFile = null;
        try {
            o_RandomAccessFile = new RandomAccessFile(this.m_SoundFile, "r");
            o_RandomAccessFile.seek(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_RandomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowSoundStreamListener(LiveShowSoundStreamListener p_LiveShowSoundStreamListener) {
        if (p_LiveShowSoundStreamListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            if (!this.m_LiveShowSoundStreamListeners.contains(p_LiveShowSoundStreamListener)) {
                this.m_LiveShowSoundStreamListeners.add(p_LiveShowSoundStreamListener);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowSoundStreamListener(LiveShowSoundStreamListener p_LiveShowSoundStreamListener) {
        if (p_LiveShowSoundStreamListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            boolRemoved = this.m_LiveShowSoundStreamListeners.remove(p_LiveShowSoundStreamListener);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File notifyListener_NoInputFile() {
        LiveShowSoundStreamListener o_LiveShowSoundStreamListener;
        ArrayList<LiveShowSoundStreamListener> o_LiveShowSoundStreamListeners;
        File o_File = null;
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundStreamListeners == null) {
                return null;
            }
            if (this.m_LiveShowSoundStreamListeners.size() <= 0) {
                return null;
            }
            o_LiveShowSoundStreamListeners = new ArrayList<LiveShowSoundStreamListener>(this.m_LiveShowSoundStreamListeners.size());
            o_LiveShowSoundStreamListeners.addAll(this.m_LiveShowSoundStreamListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowSoundStreamListeners.size() && (o_File = (o_LiveShowSoundStreamListener = (LiveShowSoundStreamListener)o_LiveShowSoundStreamListeners.get(intListener)).eventSoundStreamFileNotFound(this, this.m_SoundFile)) == null; ++intListener) {
        }
        o_LiveShowSoundStreamListeners.clear();
        return o_File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File notifyListener_NoMatchingFormat() {
        LiveShowSoundStreamListener o_LiveShowSoundStreamListener;
        ArrayList<LiveShowSoundStreamListener> o_LiveShowSoundStreamListeners;
        File o_File = null;
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundStreamListeners == null) {
                return null;
            }
            if (this.m_LiveShowSoundStreamListeners.size() <= 0) {
                return null;
            }
            o_LiveShowSoundStreamListeners = new ArrayList<LiveShowSoundStreamListener>(this.m_LiveShowSoundStreamListeners.size());
            o_LiveShowSoundStreamListeners.addAll(this.m_LiveShowSoundStreamListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowSoundStreamListeners.size() && (o_File = (o_LiveShowSoundStreamListener = (LiveShowSoundStreamListener)o_LiveShowSoundStreamListeners.get(intListener)).eventSoundStreamFileNotMatchingFormat(this, this.m_SoundFile)) == null; ++intListener) {
        }
        o_LiveShowSoundStreamListeners.clear();
        return o_File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_Closing() {
        ArrayList<LiveShowSoundStreamListener> o_LiveShowSoundStreamListeners;
        Object object = this.m_SyncStreamListeners;
        synchronized (object) {
            if (this.m_LiveShowSoundStreamListeners == null) {
                return;
            }
            if (this.m_LiveShowSoundStreamListeners.size() <= 0) {
                return;
            }
            o_LiveShowSoundStreamListeners = new ArrayList<LiveShowSoundStreamListener>(this.m_LiveShowSoundStreamListeners.size());
            o_LiveShowSoundStreamListeners.addAll(this.m_LiveShowSoundStreamListeners);
            this.m_LiveShowSoundStreamListeners.clear();
        }
        int intListenerCount = o_LiveShowSoundStreamListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0; --intListener) {
            LiveShowSoundStreamListener o_LiveShowSoundStreamListener = (LiveShowSoundStreamListener)o_LiveShowSoundStreamListeners.get(intListener);
            o_LiveShowSoundStreamListener.eventSoundStreamClosing(this);
            o_LiveShowSoundStreamListeners.remove(o_LiveShowSoundStreamListener);
        }
        o_LiveShowSoundStreamListeners.clear();
    }
}

