/*
 * Decompiled with CFR 0.152.
 */
package SoundGraphics;

import LiveShowPlayPackage.PlayRemoteActions;
import Mixer.SoundControlComponent;
import Mixer.SoundControl_Volume;
import Mixer.SoundMixerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class LiveShowSoundMixerMainView
extends JPanel
implements PropertyChangeListener {
    private SoundControl_Volume soundControl_VolumeMain;
    private ArrayList<SoundControlComponent> m_MainMixerSoundControlComponents;
    private double m_Volume_Old;
    SoundMixerPanel soundMixerPanel_MainMixer;
    public static final String SPITID_MAINSOUND_VOLUME = "mainmixerSound_Volume";
    public static final String SPITID_MAINSOUND_INCREASEVOLUME = "mainmixerSound_IncreaseVolume";
    public static final String SPITID_MAINSOUND_DECREASEVOLUME = "mainmixerSound_DecreaseVolume";

    public LiveShowSoundMixerMainView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_MainMixerSoundControlComponents = new ArrayList();
        this.m_Volume_Old = -1.0;
    }

    public void close() {
        if (this.m_MainMixerSoundControlComponents != null) {
            int intMainSoundControlComponentCount = this.m_MainMixerSoundControlComponents.size();
            for (int intSoundControlComponent = intMainSoundControlComponentCount - 1; intSoundControlComponent >= 0; --intSoundControlComponent) {
                SoundControlComponent o_SoundControlComponent = this.m_MainMixerSoundControlComponents.get(intSoundControlComponent);
                this.removeMainMixerSoundControlComponent(o_SoundControlComponent);
            }
            this.m_MainMixerSoundControlComponents.clear();
        }
    }

    private void initComponents() {
        this.soundMixerPanel_MainMixer = new SoundMixerPanel();
        this.setBackground(new Color(0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.soundMixerPanel_MainMixer.setBackground(new Color(0, 0, 0));
        this.soundMixerPanel_MainMixer.setName("Sound");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.soundMixerPanel_MainMixer, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.soundControl_VolumeMain = new SoundControl_Volume();
        this.addMainMixerSoundControlComponent(this.soundControl_VolumeMain);
    }

    public void addMainMixerSoundControlComponent(SoundControlComponent p_SoundControlComponent) {
        if (p_SoundControlComponent == null) {
            return;
        }
        if (this.m_MainMixerSoundControlComponents.contains(p_SoundControlComponent)) {
            return;
        }
        p_SoundControlComponent.setControlMaster(true);
        this.m_MainMixerSoundControlComponents.add(p_SoundControlComponent);
        this.soundMixerPanel_MainMixer.addSoundControlComponent(p_SoundControlComponent);
        p_SoundControlComponent.setVisible(true);
        Dimension o_Dimension = new Dimension(0, 0);
        for (int intComponent = 0; intComponent < this.m_MainMixerSoundControlComponents.size(); ++intComponent) {
            SoundControlComponent o_SoundControlComponent = this.m_MainMixerSoundControlComponents.get(intComponent);
            if (o_SoundControlComponent == null) continue;
            Dimension o_Dimension_Component = o_SoundControlComponent.getPreferredSize();
            o_Dimension.width += o_Dimension_Component.width;
            o_Dimension.height = o_Dimension_Component.height;
        }
        Insets o_Insets = this.getInsets();
        o_Dimension.width += o_Insets.left + o_Insets.right;
        o_Dimension.height += o_Insets.top + o_Insets.bottom;
        super.setPreferredSize(o_Dimension);
    }

    public void removeMainMixerSoundControlComponent(SoundControlComponent p_SoundControlComponent) {
        if (p_SoundControlComponent == null) {
            return;
        }
        if (!this.m_MainMixerSoundControlComponents.contains(p_SoundControlComponent)) {
            return;
        }
        this.m_MainMixerSoundControlComponents.remove(p_SoundControlComponent);
        this.soundMixerPanel_MainMixer.removeSoundControlComponent(p_SoundControlComponent);
        Dimension o_Dimension = new Dimension(0, 0);
        for (int intComponent = 0; intComponent < this.m_MainMixerSoundControlComponents.size(); ++intComponent) {
            SoundControlComponent o_SoundControlComponent = this.m_MainMixerSoundControlComponents.get(intComponent);
            if (o_SoundControlComponent == null) continue;
            Dimension o_Dimension_Component = o_SoundControlComponent.getPreferredSize();
            o_Dimension.width += o_Dimension_Component.width;
            o_Dimension.height = o_Dimension_Component.height;
        }
        Insets o_Insets = this.getInsets();
        o_Dimension.width += o_Insets.left + o_Insets.right;
        o_Dimension.height += o_Insets.top + o_Insets.bottom;
        Dimension o_DimensionMin = this.getMinimumSize();
        if (o_Dimension.width < o_DimensionMin.width) {
            o_Dimension.width = o_DimensionMin.width;
        }
        if (o_Dimension.height < o_DimensionMin.height) {
            o_Dimension.height = o_DimensionMin.height;
        }
        super.setPreferredSize(o_Dimension);
    }

    public SoundControl_Volume getSoundControl_Volume() {
        return this.soundControl_VolumeMain;
    }

    public void createSPITRemote(String p_GroupName) {
        this.soundControl_VolumeMain.createSPITRemote_Value(SPITID_MAINSOUND_VOLUME, p_GroupName, this.soundMixerPanel_MainMixer.getName(), null);
        this.soundControl_VolumeMain.createSPITRemote_InDecrease(SPITID_MAINSOUND_INCREASEVOLUME, p_GroupName, this.soundMixerPanel_MainMixer.getName(), PlayRemoteActions.ACTIONNAME_UP);
        this.soundControl_VolumeMain.createSPITRemote_InDecrease(SPITID_MAINSOUND_DECREASEVOLUME, p_GroupName, this.soundMixerPanel_MainMixer.getName(), PlayRemoteActions.ACTIONNAME_DOWN);
    }

    public void createRemoteMouseActions() {
        Object o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                double doubleVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolume();
                double doubleMaxVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMax();
                double doubleMinVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMin();
                LiveShowSoundMixerMainView.this.soundControl_VolumeMain.setVolume(doubleVolume += (doubleMaxVolume - doubleMinVolume) * PlayRemoteActions.VALUEFACTOR_UPDOWN_PERCENT);
            }
        };
        ImageIcon o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_Loudspeaker_32.png"));
        PlayRemoteActions.RemoteAction o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"", (String)"actionUp", (String)"sourceIDMainSoundVolume", (String)this.soundControl_VolumeMain.getControlName(), (long)0L);
        o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                double doubleVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolume();
                double doubleMaxVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMax();
                double doubleMinVolume = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMin();
                LiveShowSoundMixerMainView.this.soundControl_VolumeMain.setVolume(doubleVolume -= (doubleMaxVolume - doubleMinVolume) * PlayRemoteActions.VALUEFACTOR_UPDOWN_PERCENT);
            }
        };
        o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_Loudspeaker_32.png"));
        o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"", (String)"actionDown", (String)"sourceIDMainSoundVolume", (String)this.soundControl_VolumeMain.getControlName(), (long)0L);
        o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                boolean boolVolumeCaught = false;
                double doubleVolume_Input = (LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMax() - LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolumeMin()) * p_Value;
                double doubleVolumeActual = LiveShowSoundMixerMainView.this.soundControl_VolumeMain.getVolume();
                if (doubleVolume_Input > LiveShowSoundMixerMainView.this.m_Volume_Old) {
                    if (doubleVolume_Input >= doubleVolumeActual && Math.abs(LiveShowSoundMixerMainView.this.m_Volume_Old - doubleVolumeActual) < 1.0) {
                        boolVolumeCaught = true;
                    }
                } else if (doubleVolume_Input <= doubleVolumeActual && Math.abs(LiveShowSoundMixerMainView.this.m_Volume_Old - doubleVolumeActual) < 1.0) {
                    boolVolumeCaught = true;
                }
                LiveShowSoundMixerMainView.this.m_Volume_Old = doubleVolume_Input;
                if (boolVolumeCaught) {
                    LiveShowSoundMixerMainView.this.soundControl_VolumeMain.setVolume(doubleVolume_Input);
                }
            }
        };
        o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_Loudspeaker_32.png"));
        o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"", (String)"actionFadet", (String)"sourceIDMainSoundVolume", (String)this.soundControl_VolumeMain.getControlName(), (long)0L);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

