/*
 * Decompiled with CFR 0.152.
 */
package SoundGraphics;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import SoundSamplePackage.LiveShowSoundHD;
import SoundTools.LiveShowWaveHeader;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundVIP;
import StartPackage.LiveShowSoundSystem;
import SwingToolTipPackage.PopUpToolTip;
import Text.Export_HTML;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class LiveShowSoundHDView
extends JPanel
implements ListSelectionListener {
    private ArrayList<LiveShowSoundHD> m_SelectedSoundHDs;
    private final Object m_SyncSoundHD = new Object();
    private ArrayList<RequestListener> m_RequestListeners;
    private final Object m_SyncRequestListeners = new Object();
    private JButton jButton_Export;
    private JButton jButton_LoadSoundfile;
    private JButton jButton_ShowInTimeline;
    private JButton jButton_SoundOpenHDFrames;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_DMXScenes;
    private JScrollPane jScrollPane_SoundHDs;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JTable jTable_SoundHDs;
    private JToolBar jToolBar_Print;
    private JToolBar jToolBar_SoundHD;

    public LiveShowSoundHDView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshUI();
    }

    private void initMembers() {
        this.m_RequestListeners = new ArrayList();
        this.m_SelectedSoundHDs = new ArrayList();
    }

    private void initComponentsFurther() {
        this.jScrollPane_SoundHDs.getViewport().setBackground(Color.BLACK);
        this.jTable_SoundHDs.setModel(LiveShowSoundSystem.getSoundHDTableModel());
        LiveShowSoundSystem.getSoundHDTableModel().finishJTable(this.jTable_SoundHDs);
        this.jTable_SoundHDs.getSelectionModel().addListSelectionListener(this);
        this.jTable_SoundHDs.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowInTimeline.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Export.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SoundOpenHDFrames.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_LoadSoundfile.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jPanel_DMXScenes = new JPanel();
        this.jScrollPane_SoundHDs = new JScrollPane();
        this.jTable_SoundHDs = new JTable();
        this.jToolBar_Print = new JToolBar();
        this.jButton_Export = new JButton();
        this.jToolBar_SoundHD = new JToolBar();
        this.jButton_LoadSoundfile = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_SoundOpenHDFrames = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_ShowInTimeline = new JButton();
        this.setPreferredSize(new Dimension(450, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_DMXScenes.setMinimumSize(new Dimension(200, 200));
        this.jPanel_DMXScenes.setPreferredSize(new Dimension(300, 300));
        this.jPanel_DMXScenes.setRequestFocusEnabled(false);
        this.jPanel_DMXScenes.setLayout(new GridBagLayout());
        this.jTable_SoundHDs.setFont(new Font("Tahoma", 0, 14));
        this.jTable_SoundHDs.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_SoundHDs.setAutoResizeMode(4);
        this.jTable_SoundHDs.setRowHeight(22);
        this.jTable_SoundHDs.setSelectionMode(2);
        this.jScrollPane_SoundHDs.setViewportView(this.jTable_SoundHDs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DMXScenes.add((Component)this.jScrollPane_SoundHDs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_DMXScenes, gridBagConstraints);
        this.jToolBar_Print.setBorder(null);
        this.jToolBar_Print.setFloatable(false);
        this.jToolBar_Print.setRollover(true);
        this.jToolBar_Print.setMaximumSize(new Dimension(200, 41));
        this.jToolBar_Print.setMinimumSize(new Dimension(76, 36));
        this.jToolBar_Print.setPreferredSize(new Dimension(100, 36));
        this.jButton_Export.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Export_html.png")));
        this.jButton_Export.setToolTipText("Export the list of soundfiles as excel list (xls)");
        this.jButton_Export.setContentAreaFilled(false);
        this.jButton_Export.setFocusable(false);
        this.jButton_Export.setHorizontalTextPosition(0);
        this.jButton_Export.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Export.setVerticalTextPosition(3);
        this.jButton_Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSoundHDView.this.jButton_ExportActionPerformed(evt);
            }
        });
        this.jToolBar_Print.add(this.jButton_Export);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar_Print, gridBagConstraints);
        this.jToolBar_SoundHD.setBorder(null);
        this.jToolBar_SoundHD.setFloatable(false);
        this.jToolBar_SoundHD.setRollover(true);
        this.jToolBar_SoundHD.setMaximumSize(new Dimension(200, 36));
        this.jToolBar_SoundHD.setMinimumSize(new Dimension(140, 36));
        this.jToolBar_SoundHD.setPreferredSize(new Dimension(180, 36));
        this.jButton_LoadSoundfile.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/File_Load.png")));
        this.jButton_LoadSoundfile.setToolTipText("Load Soundfile");
        this.jButton_LoadSoundfile.setContentAreaFilled(false);
        this.jButton_LoadSoundfile.setFocusable(false);
        this.jButton_LoadSoundfile.setHorizontalTextPosition(0);
        this.jButton_LoadSoundfile.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_LoadSoundfile.setMaximumSize(new Dimension(32, 32));
        this.jButton_LoadSoundfile.setMinimumSize(new Dimension(32, 32));
        this.jButton_LoadSoundfile.setPreferredSize(new Dimension(32, 32));
        this.jButton_LoadSoundfile.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_LoadSoundfile.setVerticalTextPosition(3);
        this.jButton_LoadSoundfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSoundHDView.this.jButton_LoadSoundfileActionPerformed(evt);
            }
        });
        this.jToolBar_SoundHD.add(this.jButton_LoadSoundfile);
        this.jToolBar_SoundHD.add(this.jSeparator2);
        this.jButton_SoundOpenHDFrames.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Sound_Frame.png")));
        this.jButton_SoundOpenHDFrames.setToolTipText("Open Selected SoundFiles");
        this.jButton_SoundOpenHDFrames.setContentAreaFilled(false);
        this.jButton_SoundOpenHDFrames.setFocusable(false);
        this.jButton_SoundOpenHDFrames.setHorizontalTextPosition(0);
        this.jButton_SoundOpenHDFrames.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_SoundOpenHDFrames.setMaximumSize(new Dimension(32, 32));
        this.jButton_SoundOpenHDFrames.setMinimumSize(new Dimension(32, 32));
        this.jButton_SoundOpenHDFrames.setPreferredSize(new Dimension(32, 32));
        this.jButton_SoundOpenHDFrames.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SoundOpenHDFrames.setVerticalTextPosition(3);
        this.jButton_SoundOpenHDFrames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSoundHDView.this.jButton_SoundOpenHDFramesActionPerformed(evt);
            }
        });
        this.jToolBar_SoundHD.add(this.jButton_SoundOpenHDFrames);
        this.jToolBar_SoundHD.add(this.jSeparator1);
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects all objects in timeline using this sound file.");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSoundHDView.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        this.jToolBar_SoundHD.add(this.jButton_ShowInTimeline);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar_SoundHD, gridBagConstraints);
    }

    public LiveShowSoundHD getLiveShowSoundHD(int p_Index) {
        if (p_Index < 0 || p_Index >= LiveShowSoundSystem.getSoundHDTableModel().size()) {
            return null;
        }
        return (LiveShowSoundHD)LiveShowSoundSystem.getSoundHDTableModel().get(p_Index);
    }

    public int getLiveShowSoundHDCount() {
        return LiveShowSoundSystem.getSoundHDTableModel().size();
    }

    public void clearSelectedSoundHDs() {
        LiveShowSoundSystem.getSoundHDTableModel().clearSelection(this.jTable_SoundHDs);
        this.refreshUI();
    }

    public void addSelectedSoundHD(LiveShowSoundHD p_LiveShowSoundHD) {
        if (p_LiveShowSoundHD == null) {
            return;
        }
        LiveShowSoundSystem.getSoundHDTableModel().addSelectedLiveShowSoundHD(this.jTable_SoundHDs, p_LiveShowSoundHD);
        this.refreshUI();
    }

    public void scrollToSelection() {
        LiveShowSoundSystem.getSoundHDTableModel().scrollToSelection(this.jTable_SoundHDs);
    }

    private void refreshUI() {
        if (this.m_SelectedSoundHDs.size() <= 0) {
            this.jButton_ShowInTimeline.setEnabled(false);
            this.jButton_SoundOpenHDFrames.setEnabled(false);
        } else {
            this.jButton_ShowInTimeline.setEnabled(true);
            this.jButton_SoundOpenHDFrames.setEnabled(true);
        }
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        if (this.m_SelectedSoundHDs == null) {
            return;
        }
        LiveShowSoundVIP o_LiveShowSoundVIP = LiveShowSoundSystem.getLiveShowSoundVIP();
        if (o_LiveShowSoundVIP == null) {
            return;
        }
        o_LiveShowSoundVIP.clearSelectedObjects(true);
        for (int intObject = 0; intObject < o_LiveShowSoundVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowSoundObject o_LiveShowSoundObject;
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowSoundVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !this.m_SelectedSoundHDs.contains((o_LiveShowSoundObject = (LiveShowSoundObject)o_LiveShowObjectInterface).getLiveShowSoundHD())) continue;
            o_LiveShowSoundVIP.addSelectedObject(o_LiveShowObjectInterface);
        }
        if (o_LiveShowSoundVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowSoundVIP.toFront();
        }
    }

    private void jButton_SoundOpenHDFramesActionPerformed(ActionEvent evt) {
        if (this.m_SelectedSoundHDs == null) {
            return;
        }
        this.notifyRequestListeners_LoadSoundFile(this.m_SelectedSoundHDs);
    }

    private void jButton_LoadSoundfileActionPerformed(ActionEvent evt) {
        this.notifyRequestListeners_LoadSoundFile();
    }

    private void jButton_ExportActionPerformed(ActionEvent evt) {
        LiveShowSoundHD.SoundHDTableModel o_SoundHDTableModel = LiveShowSoundSystem.getSoundHDTableModel();
        if (o_SoundHDTableModel == null) {
            return;
        }
        int intRowCount = this.jTable_SoundHDs.getRowCount();
        if (intRowCount <= 0) {
            return;
        }
        if (!Export_HTML.export_Start((LiveShowProjectDescription)LiveShowSoundSystem.getLiveShowProjectDescription(), (String)"Sound")) {
            return;
        }
        int intLabelCount = 4;
        int intIndexFileName = 0;
        int intIndexInfoTitle = 1;
        int intIndexInfoArtist = 2;
        int intIndexInfoProduct = 3;
        ArrayList<String> o_ArrayListLabels = new ArrayList<String>(intLabelCount);
        ArrayList<Integer> o_ArrayListColumnFormats = new ArrayList<Integer>(intLabelCount);
        for (int intLabel = 0; intLabel < intLabelCount; ++intLabel) {
            o_ArrayListLabels.add(null);
            o_ArrayListColumnFormats.add(null);
        }
        o_ArrayListLabels.set(intIndexFileName, LiveShowSoundHD.SoundHDTableModel.COLUMN_FILENAME);
        o_ArrayListLabels.set(intIndexInfoTitle, LiveShowSoundHD.SoundHDTableModel.COLUMN_INFOTITLE);
        o_ArrayListLabels.set(intIndexInfoArtist, LiveShowSoundHD.SoundHDTableModel.COLUMN_INFOARTIST);
        o_ArrayListLabels.set(intIndexInfoProduct, LiveShowSoundHD.SoundHDTableModel.COLUMN_INFOPRODUCT);
        o_ArrayListColumnFormats.set(intIndexFileName, 0);
        o_ArrayListColumnFormats.set(intIndexInfoTitle, 2);
        o_ArrayListColumnFormats.set(intIndexInfoArtist, 2);
        o_ArrayListColumnFormats.set(intIndexInfoProduct, 2);
        Export_HTML.export_TableStart(o_ArrayListLabels, o_ArrayListColumnFormats);
        for (int intRow = 0; intRow < intRowCount; ++intRow) {
            LiveShowSoundHD o_LiveShowSoundHD;
            try {
                int intModelRow = this.jTable_SoundHDs.convertRowIndexToModel(intRow);
                o_LiveShowSoundHD = o_SoundHDTableModel.getLiveShowSoundHD(intModelRow);
            }
            catch (Exception e) {
                o_LiveShowSoundHD = null;
            }
            if (o_LiveShowSoundHD == null) continue;
            LiveShowWaveHeader o_LiveShowWaveHeader = o_LiveShowSoundHD.getLiveShowWaveHeader();
            File o_File = o_LiveShowSoundHD.getSoundFile();
            if (o_File == null) continue;
            o_ArrayListLabels.set(intIndexFileName, o_File.getName() + "\n" + o_File.getParent());
            if (o_LiveShowWaveHeader != null) {
                o_ArrayListLabels.set(intIndexInfoTitle, o_LiveShowWaveHeader.getInfo_Title());
                o_ArrayListLabels.set(intIndexInfoArtist, o_LiveShowWaveHeader.getInfo_Artist());
                o_ArrayListLabels.set(intIndexInfoProduct, o_LiveShowWaveHeader.getInfo_Product());
            } else {
                o_ArrayListLabels.set(intIndexInfoTitle, "");
                o_ArrayListLabels.set(intIndexInfoArtist, "");
                o_ArrayListLabels.set(intIndexInfoProduct, "");
            }
            Export_HTML.export_TableAddRow(o_ArrayListLabels);
        }
        Export_HTML.export_End();
    }

    public void printSoundHDTable(LiveShowProjectDescription p_LiveShowProjectDescription) {
        MessageFormat o_MessageFormatHeader = null;
        MessageFormat o_MessageFormatFooter = null;
        PrintRequestAttributeSet o_PrintRequestAttributeSet = null;
        PrintService o_PrintService = null;
        int intRowCount = this.jTable_SoundHDs.getRowCount();
        if (intRowCount <= 0) {
            return;
        }
        o_MessageFormatFooter = new MessageFormat("{0,number,integer}");
        if (p_LiveShowProjectDescription != null) {
            o_MessageFormatHeader = new MessageFormat(p_LiveShowProjectDescription.getProjectName());
        }
        try {
            this.jTable_SoundHDs.print(JTable.PrintMode.FIT_WIDTH, o_MessageFormatHeader, o_MessageFormatFooter, true, o_PrintRequestAttributeSet, false, o_PrintService);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int intFirstIndex = e.getFirstIndex();
        int intLastIndex = e.getLastIndex();
        LiveShowSoundHD o_LiveShowSoundHD = null;
        Object object = this.m_SyncSoundHD;
        synchronized (object) {
            this.m_SelectedSoundHDs.clear();
            int[] intSelectedRows = this.jTable_SoundHDs.getSelectedRows();
            for (int intRow = 0; intRow < intSelectedRows.length; ++intRow) {
                int intSelectedRow = intSelectedRows[intRow];
                if (intSelectedRow >= 0) {
                    try {
                        intSelectedRow = this.jTable_SoundHDs.convertRowIndexToModel(intSelectedRow);
                        o_LiveShowSoundHD = (LiveShowSoundHD)LiveShowSoundSystem.getSoundHDTableModel().get(intSelectedRow);
                    }
                    catch (Exception error) {
                        System.out.println(error.getMessage());
                        o_LiveShowSoundHD = null;
                    }
                } else {
                    o_LiveShowSoundHD = null;
                }
                this.m_SelectedSoundHDs.add(o_LiveShowSoundHD);
            }
        }
        this.refreshUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestListener(RequestListener p_RequestListener) {
        if (p_RequestListener == null) {
            return false;
        }
        Object object = this.m_SyncRequestListeners;
        synchronized (object) {
            if (this.m_RequestListeners.contains(p_RequestListener)) {
                return true;
            }
            this.m_RequestListeners.add(p_RequestListener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestListener(RequestListener p_RequestListener) {
        if (p_RequestListener == null) {
            return false;
        }
        Object object = this.m_SyncRequestListeners;
        synchronized (object) {
            if (!this.m_RequestListeners.contains(p_RequestListener)) {
                return false;
            }
            return this.m_RequestListeners.remove(p_RequestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRequestListeners_LoadSoundFile(ArrayList<LiveShowSoundHD> p_LiveShowSoundHD) {
        ArrayList<RequestListener> o_RquestListeners;
        if (p_LiveShowSoundHD == null) {
            return;
        }
        Object object = this.m_SyncRequestListeners;
        synchronized (object) {
            if (this.m_RequestListeners == null) {
                return;
            }
            if (this.m_RequestListeners.size() <= 0) {
                return;
            }
            o_RquestListeners = new ArrayList<RequestListener>(this.m_RequestListeners.size());
            o_RquestListeners.addAll(this.m_RequestListeners);
        }
        for (int intListener = 0; intListener < o_RquestListeners.size(); ++intListener) {
            RequestListener o_Listener = (RequestListener)o_RquestListeners.get(intListener);
            o_Listener.requestLoadSoundFile(p_LiveShowSoundHD);
        }
        o_RquestListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRequestListeners_LoadSoundFile() {
        ArrayList<RequestListener> o_RquestListeners;
        Object object = this.m_SyncRequestListeners;
        synchronized (object) {
            if (this.m_RequestListeners == null) {
                return;
            }
            if (this.m_RequestListeners.size() <= 0) {
                return;
            }
            o_RquestListeners = new ArrayList<RequestListener>(this.m_RequestListeners.size());
            o_RquestListeners.addAll(this.m_RequestListeners);
        }
        for (int intListener = 0; intListener < o_RquestListeners.size(); ++intListener) {
            RequestListener o_Listener = (RequestListener)o_RquestListeners.get(intListener);
            o_Listener.requestLoadSoundFile();
        }
        o_RquestListeners.clear();
    }

    public static interface RequestListener {
        public void requestLoadSoundFile();

        public void requestLoadSoundFile(ArrayList<LiveShowSoundHD> var1);
    }
}

