/*
 * Decompiled with CFR 0.152.
 */
package SoundGraphics;

import SoundSamplePackage.LiveShowSoundHD;
import SoundTools.LiveShowWaveHeader;
import SynchronizationPackage.LiveCloseSemaphore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class LiveShowSoundGraphicsFile {
    public static final String FILESUFFIX = ".lsg";
    private LiveShowSoundHD m_LiveShowSoundHD;
    private AudioFormat m_AudioFormat;
    private int m_Channels;
    private int m_SampleBytes;
    private int m_SampleReduction_Largest;
    private int m_SampleReduction_Large;
    private int m_SampleReduction_Middle;
    private int m_SampleReduction_Small;
    private File m_GraphicsFile;
    private RandomAccessFile m_GraphicRandomAccessFile;
    private GraphicsHeader m_GraphicsHeader;
    private RandomAccessFile m_RandomAccessFile;
    private ByteBuffer m_GrafikByteBuffer;
    private ByteBuffer m_ByteBuffer_GraphicsFramea;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncFileAccess = new Object();

    public LiveShowSoundGraphicsFile(LiveShowSoundHD p_LiveShowSoundHD) {
        this.initMembers();
        this.m_LiveShowSoundHD = p_LiveShowSoundHD;
        if (this.m_LiveShowSoundHD != null) {
            this.m_AudioFormat = this.m_LiveShowSoundHD.getAudioFormat();
        }
        this.m_ByteBuffer_GraphicsFramea = ByteBuffer.allocate(8);
        if (this.m_AudioFormat != null) {
            if (this.m_AudioFormat.isBigEndian()) {
                this.m_ByteBuffer_GraphicsFramea.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.m_ByteBuffer_GraphicsFramea.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        this.calculateSoundGraphicsFile(false);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowSoundHD = null;
        this.m_AudioFormat = null;
        this.m_Channels = 0;
        this.m_GraphicsFile = null;
        this.m_GraphicRandomAccessFile = null;
        this.m_GraphicsHeader = null;
        this.m_RandomAccessFile = null;
        this.m_GrafikByteBuffer = null;
        this.m_ByteBuffer_GraphicsFramea = null;
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.closeFiles();
        if (this.m_LiveShowSoundHD != null) {
            this.m_LiveShowSoundHD = null;
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFiles() {
        Object object = this.m_SyncFileAccess;
        synchronized (object) {
            try {
                if (this.m_GraphicRandomAccessFile != null) {
                    this.m_GraphicRandomAccessFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.m_RandomAccessFile != null) {
                    this.m_RandomAccessFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_RandomAccessFile = null;
            this.m_GraphicRandomAccessFile = null;
        }
    }

    private String calculateGraphicsFilePath(LiveShowSoundHD p_LiveShowSoundHD) {
        File o_SoundFile = p_LiveShowSoundHD.getSoundFile();
        if (o_SoundFile == null) {
            return null;
        }
        String stringSoundFilePathName = o_SoundFile.getPath();
        String stringGraphicsFileName = null;
        stringGraphicsFileName = stringSoundFilePathName.substring(stringSoundFilePathName.length() - 4, stringSoundFilePathName.length()).toLowerCase().equals(".wav") ? stringSoundFilePathName.substring(0, stringSoundFilePathName.length() - 4) + FILESUFFIX : stringSoundFilePathName + FILESUFFIX;
        return stringGraphicsFileName;
    }

    public void recalculateGraphicsFile() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.calculateSoundGraphicsFile(true);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File calculateSoundGraphicsFile(boolean p_Recalculate) {
        Object object = this.m_SyncFileAccess;
        synchronized (object) {
            if (this.m_LiveShowSoundHD == null) {
                return null;
            }
            if (this.m_AudioFormat == null) {
                return null;
            }
            this.closeFiles();
            File o_SoundFile = this.m_LiveShowSoundHD.getSoundFile();
            if (o_SoundFile == null) {
                return null;
            }
            LiveShowWaveHeader o_LiveShowWaveHeader = this.m_LiveShowSoundHD.getLiveShowWaveHeader();
            if (o_LiveShowWaveHeader == null) {
                return null;
            }
            long longFrameLength = this.m_LiveShowSoundHD.getFrameLength();
            int intSampleRate = o_LiveShowWaveHeader.getSampleRate();
            switch (intSampleRate) {
                case 48000: {
                    this.m_SampleReduction_Small = intSampleRate / 480;
                    this.m_SampleReduction_Middle = intSampleRate / 24;
                    this.m_SampleReduction_Large = intSampleRate / 2;
                    this.m_SampleReduction_Largest = intSampleRate * 2;
                    break;
                }
                case 44100: {
                    this.m_SampleReduction_Small = intSampleRate / 441;
                    this.m_SampleReduction_Middle = intSampleRate / 25;
                    this.m_SampleReduction_Large = intSampleRate / 2;
                    this.m_SampleReduction_Largest = intSampleRate * 2;
                    break;
                }
                case 32000: {
                    this.m_SampleReduction_Small = intSampleRate / 320;
                    this.m_SampleReduction_Middle = intSampleRate / 16;
                    this.m_SampleReduction_Large = intSampleRate / 2;
                    this.m_SampleReduction_Largest = intSampleRate * 2;
                    break;
                }
                case 22050: {
                    this.m_SampleReduction_Small = intSampleRate / 210;
                    this.m_SampleReduction_Middle = intSampleRate / 10;
                    this.m_SampleReduction_Large = intSampleRate / 2;
                    this.m_SampleReduction_Largest = intSampleRate * 2;
                }
            }
            int intBitsPerSample = o_LiveShowWaveHeader.getBitsPerSample();
            this.m_SampleBytes = intBitsPerSample / 8;
            int intBlockAlign = o_LiveShowWaveHeader.getBlockAlign();
            this.m_Channels = o_LiveShowWaveHeader.getChannels();
            this.m_RandomAccessFile = this.m_LiveShowSoundHD.createReadableRandomAccessFile();
            if (this.m_RandomAccessFile == null) {
                return null;
            }
            String stringGraphicsFilePath = this.calculateGraphicsFilePath(this.m_LiveShowSoundHD);
            this.m_GraphicsFile = new File(stringGraphicsFilePath);
            if (this.m_GraphicsFile.exists()) {
                this.m_GraphicsHeader = GraphicsHeader.readGraphicsHeader(this.m_GraphicsFile);
                boolean boolValidGraphicsFile = false;
                if (this.m_GraphicsHeader != null) {
                    boolValidGraphicsFile = true;
                    if (longFrameLength != this.m_GraphicsHeader.getSoundFileFrameLength()) {
                        boolValidGraphicsFile = false;
                    } else if (intSampleRate != this.m_GraphicsHeader.getSoundFileSampleRate()) {
                        boolValidGraphicsFile = false;
                    } else if (this.m_Channels != this.m_GraphicsHeader.getSoundFileChannels()) {
                        boolValidGraphicsFile = false;
                    } else if (o_SoundFile.lastModified() != this.m_GraphicsHeader.getSoundFileLastModifiction()) {
                        boolValidGraphicsFile = false;
                    } else if (this.m_SampleReduction_Largest != this.m_GraphicsHeader.getSampleRateReduction_Largest()) {
                        boolValidGraphicsFile = false;
                    } else if (this.m_SampleReduction_Large != this.m_GraphicsHeader.getSampleRateReduction_Large()) {
                        boolValidGraphicsFile = false;
                    } else if (this.m_SampleReduction_Middle != this.m_GraphicsHeader.getSampleRateReduction_Middle()) {
                        boolValidGraphicsFile = false;
                    } else if (this.m_SampleReduction_Small != this.m_GraphicsHeader.getSampleRateReduction_Small()) {
                        boolValidGraphicsFile = false;
                    }
                }
                if (boolValidGraphicsFile && !p_Recalculate) {
                    try {
                        this.readDataToBuffer(this.m_GraphicsFile);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    return this.m_GraphicsFile;
                }
            }
            int intBytesPerFrame = this.m_SampleBytes * this.m_Channels;
            short[] arrayChannelsMaxValue = new short[this.m_Channels];
            short[] arrayChannelsMinValue = new short[this.m_Channels];
            short shortSampleValue = 0;
            int intBytesRead = 0;
            int intBytesReadCount = 0;
            try {
                if (this.m_GraphicsFile.exists()) {
                    this.m_GraphicsFile.delete();
                }
                this.m_GraphicsFile.createNewFile();
                this.m_GraphicsFile.setReadable(true, false);
                this.m_GraphicsFile.setWritable(true, false);
                this.m_GraphicRandomAccessFile = new RandomAccessFile(this.m_GraphicsFile, "rw");
            }
            catch (Exception e) {
                return null;
            }
            this.m_GraphicsHeader = new GraphicsHeader(this.m_LiveShowSoundHD.getSoundFile().lastModified(), intSampleRate, this.m_Channels, longFrameLength, this.m_SampleReduction_Largest, this.m_SampleReduction_Large, this.m_SampleReduction_Middle, this.m_SampleReduction_Small, 0L, 0L, 0L, 0L);
            if (!GraphicsHeader.writeGraphicsHeader(this.m_GraphicsFile, this.m_GraphicsHeader)) {
                return null;
            }
            try {
                this.m_GraphicRandomAccessFile.seek(76L);
                ByteBuffer o_ByteBufferGraphicCluster = ByteBuffer.allocate(4 * this.m_Channels);
                o_ByteBufferGraphicCluster.order(ByteOrder.LITTLE_ENDIAN);
                for (int intReduction = 0; intReduction <= 3; ++intReduction) {
                    int intSampleReduction = intReduction == 0 ? this.m_SampleReduction_Largest : (intReduction == 1 ? this.m_SampleReduction_Large : (intReduction == 2 ? this.m_SampleReduction_Middle : this.m_SampleReduction_Small));
                    long longFramesCount = 0L;
                    ByteBuffer o_ByteBufferSoundSamples = ByteBuffer.allocate(intBlockAlign * intSampleReduction);
                    if (this.m_AudioFormat != null) {
                        if (this.m_AudioFormat.isBigEndian()) {
                            o_ByteBufferSoundSamples.order(ByteOrder.BIG_ENDIAN);
                        } else {
                            o_ByteBufferSoundSamples.order(ByteOrder.LITTLE_ENDIAN);
                        }
                    } else {
                        o_ByteBufferSoundSamples.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    this.m_RandomAccessFile.seek(this.m_LiveShowSoundHD.getFirstDataBytePosition());
                    for (long intFrameBlock = 0L; intFrameBlock < longFrameLength; intFrameBlock += (long)intSampleReduction) {
                        int intChannel;
                        for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                            arrayChannelsMinValue[intChannel] = Short.MAX_VALUE;
                            arrayChannelsMaxValue[intChannel] = Short.MIN_VALUE;
                        }
                        o_ByteBufferSoundSamples.clear();
                        intBytesRead = 0;
                        intBytesReadCount = 0;
                        while (intBytesReadCount < o_ByteBufferSoundSamples.capacity() && intBytesRead >= 0) {
                            intBytesRead = this.m_RandomAccessFile.read(o_ByteBufferSoundSamples.array());
                            if (intBytesRead <= 0) continue;
                            intBytesReadCount += intBytesRead;
                        }
                        int intFramesRead = intBytesPerFrame > 0 ? intBytesReadCount / intBytesPerFrame : 0;
                        o_ByteBufferSoundSamples.position(0);
                        for (int intFrame = 0; intFrame < intFramesRead; ++intFrame) {
                            for (int intChannel2 = 0; intChannel2 < this.m_Channels; ++intChannel2) {
                                double doubleSampleValue = 0.0;
                                if (this.m_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_FLOAT) {
                                    switch (this.m_AudioFormat.getSampleSizeInBits()) {
                                        case 32: {
                                            doubleSampleValue = o_ByteBufferSoundSamples.getFloat();
                                            break;
                                        }
                                        case 64: {
                                            doubleSampleValue = o_ByteBufferSoundSamples.getDouble();
                                        }
                                    }
                                } else if (this.m_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                                    switch (this.m_AudioFormat.getSampleSizeInBits()) {
                                        case 8: {
                                            doubleSampleValue = (double)o_ByteBufferSoundSamples.get() / 256.0;
                                            break;
                                        }
                                        case 16: {
                                            shortSampleValue = o_ByteBufferSoundSamples.getShort();
                                            doubleSampleValue = (double)shortSampleValue / 32768.0;
                                            break;
                                        }
                                        case 24: {
                                            int intSampleValue;
                                            byte byteSampleValue;
                                            if (this.m_AudioFormat.isBigEndian()) {
                                                byteSampleValue = o_ByteBufferSoundSamples.get();
                                                intSampleValue = (byteSampleValue & 0xFF) << 24;
                                                byteSampleValue = o_ByteBufferSoundSamples.get();
                                                intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                                byteSampleValue = o_ByteBufferSoundSamples.get();
                                                doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 8) / 2.147483648E9;
                                                break;
                                            }
                                            byteSampleValue = o_ByteBufferSoundSamples.get();
                                            intSampleValue = (byteSampleValue & 0xFF) << 8;
                                            byteSampleValue = o_ByteBufferSoundSamples.get();
                                            intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                            byteSampleValue = o_ByteBufferSoundSamples.get();
                                            doubleSampleValue = (double)(intSampleValue |= (byteSampleValue & 0xFF) << 24) / 2.147483648E9;
                                            break;
                                        }
                                        case 32: {
                                            doubleSampleValue = (double)o_ByteBufferSoundSamples.getInt() / 2.147483648E9;
                                            break;
                                        }
                                        case 64: {
                                            doubleSampleValue = (double)o_ByteBufferSoundSamples.getLong() / 9.223372036854776E18;
                                        }
                                    }
                                } else {
                                    doubleSampleValue = this.m_AudioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED ? 0.0 : 0.0;
                                }
                                shortSampleValue = (short)(doubleSampleValue * 32767.0);
                                if (arrayChannelsMinValue[intChannel2] > shortSampleValue) {
                                    arrayChannelsMinValue[intChannel2] = shortSampleValue;
                                }
                                if (arrayChannelsMaxValue[intChannel2] >= shortSampleValue) continue;
                                arrayChannelsMaxValue[intChannel2] = shortSampleValue;
                            }
                        }
                        ++longFramesCount;
                        o_ByteBufferGraphicCluster.clear();
                        for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                            o_ByteBufferGraphicCluster.putShort(arrayChannelsMinValue[intChannel]);
                            o_ByteBufferGraphicCluster.putShort(arrayChannelsMaxValue[intChannel]);
                        }
                        o_ByteBufferGraphicCluster.position(0);
                        this.m_GraphicRandomAccessFile.write(o_ByteBufferGraphicCluster.array());
                    }
                    if (intReduction == 0) {
                        this.m_GraphicsHeader.setFramesCountReduction_Largest(longFramesCount);
                        continue;
                    }
                    if (intReduction == 1) {
                        this.m_GraphicsHeader.setFramesCountReduction_Large(longFramesCount);
                        continue;
                    }
                    if (intReduction == 2) {
                        this.m_GraphicsHeader.setFramesCountReduction_Middle(longFramesCount);
                        continue;
                    }
                    this.m_GraphicsHeader.setFramesCountReduction_Small(longFramesCount);
                }
                this.m_GraphicRandomAccessFile.close();
                GraphicsHeader.writeGraphicsHeader(this.m_GraphicsFile, this.m_GraphicsHeader);
                this.readDataToBuffer(this.m_GraphicsFile);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.m_GraphicsFile;
    }

    private boolean readDataToBuffer(File p_GraphicsFile) {
        boolean boolLoadOk = true;
        FileInputStream o_FileInputStream = null;
        try {
            if (this.m_GrafikByteBuffer != null) {
                this.m_GrafikByteBuffer.clear();
            }
            this.m_GrafikByteBuffer = ByteBuffer.allocate((int)this.m_GraphicsFile.length());
            this.m_GrafikByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            o_FileInputStream = new FileInputStream(p_GraphicsFile);
            int intBytesRead = 0;
            int intBytesReadCount = 0;
            while ((long)intBytesRead < p_GraphicsFile.length() && intBytesRead >= 0) {
                intBytesRead = o_FileInputStream.read(this.m_GrafikByteBuffer.array());
                if (intBytesRead <= 0) continue;
                intBytesReadCount += intBytesRead;
            }
            if ((long)intBytesReadCount < this.m_GraphicsFile.length()) {
                boolLoadOk = false;
            }
        }
        catch (Exception e) {
            boolLoadOk = false;
        }
        try {
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_GrafikByteBuffer.position(0);
        return boolLoadOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GraphicsFrame> getGraphicFrames(ArrayList<GraphicsFrame> p_GraphicsFrames, int p_PointStart, int p_PointEnd, long p_SoundFileFrameStart, long p_SoundFileFrameEnd) {
        if (this.m_LiveShowSoundHD == null) {
            return null;
        }
        if (p_GraphicsFrames == null) {
            return null;
        }
        AudioFormat o_AudioFormat = this.m_LiveShowSoundHD.getAudioFormat();
        if (o_AudioFormat == null) {
            return null;
        }
        Object object = this.m_SyncFileAccess;
        synchronized (object) {
            long longBufferFrameEnd;
            long longBufferFrameStart;
            if (this.m_GraphicsHeader == null) {
                return null;
            }
            int intPointsCount = p_PointEnd - p_PointStart;
            if (intPointsCount <= 0) {
                return null;
            }
            double doubleSoundFramesPerPoint = (double)(p_SoundFileFrameEnd - p_SoundFileFrameStart) / (double)intPointsCount;
            long longByteStart = 0L;
            long longByteEnd = 0L;
            int intArrayListIndex = -1;
            int intOldArrayListIndex = -1;
            GraphicsFrame o_GraphicsFrame = null;
            if (doubleSoundFramesPerPoint < (double)this.m_GraphicsHeader.getSampleRateReduction_Small()) {
                long longFrameStart = p_SoundFileFrameStart;
                long longFrameEnd = p_SoundFileFrameEnd;
                long longFrameLength = longFrameEnd - longFrameStart;
                double doubleFramesPerPoint = (double)longFrameLength / (double)intPointsCount;
                if (longFrameEnd > this.m_GraphicsHeader.getSoundFileFrameLength()) {
                    longFrameEnd = this.m_GraphicsHeader.getSoundFileFrameLength();
                }
                if (doubleFramesPerPoint <= 0.0) {
                    return null;
                }
                if (longFrameStart < this.m_GraphicsHeader.getSoundFileFrameLength()) {
                    longByteStart = this.m_LiveShowSoundHD.getFirstDataBytePosition() + longFrameStart * (long)this.m_LiveShowSoundHD.getLiveShowWaveHeader().getBlockAlign();
                    try {
                        this.m_RandomAccessFile.seek(longByteStart);
                        for (long intGraphicFileFrame = longFrameStart; intGraphicFileFrame < longFrameEnd; ++intGraphicFileFrame) {
                            int intChannel;
                            intArrayListIndex = (int)((double)(intGraphicFileFrame - longFrameStart) / doubleFramesPerPoint);
                            if (intArrayListIndex != intOldArrayListIndex) {
                                o_GraphicsFrame = p_GraphicsFrames.get(intArrayListIndex);
                                for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                                    o_GraphicsFrame.setChannelMinValue(intChannel, (short)Short.MAX_VALUE);
                                    o_GraphicsFrame.setChannelMaxValue(intChannel, (short)Short.MIN_VALUE);
                                }
                                intOldArrayListIndex = intArrayListIndex;
                            }
                            for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                                short shortSampleValue;
                                this.m_ByteBuffer_GraphicsFramea.clear();
                                int intBytesRead = 0;
                                int intBytesReadCount = 0;
                                while (intBytesReadCount < this.m_SampleBytes && intBytesRead >= 0) {
                                    intBytesRead = this.m_RandomAccessFile.read(this.m_ByteBuffer_GraphicsFramea.array(), 0, this.m_SampleBytes);
                                    if (intBytesRead > 0) {
                                        intBytesReadCount += intBytesRead;
                                    }
                                    if (intBytesRead >= 0) continue;
                                    int intByte = intBytesReadCount;
                                    while (intByte < this.m_SampleBytes) {
                                        this.m_ByteBuffer_GraphicsFramea.put((byte)0);
                                        ++intBytesRead;
                                    }
                                    intBytesReadCount = this.m_SampleBytes;
                                }
                                this.m_ByteBuffer_GraphicsFramea.position(0);
                                switch (this.m_SampleBytes) {
                                    case 1: {
                                        shortSampleValue = (short)((this.m_ByteBuffer_GraphicsFramea.get() & 0xFF) * 256);
                                        break;
                                    }
                                    case 2: {
                                        shortSampleValue = this.m_ByteBuffer_GraphicsFramea.getShort();
                                        break;
                                    }
                                    case 3: {
                                        int intSampleValue;
                                        byte byteSampleValue;
                                        if (o_AudioFormat.isBigEndian()) {
                                            byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                            intSampleValue = (byteSampleValue & 0xFF) << 24;
                                            byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                            intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                            byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                            shortSampleValue = (short)((intSampleValue |= (byteSampleValue & 0xFF) << 8) / 32768);
                                            break;
                                        }
                                        byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                        intSampleValue = (byteSampleValue & 0xFF) << 8;
                                        byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                        intSampleValue |= (byteSampleValue & 0xFF) << 16;
                                        byteSampleValue = this.m_ByteBuffer_GraphicsFramea.get();
                                        shortSampleValue = (short)((intSampleValue |= (byteSampleValue & 0xFF) << 24) / 32768);
                                        break;
                                    }
                                    case 4: {
                                        shortSampleValue = (short)(this.m_ByteBuffer_GraphicsFramea.getInt() / 32768);
                                        break;
                                    }
                                    case 8: {
                                        shortSampleValue = (short)((double)this.m_ByteBuffer_GraphicsFramea.getLong() / 1.40737488355328E14);
                                        break;
                                    }
                                    default: {
                                        shortSampleValue = 0;
                                    }
                                }
                                if (o_GraphicsFrame.getChannelMinValue(intChannel) > shortSampleValue) {
                                    o_GraphicsFrame.setChannelMinValue(intChannel, shortSampleValue);
                                }
                                if (o_GraphicsFrame.getChannelMaxValue(intChannel) >= shortSampleValue) continue;
                                o_GraphicsFrame.setChannelMaxValue(intChannel, shortSampleValue);
                            }
                        }
                    }
                    catch (Exception intGraphicFileFrame) {
                        // empty catch block
                    }
                }
                for (int intFrame = ++intArrayListIndex; intFrame < p_GraphicsFrames.size(); ++intFrame) {
                    o_GraphicsFrame = p_GraphicsFrames.get(intFrame);
                    if (o_GraphicsFrame == null) continue;
                    for (int intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                        o_GraphicsFrame.setChannelMinValue(intChannel, (short)0);
                        o_GraphicsFrame.setChannelMaxValue(intChannel, (short)0);
                    }
                }
                return p_GraphicsFrames;
            }
            int intSampleReduction = 1;
            if (doubleSoundFramesPerPoint < (double)this.m_GraphicsHeader.getSampleRateReduction_Middle()) {
                intSampleReduction = this.m_GraphicsHeader.getSampleRateReduction_Small();
                longBufferFrameStart = this.m_GraphicsHeader.getFramesCountReduction_Largest() + this.m_GraphicsHeader.getFramesCountReduction_Large() + this.m_GraphicsHeader.getFramesCountReduction_Middle();
                longBufferFrameEnd = longBufferFrameStart + this.m_GraphicsHeader.getFramesCountReduction_Small();
            } else if (doubleSoundFramesPerPoint < (double)this.m_GraphicsHeader.getSampleRateReduction_Large()) {
                intSampleReduction = this.m_GraphicsHeader.getSampleRateReduction_Middle();
                longBufferFrameStart = this.m_GraphicsHeader.getFramesCountReduction_Largest() + this.m_GraphicsHeader.getFramesCountReduction_Large();
                longBufferFrameEnd = longBufferFrameStart + this.m_GraphicsHeader.getFramesCountReduction_Middle();
            } else if (doubleSoundFramesPerPoint < (double)this.m_GraphicsHeader.getSampleRateReduction_Largest()) {
                intSampleReduction = this.m_GraphicsHeader.getSampleRateReduction_Large();
                longBufferFrameStart = this.m_GraphicsHeader.getFramesCountReduction_Largest();
                longBufferFrameEnd = longBufferFrameStart + this.m_GraphicsHeader.getFramesCountReduction_Large();
            } else {
                intSampleReduction = this.m_GraphicsHeader.getSampleRateReduction_Largest();
                longBufferFrameStart = 0L;
                longBufferFrameEnd = longBufferFrameStart + this.m_GraphicsHeader.getFramesCountReduction_Largest();
            }
            long longFrameStart = p_SoundFileFrameStart / (long)intSampleReduction;
            long longFrameEnd = p_SoundFileFrameEnd / (long)intSampleReduction;
            long longFrameLength = longFrameEnd - longFrameStart;
            double doubleFramesPerPoint = (double)longFrameLength / (double)intPointsCount;
            if (doubleFramesPerPoint <= 0.0) {
                return null;
            }
            if (p_SoundFileFrameEnd > this.m_GraphicsHeader.getSoundFileFrameLength()) {
                p_SoundFileFrameEnd = this.m_GraphicsHeader.getSoundFileFrameLength();
            }
            longFrameEnd = p_SoundFileFrameEnd / (long)intSampleReduction;
            longByteStart = 76L + longBufferFrameStart * 2L * 2L * (long)this.m_Channels + longFrameStart * 2L * 2L * (long)this.m_Channels;
            longByteEnd = 76L + longBufferFrameEnd * 2L * 2L * (long)this.m_Channels + longFrameEnd * 2L * 2L * (long)this.m_Channels;
            if (p_SoundFileFrameStart < this.m_GraphicsHeader.getSoundFileFrameLength()) {
                try {
                    this.m_GrafikByteBuffer.position((int)longByteStart);
                    for (long intGraphicFileFrame = longFrameStart; intGraphicFileFrame < longFrameEnd; ++intGraphicFileFrame) {
                        int intChannel;
                        intArrayListIndex = (int)((double)(intGraphicFileFrame - longFrameStart) / doubleFramesPerPoint);
                        if (intArrayListIndex != intOldArrayListIndex) {
                            if (intArrayListIndex >= p_GraphicsFrames.size()) break;
                            o_GraphicsFrame = p_GraphicsFrames.get(intArrayListIndex);
                            if (o_GraphicsFrame == null) continue;
                            for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                                o_GraphicsFrame.setChannelMinValue(intChannel, (short)Short.MAX_VALUE);
                                o_GraphicsFrame.setChannelMaxValue(intChannel, (short)Short.MIN_VALUE);
                            }
                            intOldArrayListIndex = intArrayListIndex;
                        }
                        for (intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                            short shortSampleValue = this.m_GrafikByteBuffer.getShort();
                            if (o_GraphicsFrame.getChannelMinValue(intChannel) > shortSampleValue) {
                                o_GraphicsFrame.setChannelMinValue(intChannel, shortSampleValue);
                            }
                            shortSampleValue = this.m_GrafikByteBuffer.getShort();
                            if (o_GraphicsFrame.getChannelMaxValue(intChannel) >= shortSampleValue) continue;
                            o_GraphicsFrame.setChannelMaxValue(intChannel, shortSampleValue);
                        }
                    }
                }
                catch (Exception intChannel) {
                    // empty catch block
                }
            }
            for (int intFrame = ++intArrayListIndex; intFrame < p_GraphicsFrames.size(); ++intFrame) {
                o_GraphicsFrame = p_GraphicsFrames.get(intFrame);
                if (o_GraphicsFrame == null) continue;
                for (int intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                    o_GraphicsFrame.setChannelMinValue(intChannel, (short)0);
                    o_GraphicsFrame.setChannelMaxValue(intChannel, (short)0);
                }
            }
            return p_GraphicsFrames;
        }
    }

    public File getGraphicsFile() {
        return this.m_GraphicsFile;
    }

    public static class GraphicsFrame {
        private int m_ChannelsCount;
        private int m_FrameBytesCount;
        private short[] m_ChannelsMinValue;
        private short[] m_ChannelsMaxValue;

        public GraphicsFrame(int p_ChannelsCount) {
            this.m_ChannelsCount = p_ChannelsCount;
            this.m_FrameBytesCount = 4 * this.m_ChannelsCount;
            this.m_ChannelsMinValue = new short[this.m_ChannelsCount];
            this.m_ChannelsMaxValue = new short[this.m_ChannelsCount];
            for (int intChannel = 0; intChannel < this.m_ChannelsCount; ++intChannel) {
                this.m_ChannelsMinValue[intChannel] = 0;
                this.m_ChannelsMaxValue[intChannel] = 0;
            }
        }

        public int getFramesByteCount() {
            return this.m_FrameBytesCount;
        }

        public short getChannelMinValue(int p_Channel) {
            if (p_Channel < 0 || p_Channel >= this.m_ChannelsCount) {
                return 0;
            }
            return this.m_ChannelsMinValue[p_Channel];
        }

        public void setChannelMinValue(int p_Channel, short p_MinValue) {
            if (p_Channel < 0 || p_Channel >= this.m_ChannelsCount) {
                return;
            }
            this.m_ChannelsMinValue[p_Channel] = p_MinValue;
        }

        public short getChannelMaxValue(int p_Channel) {
            if (p_Channel < 0 || p_Channel >= this.m_ChannelsCount) {
                return 0;
            }
            return this.m_ChannelsMaxValue[p_Channel];
        }

        public void setChannelMaxValue(int p_Channel, short p_MaxValue) {
            if (p_Channel < 0 || p_Channel >= this.m_ChannelsCount) {
                return;
            }
            this.m_ChannelsMaxValue[p_Channel] = p_MaxValue;
        }
    }

    public static class GraphicsHeader {
        private static final int GRAPHICSHEADERVERSION = 1;
        private static final int GRAPHICSHEADERSIZE = 76;
        private long m_SoundFileLastModification;
        private int m_SoundFileSampleRate;
        private int m_SoundChannels;
        private long m_SoundFileFrameLength;
        private int m_SampleRateReduction_Largest;
        private int m_SampleRateReduction_Large;
        private int m_SampleRateReduction_Middle;
        private int m_SampleRateReduction_Small;
        private long m_FramesCountReduction_Largest;
        private long m_FramesCountReduction_Large;
        private long m_FramesCountReduction_Middle;
        private long m_FramesCountReduction_Small;

        public GraphicsHeader(long p_SoundFileLastModification, int p_SoundFileSampleRate, int p_SoundChannels, long p_SoundFileFrameLength, int p_SampleRateReduction_Largest, int p_SampleRateReduction_Large, int p_SampleRateReduction_Middle, int p_SampleRateReduction_Small, long p_FramesCountReduction_Largest, long p_FramesCountReduction_Large, long p_FramesCountReduction_Middle, long p_FramesCountReduction_Small) {
            this.m_SoundFileLastModification = p_SoundFileLastModification;
            this.m_SoundFileSampleRate = p_SoundFileSampleRate;
            this.m_SoundChannels = p_SoundChannels;
            this.m_SoundFileFrameLength = p_SoundFileFrameLength;
            this.m_SampleRateReduction_Largest = p_SampleRateReduction_Largest;
            this.m_SampleRateReduction_Large = p_SampleRateReduction_Large;
            this.m_SampleRateReduction_Middle = p_SampleRateReduction_Middle;
            this.m_SampleRateReduction_Small = p_SampleRateReduction_Small;
            this.m_FramesCountReduction_Largest = p_FramesCountReduction_Largest;
            this.m_FramesCountReduction_Large = p_FramesCountReduction_Large;
            this.m_FramesCountReduction_Middle = p_FramesCountReduction_Middle;
            this.m_FramesCountReduction_Small = p_FramesCountReduction_Small;
        }

        public void setSoundFileLastModification(long p_SoundFileLastModification) {
            this.m_SoundFileLastModification = p_SoundFileLastModification;
        }

        public long getSoundFileLastModifiction() {
            return this.m_SoundFileLastModification;
        }

        public int getSoundFileSampleRate() {
            return this.m_SoundFileSampleRate;
        }

        public int getSoundFileChannels() {
            return this.m_SoundChannels;
        }

        public long getSoundFileFrameLength() {
            return this.m_SoundFileFrameLength;
        }

        public int getSampleRateReduction_Largest() {
            return this.m_SampleRateReduction_Largest;
        }

        public int getSampleRateReduction_Large() {
            return this.m_SampleRateReduction_Large;
        }

        public int getSampleRateReduction_Middle() {
            return this.m_SampleRateReduction_Middle;
        }

        public int getSampleRateReduction_Small() {
            return this.m_SampleRateReduction_Small;
        }

        public void setFramesCountReduction_Largest(long p_FramesCountReduction_Largest) {
            this.m_FramesCountReduction_Largest = p_FramesCountReduction_Largest;
        }

        public long getFramesCountReduction_Largest() {
            return this.m_FramesCountReduction_Largest;
        }

        public void setFramesCountReduction_Large(long p_FramesCountReduction_Large) {
            this.m_FramesCountReduction_Large = p_FramesCountReduction_Large;
        }

        public long getFramesCountReduction_Large() {
            return this.m_FramesCountReduction_Large;
        }

        public void setFramesCountReduction_Middle(long p_FramesCountReduction_Middle) {
            this.m_FramesCountReduction_Middle = p_FramesCountReduction_Middle;
        }

        public long getFramesCountReduction_Middle() {
            return this.m_FramesCountReduction_Middle;
        }

        public void setFramesCountReduction_Small(long p_FramesCountReduction_Small) {
            this.m_FramesCountReduction_Small = p_FramesCountReduction_Small;
        }

        public long getFramesCountReduction_Small() {
            return this.m_FramesCountReduction_Small;
        }

        public static GraphicsHeader readGraphicsHeader(File p_GraphicsFile) {
            if (p_GraphicsFile == null) {
                return null;
            }
            if (!p_GraphicsFile.exists()) {
                return null;
            }
            FileInputStream o_FileInputStream = null;
            GraphicsHeader o_LiveShowSoundGraphicsHeader = null;
            try {
                ByteBuffer o_ByteBuffer = ByteBuffer.allocate(76);
                o_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                o_FileInputStream = new FileInputStream(p_GraphicsFile);
                int intBytesRead = 0;
                int intBytesReadCount = 0;
                while (intBytesRead < 76 && intBytesRead >= 0) {
                    intBytesRead = o_FileInputStream.read(o_ByteBuffer.array());
                    if (intBytesRead <= 0) continue;
                    intBytesReadCount += intBytesRead;
                }
                if (intBytesReadCount < 76) {
                    return null;
                }
                o_ByteBuffer.position(0);
                int intVersion = o_ByteBuffer.getInt();
                long longSoundFileDate = o_ByteBuffer.getLong();
                int intSoundFileSampleRate = o_ByteBuffer.getInt();
                int intSoundFileChannels = o_ByteBuffer.getInt();
                long longSoundFileFrameLength = o_ByteBuffer.getLong();
                int intSampleRateReduction_Largest = o_ByteBuffer.getInt();
                int intSampleRateReduction_Large = o_ByteBuffer.getInt();
                int intSampleRateReduction_Middle = o_ByteBuffer.getInt();
                int intSampleRateReduction_Small = o_ByteBuffer.getInt();
                long longFramesCountReduction_Largest = o_ByteBuffer.getLong();
                long longFramesCountReduction_Large = o_ByteBuffer.getLong();
                long longFramesCountReduction_Middle = o_ByteBuffer.getLong();
                long longFramesCountReduction_Small = o_ByteBuffer.getLong();
                o_LiveShowSoundGraphicsHeader = new GraphicsHeader(longSoundFileDate, intSoundFileSampleRate, intSoundFileChannels, longSoundFileFrameLength, intSampleRateReduction_Largest, intSampleRateReduction_Large, intSampleRateReduction_Middle, intSampleRateReduction_Small, longFramesCountReduction_Largest, longFramesCountReduction_Large, longFramesCountReduction_Middle, longFramesCountReduction_Small);
                o_FileInputStream.close();
                return o_LiveShowSoundGraphicsHeader;
            }
            catch (Exception e) {
                try {
                    if (o_FileInputStream != null) {
                        o_FileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }

        public static boolean writeGraphicsHeader(File p_GraphicsFile, GraphicsHeader p_LiveShowSoundGraphicsHeader) {
            if (p_GraphicsFile == null) {
                return false;
            }
            if (p_LiveShowSoundGraphicsHeader == null) {
                return false;
            }
            RandomAccessFile o_RandomAccessFile = null;
            try {
                o_RandomAccessFile = new RandomAccessFile(p_GraphicsFile, "rw");
                o_RandomAccessFile.seek(0L);
                ByteBuffer o_ByteBuffer = ByteBuffer.allocate(76);
                o_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                o_ByteBuffer.putInt(1);
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getSoundFileLastModifiction());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSoundFileSampleRate());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSoundFileChannels());
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getSoundFileFrameLength());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSampleRateReduction_Largest());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSampleRateReduction_Large());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSampleRateReduction_Middle());
                o_ByteBuffer.putInt(p_LiveShowSoundGraphicsHeader.getSampleRateReduction_Small());
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getFramesCountReduction_Largest());
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getFramesCountReduction_Large());
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getFramesCountReduction_Middle());
                o_ByteBuffer.putLong(p_LiveShowSoundGraphicsHeader.getFramesCountReduction_Small());
                o_RandomAccessFile.write(o_ByteBuffer.array());
                o_RandomAccessFile.close();
                return true;
            }
            catch (Exception e) {
                try {
                    o_RandomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
    }
}

