/*
 * Decompiled with CFR 0.152.
 */
package PlaySoundPackage;

import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import OS.OSChecker;
import SoundPackage.SoundMixers;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundSceneBridge;
import SoundVirtualPackage.LiveShowSoundVIP;
import StartPackage.LiveShowSoundSystem;
import TimerPackage.JavaTimer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class PlaySound
extends Play
implements Runnable {
    public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/PlaySound.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static int BUFFER_MILLISECONDS = 100;
    public static int NEW_BUFFER_MILLISECONDS = 100;
    public static boolean USESINIFILE = PlaySound.readIni();
    private static boolean s_ReadIniActive = false;
    public static final Object s_SyncWriteIni = new Object();
    public static String ERROR_MIXERNOTFOUND = "No mixer defined";
    public static String ERROR_MIXERNOLINE = "Mixer has no line for declared audio format";
    private AudioFormat m_AudioFormat;
    private long m_FramePositionToWrite;
    private SoundMixers.SoundBuffer_Player m_SoundBuffer_Player;
    private SoundPlayObject m_SoundPlayObject;
    private int m_PlayObjectBufferedFrames;
    private JavaTimer m_JavaTimer;
    private final Object m_SyncObjectPlayWait = new Object();

    public static int getNewBufferMilliseconds() {
        return NEW_BUFFER_MILLISECONDS;
    }

    public static void setNewBufferMilliseconds(int p_Milliseconds) {
        NEW_BUFFER_MILLISECONDS = p_Milliseconds;
    }

    public static boolean readIni() {
        File o_FileIni = new File(INIFILE_NAME);
        if (!o_FileIni.exists()) {
            return false;
        }
        s_ReadIniActive = true;
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.equals("SoundCardBuffer_ms")) {
                        int intValue = Integer.valueOf(stringPropertyValue.trim());
                        if (intValue > 10 && intValue <= 1000) {
                            BUFFER_MILLISECONDS = intValue;
                            NEW_BUFFER_MILLISECONDS = intValue;
                            SoundMixers.BUFFERSIZE_IN_MS = intValue;
                        }
                        boolIni = true;
                    } else if (stringPropertyName.trim().equals("LastSoundOpenPath")) {
                        File o_FileLastPath = new File(stringPropertyValue);
                        if (!o_FileLastPath.exists()) {
                            o_FileLastPath = null;
                        }
                        LiveShowSoundSystem.s_LastOpenFilePath = o_FileLastPath;
                        boolIni = true;
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s_ReadIniActive = false;
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIni() {
        if (s_ReadIniActive) {
            return false;
        }
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            try {
                o_FileIni = new File(INIFILE_NAME);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("ERROR PlaySound writeIni() - delete ini file:");
                e.printStackTrace();
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SoundCardBuffer_ms");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(NEW_BUFFER_MILLISECONDS);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("time in milliseconds soundcard will buffer sounddata (default 100, for older hardware try 120)");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                String stringLastPath = null;
                File o_LastFile = LiveShowSoundSystem.s_LastOpenFilePath;
                if (o_LastFile != null) {
                    try {
                        stringLastPath = o_LastFile.getAbsolutePath();
                    }
                    catch (Exception e) {
                        stringLastPath = null;
                    }
                }
                if (stringLastPath != null) {
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append("LastSoundOpenPath");
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append(stringLastPath);
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append("the last path where a sound file is loaded");
                    o_BufferedWriter.append(stringBuilder.toString());
                    o_BufferedWriter.newLine();
                }
                boolIni = true;
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlaySound writeIni():");
                e_IOException.printStackTrace();
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlaySound close ini file():");
                e_IOException.printStackTrace();
            }
            return boolIni;
        }
    }

    public PlaySound(Playable p_Playable, AudioFormat p_AudioFormat) {
        super(p_Playable);
        this.m_Playable = p_Playable;
        this.m_AudioFormat = p_AudioFormat;
        this.initMembers();
        this.m_JavaTimer = new JavaTimer();
        LiveShowSoundSystem.addPlaySound(this);
        this.initPlayObject();
        this.setPlayCursor(this.m_FramePlayCursor);
    }

    private void initMembers() {
        this.m_SoundBuffer_Player = null;
        this.m_PlayObjectBufferedFrames = this.m_AudioFormat != null ? SoundMixers.BUFFERSIZE_FRAMES_MIXER * 2 : 1;
        this.setColor(Color.WHITE);
    }

    public boolean createOutputLine() {
        this.m_SoundBuffer_Player = SoundMixers.createSoundBuffer_Player((int)SoundMixers.BUFFERSIZE_FRAMES_PLAYBUFFER);
        this.m_HasOutputLine = true;
        return true;
    }

    public boolean closeOutputLine() {
        this.closeDataLine();
        this.m_HasOutputLine = false;
        return true;
    }

    public void close() {
        LiveShowSoundSystem.removePlaySound(this);
        super.close();
        this.m_HasOutputLine = false;
        this.m_JavaTimer.close();
    }

    public void setPlayable(Playable p_Playable, Object p_AudioFormat) {
        if (this.m_Playable == p_Playable) {
            return;
        }
        if (p_Playable == null) {
            return;
        }
        if (p_AudioFormat == null) {
            return;
        }
        if (!(p_AudioFormat instanceof AudioFormat)) {
            return;
        }
        Object o_AudioFormat = null;
        super.setPlayable(p_Playable, p_AudioFormat);
        this.m_AudioFormat = (AudioFormat)p_AudioFormat;
        if (this.m_SoundPlayObject != null) {
            this.m_SoundPlayObject.close();
        }
        this.initPlayObject();
    }

    protected void initPlayObject() {
        this.m_SoundPlayObject = new SoundPlayObject(this.getPlayable(), this.m_AudioFormat);
        this.m_SoundPlayObject.setFramesBuffered(this.m_PlayObjectBufferedFrames);
        this.m_PlayObjectBufferedFrames = SoundMixers.BUFFERSIZE_FRAMES_MIXER * 2;
        SoundPlayObject o_SoundPlayObject = this.m_SoundPlayObject;
        if (o_SoundPlayObject != null) {
            o_SoundPlayObject.setFramesBuffered(this.m_PlayObjectBufferedFrames);
        }
    }

    public Playable.PlayObject getPlayObject() {
        return this.m_SoundPlayObject;
    }

    public long getBufferDelayFrames() {
        SoundPlayObject o_SoundPlayObject = this.m_SoundPlayObject;
        if (o_SoundPlayObject == null) {
            return 0L;
        }
        return o_SoundPlayObject.getFramesBuffered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataLine() {
        if (this.m_PlayThread != null) {
            this.stopInternal();
            Object object = this.m_SyncPlay;
            synchronized (object) {
            }
        }
        if (this.m_SoundBuffer_Player != null) {
            this.m_SoundBuffer_Player.close();
        }
    }

    public AudioFormat getAudioFormat() {
        AudioFormat o_AudioFormat = null;
        Playable o_Playable = this.m_Playable;
        if (o_Playable != null) {
            o_AudioFormat = this.m_AudioFormat;
        }
        return o_AudioFormat;
    }

    public void setPlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        super.setPlayCursor(p_FramePosition);
        p_FramePosition = super.getPlayCursor();
        if (this.m_Status != 3 || this.m_StopFlag || this.m_WaitFlag) {
            LiveShowSoundObject o_LiveShowSoundObject;
            Playable o_Playable = this.m_Playable;
            if (o_Playable instanceof LiveShowSoundVIP) {
                LiveShowSoundVIP o_LiveShowSoundVIP = (LiveShowSoundVIP)o_Playable;
                ArrayList o_Hit_LiveShowSoundObjects = o_LiveShowSoundVIP.getLiveShowObjects_HitsFrame(null, p_FramePosition, true, false);
                for (int intObject = 0; intObject < o_Hit_LiveShowSoundObjects.size(); ++intObject) {
                    LiveShowSoundObject o_LiveShowSoundObject2 = (LiveShowSoundObject)((Object)o_Hit_LiveShowSoundObjects.get(intObject));
                    if (o_LiveShowSoundObject2 == null) continue;
                    o_LiveShowSoundObject2.resetPrefetchBuffer(p_FramePosition - o_LiveShowSoundObject2.getFrameStart());
                    LiveShowSoundSceneBridge o_LiveShowSoundSceneBridge = (LiveShowSoundSceneBridge)o_LiveShowSoundVIP.getLiveShowSceneBridge_Next(p_FramePosition, false, true);
                    o_LiveShowSoundObject2.resetPrefetchBuffer_SceneBridge(null, o_LiveShowSoundSceneBridge, p_FramePosition);
                }
            } else if (o_Playable instanceof LiveShowObject.LiveShowObjectOwner) {
                LiveShowSoundObject o_LiveShowSoundObject3 = (LiveShowSoundObject)((LiveShowObject.LiveShowObjectOwner)o_Playable).getLiveShowObject();
                if (o_LiveShowSoundObject3 != null) {
                    o_LiveShowSoundObject3.resetPrefetchBuffer(p_FramePosition);
                }
            } else if (o_Playable instanceof LiveShowSoundObject && (o_LiveShowSoundObject = (LiveShowSoundObject)o_Playable) != null) {
                o_LiveShowSoundObject.resetPrefetchBuffer(p_FramePosition);
            }
        }
        this.m_FramePositionToWrite = super.getPlayCursor();
        super.setPlayCursorInternal(super.getPlayCursor(), super.getPlayCursor());
    }

    public void setWaitForTrigger(boolean p_Wait) {
        super.setWaitForTrigger(p_Wait);
        if (!p_Wait) {
            // empty if block
        }
    }

    public void playFramePositionOnce(long p_FramePosition) {
        if (!this.m_IsEditModeOn) {
            Playable o_Playable;
            SoundPlayObject o_SoundPlayObject = this.m_SoundPlayObject;
            if (o_SoundPlayObject != null) {
                o_SoundPlayObject.clear();
                o_SoundPlayObject.setFramePosition(p_FramePosition);
            }
            if ((o_Playable = this.m_Playable) != null) {
                o_Playable.read((Play)this, (Playable.PlayObject)o_SoundPlayObject);
            }
        }
    }

    public void playFramePositionOnce() {
        if (!this.m_IsEditModeOn) {
            this.playFramePositionOnce(this.m_FramePlayCursor);
        } else {
            this.playFramePositionOnce(this.m_FrameEditCursor);
        }
    }

    public void letsRun() {
        if (this.getStatus() == 3) {
            return;
        }
        super.letsRun();
    }

    protected void clearPlaying() {
        SoundMixers.SoundBuffer_Player o_SoundBuffer_Player = this.m_SoundBuffer_Player;
        if (this.m_PlayThread != null && o_SoundBuffer_Player != null) {
            try {
                o_SoundBuffer_Player.stopAndDrain();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_FramesRead = -1L;
    }

    public void reworkPause() {
    }

    public void reworkStop() {
    }

    protected void fetchwriteData() {
        this.fetchwriteDataWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchwriteDataWrite() {
        SoundPlayObject o_SoundPlayObject = this.m_SoundPlayObject;
        Playable o_Playable = this.m_Playable;
        SoundMixers.SoundBuffer_Player o_SoundBuffer_Player = this.m_SoundBuffer_Player;
        if (o_SoundPlayObject == null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayPause();
                return;
            }
            this.m_StopFlag = true;
            return;
        }
        if (o_Playable == null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayPause();
                return;
            }
            this.m_StopFlag = true;
            return;
        }
        if (o_SoundBuffer_Player == null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayPause();
                return;
            }
            this.m_StopFlag = true;
            return;
        }
        o_SoundPlayObject.clear();
        if (this.m_FramePositionToWrite >= o_Playable.getFrameEndToPlay()) {
            this.m_FramePositionToWrite = o_Playable.getFrameEndToPlay();
            super.setPlayCursorInternal(o_Playable.getFrameEndToPlay(), o_Playable.getFrameEndToPlay());
            return;
        }
        long longOldFramePositionToWrite = this.m_FramePositionToWrite;
        long longFrames = o_SoundPlayObject.getFramesBuffered();
        long longFramesToRead = this.m_FramePositionToWrite + longFrames >= o_Playable.getFrameEndToPlay() ? o_Playable.getFrameEndToPlay() - this.m_FramePositionToWrite : longFrames;
        boolean boolReady = false;
        boolean boolJumpNow = false;
        while (!boolReady) {
            block24: {
                block25: {
                    if (this.m_ActualPlayJump == null || !this.m_ActualPlayJump.getJumpIsActive()) break block25;
                    if (!boolJumpNow) {
                        if (this.m_FramePositionToWrite < this.m_ActualPlayJump.getJumpFrameFrom() && this.m_FramePositionToWrite + longFramesToRead > this.m_ActualPlayJump.getJumpFrameFrom()) {
                            longFramesToRead = this.m_ActualPlayJump.getJumpFrameFrom() - this.m_FramePositionToWrite;
                            boolJumpNow = true;
                            boolReady = false;
                            break block24;
                        } else {
                            boolReady = true;
                        }
                        break block24;
                    } else {
                        this.setPlayCursor(this.m_ActualPlayJump.getJumpFrameTo());
                        boolReady = true;
                        continue;
                    }
                }
                boolReady = true;
            }
            this.setWillStopAtSceneBridge(null);
            Object object = this.m_SyncPlayListeners;
            synchronized (object) {
                for (int intListener = 0; intListener < this.m_PlayListeners.size(); ++intListener) {
                    PlayListener o_PlayListener = (PlayListener)this.m_PlayListeners.get(intListener);
                    if (o_PlayListener == null) continue;
                    long longVetoFramesToRead = o_PlayListener.eventPlayCheckRead((Play)this, this.m_FramePositionToWrite, longFramesToRead);
                    if (longVetoFramesToRead <= 0L) {
                        longVetoFramesToRead = 0L;
                    }
                    if (longVetoFramesToRead >= longFramesToRead) continue;
                    longFramesToRead = longVetoFramesToRead;
                }
            }
            o_SoundPlayObject.setFramePosition(this.m_FramePositionToWrite);
            o_SoundPlayObject.setFramesToRead(longFramesToRead);
            SoundPlayObject o_SoundPlayObjectRead = (SoundPlayObject)o_Playable.read((Play)this, (Playable.PlayObject)o_SoundPlayObject);
            if (o_SoundPlayObjectRead == null) {
                o_SoundPlayObjectRead = o_SoundPlayObject;
            }
            this.fetchWriteLiveShowObjectInterfaces_Jingle(this.m_FramePositionToWrite, longFramesToRead);
            try {
                o_SoundBuffer_Player.start();
                int intFramesBuffered = o_SoundBuffer_Player.writeFrames(o_SoundPlayObjectRead.getSoundLinesBuffer().array(), (int)o_SoundPlayObjectRead.getFramesToRead());
                if (this.m_PlayStartTime < 0L) {
                    // empty if block
                }
                this.m_FramePositionToWrite += o_SoundPlayObjectRead.getFramesToRead();
                this.setWillStopAtSceneBridge(null);
                if (this.m_FramesRead < 0L) {
                    this.m_PlayStartTime = System.nanoTime();
                    super.setPlayCursorInternal(longOldFramePositionToWrite, this.m_FramePositionToWrite);
                    return;
                }
                if (intFramesBuffered < 0) {
                    long longActualTime = (System.nanoTime() - this.m_PlayStartTime) / 1000000L;
                    long longActualTimeCalculated = (long)((double)this.m_FramesRead * o_Playable.getFrameTime());
                    long longTimeDiff = longActualTime - longActualTimeCalculated;
                    long m_FramesToReadTime = (long)((double)longFramesToRead * o_Playable.getFrameTime() + 0.5);
                    long longTimeToWait = m_FramesToReadTime - longTimeDiff;
                    if (m_FramesToReadTime > 0L && !this.m_StopFlag && !this.m_WaitFlag) {
                        this.m_JavaTimer.sleep(longTimeToWait);
                    }
                }
                super.setPlayCursorInternal(longOldFramePositionToWrite, this.m_FramePositionToWrite);
                this.m_FramesRead += longFramesToRead;
            }
            catch (Exception e) {
                if (this.m_PlaySynchronisizer != null) {
                    this.m_PlaySynchronisizer.actionPlayPause();
                    return;
                }
                this.m_StopFlag = true;
                return;
            }
        }
    }

    protected void checkFadeProgress(boolean p_NotifyListeners) {
        double doubleFadeProgress;
        boolean boolFadeInPossible = false;
        boolean boolFadeOutPossible = false;
        boolean boolFadedIn = false;
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            doubleFadeProgress = 0.0;
            boolFadeInPossible = false;
            boolFadeInPossible = false;
            boolFadedIn = false;
        } else {
            doubleFadeProgress = o_PlayObject.getFadeProgress();
            boolFadeInPossible = false;
            boolFadeOutPossible = false;
            if (this.m_Status == 1) {
                if (o_PlayObject.getFadeInProgress() < 1.0 || o_PlayObject.getFadeOutProgress() < 1.0) {
                    boolFadeInPossible = true;
                }
            } else if (o_PlayObject.getFadeInProgress() == 0.0 || o_PlayObject.getFadeOutProgress() < 1.0 && o_PlayObject.getFadeOutProgress() > 0.0) {
                boolFadeInPossible = true;
            }
            if (o_PlayObject.getFadeInProgress() == 1.0) {
                boolFadedIn = true;
            }
            if (this.m_Status == 1) {
                if (o_PlayObject.getFadeInProgress() > 0.0 || o_PlayObject.getFadeOutProgress() > 0.0) {
                    boolFadeOutPossible = true;
                }
            } else if (o_PlayObject.getFadeInProgress() > 0.0 && (o_PlayObject.getFadeOutProgress() == 0.0 || o_PlayObject.getFadeOutProgress() == 1.0)) {
                boolFadeOutPossible = true;
            }
        }
        if (this.m_FadeInPossible != boolFadeInPossible || this.m_FadeOutPossible != boolFadeOutPossible) {
            this.m_FadeInPossible = boolFadeInPossible;
            this.m_FadeOutPossible = boolFadeOutPossible;
            if (p_NotifyListeners) {
                this.notifyPlayListeners_PlayFadePossibility(this.m_FadeInPossible, this.m_FadeOutPossible, doubleFadeProgress);
            }
        }
        if (this.m_FadedIn != boolFadedIn) {
            this.m_FadedIn = boolFadedIn;
            if (this.m_FadedIn) {
                this.m_WasFadedIn = true;
            }
            this.notifyPlayListeners_PlayFadedIn(this.m_FadedIn, doubleFadeProgress);
        }
    }

    public void addLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    public void removeLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    public int getLiveShowObjectInterfaces_JingleCount() {
        return 0;
    }

    public void fetchWriteLiveShowObjectInterfaces_Jingle(long p_FramePositionToWrite, long p_FramesToRead) {
    }

    public LiveShowObjectInterface getLiveShowObjectInterface_Jingle(int p_Index) {
        return null;
    }

    public static class SoundPlayObject
    implements Playable.PlayObject {
        private static double[] s_EmptyArray;
        private Playable m_Playable;
        private long m_FramePosition;
        private long m_FramePosition_Pre;
        private long m_FramesToRead;
        private int m_BufferFramesLength;
        private AudioFormat m_AudioFormat;
        private DoubleBuffer m_SoundLinesBuffer;
        private int m_BufferLength_Samples;
        private double m_FadeProgress;
        private double m_FadeInProgress;
        private double m_FadeOutProgress;
        private final Object m_SyncBuffer = new Object();

        public SoundPlayObject(Playable p_Playable, AudioFormat p_AudioFormat) {
            this.m_Playable = p_Playable;
            this.m_AudioFormat = p_AudioFormat;
            this.initMembers();
        }

        private void initMembers() {
            this.m_FramePosition = 0L;
            this.m_FramesToRead = 0L;
            if (this.m_AudioFormat != null) {
                int intSoundLineBufferFrames = (int)((double)this.m_AudioFormat.getFrameRate() / (1000.0 / (double)BUFFER_MILLISECONDS));
                int intPlayObjectBufferedFrames = intSoundLineBufferFrames / 2;
                this.setFramesBuffered(intPlayObjectBufferedFrames);
            } else {
                this.setFramesBuffered(1);
            }
            this.m_FadeProgress = 0.0;
            this.m_FadeInProgress = 0.0;
            this.m_FadeOutProgress = 0.0;
        }

        public void close() {
        }

        public Playable getPlayable() {
            return this.m_Playable;
        }

        public Object getSyncObjectBuffer() {
            return this.m_SyncBuffer;
        }

        public void setFramePosition(long p_FramePosition) {
            this.m_FramePosition = p_FramePosition;
        }

        public long getFramePosition() {
            return this.m_FramePosition;
        }

        public void setFramePosition_Pre(long p_FramePosition) {
            this.m_FramePosition_Pre = p_FramePosition;
        }

        public long getFramePosition_Pre() {
            return this.m_FramePosition_Pre;
        }

        public void setFramesToRead(long p_FrameToRead) {
            this.m_FramesToRead = p_FrameToRead;
        }

        public long getFramesToRead() {
            return this.m_FramesToRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFramesBuffered(int p_FrameLength) {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                if (this.m_SoundLinesBuffer != null && p_FrameLength != this.m_SoundLinesBuffer.capacity() / SoundMixers.SOUND_SOUNDLINES_COUNT) {
                    this.m_SoundLinesBuffer = null;
                }
                if (this.m_SoundLinesBuffer == null) {
                    this.m_BufferFramesLength = p_FrameLength;
                    this.m_BufferLength_Samples = this.m_BufferFramesLength * SoundMixers.SOUND_SOUNDLINES_COUNT;
                    this.m_SoundLinesBuffer = DoubleBuffer.allocate(this.m_BufferLength_Samples);
                    if (s_EmptyArray == null || s_EmptyArray.length < this.m_BufferLength_Samples) {
                        s_EmptyArray = new double[this.m_BufferLength_Samples];
                        for (int intDouble = 0; intDouble < this.m_BufferLength_Samples; ++intDouble) {
                            SoundPlayObject.s_EmptyArray[intDouble] = 0.0;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFramesBuffered() {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                return this.m_BufferFramesLength;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getData() {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                return this.m_SoundLinesBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                System.arraycopy(s_EmptyArray, 0, this.m_SoundLinesBuffer.array(), 0, this.m_SoundLinesBuffer.capacity());
                this.m_SoundLinesBuffer.position(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoubleBuffer getSoundLinesBuffer() {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                return this.m_SoundLinesBuffer;
            }
        }

        public int getSoundLinesBufferLength() {
            return this.m_BufferLength_Samples;
        }

        public double getFadeProgress() {
            return this.m_FadeProgress;
        }

        public double getFadeInProgress() {
            return this.m_FadeInProgress;
        }

        public double getFadeOutProgress() {
            return this.m_FadeOutProgress;
        }

        public void setFadeInProgress(double p_FadeInProgress) {
            this.m_FadeInProgress = p_FadeInProgress;
        }

        public void setFadeOutProgress(double p_FadeOutProgress) {
            this.m_FadeOutProgress = p_FadeOutProgress;
        }

        public void setFadeProgress(double p_FadeProgress) {
            this.m_FadeProgress = p_FadeProgress;
        }

        public AudioFormat getAudioFormat() {
            return this.m_AudioFormat;
        }
    }
}

