/*
 * Decompiled with CFR 0.152.
 */
package LiveShowRemotePackage;

import ClientPackage.LiveDBClient;
import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceGroup;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXDeviceView;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_RGB;
import DMXMixer.DMXMixerPanel;
import DMXVirtualPackage.LiveShowDMXVIP;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.JControlGrid;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayListener;
import LiveShowProjectPackage.LiveShowInternalFrame_MixerMain;
import LiveShowProjectPackage.LiveShowInternalFrame_PlayJingles;
import LiveShowProjectPackage.LiveShowInternalFrame_SceneBook;
import LiveShowProjectPackage.LiveShowJingleGroup;
import LiveShowRemoteBoardPackage.JPanel_RemoteBoard;
import LiveShowRemoteBoardPackage.JPanel_RemoteBoardItem;
import LiveShowRemoteBoardPackage.LiveShowInternalFrame_RemoteBoard;
import LiveShowVirtualPackage.LiveShowSceneBookPanel;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import MainPackage.LiveShowProjectDesktop;
import MediaVirtualPackage.LiveShowMediaVIP;
import Messages.Message_DMXControlComponent;
import Messages.Message_DMXControlComponentFunction;
import Messages.Message_DMXControlComponentLabelList;
import Messages.Message_DMXControlComponentRemoved;
import Messages.Message_DMXControlComponentValue;
import Messages.Message_DMXControlComponentVisible;
import Messages.Message_DMXControlGroupsChangeType;
import Messages.Message_DMXDevice;
import Messages.Message_DMXDeviceGroup;
import Messages.Message_DMXDeviceGroupRemoved;
import Messages.Message_DMXDeviceGroupSelected;
import Messages.Message_DMXDeviceRemoved;
import Messages.Message_DMXUniverse;
import Messages.Message_DMXUniverseRemoved;
import Messages.Message_JingleAdded;
import Messages.Message_JingleChanged;
import Messages.Message_JinglePlayControlStatus;
import Messages.Message_JinglePlay_FadeIn;
import Messages.Message_JinglePlay_FadeOut;
import Messages.Message_JinglePlay_Pause;
import Messages.Message_JinglePlay_Start;
import Messages.Message_JinglePlay_Stop;
import Messages.Message_JingleRemoved;
import Messages.Message_JinglesGroupAdded;
import Messages.Message_JinglesGroupChanged;
import Messages.Message_JinglesGroupPlayControlStatus;
import Messages.Message_JinglesGroupPlay_FadeIn;
import Messages.Message_JinglesGroupPlay_FadeOut;
import Messages.Message_JinglesGroupPlay_Pause;
import Messages.Message_JinglesGroupPlay_Start;
import Messages.Message_JinglesGroupPlay_Stop;
import Messages.Message_JinglesGroupRemoved;
import Messages.Message_Login;
import Messages.Message_LoginFailed;
import Messages.Message_LoginOK;
import Messages.Message_Master_Change;
import Messages.Message_Permission;
import Messages.Message_PlayNextBridge;
import Messages.Message_PlayNextMainBridge;
import Messages.Message_PlayNextPreviousBridge;
import Messages.Message_PlayPreviousMainBridge;
import Messages.Message_PlayRewind;
import Messages.Message_PlaySceneBridge;
import Messages.Message_Play_FromStart;
import Messages.Message_Play_Pause;
import Messages.Message_Play_PauseDMX;
import Messages.Message_Play_PauseMedia;
import Messages.Message_Play_PauseSound;
import Messages.Message_Play_Start;
import Messages.Message_Play_StartDMX;
import Messages.Message_Play_StartMedia;
import Messages.Message_Play_StartSound;
import Messages.Message_Play_Stop;
import Messages.Message_RemoteBoardItemChanged;
import Messages.Message_RemoteBoardItemPlayStatus;
import Messages.Message_RemoteBoardItem_DoAction;
import Messages.Message_Request_Language;
import Messages.Message_Request_SceneBook;
import Messages.Message_Request_Status_DMXStageView;
import Messages.Message_Request_Status_Jingle;
import Messages.Message_Request_Status_Master;
import Messages.Message_Request_Status_Play;
import Messages.Message_Request_Status_RemoteBoard;
import Messages.Message_SceneBridgeChanged;
import Messages.Message_Scenebook;
import Messages.Message_Status_DMXStageView;
import Messages.Message_Status_Jingle;
import Messages.Message_Status_JingleGroup;
import Messages.Message_Status_Language;
import Messages.Message_Status_Master;
import Messages.Message_Status_Play;
import Messages.Message_Status_RemoteBoard;
import Messages.Message_Status_SceneBridgeCursor;
import Messages.Message_Status_TimeWarning1;
import Messages.Message_Status_TimeWarning2;
import OS.OSChecker;
import ServerAutoDetectPackage.ServerAutoDetect_Server;
import ServerKernelPackage.LiveDBServerKernel;
import ServerKernelPackage.LiveDBServerKernelListener;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SoundVirtualPackage.LiveShowSoundVIP;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabel_ResizeFrame;
import ToolsGraphics.LiveShowHTMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class LiveShowInternalFrame_RemoteServer
extends JInternalFrame
implements LiveDBServerKernelListener,
Externalizable,
ListSelectionListener {
    public static final int SOFTWAREVERSION = 2;
    public static LiveShowInternalFrame_RemoteServer s_SelfReference = null;
    public static int DEFAULT_WATCHDOGCONNECTION_TIME = 10000;
    @LiveLanguageString
    public static String s_Direction_Scene_Start = "Scene";
    @LiveLanguageString
    public static String s_Direction_Scene_End = "started";
    @LiveLanguageString
    public static String s_Direction_Pre_Start = "The next scene is";
    @LiveLanguageString
    public static String s_Direction_Pre_End = "";
    @LiveLanguageString
    public static String s_Direction_Post_Start = "";
    @LiveLanguageString
    public static String s_Direction_Post_End = "";
    public static long s_NextSceneLatency = 2000L;
    private String m_ServerID;
    private String m_ServerIP;
    private int m_ServerPort;
    private boolean m_ServerConnected;
    private StringBuilder m_ServerIPAddresses;
    private Runnable m_RunnableServerIPs;
    private boolean m_StopServerIPs;
    private final Object m_SyncServerIPs = new Object();
    private RemoteUserDescriptionTableModel m_RemoteUserDescriptionTableModel;
    private ListSelectionModel m_RemoteUserDescription_SelectionModel;
    private TableAndListModel.ListModel<RemoteUser> m_RemoteUsers;
    private RemoteUserCellRenderer m_RemoteUserCellRenderer;
    private final Object m_SyncRemoteUser = new Object();
    private RemoteController m_RemoteController;
    public static Color s_Foreground_Normal = Color.WHITE;
    public static Color s_Foreground_Disabled = Color.GRAY;
    private JButton jButton_AddNewRegisteredUser;
    private JButton jButton_RemoveRegisteredUser;
    private JButton jButton_StartRemoteServer;
    private JButton jButton_StopRemoteServer;
    private JLabel jLabel_ConnectedUsers;
    private JLabel jLabel_ConnectionStatus;
    private JLabel jLabel_RegisteredUsers;
    private JLabel jLabel_RemoteElements;
    private JLabel jLabel_RemoteServerIP;
    private JLabel jLabel_RemoteServerIP_Header;
    private JLabel jLabel_RemoteServerPort_Header;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JList jList_ConnectedUsers;
    private JPanel jPanel_ConnectedUsers;
    private JPanel jPanel_Content;
    private JPanel jPanel_RegisteredUsers;
    private JPanel jPanel_RemoteElements;
    private JPanel jPanel_Server;
    private JRadioButton jRadioButton_RemoteElement_DMXStage;
    private JRadioButton jRadioButton_RemoteElement_Direction;
    private JRadioButton jRadioButton_RemoteElement_Jingle;
    private JRadioButton jRadioButton_RemoteElement_Master;
    private JRadioButton jRadioButton_RemoteElement_PlayControl;
    private JRadioButton jRadioButton_RemoteElement_RemoteBoard;
    private JRadioButton jRadioButton_RemoteElement_Scenebook;
    private JScrollPane jScrollPane_Connected;
    private JScrollPane jScrollPane_ServerIP;
    private JScrollPane jScrollPane_User;
    private JTable jTable_RegisteredUsers;
    private JTextField jTextField_ServerPort;

    public LiveShowInternalFrame_RemoteServer() {
        s_SelfReference = this;
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveShowInternalFrame_RemoteServer.load();
        LiveDBServerKernel.addLiveDBServerKernelListener((LiveDBServerKernelListener)this);
        LiveDBServerKernel.setLogEventOutput(null);
        LiveDBServerKernel.setWatchdogConnection_Time((long)DEFAULT_WATCHDOGCONNECTION_TIME);
        LiveDBServerKernel.setWatchdogConnectionLost_Time((long)DEFAULT_WATCHDOGCONNECTION_TIME);
        this.refreshIPAddresses();
        this.refreshGUI();
        this.m_RemoteController = new RemoteController(s_SelfReference);
        this.m_RemoteController.setPlayControlPanel(LiveShowProjectDesktop.getPlayControlPanel_Main());
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_ServerIPAddresses = new StringBuilder();
        this.m_ServerConnected = false;
        this.m_RemoteUserDescriptionTableModel = new RemoteUserDescriptionTableModel(this);
        this.m_RemoteUsers = new TableAndListModel.ListModel(false);
        this.m_RemoteUserCellRenderer = new RemoteUserCellRenderer();
        this.m_ServerID = LiveGUID.getUID();
        this.m_ServerIP = "";
        this.m_ServerPort = 15111;
    }

    private void initComponents() {
        this.jPanel_Content = new JPanel();
        this.jPanel_Server = new JPanel();
        this.jTextField_ServerPort = new JTextField();
        this.jLabel_RemoteServerPort_Header = new JLabel();
        this.jButton_StartRemoteServer = new JButton();
        this.jButton_StopRemoteServer = new JButton();
        this.jLabel_ConnectionStatus = new JLabel();
        this.jScrollPane_ServerIP = new JScrollPane();
        this.jLabel_RemoteServerIP = new JLabel();
        this.jLabel_RemoteServerIP_Header = new JLabel();
        this.jPanel_ConnectedUsers = new JPanel();
        this.jLabel_ConnectedUsers = new JLabel();
        this.jScrollPane_Connected = new JScrollPane();
        this.jList_ConnectedUsers = new JList();
        this.jPanel_RegisteredUsers = new JPanel();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jLabel_RegisteredUsers = new JLabel();
        this.jButton_RemoveRegisteredUser = new JButton();
        this.jScrollPane_User = new JScrollPane();
        this.jTable_RegisteredUsers = new JTable();
        this.jButton_AddNewRegisteredUser = new JButton();
        this.jPanel_RemoteElements = new JPanel();
        this.jRadioButton_RemoteElement_Direction = new JRadioButton();
        this.jRadioButton_RemoteElement_PlayControl = new JRadioButton();
        this.jRadioButton_RemoteElement_Scenebook = new JRadioButton();
        this.jRadioButton_RemoteElement_Jingle = new JRadioButton();
        this.jRadioButton_RemoteElement_Master = new JRadioButton();
        this.jRadioButton_RemoteElement_DMXStage = new JRadioButton();
        this.jRadioButton_RemoteElement_RemoteBoard = new JRadioButton();
        this.jLabel_RemoteElements = new JLabel();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("RemoteControl");
        this.setToolTipText("");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Menu_RemoteServer.png")));
        this.setMinimumSize(new Dimension(450, 500));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(450, 500));
        this.setVisible(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jPanel_Server.setToolTipText("");
        this.jPanel_Server.setMinimumSize(new Dimension(244, 150));
        this.jPanel_Server.setPreferredSize(new Dimension(244, 150));
        this.jPanel_Server.setLayout(new GridBagLayout());
        this.jTextField_ServerPort.setFont(new Font("Tahoma", 1, 13));
        this.jTextField_ServerPort.setHorizontalAlignment(0);
        this.jTextField_ServerPort.setText("jTextField1");
        this.jTextField_ServerPort.setToolTipText("insert server port number (between 1024 and 65535) ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jTextField_ServerPort, gridBagConstraints);
        this.jLabel_RemoteServerPort_Header.setHorizontalAlignment(4);
        this.jLabel_RemoteServerPort_Header.setText("ServerPort (1024\u201365535):");
        this.jLabel_RemoteServerPort_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_RemoteServerPort_Header, gridBagConstraints);
        this.jButton_StartRemoteServer.setText("Start Server");
        this.jButton_StartRemoteServer.setBorder(new LineBorder(new Color(0, 255, 0), 1, true));
        this.jButton_StartRemoteServer.setContentAreaFilled(false);
        this.jButton_StartRemoteServer.setMargin(new Insets(5, 10, 5, 10));
        this.jButton_StartRemoteServer.setMaximumSize(new Dimension(100, 50));
        this.jButton_StartRemoteServer.setPreferredSize(new Dimension(100, 25));
        this.jButton_StartRemoteServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_RemoteServer.this.jButton_StartRemoteServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jButton_StartRemoteServer, gridBagConstraints);
        this.jButton_StopRemoteServer.setText("Stop Server");
        this.jButton_StopRemoteServer.setBorder(new LineBorder(new Color(255, 0, 0), 1, true));
        this.jButton_StopRemoteServer.setContentAreaFilled(false);
        this.jButton_StopRemoteServer.setMargin(new Insets(5, 10, 5, 10));
        this.jButton_StopRemoteServer.setMaximumSize(new Dimension(100, 50));
        this.jButton_StopRemoteServer.setPreferredSize(new Dimension(100, 25));
        this.jButton_StopRemoteServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_RemoteServer.this.jButton_StopRemoteServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jButton_StopRemoteServer, gridBagConstraints);
        this.jLabel_ConnectionStatus.setToolTipText("Connection Status (green = server is connected)");
        this.jLabel_ConnectionStatus.setMaximumSize(new Dimension(16, 16));
        this.jLabel_ConnectionStatus.setMinimumSize(new Dimension(16, 16));
        this.jLabel_ConnectionStatus.setOpaque(true);
        this.jLabel_ConnectionStatus.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel_Server.add((Component)this.jLabel_ConnectionStatus, gridBagConstraints);
        this.jScrollPane_ServerIP.setMinimumSize(new Dimension(23, 90));
        this.jScrollPane_ServerIP.setPreferredSize(new Dimension(52, 90));
        this.jLabel_RemoteServerIP.setHorizontalAlignment(0);
        this.jLabel_RemoteServerIP.setText("-");
        this.jLabel_RemoteServerIP.setToolTipText("");
        this.jLabel_RemoteServerIP.setOpaque(true);
        this.jScrollPane_ServerIP.setViewportView(this.jLabel_RemoteServerIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_Server.add((Component)this.jScrollPane_ServerIP, gridBagConstraints);
        this.jLabel_RemoteServerIP_Header.setHorizontalAlignment(4);
        this.jLabel_RemoteServerIP_Header.setText("ServerIP: ");
        this.jLabel_RemoteServerIP_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_RemoteServerIP_Header, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jPanel_Server, gridBagConstraints);
        this.jPanel_ConnectedUsers.setMinimumSize(new Dimension(128, 130));
        this.jPanel_ConnectedUsers.setPreferredSize(new Dimension(128, 130));
        this.jPanel_ConnectedUsers.setLayout(new GridBagLayout());
        this.jLabel_ConnectedUsers.setText("Connected Users");
        this.jLabel_ConnectedUsers.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ConnectedUsers.add((Component)this.jLabel_ConnectedUsers, gridBagConstraints);
        this.jScrollPane_Connected.setMinimumSize(new Dimension(23, 100));
        this.jScrollPane_Connected.setPreferredSize(new Dimension(35, 100));
        this.jList_ConnectedUsers.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane_Connected.setViewportView(this.jList_ConnectedUsers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ConnectedUsers.add((Component)this.jScrollPane_Connected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jPanel_ConnectedUsers, gridBagConstraints);
        this.jPanel_RegisteredUsers.setMinimumSize(new Dimension(180, 240));
        this.jPanel_RegisteredUsers.setPreferredSize(new Dimension(150, 240));
        this.jPanel_RegisteredUsers.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setText("jLabel_ResizeFrame1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        this.jPanel_RegisteredUsers.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jLabel_RegisteredUsers.setText("Registered Users");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RegisteredUsers.add((Component)this.jLabel_RegisteredUsers, gridBagConstraints);
        this.jButton_RemoveRegisteredUser.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveRegisteredUser.setToolTipText("remove selected user");
        this.jButton_RemoveRegisteredUser.setContentAreaFilled(false);
        this.jButton_RemoveRegisteredUser.setMaximumSize(new Dimension(34, 34));
        this.jButton_RemoveRegisteredUser.setMinimumSize(new Dimension(34, 34));
        this.jButton_RemoveRegisteredUser.setPreferredSize(new Dimension(34, 34));
        this.jButton_RemoveRegisteredUser.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveRegisteredUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_RemoteServer.this.jButton_RemoveRegisteredUserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RegisteredUsers.add((Component)this.jButton_RemoveRegisteredUser, gridBagConstraints);
        this.jTable_RegisteredUsers.setFont(new Font("Tahoma", 1, 13));
        this.jTable_RegisteredUsers.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_RegisteredUsers.setFillsViewportHeight(true);
        this.jScrollPane_User.setViewportView(this.jTable_RegisteredUsers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RegisteredUsers.add((Component)this.jScrollPane_User, gridBagConstraints);
        this.jButton_AddNewRegisteredUser.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddNewRegisteredUser.setToolTipText("Add new user");
        this.jButton_AddNewRegisteredUser.setContentAreaFilled(false);
        this.jButton_AddNewRegisteredUser.setMaximumSize(new Dimension(34, 34));
        this.jButton_AddNewRegisteredUser.setMinimumSize(new Dimension(34, 34));
        this.jButton_AddNewRegisteredUser.setPreferredSize(new Dimension(34, 34));
        this.jButton_AddNewRegisteredUser.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddNewRegisteredUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_RemoteServer.this.jButton_AddNewRegisteredUserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RegisteredUsers.add((Component)this.jButton_AddNewRegisteredUser, gridBagConstraints);
        this.jPanel_RemoteElements.setMinimumSize(new Dimension(150, 200));
        this.jPanel_RemoteElements.setPreferredSize(new Dimension(150, 200));
        this.jPanel_RemoteElements.setLayout(new GridBagLayout());
        this.jRadioButton_RemoteElement_Direction.setText("Direction");
        this.jRadioButton_RemoteElement_Direction.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_Direction, gridBagConstraints);
        this.jRadioButton_RemoteElement_PlayControl.setText("PlayControl");
        this.jRadioButton_RemoteElement_PlayControl.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_PlayControl, gridBagConstraints);
        this.jRadioButton_RemoteElement_Scenebook.setText("Scenebook");
        this.jRadioButton_RemoteElement_Scenebook.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_Scenebook, gridBagConstraints);
        this.jRadioButton_RemoteElement_Jingle.setText("Jingle");
        this.jRadioButton_RemoteElement_Jingle.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_Jingle, gridBagConstraints);
        this.jRadioButton_RemoteElement_Master.setText("Master");
        this.jRadioButton_RemoteElement_Master.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_Master, gridBagConstraints);
        this.jRadioButton_RemoteElement_DMXStage.setText("DMX lamps");
        this.jRadioButton_RemoteElement_DMXStage.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_DMXStage, gridBagConstraints);
        this.jRadioButton_RemoteElement_RemoteBoard.setText("RemoteBoard");
        this.jRadioButton_RemoteElement_RemoteBoard.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RemoteElements.add((Component)this.jRadioButton_RemoteElement_RemoteBoard, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_RegisteredUsers.add((Component)this.jPanel_RemoteElements, gridBagConstraints);
        this.jLabel_RemoteElements.setForeground(new Color(255, 255, 255));
        this.jLabel_RemoteElements.setHorizontalAlignment(0);
        this.jLabel_RemoteElements.setText("Remote elements");
        this.jLabel_RemoteElements.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_RegisteredUsers.add((Component)this.jLabel_RemoteElements, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jPanel_RegisteredUsers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.jLabel_ResizeFrame1.setContainer((Container)this);
        this.jScrollPane_ServerIP.getViewport().setBackground(Color.BLACK);
        this.jScrollPane_Connected.getViewport().setBackground(Color.BLACK);
        this.jScrollPane_User.getViewport().setBackground(Color.BLACK);
        this.jTable_RegisteredUsers.setModel((TableModel)((Object)this.m_RemoteUserDescriptionTableModel));
        this.m_RemoteUserDescription_SelectionModel = this.jTable_RegisteredUsers.getSelectionModel();
        this.m_RemoteUserDescription_SelectionModel.addListSelectionListener(this);
        this.m_RemoteUserDescriptionTableModel.finishJTable(this.jTable_RegisteredUsers);
        ActionListener o_ActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int intSelectedRow = LiveShowInternalFrame_RemoteServer.this.jTable_RegisteredUsers.getSelectedRow();
                if (intSelectedRow < 0) {
                    return;
                }
                intSelectedRow = LiveShowInternalFrame_RemoteServer.this.jTable_RegisteredUsers.convertRowIndexToModel(intSelectedRow);
                Message_Permission.RemoteUserDescription o_RemoteUserDescription = LiveShowInternalFrame_RemoteServer.this.m_RemoteUserDescriptionTableModel.getRemoteUserDescription(intSelectedRow);
                if (o_RemoteUserDescription == null) {
                    return;
                }
                LiveShowInternalFrame_RemoteServer.this.setRemoteElements(o_RemoteUserDescription);
            }
        };
        this.jRadioButton_RemoteElement_Direction.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_RemoteBoard.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_PlayControl.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_Scenebook.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_Jingle.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_Master.addActionListener(o_ActionListener);
        this.jRadioButton_RemoteElement_DMXStage.addActionListener(o_ActionListener);
        this.jList_ConnectedUsers.setModel(this.m_RemoteUsers);
        this.jList_ConnectedUsers.setCellRenderer(this.m_RemoteUserCellRenderer);
        this.jLabel_RemoteServerIP.setText(this.m_ServerIP);
        this.jTextField_ServerPort.setText(String.valueOf(this.m_ServerPort));
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer((JTextComponent)this.jTextField_ServerPort);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        o_DocumentFilter_Integer.setMinValue(1024);
        o_DocumentFilter_Integer.setMaxValue(65535);
        this.jTextField_ServerPort.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_StartRemoteServer.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_StopRemoteServer.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jLabel_ConnectionStatus.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_AddNewRegisteredUser.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveRegisteredUser.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTable_RegisteredUsers.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jPanel_RemoteElements.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jLabel_RemoteElements.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.m_StopServerIPs = false;
        this.m_RunnableServerIPs = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!LiveShowInternalFrame_RemoteServer.this.m_StopServerIPs) {
                    LiveShowInternalFrame_RemoteServer.this.refreshIPAddresses();
                    LiveShowInternalFrame_RemoteServer.this.refreshGUI();
                    Object object = LiveShowInternalFrame_RemoteServer.this.m_SyncServerIPs;
                    synchronized (object) {
                        try {
                            long longWaitStart;
                            for (long longWaitTime = 5000L; longWaitTime > 0L && !LiveShowInternalFrame_RemoteServer.this.m_StopServerIPs; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                LiveShowInternalFrame_RemoteServer.this.m_SyncServerIPs.wait(longWaitTime);
                            }
                        }
                        catch (Exception e) {
                            LiveShowInternalFrame_RemoteServer.this.m_StopServerIPs = true;
                        }
                    }
                }
            }
        };
        Thread o_ThreadServerIPs = new Thread(this.m_RunnableServerIPs);
        o_ThreadServerIPs.start();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_RemoteUserDescription_SelectionModel) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.refreshGUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LiveShowInternalFrame_RemoteServer.save();
        Object object = this.m_SyncServerIPs;
        synchronized (object) {
            this.m_StopServerIPs = true;
            this.m_SyncServerIPs.notifyAll();
        }
        this.jTextField_ServerPort.setComponentPopupMenu(null);
        this.jButton_StartRemoteServer.setComponentPopupMenu(null);
        this.jButton_StopRemoteServer.setComponentPopupMenu(null);
        this.jLabel_ConnectionStatus.setComponentPopupMenu(null);
        this.jButton_AddNewRegisteredUser.setComponentPopupMenu(null);
        this.jButton_RemoveRegisteredUser.setComponentPopupMenu(null);
        this.jTable_RegisteredUsers.setComponentPopupMenu(null);
        this.jPanel_RemoteElements.setComponentPopupMenu(null);
        this.jLabel_RemoteElements.setComponentPopupMenu(null);
        try {
            ServerAutoDetect_Server.stopServerAutoDetect((String)this.m_ServerID);
            LiveDBServerKernel.destruct((boolean)true, (int)1, (long)5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_RemoteController.close();
        RemoteHandler.close(1000L);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_ServerID);
        out.writeUTF(this.m_ServerIP);
        out.writeInt(this.m_ServerPort);
        out.writeBoolean(this.m_ServerConnected);
        int intRowCount = this.m_RemoteUserDescriptionTableModel.size();
        out.writeInt(intRowCount);
        for (int intRow = 0; intRow < intRowCount; ++intRow) {
            Message_Permission.RemoteUserDescription o_RemoteUserDescription = this.m_RemoteUserDescriptionTableModel.getRemoteUserDescription(intRow);
            o_RemoteUserDescription.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ServerID = in.readUTF();
        this.m_ServerIP = in.readUTF();
        this.m_ServerPort = in.readInt();
        this.m_ServerConnected = in.readBoolean();
        int intRowCount = in.readInt();
        for (int intRow = 0; intRow < intRowCount; ++intRow) {
            Message_Permission.RemoteUserDescription o_RemoteUserDescription = new Message_Permission.RemoteUserDescription();
            o_RemoteUserDescription.readExternal(in);
            this.m_RemoteUserDescriptionTableModel.addRemoteUserDescription(o_RemoteUserDescription);
        }
        if (this.m_ServerPort < 1024) {
            this.m_ServerPort = 1024;
        }
        if (this.m_ServerPort > 65535) {
            this.m_ServerPort = 65535;
        }
        this.jTextField_ServerPort.setText(String.valueOf(this.m_ServerPort));
        NetworkInterface o_NetworkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(this.m_ServerIP));
        if (o_NetworkInterface != null) {
            this.jLabel_RemoteServerIP.setText(this.m_ServerIP);
            if (this.m_ServerConnected) {
                this.connectServer();
            }
        } else {
            this.jLabel_RemoteServerIP.setText("-");
            if (this.m_ServerConnected) {
                this.m_ServerConnected = false;
                EventQueueHandler.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveShowProjectDesktop.toFrontInternalFrame(s_SelfReference);
                    }
                });
            }
        }
    }

    public static void load() {
        if (s_SelfReference == null) {
            return;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        String stringFileName = OSChecker.getPathUserHomeConfigDirectory() + "/LiveShowRemoteServer.lrs";
        File o_File = new File(stringFileName);
        if (!o_File.exists()) {
            return;
        }
        try {
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            s_SelfReference.readExternal(o_ObjectInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (o_ObjectInput != null) {
                o_ObjectInput.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        if (s_SelfReference == null) {
            return;
        }
        FileOutputStream o_FileOutputStream = null;
        ObjectOutput o_ObjectOutput = null;
        String stringFileName = OSChecker.getPathUserHomeConfigDirectory() + "/LiveShowRemoteServer.lrs";
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            o_FileOutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            s_SelfReference.writeExternal(o_ObjectOutput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (o_ObjectOutput != null) {
                o_ObjectOutput.close();
            }
            if (o_FileOutputStream != null) {
                o_FileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshIPAddresses() {
        this.m_ServerIPAddresses.delete(0, this.m_ServerIPAddresses.length());
        this.m_ServerIPAddresses.append("<html>");
        this.m_ServerIPAddresses.append(this.getServerIPAddresses());
        this.m_ServerIPAddresses.append("</html>");
    }

    public String getServerIPAddresses() {
        Enumeration<NetworkInterface> o_NetworkInterfaces;
        StringBuffer o_StringBuffer_Result = new StringBuffer();
        StringBuffer o_StringBuffer_NetworkInterface = new StringBuffer();
        try {
            o_NetworkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            o_NetworkInterfaces = null;
        }
        if (o_NetworkInterfaces != null) {
            while (o_NetworkInterfaces.hasMoreElements()) {
                NetworkInterface o_NetworkInterface = o_NetworkInterfaces.nextElement();
                try {
                    if (!o_NetworkInterface.isUp() || o_NetworkInterface.isVirtual()) continue;
                    if (o_NetworkInterface.isPointToPoint()) {
                    }
                }
                catch (Exception e) {}
                continue;
                o_StringBuffer_NetworkInterface.delete(0, o_StringBuffer_NetworkInterface.length());
                List<InterfaceAddress> o_InterfaceAddresses = o_NetworkInterface.getInterfaceAddresses();
                for (int intInterfaceAddress = 0; intInterfaceAddress < o_InterfaceAddresses.size(); ++intInterfaceAddress) {
                    InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intInterfaceAddress);
                    InetAddress o_InetAddress = o_InterfaceAddress.getAddress();
                    if (o_InetAddress == null) continue;
                    if (o_InetAddress instanceof Inet4Address) {
                        o_StringBuffer_NetworkInterface.append("<b>");
                    }
                    o_StringBuffer_NetworkInterface.append(o_InetAddress.getHostAddress());
                    if (o_InetAddress instanceof Inet4Address) {
                        o_StringBuffer_NetworkInterface.append("</b>");
                    }
                    if (intInterfaceAddress >= o_InterfaceAddresses.size() - 1) continue;
                    o_StringBuffer_NetworkInterface.append(", ");
                }
                o_StringBuffer_Result.append(o_StringBuffer_NetworkInterface.toString());
                try {
                    if (o_NetworkInterface.isLoopback()) {
                        o_StringBuffer_Result.append(" (local)");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!o_NetworkInterfaces.hasMoreElements()) continue;
                o_StringBuffer_Result.append("<br>");
            }
        }
        return o_StringBuffer_Result.toString();
    }

    public void refreshGUI() {
        this.jLabel_RemoteServerIP.setText(this.m_ServerIPAddresses.toString());
        switch (LiveDBServerKernel.getConnectionStatus()) {
            case 0: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jButton_StopRemoteServer.setEnabled(false);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.ORANGE);
                break;
            }
            case 2: {
                this.jButton_StartRemoteServer.setEnabled(false);
                this.jButton_StopRemoteServer.setEnabled(true);
                this.jTextField_ServerPort.setEnabled(false);
                this.jLabel_ConnectionStatus.setBackground(Color.GREEN);
                this.m_ServerConnected = true;
                break;
            }
            case 6: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jButton_StopRemoteServer.setEnabled(false);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.RED);
                break;
            }
            case 8: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.YELLOW);
                break;
            }
            case 3: {
                this.jButton_StartRemoteServer.setEnabled(false);
                this.jButton_StopRemoteServer.setEnabled(true);
                this.jTextField_ServerPort.setEnabled(false);
                this.jLabel_ConnectionStatus.setBackground(Color.GREEN);
                break;
            }
            case 9: {
                this.jButton_StartRemoteServer.setEnabled(false);
                this.jButton_StopRemoteServer.setEnabled(false);
                this.jTextField_ServerPort.setEnabled(false);
                this.jLabel_ConnectionStatus.setBackground(Color.LIGHT_GRAY);
                break;
            }
            case 1: {
                this.jButton_StartRemoteServer.setEnabled(false);
                this.jButton_StopRemoteServer.setEnabled(false);
                this.jTextField_ServerPort.setEnabled(false);
                this.jLabel_ConnectionStatus.setBackground(Color.LIGHT_GRAY);
                break;
            }
            default: {
                this.jButton_StartRemoteServer.setEnabled(false);
                this.jButton_StopRemoteServer.setEnabled(false);
                this.jTextField_ServerPort.setEnabled(false);
                this.jLabel_ConnectionStatus.setBackground(Color.WHITE);
            }
        }
        int intIndex = this.jTable_RegisteredUsers.getSelectedRow();
        if (intIndex >= 0) {
            intIndex = this.jTable_RegisteredUsers.convertRowIndexToModel(intIndex);
            Message_Permission.RemoteUserDescription o_RemoteUserDescription = this.m_RemoteUserDescriptionTableModel.getRemoteUserDescription(intIndex);
            this.refreshRemoteElements(o_RemoteUserDescription);
            this.jButton_RemoveRegisteredUser.setEnabled(true);
        } else {
            this.refreshRemoteElements(null);
            this.jButton_RemoveRegisteredUser.setEnabled(false);
        }
    }

    public void refreshRemoteElements(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
        if (p_RemoteUserDescription == null) {
            this.jRadioButton_RemoteElement_Direction.setSelected(false);
            this.jRadioButton_RemoteElement_Direction.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_RemoteBoard.setSelected(false);
            this.jRadioButton_RemoteElement_RemoteBoard.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_PlayControl.setSelected(false);
            this.jRadioButton_RemoteElement_PlayControl.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_Scenebook.setSelected(false);
            this.jRadioButton_RemoteElement_Scenebook.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_Jingle.setSelected(false);
            this.jRadioButton_RemoteElement_Jingle.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_Master.setSelected(false);
            this.jRadioButton_RemoteElement_Master.setForeground(s_Foreground_Disabled);
            this.jRadioButton_RemoteElement_DMXStage.setSelected(false);
            this.jRadioButton_RemoteElement_DMXStage.setForeground(s_Foreground_Disabled);
        } else {
            this.jRadioButton_RemoteElement_Direction.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_RemoteBoard.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_PlayControl.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_Scenebook.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_Jingle.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_Master.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_DMXStage.setForeground(s_Foreground_Normal);
            this.jRadioButton_RemoteElement_Direction.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_direction"));
            this.jRadioButton_RemoteElement_RemoteBoard.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_remoteboard"));
            this.jRadioButton_RemoteElement_PlayControl.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_playcontrol"));
            this.jRadioButton_RemoteElement_Scenebook.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_scenebook"));
            this.jRadioButton_RemoteElement_Jingle.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_jingle"));
            this.jRadioButton_RemoteElement_Master.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_master"));
            this.jRadioButton_RemoteElement_DMXStage.setSelected(p_RemoteUserDescription.hasRemoteElement("elementid_dmxstage"));
        }
    }

    public void setRemoteElements(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
        if (p_RemoteUserDescription == null) {
            return;
        }
        p_RemoteUserDescription.clearRemoteElements();
        if (this.jRadioButton_RemoteElement_Direction.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_direction");
        }
        if (this.jRadioButton_RemoteElement_RemoteBoard.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_remoteboard");
        }
        if (this.jRadioButton_RemoteElement_PlayControl.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_playcontrol");
        }
        if (this.jRadioButton_RemoteElement_Scenebook.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_scenebook");
        }
        if (this.jRadioButton_RemoteElement_Jingle.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_jingle");
        }
        if (this.jRadioButton_RemoteElement_Master.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_master");
        }
        if (this.jRadioButton_RemoteElement_DMXStage.isSelected()) {
            p_RemoteUserDescription.addRemoteElement("elementid_dmxstage");
        }
        ArrayList<RemoteUser> o_RemoteUsers = this.getRemoteUsers(p_RemoteUserDescription);
        for (int intUser = 0; intUser < o_RemoteUsers.size(); ++intUser) {
            RemoteUser o_RemoteUser = o_RemoteUsers.get(intUser);
            o_RemoteUser.sendPermission();
        }
    }

    public void setLiveShowSoundVip(LiveShowSoundVIP p_LiveShowSoundVIP) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server;
        if (this.m_RemoteController != null) {
            this.m_RemoteController.setLiveShowSoundVIP(p_LiveShowSoundVIP);
        }
        if ((o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server((String)this.m_ServerID)) != null) {
            LiveShowProjectDescription o_LiveShowProjectDescription = LiveShowProjectDesktop.getLiveShowProjectDescription();
            String stringProjectName = o_LiveShowProjectDescription != null ? o_LiveShowProjectDescription.getProjectName() : "";
            o_ServerAutoDetect_Server.setServerProjectName(stringProjectName);
        }
    }

    public void setLiveShowDMXVip(LiveShowDMXVIP p_LiveShowDMXVIP) {
        if (this.m_RemoteController != null) {
            this.m_RemoteController.setLiveShowDMXVIP(p_LiveShowDMXVIP);
        }
    }

    public void setLiveShowMediaVip(LiveShowMediaVIP p_LiveShowMediaVIP) {
        if (this.m_RemoteController != null) {
            this.m_RemoteController.setLiveShowMediaVIP(p_LiveShowMediaVIP);
        }
    }

    public void setLiveShowSceneBookPanel(LiveShowSceneBookPanel p_LiveShowSceneBookPanel) {
        if (this.m_RemoteController != null) {
            this.m_RemoteController.setLiveShowSceneBookPanel(p_LiveShowSceneBookPanel);
        }
    }

    private void jButton_StartRemoteServerActionPerformed(ActionEvent evt) {
        this.refreshIPAddresses();
        this.connectServer();
    }

    private void connectServer() {
        int intServerPort;
        String stringServerPort = this.jTextField_ServerPort.getText();
        if (stringServerPort == null || stringServerPort.length() <= 0) {
            return;
        }
        try {
            intServerPort = Integer.valueOf(stringServerPort);
        }
        catch (Exception e) {
            intServerPort = 15111;
            this.jTextField_ServerPort.setText("15111");
        }
        if (intServerPort < 1024) {
            intServerPort = 1024;
            this.jTextField_ServerPort.setText("1024");
        }
        if (intServerPort > 65535) {
            intServerPort = 65535;
            this.jTextField_ServerPort.setText("65535");
        }
        this.m_ServerIP = "";
        this.m_ServerPort = intServerPort;
        LiveDBServerKernel.connectServer((String)this.m_ServerIP, (int)this.m_ServerPort, (String)this.m_ServerID, (String)"LiveShowRemote", (String)"LiveShowRemote", (String)("Server " + this.m_ServerIP + " at Port " + String.valueOf(this.m_ServerPort)), (String)String.valueOf(2));
        switch (LiveDBServerKernel.getConnectionStatus()) {
            default: 
        }
    }

    private void jButton_StopRemoteServerActionPerformed(ActionEvent evt) {
        this.m_ServerConnected = false;
        ServerAutoDetect_Server.stopServerAutoDetect((String)this.m_ServerID);
        LiveDBServerKernel.closeServer((int)1);
    }

    private void jButton_AddNewRegisteredUserActionPerformed(ActionEvent evt) {
        Message_Permission.RemoteUserDescription o_RemoteUserDescription = new Message_Permission.RemoteUserDescription();
        o_RemoteUserDescription.setUserName("name");
        o_RemoteUserDescription.setUserPassword("password");
        o_RemoteUserDescription.setPermissionControl(false);
        o_RemoteUserDescription.setPermissionListen(true);
        o_RemoteUserDescription.addRemoteElement("elementid_direction");
        o_RemoteUserDescription.addRemoteElement("elementid_scenebook");
        this.m_RemoteUserDescriptionTableModel.addRemoteUserDescription(o_RemoteUserDescription);
        this.m_RemoteUserDescriptionTableModel.setSelectedElement(this.jTable_RegisteredUsers, o_RemoteUserDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_RemoveRegisteredUserActionPerformed(ActionEvent evt) {
        ArrayList<LiveDBClient> o_LiveDBClients;
        String stringUserPassword;
        String stringUserName;
        Message_Permission.RemoteUserDescription o_RemoteUserDescription;
        int intSelectedRow = this.jTable_RegisteredUsers.getSelectedRow();
        if (intSelectedRow < 0) {
            return;
        }
        try {
            intSelectedRow = this.jTable_RegisteredUsers.convertRowIndexToModel(intSelectedRow);
            o_RemoteUserDescription = this.m_RemoteUserDescriptionTableModel.getRemoteUserDescription(intSelectedRow);
            if (o_RemoteUserDescription == null) {
                return;
            }
            stringUserName = o_RemoteUserDescription.getUserName();
            stringUserPassword = o_RemoteUserDescription.getUserPassword();
        }
        catch (Exception e) {
            return;
        }
        this.m_RemoteUserDescriptionTableModel.removeRemoteUserDescription(o_RemoteUserDescription);
        Object e = this.m_SyncRemoteUser;
        synchronized (e) {
            o_LiveDBClients = new ArrayList<LiveDBClient>(this.m_RemoteUsers.size());
            for (int intRemoteUser = this.m_RemoteUsers.size() - 1; intRemoteUser >= 0; --intRemoteUser) {
                RemoteUser o_RemoteUser = (RemoteUser)this.m_RemoteUsers.get(intRemoteUser);
                if (!stringUserName.equals(o_RemoteUser.getUserName()) || !stringUserPassword.equals(o_RemoteUser.getUserPassword())) continue;
                o_LiveDBClients.add(o_RemoteUser.getLiveDBClient());
            }
        }
        for (int intClient = 0; intClient < o_LiveDBClients.size(); ++intClient) {
            LiveDBClient o_LiveDBClient = (LiveDBClient)o_LiveDBClients.get(intClient);
            o_LiveDBClient.close();
        }
        o_LiveDBClients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectedClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        RemoteUser o_RemoteUser = new RemoteUser(p_LiveDBClient);
        Object object = this.m_SyncRemoteUser;
        synchronized (object) {
            this.m_RemoteUsers.add((Object)o_RemoteUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectedClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        RemoteUser o_RemoteUser = this.getRemoteUser(p_LiveDBClient);
        if (o_RemoteUser == null) {
            return;
        }
        Object object = this.m_SyncRemoteUser;
        synchronized (object) {
            this.m_RemoteUsers.remove((Object)o_RemoteUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteUser getRemoteUser(LiveDBClient p_LiveDBClient) {
        Object object = this.m_SyncRemoteUser;
        synchronized (object) {
            for (int intUser = 0; intUser < this.m_RemoteUsers.size(); ++intUser) {
                RemoteUser o_RemoteUser = (RemoteUser)this.m_RemoteUsers.get(intUser);
                if (o_RemoteUser.getLiveDBClient() != p_LiveDBClient) continue;
                return o_RemoteUser;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<RemoteUser> getRemoteUsers(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
        ArrayList<RemoteUser> o_RemoteUsers = new ArrayList<RemoteUser>();
        if (p_RemoteUserDescription == null) {
            return o_RemoteUsers;
        }
        Object object = this.m_SyncRemoteUser;
        synchronized (object) {
            for (int intRemoteUser = 0; intRemoteUser < this.m_RemoteUsers.size(); ++intRemoteUser) {
                RemoteUser o_RemoteUser = (RemoteUser)this.m_RemoteUsers.get(intRemoteUser);
                Message_Permission.RemoteUserDescription o_RemoteUserDescription = o_RemoteUser.getRemoteUserDescription();
                if (p_RemoteUserDescription != o_RemoteUserDescription) continue;
                o_RemoteUsers.add(o_RemoteUser);
            }
        }
        return o_RemoteUsers;
    }

    public int getRemoteUsersCount() {
        return this.m_RemoteUsers.size();
    }

    public boolean loginRemoteUser(LiveDBClient p_LiveDBClient, Message_Login p_Message_Login) {
        if (p_LiveDBClient == null) {
            return false;
        }
        if (p_Message_Login == null) {
            return false;
        }
        boolean boolLoginOK = true;
        RemoteUser o_RemoteUser = this.getRemoteUser(p_LiveDBClient);
        if (o_RemoteUser == null) {
            return false;
        }
        String stringUserName = p_Message_Login.getUserName();
        String stringUserPassword = p_Message_Login.getUserPassword();
        if (stringUserName == null) {
            boolLoginOK = false;
        }
        if (stringUserPassword == null) {
            boolLoginOK = false;
        }
        if (boolLoginOK && !this.m_RemoteUserDescriptionTableModel.checkLogin(o_RemoteUser, stringUserName, stringUserPassword)) {
            boolLoginOK = false;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            // empty if block
        }
        this.jList_ConnectedUsers.repaint();
        return boolLoginOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(RemoteUser p_RemoteUser, Serializable p_Message) {
        if (p_Message == null) {
            return;
        }
        if (p_RemoteUser != null) {
            LiveDBClient o_LiveDBClient = p_RemoteUser.getLiveDBClient();
            if (o_LiveDBClient != null) {
                o_LiveDBClient.sendMessage(p_Message);
            }
        } else {
            LiveDBClient o_LiveDBClient;
            ArrayList<LiveDBClient> o_LiveDBClients;
            Object object = this.m_SyncRemoteUser;
            synchronized (object) {
                o_LiveDBClients = new ArrayList<LiveDBClient>(this.m_RemoteUsers.size());
                for (int intRemoteUser = 0; intRemoteUser < this.m_RemoteUsers.size(); ++intRemoteUser) {
                    RemoteUser o_RemoteUser = (RemoteUser)this.m_RemoteUsers.get(intRemoteUser);
                    if (o_RemoteUser == null || (o_LiveDBClient = o_RemoteUser.getLiveDBClient()) == null) continue;
                    o_LiveDBClients.add(o_LiveDBClient);
                }
            }
            for (int intClient = 0; intClient < o_LiveDBClients.size(); ++intClient) {
                o_LiveDBClient = (LiveDBClient)o_LiveDBClients.get(intClient);
                o_LiveDBClient.sendMessage(p_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage_ExcludeClient(Serializable p_Message, RemoteUser p_RemoteUser_Exclude) {
        LiveDBClient o_LiveDBClient;
        ArrayList<LiveDBClient> o_LiveDBClients;
        Object object = this.m_SyncRemoteUser;
        synchronized (object) {
            o_LiveDBClients = new ArrayList<LiveDBClient>(this.m_RemoteUsers.size());
            for (int intRemoteUser = 0; intRemoteUser < this.m_RemoteUsers.size(); ++intRemoteUser) {
                RemoteUser o_RemoteUser = (RemoteUser)this.m_RemoteUsers.get(intRemoteUser);
                if (o_RemoteUser == null || o_RemoteUser == p_RemoteUser_Exclude || (o_LiveDBClient = o_RemoteUser.getLiveDBClient()) == null) continue;
                o_LiveDBClients.add(o_LiveDBClient);
            }
        }
        for (int intClient = 0; intClient < o_LiveDBClients.size(); ++intClient) {
            o_LiveDBClient = (LiveDBClient)o_LiveDBClients.get(intClient);
            o_LiveDBClient.sendMessage(p_Message);
        }
    }

    public void eventServerConnectionStatus(int p_ConnectionStatus) {
        this.refreshGUI();
        switch (p_ConnectionStatus) {
            case 2: {
                LiveShowProjectDescription o_LiveShowProjectDescription = LiveShowProjectDesktop.getLiveShowProjectDescription();
                String stringProjectName = o_LiveShowProjectDescription == null ? "" : o_LiveShowProjectDescription.getProjectName();
                ServerAutoDetect_Server.startServerAutoDetect((String)this.m_ServerID, (String)"LiveShowRemote", (String)"LiveShowRemote", (int)15108, (int)this.m_ServerPort, null, (String)stringProjectName);
                break;
            }
            case 0: 
            case 6: {
                ServerAutoDetect_Server.stopServerAutoDetect((String)this.m_ServerID);
                break;
            }
        }
    }

    public void eventServerError(Exception p_Exception, String p_Remark) {
    }

    public void eventServerLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
        this.addConnectedClient(p_LiveDBClient);
    }

    public void eventServerLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
        this.removeConnectedClient(p_LiveDBClient);
    }

    public void eventServerVerbosedClientIP(String p_VerbosedIP, boolean p_New) {
    }

    public boolean verifyClientSoftwareVersion(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientSoftwareVersion) {
        return true;
    }

    public boolean verifyClientLicense(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientLicense) {
        return true;
    }

    public boolean verifyCloseServer(LiveDBClient p_LiveDBClient, int p_ShutdownFlag) {
        return true;
    }

    public boolean verifyShutDownLiveDBClient(LiveDBClient p_LiveDBClientActor, LiveDBClient p_LiveDBClientToClose) {
        return true;
    }

    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        RemoteUser o_RemoteUser = this.getRemoteUser(p_LiveDBClient);
        if (o_RemoteUser == null) {
            return;
        }
        o_RemoteUser.setConnectionStatus(p_ConnectionStatus);
        if (!SwingUtilities.isEventDispatchThread()) {
            // empty if block
        }
        this.jList_ConnectedUsers.repaint();
    }

    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
        p_LiveDBClient.close();
    }

    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
    }

    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
    }

    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MessageObject == null) {
            return;
        }
        RemoteUser o_RemoteUser = this.getRemoteUser(p_LiveDBClient);
        if (p_MessageObject instanceof Message_Login) {
            this.loginRemoteUser(p_LiveDBClient, (Message_Login)p_MessageObject);
            return;
        }
        if (p_MessageObject instanceof Message_Request_Status_Play) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestStatusPlay(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlayNextMainBridge) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playNextMainBridge(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlayPreviousMainBridge) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPreviousMainBridge(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlayNextBridge) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playNextBridge(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlayNextPreviousBridge) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPreviousBridge(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlaySceneBridge) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playSceneBridge(o_RemoteUser, (Message_PlaySceneBridge)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_Play_FromStart) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playFromStart(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_PlayRewind) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playRewind(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_Start) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playStart(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_Pause) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPause(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_Stop) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playStop(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_StartSound) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playStartSound(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_PauseSound) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPauseSound(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_StartMedia) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playStartMedia(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_PauseMedia) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPauseMedia(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_StartDMX) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playStartDMX(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Play_PauseDMX) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.playPauseDMX(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Request_Status_Jingle) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestStatusJingles(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_JinglePlay_Start) {
            if (this.m_RemoteController != null) {
                Message_JinglePlay_Start o_Message = (Message_JinglePlay_Start)p_MessageObject;
                this.m_RemoteController.playJingleStart(o_RemoteUser, o_Message.getVIPType(), o_Message.getJingleID());
            }
        } else if (p_MessageObject instanceof Message_JinglePlay_Pause) {
            if (this.m_RemoteController != null) {
                Message_JinglePlay_Pause o_Message = (Message_JinglePlay_Pause)p_MessageObject;
                this.m_RemoteController.playJinglePause(o_RemoteUser, o_Message.getVIPType(), o_Message.getJingleID());
            }
        } else if (p_MessageObject instanceof Message_JinglePlay_Stop) {
            if (this.m_RemoteController != null) {
                Message_JinglePlay_Stop o_Message = (Message_JinglePlay_Stop)p_MessageObject;
                this.m_RemoteController.playJingleStop(o_RemoteUser, o_Message.getVIPType(), o_Message.getJingleID());
            }
        } else if (p_MessageObject instanceof Message_JinglePlay_FadeIn) {
            if (this.m_RemoteController != null) {
                Message_JinglePlay_FadeIn o_Message = (Message_JinglePlay_FadeIn)p_MessageObject;
                this.m_RemoteController.playJingleFadeIn(o_RemoteUser, o_Message.getVIPType(), o_Message.getJingleID());
            }
        } else if (p_MessageObject instanceof Message_JinglePlay_FadeOut) {
            if (this.m_RemoteController != null) {
                Message_JinglePlay_FadeOut o_Message = (Message_JinglePlay_FadeOut)p_MessageObject;
                this.m_RemoteController.playJingleFadeOut(o_RemoteUser, o_Message.getVIPType(), o_Message.getJingleID());
            }
        } else if (p_MessageObject instanceof Message_JinglesGroupPlay_Start) {
            if (this.m_RemoteController != null) {
                Message_JinglesGroupPlay_Start o_Message = (Message_JinglesGroupPlay_Start)p_MessageObject;
                this.m_RemoteController.playJinglesGroupStart(o_RemoteUser, o_Message.getJingleGroupID());
            }
        } else if (p_MessageObject instanceof Message_JinglesGroupPlay_FadeIn) {
            if (this.m_RemoteController != null) {
                Message_JinglesGroupPlay_FadeIn o_Message = (Message_JinglesGroupPlay_FadeIn)p_MessageObject;
                this.m_RemoteController.playJinglesGroupFadeIn(o_RemoteUser, o_Message.getJingleGroupID());
            }
        } else if (p_MessageObject instanceof Message_JinglesGroupPlay_FadeOut) {
            if (this.m_RemoteController != null) {
                Message_JinglesGroupPlay_FadeOut o_Message = (Message_JinglesGroupPlay_FadeOut)p_MessageObject;
                this.m_RemoteController.playJinglesGroupFadeOut(o_RemoteUser, o_Message.getJingleGroupID());
            }
        } else if (p_MessageObject instanceof Message_JinglesGroupPlay_Pause) {
            if (this.m_RemoteController != null) {
                Message_JinglesGroupPlay_Pause o_Message = (Message_JinglesGroupPlay_Pause)p_MessageObject;
                this.m_RemoteController.playJinglesGroupPause(o_RemoteUser, o_Message.getJingleGroupID());
            }
        } else if (p_MessageObject instanceof Message_JinglesGroupPlay_Stop) {
            if (this.m_RemoteController != null) {
                Message_JinglesGroupPlay_Stop o_Message = (Message_JinglesGroupPlay_Stop)p_MessageObject;
                this.m_RemoteController.playJinglesGroupStop(o_RemoteUser, o_Message.getJingleGroupID());
            }
        } else if (p_MessageObject instanceof Message_Request_Status_Master) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestStatusMasters(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Master_Change) {
            if (this.m_RemoteController != null) {
                Message_Master_Change o_Message_Master_Change = (Message_Master_Change)p_MessageObject;
                this.m_RemoteController.changeMaster(o_RemoteUser, o_Message_Master_Change.getVIPType(), o_Message_Master_Change.getValueNormed());
            }
        } else if (p_MessageObject instanceof Message_Request_Language) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestLanguage(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Request_SceneBook) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestSceneBook(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_Request_Status_DMXStageView) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestStatusDMXStageView(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_DMXDevice) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.changeDMXDevice(o_RemoteUser, (Message_DMXDevice)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_DMXDeviceGroupSelected) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.selectedDMXDeviceGroup(o_RemoteUser, (Message_DMXDeviceGroupSelected)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_DMXControlComponentValue) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.changeDMXControlDimension(o_RemoteUser, (Message_DMXControlComponentValue)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_DMXControlComponentFunction) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.callDMXControlFunction(o_RemoteUser, (Message_DMXControlComponentFunction)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_DMXControlGroupsChangeType) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.changeDMXControlGroupsChangeType(o_RemoteUser, (Message_DMXControlGroupsChangeType)p_MessageObject);
            }
        } else if (p_MessageObject instanceof Message_Request_Status_RemoteBoard) {
            if (this.m_RemoteController != null) {
                this.m_RemoteController.requestStatusRemoteBoard(o_RemoteUser);
            }
        } else if (p_MessageObject instanceof Message_RemoteBoardItem_DoAction) {
            Message_RemoteBoardItem_DoAction o_Message_RemoteBoardItem_DoAction = (Message_RemoteBoardItem_DoAction)p_MessageObject;
            if (this.m_RemoteController != null) {
                this.m_RemoteController.doActionRemoteBoard(o_RemoteUser, o_Message_RemoteBoardItem_DoAction.getGridX(), o_Message_RemoteBoardItem_DoAction.getGridY());
            }
        }
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
    }

    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytesCount) {
    }

    public static class RemoteHandler {
        private static ArrayList<Runnable> m_Runnables = new ArrayList();
        private static Runnable m_ActualJob;
        private static Thread m_HandlerThread;
        private static boolean m_HandlerStop;
        private static boolean m_HandlerStopWaitForJobs;
        private static final Object m_SyncRunnables;
        private static final Object m_SyncThread;
        private static boolean m_IsWorking;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void addJob(Runnable p_Runnable) {
            if (p_Runnable == null) {
                return;
            }
            if (m_HandlerStop || m_HandlerStopWaitForJobs) {
                return;
            }
            Object object = m_SyncThread;
            synchronized (object) {
                if (m_HandlerThread == null) {
                    Runnable o_RunnableHandler = new Runnable(){

                        @Override
                        public void run() {
                            RemoteHandler.runJobs();
                        }
                    };
                    m_HandlerThread = new Thread(null, o_RunnableHandler, RemoteHandler.class.getSimpleName());
                    m_HandlerThread.start();
                }
            }
            object = m_SyncRunnables;
            synchronized (object) {
                if (m_Runnables.contains(p_Runnable)) {
                    return;
                }
                m_Runnables.add(p_Runnable);
                m_SyncRunnables.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void removeJob(Runnable p_Runnable) {
            Object object = m_SyncRunnables;
            synchronized (object) {
                m_Runnables.remove(p_Runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runJobs() {
            while (!(m_HandlerStop || m_HandlerStopWaitForJobs && m_Runnables.size() <= 0)) {
                Runnable o_Runnable = null;
                m_ActualJob = null;
                Object object = m_SyncRunnables;
                synchronized (object) {
                    if (m_HandlerStop) {
                        break;
                    }
                    if (m_Runnables.size() <= 0) {
                        if (m_HandlerStopWaitForJobs) {
                            break;
                        }
                        try {
                            m_IsWorking = false;
                            m_SyncRunnables.wait();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    o_Runnable = m_Runnables.get(0);
                    m_Runnables.remove(0);
                    m_IsWorking = true;
                }
                if (o_Runnable == null) continue;
                m_ActualJob = o_Runnable;
                try {
                    o_Runnable.run();
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    System.out.println("RemoteHandler Error: " + e.getMessage());
                }
            }
            m_IsWorking = false;
        }

        public static boolean isWorking() {
            return m_IsWorking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void clearJobs() {
            Object object = m_SyncRunnables;
            synchronized (object) {
                m_Runnables.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getJobCount() {
            Object object = m_SyncRunnables;
            synchronized (object) {
                return m_Runnables.size();
            }
        }

        public Runnable getActualJob() {
            return m_ActualJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void interrupt(long p_Milliseconds) {
            if (p_Milliseconds < 0L) {
                p_Milliseconds = 0L;
            }
            Object object = m_SyncThread;
            synchronized (object) {
                m_HandlerStopWaitForJobs = true;
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_SyncRunnables.notifyAll();
            }
            try {
                if (Thread.currentThread() != m_HandlerThread && m_HandlerThread != null && m_HandlerThread.isAlive()) {
                    m_HandlerThread.join(p_Milliseconds);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_Runnables.clear();
            }
            object = m_SyncThread;
            synchronized (object) {
                m_HandlerStop = false;
                m_HandlerStopWaitForJobs = false;
                Runnable o_RunnableHandler = new Runnable(){

                    @Override
                    public void run() {
                        RemoteHandler.runJobs();
                    }
                };
                m_HandlerThread = new Thread(null, o_RunnableHandler, RemoteHandler.class.getSimpleName());
                m_HandlerThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void close(long p_Milliseconds) {
            Object object = m_SyncThread;
            synchronized (object) {
                m_HandlerStop = true;
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_SyncRunnables.notifyAll();
            }
            try {
                if (Thread.currentThread() != m_HandlerThread && m_HandlerThread != null && m_HandlerThread.isAlive()) {
                    m_HandlerThread.join(p_Milliseconds);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_Runnables.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void closeWaitForJobs(long p_Milliseconds) {
            if (p_Milliseconds < 0L) {
                p_Milliseconds = 0L;
            }
            Object object = m_SyncThread;
            synchronized (object) {
                m_HandlerStopWaitForJobs = true;
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_SyncRunnables.notifyAll();
            }
            try {
                if (Thread.currentThread() != m_HandlerThread && m_HandlerThread != null && m_HandlerThread.isAlive()) {
                    m_HandlerThread.join(p_Milliseconds);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = m_SyncRunnables;
            synchronized (object) {
                m_Runnables.clear();
            }
        }

        static {
            m_HandlerStop = false;
            m_HandlerStopWaitForJobs = false;
            m_SyncRunnables = new Object();
            m_SyncThread = new Object();
        }
    }

    public static class RemoteController
    implements LiveShowVIPListener,
    LiveShowInternalFrame_PlayJingles.JingleListener,
    LiveShowJingleGroup.JingleGroupListener,
    LiveShowTimer.LiveShowTimerListener,
    PlayListener,
    LiveShowSceneBookPanel.SceneBookListener,
    LiveShowDMXStageView.LiveShowDMXStageViewListener,
    Message_Status_DMXStageView.DMXDimensionEventListener,
    JPanel_RemoteBoard.RemoteBoardListener,
    PropertyChangeListener {
        LiveShowInternalFrame_RemoteServer m_LiveShowInternalFrame_RemoteServer;
        private LiveShowSoundVIP m_LiveShowSoundVIP;
        private LiveShowDMXVIP m_LiveShowDMXVIP;
        private LiveShowMediaVIP m_LiveShowMediaVIP;
        private LiveShowSceneBridge m_ActualSceneBridge_Sound;
        private LiveShowSceneBridge m_PreviousMainSceneBridge_Sound;
        private LiveShowSceneBridge m_PreviousSceneBridge_Sound;
        private LiveShowSceneBridge m_NextMainSceneBridge_Sound;
        private LiveShowSceneBridge m_NextSceneBridge_Sound;
        private boolean m_ActualStopAtStart_Sound;
        private LiveShowSceneBridge m_ActualSceneBridge_DMX;
        private LiveShowSceneBridge m_PreviousMainSceneBridge_DMX;
        private LiveShowSceneBridge m_PreviousSceneBridge_DMX;
        private LiveShowSceneBridge m_NextMainSceneBridge_DMX;
        private LiveShowSceneBridge m_NextSceneBridge_DMX;
        private boolean m_ActualStopAtStart_DMX;
        private LiveShowSceneBridge m_ActualSceneBridge_Media;
        private LiveShowSceneBridge m_PreviousMainSceneBridge_Media;
        private LiveShowSceneBridge m_PreviousSceneBridge_Media;
        private LiveShowSceneBridge m_NextMainSceneBridge_Media;
        private LiveShowSceneBridge m_NextSceneBridge_Media;
        private boolean m_ActualStopAtStart_Media;
        private Play m_ActualPlay_Sound;
        private Play m_ActualPlay_DMX;
        private Play m_ActualPlay_Media;
        private PlayControlPanel m_PlayControlPanel;
        private boolean m_ActualWarning1;
        private boolean m_ActualWarning2;
        private ControlObject m_ControlObject_MainSoundVolume;
        private double m_ValueNormed_MainSoundVolume;
        private ControlObject m_ControlObject_MainDMXDimmer;
        private double m_ValueNormed_MainDMXDimmer;
        private ControlObject m_ControlObject_MainMediaDimmer;
        private double m_ValueNormed_MainMediaDimmer;
        private ControlObject m_ControlObject_MainMediaSoundVolume;
        private double m_ValueNormed_MainMediaSoundVolume;
        private boolean m_ValueMasterSoundSetByRemote;
        private boolean m_ValueMasterDMXSetByRemote;
        private boolean m_ValueMasterMediaSetByRemote;
        private boolean m_ValueMasterMediaSoundSetByRemote;
        private ArrayList<LiveShowSceneBridge> m_ChangedSceneBridges;
        private ArrayList<LiveShowInternalFrame_PlayJingles.SoundJingleView> m_SoundJingleViews;
        private ArrayList<LiveShowInternalFrame_PlayJingles.DMXJingleView> m_DMXJingleViews;
        private ArrayList<LiveShowInternalFrame_PlayJingles.MediaJingleView> m_MediaJingleViews;
        private ArrayList<LiveShowInternalFrame_PlayJingles.SPITJingleView> m_SPITJingleViews;
        private boolean m_DMXStageViewRequested;
        private ControlObject.ControlDimension m_ValueDimensionSetByRemote;
        private int m_ActualDMXUniverseIndex;
        private HashMap<String, Message_Status_DMXStageView.DMXControlComponentDescription> m_DMXControlDescriptions;
        private final Object m_SyncDMXControlComponent = new Object();
        private final Object m_SyncThread = new Object();
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private final Object m_SyncJingles = new Object();
        private Runnable m_Runnable_sendMessage_VipObjectParamChanged = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList o_LiveShowSceneBridges;
                Object object = m_SyncThread;
                synchronized (object) {
                    if (m_ChangedSceneBridges == null) {
                        return;
                    }
                    if (m_ChangedSceneBridges.size() <= 0) {
                        return;
                    }
                    o_LiveShowSceneBridges = new ArrayList(m_ChangedSceneBridges.size());
                    o_LiveShowSceneBridges.addAll(m_ChangedSceneBridges);
                    m_ChangedSceneBridges.clear();
                }
                for (int intSceneBridge = 0; intSceneBridge < o_LiveShowSceneBridges.size(); ++intSceneBridge) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intSceneBridge);
                    this.sendMessage_VipObjectParamChanged(null, o_LiveShowSceneBridge.getLiveShowVIP(), (LiveShowObjectInterface)o_LiveShowSceneBridge);
                }
            }
        };

        public RemoteController(LiveShowInternalFrame_RemoteServer p_LiveShowInternalFrame_RemoteServer) {
            this.initMembers();
            this.m_LiveShowInternalFrame_RemoteServer = p_LiveShowInternalFrame_RemoteServer;
            LiveShowTimer.selfReference().addLiveShowTimerListener((LiveShowTimer.LiveShowTimerListener)this);
            this.fillJingles();
            LiveShowInternalFrame_PlayJingles.addJingleListener(this);
            LiveShowJingleGroup.addJingleGroupListener(this);
            LiveShowDMXStageView.addLiveShowStageViewListener((LiveShowDMXStageView.LiveShowDMXStageViewListener)this);
            this.setDMXStageView_DMXMixerPanel(LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel());
            this.m_ControlObject_MainDMXDimmer = LiveShowInternalFrame_MixerMain.getDMXControl_Dimmer().getControlObject(0);
            this.m_ControlObject_MainSoundVolume = LiveShowInternalFrame_MixerMain.getSoundControl_Volume().getControlObject(0);
            this.m_ControlObject_MainMediaDimmer = LiveShowInternalFrame_MixerMain.getMediaControl_Transparency().getControlObject(0);
            this.m_ControlObject_MainMediaSoundVolume = LiveShowInternalFrame_MixerMain.getMediaControl_SoundVolume().getControlObject(0);
            this.m_ControlObject_MainDMXDimmer.addPropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ValueNormed_MainDMXDimmer = 0.0;
            this.m_ControlObject_MainSoundVolume.addPropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ValueNormed_MainSoundVolume = 0.0;
            this.m_ControlObject_MainMediaDimmer.addPropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ValueNormed_MainMediaDimmer = 0.0;
            this.m_ControlObject_MainMediaSoundVolume.addPropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ValueNormed_MainMediaSoundVolume = 0.0;
            DMXUniverse.addStageViewListener((LiveShowDMXStageView.LiveShowDMXStageViewListener)this);
            DMXDeviceGroup.addStageViewListener((LiveShowDMXStageView.LiveShowDMXStageViewListener)this);
            JPanel_RemoteBoard.addRemoteBoardListener(this);
        }

        private void initMembers() {
            this.m_ActualPlay_DMX = null;
            this.m_ActualPlay_Sound = null;
            this.m_ActualPlay_Media = null;
            this.m_ActualSceneBridge_Sound = null;
            this.m_PreviousSceneBridge_Sound = null;
            this.m_NextSceneBridge_Sound = null;
            this.m_ActualSceneBridge_DMX = null;
            this.m_PreviousSceneBridge_DMX = null;
            this.m_NextSceneBridge_DMX = null;
            this.m_ActualSceneBridge_Media = null;
            this.m_PreviousSceneBridge_Media = null;
            this.m_NextSceneBridge_Media = null;
            this.m_ActualWarning1 = false;
            this.m_ActualWarning2 = false;
            this.m_SoundJingleViews = new ArrayList();
            this.m_DMXJingleViews = new ArrayList();
            this.m_MediaJingleViews = new ArrayList();
            this.m_SPITJingleViews = new ArrayList();
            this.m_ValueNormed_MainDMXDimmer = 0.0;
            this.m_ValueNormed_MainSoundVolume = 0.0;
            this.m_ValueNormed_MainMediaDimmer = 0.0;
            this.m_ValueNormed_MainMediaSoundVolume = 0.0;
            this.m_ValueMasterSoundSetByRemote = false;
            this.m_ValueMasterDMXSetByRemote = false;
            this.m_ValueMasterMediaSetByRemote = false;
            this.m_ValueMasterMediaSoundSetByRemote = false;
            this.m_ValueDimensionSetByRemote = null;
            this.m_DMXStageViewRequested = false;
            this.m_DMXControlDescriptions = new HashMap();
        }

        public void close() {
            LiveShowTimer.selfReference().removeLiveShowTimerListener((LiveShowTimer.LiveShowTimerListener)this);
            this.m_ControlObject_MainDMXDimmer.removePropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ControlObject_MainSoundVolume.removePropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ControlObject_MainMediaDimmer.removePropertyChangeListener("value", (PropertyChangeListener)this);
            this.m_ControlObject_MainMediaSoundVolume.removePropertyChangeListener("value", (PropertyChangeListener)this);
            LiveShowInternalFrame_PlayJingles.removeJingleListener(this);
            LiveShowJingleGroup.removeJingleGroupListener(this);
            LiveShowDMXStageView.removeLiveShowStageViewListener((LiveShowDMXStageView.LiveShowDMXStageViewListener)this);
            DMXDeviceGroup.removeStageViewListener((LiveShowDMXStageView.LiveShowDMXStageViewListener)this);
            this.setLiveShowSoundVIP(null);
            this.setLiveShowDMXVIP(null);
            this.setLiveShowMediaVIP(null);
        }

        public void requestStatusPlay(RemoteUser p_RemoteUser) {
            this.sendMessage_ActualSceneBridge(p_RemoteUser);
            this.sendMessage_StatusPlay(p_RemoteUser);
            this.sendMessage_TimeWarning(p_RemoteUser);
        }

        public void setPlayControlPanel(PlayControlPanel p_PlayControlPanel) {
            this.m_PlayControlPanel = p_PlayControlPanel;
        }

        public void playNextMainBridge(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionNextMainScene();
            }
        }

        public void playPreviousMainBridge(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPreviousMainScene();
            }
        }

        public void playNextBridge(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionNextScene();
            }
        }

        public void playPreviousBridge(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPreviousScene();
            }
        }

        public void playStart(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPlayStart();
            }
        }

        public void playPause(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPlayPause();
            }
        }

        public void playStop(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_PlayControlPanel != null) {
                this.m_PlayControlPanel.actionPlayStop();
            }
        }

        public void playStartSound(RemoteUser p_RemoteUser) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_Sound != null && (o_PlaySynchronisizer = this.m_ActualPlay_Sound.getPlaySynchronizer()) != null) {
                o_PlaySynchronisizer.addPlayTriggerStart(this.m_ActualPlay_Sound);
                this.m_ActualPlay_Sound.start();
            }
        }

        public void playPauseSound(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_Sound != null) {
                Play.PlaySynchronisizer o_PlaySynchronisizer;
                if (this.m_ActualPlay_Sound.isRunning() && (o_PlaySynchronisizer = this.m_ActualPlay_Sound.getPlaySynchronizer()) != null) {
                    o_PlaySynchronisizer.addPlayTriggerStop(this.m_ActualPlay_Sound);
                }
                this.m_ActualPlay_Sound.pause();
            }
        }

        public void playStartDMX(RemoteUser p_RemoteUser) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_DMX != null && (o_PlaySynchronisizer = this.m_ActualPlay_DMX.getPlaySynchronizer()) != null) {
                o_PlaySynchronisizer.addPlayTriggerStart(this.m_ActualPlay_DMX);
                this.m_ActualPlay_DMX.start();
            }
        }

        public void playPauseDMX(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_DMX != null) {
                Play.PlaySynchronisizer o_PlaySynchronisizer;
                if (this.m_ActualPlay_DMX.isRunning() && (o_PlaySynchronisizer = this.m_ActualPlay_DMX.getPlaySynchronizer()) != null) {
                    o_PlaySynchronisizer.addPlayTriggerStop(this.m_ActualPlay_DMX);
                }
                this.m_ActualPlay_DMX.pause();
            }
        }

        public void playStartMedia(RemoteUser p_RemoteUser) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_Media != null && (o_PlaySynchronisizer = this.m_ActualPlay_Media.getPlaySynchronizer()) != null) {
                o_PlaySynchronisizer.addPlayTriggerStart(this.m_ActualPlay_Media);
                this.m_ActualPlay_Media.start();
            }
        }

        public void playPauseMedia(RemoteUser p_RemoteUser) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (this.m_ActualPlay_Media != null) {
                Play.PlaySynchronisizer o_PlaySynchronisizer;
                if (this.m_ActualPlay_Media.isRunning() && (o_PlaySynchronisizer = this.m_ActualPlay_Media.getPlaySynchronizer()) != null) {
                    o_PlaySynchronisizer.addPlayTriggerStop(this.m_ActualPlay_Media);
                }
                this.m_ActualPlay_Media.pause();
            }
        }

        public void playSceneBridge(RemoteUser p_RemoteUser, Message_PlaySceneBridge p_Message_PlaySceneBridge) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            LiveShowSoundVIP o_LiveShowVIP;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            if (p_Message_PlaySceneBridge == null) {
                return;
            }
            int intVIPType = p_Message_PlaySceneBridge.getVIPType();
            String stringSceneBridgeID = p_Message_PlaySceneBridge.getSceneBridgeID();
            switch (intVIPType) {
                case 0: {
                    o_LiveShowVIP = this.m_LiveShowSoundVIP;
                    break;
                }
                case 1: {
                    o_LiveShowVIP = this.m_LiveShowDMXVIP;
                    break;
                }
                case 2: {
                    o_LiveShowVIP = this.m_LiveShowMediaVIP;
                    break;
                }
                default: {
                    return;
                }
            }
            if (o_LiveShowVIP == null) {
                return;
            }
            LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(stringSceneBridgeID);
            if (o_LiveShowSceneBridge == null) {
                return;
            }
            o_LiveShowVIP.gotoSceneBridge(o_LiveShowSceneBridge, false);
            PlayControlPanel o_PlayControlPanel = this.m_PlayControlPanel;
            if (o_PlayControlPanel != null && (o_PlaySynchronisizer = o_PlayControlPanel.getPlaySynchronisizer()) != null) {
                o_PlaySynchronisizer.actionStartPlaysSceneBridge();
            }
        }

        public void playFromStart(RemoteUser p_RemoteUser) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            PlayControlPanel o_PlayControlPanel = this.m_PlayControlPanel;
            if (o_PlayControlPanel != null && (o_PlaySynchronisizer = o_PlayControlPanel.getPlaySynchronisizer()) != null) {
                o_PlaySynchronisizer.clearPlaysTriggerSceneBridge();
                o_PlaySynchronisizer.actionPlayRewind();
                o_PlaySynchronisizer.actionPlayStart();
            }
        }

        public void playRewind(RemoteUser p_RemoteUser) {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            PlayControlPanel o_PlayControlPanel = this.m_PlayControlPanel;
            if (o_PlayControlPanel != null && (o_PlaySynchronisizer = o_PlayControlPanel.getPlaySynchronisizer()) != null) {
                o_PlaySynchronisizer.actionPlayRewind();
            }
        }

        public void setLiveShowSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP) {
            if (this.m_LiveShowSoundVIP != null) {
                this.m_LiveShowSoundVIP.removeLiveShowVIPListener((LiveShowVIPListener)this);
                if (this.m_ActualPlay_Sound != null) {
                    this.m_ActualPlay_Sound.removePlayListener((PlayListener)this);
                }
            }
            this.m_LiveShowSoundVIP = p_LiveShowSoundVIP;
            if (this.m_LiveShowSoundVIP != null) {
                this.m_LiveShowSoundVIP.addLiveShowVIPListener((LiveShowVIPListener)this);
                this.m_ActualSceneBridge_Sound = this.m_LiveShowSoundVIP.getLiveShowSceneBridge_Actual();
                this.m_PreviousMainSceneBridge_Sound = this.m_LiveShowSoundVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Sound, true);
                this.m_PreviousSceneBridge_Sound = this.m_LiveShowSoundVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Sound, false);
                this.m_NextMainSceneBridge_Sound = this.m_LiveShowSoundVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Sound, true);
                this.m_NextSceneBridge_Sound = this.m_LiveShowSoundVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Sound, false);
                this.m_ActualStopAtStart_Sound = true;
                this.m_ActualPlay_Sound = this.m_LiveShowSoundVIP.getPlay();
                if (this.m_ActualPlay_Sound != null) {
                    this.m_ActualPlay_Sound.addPlayListener((PlayListener)this);
                    if (this.m_ActualPlay_Sound.isRunning()) {
                        this.m_ActualStopAtStart_Sound = false;
                    }
                }
            }
            this.sendMessage_ActualSceneBridge(null);
            this.sendMessage_StatusPlay(null);
            this.sendMessage_TimeWarning(null);
        }

        public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
            if (this.m_LiveShowDMXVIP != null) {
                this.m_LiveShowDMXVIP.removeLiveShowVIPListener((LiveShowVIPListener)this);
                if (this.m_ActualPlay_DMX != null) {
                    this.m_ActualPlay_DMX.removePlayListener((PlayListener)this);
                }
            }
            this.m_LiveShowDMXVIP = p_LiveShowDMXVIP;
            if (this.m_LiveShowDMXVIP != null) {
                this.m_LiveShowDMXVIP.addLiveShowVIPListener((LiveShowVIPListener)this);
                this.m_ActualSceneBridge_DMX = this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Actual();
                this.m_PreviousMainSceneBridge_DMX = this.m_LiveShowDMXVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_DMX, true);
                this.m_PreviousSceneBridge_DMX = this.m_LiveShowDMXVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_DMX, false);
                this.m_NextMainSceneBridge_DMX = this.m_LiveShowDMXVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_DMX, true);
                this.m_NextSceneBridge_DMX = this.m_LiveShowDMXVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_DMX, false);
                this.m_ActualStopAtStart_DMX = true;
                this.m_ActualPlay_DMX = this.m_LiveShowDMXVIP.getPlay();
                if (this.m_ActualPlay_DMX != null) {
                    this.m_ActualPlay_DMX.addPlayListener((PlayListener)this);
                    if (this.m_ActualPlay_DMX.isRunning()) {
                        this.m_ActualStopAtStart_DMX = false;
                    }
                }
            }
            this.sendMessage_ActualSceneBridge(null);
            this.sendMessage_StatusPlay(null);
            this.sendMessage_TimeWarning(null);
        }

        public void setLiveShowMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP) {
            if (this.m_LiveShowMediaVIP != null) {
                this.m_LiveShowMediaVIP.removeLiveShowVIPListener((LiveShowVIPListener)this);
                if (this.m_ActualPlay_Media != null) {
                    this.m_ActualPlay_Media.removePlayListener((PlayListener)this);
                }
            }
            this.m_LiveShowMediaVIP = p_LiveShowMediaVIP;
            if (this.m_LiveShowMediaVIP != null) {
                this.m_LiveShowMediaVIP.addLiveShowVIPListener((LiveShowVIPListener)this);
                this.m_ActualSceneBridge_Media = this.m_LiveShowMediaVIP.getLiveShowSceneBridge_Actual();
                this.m_PreviousMainSceneBridge_Media = this.m_LiveShowMediaVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Media, true);
                this.m_PreviousSceneBridge_Media = this.m_LiveShowMediaVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Media, false);
                this.m_NextMainSceneBridge_Media = this.m_LiveShowMediaVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Media, true);
                this.m_NextSceneBridge_Media = this.m_LiveShowMediaVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Media, false);
                this.m_ActualStopAtStart_Media = true;
                this.m_ActualPlay_Media = this.m_LiveShowMediaVIP.getPlay();
                if (this.m_ActualPlay_Media != null) {
                    this.m_ActualPlay_Media.addPlayListener((PlayListener)this);
                    if (this.m_ActualPlay_Media.isRunning()) {
                        this.m_ActualStopAtStart_Media = false;
                    }
                }
            }
            this.sendMessage_ActualSceneBridge(null);
            this.sendMessage_StatusPlay(null);
            this.sendMessage_TimeWarning(null);
        }

        public void sendMessage_StatusPlay(RemoteUser p_RemoteUser) {
            boolean boolActive;
            Message_Status_Play o_Message_Status_Play;
            Play o_Play = this.m_ActualPlay_Sound;
            LiveShowSoundVIP o_LiveShowVIP = this.m_LiveShowSoundVIP;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                if (o_Play == null) {
                    o_Message_Status_Play = new Message_Status_Play(0, false, true, false);
                } else {
                    boolActive = false;
                    if (o_LiveShowVIP != null) {
                        boolActive = o_LiveShowVIP.getActive();
                    }
                    o_Message_Status_Play = new Message_Status_Play(0, o_Play.isRunning(), false, boolActive);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Play);
            }
            o_Play = this.m_ActualPlay_DMX;
            o_LiveShowVIP = this.m_LiveShowDMXVIP;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                if (o_Play == null) {
                    o_Message_Status_Play = new Message_Status_Play(1, false, true, false);
                } else {
                    boolActive = false;
                    if (o_LiveShowVIP != null) {
                        boolActive = o_LiveShowVIP.getActive();
                    }
                    o_Message_Status_Play = new Message_Status_Play(1, o_Play.isRunning(), false, boolActive);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Play);
            }
            o_Play = this.m_ActualPlay_Media;
            o_LiveShowVIP = this.m_LiveShowMediaVIP;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                if (o_Play == null) {
                    o_Message_Status_Play = new Message_Status_Play(2, false, true, false);
                } else {
                    boolActive = false;
                    if (o_LiveShowVIP != null) {
                        boolActive = o_LiveShowVIP.getActive();
                    }
                    o_Message_Status_Play = new Message_Status_Play(2, o_Play.isRunning(), false, boolActive);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Play);
            }
        }

        public void eventPlayStart(Play p_Play) {
            this.sendMessage_StatusPlay(null);
        }

        public void eventPlayStop(Play p_Play) {
            this.sendMessage_StatusPlay(null);
        }

        public void eventPlayPause(Play p_Play) {
            this.sendMessage_StatusPlay(null);
        }

        public void eventPlayRewind(Play p_Play) {
        }

        public void eventPlayFastForward(Play p_Play) {
        }

        public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        }

        public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
        }

        public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
            return p_FramesToRead;
        }

        public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        }

        public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
        }

        public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        }

        public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        }

        public void eventPlayClosing(Play p_Play) {
        }

        public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
        }

        public void eventPlayTimelineEnd(Play p_Play) {
        }

        public void sendMessage_TimeWarning(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_TimeWarning1 o_Message_Status_Warning1 = new Message_Status_TimeWarning1(-1, this.m_ActualWarning1);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Warning1);
                Message_Status_TimeWarning2 o_Message_Status_Warning2 = new Message_Status_TimeWarning2(-1, this.m_ActualWarning2);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Warning2);
            }
        }

        public void eventTimeNextAction(LiveShowTimer p_LiveShowTimer, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, long p_TimeFrames, String p_TimeString, boolean p_TimeRecorded, Color p_ColorForeground) {
        }

        public void eventTimeNextOneStopped(LiveShowTimer p_LiveShowTimer, boolean p_OneStopped) {
        }

        public void eventTimeWarning1(LiveShowTimer p_LiveShowTimer, boolean p_On) {
            if (this.m_ActualWarning1 == p_On) {
                return;
            }
            this.m_ActualWarning1 = p_On;
            this.sendMessage_TimeWarning(null);
        }

        public void eventTimeWarning2(LiveShowTimer p_LiveShowTimer, boolean p_On) {
            if (this.m_ActualWarning2 == p_On) {
                return;
            }
            this.m_ActualWarning2 = p_On;
            this.sendMessage_TimeWarning(null);
        }

        public void eventTimeRecordOn(LiveShowTimer p_LiveShowTimer, boolean p_RecordRunning) {
        }

        public void eventShowTimeRecorded(LiveShowTimer p_LiveShowTimer, boolean p_ShowTimeRecorded) {
        }

        public void sendMessage_ActualSceneBridge(RemoteUser p_RemoteUser) {
            LiveShowSoundVIP o_LiveShowSoundVIP = this.m_LiveShowSoundVIP;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription;
                LiveShowSceneBridge o_LiveShowSceneBridge;
                Message_Status_SceneBridgeCursor o_Message_ScenebridgeCursor;
                if (o_LiveShowSoundVIP != null && o_LiveShowSoundVIP.getActive()) {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(this.m_ActualStopAtStart_Sound, 0, true);
                    o_LiveShowSceneBridge = this.m_ActualSceneBridge_Sound;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setActualSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousMainSceneBridge_Sound;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousSceneBridge_Sound;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextMainSceneBridge_Sound;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextSceneBridge_Sound;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextSceneBridge(o_BridgeDescription);
                    }
                } else {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(false, 0, false);
                    o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_ScenebridgeCursor);
                LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
                if (o_LiveShowDMXVIP != null && o_LiveShowDMXVIP.getActive()) {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(this.m_ActualStopAtStart_DMX, 1, true);
                    o_LiveShowSceneBridge = this.m_ActualSceneBridge_DMX;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setActualSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousMainSceneBridge_DMX;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousSceneBridge_DMX;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextMainSceneBridge_DMX;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextSceneBridge_DMX;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextSceneBridge(o_BridgeDescription);
                    }
                } else {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(false, 1, false);
                    o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_ScenebridgeCursor);
                LiveShowMediaVIP o_LiveShowMediaVIP = this.m_LiveShowMediaVIP;
                if (o_LiveShowMediaVIP != null && o_LiveShowMediaVIP.getActive()) {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(this.m_ActualStopAtStart_Media, 2, true);
                    o_LiveShowSceneBridge = this.m_ActualSceneBridge_Media;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setActualSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousMainSceneBridge_Media;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_PreviousSceneBridge_Media;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setPreviousSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextMainSceneBridge_Media;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextMainSceneBridge(o_BridgeDescription);
                    }
                    o_LiveShowSceneBridge = this.m_NextSceneBridge_Media;
                    if (o_LiveShowSceneBridge == null) {
                        o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                    } else {
                        o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getActive());
                        o_Message_ScenebridgeCursor.setNextSceneBridge(o_BridgeDescription);
                    }
                } else {
                    o_Message_ScenebridgeCursor = new Message_Status_SceneBridgeCursor(false, 2, false);
                    o_Message_ScenebridgeCursor.setActualSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setPreviousSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextMainSceneBridge(null);
                    o_Message_ScenebridgeCursor.setNextSceneBridge(null);
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_ScenebridgeCursor);
            }
        }

        public String getStageDirection(boolean p_Pre, LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return "";
            }
            StringBuffer stringDirection = new StringBuffer();
            LiveShowHTMLDocument o_LiveShowEditorDocument = p_Pre ? LiveShowInternalFrame_SceneBook.getLiveShowEditorDocument_Pre(p_LiveShowSceneBridge) : LiveShowInternalFrame_SceneBook.getLiveShowEditorDocument_Post(p_LiveShowSceneBridge);
            if (o_LiveShowEditorDocument == null) {
                return "";
            }
            try {
                String stringDocument = o_LiveShowEditorDocument.getText(0, o_LiveShowEditorDocument.getLength());
                int intIndex = stringDocument.indexOf("\"");
                while (intIndex >= 0) {
                    try {
                        stringDocument = stringDocument.substring(intIndex + 1, stringDocument.length());
                    }
                    catch (Exception e) {
                        return stringDirection.toString();
                    }
                    intIndex = stringDocument.indexOf("\"");
                    if (intIndex > 0) {
                        try {
                            if (stringDirection.length() > 0) {
                                stringDirection.append("\"");
                            }
                            stringDirection.append(stringDocument.substring(0, intIndex));
                            stringDocument = stringDocument.substring(intIndex + 1, stringDocument.length());
                        }
                        catch (Exception e) {
                            return stringDirection.toString();
                        }
                    } else {
                        if (stringDirection.length() > 0) {
                            stringDirection.append(" \n");
                        }
                        stringDirection.append(stringDocument);
                    }
                    intIndex = stringDocument.indexOf("\"");
                }
            }
            catch (Exception e) {
                return "";
            }
            return stringDirection.toString();
        }

        public void setActualSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_ActualPlayInside, boolean p_ActualStopAtStart) {
            if (p_LiveShowVIP == null) {
                return;
            }
            if (p_LiveShowVIP instanceof LiveShowSoundVIP) {
                this.m_ActualSceneBridge_Sound = p_LiveShowSceneBridge == null ? null : p_LiveShowSceneBridge;
                this.m_ActualStopAtStart_Sound = p_ActualStopAtStart;
                if (!p_ActualPlayInside) {
                    this.m_PreviousSceneBridge_Sound = this.m_ActualSceneBridge_Sound;
                    this.m_NextSceneBridge_Sound = p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Sound, false);
                } else {
                    this.m_PreviousSceneBridge_Sound = p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Sound, false);
                    this.m_NextSceneBridge_Sound = p_ActualStopAtStart ? this.m_ActualSceneBridge_Sound : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Sound, false);
                }
                this.m_PreviousMainSceneBridge_Sound = this.m_PreviousSceneBridge_Sound == null || this.m_PreviousSceneBridge_Sound.getIsMainBridge() ? this.m_PreviousSceneBridge_Sound : p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Sound, true);
                this.m_NextMainSceneBridge_Sound = this.m_NextSceneBridge_Sound == null || this.m_NextSceneBridge_Sound.getIsMainBridge() ? this.m_NextSceneBridge_Sound : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Sound, true);
            } else if (p_LiveShowVIP instanceof LiveShowDMXVIP) {
                this.m_ActualSceneBridge_DMX = p_LiveShowSceneBridge == null ? null : p_LiveShowSceneBridge;
                this.m_ActualStopAtStart_DMX = p_ActualStopAtStart;
                if (!p_ActualPlayInside) {
                    this.m_PreviousSceneBridge_DMX = this.m_ActualSceneBridge_DMX;
                    this.m_NextSceneBridge_DMX = p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_DMX, false);
                } else {
                    this.m_PreviousSceneBridge_DMX = p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_DMX, false);
                    this.m_NextSceneBridge_DMX = p_ActualStopAtStart ? this.m_ActualSceneBridge_DMX : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_DMX, false);
                }
                this.m_PreviousMainSceneBridge_DMX = this.m_PreviousSceneBridge_DMX == null || this.m_PreviousSceneBridge_DMX.getIsMainBridge() ? this.m_PreviousSceneBridge_DMX : p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_DMX, true);
                this.m_NextMainSceneBridge_DMX = this.m_NextSceneBridge_DMX == null || this.m_NextSceneBridge_DMX.getIsMainBridge() ? this.m_NextSceneBridge_DMX : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_DMX, true);
            } else if (p_LiveShowVIP instanceof LiveShowMediaVIP) {
                this.m_ActualSceneBridge_Media = p_LiveShowSceneBridge == null ? null : p_LiveShowSceneBridge;
                this.m_ActualStopAtStart_Media = p_ActualStopAtStart;
                if (!p_ActualPlayInside) {
                    this.m_PreviousSceneBridge_Media = this.m_ActualSceneBridge_Media;
                    this.m_NextSceneBridge_Media = p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Media, false);
                } else {
                    this.m_PreviousSceneBridge_Media = p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Media, false);
                    this.m_NextSceneBridge_Media = p_ActualStopAtStart ? this.m_ActualSceneBridge_Media : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Media, false);
                }
                this.m_PreviousMainSceneBridge_Media = this.m_PreviousSceneBridge_Media == null || this.m_PreviousSceneBridge_Media.getIsMainBridge() ? this.m_PreviousSceneBridge_Media : p_LiveShowVIP.getLiveShowSceneBridge_PreviousToPlay(this.m_ActualSceneBridge_Media, true);
                this.m_NextMainSceneBridge_Media = this.m_NextSceneBridge_Media == null || this.m_NextSceneBridge_Media.getIsMainBridge() ? this.m_NextSceneBridge_Media : p_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(this.m_ActualSceneBridge_Media, true);
            }
            this.sendMessage_ActualSceneBridge(null);
        }

        public void requestSceneBook(RemoteUser p_RemoteUser) {
            this.sendMessage_SceneBookChanged(p_RemoteUser);
        }

        public void eventSceneBookClose(LiveShowSceneBookPanel p_LiveShowSceneBookPanel) {
            this.sendMessage_SceneBookClose(null);
        }

        public void eventSceneBookChanged(LiveShowSceneBookPanel p_LiveShowSceneBookPanel) {
            if (this.m_LiveShowSceneBookPanel == null) {
                return;
            }
            if (this.m_LiveShowSceneBookPanel != p_LiveShowSceneBookPanel) {
                return;
            }
            this.sendMessage_SceneBookChanged(null);
            this.sendMessage_ActualSceneBridge(null);
        }

        public void sendMessage_SceneBookChanged(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Scenebook o_Message_Scenebook = new Message_Scenebook();
                if (this.m_LiveShowSoundVIP != null && this.m_LiveShowSoundVIP.getActive()) {
                    o_Message_Scenebook.addVIPType(0);
                }
                if (this.m_LiveShowDMXVIP != null && this.m_LiveShowDMXVIP.getActive()) {
                    o_Message_Scenebook.addVIPType(1);
                }
                if (this.m_LiveShowMediaVIP != null && this.m_LiveShowMediaVIP.getActive()) {
                    o_Message_Scenebook.addVIPType(2);
                }
                for (int intMainBridge = 0; intMainBridge < this.m_LiveShowSceneBookPanel.getMainPanelSceneBridgeCount(); ++intMainBridge) {
                    boolean boolActive;
                    Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription;
                    LiveShowVIP o_LiveShowVIP;
                    LiveShowSceneBridge o_LiveShowSceneBridge;
                    LiveShowSceneBookPanel.SceneBook_MainPanelSceneBridge o_MainPanelSceneBridge = this.m_LiveShowSceneBookPanel.getMainPanelSceneBridge(intMainBridge);
                    if (o_MainPanelSceneBridge == null) continue;
                    boolean boolContainsBridges = false;
                    boolean boolActiveMainBridge = true;
                    LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = o_MainPanelSceneBridge.getLiveShowSceneBridgeMain();
                    Message_Scenebook.ScenebookRow o_MessageSceneBookRow = new Message_Scenebook.ScenebookRow();
                    if (o_LiveShowSceneBridgeMain != null) {
                        if (!o_LiveShowSceneBridgeMain.getActive()) {
                            boolActiveMainBridge = false;
                        }
                        for (int intBridge = 0; intBridge < o_LiveShowSceneBridgeMain.getLiveShowSceneBridgeCount(); ++intBridge) {
                            o_LiveShowSceneBridge = o_LiveShowSceneBridgeMain.getLiveShowSceneBridge(intBridge);
                            if (o_LiveShowSceneBridge == null || (o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP()) == null || !o_LiveShowVIP.getActive() || (o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, boolActive = boolActiveMainBridge ? o_LiveShowSceneBridge.getActive() : false)) == null) continue;
                            o_MessageSceneBookRow.addBridgeDescription(o_BridgeDescription);
                            boolContainsBridges = true;
                        }
                    }
                    o_Message_Scenebook.addScenebookRow(o_MessageSceneBookRow);
                    for (int intRow = 0; intRow < o_MainPanelSceneBridge.getSceneBookRowCount(); ++intRow) {
                        LiveShowSceneBookPanel.SceneBookRow o_SceneBookRow = o_MainPanelSceneBridge.getSceneBookRow(intRow);
                        if (o_SceneBookRow == null) continue;
                        boolContainsBridges = false;
                        o_MessageSceneBookRow = new Message_Scenebook.ScenebookRow();
                        for (int intBridge = 0; intBridge < o_SceneBookRow.getSceneBookItemCount(); ++intBridge) {
                            LiveShowSceneBookPanel.SceneBookItem o_SceneBookItem = o_SceneBookRow.getSceneBookItem(intBridge);
                            if (o_SceneBookItem == null || (o_LiveShowSceneBridge = o_SceneBookItem.getLiveShowSceneBridge()) == null || (o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP()) == null || !o_LiveShowVIP.getActive() || (o_BridgeDescription = this.createBrideDescription(o_LiveShowSceneBridge, boolActive = boolActiveMainBridge ? o_LiveShowSceneBridge.getActive() : false)) == null) continue;
                            o_MessageSceneBookRow.addBridgeDescription(o_BridgeDescription);
                            boolContainsBridges = true;
                        }
                        if (!boolContainsBridges) continue;
                        o_Message_Scenebook.addScenebookRow(o_MessageSceneBookRow);
                    }
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Scenebook);
            }
        }

        public void sendMessage_SceneBookClose(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Scenebook o_Message_SceneBook = new Message_Scenebook();
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_SceneBook);
            }
        }

        public void setLiveShowSceneBookPanel(LiveShowSceneBookPanel p_LiveShowSceneBookPanel) {
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.removeSceneBookListener((LiveShowSceneBookPanel.SceneBookListener)this);
            }
            this.m_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.addSceneBookListener((LiveShowSceneBookPanel.SceneBookListener)this);
            }
            this.eventSceneBookChanged(p_LiveShowSceneBookPanel);
        }

        public Message_Status_SceneBridgeCursor.BridgeDescription createBrideDescription(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Active) {
            int intVIPType;
            if (p_LiveShowSceneBridge == null) {
                return null;
            }
            if (p_LiveShowSceneBridge.getID() == null) {
                return null;
            }
            String stringStageDirectionPre = this.getStageDirection(true, p_LiveShowSceneBridge);
            String stringStageDirectionPost = this.getStageDirection(false, p_LiveShowSceneBridge);
            boolean boolHasJump = false;
            if (p_LiveShowSceneBridge.getJumpSceneBridge() != null && p_LiveShowSceneBridge.getJumpActive() && p_LiveShowSceneBridge.getJumpPossible()) {
                boolHasJump = true;
            }
            long longMaxTime = p_LiveShowSceneBridge.getTimeToNextSceneBridge();
            if (p_LiveShowSceneBridge.getObjectType() == 2) {
                intVIPType = 0;
            } else if (p_LiveShowSceneBridge.getObjectType() == 12) {
                intVIPType = 1;
            } else if (p_LiveShowSceneBridge.getObjectType() == 22) {
                intVIPType = 2;
            } else {
                return null;
            }
            Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription = new Message_Status_SceneBridgeCursor.BridgeDescription(intVIPType, p_LiveShowSceneBridge.getID(), p_LiveShowSceneBridge.getName(), p_LiveShowSceneBridge.getIsMainBridge(), p_LiveShowSceneBridge.getFrameStart(), longMaxTime, p_LiveShowSceneBridge.getStopAtStart(), p_Active, boolHasJump, stringStageDirectionPre, stringStageDirectionPost);
            return o_BridgeDescription;
        }

        public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
            this.requestSceneBook(null);
            this.requestStatusPlay(null);
        }

        public void eventVIPTrackAdded(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
        }

        public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
        }

        public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
        }

        public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
        }

        public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
        }

        public void eventVIPClosing(LiveShowVIP p_LiveShowVIP) {
        }

        public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        }

        public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        }

        public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
        }

        public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
            this.setActualSceneBridge(p_LiveShowVIP, p_LiveShowVIP.getLiveShowSceneBridge_Cursor(), p_ActualPlaying, p_ActualStopAtStart);
        }

        public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
        }

        public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        }

        public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        }

        public void eventVIPObjectAdded(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (!(p_LiveShowObjectInterface instanceof LiveShowSceneBridge)) {
                return;
            }
            if (this.m_ChangedSceneBridges == null) {
                this.m_ChangedSceneBridges = new ArrayList();
            }
            Object object = this.m_SyncThread;
            synchronized (object) {
                if (this.m_ChangedSceneBridges.contains(p_LiveShowObjectInterface)) {
                    return;
                }
                this.m_ChangedSceneBridges.add((LiveShowSceneBridge)p_LiveShowObjectInterface);
            }
        }

        public void sendMessage_VipObjectParamChanged(RemoteUser p_RemoteUser, LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowVIP == null) {
                return;
            }
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            if (!(p_LiveShowObjectInterface instanceof LiveShowSceneBridge)) {
                return;
            }
            LiveShowSceneBridge o_SceneBridge = (LiveShowSceneBridge)p_LiveShowObjectInterface;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                boolean boolActive;
                boolean boolActiveMainBridge = true;
                if (o_SceneBridge.getIsMainBridge()) {
                    boolActive = boolActiveMainBridge = o_SceneBridge.getActive();
                } else {
                    LiveShowSceneBridge o_SceneBridgeMain = p_LiveShowVIP.getLiveShowSceneBridge_Previous(o_SceneBridge, true, false);
                    boolActiveMainBridge = o_SceneBridgeMain == null ? true : o_SceneBridgeMain.getActive();
                    boolActiveMainBridge = true;
                    boolActive = true ? o_SceneBridge.getActive() : false;
                }
                Message_Status_SceneBridgeCursor.BridgeDescription o_BridgeDescription = this.createBrideDescription(o_SceneBridge, boolActive);
                Message_SceneBridgeChanged o_Message_SceneBridgeChanged = new Message_SceneBridgeChanged(o_BridgeDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_SceneBridgeChanged);
                if (o_SceneBridge.getIsMainBridge()) {
                    ArrayList o_LiveShowSceneBridges = null;
                    o_LiveShowSceneBridges = p_LiveShowVIP.getLiveShowSceneBridges_OfMainBridge(o_LiveShowSceneBridges, o_SceneBridge);
                    for (int intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
                        o_SceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge);
                        boolActive = boolActiveMainBridge ? o_SceneBridge.getActive() : false;
                        o_BridgeDescription = this.createBrideDescription(o_SceneBridge, boolActive);
                        Message_SceneBridgeChanged o_Message_SubSceneBridgeChanged = new Message_SceneBridgeChanged(o_BridgeDescription);
                        this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_SubSceneBridgeChanged);
                    }
                }
            }
        }

        public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
        }

        public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        public void eventVIPObjectSelection(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
            RemoteHandler.addJob(this.m_Runnable_sendMessage_VipObjectParamChanged);
        }

        public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
        }

        public void eventVIPCursorMode(LiveShowVIP p_LiveShowVIP, int p_EditMode) {
        }

        public void requestStatusJingles(RemoteUser p_RemoteUser) {
            this.sendMessage_StatusJingle(p_RemoteUser);
            this.sendMessage_StatusJingleGroup(p_RemoteUser);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage_StatusJingle(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_Jingle o_Message_Status_Jingle = new Message_Status_Jingle();
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    Message_Status_Jingle.PlayControlStatus o_JinglePlayStatus;
                    PlayControlPanel.PlayControlPanelStatus o_PlayControlStatus;
                    Message_Status_Jingle.JingleDescription o_JingleDescription;
                    LiveShowInternalFrame_PlayJingles.JingleView o_JingleView;
                    int intJingleView;
                    for (intJingleView = 0; intJingleView < this.m_SoundJingleViews.size(); ++intJingleView) {
                        o_JingleView = this.m_SoundJingleViews.get(intJingleView);
                        if (o_JingleView == null) continue;
                        o_JingleDescription = new Message_Status_Jingle.JingleDescription(0, o_JingleView.getJingleID(), o_JingleView.getJingleName(), o_JingleView.getJingleSourceName());
                        o_PlayControlStatus = o_JingleView.getPlayControlPanelStatus();
                        o_JinglePlayStatus = new Message_Status_Jingle.PlayControlStatus(o_PlayControlStatus.getStartEnabled(), o_PlayControlStatus.getPauseEnabled(), o_PlayControlStatus.getStopEnabled(), o_PlayControlStatus.getFadeInEnabled(), o_PlayControlStatus.getFadeOutEnabled() || o_PlayControlStatus.getFadeOutDirectEnabled(), o_PlayControlStatus.getFastForwardEnabled(), o_PlayControlStatus.getRewindEnabled());
                        o_Message_Status_Jingle.addJingleDescriptionStatus(o_JingleDescription, o_JinglePlayStatus);
                    }
                    for (intJingleView = 0; intJingleView < this.m_DMXJingleViews.size(); ++intJingleView) {
                        o_JingleView = this.m_DMXJingleViews.get(intJingleView);
                        if (o_JingleView == null) continue;
                        o_JingleDescription = new Message_Status_Jingle.JingleDescription(1, o_JingleView.getJingleID(), o_JingleView.getJingleName(), o_JingleView.getJingleSourceName());
                        o_PlayControlStatus = o_JingleView.getPlayControlPanelStatus();
                        o_JinglePlayStatus = new Message_Status_Jingle.PlayControlStatus(o_PlayControlStatus.getStartEnabled(), o_PlayControlStatus.getPauseEnabled(), o_PlayControlStatus.getStopEnabled(), o_PlayControlStatus.getFadeInEnabled(), o_PlayControlStatus.getFadeOutEnabled(), o_PlayControlStatus.getFastForwardEnabled(), o_PlayControlStatus.getRewindEnabled());
                        o_Message_Status_Jingle.addJingleDescriptionStatus(o_JingleDescription, o_JinglePlayStatus);
                    }
                    for (intJingleView = 0; intJingleView < this.m_MediaJingleViews.size(); ++intJingleView) {
                        o_JingleView = this.m_MediaJingleViews.get(intJingleView);
                        if (o_JingleView == null) continue;
                        o_JingleDescription = new Message_Status_Jingle.JingleDescription(2, o_JingleView.getJingleID(), o_JingleView.getJingleName(), o_JingleView.getJingleSourceName());
                        o_PlayControlStatus = o_JingleView.getPlayControlPanelStatus();
                        o_JinglePlayStatus = new Message_Status_Jingle.PlayControlStatus(o_PlayControlStatus.getStartEnabled(), o_PlayControlStatus.getPauseEnabled(), o_PlayControlStatus.getStopEnabled(), o_PlayControlStatus.getFadeInEnabled(), o_PlayControlStatus.getFadeOutEnabled() || o_PlayControlStatus.getFadeOutDirectEnabled(), o_PlayControlStatus.getFastForwardEnabled(), o_PlayControlStatus.getRewindEnabled());
                        o_Message_Status_Jingle.addJingleDescriptionStatus(o_JingleDescription, o_JinglePlayStatus);
                    }
                    for (intJingleView = 0; intJingleView < this.m_SPITJingleViews.size(); ++intJingleView) {
                        o_JingleView = this.m_SPITJingleViews.get(intJingleView);
                        if (o_JingleView == null) continue;
                        o_JingleDescription = new Message_Status_Jingle.JingleDescription(2, o_JingleView.getJingleID(), o_JingleView.getJingleName(), o_JingleView.getJingleSourceName());
                        o_PlayControlStatus = o_JingleView.getPlayControlPanelStatus();
                        o_JinglePlayStatus = new Message_Status_Jingle.PlayControlStatus(o_PlayControlStatus.getStartEnabled(), o_PlayControlStatus.getPauseEnabled(), o_PlayControlStatus.getStopEnabled(), o_PlayControlStatus.getFadeInEnabled(), o_PlayControlStatus.getFadeOutEnabled() || o_PlayControlStatus.getFadeOutDirectEnabled(), o_PlayControlStatus.getFastForwardEnabled(), o_PlayControlStatus.getRewindEnabled());
                        o_Message_Status_Jingle.addJingleDescriptionStatus(o_JingleDescription, o_JinglePlayStatus);
                    }
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Jingle);
            }
        }

        private void fillJingles() {
            ArrayList<LiveShowInternalFrame_PlayJingles.JingleView> o_JingleViews = LiveShowInternalFrame_PlayJingles.getJingleViewList();
            for (int intJingleView = 0; intJingleView < o_JingleViews.size(); ++intJingleView) {
                LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = o_JingleViews.get(intJingleView);
                if (o_JingleView == null) continue;
                if (o_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                    this.m_SoundJingleViews.add((LiveShowInternalFrame_PlayJingles.SoundJingleView)o_JingleView);
                    continue;
                }
                if (o_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                    this.m_DMXJingleViews.add((LiveShowInternalFrame_PlayJingles.DMXJingleView)o_JingleView);
                    continue;
                }
                if (o_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                    this.m_MediaJingleViews.add((LiveShowInternalFrame_PlayJingles.MediaJingleView)o_JingleView);
                    continue;
                }
                if (!(o_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView)) continue;
                this.m_SPITJingleViews.add((LiveShowInternalFrame_PlayJingles.SPITJingleView)o_JingleView);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage_StatusJingleGroup(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_JingleGroup o_Message_Status_JingleGroup = new Message_Status_JingleGroup();
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    for (int intJingleGroup = 0; intJingleGroup < LiveShowJingleGroup.getGroupCount(); ++intJingleGroup) {
                        LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(intJingleGroup);
                        if (o_JingleGroup == null) continue;
                        Message_Status_JingleGroup.JingleGroupDescription o_JingleGroupDescription = new Message_Status_JingleGroup.JingleGroupDescription(o_JingleGroup.getID(), o_JingleGroup.getName(), o_JingleGroup.getRemark());
                        Message_Status_JingleGroup.PlayControlStatus o_JingleGroupPlayStatus = new Message_Status_JingleGroup.PlayControlStatus(o_JingleGroup.getPlayStartEnabled(), o_JingleGroup.getPlayPauseEnabled(), o_JingleGroup.getPlayStopEnabled(), o_JingleGroup.getPlayJingleCount(), o_JingleGroup.getJingleInterfaceCount());
                        o_Message_Status_JingleGroup.addJingleGroupDescriptionStatus(o_JingleGroupDescription, o_JingleGroupPlayStatus);
                    }
                }
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_JingleGroup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowInternalFrame_PlayJingles.JingleView getJingleView(int p_VIPStatus, String p_JingleID) {
            if (p_JingleID == null) {
                return null;
            }
            Object object = this.m_SyncJingles;
            synchronized (object) {
                switch (p_VIPStatus) {
                    case 0: {
                        for (int intJingle = 0; intJingle < this.m_SoundJingleViews.size(); ++intJingle) {
                            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_SoundJingleViews.get(intJingle);
                            if (!p_JingleID.equals(o_JingleView.getJingleID())) continue;
                            return o_JingleView;
                        }
                        return null;
                    }
                    case 1: {
                        for (int intJingle = 0; intJingle < this.m_DMXJingleViews.size(); ++intJingle) {
                            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_DMXJingleViews.get(intJingle);
                            if (!p_JingleID.equals(o_JingleView.getJingleID())) continue;
                            return o_JingleView;
                        }
                        return null;
                    }
                    case 2: {
                        LiveShowInternalFrame_PlayJingles.JingleView o_JingleView;
                        int intJingle;
                        for (intJingle = 0; intJingle < this.m_MediaJingleViews.size(); ++intJingle) {
                            o_JingleView = this.m_MediaJingleViews.get(intJingle);
                            if (!p_JingleID.equals(o_JingleView.getJingleID())) continue;
                            return o_JingleView;
                        }
                        for (intJingle = 0; intJingle < this.m_SPITJingleViews.size(); ++intJingle) {
                            o_JingleView = this.m_SPITJingleViews.get(intJingle);
                            if (!p_JingleID.equals(o_JingleView.getJingleID())) continue;
                            return o_JingleView;
                        }
                        return null;
                    }
                }
                return null;
            }
        }

        @Override
        public void eventJingleAdded(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            this.sendMessage_JingleAdded(null, p_JingleView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage_JingleAdded(RemoteUser p_RemoteUser, LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            int intVIPType;
            if (p_JingleView == null) {
                return;
            }
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                intVIPType = 0;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (!this.m_SoundJingleViews.contains(p_JingleView)) {
                        this.m_SoundJingleViews.add((LiveShowInternalFrame_PlayJingles.SoundJingleView)p_JingleView);
                    }
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                intVIPType = 1;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (!this.m_DMXJingleViews.contains(p_JingleView)) {
                        this.m_DMXJingleViews.add((LiveShowInternalFrame_PlayJingles.DMXJingleView)p_JingleView);
                    }
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                intVIPType = 2;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (!this.m_MediaJingleViews.contains(p_JingleView)) {
                        this.m_MediaJingleViews.add((LiveShowInternalFrame_PlayJingles.MediaJingleView)p_JingleView);
                    }
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView) {
                intVIPType = 2;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (!this.m_SPITJingleViews.contains(p_JingleView)) {
                        this.m_SPITJingleViews.add((LiveShowInternalFrame_PlayJingles.SPITJingleView)p_JingleView);
                    }
                }
            } else {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                LiveShowObject o_LiveShowObject = p_JingleView.getLiveShowObject();
                if (o_LiveShowObject == null) {
                    return;
                }
                Message_Status_Jingle.JingleDescription o_JingleDescription = new Message_Status_Jingle.JingleDescription(intVIPType, p_JingleView.getJingleID(), p_JingleView.getJingleName(), p_JingleView.getJingleSourceName());
                PlayControlPanel.PlayControlPanelStatus o_PlayControlStatus = p_JingleView.getPlayControlPanelStatus();
                Message_Status_Jingle.PlayControlStatus o_JinglePlayStatus = new Message_Status_Jingle.PlayControlStatus(o_PlayControlStatus.getStartEnabled(), o_PlayControlStatus.getPauseEnabled(), o_PlayControlStatus.getStopEnabled(), o_PlayControlStatus.getFadeInEnabled(), o_PlayControlStatus.getFadeOutEnabled(), o_PlayControlStatus.getFastForwardEnabled(), o_PlayControlStatus.getRewindEnabled());
                Message_JingleAdded o_Message_JingleAdded = new Message_JingleAdded(o_JingleDescription, o_JinglePlayStatus);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleAdded);
            }
        }

        @Override
        public void eventJingleRemoved(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            this.sendMesssage_JingleRemoved(null, p_JingleView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMesssage_JingleRemoved(RemoteUser p_RemoteUser, LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            int intVIPType;
            if (p_JingleView == null) {
                return;
            }
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                intVIPType = 0;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    this.m_SoundJingleViews.remove(p_JingleView);
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                intVIPType = 1;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    this.m_DMXJingleViews.remove(p_JingleView);
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                intVIPType = 2;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    this.m_MediaJingleViews.remove(p_JingleView);
                }
            } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView) {
                intVIPType = 2;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    this.m_SPITJingleViews.remove(p_JingleView);
                }
            } else {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_JingleRemoved o_Message_JingleRemoved = new Message_JingleRemoved(intVIPType, p_JingleView.getJingleID());
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleRemoved);
            }
        }

        @Override
        public void eventJingleChanged(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            this.sendMessage_JingleChanged(null, p_JingleView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage_JingleChanged(RemoteUser p_RemoteUser, LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            if (p_JingleView == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                int intVIPType;
                if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                    intVIPType = 0;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_SoundJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                    intVIPType = 1;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_DMXJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                    intVIPType = 2;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_MediaJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView) {
                    intVIPType = 2;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_SPITJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else {
                    return;
                }
                LiveShowObject o_LiveShowObject = p_JingleView.getLiveShowObject();
                if (o_LiveShowObject == null) {
                    return;
                }
                Message_Status_Jingle.JingleDescription o_JingleDescription = new Message_Status_Jingle.JingleDescription(intVIPType, p_JingleView.getJingleID(), p_JingleView.getJingleName(), p_JingleView.getJingleSourceName());
                Message_JingleChanged o_Message_JingleChanged = new Message_JingleChanged(o_JingleDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleChanged);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getVIPType(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
            int intVIPType = -1;
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (this.m_SoundJingleViews.contains(p_JingleView)) {
                        intVIPType = 0;
                    }
                }
            }
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (this.m_DMXJingleViews.contains(p_JingleView)) {
                        intVIPType = 1;
                    }
                }
            }
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (this.m_MediaJingleViews.contains(p_JingleView)) {
                        intVIPType = 2;
                    }
                }
            }
            if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView) {
                intVIPType = 2;
                Object object = this.m_SyncJingles;
                synchronized (object) {
                    if (this.m_SPITJingleViews.contains(p_JingleView)) {
                        intVIPType = 2;
                    }
                }
            }
            return intVIPType;
        }

        @Override
        public void eventJinglePlayControlStatus(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, PlayControlPanel.PlayControlPanelStatus p_PlayControlPanelStatus) {
            this.sendMessage_JinglePlayControlStatus(null, p_JingleView, p_PlayControlPanelStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage_JinglePlayControlStatus(RemoteUser p_RemoteUser, LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, PlayControlPanel.PlayControlPanelStatus p_Status) {
            if (p_JingleView == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                int intVIPType;
                if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SoundJingleView) {
                    intVIPType = 0;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_SoundJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.DMXJingleView) {
                    intVIPType = 1;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_DMXJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.MediaJingleView) {
                    intVIPType = 2;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_MediaJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else if (p_JingleView instanceof LiveShowInternalFrame_PlayJingles.SPITJingleView) {
                    intVIPType = 2;
                    Object object = this.m_SyncJingles;
                    synchronized (object) {
                        if (!this.m_SPITJingleViews.contains(p_JingleView)) {
                            return;
                        }
                    }
                } else {
                    return;
                }
                LiveShowObject o_LiveShowObject = p_JingleView.getLiveShowObject();
                if (o_LiveShowObject == null) {
                    return;
                }
                Message_JinglePlayControlStatus o_Message_JinglePlayControlStatus = new Message_JinglePlayControlStatus(intVIPType, p_JingleView.getJingleID(), p_Status.getStartEnabled(), p_Status.getPauseEnabled(), p_Status.getStopEnabled(), p_Status.getFadeInEnabled(), p_Status.getFadeOutEnabled() || p_Status.getFadeOutDirectEnabled(), p_Status.getFastForwardEnabled(), p_Status.getRewindEnabled());
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JinglePlayControlStatus);
            }
        }

        public void playJingleStart(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playStart();
        }

        public void playJinglePause(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playPause();
        }

        public void playJingleStop(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playStop();
        }

        public void playJingleFadeIn(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playFadeIn();
        }

        public void playJingleFadeOut(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playFadeOut();
        }

        public void playJingleFastForward(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playFastForward();
        }

        public void playJingleRewind(RemoteUser p_RemoteUser, int p_VIPType, String p_JingleID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.getJingleView(p_VIPType, p_JingleID);
            if (o_JingleView == null) {
                return;
            }
            o_JingleView.playRewind();
        }

        @Override
        public void eventJingleGroupAdded(LiveShowJingleGroup p_JingleGroup) {
            this.sendMessage_JinglesGroupAdded(null, p_JingleGroup);
        }

        private void sendMessage_JinglesGroupAdded(RemoteUser p_RemoteUser, LiveShowJingleGroup p_JingleGroup) {
            if (p_JingleGroup == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_JingleGroup.JingleGroupDescription o_JingleGroupDescription = new Message_Status_JingleGroup.JingleGroupDescription(p_JingleGroup.getID(), p_JingleGroup.getName(), p_JingleGroup.getRemark());
                Message_Status_JingleGroup.PlayControlStatus o_JingleGroupPlayStatus = new Message_Status_JingleGroup.PlayControlStatus(p_JingleGroup.getPlayStartEnabled(), p_JingleGroup.getPlayPauseEnabled(), p_JingleGroup.getPlayStopEnabled(), p_JingleGroup.getPlayJingleCount(), p_JingleGroup.getJingleInterfaceCount());
                Message_JinglesGroupAdded o_Message_JingleAdded = new Message_JinglesGroupAdded(o_JingleGroupDescription, o_JingleGroupPlayStatus);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleAdded);
            }
        }

        @Override
        public void eventJingleGroupRemoved(LiveShowJingleGroup p_JingleGroup) {
            this.sendMessage_JinglesGroupRemoved(null, p_JingleGroup);
        }

        private void sendMessage_JinglesGroupRemoved(RemoteUser p_RemoteUser, LiveShowJingleGroup p_JingleGroup) {
            if (p_JingleGroup == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_JinglesGroupRemoved o_Message_JingleRemoved = new Message_JinglesGroupRemoved(p_JingleGroup.getID());
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleRemoved);
            }
        }

        @Override
        public void eventJingleGroupChanged(LiveShowJingleGroup p_JingleGroup) {
            this.sendMessage_JinglesGroupChanged(null, p_JingleGroup);
        }

        private void sendMessage_JinglesGroupChanged(RemoteUser p_RemoteUser, LiveShowJingleGroup p_JingleGroup) {
            if (p_JingleGroup == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_JingleGroup.JingleGroupDescription o_JingleGroupDescription = new Message_Status_JingleGroup.JingleGroupDescription(p_JingleGroup.getID(), p_JingleGroup.getName(), p_JingleGroup.getRemark());
                Message_JinglesGroupChanged o_Message_JingleChanged = new Message_JinglesGroupChanged(o_JingleGroupDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JingleChanged);
            }
        }

        @Override
        public void eventJingleGroupPlayStatus(LiveShowJingleGroup p_JingleGroup) {
            this.sendMessage_JinglesGroupPlayControlStatus(null, p_JingleGroup);
        }

        private void sendMessage_JinglesGroupPlayControlStatus(RemoteUser p_RemoteUser, LiveShowJingleGroup p_JingleGroup) {
            if (p_JingleGroup == null) {
                return;
            }
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_JingleGroup.PlayControlStatus o_JingleGroupPlayStatus = new Message_Status_JingleGroup.PlayControlStatus(p_JingleGroup.getPlayStartEnabled(), p_JingleGroup.getPlayPauseEnabled(), p_JingleGroup.getPlayStopEnabled(), p_JingleGroup.getPlayJingleCount(), p_JingleGroup.getJingleInterfaceCount());
                Message_JinglesGroupPlayControlStatus o_Message_JinglesGroupPlayControlStatus = new Message_JinglesGroupPlayControlStatus(p_JingleGroup.getID(), o_JingleGroupPlayStatus);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_JinglesGroupPlayControlStatus);
            }
        }

        public void playJinglesGroupStart(RemoteUser p_RemoteUser, String p_JingleGroupID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(p_JingleGroupID);
            if (o_JingleGroup == null) {
                return;
            }
            o_JingleGroup.playStart();
        }

        public void playJinglesGroupFadeIn(RemoteUser p_RemoteUser, String p_JingleGroupID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(p_JingleGroupID);
            if (o_JingleGroup == null) {
                return;
            }
            o_JingleGroup.playFadeInPause();
        }

        public void playJinglesGroupFadeOut(RemoteUser p_RemoteUser, String p_JingleGroupID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(p_JingleGroupID);
            if (o_JingleGroup == null) {
                return;
            }
            o_JingleGroup.playFadeOut();
        }

        public void playJinglesGroupPause(RemoteUser p_RemoteUser, String p_JingleGroupID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(p_JingleGroupID);
            if (o_JingleGroup == null) {
                return;
            }
            o_JingleGroup.playPause();
        }

        public void playJinglesGroupStop(RemoteUser p_RemoteUser, String p_JingleGroupID) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            LiveShowJingleGroup o_JingleGroup = LiveShowJingleGroup.getGroup(p_JingleGroupID);
            if (o_JingleGroup == null) {
                return;
            }
            o_JingleGroup.playStop();
        }

        public void requestStatusMasters(RemoteUser p_RemoteUser) {
            this.sendMessage_StatusMaster(p_RemoteUser);
        }

        public void sendMessage_StatusMaster(RemoteUser p_RemoteUser) {
            Message_Status_Master o_Message_Status_Master;
            this.m_ValueNormed_MainSoundVolume = this.m_ControlObject_MainSoundVolume.getControlDimension(0).getValueNormed();
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                o_Message_Status_Master = new Message_Status_Master(0, this.m_ValueNormed_MainSoundVolume);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Master);
            }
            this.m_ValueNormed_MainDMXDimmer = this.m_ControlObject_MainDMXDimmer.getControlDimension(0).getValueNormed();
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                o_Message_Status_Master = new Message_Status_Master(1, this.m_ValueNormed_MainDMXDimmer);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Master);
            }
            this.m_ValueNormed_MainMediaDimmer = this.m_ControlObject_MainMediaDimmer.getControlDimension(0).getValueNormed();
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                o_Message_Status_Master = new Message_Status_Master(2, this.m_ValueNormed_MainMediaDimmer);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Master);
            }
            this.m_ValueNormed_MainMediaSoundVolume = this.m_ControlObject_MainMediaSoundVolume.getControlDimension(0).getValueNormed();
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                o_Message_Status_Master = new Message_Status_Master(3, this.m_ValueNormed_MainMediaSoundVolume);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Master);
            }
        }

        public void changeMaster(RemoteUser p_RemoteUser, int p_VIPType, double p_ValueNormed) {
            if (p_RemoteUser == null) {
                return;
            }
            if (!p_RemoteUser.getPermissionControl()) {
                return;
            }
            switch (p_VIPType) {
                case 0: {
                    if (p_ValueNormed == this.m_ValueNormed_MainSoundVolume) {
                        return;
                    }
                    this.m_ValueMasterSoundSetByRemote = true;
                    this.m_ValueNormed_MainSoundVolume = p_ValueNormed;
                    this.m_ControlObject_MainSoundVolume.getControlDimension(0).setValueNormed(p_ValueNormed, 2);
                    this.m_ControlObject_MainSoundVolume.setValueManuallyIsReady();
                    Message_Status_Master o_Message_Status_Master = new Message_Status_Master(0, this.m_ValueNormed_MainSoundVolume);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)o_Message_Status_Master, p_RemoteUser);
                    break;
                }
                case 1: {
                    if (p_ValueNormed == this.m_ValueNormed_MainDMXDimmer) {
                        return;
                    }
                    this.m_ValueMasterDMXSetByRemote = true;
                    this.m_ValueNormed_MainDMXDimmer = p_ValueNormed;
                    this.m_ControlObject_MainDMXDimmer.getControlDimension(0).setValueNormed(p_ValueNormed, 2);
                    this.m_ControlObject_MainDMXDimmer.setValueManuallyIsReady();
                    Message_Status_Master o_Message_Status_Master = new Message_Status_Master(1, this.m_ValueNormed_MainDMXDimmer);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)o_Message_Status_Master, p_RemoteUser);
                    break;
                }
                case 2: {
                    if (p_ValueNormed == this.m_ValueNormed_MainMediaDimmer) {
                        return;
                    }
                    this.m_ValueMasterMediaSetByRemote = true;
                    this.m_ValueNormed_MainMediaDimmer = p_ValueNormed;
                    this.m_ControlObject_MainMediaDimmer.getControlDimension(0).setValueNormed(p_ValueNormed, 2);
                    this.m_ControlObject_MainMediaDimmer.setValueManuallyIsReady();
                    Message_Status_Master o_Message_Status_Master = new Message_Status_Master(2, this.m_ValueNormed_MainMediaDimmer);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)o_Message_Status_Master, p_RemoteUser);
                    break;
                }
                case 3: {
                    if (p_ValueNormed == this.m_ValueNormed_MainMediaSoundVolume) {
                        return;
                    }
                    this.m_ValueMasterMediaSoundSetByRemote = true;
                    this.m_ValueNormed_MainMediaSoundVolume = p_ValueNormed;
                    this.m_ControlObject_MainMediaSoundVolume.getControlDimension(0).setValueNormed(p_ValueNormed, 2);
                    this.m_ControlObject_MainMediaSoundVolume.setValueManuallyIsReady();
                    Message_Status_Master o_Message_Status_Master = new Message_Status_Master(3, this.m_ValueNormed_MainMediaSoundVolume);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)o_Message_Status_Master, p_RemoteUser);
                }
            }
        }

        public void sendMessage_StatusLanguage(RemoteUser p_RemoteUser) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                Message_Status_Language o_Message_Status_Language = new Message_Status_Language(Locale.getDefault(), s_Direction_Scene_Start, s_Direction_Scene_End, s_Direction_Pre_Start, s_Direction_Pre_End, s_Direction_Post_Start, s_Direction_Post_End, s_NextSceneLatency);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_Language);
            }
        }

        public void requestLanguage(RemoteUser p_RemoteUser) {
            this.sendMessage_StatusLanguage(p_RemoteUser);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"value".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getSource() == this.m_ControlObject_MainSoundVolume) {
                double doubleValueNormed;
                if (!this.m_ValueMasterSoundSetByRemote && this.m_ValueNormed_MainSoundVolume != (doubleValueNormed = this.m_ControlObject_MainSoundVolume.getControlDimension(0).getValueNormed())) {
                    this.m_ValueNormed_MainSoundVolume = doubleValueNormed;
                    if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                        Message_Status_Master o_Message_Status_Master = new Message_Status_Master(0, this.m_ValueNormed_MainSoundVolume);
                        this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_Status_Master);
                    }
                }
                this.m_ValueMasterSoundSetByRemote = false;
            } else if (evt.getSource() == this.m_ControlObject_MainDMXDimmer) {
                double doubleValueNormed;
                if (!this.m_ValueMasterDMXSetByRemote && this.m_ValueNormed_MainDMXDimmer != (doubleValueNormed = this.m_ControlObject_MainDMXDimmer.getControlDimension(0).getValueNormed())) {
                    this.m_ValueNormed_MainDMXDimmer = doubleValueNormed;
                    if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                        Message_Status_Master o_Message_Status_Master = new Message_Status_Master(1, this.m_ValueNormed_MainDMXDimmer);
                        this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_Status_Master);
                    }
                }
                this.m_ValueMasterDMXSetByRemote = false;
            } else if (evt.getSource() == this.m_ControlObject_MainMediaDimmer) {
                double doubleValueNormed;
                if (!this.m_ValueMasterMediaSetByRemote && this.m_ValueNormed_MainMediaDimmer != (doubleValueNormed = this.m_ControlObject_MainMediaDimmer.getControlDimension(0).getValueNormed())) {
                    this.m_ValueNormed_MainMediaDimmer = doubleValueNormed;
                    if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                        Message_Status_Master o_Message_Status_Master = new Message_Status_Master(2, this.m_ValueNormed_MainMediaDimmer);
                        this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_Status_Master);
                    }
                }
                this.m_ValueMasterMediaSetByRemote = false;
            } else if (evt.getSource() == this.m_ControlObject_MainMediaSoundVolume) {
                double doubleValueNormed;
                if (!this.m_ValueMasterMediaSoundSetByRemote && this.m_ValueNormed_MainMediaSoundVolume != (doubleValueNormed = this.m_ControlObject_MainMediaSoundVolume.getControlDimension(0).getValueNormed())) {
                    this.m_ValueNormed_MainMediaSoundVolume = doubleValueNormed;
                    if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                        Message_Status_Master o_Message_Status_Master = new Message_Status_Master(3, this.m_ValueNormed_MainMediaSoundVolume);
                        this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_Status_Master);
                    }
                }
                this.m_ValueMasterMediaSoundSetByRemote = false;
            }
        }

        public void eventPropertyChange(PropertyChangeEvent evt, String p_DMXControlComponentID, int p_ControlObjectIndex, int p_ControlDimensionIndex) {
            Message_Status_DMXStageView.ControlDimensionDescription o_ControlDimensionDescription = null;
            boolean boolVirtual = false;
            if ("value".equals(evt.getPropertyName()) || "valueAdjustedManually".equals(evt.getPropertyName())) {
                Message_Status_DMXStageView.ControlObjectDescription o_ControlObjectDescription;
                DMXControlComponent o_DMXControlComponent = LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel().getDMXControlComponentByID(p_DMXControlComponentID);
                if (o_DMXControlComponent == null) {
                    return;
                }
                ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(p_ControlObjectIndex);
                if (o_ControlObject == null && p_ControlObjectIndex == 1 && o_DMXControlComponent instanceof DMXControl_GridPanTilt) {
                    DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent;
                    o_ControlObject = o_DMXControl_GridPanTilt.getJControlGridVirtual();
                    boolVirtual = true;
                }
                if (o_ControlObject == null) {
                    return;
                }
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_ControlDimensionIndex);
                if (o_ControlDimension == null) {
                    return;
                }
                double doubleValueNormed = o_ControlDimension.getValueNormed();
                doubleValueNormed = (double)((int)(doubleValueNormed * 1000.0 + 0.5)) / 1000.0;
                Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.m_DMXControlDescriptions.get(p_DMXControlComponentID);
                if (o_DMXControlComponentDescription != null && (o_ControlObjectDescription = o_DMXControlComponentDescription.getControlObjectDescription(p_ControlObjectIndex)) != null) {
                    o_ControlDimensionDescription = o_ControlObjectDescription.getControlDimensionDescription(p_ControlDimensionIndex);
                }
                boolean boolSendValue = true;
                if (o_ControlDimensionDescription != null) {
                    if (o_ControlDimensionDescription.getValue() != doubleValueNormed) {
                        o_ControlDimensionDescription.setValue(doubleValueNormed);
                    } else {
                        boolSendValue = false;
                    }
                } else {
                    boolSendValue = false;
                }
                if (this.m_ValueDimensionSetByRemote != null && boolSendValue && o_ControlDimension == this.m_ValueDimensionSetByRemote) {
                    boolSendValue = false;
                    this.m_ValueDimensionSetByRemote = null;
                }
                if (boolSendValue && this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0 && this.m_DMXStageViewRequested) {
                    Message_DMXControlComponentValue o_Message_DMXControlComponentValue = new Message_DMXControlComponentValue(doubleValueNormed, p_DMXControlComponentID, p_ControlObjectIndex, p_ControlDimensionIndex);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_DMXControlComponentValue);
                }
            } else if ("listSelected".equals(evt.getPropertyName())) {
                Message_Status_DMXStageView.ControlObjectDescription o_ControlObjectDescription;
                boolean boolSendListIndex = false;
                DMXControlComponent o_DMXControlComponent = LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel().getDMXControlComponentByID(p_DMXControlComponentID);
                if (o_DMXControlComponent == null) {
                    return;
                }
                ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(p_ControlObjectIndex);
                if (o_ControlObject == null) {
                    return;
                }
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_ControlDimensionIndex);
                if (o_ControlDimension == null) {
                    return;
                }
                ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                if (o_ControlLabelModel == null) {
                    return;
                }
                Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.m_DMXControlDescriptions.get(p_DMXControlComponentID);
                if (o_DMXControlComponentDescription != null && (o_ControlObjectDescription = o_DMXControlComponentDescription.getControlObjectDescription(p_ControlObjectIndex)) != null) {
                    o_ControlDimensionDescription = o_ControlObjectDescription.getControlDimensionDescription(p_ControlDimensionIndex);
                    if (o_ControlDimensionDescription == null) {
                        return;
                    }
                    o_ControlDimensionDescription.setValueLabelListActual(o_ControlLabelModel.getSelectedControlLabelListIndex());
                    boolSendListIndex = true;
                }
                if (boolSendListIndex && o_ControlDimensionDescription != null && this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() > 0) {
                    Message_DMXControlComponentLabelList o_Message_DMXControlComponentLabelList = new Message_DMXControlComponentLabelList(o_ControlDimensionDescription.getValueLabelListActual(), p_DMXControlComponentID, p_ControlObjectIndex, p_ControlDimensionIndex);
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_DMXControlComponentLabelList);
                }
            }
        }

        public void requestStatusDMXStageView(RemoteUser p_RemoteUser) {
            this.m_DMXStageViewRequested = true;
            this.sendMessage_StatusDMXStageView(p_RemoteUser);
        }

        public void sendMessage_StatusDMXStageView(RemoteUser p_RemoteUser) {
            Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription_New;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_Status_DMXStageView o_Message_Status_DMXStageView = new Message_Status_DMXStageView();
            int intDMXUniverseCount = DMXUniverse.getDMXUniverseCount();
            for (int intUniverse = 0; intUniverse < intDMXUniverseCount; ++intUniverse) {
                Message_Status_DMXStageView.DMXUniverseDescription o_DMXUniverseDescription;
                DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse((int)intUniverse);
                if (o_DMXUniverse == null || !this.fillDMXUniverseDescription(o_DMXUniverseDescription = new Message_Status_DMXStageView.DMXUniverseDescription(), o_DMXUniverse)) continue;
                o_Message_Status_DMXStageView.addDMXUniverseDescription(o_DMXUniverseDescription);
            }
            int intDMXViewCount = LiveShowDMXStageView.getDMXDeviceViewCount();
            for (int intDevice = 0; intDevice < intDMXViewCount; ++intDevice) {
                Message_Status_DMXStageView.DMXDeviceDescription o_DMXDeviceDescription;
                DMXDevice o_DMXDevice;
                DMXDeviceView o_DMXDeviceView = LiveShowDMXStageView.getDMXDeviceView((int)intDevice);
                if (o_DMXDeviceView == null || (o_DMXDevice = o_DMXDeviceView.getDMXDevice()) == null || !this.fillDMXDeviceDescription(o_DMXDeviceDescription = new Message_Status_DMXStageView.DMXDeviceDescription(), o_DMXDeviceView)) continue;
                o_Message_Status_DMXStageView.addDMXDeviceDescription(o_DMXDeviceDescription);
            }
            int intDMXDeviceGroupCount = DMXDeviceGroup.getGroupCount();
            for (int intGroup = 0; intGroup < intDMXDeviceGroupCount; ++intGroup) {
                Message_Status_DMXStageView.DMXDeviceGroupDescription o_DMXDeviceGroupDescription;
                DMXDeviceGroup o_DMXDeviceGroup = DMXDeviceGroup.getGroup((int)intGroup);
                if (o_DMXDeviceGroup == null || !this.fillDMXDeviceGroupDescription(o_DMXDeviceGroupDescription = new Message_Status_DMXStageView.DMXDeviceGroupDescription(), o_DMXDeviceGroup)) continue;
                o_Message_Status_DMXStageView.addDMXDeviceGroupDescription(o_DMXDeviceGroupDescription);
            }
            int intDMXControlComponentCount = this.m_DMXControlDescriptions.size();
            ArrayList<Message_Status_DMXStageView.DMXControlComponentDescription> o_DMXControlComponentDescriptions = new ArrayList<Message_Status_DMXStageView.DMXControlComponentDescription>();
            for (String stringID : this.m_DMXControlDescriptions.keySet()) {
                int intComponent;
                Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.m_DMXControlDescriptions.get(stringID);
                o_DMXControlComponentDescription_New = o_DMXControlComponentDescription.copy(null);
                for (intComponent = 0; intComponent < o_DMXControlComponentDescriptions.size() && (o_DMXControlComponentDescription = (Message_Status_DMXStageView.DMXControlComponentDescription)o_DMXControlComponentDescriptions.get(intComponent)).getIndex() <= o_DMXControlComponentDescription_New.getIndex(); ++intComponent) {
                }
                o_DMXControlComponentDescriptions.add(intComponent, o_DMXControlComponentDescription_New);
            }
            for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXControlComponentDescriptions.size(); ++intDMXControlComponent) {
                o_DMXControlComponentDescription_New = (Message_Status_DMXStageView.DMXControlComponentDescription)o_DMXControlComponentDescriptions.get(intDMXControlComponent);
                o_Message_Status_DMXStageView.addDMXControlComponentDescription(o_DMXControlComponentDescription_New);
            }
            o_Message_Status_DMXStageView.setDMXControlGroupChangeType(LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel().getControlGroupsChangeType());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_DMXStageView);
        }

        public void eventDMXUniverseAdded(DMXUniverse p_DMXUniverse) {
            this.sendMessage_DMXUniverse(null, p_DMXUniverse);
        }

        public void eventDMXUniverseChanged(DMXUniverse p_DMXUniverse) {
            this.sendMessage_DMXUniverse(null, p_DMXUniverse);
        }

        public void eventDMXUniverseRemoved(DMXUniverse p_DMXUniverse) {
            this.sendMessage_DMXUniverseRemoved(null, p_DMXUniverse);
        }

        public boolean fillDMXUniverseDescription(Message_Status_DMXStageView.DMXUniverseDescription p_DMXUniverseDescription, DMXUniverse p_DMXUniverse) {
            if (p_DMXUniverseDescription == null) {
                return false;
            }
            if (p_DMXUniverse == null) {
                return false;
            }
            p_DMXUniverseDescription.setID(p_DMXUniverse.getID());
            p_DMXUniverseDescription.setName(p_DMXUniverse.getName());
            return true;
        }

        public void sendMessage_DMXUniverse(RemoteUser p_RemoteUser, DMXUniverse p_DMXUniverse) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXUniverse == null) {
                return;
            }
            Message_Status_DMXStageView.DMXUniverseDescription o_DMXUniverseDescription = new Message_Status_DMXStageView.DMXUniverseDescription();
            if (this.fillDMXUniverseDescription(o_DMXUniverseDescription, p_DMXUniverse)) {
                Message_DMXUniverse o_Message_DMXUniverse = new Message_DMXUniverse(o_DMXUniverseDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXUniverse);
            }
        }

        public void sendMessage_DMXUniverseRemoved(RemoteUser p_RemoteUser, DMXUniverse p_DMXUniverse) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXUniverse == null) {
                return;
            }
            Message_DMXUniverseRemoved o_Message_DMXUniverseRemoved = new Message_DMXUniverseRemoved(p_DMXUniverse.getID());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXUniverseRemoved);
        }

        public void eventDMXDeviceGroupAdded(DMXDeviceGroup p_DMXDeviceGroup) {
            this.sendMessage_DMXDeviceGroup(null, p_DMXDeviceGroup);
        }

        public void eventDMXDeviceGroupChanged(DMXDeviceGroup p_DMXDeviceGroup) {
            this.sendMessage_DMXDeviceGroup(null, p_DMXDeviceGroup);
        }

        public void eventDMXDeviceGroupRemoved(DMXDeviceGroup p_DMXDeviceGroup) {
            this.sendMessage_DMXDeviceGroupRemoved(null, p_DMXDeviceGroup);
        }

        public boolean fillDMXDeviceGroupDescription(Message_Status_DMXStageView.DMXDeviceGroupDescription p_DMXDeviceGroupDescription, DMXDeviceGroup p_DMXDeviceGroup) {
            if (p_DMXDeviceGroupDescription == null) {
                return false;
            }
            if (p_DMXDeviceGroup == null) {
                return false;
            }
            p_DMXDeviceGroupDescription.setID(p_DMXDeviceGroup.getID());
            p_DMXDeviceGroupDescription.setName(p_DMXDeviceGroup.getName());
            return true;
        }

        public void sendMessage_DMXDeviceGroup(RemoteUser p_RemoteUser, DMXDeviceGroup p_DMXDeviceGroup) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXDeviceGroup == null) {
                return;
            }
            Message_Status_DMXStageView.DMXDeviceGroupDescription o_DMXDeviceGroupDescription = new Message_Status_DMXStageView.DMXDeviceGroupDescription();
            if (this.fillDMXDeviceGroupDescription(o_DMXDeviceGroupDescription, p_DMXDeviceGroup)) {
                Message_DMXDeviceGroup o_Message_DMXDeviceGroup = new Message_DMXDeviceGroup(o_DMXDeviceGroupDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXDeviceGroup);
            }
        }

        public void sendMessage_DMXDeviceGroupRemoved(RemoteUser p_RemoteUser, DMXDeviceGroup p_DMXDeviceGroup) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXDeviceGroup == null) {
                return;
            }
            Message_DMXDeviceGroupRemoved o_Message_DMXDeviceGroupRemoved = new Message_DMXDeviceGroupRemoved(p_DMXDeviceGroup.getID());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXDeviceGroupRemoved);
        }

        public void selectedDMXDeviceGroup(RemoteUser p_RemoteUser, Message_DMXDeviceGroupSelected p_Message_DMXDeviceGroupSelected) {
            if (p_Message_DMXDeviceGroupSelected == null) {
                return;
            }
            DMXDeviceGroup o_DMXDeviceGroup = DMXDeviceGroup.getGroup((String)p_Message_DMXDeviceGroupSelected.getDMXDeviceGroupID());
            if (o_DMXDeviceGroup == null) {
                return;
            }
            LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
            if (o_LiveShowDMXStageView == null) {
                return;
            }
            o_LiveShowDMXStageView.clearSelectedDMXDevices();
            o_DMXDeviceGroup.addSelectedDMXDevices();
        }

        public void eventDMXDeviceViewAdded(DMXDeviceView p_DMXDeviceView) {
            this.sendMessage_DMXDevice(null, p_DMXDeviceView);
        }

        public void eventDMXDeviceViewChanged(DMXDeviceView p_DMXDeviceView) {
            this.sendMessage_DMXDevice(null, p_DMXDeviceView);
        }

        public void eventDMXDeviceViewSelected(DMXDeviceView p_DMXDeviceView, boolean p_Selected) {
            this.sendMessage_DMXDevice(null, p_DMXDeviceView);
        }

        public void sendMessage_DMXDevice(RemoteUser p_RemoteUser, DMXDeviceView p_DMXDeviceView) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXDeviceView == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DMXDeviceView.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            Message_Status_DMXStageView.DMXDeviceDescription o_DMXDeviceDescription = new Message_Status_DMXStageView.DMXDeviceDescription();
            if (this.fillDMXDeviceDescription(o_DMXDeviceDescription, p_DMXDeviceView)) {
                Message_DMXDevice o_Message_DMXDevice = new Message_DMXDevice(o_DMXDeviceDescription);
                this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXDevice);
            }
        }

        private boolean fillDMXDeviceDescription(Message_Status_DMXStageView.DMXDeviceDescription p_DMXDeviceDescription, DMXDeviceView p_DMXDeviceView) {
            if (p_DMXDeviceDescription == null) {
                return false;
            }
            if (p_DMXDeviceView == null) {
                return false;
            }
            DMXDevice o_DMXDevice = p_DMXDeviceView.getDMXDevice();
            if (o_DMXDevice == null) {
                return false;
            }
            p_DMXDeviceDescription.setID(o_DMXDevice.getID());
            p_DMXDeviceDescription.setName(o_DMXDevice.getName());
            int intInternalSectorCount = o_DMXDevice.getInternalSectorCount();
            p_DMXDeviceDescription.setDMXUniverseCount(intInternalSectorCount);
            for (int intSector = 0; intSector < intInternalSectorCount; ++intSector) {
                DMXDevice.InternalSector o_InternalSector = o_DMXDevice.getInternalSector(intSector);
                if (o_InternalSector == null) continue;
                Message_Status_DMXStageView.DMXAddress o_DMXAddress = p_DMXDeviceDescription.getDMXAddress(intSector);
                if (o_DMXAddress == null) {
                    o_DMXAddress = new Message_Status_DMXStageView.DMXAddress();
                    p_DMXDeviceDescription.addDMXAddress(o_DMXAddress);
                }
                o_DMXAddress.setInternalSectorIndex(intSector);
                o_DMXAddress.setDMXChannelCount(o_InternalSector.getInternalChannelCount());
                DMXUniverse o_DMXUniverse = o_InternalSector.getDMXUniverse();
                if (o_DMXUniverse == null) {
                    o_DMXAddress.setDMXUniverseID("");
                } else {
                    o_DMXAddress.setDMXUniverseID(o_DMXUniverse.getID());
                }
                o_DMXAddress.setDMXStartAddress(o_InternalSector.getDMXStartAddress());
            }
            p_DMXDeviceDescription.setActive(o_DMXDevice.getActive());
            p_DMXDeviceDescription.setMute(o_DMXDevice.getMute());
            p_DMXDeviceDescription.setSolo(o_DMXDevice.getSolo());
            p_DMXDeviceDescription.setValidAddress(o_DMXDevice.getValidAddress());
            p_DMXDeviceDescription.setSelected(p_DMXDeviceView.getSelected());
            return true;
        }

        public void eventDMXDeviceViewRemoved(DMXDeviceView p_DMXDeviceView) {
            this.sendMessage_DMXDeviceRemoved(null, p_DMXDeviceView);
        }

        public void sendMessage_DMXDeviceRemoved(RemoteUser p_RemoteUser, DMXDeviceView p_DMXDeviceView) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXDeviceView == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DMXDeviceView.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            Message_DMXDeviceRemoved o_Message_DMXDeviceRemoved = new Message_DMXDeviceRemoved(o_DMXDevice.getID());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXDeviceRemoved);
        }

        public void changeDMXDevice(RemoteUser p_RemoteUser, Message_DMXDevice p_Message_DMXDevice) {
            if (p_Message_DMXDevice == null) {
                return;
            }
            Message_Status_DMXStageView.DMXDeviceDescription o_DMXDeviceDescription = p_Message_DMXDevice.getDMXDeviceDescription();
            String stringID = o_DMXDeviceDescription.getID();
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice((String)stringID);
            if (o_DMXDevice == null) {
                return;
            }
            o_DMXDevice.setName(o_DMXDeviceDescription.getName());
            o_DMXDevice.setActive(o_DMXDeviceDescription.getActive());
            o_DMXDevice.setMute(o_DMXDeviceDescription.getMute());
            o_DMXDevice.setSolo(o_DMXDeviceDescription.getSolo());
            if (o_DMXDeviceDescription.getSelected()) {
                LiveShowDMXStageView.s_SelfReference.addSelectedDMXDevice(o_DMXDevice);
            } else {
                LiveShowDMXStageView.s_SelfReference.removeSelectedDMXDevice(o_DMXDevice);
            }
            for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                DMXDevice.InternalSector o_InternalSector;
                Message_Status_DMXStageView.DMXAddress o_DMXAddress = o_DMXDeviceDescription.getDMXAddress(intSector);
                if (o_DMXAddress == null || (o_InternalSector = o_DMXDevice.getInternalSector(intSector)) == null) continue;
                DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse((String)o_DMXAddress.getDMXUniverseID());
                int intDMXStartAddress = o_DMXAddress.getDMXStartAddress();
                if (o_InternalSector.getDMXStartAddress() == intDMXStartAddress && o_InternalSector.getDMXUniverse() == o_DMXUniverse) continue;
                o_InternalSector.setDMXAddress(o_DMXUniverse, intDMXStartAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXStageView_DMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
            if (p_DMXMixerPanel == null) {
                return;
            }
            Object object = this.m_SyncDMXControlComponent;
            synchronized (object) {
                int intDMXControlComponentCount = p_DMXMixerPanel.getDMXControlComponentCount();
                for (int intDMXControlComponent = 0; intDMXControlComponent < intDMXControlComponentCount; ++intDMXControlComponent) {
                    DMXControlComponent o_DMXControlComponent = p_DMXMixerPanel.getDMXControlComponent(intDMXControlComponent);
                    if (o_DMXControlComponent == null) continue;
                    Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.getDMXControlComponentDescription(o_DMXControlComponent.getDMXControlTypeID());
                    if (o_DMXControlComponentDescription == null) {
                        o_DMXControlComponentDescription = new Message_Status_DMXStageView.DMXControlComponentDescription();
                        o_DMXControlComponentDescription.setIndex(intDMXControlComponent);
                        o_DMXControlComponentDescription.setDMXValueListener((Message_Status_DMXStageView.DMXDimensionEventListener)this);
                        this.m_DMXControlDescriptions.put(o_DMXControlComponent.getDMXControlTypeID(), o_DMXControlComponentDescription);
                    }
                    this.fillDMXControlDescription(o_DMXControlComponentDescription, o_DMXControlComponent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message_Status_DMXStageView.DMXControlComponentDescription getDMXControlComponentDescription(String p_ID) {
            if (p_ID == null) {
                return null;
            }
            Object object = this.m_SyncDMXControlComponent;
            synchronized (object) {
                return this.m_DMXControlDescriptions.get(p_ID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventDMXControlComponentAdded(DMXControlComponent p_DMXControlComponent, int p_ActualIndex) {
            if (p_DMXControlComponent == null) {
                return;
            }
            Object object = this.m_SyncDMXControlComponent;
            synchronized (object) {
                Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.m_DMXControlDescriptions.get(p_DMXControlComponent.getDMXControlTypeID());
                if (o_DMXControlComponentDescription == null) {
                    o_DMXControlComponentDescription = new Message_Status_DMXStageView.DMXControlComponentDescription();
                    o_DMXControlComponentDescription.setIndex(p_ActualIndex);
                    o_DMXControlComponentDescription.setDMXValueListener((Message_Status_DMXStageView.DMXDimensionEventListener)this);
                    this.m_DMXControlDescriptions.put(p_DMXControlComponent.getDMXControlTypeID(), o_DMXControlComponentDescription);
                }
                this.fillDMXControlDescription(o_DMXControlComponentDescription, p_DMXControlComponent);
            }
            this.sendMessage_DMXControlComponent(null, p_DMXControlComponent);
        }

        private boolean fillDMXControlDescription(Message_Status_DMXStageView.DMXControlComponentDescription p_DMXControlComponentDescription, DMXControlComponent p_DMXControlComponent) {
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt;
            Message_Status_DMXStageView.ControlObjectDescription o_ControlObjectDescription;
            ControlObject o_ControlObject;
            if (p_DMXControlComponentDescription == null) {
                return false;
            }
            if (p_DMXControlComponent == null) {
                return false;
            }
            p_DMXControlComponentDescription.setID(p_DMXControlComponent.getDMXControlTypeID());
            p_DMXControlComponentDescription.setName(p_DMXControlComponent.getName());
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXControlComponent.getDMXControlType();
            if (o_DMXControlType == null) {
                return false;
            }
            p_DMXControlComponentDescription.setControlType(o_DMXControlType.getClassName());
            p_DMXControlComponentDescription.setVisible(p_DMXControlComponent.isVisible());
            p_DMXControlComponentDescription.clearControlObjects();
            int intControlObjectCount = p_DMXControlComponent.getControlObjectCount();
            if (intControlObjectCount <= 0) {
                return true;
            }
            int intStart = 0;
            int intCount = intControlObjectCount;
            if (p_DMXControlComponent instanceof DMXControl_RGB) {
                DMXControl_RGB o_DMXControl_RGB = (DMXControl_RGB)p_DMXControlComponent;
                if (o_DMXControl_RGB.isRGBControlled()) {
                    intStart = 0;
                    intCount = 3;
                } else {
                    intStart = 3;
                    intCount = 6;
                }
            }
            for (int intControl = intStart; intControl < intCount; ++intControl) {
                o_ControlObject = p_DMXControlComponent.getControlObject(intControl);
                if (o_ControlObject == null) continue;
                o_ControlObjectDescription = new Message_Status_DMXStageView.ControlObjectDescription();
                o_ControlObjectDescription.setParent(p_DMXControlComponentDescription);
                o_ControlObjectDescription.setName(o_ControlObject.getName());
                o_ControlObjectDescription.setIndex(intControl);
                this.fillDimensions(p_DMXControlComponentDescription, p_DMXControlComponent, o_ControlObjectDescription, o_ControlObject);
                p_DMXControlComponentDescription.addControlObjectDescription(o_ControlObjectDescription);
            }
            if (p_DMXControlComponent instanceof DMXControl_GridPanTilt && (o_ControlObject = (o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)p_DMXControlComponent).getJControlGridVirtual()) != null) {
                o_ControlObjectDescription = new Message_Status_DMXStageView.ControlObjectDescription();
                o_ControlObjectDescription.setParent(p_DMXControlComponentDescription);
                o_ControlObjectDescription.setName(o_ControlObject.getName());
                o_ControlObjectDescription.setIndex(1);
                this.fillDimensions(p_DMXControlComponentDescription, p_DMXControlComponent, o_ControlObjectDescription, o_ControlObject);
                o_ControlObjectDescription.getControlDimensionDescription(0).setName(Message_Status_DMXStageView.ControlDimensionDescription.GRIDDIMENAION_VIRTUAL_X);
                o_ControlObjectDescription.getControlDimensionDescription(1).setName(Message_Status_DMXStageView.ControlDimensionDescription.GRIDDIMENAION_VIRTUAL_Y);
                p_DMXControlComponentDescription.addControlObjectDescription(o_ControlObjectDescription);
            }
            return true;
        }

        private void fillDimensions(Message_Status_DMXStageView.DMXControlComponentDescription p_DMXControlComponentDescription, DMXControlComponent p_DMXControlComponent, Message_Status_DMXStageView.ControlObjectDescription p_ControlObjectDescription, ControlObject p_ControlObject) {
            if (p_DMXControlComponent == null) {
                return;
            }
            if (p_DMXControlComponentDescription == null) {
                return;
            }
            if (p_ControlObject == null) {
                return;
            }
            if (p_ControlObjectDescription == null) {
                return;
            }
            int intControlDimensionCount = p_ControlObject.getControlDimensionCount();
            for (int intDimension = 0; intDimension < intControlDimensionCount; ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = p_ControlObject.getControlDimension(intDimension);
                if (o_ControlDimension == null) continue;
                Message_Status_DMXStageView.ControlDimensionDescription o_ControlDimensionDescription = new Message_Status_DMXStageView.ControlDimensionDescription();
                o_ControlDimensionDescription.setParent(p_ControlObjectDescription);
                o_ControlDimensionDescription.setName(o_ControlDimension.getDimensionName());
                o_ControlDimensionDescription.setIndex(o_ControlDimension.getDimensionIndex());
                o_ControlDimensionDescription.setValue(o_ControlDimension.getValueNormed());
                ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                o_ControlDimensionDescription.setValueLabelListCount(o_ControlLabelModel.getSize());
                for (int intLabelList = 0; intLabelList < o_ControlLabelModel.getSize(); ++intLabelList) {
                    ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intLabelList);
                    if (o_ControlLabelList == null) continue;
                    for (int intLabel = 0; intLabel < o_ControlLabelList.getSize(); ++intLabel) {
                        ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = o_ControlLabelList.getControlLabelDescription(intLabel);
                        if (o_ControlLabelDescription == null) continue;
                        double doubleValueNormedMax = o_ControlDimension.getValueNormed(o_ControlLabelDescription.getValueEnd());
                        double doubleValueNormedDefault = o_ControlDimension.getValueNormed(o_ControlLabelDescription.getValueDefault());
                        double doubleValueNormedMin = o_ControlDimension.getValueNormed(o_ControlLabelDescription.getValueStart());
                        o_ControlDimensionDescription.addValueLabel(intLabelList, o_ControlLabelDescription.getLabelText(), doubleValueNormedMax, doubleValueNormedDefault, doubleValueNormedMin);
                    }
                }
                o_ControlDimensionDescription.setValueLabelListActual(o_ControlLabelModel.getSelectedControlLabelListIndex());
                o_ControlDimension.addPropertyChangeListener("value", (PropertyChangeListener)o_ControlDimensionDescription);
                o_ControlDimension.addPropertyChangeListener("valueAdjustedManually", (PropertyChangeListener)o_ControlDimensionDescription);
                if (o_ControlLabelModel != null) {
                    o_ControlLabelModel.addPropertyChangeListener("listSelected", (PropertyChangeListener)o_ControlDimensionDescription);
                }
                p_ControlObjectDescription.addControlDimensionDescription(o_ControlDimensionDescription);
            }
        }

        public void sendMessage_DMXControlComponent(RemoteUser p_RemoteUser, DMXControlComponent p_DMXControlComponent) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            if (p_DMXControlComponent == null) {
                return;
            }
            Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlDescription = this.getDMXControlComponentDescription(p_DMXControlComponent.getDMXControlTypeID());
            if (o_DMXControlDescription == null) {
                return;
            }
            Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlDescription_New = o_DMXControlDescription.copy(null);
            Message_DMXControlComponent o_Message_DMXControlComponent = new Message_DMXControlComponent(o_DMXControlDescription_New);
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXControlComponent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventDMXControlComponentRemoved(DMXControlComponent p_DMXControlComponent, int p_ActualIndex) {
            Object object = this.m_SyncDMXControlComponent;
            synchronized (object) {
                Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.getDMXControlComponentDescription(p_DMXControlComponent.getDMXControlTypeID());
                if (o_DMXControlComponentDescription == null) {
                    return;
                }
                int intControlObjectCount = o_DMXControlComponentDescription.getControlObjectDescriptionCount();
                for (int intControlObject = intControlObjectCount - 1; intControlObject >= 0; --intControlObject) {
                    Message_Status_DMXStageView.ControlObjectDescription o_ControlObjectDescription = o_DMXControlComponentDescription.getControlObjectDescription(intControlObject);
                    if (o_ControlObjectDescription == null) continue;
                    ControlObject o_ControlObject = p_DMXControlComponent.getControlObject(intControlObject);
                    int intControlDimensionCount = o_ControlObjectDescription.getControlDimensionDescriptionCount();
                    for (int intControlDimension = intControlDimensionCount - 1; intControlDimension >= 0; --intControlDimension) {
                        Message_Status_DMXStageView.ControlDimensionDescription o_ControlDimensionDescription = o_ControlObjectDescription.getControlDimensionDescription(intControlDimension);
                        if (o_ControlDimensionDescription == null) continue;
                        ControlObject.ControlDimension o_ControlDimension = o_ControlObject != null ? o_ControlObject.getControlDimension(intControlDimension) : null;
                        if (o_ControlDimension != null) {
                            ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                            o_ControlDimension.removePropertyChangeListener("value", (PropertyChangeListener)o_ControlDimensionDescription);
                            o_ControlDimension.removePropertyChangeListener("valueAdjustedManually", (PropertyChangeListener)o_ControlDimensionDescription);
                            if (o_ControlLabelModel != null) {
                                o_ControlLabelModel.removePropertyChangeListener("listSelected", (PropertyChangeListener)o_ControlDimensionDescription);
                            }
                        }
                        o_ControlObjectDescription.removeControlDimensionDescription(o_ControlDimensionDescription);
                    }
                    o_DMXControlComponentDescription.removeControlObjectDescription(o_ControlObjectDescription);
                }
                this.m_DMXControlDescriptions.remove(p_DMXControlComponent.getDMXControlTypeID());
            }
            this.sendMessage_DMXControlComponentRemoved(null, p_DMXControlComponent);
        }

        public void sendMessage_DMXControlComponentRemoved(RemoteUser p_RemoteUser, DMXControlComponent p_DMXControlComponent) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_DMXControlComponentRemoved o_Message_DMXControlComponentRemoved = new Message_DMXControlComponentRemoved(p_DMXControlComponent.getDMXControlTypeID());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXControlComponentRemoved);
        }

        public void eventDMXControlComponentVisible(DMXControlComponent p_DMXControlComponent, int p_ActualIndex, boolean p_Visible) {
            if (p_DMXControlComponent == null) {
                return;
            }
            Message_Status_DMXStageView.DMXControlComponentDescription o_DMXControlComponentDescription = this.getDMXControlComponentDescription(p_DMXControlComponent.getDMXControlTypeID());
            if (o_DMXControlComponentDescription == null) {
                return;
            }
            if (o_DMXControlComponentDescription.getVisible() == p_Visible) {
                return;
            }
            o_DMXControlComponentDescription.setVisible(p_Visible);
            this.sendMessage_DMXControlComponentVisible(null, p_DMXControlComponent);
        }

        public void sendMessage_DMXControlComponentVisible(RemoteUser p_RemoteUser, DMXControlComponent p_DMXControlComponent) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_DMXControlComponentVisible o_Message_DMXControlComponentVisible = new Message_DMXControlComponentVisible(p_DMXControlComponent.getDMXControlTypeID(), p_DMXControlComponent.isVisible());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_DMXControlComponentVisible);
        }

        public void changeDMXControlDimension(RemoteUser p_RemoteUser, Message_DMXControlComponentValue p_Message_DMXControlComponentValue) {
            if (p_Message_DMXControlComponentValue == null) {
                return;
            }
            boolean boolVirtual = false;
            DMXMixerPanel o_DMXMixerPanel = LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel();
            if (o_DMXMixerPanel == null) {
                return;
            }
            DMXControlComponent o_DMXControlComponent = o_DMXMixerPanel.getDMXControlComponentByID(p_Message_DMXControlComponentValue.getDMXControlTypeID());
            if (o_DMXControlComponent == null) {
                return;
            }
            int intControlDimensionIndex = p_Message_DMXControlComponentValue.getControlDimensionIndex();
            double doubleValue = p_Message_DMXControlComponentValue.getValue();
            ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(p_Message_DMXControlComponentValue.getControlObjectIndex());
            if (o_ControlObject == null && o_DMXControlComponent instanceof DMXControl_GridPanTilt && p_Message_DMXControlComponentValue.getControlObjectIndex() == 1) {
                double doubleCoordYNew;
                double doubleCoordXNew;
                DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent;
                JControlGrid o_JControlGrid = o_DMXControl_GridPanTilt.getJControlGridVirtual();
                ControlObject.ControlDimension o_ControlDimension = o_JControlGrid.getControlDimension(intControlDimensionIndex);
                double doubleCoordX = o_JControlGrid.getControlDimension(0).getValue();
                double doubleCoordY = o_JControlGrid.getControlDimension(1).getValue();
                if (intControlDimensionIndex == 0) {
                    doubleCoordXNew = o_JControlGrid.getControlDimension(0).getValue(doubleValue);
                    doubleCoordYNew = doubleCoordY;
                } else {
                    doubleCoordXNew = doubleCoordX;
                    doubleCoordYNew = o_JControlGrid.getControlDimension(1).getValue(doubleValue);
                }
                o_JControlGrid.setMousePressed(true);
                o_JControlGrid.setValues(doubleCoordXNew, doubleCoordXNew - doubleCoordX, doubleCoordYNew, doubleCoordYNew - doubleCoordY, 2);
                o_JControlGrid.setMousePressed(false);
                if (doubleCoordX != doubleCoordXNew || doubleCoordY != doubleCoordYNew) {
                    this.m_ValueDimensionSetByRemote = o_ControlDimension;
                    this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)p_Message_DMXControlComponentValue, p_RemoteUser);
                }
                return;
            }
            if (o_ControlObject == null) {
                return;
            }
            ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intControlDimensionIndex);
            if (o_ControlDimension == null) {
                return;
            }
            if (doubleValue != o_ControlDimension.getValueNormed()) {
                this.m_ValueDimensionSetByRemote = o_ControlDimension;
                o_ControlDimension.setValueNormed(doubleValue, 2);
                o_ControlObject.setValueManuallyIsReady();
            }
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage_ExcludeClient((Serializable)p_Message_DMXControlComponentValue, p_RemoteUser);
        }

        public void callDMXControlFunction(RemoteUser p_RemoteUser, Message_DMXControlComponentFunction p_Message_DMXControlComponentFunction) {
            if (p_Message_DMXControlComponentFunction == null) {
                return;
            }
            DMXMixerPanel o_DMXMixerPanel = LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel();
            this.m_ValueDimensionSetByRemote = null;
            ArrayList o_SelectedDMXDevices = LiveShowDMXStageView.s_SelfReference.getSelectedDMXDevices(null);
            block4: for (int intDevice = 0; intDevice < o_SelectedDMXDevices.size(); ++intDevice) {
                DMXDevice o_DMXDevice = (DMXDevice)o_SelectedDMXDevices.get(intDevice);
                if (o_DMXDevice == null) continue;
                switch (p_Message_DMXControlComponentFunction.getFunctionID()) {
                    case 0: {
                        o_DMXDevice.callControlFunction(DMXDeviceType.s_ControlFunctionType_Null);
                        continue block4;
                    }
                    case 1: {
                        o_DMXDevice.callControlFunction(DMXDeviceType.s_ControlFunctionType_Default);
                    }
                }
            }
        }

        public void eventControlGroupsChangeType(int p_ChangeType) {
            Message_DMXControlGroupsChangeType o_Message = new Message_DMXControlGroupsChangeType(p_ChangeType);
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message);
        }

        public void changeDMXControlGroupsChangeType(RemoteUser p_RemoteUser, Message_DMXControlGroupsChangeType p_Message_DMXControlGroupsChangeType) {
            if (p_Message_DMXControlGroupsChangeType == null) {
                return;
            }
            DMXMixerPanel o_DMXMixerPanel = LiveShowDMXStageView.s_SelfReference.getDMXMixerPanel();
            int intChangeType = p_Message_DMXControlGroupsChangeType.getGroupsChangeType();
            o_DMXMixerPanel.setControlGroupsChangeType(10, intChangeType);
        }

        public void requestStatusRemoteBoard(RemoteUser p_RemoteUser) {
            this.sendMessage_StatusRemoteBoard(p_RemoteUser);
        }

        public void sendMessage_StatusRemoteBoard(RemoteUser p_RemoteUser) {
            JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem;
            int intY;
            int intX;
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_Status_RemoteBoard o_Message_Status_RemoteBoard = new Message_Status_RemoteBoard();
            o_Message_Status_RemoteBoard.setGridSizeX(LiveShowInternalFrame_RemoteBoard.getGridSizeX());
            o_Message_Status_RemoteBoard.setGridSizeY(LiveShowInternalFrame_RemoteBoard.getGridSizeY());
            int intGridSizeX = LiveShowInternalFrame_RemoteBoard.getGridSizeX();
            int intGridSizeY = LiveShowInternalFrame_RemoteBoard.getGridSizeY();
            for (intX = 0; intX < intGridSizeX; ++intX) {
                for (intY = 0; intY < intGridSizeY; ++intY) {
                    Message_Status_RemoteBoard.ItemDescription o_ItemDescription;
                    o_JPanel_RemoteBoardItem = LiveShowInternalFrame_RemoteBoard.getRemoteBoardItem(intX, intY);
                    if (o_JPanel_RemoteBoardItem == null || (o_ItemDescription = this.createItemDescription(o_JPanel_RemoteBoardItem, true)) == null) continue;
                    o_Message_Status_RemoteBoard.addItemDescription(o_ItemDescription);
                }
            }
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(p_RemoteUser, (Serializable)o_Message_Status_RemoteBoard);
            for (intX = 0; intX < intGridSizeX; ++intX) {
                for (intY = 0; intY < intGridSizeY; ++intY) {
                    o_JPanel_RemoteBoardItem = LiveShowInternalFrame_RemoteBoard.getRemoteBoardItem(intX, intY);
                    if (o_JPanel_RemoteBoardItem == null) continue;
                    this.sendMessage_RemoteBoardItemPlayStatus(o_JPanel_RemoteBoardItem);
                }
            }
        }

        public void sendMessage_RemoteBoardItemChanged(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem, boolean p_ImageCHanged) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_Status_RemoteBoard.ItemDescription o_ItemDescription = this.createItemDescription(p_JPanel_RemoteBoardItem, p_ImageCHanged);
            if (o_ItemDescription == null) {
                return;
            }
            Message_RemoteBoardItemChanged o_Message_RemoteBoardItemChanged = new Message_RemoteBoardItemChanged(o_ItemDescription);
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_RemoteBoardItemChanged);
        }

        public Message_Status_RemoteBoard.ItemDescription createItemDescription(JPanel_RemoteBoardItem p_RemoteBoardItem, boolean p_ImageChanged) {
            if (p_RemoteBoardItem == null) {
                return null;
            }
            String stringDisplayText = "";
            boolean boolActionAssigned = p_RemoteBoardItem.getRemoteBoard_Action() != null;
            Color o_Color_Background = p_RemoteBoardItem.getDisplayBackground_Color();
            Color o_Color_Text = p_RemoteBoardItem.getDisplayText_Color();
            int intImageSizeX = 0;
            int intImageSizeY = 0;
            int[] o_ImageValues = null;
            if (p_ImageChanged) {
                BufferedImage o_BufferedImage = null;
                switch (p_RemoteBoardItem.getDisplayImage_Flag()) {
                    case 0: {
                        o_BufferedImage = null;
                        break;
                    }
                    case 1: {
                        o_BufferedImage = p_RemoteBoardItem.getDisplayImage_Default();
                        break;
                    }
                    case 2: {
                        o_BufferedImage = p_RemoteBoardItem.getDisplayImage_Custom();
                    }
                }
                if (o_BufferedImage != null) {
                    intImageSizeX = o_BufferedImage.getWidth();
                    intImageSizeY = o_BufferedImage.getHeight();
                    try {
                        o_ImageValues = ImagesTools.getArrayFromImage((Image)o_BufferedImage, (int)intImageSizeX, (int)intImageSizeY);
                    }
                    catch (Exception e) {
                        intImageSizeX = 0;
                        intImageSizeY = 0;
                        o_ImageValues = null;
                    }
                }
            }
            switch (p_RemoteBoardItem.getDisplayText_Flag()) {
                case 0: {
                    stringDisplayText = "";
                    break;
                }
                case 1: {
                    stringDisplayText = p_RemoteBoardItem.getDisplayText_Default();
                    break;
                }
                case 2: {
                    stringDisplayText = p_RemoteBoardItem.getDisplayText();
                }
            }
            Message_Status_RemoteBoard.ItemDescription o_ItemDescription = new Message_Status_RemoteBoard.ItemDescription(p_RemoteBoardItem.getDisplayGridX(), p_RemoteBoardItem.getDisplayGridY(), boolActionAssigned, p_RemoteBoardItem.getDisplayBackground_Transparent(), o_Color_Background.getRed(), o_Color_Background.getGreen(), o_Color_Background.getBlue(), stringDisplayText, p_RemoteBoardItem.getDisplayText_AnchorFlag(), o_Color_Text.getRed(), o_Color_Text.getGreen(), o_Color_Text.getBlue(), p_ImageChanged, intImageSizeX, intImageSizeY, o_ImageValues);
            return o_ItemDescription;
        }

        public void sendMessage_RemoteBoardItemPlayStatus(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem) {
            if (this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsersCount() <= 0) {
                return;
            }
            Message_RemoteBoardItemPlayStatus o_Message_RemoteBoardItemPlayStatus = new Message_RemoteBoardItemPlayStatus(p_JPanel_RemoteBoardItem.getDisplayGridX(), p_JPanel_RemoteBoardItem.getDisplayGridY(), p_JPanel_RemoteBoardItem.getIsPlaying(), p_JPanel_RemoteBoardItem.getIsPlayingAll(), p_JPanel_RemoteBoardItem.getIsPlayingStopped());
            this.m_LiveShowInternalFrame_RemoteServer.sendMessage(null, (Serializable)o_Message_RemoteBoardItemPlayStatus);
        }

        @Override
        public void eventRemoteBoard_Changed(JPanel_RemoteBoard p_JPanel_RemoteBoard) {
            if (p_JPanel_RemoteBoard == null) {
                return;
            }
            this.sendMessage_StatusRemoteBoard(null);
        }

        @Override
        public void eventRemoteBoardItem_Changed(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem, boolean p_ImageChanged) {
            if (p_JPanel_RemoteBoardItem == null) {
                return;
            }
            this.sendMessage_RemoteBoardItemChanged(p_JPanel_RemoteBoardItem, p_ImageChanged);
        }

        @Override
        public void eventRemoteBoardItem_PlayStatus(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem) {
            if (p_JPanel_RemoteBoardItem == null) {
                return;
            }
            this.sendMessage_RemoteBoardItemPlayStatus(p_JPanel_RemoteBoardItem);
        }

        public void doActionRemoteBoard(RemoteUser p_RemoteUser, int p_GridX, int p_GridY) {
            JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem = LiveShowInternalFrame_RemoteBoard.getRemoteBoardItem(p_GridX, p_GridY);
            if (o_JPanel_RemoteBoardItem == null) {
                return;
            }
            o_JPanel_RemoteBoardItem.doAction();
        }
    }

    public static class RemoteUserDescriptionTableModel
    extends TableAndListModel<Message_Permission.RemoteUserDescription> {
        public static final int s_ColumnCount = 4;
        public static final int s_ColumnIndex_Name = 0;
        public static final int s_ColumnIndex_Password = 1;
        public static final int s_ColumnIndex_Control = 2;
        public static final int s_ColumnIndex_Listen = 3;
        @LiveLanguageString
        private static String s_ColumnUserName = "Name";
        @LiveLanguageString
        private static String s_ColumnUserPassword = "Password";
        @LiveLanguageString
        private static String s_ColumnUserPermissionControl = "Control";
        @LiveLanguageString
        private static String s_ColumnUserPermissionListen = "Listen";
        @LiveLanguageString
        private static String s_ColumnUserName_ToolTip = "Double-click to change the name.";
        @LiveLanguageString
        private static String s_ColumnUserPassword_ToolTip = "Double-click to change the password.";
        @LiveLanguageString
        private static String s_ColumnUserPermissionControl_ToolTip = "The user can control the show.";
        @LiveLanguageString
        private static String s_ColumnUserPermissionListen_ToolTip = "The user can have the stage directions read aloud.";
        private LiveShowInternalFrame_RemoteServer m_LiveShowInternalFrame_RemoteServer;
        private final Object m_SyncRows = new Object();

        public RemoteUserDescriptionTableModel(LiveShowInternalFrame_RemoteServer p_LiveShowInternalFrame_RemoteServer) {
            super(false);
            this.m_LiveShowInternalFrame_RemoteServer = p_LiveShowInternalFrame_RemoteServer;
            LiveLanguage.addLanguageListener((Object)((Object)this), null);
            this.initMembers();
        }

        private void initMembers() {
        }

        public int getColumnCount() {
            return 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncRows;
            synchronized (object) {
                super.clear();
            }
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox;
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            super.finishJTable(p_JTable, null, null);
            TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(0);
            if (o_TableColumn != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
                o_TableCellEditorRenderer_String.setToolTipText(s_ColumnUserName_ToolTip);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
                o_TableCellEditorRenderer_String.setToolTipText(s_ColumnUserPassword_ToolTip);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(2)) != null) {
                o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_CheckBox);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_CheckBox);
                o_TableCellEditorRenderer_CheckBox.setToolTipText(s_ColumnUserPermissionControl_ToolTip);
                o_TableCellEditorRenderer_CheckBox.setToolTipTextAt(true, true);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(3)) != null) {
                o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_CheckBox);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_CheckBox);
                o_TableCellEditorRenderer_CheckBox.setToolTipText(s_ColumnUserPermissionListen_ToolTip);
                o_TableCellEditorRenderer_CheckBox.setToolTipTextAt(true, true);
            }
        }

        public String getColumnName(int p_Column) {
            switch (p_Column) {
                case 0: {
                    return s_ColumnUserName;
                }
                case 1: {
                    return s_ColumnUserPassword;
                }
                case 2: {
                    return s_ColumnUserPermissionControl;
                }
                case 3: {
                    return s_ColumnUserPermissionListen;
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRemoteUserDescription(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
            if (p_RemoteUserDescription == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                super.add((Object)p_RemoteUserDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRemoteUserDescription(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
            if (p_RemoteUserDescription == null) {
                return;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                super.remove((Object)p_RemoteUserDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message_Permission.RemoteUserDescription getRemoteUserDescription(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                return (Message_Permission.RemoteUserDescription)this.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message_Permission.RemoteUserDescription getRemoteUserDescription(String p_UserName, String p_UserPassword) {
            if (p_UserName == null) {
                return null;
            }
            if (p_UserPassword == null) {
                return null;
            }
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intUser = 0; intUser < this.size(); ++intUser) {
                    Message_Permission.RemoteUserDescription o_RemoteUserDescription = (Message_Permission.RemoteUserDescription)this.get(intUser);
                    if (o_RemoteUserDescription == null || !p_UserName.equals(o_RemoteUserDescription.getUserName()) || !p_UserPassword.equals(o_RemoteUserDescription.getUserPassword())) continue;
                    return o_RemoteUserDescription;
                }
            }
            return null;
        }

        public boolean checkLogin(RemoteUser p_RemoteUser, String p_UserName, String p_UserPassword) {
            if (p_RemoteUser == null) {
                return false;
            }
            Object stringUserPassword = null;
            boolean boolLoginOK = false;
            Message_Permission.RemoteUserDescription o_RemoteUserDescription = this.getRemoteUserDescription(p_UserName, p_UserPassword);
            if (o_RemoteUserDescription != null) {
                p_RemoteUser.setRemoteUserDescription(o_RemoteUserDescription);
                boolLoginOK = true;
            }
            if (boolLoginOK) {
                p_RemoteUser.sendLoginOK();
            } else {
                p_RemoteUser.sendLoginFalse();
            }
            return boolLoginOK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getPasswordOfUser(String p_UserName) {
            if (p_UserName == null) {
                return null;
            }
            String stringUserPassword = null;
            Object object = this.m_SyncRows;
            synchronized (object) {
                for (int intDescription = 0; intDescription < this.size(); ++intDescription) {
                    String stringUserName;
                    Message_Permission.RemoteUserDescription o_RemoteUserDescription = (Message_Permission.RemoteUserDescription)this.get(intDescription);
                    if (o_RemoteUserDescription == null || !p_UserName.equals(stringUserName = o_RemoteUserDescription.getUserName())) continue;
                    stringUserPassword = o_RemoteUserDescription.getUserPassword();
                    break;
                }
            }
            return stringUserPassword;
        }

        public Object getValue(Message_Permission.RemoteUserDescription p_RemoteUserDescription, int columnIndex) {
            if (p_RemoteUserDescription == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return p_RemoteUserDescription.getUserName();
                }
                case 1: {
                    return p_RemoteUserDescription.getUserPassword();
                }
                case 2: {
                    return p_RemoteUserDescription.getPermissionControl();
                }
                case 3: {
                    return p_RemoteUserDescription.getPermissionListen();
                }
            }
            return null;
        }

        public void setValue(Message_Permission.RemoteUserDescription p_RemoteUserDescription, Object p_Value, int p_Column) {
            boolean boolPermissionChanged = false;
            if (p_RemoteUserDescription == null) {
                return;
            }
            switch (p_Column) {
                case 0: {
                    String stringUserName = (String)p_Value;
                    p_RemoteUserDescription.setUserName(stringUserName);
                    break;
                }
                case 1: {
                    String stringUserPassword = (String)p_Value;
                    p_RemoteUserDescription.setUserPassword(stringUserPassword);
                    break;
                }
                case 2: {
                    boolean boolPermissionControl = (Boolean)p_Value;
                    if (p_RemoteUserDescription.getPermissionControl() == boolPermissionControl) {
                        return;
                    }
                    boolPermissionChanged = true;
                    p_RemoteUserDescription.setPermissionControl(boolPermissionControl);
                    break;
                }
                case 3: {
                    boolean boolPermissionListen = (Boolean)p_Value;
                    if (p_RemoteUserDescription.getPermissionListen() == boolPermissionListen) {
                        return;
                    }
                    boolPermissionChanged = true;
                    p_RemoteUserDescription.setPermissionListen(boolPermissionListen);
                }
            }
            if (boolPermissionChanged) {
                ArrayList<RemoteUser> o_RemoteUsers = this.m_LiveShowInternalFrame_RemoteServer.getRemoteUsers(p_RemoteUserDescription);
                for (int intUser = 0; intUser < o_RemoteUsers.size(); ++intUser) {
                    RemoteUser o_RemoteUser = o_RemoteUsers.get(intUser);
                    o_RemoteUser.sendPermission();
                }
            }
        }

        public static class CellRendererPermission
        extends JCheckBox
        implements TableCellRenderer {
            public CellRendererPermission() {
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
            }

            private void initMembers() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color o_Background = table.getBackground();
                Color o_Foreground = table.getForeground();
                if (isSelected) {
                    if (table.hasFocus()) {
                        o_Background = UIManager.getColor("Table.selectionBackground");
                        o_Foreground = UIManager.getColor("Table.selectionForeground");
                    } else {
                        o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                        o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                    }
                }
                this.setBackground(o_Background);
                this.setForeground(o_Foreground);
                int intRow = table.convertRowIndexToModel(row);
                int intColumn = table.convertColumnIndexToModel(column);
                try {
                    RemoteUserDescriptionTableModel o_RemoteUserDescriptionTableModel = (RemoteUserDescriptionTableModel)((Object)table.getModel());
                    super.setSelected((Boolean)o_RemoteUserDescriptionTableModel.getValueAt(intRow, intColumn));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setFont(table.getFont());
                return this;
            }
        }
    }

    public static class RemoteUserCellRenderer
    implements ListCellRenderer {
        public static final Border s_BorderConnectionUndefined = new LineBorder(Color.ORANGE, 1);
        public static final Border s_BorderConnectionLost = new LineBorder(Color.YELLOW, 1);
        public static final Border s_BorderConnectionLoginFalse = new LineBorder(Color.RED, 1);
        public static final Border s_BorderConnectionLoginOk = null;
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value instanceof RemoteUser) {
                RemoteUser o_RemoteUser = (RemoteUser)value;
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append("<html>");
                o_StringBuilder.append("<b>");
                o_StringBuilder.append(o_RemoteUser.getUserName());
                o_StringBuilder.append("</b>");
                o_StringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                o_StringBuilder.append("IP: ");
                LiveDBClient o_LiveDBClient = o_RemoteUser.getLiveDBClient();
                if (o_LiveDBClient != null) {
                    o_StringBuilder.append(o_LiveDBClient.getLiveDBConnectionDescription().getClientRemoteIP());
                }
                o_StringBuilder.append("</html>");
                renderer.setText(o_StringBuilder.toString());
                switch (o_RemoteUser.getConnectionStatus()) {
                    case 10000: {
                        renderer.setBorder(s_BorderConnectionLoginOk);
                        break;
                    }
                    case 9999: {
                        renderer.setBorder(s_BorderConnectionLoginFalse);
                        break;
                    }
                    case 8: {
                        renderer.setBorder(s_BorderConnectionLost);
                        break;
                    }
                    default: {
                        renderer.setBorder(s_BorderConnectionUndefined);
                    }
                }
            }
            return renderer;
        }
    }

    public static class RemoteUser {
        public static final int CONNECTION_LOGINOK = 10000;
        public static final int CONNECTION_LOGINFALSE = 9999;
        private LiveDBClient m_LiveDBClient;
        Message_Permission.RemoteUserDescription m_RemoteUserDescription;
        private int m_ConnectionStatus;

        public RemoteUser(LiveDBClient p_LiveDBClient) {
            this.m_LiveDBClient = p_LiveDBClient;
            this.m_RemoteUserDescription = null;
            this.m_ConnectionStatus = p_LiveDBClient.getConnectionStatus();
        }

        public LiveDBClient getLiveDBClient() {
            return this.m_LiveDBClient;
        }

        public void close() {
            if (this.m_LiveDBClient != null) {
                this.m_LiveDBClient.close();
            }
        }

        public void setRemoteUserDescription(Message_Permission.RemoteUserDescription p_RemoteUserDescription) {
            this.m_RemoteUserDescription = p_RemoteUserDescription;
        }

        public Message_Permission.RemoteUserDescription getRemoteUserDescription() {
            return this.m_RemoteUserDescription;
        }

        public void setConnectionStatus(int p_ConnectionStatus) {
            this.m_ConnectionStatus = p_ConnectionStatus;
        }

        public int getConnectionStatus() {
            if (this.m_LiveDBClient == null) {
                return 0;
            }
            return this.m_ConnectionStatus;
        }

        public void sendLoginOK() {
            if (this.m_RemoteUserDescription != null) {
                Message_LoginOK o_Message_LoginOK = new Message_LoginOK(this.m_RemoteUserDescription);
                this.m_LiveDBClient.sendMessage((Serializable)o_Message_LoginOK);
                this.setConnectionStatus(10000);
            } else {
                this.sendLoginFalse();
            }
        }

        public void sendLoginFalse() {
            Message_LoginFailed o_Message_LoginFailed = new Message_LoginFailed();
            this.m_LiveDBClient.sendMessage((Serializable)o_Message_LoginFailed);
            this.m_LiveDBClient.close();
            this.setConnectionStatus(9999);
        }

        public void sendPermission() {
            Message_Permission o_Message_Permission = new Message_Permission(this.m_RemoteUserDescription);
            this.m_LiveDBClient.sendMessage((Serializable)o_Message_Permission);
        }

        public String getUserName() {
            LiveDBConnectionDescription o_LiveDBConnectionDescription;
            if (this.m_ConnectionStatus == 10000) {
                if (this.m_RemoteUserDescription != null) {
                    return this.m_RemoteUserDescription.getUserName();
                }
                return "?";
            }
            if (this.m_LiveDBClient != null && (o_LiveDBConnectionDescription = this.m_LiveDBClient.getLiveDBConnectionDescription()) != null) {
                return o_LiveDBConnectionDescription.getClientRemoteIP();
            }
            return "?";
        }

        public String getUserPassword() {
            if (this.m_RemoteUserDescription == null) {
                return "";
            }
            return this.m_RemoteUserDescription.getUserPassword();
        }

        public boolean getPermissionControl() {
            if (this.m_RemoteUserDescription == null) {
                return false;
            }
            return this.m_RemoteUserDescription.getPermissionControl();
        }
    }

    public static class NetworkDescriptionCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value instanceof NetworkDescription) {
                NetworkDescription o_NetworkDescription = (NetworkDescription)value;
                renderer.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                renderer.setText(o_NetworkDescription.getDisplayName());
            }
            return renderer;
        }
    }

    public static class NetworkDescription {
        private NetworkInterface m_NetworkInterface;
        private InetAddress m_InetAddress;
        private String m_NetworkInterfaceDisplayName;
        private String m_InetAddressName;
        private String m_DisplayName;

        public NetworkDescription() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_DisplayName = "";
        }

        public void close() {
            this.setNetwork(null, null);
        }

        public void setNetwork(NetworkInterface p_NetworkInterface, InetAddress p_InetAddress) {
            this.m_NetworkInterface = p_NetworkInterface;
            this.m_InetAddress = p_InetAddress;
            this.m_NetworkInterfaceDisplayName = this.m_NetworkInterface != null ? this.m_NetworkInterface.getDisplayName() : "";
            this.m_InetAddressName = this.m_InetAddress != null ? this.m_InetAddress.getHostAddress() : "";
            this.m_DisplayName = this.m_NetworkInterfaceDisplayName + ": " + this.m_InetAddressName;
        }

        public NetworkInterface getNetworkInterface() {
            return this.m_NetworkInterface;
        }

        public InetAddress getInetAddress() {
            return this.m_InetAddress;
        }

        public String getInetAddressName() {
            return this.m_InetAddressName;
        }

        public String getDisplayName() {
            return this.m_DisplayName;
        }
    }
}

