/*
 * Decompiled with CFR 0.152.
 */
package LiveShowProjectPackage;

import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObjectGroupPanel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowProjectPackage.LiveShowInternalFrame_PlayJingles;
import LiveShowProjectPackage.LiveShowJingleGroupPanel;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SoundPackage.SoundMixers;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Time;
import Text.NameExtension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class LiveShowJingleGroup
implements LiveShowInternalFrame_PlayJingles.JingleListener,
PlayListener,
SPIT_Action_Interface,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".ljg";
    public static final String FILESUFFIX_SELECTION = ".sjg";
    public static ImageIcon s_Icon = new ImageIcon(LiveShowObjectGroupPanel.class.getResource("/IconsPackage/JingleGroup.png"));
    public static Color s_Color_JingleGroup = new Color(0, 0, 100);
    @LiveLanguageString
    public static String DEFAULT_GROUPNAME = "JingleGroup";
    public static final String PROP_NAME = "jingleGroupName";
    public static final String PROP_REMARK = "jingleGroupRemark";
    public static final String PROP_CLOSED = "jingleGroupClosed";
    public static final String PROP_PLAYSTATUS = "jingleGroupPlayStatus";
    private static final Object s_SyncJingleGroupListeners = new Object();
    private static ArrayList<JingleGroupListener> s_JingleGroupListeners = new ArrayList();
    public static JingleGroupTableModel s_GroupTableModel = new JingleGroupTableModel();
    private String m_ID;
    private String m_Name;
    private String m_Remark;
    private ArrayList<LiveShowJingle.JingleInterface> m_JingleInterfaces;
    private boolean m_PlayStartEnabled;
    private boolean m_PlayFadeInEnabled;
    private boolean m_PlayFadeOutEnabled;
    private boolean m_PlayPauseEnabled;
    private boolean m_PlayStopEnabled;
    private boolean m_PlayAllFadedIn;
    private boolean m_PlayNoneFadedIn;
    private int m_PlayJingleRunning;
    private int m_PlayJingleWaiting;
    private boolean m_IsPlayFadeInPause;
    private boolean m_StopPlayAfterAllFadedIn;
    private boolean m_IsPlayFadeOut;
    private ArrayList<LiveShowJingle.JingleInterface> m_JinglesWaiting;
    private boolean m_Closing;
    private StringBuilder m_StringBuilderToolTip;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected static final Object m_SyncObjects = new Object();
    private final Object m_SyncStringBuilder = new Object();

    public static void playJingleGroup(LiveShowJingleGroup p_LiveShowJingleGroup) {
        if (p_LiveShowJingleGroup == null) {
            return;
        }
        p_LiveShowJingleGroup.playStart();
    }

    public LiveShowJingleGroup() {
        this("");
    }

    public LiveShowJingleGroup(String p_Name) {
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Name = this.createName(p_Name);
        this.refreshToolTipText();
        LiveShowInternalFrame_PlayJingles.addJingleListener(this);
    }

    private void initMembers() {
        this.m_Closing = false;
        this.m_PlayStartEnabled = true;
        this.m_PlayFadeInEnabled = false;
        this.m_PlayFadeOutEnabled = false;
        this.m_PlayPauseEnabled = false;
        this.m_PlayStopEnabled = false;
        this.m_PlayJingleRunning = 0;
        this.m_PlayJingleWaiting = 0;
        this.m_PlayAllFadedIn = false;
        this.m_PlayNoneFadedIn = true;
        this.m_StringBuilderToolTip = new StringBuilder();
        this.m_JingleInterfaces = new ArrayList();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_ID = LiveGUID.getGUID();
        this.m_Remark = "";
        this.m_IsPlayFadeInPause = false;
        this.m_StopPlayAfterAllFadedIn = false;
        this.m_IsPlayFadeOut = false;
        this.m_JinglesWaiting = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = m_SyncObjects;
        synchronized (object) {
            out.writeInt(this.getJingleInterfaceCount());
            for (int intObject = 0; intObject < this.getJingleInterfaceCount(); ++intObject) {
                LiveShowJingle.JingleInterface o_JingleInterface = this.getJingleInterface(intObject);
                if (o_JingleInterface == null) continue;
                out.writeUTF(o_JingleInterface.getJingleID());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String oldValue = this.m_Name;
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        int intObjectCount = in.readInt();
        for (int intObject = 0; intObject < intObjectCount; ++intObject) {
            String stringObjectID = in.readUTF();
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleInterface = LiveShowInternalFrame_PlayJingles.getJingleView(stringObjectID);
            if (o_JingleInterface == null) continue;
            this.addJingleInterface_Sorted(o_JingleInterface);
        }
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, (Object)oldValue, (Object)this.m_Name);
        }
    }

    protected void close() {
        this.m_Closing = true;
        LiveShowInternalFrame_PlayJingles.removeJingleListener(this);
        this.clearJingleInterfaces();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, (Object)this, null);
            this.m_PropertyChangeSupport.clear();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public String getID() {
        return this.m_ID;
    }

    private void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        if (p_ID.equals(this.m_ID)) {
            return;
        }
        this.m_ID = p_ID;
    }

    private String createName(String p_Name) {
        boolean boolShowNumber1;
        String stringPrefix;
        int intPrefixCount = 0;
        int intMaxPostfix = 0;
        String stringNameOrigin = null;
        boolean boolPrefixFound = false;
        if (p_Name != null && p_Name.length() > 0) {
            stringPrefix = NameExtension.getPrefix((String)p_Name);
            stringNameOrigin = p_Name;
            boolShowNumber1 = false;
        } else {
            stringPrefix = DEFAULT_GROUPNAME;
            boolShowNumber1 = true;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intGroup = 0; intGroup < LiveShowJingleGroup.getGroupCount(); ++intGroup) {
            int intPostfix;
            LiveShowJingleGroup o_LiveShowJingleGroup = LiveShowJingleGroup.getGroup(intGroup);
            if (o_LiveShowJingleGroup == null || (intPostfix = NameExtension.getPostfix_Int((String)o_LiveShowJingleGroup.getName(), (String)stringPrefix)) == -2) continue;
            boolPrefixFound = true;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostfix) continue;
            intMaxPostfix = intPostfix;
        }
        ++intMaxPostfix;
        if (boolPrefixFound || stringNameOrigin == null) {
            return NameExtension.createName((String)stringPrefix, (int)intMaxPostfix, (String)"000", (boolean)boolShowNumber1);
        }
        return stringNameOrigin;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (this.m_Closing) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, (Object)oldValue, (Object)this.m_Name);
        }
        LiveShowJingleGroup.notifyJingleGroupChanged(this);
        SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type((String)this.getID());
        if (o_SPIT_Type_Interface != null) {
            o_SPIT_Type_Interface.setName(this.getName());
        }
        this.changeRemoteMouseActions();
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        if (this.m_Closing) {
            return;
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, (Object)oldValue, (Object)this.m_Remark);
        }
        LiveShowJingleGroup.notifyJingleGroupChanged(this);
    }

    public void resetObjects() {
        this.clearJingleInterfaces();
        int intSelectedJingleViewCount = LiveShowInternalFrame_PlayJingles.getSelectedJingleViewCount();
        for (int intJingleView = 0; intJingleView < intSelectedJingleViewCount; ++intJingleView) {
            LiveShowJingle.JingleInterface o_JingleInterface = LiveShowInternalFrame_PlayJingles.getSelectedJingleView(intJingleView);
            if (o_JingleInterface == null) continue;
            this.addJingleInterface_Sorted((LiveShowInternalFrame_PlayJingles.JingleView)o_JingleInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJingleInterfaces() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        Object object = m_SyncObjects;
        synchronized (object) {
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            o_JingleInterfaces.addAll(this.m_JingleInterfaces);
            this.m_JingleInterfaces.clear();
        }
        for (int intObject = o_JingleInterfaces.size() - 1; intObject >= 0; --intObject) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intObject);
            this.removeJingleInterface(o_JingleInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJingleInterfaceCount() {
        Object object = m_SyncObjects;
        synchronized (object) {
            return this.m_JingleInterfaces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJingleInterface_Sorted(LiveShowJingle.JingleInterface p_JingleInterface) {
        if (p_JingleInterface == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            LiveShowJingle.JingleInterface o_JingleInterface;
            if (this.m_JingleInterfaces.contains(p_JingleInterface)) {
                return false;
            }
            int intIndex = 0;
            for (intIndex = 0; intIndex < this.m_JingleInterfaces.size() && ((o_JingleInterface = this.m_JingleInterfaces.get(intIndex)) == null || p_JingleInterface.getFrameStart() >= o_JingleInterface.getFrameStart()); ++intIndex) {
            }
            this.m_JingleInterfaces.add(intIndex, p_JingleInterface);
            p_JingleInterface.addPlayListener((PlayListener)this);
        }
        s_GroupTableModel.changedElement(this);
        this.refreshPlayStatus();
        this.refreshToolTipText();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJingleInterface(LiveShowJingle.JingleInterface p_JingleInterface) {
        if (p_JingleInterface == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_JingleInterfaces.remove(p_JingleInterface);
            p_JingleInterface.removePlayListener((PlayListener)this);
        }
        s_GroupTableModel.changedElement(this);
        this.refreshPlayStatus();
        this.refreshToolTipText();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowJingle.JingleInterface getJingleInterface(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_JingleInterfaces.size()) {
                return null;
            }
            return this.m_JingleInterfaces.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(LiveShowJingle.JingleInterface p_JingleInterface) {
        if (p_JingleInterface == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            return this.m_JingleInterfaces.contains(p_JingleInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playStart() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_IsPlayFadeOut = false;
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            if (this.m_JinglesWaiting.size() > 0) {
                o_JingleInterfaces.addAll(this.m_JinglesWaiting);
            } else {
                o_JingleInterfaces.addAll(this.m_JingleInterfaces);
            }
        }
        for (int intJingle = 0; intJingle < o_JingleInterfaces.size(); ++intJingle) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intJingle);
            o_JingleInterface.playStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playFadeInPause() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_IsPlayFadeInPause = true;
            this.m_StopPlayAfterAllFadedIn = true;
            this.m_IsPlayFadeOut = false;
            this.m_JinglesWaiting.clear();
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            o_JingleInterfaces.addAll(this.m_JingleInterfaces);
        }
        LiveShowInternalFrame_PlayJingles.JingleView.addJingleToStart(this);
        for (int intJingle = 0; intJingle < o_JingleInterfaces.size(); ++intJingle) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intJingle);
            o_JingleInterface.playStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playFadeOut() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        this.m_StopPlayAfterAllFadedIn = false;
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_IsPlayFadeInPause = false;
            this.m_StopPlayAfterAllFadedIn = false;
            this.m_IsPlayFadeOut = true;
            this.m_JinglesWaiting.clear();
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            o_JingleInterfaces.addAll(this.m_JingleInterfaces);
        }
        LiveShowInternalFrame_PlayJingles.JingleView.addJingleToStart(this);
        for (int intJingle = 0; intJingle < o_JingleInterfaces.size(); ++intJingle) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intJingle);
            o_JingleInterface.playFadeOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playFadeInOut() {
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        boolean boolPlay = false;
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_IsPlayFadeInPause) {
                if (this.m_PlayAllFadedIn) {
                    if (this.m_PlayJingleRunning <= 0) {
                        boolPlay = true;
                    } else {
                        boolFadeOut = true;
                    }
                } else {
                    boolFadeOut = true;
                }
            } else if (this.m_PlayJingleRunning > 0 || this.m_PlayJingleWaiting > 0) {
                boolFadeOut = true;
            } else {
                boolFadeIn = true;
            }
        }
        if (boolFadeIn) {
            this.playFadeInPause();
        } else if (boolPlay) {
            this.playStart();
        } else if (boolFadeOut) {
            this.playFadeOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playPause() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        Object object = m_SyncObjects;
        synchronized (object) {
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            o_JingleInterfaces.addAll(this.m_JingleInterfaces);
        }
        for (int intJingle = 0; intJingle < o_JingleInterfaces.size(); ++intJingle) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intJingle);
            o_JingleInterface.playPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playStop() {
        ArrayList<LiveShowJingle.JingleInterface> o_JingleInterfaces;
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_IsPlayFadeInPause = false;
            this.m_StopPlayAfterAllFadedIn = false;
            this.m_IsPlayFadeOut = false;
            this.m_JinglesWaiting.clear();
            o_JingleInterfaces = new ArrayList<LiveShowJingle.JingleInterface>(this.m_JingleInterfaces.size());
            o_JingleInterfaces.addAll(this.m_JingleInterfaces);
        }
        for (int intJingle = 0; intJingle < o_JingleInterfaces.size(); ++intJingle) {
            LiveShowJingle.JingleInterface o_JingleInterface = (LiveShowJingle.JingleInterface)o_JingleInterfaces.get(intJingle);
            o_JingleInterface.playStop();
        }
    }

    public void playStartStop() {
        if (this.m_PlayStopEnabled) {
            this.playStop();
        } else {
            this.playStart();
        }
    }

    public void playStartFadeOut() {
        if (this.m_PlayFadeOutEnabled) {
            this.playFadeOut();
        } else {
            this.playStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            this.m_StringBuilderToolTip.delete(0, this.m_StringBuilderToolTip.length());
            this.m_StringBuilderToolTip.append("<html>");
            this.m_StringBuilderToolTip.append("<center>");
            this.m_StringBuilderToolTip.append("<b>");
            this.m_StringBuilderToolTip.append(this.getName());
            this.m_StringBuilderToolTip.append("</b><br>");
            this.m_StringBuilderToolTip.append(this.getRemark());
            this.m_StringBuilderToolTip.append("<br>");
            this.m_StringBuilderToolTip.append("<br>");
            this.m_StringBuilderToolTip.append("</center>");
            this.m_StringBuilderToolTip.append("<table>");
            for (int intJingle = 0; intJingle < this.getJingleInterfaceCount(); ++intJingle) {
                LiveShowJingle.JingleInterface o_JingleInterface = this.getJingleInterface(intJingle);
                if (o_JingleInterface == null) continue;
                this.m_StringBuilderToolTip.append("<tr>");
                this.m_StringBuilderToolTip.append("<td align=right>");
                this.m_StringBuilderToolTip.append(DocumentFilter_Time.getTimeStringFromFrames((long)o_JingleInterface.getFrameStart(), (double)((int)SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate())));
                this.m_StringBuilderToolTip.append("</td>");
                this.m_StringBuilderToolTip.append("<td align=center>");
                this.m_StringBuilderToolTip.append("<b>");
                this.m_StringBuilderToolTip.append(o_JingleInterface.getJingleName());
                this.m_StringBuilderToolTip.append("</b>");
                this.m_StringBuilderToolTip.append("</td>");
                this.m_StringBuilderToolTip.append("<td align=center>");
                this.m_StringBuilderToolTip.append(o_JingleInterface.getJingleSourceName());
                this.m_StringBuilderToolTip.append("</td>");
                this.m_StringBuilderToolTip.append("</tr>");
            }
            this.m_StringBuilderToolTip.append("<table>");
            this.m_StringBuilderToolTip.append("</html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            return this.m_StringBuilderToolTip.toString();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static JingleGroupTableModel getGroupTableModel() {
        return s_GroupTableModel;
    }

    public static boolean addGroup(LiveShowJingleGroup p_Group) {
        if (p_Group == null) {
            return false;
        }
        if (!s_GroupTableModel.addGroup(p_Group)) {
            return false;
        }
        LiveShowJingleGroup.notifyJingleGroupAdded(p_Group);
        return true;
    }

    public static boolean removeGroup(LiveShowJingleGroup p_Group, boolean p_ProjectClosed) {
        if (p_Group == null) {
            return false;
        }
        p_Group.removeJingleGroupRemoteObjects();
        if (!s_GroupTableModel.removeGroup(p_Group)) {
            return false;
        }
        LiveShowJingleGroup.notifyJingleGroupRemoved(p_Group);
        p_Group.close();
        if (!p_ProjectClosed) {
            // empty if block
        }
        return true;
    }

    public static ArrayList<LiveShowJingleGroup> getGroups() {
        ArrayList<LiveShowJingleGroup> o_Groups = new ArrayList<LiveShowJingleGroup>();
        int intGroupCount = s_GroupTableModel.size();
        for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
            LiveShowJingleGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group == null) continue;
            o_Groups.add(o_Group);
        }
        return o_Groups;
    }

    public static int getGroupCount() {
        return s_GroupTableModel.size();
    }

    public static LiveShowJingleGroup getGroup(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= s_GroupTableModel.size()) {
            return null;
        }
        return s_GroupTableModel.getGroup(p_Index);
    }

    public static boolean contains(String p_ID) {
        return s_GroupTableModel.contains(p_ID);
    }

    public static LiveShowJingleGroup getGroup(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object o_Group = null;
        return s_GroupTableModel.getGroup(p_ID);
    }

    public static LiveShowJingleGroup getGroupByName(String p_Name) {
        if (p_Name == null) {
            return null;
        }
        LiveShowJingleGroup o_Group = null;
        int intGroupCount = LiveShowJingleGroup.getGroupCount();
        for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
            o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group == null) continue;
            if (p_Name.equals(o_Group.getName())) break;
            o_Group = null;
        }
        return o_Group;
    }

    public static void clear() {
        int intGroupCount = LiveShowJingleGroup.getGroupCount();
        for (int intGroup = intGroupCount - 1; intGroup >= 0; --intGroup) {
            LiveShowJingleGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            LiveShowJingleGroup.removeGroup(o_Group, true);
        }
    }

    public static void clearEmptyGroups() {
        for (int intGroup = LiveShowJingleGroup.getGroupCount() - 1; intGroup >= 0; --intGroup) {
            LiveShowJingleGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group.getJingleInterfaceCount() != 0) continue;
            LiveShowJingleGroup.removeGroup(o_Group, false);
        }
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        if (!p_LiveShow_ExportDescription.getSaveProject() && !p_LiveShow_ExportDescription.getExportProjectAll()) {
            if (!p_LiveShow_ExportDescription.getIncludeJingles()) {
                return true;
            }
            ArrayList<LiveShowJingleGroup> o_Groups = new ArrayList<LiveShowJingleGroup>();
            for (int intGroup = 0; intGroup < s_GroupTableModel.size(); ++intGroup) {
                LiveShowJingleGroup o_Group = s_GroupTableModel.getGroup(intGroup);
                if (o_Group == null) continue;
                boolean boolAllJingleInterfacesSaved = true;
                for (int intJingleInterface = 0; intJingleInterface < o_Group.getJingleInterfaceCount(); ++intJingleInterface) {
                    LiveShowJingle.JingleInterface o_JingleInterface = o_Group.getJingleInterface(intJingleInterface);
                    if (o_JingleInterface == null || LiveShowInternalFrame_PlayJingles.containsJingleInterfacesSaved(o_JingleInterface)) continue;
                    boolAllJingleInterfacesSaved = false;
                    break;
                }
                if (!boolAllJingleInterfacesSaved || o_Group == null) continue;
                o_Groups.add(o_Group);
                PlayRemoteActions.addExportedSourceID((String)o_Group.getID());
            }
            return LiveShowJingleGroup.saveGroups(p_LiveShowProjectDescription, o_Groups);
        }
        return LiveShowJingleGroup.saveGroups(p_LiveShowProjectDescription, (ArrayList<LiveShowJingleGroup>)null);
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<LiveShowJingleGroup> p_Groups) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p_Groups == null ? s_GroupTableModel.size() <= 0 : p_Groups.size() <= 0) {
                return true;
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            if (p_Groups == null) {
                int intGroupCount = LiveShowJingleGroup.getGroupCount();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    LiveShowJingleGroup o_Group = LiveShowJingleGroup.getGroup(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            } else {
                int intGroupCount = p_Groups.size();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    LiveShowJingleGroup o_Group = p_Groups.get(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteJingleGroupFile(LiveShowInternalFrame_PlayJingles p_LiveShowInternalFrame_PlayJingles, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (p_LiveShowInternalFrame_PlayJingles == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception e) {
                boolSuccess = false;
            }
        }
        return boolSuccess;
    }

    public static boolean loadGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (!o_File.exists()) {
                return false;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intGroupCount = o_ObjectInput.readInt();
            for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                LiveShowJingleGroup o_Group = new LiveShowJingleGroup();
                o_Group.readExternal(o_ObjectInput);
                if (LiveShowJingleGroup.contains(o_Group.getID())) {
                    o_Group.close();
                    continue;
                }
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    LiveShowJingleGroup.addGroup(o_Group);
                } else {
                    String stringGroupName = o_Group.getName();
                    stringGroupName = LiveShow_ImportDescription.createImportedName((String)stringGroupName);
                    o_Group.setName(stringGroupName);
                    LiveShowJingleGroup.addGroup(o_Group);
                }
                o_Group.createJingleGroupRemoteObjects();
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean saveGroupSelection(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SELECTION;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!p_LiveShow_ExportDescription.getSaveProject() && !p_LiveShow_ExportDescription.getExportProjectAll()) {
                return true;
            }
            int intGroupCount = LiveShowJingleGroupPanel.getSelectedGroupCount();
            if (intGroupCount <= 0) {
                return true;
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            o_ObjectOutput.writeInt(intGroupCount);
            for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                LiveShowJingleGroup o_Group = LiveShowJingleGroupPanel.getSelectedGroup(intGroup);
                if (o_Group == null) continue;
                o_ObjectOutput.writeUTF(o_Group.getID());
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean loadGroupSelection(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        if (!p_LiveShow_ImportDescription.getLoadNewProject()) {
            return true;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SELECTION;
        try {
            File o_File = new File(stringFileName);
            if (!o_File.exists()) {
                return false;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            LiveShowJingleGroupPanel.clearSelectedGroups();
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intGroupCount = o_ObjectInput.readInt();
            for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                String stringGroupID = o_ObjectInput.readUTF();
                LiveShowJingleGroup o_Group = LiveShowJingleGroup.getGroup(stringGroupID);
                if (o_Group == null) continue;
                LiveShowJingleGroupPanel.addSelectedGroup(o_Group);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean deleteJingleGroupSelectionFile(LiveShowInternalFrame_PlayJingles p_LiveShowInternalFrame_PlayJingles, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (p_LiveShowInternalFrame_PlayJingles == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SELECTION);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception e) {
                boolSuccess = false;
            }
        }
        return boolSuccess;
    }

    public void eventJingleInterfaceClosed(LiveShowJingle.JingleInterface p_JingleInterface) {
        if (p_JingleInterface == null) {
            return;
        }
        this.removeJingleInterface(p_JingleInterface);
    }

    @Override
    public void eventJingleAdded(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
    }

    @Override
    public void eventJingleRemoved(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
        if (p_JingleView == null) {
            return;
        }
        this.removeJingleInterface(p_JingleView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventJingleChanged(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
        LiveShowJingle.JingleInterface o_JingleInterface = null;
        Object object = m_SyncObjects;
        synchronized (object) {
            for (int intJingle = 0; intJingle < this.m_JingleInterfaces.size() && (o_JingleInterface = this.m_JingleInterfaces.get(intJingle)) != p_JingleView; ++intJingle) {
                o_JingleInterface = null;
            }
            if (o_JingleInterface == null) {
                return;
            }
            this.m_JingleInterfaces.remove(o_JingleInterface);
        }
        this.addJingleInterface_Sorted(o_JingleInterface);
    }

    @Override
    public void eventJinglePlayControlStatus(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, PlayControlPanel.PlayControlPanelStatus p_PlayControlPanelStatus) {
    }

    public void eventPlayStart(Play p_Play) {
        this.refreshPlayStatus();
    }

    public void eventPlayStop(Play p_Play) {
        this.refreshPlayStatus();
    }

    public void eventPlayPause(Play p_Play) {
        this.refreshPlayStatus();
    }

    public void eventPlayRewind(Play p_Play) {
    }

    public void eventPlayFastForward(Play p_Play) {
    }

    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        this.refreshPlayStatus();
    }

    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
        this.refreshPlayStatus();
    }

    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    public void eventPlayClosing(Play p_Play) {
    }

    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    public void eventPlayTimelineEnd(Play p_Play) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPlayStatus() {
        boolean boolChanged = false;
        boolean boolPause = false;
        if (this.m_Closing) {
            return;
        }
        boolean boolPlayStartEnabled = this.m_PlayStartEnabled;
        boolean boolPlayFadeInEnabled = this.m_PlayFadeInEnabled;
        boolean boolPlayFadeOutEnabled = this.m_PlayFadeOutEnabled;
        boolean boolPlayPauseEnabled = this.m_PlayPauseEnabled;
        boolean boolPlayStopEnabled = this.m_PlayStopEnabled;
        int intPlayJingleCount = this.m_PlayJingleRunning;
        boolean boolAllFadedIn = this.m_PlayAllFadedIn;
        boolean boolNoneFadedIn = this.m_PlayNoneFadedIn;
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_PlayStartEnabled = false;
            this.m_PlayFadeInEnabled = false;
            this.m_PlayFadeOutEnabled = false;
            this.m_PlayPauseEnabled = false;
            this.m_PlayStopEnabled = false;
            this.m_PlayJingleRunning = 0;
            this.m_PlayJingleWaiting = 0;
            if (this.m_JingleInterfaces.size() <= 0) {
                this.m_PlayAllFadedIn = false;
                this.m_PlayNoneFadedIn = true;
            } else {
                this.m_PlayAllFadedIn = true;
                this.m_PlayNoneFadedIn = true;
                for (int intJingle = 0; intJingle < this.m_JingleInterfaces.size(); ++intJingle) {
                    LiveShowJingle.JingleInterface o_JingleInterface = this.m_JingleInterfaces.get(intJingle);
                    Play o_Play = o_JingleInterface.getPlay();
                    int intPlayStatus = o_JingleInterface.getPlayStatus();
                    switch (intPlayStatus) {
                        case 3: {
                            this.m_PlayPauseEnabled = true;
                            this.m_PlayStopEnabled = true;
                            ++this.m_PlayJingleRunning;
                            break;
                        }
                        case 1: {
                            this.m_PlayStartEnabled = true;
                            this.m_PlayStopEnabled = true;
                            ++this.m_PlayJingleWaiting;
                            if (this.m_JinglesWaiting.contains(o_JingleInterface)) break;
                            this.m_JinglesWaiting.add(o_JingleInterface);
                            break;
                        }
                        case 0: {
                            this.m_PlayStartEnabled = true;
                            this.m_PlayFadeInEnabled = true;
                        }
                    }
                    if (o_Play == null) continue;
                    if (!o_Play.getWasFadedIn()) {
                        this.m_PlayAllFadedIn = false;
                    }
                    if (!o_Play.getWasFadedIn()) continue;
                    this.m_PlayNoneFadedIn = false;
                }
            }
            if (!this.m_IsPlayFadeInPause) {
                if (this.m_PlayJingleRunning <= 0) {
                    this.m_PlayStartEnabled = true;
                    this.m_PlayPauseEnabled = false;
                    this.m_PlayFadeInEnabled = this.m_PlayJingleWaiting <= 0;
                    this.m_PlayFadeOutEnabled = false;
                } else {
                    this.m_PlayStartEnabled = false;
                    this.m_PlayPauseEnabled = true;
                    this.m_PlayFadeInEnabled = false;
                    this.m_PlayFadeOutEnabled = !this.m_IsPlayFadeOut;
                }
            } else {
                this.m_PlayStartEnabled = false;
                this.m_PlayPauseEnabled = this.m_PlayJingleRunning > 0;
                if (this.m_PlayJingleWaiting > 0) {
                    if (this.m_PlayAllFadedIn) {
                        this.m_PlayFadeInEnabled = false;
                        this.m_PlayStartEnabled = true;
                        this.m_PlayFadeOutEnabled = true;
                    } else {
                        this.m_PlayFadeInEnabled = true;
                        this.m_PlayFadeOutEnabled = true;
                    }
                    if (this.m_PlayNoneFadedIn) {
                        this.m_PlayStartEnabled = true;
                    }
                } else {
                    this.m_PlayFadeInEnabled = false;
                    this.m_PlayFadeOutEnabled = !this.m_IsPlayFadeOut;
                }
            }
            if (this.m_StopPlayAfterAllFadedIn && this.m_PlayAllFadedIn && this.m_PlayJingleRunning > 0 && boolAllFadedIn != this.m_PlayAllFadedIn) {
                boolPause = true;
                this.m_StopPlayAfterAllFadedIn = false;
            }
            if (this.m_PlayJingleWaiting <= 0) {
                this.m_JinglesWaiting.clear();
                if (this.m_PlayJingleRunning <= 0) {
                    this.m_IsPlayFadeInPause = false;
                    this.m_StopPlayAfterAllFadedIn = false;
                    this.m_IsPlayFadeOut = false;
                    this.m_PlayStartEnabled = true;
                    this.m_PlayFadeInEnabled = true;
                    this.m_PlayFadeOutEnabled = false;
                    this.m_PlayPauseEnabled = false;
                    this.m_PlayStopEnabled = false;
                }
            } else {
                this.m_PlayFadeOutEnabled = true;
            }
        }
        if (boolPause) {
            this.playPause();
        }
        if (boolPlayStartEnabled != this.m_PlayStartEnabled || boolPlayFadeInEnabled != this.m_PlayFadeInEnabled || boolPlayFadeOutEnabled != this.m_PlayFadeOutEnabled || boolPlayPauseEnabled != this.m_PlayPauseEnabled || boolPlayStopEnabled != this.m_PlayStopEnabled || intPlayJingleCount != this.m_PlayJingleRunning || boolAllFadedIn != this.m_PlayAllFadedIn) {
            boolChanged = true;
        }
        if (boolChanged) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_PLAYSTATUS, null, (Object)this);
            LiveShowJingleGroup.notifyJingleGroupPlayStatus(this);
        }
    }

    public boolean getPlayStartEnabled() {
        return this.m_PlayStartEnabled;
    }

    public boolean getPlayFadeInEnabled() {
        return this.m_PlayFadeInEnabled;
    }

    public boolean getPlayFadeOutEnabled() {
        return this.m_PlayFadeOutEnabled;
    }

    public boolean getPlayPauseEnabled() {
        return this.m_PlayPauseEnabled;
    }

    public boolean getPlayStopEnabled() {
        return this.m_PlayStopEnabled;
    }

    public int getPlayJingleCount() {
        return this.m_PlayJingleRunning + this.m_PlayJingleWaiting;
    }

    public boolean getPlayJingleRunning() {
        return this.m_PlayJingleRunning > 0;
    }

    public boolean getPlayJingleWaiting() {
        return this.m_PlayJingleWaiting > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJingleGroupListener(JingleGroupListener p_JingleGroupListener) {
        if (p_JingleGroupListener == null) {
            return;
        }
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            if (s_JingleGroupListeners.contains(p_JingleGroupListener)) {
                return;
            }
            s_JingleGroupListeners.add(p_JingleGroupListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJingleGroupListener(JingleGroupListener p_JingleGroupListener) {
        if (p_JingleGroupListener == null) {
            return;
        }
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            if (!s_JingleGroupListeners.contains(p_JingleGroupListener)) {
                return;
            }
            s_JingleGroupListeners.remove(p_JingleGroupListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJingleGroupListeners() {
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            s_JingleGroupListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyJingleGroupAdded(LiveShowJingleGroup p_JingleGroup) {
        ArrayList<JingleGroupListener> o_JingleGroupListeners;
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            o_JingleGroupListeners = new ArrayList<JingleGroupListener>(s_JingleGroupListeners.size());
            o_JingleGroupListeners.addAll(s_JingleGroupListeners);
        }
        for (int intListener = 0; intListener < o_JingleGroupListeners.size(); ++intListener) {
            JingleGroupListener o_JingleGroupListener = (JingleGroupListener)o_JingleGroupListeners.get(intListener);
            o_JingleGroupListener.eventJingleGroupAdded(p_JingleGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyJingleGroupRemoved(LiveShowJingleGroup p_JingleGroup) {
        ArrayList<JingleGroupListener> o_JingleGroupListeners;
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            o_JingleGroupListeners = new ArrayList<JingleGroupListener>(s_JingleGroupListeners.size());
            o_JingleGroupListeners.addAll(s_JingleGroupListeners);
        }
        for (int intListener = 0; intListener < o_JingleGroupListeners.size(); ++intListener) {
            JingleGroupListener o_JingleGroupListener = (JingleGroupListener)o_JingleGroupListeners.get(intListener);
            o_JingleGroupListener.eventJingleGroupRemoved(p_JingleGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyJingleGroupChanged(LiveShowJingleGroup p_JingleGroup) {
        ArrayList<JingleGroupListener> o_JingleGroupListeners;
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            o_JingleGroupListeners = new ArrayList<JingleGroupListener>(s_JingleGroupListeners.size());
            o_JingleGroupListeners.addAll(s_JingleGroupListeners);
        }
        for (int intListener = 0; intListener < o_JingleGroupListeners.size(); ++intListener) {
            JingleGroupListener o_JingleGroupListener = (JingleGroupListener)o_JingleGroupListeners.get(intListener);
            o_JingleGroupListener.eventJingleGroupChanged(p_JingleGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyJingleGroupPlayStatus(LiveShowJingleGroup p_JingleGroup) {
        ArrayList<JingleGroupListener> o_JingleGroupListeners;
        Object object = s_SyncJingleGroupListeners;
        synchronized (object) {
            o_JingleGroupListeners = new ArrayList<JingleGroupListener>(s_JingleGroupListeners.size());
            o_JingleGroupListeners.addAll(s_JingleGroupListeners);
        }
        for (int intListener = 0; intListener < o_JingleGroupListeners.size(); ++intListener) {
            JingleGroupListener o_JingleGroupListener = (JingleGroupListener)o_JingleGroupListeners.get(intListener);
            o_JingleGroupListener.eventJingleGroupPlayStatus(p_JingleGroup);
        }
    }

    public void createJingleGroupRemoteObjects() {
        String stringID = this.getID();
        SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type((String)stringID);
        if (o_SPIT_Type_Interface == null) {
            String stringTypeGroupName = DEFAULT_GROUPNAME;
            o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringID, (String)stringTypeGroupName, (String)this.getName(), (boolean)false);
            SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
            SPIT_Object_Interface o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "pl", LiveShowInternalFrame_PlayJingles.COMMAND_PLAY_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
            o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "pa", LiveShowInternalFrame_PlayJingles.COMMAND_PAUSE_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
            o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "st", LiveShowInternalFrame_PlayJingles.COMMAND_STOP_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
            o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "ps", LiveShowInternalFrame_PlayJingles.COMMAND_PLAYSTOP_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
            o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "pf", LiveShowInternalFrame_PlayJingles.COMMAND_PLAYFADEOUT_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
            o_SPIT_Object_Interface = this.createJingleGroupRemoteObjectCommand(o_SPIT_Type_Interface, "ff", LiveShowInternalFrame_PlayJingles.COMMAND_FADEINOUT_NAME);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        }
        this.createRemoteMouseActions();
    }

    public SPIT_Object_Interface createJingleGroupRemoteObjectCommand(SPIT_Type_Interface p_SPIT_Type_Interface, String p_IDSuffix, String p_CommandName) {
        if (p_SPIT_Type_Interface == null) {
            return null;
        }
        String stringID = this.getID() + p_IDSuffix;
        SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)p_SPIT_Type_Interface, (String)stringID, (String)p_CommandName, (byte)0);
        if (o_SPIT_Object_Interface == null) {
            return null;
        }
        o_SPIT_Object_Interface.setFrameStart(0L);
        o_SPIT_Object_Interface.setFrameLength(0L);
        o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        return o_SPIT_Object_Interface;
    }

    public void removeJingleGroupRemoteObjects() {
        SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)(this.getID() + "ps"));
        SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)(this.getID() + "st"));
        SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)(this.getID() + "pa"));
        SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)(this.getID() + "pl"));
        SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)(this.getID() + "ff"));
        SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
        SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type((String)this.getID());
        SPITRemote.removeRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
        this.removeRemoteMouseActions();
    }

    public void createRemoteMouseActions() {
        ImageIcon o_ImageIcon = null;
        Object o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                LiveShowJingleGroup.this.playStartStop();
            }
        };
        o_ImageIcon = s_Icon;
        PlayRemoteActions.RemoteAction o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"JingleGroup", (String)"actionPlayStop", (String)this.getID(), (String)this.getName(), (long)0L);
        o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                LiveShowJingleGroup.this.playStartFadeOut();
            }
        };
        o_ImageIcon = s_Icon;
        o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"JingleGroup", (String)"actionPlayFadeOut", (String)this.getID(), (String)this.getName(), (long)0L);
        o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

            public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                LiveShowJingleGroup.this.playFadeInOut();
            }
        };
        o_RemoteMouseAction = PlayRemoteActions.createRemoteAction((PlayRemoteActions.RemoteActionListener)o_RemoteActionListener, (ImageIcon)o_ImageIcon, (String)"JingleGroup", (String)"actionFadeInOut", (String)this.getID(), (String)this.getName(), (long)0L);
    }

    public void changeRemoteMouseActions() {
        PlayRemoteActions.RemoteAction o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionPlayStop");
        if (o_RemoteMouseAction != null) {
            o_RemoteMouseAction.setSourceName(this.getName());
        }
        if ((o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionFadeInOut")) != null) {
            o_RemoteMouseAction.setSourceName(this.getName());
        }
        if ((o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionPlayFadeOut")) != null) {
            o_RemoteMouseAction.setSourceName(this.getName());
        }
    }

    public void removeRemoteMouseActions() {
        PlayRemoteActions.RemoteAction o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionPlayStop");
        if (o_RemoteMouseAction != null) {
            o_RemoteMouseAction.close();
        }
        if ((o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionFadeInOut")) != null) {
            o_RemoteMouseAction.close();
        }
        if ((o_RemoteMouseAction = PlayRemoteActions.getRemoteAction((String)this.getID(), (String)"actionPlayFadeOut")) != null) {
            o_RemoteMouseAction.close();
        }
    }

    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        String stringObjectID = p_SPIT_Object_Interface.getID();
        String stringCommandSuffix = stringObjectID.substring(stringObjectID.length() - 2, stringObjectID.length());
        stringObjectID = stringObjectID.substring(0, stringObjectID.length() - 2);
        switch (stringCommandSuffix) {
            case "pl": {
                this.playStart();
                break;
            }
            case "ff": {
                this.playFadeInOut();
                break;
            }
            case "pa": {
                this.playPause();
                break;
            }
            case "st": {
                this.playStop();
                break;
            }
            case "ps": {
                this.playStartStop();
                break;
            }
            case "pf": {
                this.playStartFadeOut();
            }
        }
    }

    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public static class JIngleGroup_PlayRenderer
    extends DefaultTableCellRenderer {
        public static Dimension BUTTON_SIZE = new Dimension(16, 16);

        public JIngleGroup_PlayRenderer() {
            this.initComponents();
        }

        private void initComponents() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color o_Background = null;
            Color o_Foreground = null;
            if (isSelected) {
                if (hasFocus) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.setIcon(null);
            this.setText("");
            this.setEnabled(false);
            if (!(value instanceof LiveShowJingleGroup)) {
                return this;
            }
            LiveShowJingleGroup o_JingleGroup = (LiveShowJingleGroup)value;
            int intColumn = table.convertColumnIndexToModel(column);
            switch (intColumn) {
                case 0: {
                    if (o_JingleGroup.getPlayStartEnabled()) {
                        if (!o_JingleGroup.getPlayStopEnabled()) {
                            this.setIcon(PlayControlPanel.ICON_PLAYSTART_24);
                        } else {
                            this.setIcon(PlayControlPanel.ICON_PLAYSTARTFADEOUT_24);
                        }
                        this.setEnabled(true);
                        break;
                    }
                    if (!o_JingleGroup.getPlayPauseEnabled()) break;
                    this.setIcon(PlayControlPanel.ICON_PLAYPAUSE_24);
                    this.setEnabled(true);
                    break;
                }
                case 1: {
                    if (o_JingleGroup.getPlayFadeInEnabled()) {
                        this.setIcon(PlayControlPanel.ICON_PLAYFADEINPAUSE_24);
                        this.setEnabled(true);
                        break;
                    }
                    if (!o_JingleGroup.getPlayFadeOutEnabled()) break;
                    this.setIcon(PlayControlPanel.ICON_PLAYFADEOUT_24);
                    this.setEnabled(true);
                    break;
                }
                case 2: {
                    this.setIcon(PlayControlPanel.ICON_PLAYSTOP_24);
                    this.setEnabled(o_JingleGroup.getPlayStopEnabled());
                    break;
                }
            }
            return this;
        }
    }

    public static class GroupTableCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        protected Border m_NoFocusBorder = new EmptyBorder(2, 2, 2, 2);
        protected Border m_SelectedBorder = new LineBorder(UIManager.getColor("Table.selectionBackground"), 2);
        public static Color PLAYING_ALL_FOREGROUND = new Color(255, 255, 255);
        public static Color PLAYING_ALL_BACKROUND = new Color(255, 128, 0);
        public static Color PLAYING_SOME_FOREGROUND = new Color(0, 0, 0);
        public static Color PLAYING_SOME_BACKROUND = new Color(255, 255, 100);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent o_JComponentRenderer = null;
            Component o_ComponentRenderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (o_ComponentRenderer instanceof JComponent) {
                o_JComponentRenderer = (JComponent)o_ComponentRenderer;
            }
            if (o_JComponentRenderer != null) {
                if (isSelected) {
                    o_JComponentRenderer.setBorder(this.m_SelectedBorder);
                } else {
                    o_JComponentRenderer.setBorder(this.m_NoFocusBorder);
                }
            }
            int intRowModel = table.convertRowIndexToModel(row);
            LiveShowJingleGroup o_Group = (LiveShowJingleGroup)LiveShowJingleGroup.getGroupTableModel().getElementAt(intRowModel);
            if (o_Group != null && o_Group.getPlayStopEnabled()) {
                if (o_Group.getPlayJingleCount() >= o_Group.getJingleInterfaceCount()) {
                    o_ComponentRenderer.setForeground(PLAYING_ALL_FOREGROUND);
                    o_ComponentRenderer.setBackground(PLAYING_ALL_BACKROUND);
                } else {
                    o_ComponentRenderer.setForeground(PLAYING_SOME_FOREGROUND);
                    o_ComponentRenderer.setBackground(PLAYING_SOME_BACKROUND);
                }
            }
            return o_ComponentRenderer;
        }
    }

    public static class JingleGroup_RowFilter
    extends RowFilter<LiveShowJingleGroup, Integer> {
        private JingleGroupTableModel m_JingleGroupTableModel;
        private String m_FilterString;

        public JingleGroup_RowFilter(JingleGroupTableModel p_JingleGroupTableModel) {
            this.initMembers();
            this.m_JingleGroupTableModel = p_JingleGroupTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_JingleGroupTableModel != null) {
                this.m_JingleGroupTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_JingleGroupTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            LiveShowJingleGroup o_LiveShowJingleGroup = this.m_JingleGroupTableModel.getGroup(intRow);
            if (o_LiveShowJingleGroup == null) {
                return false;
            }
            if (o_LiveShowJingleGroup.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_LiveShowJingleGroup.getRemark().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class JingleGroupTableModel
    extends TableAndListModel<LiveShowJingleGroup>
    implements PropertyChangeListener,
    JingleGroupListener,
    TableAndListModel.TableBehaviorListener {
        public static final int COLUMNCOUNT = 5;
        public static final int COLUMNINDEX_PLAYSTARTPAUSE = 0;
        public static final int COLUMNINDEX_PLAYFADEINOUT = 1;
        public static final int COLUMNINDEX_PLAYSTOP = 2;
        public static final int COLUMNINDEX_GROUPNAME = 3;
        public static final int COLUMNINDEX_GROUPREMARK = 4;
        @LiveLanguageString
        public static String COLUMN_GROUPNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_GROUPREMARK = "Description";
        private TableRowSorter m_TableRowSorter;
        private JingleGroup_RowFilter m_JingleGroup_RowFilter;
        private final Object m_SyncObject = new Object();
        private int m_ExcludedMousePressedRow = -1;
        private int m_ExcludedMousePressedColumn = -1;

        public JingleGroupTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
            LiveShowJingleGroup.addJingleGroupListener(this);
        }

        private void initMembers() {
            this.m_JingleGroup_RowFilter = new JingleGroup_RowFilter(this);
            this.m_TableRowSorter = new TableRowSorter<JingleGroupTableModel>(this);
            this.m_TableRowSorter.setComparator(3, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(4, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
        }

        public void finishJTable(JTable p_JTable) {
            GroupTableCellRenderer o_GroupTableCellRenderer;
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            super.finishJTable(p_JTable, this.m_TableRowSorter, (RowFilter)this.m_JingleGroup_RowFilter);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            if (o_TableColumnModel == null) {
                return;
            }
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(3);
            if (o_TableColumn != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_GroupTableCellRenderer = new GroupTableCellRenderer();
                o_GroupTableCellRenderer.setIcon(s_Icon);
                o_GroupTableCellRenderer.setHorizontalAlignment(10);
                o_GroupTableCellRenderer.setToolTipText_Automatic(2);
                o_GroupTableCellRenderer.setToolTipTextAt(false, true);
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_GroupTableCellRenderer));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_GroupTableCellRenderer = new GroupTableCellRenderer();
                o_GroupTableCellRenderer.setHorizontalAlignment(10);
                o_GroupTableCellRenderer.setToolTipText_Automatic(2);
                o_GroupTableCellRenderer.setToolTipTextAt(false, true);
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_GroupTableCellRenderer));
            }
            TableAndListModel.TableBehavior o_TableBehavior = new TableAndListModel.TableBehavior(p_JTable, (TableAndListModel.TableBehaviorListener)this);
            JIngleGroup_PlayRenderer o_JIngleGroup_PlayRenderer = new JIngleGroup_PlayRenderer();
            o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setCellRenderer(o_JIngleGroup_PlayRenderer);
                o_TableColumn.setMinWidth(26);
                o_TableColumn.setMaxWidth(26);
                o_TableColumn.setPreferredWidth(26);
                o_TableColumn.setResizable(false);
            }
            o_TableBehavior.addMouseExcludedColumn(0, false);
            o_TableColumn = o_TableColumnModel.getColumn(1);
            if (o_TableColumn != null) {
                o_TableColumn.setCellRenderer(o_JIngleGroup_PlayRenderer);
                o_TableColumn.setMinWidth(26);
                o_TableColumn.setMaxWidth(26);
                o_TableColumn.setPreferredWidth(26);
                o_TableColumn.setResizable(false);
            }
            o_TableBehavior.addMouseExcludedColumn(1, false);
            o_TableColumn = o_TableColumnModel.getColumn(2);
            if (o_TableColumn != null) {
                o_TableColumn.setCellRenderer(o_JIngleGroup_PlayRenderer);
                o_TableColumn.setMinWidth(26);
                o_TableColumn.setMaxWidth(26);
                o_TableColumn.setPreferredWidth(26);
                o_TableColumn.setResizable(false);
            }
            o_TableBehavior.addMouseExcludedColumn(2, false);
        }

        public void excludedMouseEvent(MouseEvent p_MouseEvent, JTable p_JTable, int p_RowModel, int p_ColumnModel, Object p_Value) {
            LiveShowJingleGroup o_Group = (LiveShowJingleGroup)this.get(p_RowModel);
            if (o_Group == null) {
                return;
            }
            if (p_MouseEvent.getID() == 501 && p_MouseEvent.getButton() == 1) {
                this.m_ExcludedMousePressedRow = p_RowModel;
                this.m_ExcludedMousePressedColumn = p_ColumnModel;
                return;
            }
            if (p_MouseEvent.getID() == 502 && p_MouseEvent.getButton() == 1) {
                if (this.m_ExcludedMousePressedRow != p_RowModel || this.m_ExcludedMousePressedColumn != p_ColumnModel) {
                    return;
                }
                switch (p_ColumnModel) {
                    case 0: {
                        if (o_Group.getPlayStartEnabled()) {
                            o_Group.playStart();
                            break;
                        }
                        if (!o_Group.getPlayPauseEnabled()) break;
                        o_Group.playPause();
                        break;
                    }
                    case 1: {
                        if (o_Group.getPlayFadeInEnabled()) {
                            o_Group.playFadeInPause();
                            break;
                        }
                        if (!o_Group.getPlayFadeOutEnabled()) break;
                        o_Group.playFadeOut();
                        break;
                    }
                    case 2: {
                        if (!o_Group.getPlayStopEnabled()) break;
                        o_Group.playStop();
                    }
                }
            }
        }

        public void filter(String p_FilterString) {
            if (this.m_JingleGroup_RowFilter != null) {
                this.m_JingleGroup_RowFilter.setFilterString(p_FilterString);
            }
        }

        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            LiveShowJingleGroup o_Group = this.getGroup(p_ID);
            return o_Group != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowJingleGroup getGroup(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intGroup = 0; intGroup < this.size(); ++intGroup) {
                    LiveShowJingleGroup o_Group = (LiveShowJingleGroup)this.get(intGroup);
                    if (o_Group == null || !p_ID.equals(o_Group.getID())) continue;
                    return o_Group;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addGroup(LiveShowJingleGroup p_Group) {
            boolean boolAdded;
            if (p_Group == null) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                boolAdded = this.add(p_Group);
                if (boolAdded) {
                    p_Group.addPropertyChangeListener(LiveShowJingleGroupPanel.s_SelfReference);
                }
            }
            return boolAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeGroup(LiveShowJingleGroup p_Group) {
            boolean boolRemoved;
            if (p_Group == null) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                boolRemoved = this.remove(p_Group);
                if (boolRemoved) {
                    p_Group.removePropertyChangeListener(LiveShowJingleGroupPanel.s_SelfReference);
                }
            }
            return boolRemoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedGroup(JTable p_JTable, LiveShowJingleGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_Group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedGroup(JTable p_JTable, LiveShowJingleGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_Group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowJingleGroup getGroup(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (LiveShowJingleGroup)this.get(p_Index);
            }
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return COLUMN_GROUPNAME;
                }
                case 4: {
                    return COLUMN_GROUPREMARK;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(LiveShowJingleGroup p_Group, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return stringValue;
                }
                switch (columnIndex) {
                    case 3: {
                        stringValue = p_Group.getName();
                        break;
                    }
                    case 4: {
                        stringValue = p_Group.getRemark();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        return p_Group;
                    }
                }
                return stringValue;
            }
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(LiveShowJingleGroup p_Group, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return;
                }
            }
            switch (col) {
                case 3: {
                    String stringValue = (String)value;
                    p_Group.setName(stringValue);
                    break;
                }
                case 4: {
                    String stringValue = (String)value;
                    p_Group.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }

        @Override
        public void eventJingleGroupAdded(LiveShowJingleGroup p_JingleGroup) {
        }

        @Override
        public void eventJingleGroupRemoved(LiveShowJingleGroup p_JingleGroup) {
        }

        @Override
        public void eventJingleGroupChanged(LiveShowJingleGroup p_JingleGroup) {
            this.changedElement(p_JingleGroup);
        }

        @Override
        public void eventJingleGroupPlayStatus(LiveShowJingleGroup p_JingleGroup) {
            this.changedElement(p_JingleGroup);
        }
    }

    public static interface JingleGroupListener {
        public void eventJingleGroupAdded(LiveShowJingleGroup var1);

        public void eventJingleGroupRemoved(LiveShowJingleGroup var1);

        public void eventJingleGroupChanged(LiveShowJingleGroup var1);

        public void eventJingleGroupPlayStatus(LiveShowJingleGroup var1);
    }
}

