/*
 * Decompiled with CFR 0.152.
 */
package LiveShowProjectPackage;

import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.DMXFadeSettingsPanel;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowObjectSettingsPanel;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowVIP;
import MainPackage.LiveShowProjectDesktop;
import MediaGraphicsPackage.MediaObjectSettings;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaSceneBridge;
import SPITServerPackage.LiveShowSPITObject;
import SoundPackage.SoundMixers;
import SoundPackage.SoundSettingsPanel;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundObjectDescription;
import SoundVirtualPackage.LiveShowSoundSceneBridge;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class LiveShowInternalFrame_ObjectSettings
extends JInternalFrame
implements LiveShowObjectListener,
PropertyChangeListener {
    @LiveLanguageString
    public static String TITLE = "Object Settings ";
    @LiveLanguageString
    public static String TAB_0_TITLE = "Object Settings";
    @LiveLanguageString
    public static String TAB_SOUND_TITLE = "Sound Lines";
    @LiveLanguageString
    public static String TAB_DMX_TITLE = "Fade Settings";
    @LiveLanguageString
    public static String TAB_MEDIA_TITLE = "Fade Settings";
    @LiveLanguageString
    public static String DMXOBJECT = "DMX";
    @LiveLanguageString
    public static String DMXSCENEBRIDGE = "DMX Scenebridge";
    @LiveLanguageString
    public static String SOUNDOBJECT = "Sound";
    @LiveLanguageString
    public static String SOUNDSCENEBRIDGE = "Sound Scenebridge";
    @LiveLanguageString
    public static String MEDIAOBJECT = "Media";
    @LiveLanguageString
    public static String MEDIASCENEBRIDGE = "Media Scenebridge";
    @LiveLanguageString
    public static String SPITOBJECT = "Trigger";
    private LiveShowObjectInterface m_LiveShowObjectInterface;
    private SoundSettingsPanel m_SoundSettingsPanel;
    private DMXFadeSettingsPanel m_DMXFadeSettingsPanel;
    private MediaObjectSettings m_MediaObjectSettings;
    private JComponent m_LastTab1Component;
    private boolean m_ObjectSettingParamChanged;
    private boolean m_SoundSettingParamChanged;
    private boolean m_FadeSettingParamChanged;
    private boolean m_MediaServerParamChanged;
    public static SoundMixers.Sound_Lines s_SoundSettings_ClipBoard = null;
    public static LiveShowMediaObjectDescription s_MediaObjectDescription_ClipBoard = null;
    public static DMXFadeDescription s_DMXFadeDescription_ClipBoard = null;
    private ButtonGroup buttonGroup_Unit;
    private JButton jButton_Cancel;
    private JButton jButton_CopyDMXSettings;
    private JButton jButton_CopyMediaSettings;
    private JButton jButton_CopySoundSettings;
    private JButton jButton_PasteDMXSettings;
    private JButton jButton_PasteMediaSettings;
    private JButton jButton_PasteSoundSettings;
    private JButton jButton_Save;
    private JButton jButton_SplitMainBridge;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_Content;
    private JRadioButton jRadioButton_UnitFrames;
    private JRadioButton jRadioButton_UnitTime;
    private JTabbedPane jTabbedPane1;
    private LiveShowObjectSettingsPanel liveShowObjectSettingsPanel1;

    public LiveShowInternalFrame_ObjectSettings() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.liveShowObjectSettingsPanel1.addPropertyChangeListener("paramsChanged", (PropertyChangeListener)this);
        this.liveShowObjectSettingsPanel1.addPropertyChangeListener("paramsSourceChanged", (PropertyChangeListener)this);
        this.m_SoundSettingsPanel.addPropertyChangeListener("paramsChanged", (PropertyChangeListener)this);
        this.m_DMXFadeSettingsPanel.addPropertyChangeListener("paramsChanged", (PropertyChangeListener)this);
        this.m_MediaObjectSettings.addPropertyChangeListener("paramsChanged", (PropertyChangeListener)this);
        LiveLanguage.addLanguageListener((Object)this, null);
        this.jTabbedPane1.setTitleAt(0, TAB_0_TITLE);
        this.jRadioButton_UnitFrames.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_UnitTime.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SplitMainBridge.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CopySoundSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_PasteSoundSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CopyDMXSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_PasteDMXSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CopyMediaSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_PasteMediaSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    private void initMembers() {
        this.m_LiveShowObjectInterface = null;
        this.m_ObjectSettingParamChanged = false;
        this.m_SoundSettingParamChanged = false;
        this.m_FadeSettingParamChanged = false;
        this.m_MediaServerParamChanged = false;
        this.m_LastTab1Component = null;
    }

    private void initComponents() {
        this.buttonGroup_Unit = new ButtonGroup();
        this.jPanel_Content = new JPanel();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jTabbedPane1 = new JTabbedPane();
        this.liveShowObjectSettingsPanel1 = new LiveShowObjectSettingsPanel();
        this.jRadioButton_UnitTime = new JRadioButton();
        this.jRadioButton_UnitFrames = new JRadioButton();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jButton_SplitMainBridge = new JButton();
        this.jButton_CopyMediaSettings = new JButton();
        this.jButton_PasteMediaSettings = new JButton();
        this.jButton_CopyDMXSettings = new JButton();
        this.jButton_PasteDMXSettings = new JButton();
        this.jButton_CopySoundSettings = new JButton();
        this.jButton_PasteSoundSettings = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setTitle("Object Settings");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Object_Settings.png")));
        this.setMinimumSize(new Dimension(700, 550));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(800, 680));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setPreferredSize(new Dimension(700, 446));
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        this.jPanel_Content.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jTabbedPane1.setMinimumSize(new Dimension(500, 400));
        this.jTabbedPane1.setPreferredSize(new Dimension(600, 400));
        this.liveShowObjectSettingsPanel1.setForeground(new Color(255, 255, 255));
        this.liveShowObjectSettingsPanel1.setMinimumSize(new Dimension(420, 240));
        this.jTabbedPane1.addTab("Settings", (Component)this.liveShowObjectSettingsPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Content.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.buttonGroup_Unit.add(this.jRadioButton_UnitTime);
        this.jRadioButton_UnitTime.setSelected(true);
        this.jRadioButton_UnitTime.setText("Time");
        this.jRadioButton_UnitTime.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jRadioButton_UnitTime.setOpaque(false);
        this.jRadioButton_UnitTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jRadioButton_UnitTimeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jRadioButton_UnitTime, gridBagConstraints);
        this.buttonGroup_Unit.add(this.jRadioButton_UnitFrames);
        this.jRadioButton_UnitFrames.setText("Frames");
        this.jRadioButton_UnitFrames.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jRadioButton_UnitFrames.setOpaque(false);
        this.jRadioButton_UnitFrames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jRadioButton_UnitFramesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jRadioButton_UnitFrames, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setEnabled(false);
        this.jButton_Save.setIconTextGap(0);
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setIconTextGap(0);
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_SplitMainBridge.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Scenebridge_MainSplit.png")));
        this.jButton_SplitMainBridge.setToolTipText("Split MainBridge to normal SceneBridges");
        this.jButton_SplitMainBridge.setContentAreaFilled(false);
        this.jButton_SplitMainBridge.setIconTextGap(0);
        this.jButton_SplitMainBridge.setMaximumSize(new Dimension(64, 32));
        this.jButton_SplitMainBridge.setMinimumSize(new Dimension(64, 32));
        this.jButton_SplitMainBridge.setPreferredSize(new Dimension(64, 32));
        this.jButton_SplitMainBridge.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_SplitMainBridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_SplitMainBridgeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 40, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_SplitMainBridge, gridBagConstraints);
        this.jButton_CopyMediaSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopyMedia.png")));
        this.jButton_CopyMediaSettings.setContentAreaFilled(false);
        this.jButton_CopyMediaSettings.setIconTextGap(0);
        this.jButton_CopyMediaSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_CopyMediaSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_CopyMediaSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_CopyMediaSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_CopyMediaSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_CopyMediaSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 10);
        this.jPanel_Content.add((Component)this.jButton_CopyMediaSettings, gridBagConstraints);
        this.jButton_PasteMediaSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopyPasteMedia.png")));
        this.jButton_PasteMediaSettings.setContentAreaFilled(false);
        this.jButton_PasteMediaSettings.setIconTextGap(0);
        this.jButton_PasteMediaSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_PasteMediaSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_PasteMediaSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_PasteMediaSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_PasteMediaSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_PasteMediaSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_PasteMediaSettings, gridBagConstraints);
        this.jButton_CopyDMXSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopyDMX.png")));
        this.jButton_CopyDMXSettings.setContentAreaFilled(false);
        this.jButton_CopyDMXSettings.setIconTextGap(0);
        this.jButton_CopyDMXSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_CopyDMXSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_CopyDMXSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_CopyDMXSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_CopyDMXSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_CopyDMXSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 10);
        this.jPanel_Content.add((Component)this.jButton_CopyDMXSettings, gridBagConstraints);
        this.jButton_PasteDMXSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopyPasteDMX.png")));
        this.jButton_PasteDMXSettings.setContentAreaFilled(false);
        this.jButton_PasteDMXSettings.setIconTextGap(0);
        this.jButton_PasteDMXSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_PasteDMXSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_PasteDMXSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_PasteDMXSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_PasteDMXSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_PasteDMXSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_PasteDMXSettings, gridBagConstraints);
        this.jButton_CopySoundSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopySound.png")));
        this.jButton_CopySoundSettings.setContentAreaFilled(false);
        this.jButton_CopySoundSettings.setIconTextGap(0);
        this.jButton_CopySoundSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_CopySoundSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_CopySoundSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_CopySoundSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_CopySoundSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_CopySoundSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 10);
        this.jPanel_Content.add((Component)this.jButton_CopySoundSettings, gridBagConstraints);
        this.jButton_PasteSoundSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_CopyPasteSound.png")));
        this.jButton_PasteSoundSettings.setContentAreaFilled(false);
        this.jButton_PasteSoundSettings.setIconTextGap(0);
        this.jButton_PasteSoundSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_PasteSoundSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_PasteSoundSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_PasteSoundSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_PasteSoundSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_ObjectSettings.this.jButton_PasteSoundSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_PasteSoundSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.m_SoundSettingsPanel = new SoundSettingsPanel();
        this.m_DMXFadeSettingsPanel = new DMXFadeSettingsPanel();
        this.m_DMXFadeSettingsPanel.setDividerLocation(0.5);
        this.m_MediaObjectSettings = new MediaObjectSettings();
        this.jLabel_ResizeFrame1.setContainer((Container)this);
        this.jButton_Cancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SplitMainBridge.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CopyMediaSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_PasteMediaSettings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_UnitFrames.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_UnitTime.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.cancel();
        this.liveShowObjectSettingsPanel1.setLiveShowObject(null, null);
        this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
        this.m_DMXFadeSettingsPanel.setLiveShowObject(null, null);
        this.m_MediaObjectSettings.setLiveShowMediaObject(null);
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        this.save();
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.cancel();
        this.setVisible(false);
    }

    private void jRadioButton_UnitFramesActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_UnitFrames.isSelected()) {
            this.setSelectedUnit(1);
        }
    }

    private void jRadioButton_UnitTimeActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_UnitTime.isSelected()) {
            this.setSelectedUnit(0);
        }
    }

    private void jButton_SplitMainBridgeActionPerformed(ActionEvent evt) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        if (this.m_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = null;
        if (this.m_LiveShowObjectInterface instanceof LiveShowSceneBridge && (o_LiveShowSceneBridge = (LiveShowSceneBridge)this.m_LiveShowObjectInterface).getIsMainBridge()) {
            o_LiveShowSceneBridgeMain = o_LiveShowSceneBridge.getLiveShowSceneBridgeMain();
        }
        if (o_LiveShowSceneBridgeMain == null) {
            return;
        }
        LiveShowProjectDesktop.getLiveShowInternalFrame_Timeline().splitMainBridge(o_LiveShowSceneBridgeMain);
        this.setVisible(false);
    }

    private void jButton_CopyMediaSettingsActionPerformed(ActionEvent evt) {
        if (this.m_MediaObjectSettings == null) {
            return;
        }
        if (this.m_LiveShowObjectInterface instanceof LiveShowMediaObject) {
            LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = this.m_MediaObjectSettings.getMediaObjectDescription_Panel();
            if (o_LiveShowMediaObjectDescription == null) {
                return;
            }
            s_MediaObjectDescription_ClipBoard = (LiveShowMediaObjectDescription)o_LiveShowMediaObjectDescription.clone((LiveShowObjectDescription)s_MediaObjectDescription_ClipBoard);
        }
        this.refreshButtons();
    }

    private void jButton_PasteMediaSettingsActionPerformed(ActionEvent evt) {
        if (s_MediaObjectDescription_ClipBoard == null) {
            return;
        }
        if (this.m_MediaObjectSettings == null) {
            return;
        }
        this.m_MediaObjectSettings.pasteMediaObjectParams(s_MediaObjectDescription_ClipBoard);
    }

    private void jButton_CopyDMXSettingsActionPerformed(ActionEvent evt) {
        if (!(this.m_LiveShowObjectInterface instanceof LiveShowDMXObject)) {
            return;
        }
        if (this.m_DMXFadeSettingsPanel == null) {
            return;
        }
        DMXFadeDescription o_DMXFadeDescription = this.m_DMXFadeSettingsPanel.getDMXFadeDescriptionNew();
        s_DMXFadeDescription_ClipBoard = o_DMXFadeDescription.copyTo(s_DMXFadeDescription_ClipBoard);
        this.refreshButtons();
    }

    private void jButton_PasteDMXSettingsActionPerformed(ActionEvent evt) {
        if (!(this.m_LiveShowObjectInterface instanceof LiveShowDMXObject)) {
            return;
        }
        if (s_DMXFadeDescription_ClipBoard == null) {
            return;
        }
        if (this.m_DMXFadeSettingsPanel == null) {
            return;
        }
        if (this.m_DMXFadeSettingsPanel.getDMXFadeDescriptionNew().isEqual(s_DMXFadeDescription_ClipBoard)) {
            return;
        }
        s_DMXFadeDescription_ClipBoard.copyTo(this.m_DMXFadeSettingsPanel.getDMXFadeDescriptionNew());
        this.m_DMXFadeSettingsPanel.refreshAfterCopy();
    }

    private void jButton_CopySoundSettingsActionPerformed(ActionEvent evt) {
        if (this.m_SoundSettingsPanel == null) {
            return;
        }
        if (this.m_LiveShowObjectInterface instanceof LiveShowSoundObject) {
            SoundMixers.Sound_Lines o_Sound_Lines;
            LiveShowSoundObjectDescription o_LiveShowSoundObjectDescription = (LiveShowSoundObjectDescription)this.m_LiveShowObjectInterface.getDescription();
            if (o_LiveShowSoundObjectDescription == null) {
                return;
            }
            s_SoundSettings_ClipBoard = o_Sound_Lines = o_LiveShowSoundObjectDescription.getSound_Lines().copyTo(null);
        }
        this.refreshButtons();
    }

    private void jButton_PasteSoundSettingsActionPerformed(ActionEvent evt) {
        if (s_SoundSettings_ClipBoard == null) {
            return;
        }
        if (this.m_SoundSettingsPanel == null) {
            return;
        }
        this.m_SoundSettingsPanel.pasteSound_Lines(s_SoundSettings_ClipBoard);
    }

    public void clearClipBoards() {
        if (s_DMXFadeDescription_ClipBoard != null) {
            s_DMXFadeDescription_ClipBoard.close(true);
            s_DMXFadeDescription_ClipBoard = null;
        }
        if (s_MediaObjectDescription_ClipBoard != null) {
            s_MediaObjectDescription_ClipBoard.close(true);
            s_MediaObjectDescription_ClipBoard = null;
        }
    }

    public void setLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface, Playable p_Playable) {
        String stringName;
        boolean boolAddSpecialTab = false;
        StringBuffer stringBuffer_Titel = new StringBuffer();
        stringBuffer_Titel.append(TITLE);
        if (p_LiveShowObjectInterface == null) {
            stringBuffer_Titel.append(" ---");
            this.setTitle(stringBuffer_Titel.toString());
            this.jTabbedPane1.setEnabledAt(0, false);
            if (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(1);
            }
            this.jTabbedPane1.setVisible(false);
        }
        this.jTabbedPane1.setEnabledAt(0, true);
        if (this.m_LiveShowObjectInterface != null) {
            this.m_LiveShowObjectInterface.removeLiveShowObjectListener((LiveShowObjectListener)this);
        }
        this.m_LiveShowObjectInterface = p_LiveShowObjectInterface;
        if (this.m_LiveShowObjectInterface != null) {
            this.m_LiveShowObjectInterface.addLiveShowObjectListener((LiveShowObjectListener)this);
            stringName = this.m_LiveShowObjectInterface.getName();
        } else {
            stringName = "";
        }
        this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
        this.m_SoundSettingParamChanged = false;
        this.m_MediaObjectSettings.setLiveShowMediaObject(null);
        this.m_MediaServerParamChanged = false;
        this.m_DMXFadeSettingsPanel.setLiveShowObject(null, p_Playable);
        this.m_FadeSettingParamChanged = false;
        this.liveShowObjectSettingsPanel1.setLiveShowObject(p_LiveShowObjectInterface, p_Playable);
        this.m_ObjectSettingParamChanged = false;
        stringBuffer_Titel.append(" ");
        if (this.m_LiveShowObjectInterface instanceof LiveShowDMXObject) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.m_DMXFadeSettingsPanel.setLiveShowObject(this.m_LiveShowObjectInterface, p_Playable);
            if (this.jTabbedPane1.getTabCount() < 2) {
                this.jTabbedPane1.setSelectedIndex(0);
                boolAddSpecialTab = true;
            } else if (this.m_LastTab1Component != this.m_DMXFadeSettingsPanel) {
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.removeTabAt(1);
                boolAddSpecialTab = true;
            }
            if (boolAddSpecialTab) {
                this.jTabbedPane1.addTab(TAB_DMX_TITLE, (Component)this.m_DMXFadeSettingsPanel);
                this.m_LastTab1Component = this.m_DMXFadeSettingsPanel;
            }
            this.jTabbedPane1.setEnabledAt(1, true);
            stringBuffer_Titel.append(DMXOBJECT);
            this.jTabbedPane1.setVisible(true);
        } else if (this.m_LiveShowObjectInterface instanceof LiveShowDMXSceneBridge) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.jTabbedPane1.setSelectedIndex(0);
            this.m_DMXFadeSettingsPanel.setLiveShowObject(this.m_LiveShowObjectInterface, p_Playable);
            if (this.jTabbedPane1.getTabCount() < 2) {
                boolAddSpecialTab = true;
            } else if (this.m_LastTab1Component != this.m_DMXFadeSettingsPanel) {
                this.jTabbedPane1.removeTabAt(1);
                boolAddSpecialTab = true;
            }
            if (boolAddSpecialTab) {
                this.jTabbedPane1.addTab(TAB_DMX_TITLE, (Component)this.m_DMXFadeSettingsPanel);
                this.m_LastTab1Component = this.m_DMXFadeSettingsPanel;
            }
            this.jTabbedPane1.setEnabledAt(1, false);
            stringBuffer_Titel.append(DMXSCENEBRIDGE);
            this.jTabbedPane1.setVisible(true);
        } else if (p_LiveShowObjectInterface instanceof LiveShowSoundObject) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent((SoundMixers.Sound_Lines_Parent)((LiveShowSoundObject)this.m_LiveShowObjectInterface));
            if (this.jTabbedPane1.getTabCount() < 2) {
                this.jTabbedPane1.setSelectedIndex(0);
                boolAddSpecialTab = true;
            } else if (this.m_LastTab1Component != this.m_SoundSettingsPanel) {
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.removeTabAt(1);
                boolAddSpecialTab = true;
            }
            if (boolAddSpecialTab) {
                this.jTabbedPane1.addTab(TAB_SOUND_TITLE, (Component)this.m_SoundSettingsPanel);
                this.m_LastTab1Component = this.m_SoundSettingsPanel;
            }
            this.jTabbedPane1.setEnabledAt(1, true);
            stringBuffer_Titel.append(SOUNDOBJECT);
            this.jTabbedPane1.setVisible(true);
        } else if (p_LiveShowObjectInterface instanceof LiveShowSoundSceneBridge) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.jTabbedPane1.setSelectedIndex(0);
            if (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(1);
            }
            this.m_LastTab1Component = null;
            stringBuffer_Titel.append(SOUNDSCENEBRIDGE);
            this.jTabbedPane1.setVisible(true);
        } else if (p_LiveShowObjectInterface instanceof LiveShowMediaObject) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.m_MediaObjectSettings.setLiveShowMediaObject((LiveShowMediaObject)p_LiveShowObjectInterface);
            if (this.jTabbedPane1.getTabCount() < 2) {
                boolAddSpecialTab = true;
            } else if (this.m_LastTab1Component != this.m_MediaObjectSettings) {
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.removeTabAt(1);
                boolAddSpecialTab = true;
            }
            if (boolAddSpecialTab) {
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.addTab(TAB_MEDIA_TITLE, (Component)this.m_MediaObjectSettings);
                this.m_LastTab1Component = this.m_MediaObjectSettings;
            }
            this.jTabbedPane1.setEnabledAt(1, true);
            stringBuffer_Titel.append(MEDIAOBJECT);
            this.jTabbedPane1.setVisible(true);
            if (((LiveShowMediaObject)p_LiveShowObjectInterface).getMediaServerCount() <= 0) {
                this.jTabbedPane1.setSelectedIndex(1);
            }
        } else if (p_LiveShowObjectInterface instanceof LiveShowMediaSceneBridge) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.jTabbedPane1.setSelectedIndex(0);
            if (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(1);
            }
            this.m_LastTab1Component = null;
            stringBuffer_Titel.append(MEDIASCENEBRIDGE);
            this.jTabbedPane1.setVisible(true);
        } else if (p_LiveShowObjectInterface instanceof LiveShowSPITObject) {
            this.m_SoundSettingsPanel.setSound_Lines_Parent(null);
            this.jTabbedPane1.setSelectedIndex(0);
            if (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(1);
            }
            this.m_LastTab1Component = null;
            stringBuffer_Titel.append(SPITOBJECT);
            this.jTabbedPane1.setVisible(true);
        } else {
            this.m_LiveShowObjectInterface = null;
            if (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(1);
            }
            this.m_LastTab1Component = null;
            this.jTabbedPane1.setVisible(false);
        }
        stringBuffer_Titel.append(" ");
        stringBuffer_Titel.append(stringName);
        this.setTitle(stringBuffer_Titel.toString());
    }

    public LiveShowObjectDescription getOldLiveShowObjectDescription() {
        LiveShowObjectDescription o_ObjectDescription_Old;
        if (this.m_LiveShowObjectInterface instanceof LiveShowSoundObject) {
            SoundMixers.Sound_Lines o_Sound_Lines_Old = this.m_SoundSettingsPanel.getSound_Lines_Old();
            o_ObjectDescription_Old = this.m_LiveShowObjectInterface.getDescription().clone(null);
            o_Sound_Lines_Old.copyTo(((LiveShowSoundObjectDescription)o_ObjectDescription_Old).getSound_Lines());
        } else {
            o_ObjectDescription_Old = this.m_LiveShowObjectInterface.getDescription();
        }
        return o_ObjectDescription_Old;
    }

    public void setSelectedUnit(int p_Unit) {
        if (p_Unit != 1 && p_Unit != 0) {
            return;
        }
        this.liveShowObjectSettingsPanel1.setSelectedUnit(p_Unit);
        this.m_DMXFadeSettingsPanel.setSelectedUnit(p_Unit);
    }

    public void startUndoAction(int p_Action, String p_ActionString) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkStartAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObjectDescription_Cloned(this.getOldLiveShowObjectDescription());
            o_LiveShowUndo.startAction(p_Action, p_ActionString, (LiveShowUndo.ActionOwnerInterface)o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void startUndoAction_Volume(int p_Action, String p_ActionString) {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        if (!o_LiveShowObjectInterface.getSelected()) {
            this.startUndoAction(p_Action, p_ActionString);
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.startUndoAction_VolumeChange(o_LiveShowObjectInterface, p_Action, p_ActionString);
    }

    public void endUndoAction(int p_Action, boolean p_Success) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkEndAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
            o_LiveShowUndo.endAction(p_Success, p_Action, (LiveShowUndo.ActionOwnerInterface)o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void endUndoAction_Volume(int p_Action, boolean p_Success) {
        Object o_LiveShowUndo = null;
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        if (!o_LiveShowObjectInterface.getSelected()) {
            this.endUndoAction(p_Action, p_Success);
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.endUndoAction_VolumeChange(o_LiveShowObjectInterface, p_Action, p_Success);
    }

    public void save() {
        boolean boolChangedVolume = false;
        Playable o_Playable = this.liveShowObjectSettingsPanel1.getPlayable();
        int intAction = 14;
        String stringAction = LiveShowUndo.ACTION_PARAMCHANGE_STRING;
        if (this.m_FadeSettingParamChanged && this.m_ObjectSettingParamChanged) {
            intAction = 14;
            stringAction = LiveShowUndo.ACTION_PARAMCHANGE_STRING;
        }
        if (this.m_MediaServerParamChanged && this.m_ObjectSettingParamChanged) {
            intAction = 14;
            stringAction = LiveShowUndo.ACTION_PARAMCHANGE_STRING;
        } else if (this.m_ObjectSettingParamChanged) {
            intAction = 120;
            stringAction = LiveShowUndo.ACTION_OBJECTSETTINGS_STRING;
        } else if (this.m_SoundSettingParamChanged) {
            intAction = 122;
            stringAction = LiveShowUndo.ACTION_SOUNDSETTINGS_STRING;
        } else if (this.m_FadeSettingParamChanged) {
            intAction = 121;
            stringAction = LiveShowUndo.ACTION_FADESETTINGS_STRING;
        } else if (this.m_MediaServerParamChanged) {
            intAction = 131;
            stringAction = LiveShowUndo.ACTION_MEDIASERVERSETTINGS_STRING;
        } else {
            this.cancel();
            return;
        }
        if (o_Playable != null && o_Playable instanceof LiveShowVIP) {
            boolChangedVolume = this.liveShowObjectSettingsPanel1.getChangedVolume();
            if (boolChangedVolume) {
                this.startUndoAction_Volume(intAction, stringAction);
            } else {
                this.startUndoAction(intAction, stringAction);
            }
        }
        if (this.m_LiveShowObjectInterface != null) {
            this.m_LiveShowObjectInterface.setSendNotification(false);
        }
        this.liveShowObjectSettingsPanel1.save();
        this.m_SoundSettingsPanel.save();
        this.m_DMXFadeSettingsPanel.save();
        this.m_MediaObjectSettings.save();
        if (this.m_LiveShowObjectInterface == null || !(this.m_LiveShowObjectInterface instanceof LiveShowDMXObject) || ((LiveShowDMXObject)this.m_LiveShowObjectInterface).checkEqualsFadeSettingsToDefault()) {
            // empty if block
        }
        if (this.m_LiveShowObjectInterface != null) {
            this.m_LiveShowObjectInterface.setSendNotification(true);
            ((LiveShowObject)this.m_LiveShowObjectInterface).notifyObjectListeners_ObjectParameterChanged(this.m_LiveShowObjectInterface.getDescription());
        }
        if (o_Playable != null && o_Playable instanceof LiveShowVIP) {
            if (boolChangedVolume) {
                this.endUndoAction_Volume(intAction, true);
            } else {
                this.endUndoAction(intAction, true);
            }
        }
        this.jButton_Save.setEnabled(false);
    }

    public void cancel() {
        this.liveShowObjectSettingsPanel1.cancel();
        this.m_SoundSettingsPanel.cancel();
        this.m_DMXFadeSettingsPanel.cancel();
        this.m_MediaObjectSettings.cancel();
        this.jButton_Save.setEnabled(false);
    }

    public void refreshButtons() {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        if (this.m_ObjectSettingParamChanged || this.m_SoundSettingParamChanged || this.m_FadeSettingParamChanged || this.m_MediaServerParamChanged) {
            this.jButton_Save.setEnabled(true);
        } else {
            this.jButton_Save.setEnabled(false);
        }
        LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = null;
        if (this.m_LiveShowObjectInterface instanceof LiveShowSceneBridge && (o_LiveShowSceneBridge = (LiveShowSceneBridge)this.m_LiveShowObjectInterface).getIsMainBridge()) {
            o_LiveShowSceneBridgeMain = o_LiveShowSceneBridge.getLiveShowSceneBridgeMain();
        }
        if (o_LiveShowSceneBridgeMain == null) {
            this.jButton_SplitMainBridge.setVisible(false);
        } else {
            this.jButton_SplitMainBridge.setVisible(true);
        }
        if (this.m_LiveShowObjectInterface instanceof LiveShowSoundObject) {
            this.jButton_CopySoundSettings.setVisible(true);
            this.jButton_PasteSoundSettings.setVisible(true);
            if (s_SoundSettings_ClipBoard != null) {
                this.jButton_PasteSoundSettings.setEnabled(true);
            } else {
                this.jButton_PasteSoundSettings.setEnabled(false);
            }
        } else {
            this.jButton_CopySoundSettings.setVisible(false);
            this.jButton_PasteSoundSettings.setVisible(false);
        }
        if (this.m_LiveShowObjectInterface instanceof LiveShowDMXObject) {
            this.jButton_CopyDMXSettings.setVisible(true);
            this.jButton_PasteDMXSettings.setVisible(true);
            if (s_DMXFadeDescription_ClipBoard != null) {
                this.jButton_PasteDMXSettings.setEnabled(true);
            } else {
                this.jButton_PasteDMXSettings.setEnabled(false);
            }
        } else {
            this.jButton_CopyDMXSettings.setVisible(false);
            this.jButton_PasteDMXSettings.setVisible(false);
        }
        if (this.m_LiveShowObjectInterface instanceof LiveShowMediaObject) {
            this.jButton_CopyMediaSettings.setVisible(true);
            this.jButton_PasteMediaSettings.setVisible(true);
            if (s_MediaObjectDescription_ClipBoard != null) {
                this.jButton_PasteMediaSettings.setEnabled(true);
            } else {
                this.jButton_PasteMediaSettings.setEnabled(false);
            }
        } else {
            this.jButton_CopyMediaSettings.setVisible(false);
            this.jButton_PasteMediaSettings.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.liveShowObjectSettingsPanel1) {
            if ("paramsChanged".equals(evt.getPropertyName())) {
                this.m_ObjectSettingParamChanged = (Boolean)evt.getNewValue();
                this.refreshButtons();
            } else if ("paramsSourceChanged".equals(evt.getPropertyName())) {
                PropertyChangeEvent o_PropertyChangeEvent = new PropertyChangeEvent(this.liveShowObjectSettingsPanel1, "paramsSourceChanged", evt.getOldValue(), evt.getNewValue());
                this.m_MediaObjectSettings.propertyChange(o_PropertyChangeEvent);
                this.refreshButtons();
            }
        } else if (evt.getSource() == this.m_SoundSettingsPanel) {
            if ("paramsChanged".equals(evt.getPropertyName())) {
                this.m_SoundSettingParamChanged = (Boolean)evt.getNewValue();
                this.refreshButtons();
            }
        } else if (evt.getSource() == this.m_DMXFadeSettingsPanel) {
            if ("paramsChanged".equals(evt.getPropertyName())) {
                this.m_FadeSettingParamChanged = (Boolean)evt.getNewValue();
                this.refreshButtons();
            }
        } else if (evt.getSource() == this.m_MediaObjectSettings && "paramsChanged".equals(evt.getPropertyName())) {
            this.m_MediaServerParamChanged = (Boolean)evt.getNewValue();
            this.refreshButtons();
        }
    }

    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (p_LiveShowObjectInterface == this.m_LiveShowObjectInterface) {
            this.setVisible(false);
        }
    }

    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }
}

