/*
 * Decompiled with CFR 0.152.
 */
package LiveShowProjectPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowProjectPackage.LiveShowInternalFrame_PlayJingles;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import MainPackage.LiveShowProjectDesktop;
import ProtocolTools.PopUpToolTip;
import SwingFramePackage.JOptionDialog;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.JobHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class LiveShowInternalFrame_Export
extends JInternalFrame {
    public static LiveShowProjectDescription s_LiveShowProjectDescription_Project;
    public static LiveShowProjectDescription s_LiveShowProjectDescription_SelectedObjects;
    public static LiveShow_ExportDescription s_LiveShowExportDescription;
    public static ImageIcon s_IconCheckBox_Unselected;
    public static ImageIcon s_IconCheckBox_Selected;
    @LiveLanguageString
    public static String FREESPACEMISSING_TITEL;
    @LiveLanguageString
    public static String FREESPACEMISSING_REASON;
    @LiveLanguageString
    public static String FREESPACEMISSING_REMARK;
    private static String m_Statistic_Project;
    private static double m_Size_Project;
    private static String m_Statistic_Selected;
    private static double m_Size_Selection;
    private ButtonGroup buttonGroup_Export;
    private JButton jButton_Cancel;
    private JButton jButton_Save;
    private JCheckBox jCheckBox_Jingles;
    private JLabel jLabel_Description;
    private JLabel jLabel_ProjectSizeMB;
    private JLabel jLabel_SelectionSizeMB;
    private JLabel jLabel_StatisticProject;
    private JLabel jLabel_StatisticSelection;
    private JPanel jPanel_Content;
    private JPanel jPanel_Export;
    private JRadioButton jRadioButton_ProjectAll;
    private JRadioButton jRadioButton_Selection;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldDescription;

    public LiveShowInternalFrame_Export() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveShowInternalFrame_Export.refreshStatistic();
        this.refresh();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        s_LiveShowExportDescription.setExportProjectAll(true);
    }

    private void initComponentsFurther() {
        this.jRadioButton_ProjectAll.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_Selection.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jCheckBox_Jingles.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextFieldDescription.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.buttonGroup_Export = new ButtonGroup();
        this.jPanel_Content = new JPanel();
        this.jPanel_Export = new JPanel();
        this.jRadioButton_ProjectAll = new JRadioButton();
        this.jRadioButton_Selection = new JRadioButton();
        this.jLabel_StatisticProject = new JLabel();
        this.jLabel_StatisticSelection = new JLabel();
        this.jLabel_Description = new JLabel();
        this.jTextFieldDescription = new JTextField();
        this.jCheckBox_Jingles = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jLabel_ProjectSizeMB = new JLabel();
        this.jLabel_SelectionSizeMB = new JLabel();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setTitle("Export");
        this.setToolTipText("");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Menu_ProjectExport.png")));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(500, 650));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                LiveShowInternalFrame_Export.this.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                LiveShowInternalFrame_Export.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jPanel_Export.setMinimumSize(new Dimension(50, 50));
        this.jPanel_Export.setPreferredSize(new Dimension(200, 100));
        this.jPanel_Export.setLayout(new GridBagLayout());
        this.buttonGroup_Export.add(this.jRadioButton_ProjectAll);
        this.jRadioButton_ProjectAll.setSelected(true);
        this.jRadioButton_ProjectAll.setText("Whole Project");
        this.jRadioButton_ProjectAll.setToolTipText("");
        this.jRadioButton_ProjectAll.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jRadioButton_ProjectAll.setOpaque(false);
        this.jRadioButton_ProjectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_Export.this.jRadioButton_ProjectAllActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jRadioButton_ProjectAll, gridBagConstraints);
        this.buttonGroup_Export.add(this.jRadioButton_Selection);
        this.jRadioButton_Selection.setText("Selection");
        this.jRadioButton_Selection.setToolTipText("");
        this.jRadioButton_Selection.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jRadioButton_Selection.setOpaque(false);
        this.jRadioButton_Selection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_Export.this.jRadioButton_SelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jRadioButton_Selection, gridBagConstraints);
        this.jLabel_StatisticProject.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jLabel_StatisticProject, gridBagConstraints);
        this.jLabel_StatisticSelection.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jLabel_StatisticSelection, gridBagConstraints);
        this.jLabel_Description.setText("Description");
        this.jLabel_Description.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jLabel_Description, gridBagConstraints);
        this.jTextFieldDescription.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Export.add((Component)this.jTextFieldDescription, gridBagConstraints);
        this.jCheckBox_Jingles.setText("Include Jingles");
        this.jCheckBox_Jingles.setOpaque(false);
        this.jCheckBox_Jingles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_Export.this.jCheckBox_JinglesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Export.add((Component)this.jCheckBox_Jingles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel_Export.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel_Export.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel_ProjectSizeMB.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_ProjectSizeMB.setText("0 MB");
        this.jLabel_ProjectSizeMB.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel_Export.add((Component)this.jLabel_ProjectSizeMB, gridBagConstraints);
        this.jLabel_SelectionSizeMB.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_SelectionSizeMB.setText("0 MB");
        this.jLabel_SelectionSizeMB.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel_Export.add((Component)this.jLabel_SelectionSizeMB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jPanel_Export, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setIconTextGap(0);
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_Export.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setIconTextGap(0);
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowInternalFrame_Export.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void jRadioButton_ProjectAllActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_ProjectAll.isSelected()) {
            s_LiveShowExportDescription.setExportProjectAll(true);
        }
        this.refresh();
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        this.export();
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jRadioButton_SelectionActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_Selection.isSelected()) {
            s_LiveShowExportDescription.setExportProjectAll(false);
        }
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        LiveShowInternalFrame_Export.refreshStatistic();
        this.refresh();
    }

    private void jCheckBox_JinglesActionPerformed(ActionEvent evt) {
        s_LiveShowExportDescription.setIncludeJingles(this.jCheckBox_Jingles.isSelected());
        LiveShowInternalFrame_Export.refreshStatistic();
        this.refresh();
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LiveShowInternalFrame_Export.refreshStatistic();
                LiveShowInternalFrame_Export.this.refresh();
            }
        });
    }

    private static void refreshStatistic() {
        LiveShowObject o_LiveShowObjectInterface;
        LiveShowInternalFrame_PlayJingles.JingleView o_JingleView;
        int intJingle;
        s_LiveShowExportDescription.addLiveShowVIP((LiveShowVIP)LiveShowProjectDesktop.getLiveShowSoundVIP());
        s_LiveShowExportDescription.addLiveShowVIP((LiveShowVIP)LiveShowProjectDesktop.getLiveShowDMXVIP());
        s_LiveShowExportDescription.addLiveShowVIP((LiveShowVIP)LiveShowProjectDesktop.getLiveShowMediaVIP());
        s_LiveShowExportDescription.clearLiveShowJingleObjects();
        LiveShowInternalFrame_PlayJingles o_LiveShowInternalFrame_PlayJingles = LiveShowProjectDesktop.getLiveShowInternalFrame_PlayJingles();
        LiveShowInternalFrame_PlayJingles.JinglePanel o_JinglePanel = o_LiveShowInternalFrame_PlayJingles.getSoundJinglePanel();
        int intJingleCount = o_JinglePanel.getJingleViewCount();
        for (intJingle = 0; intJingle < intJingleCount; ++intJingle) {
            o_JingleView = (LiveShowInternalFrame_PlayJingles.JingleView)o_JinglePanel.getJingleView(intJingle);
            if (o_JingleView == null || !s_LiveShowExportDescription.getExportProjectAll() && !s_LiveShowExportDescription.getExportProjectAll() && (!s_LiveShowExportDescription.getIncludeJingles() || !o_JingleView.getSelected())) continue;
            o_LiveShowObjectInterface = o_JingleView.getLiveShowObject();
            s_LiveShowExportDescription.addLiveShowJingleObject(s_LiveShowExportDescription.getLiveShowVIP("Sound"), (LiveShowObjectInterface)o_LiveShowObjectInterface);
        }
        o_JinglePanel = o_LiveShowInternalFrame_PlayJingles.getDMXJinglePanel();
        intJingleCount = o_JinglePanel.getJingleViewCount();
        for (intJingle = 0; intJingle < intJingleCount; ++intJingle) {
            o_JingleView = (LiveShowInternalFrame_PlayJingles.JingleView)o_JinglePanel.getJingleView(intJingle);
            if (o_JingleView == null || !s_LiveShowExportDescription.getExportProjectAll() && !s_LiveShowExportDescription.getExportProjectAll() && (!s_LiveShowExportDescription.getIncludeJingles() || !o_JingleView.getSelected())) continue;
            o_LiveShowObjectInterface = o_JingleView.getLiveShowObject();
            s_LiveShowExportDescription.addLiveShowJingleObject(s_LiveShowExportDescription.getLiveShowVIP("DMX"), (LiveShowObjectInterface)o_LiveShowObjectInterface);
        }
        o_JinglePanel = o_LiveShowInternalFrame_PlayJingles.getMediaJinglePanel();
        intJingleCount = o_JinglePanel.getJingleViewCount();
        for (intJingle = 0; intJingle < intJingleCount; ++intJingle) {
            o_JingleView = (LiveShowInternalFrame_PlayJingles.JingleView)o_JinglePanel.getJingleView(intJingle);
            if (o_JingleView == null || !s_LiveShowExportDescription.getExportProjectAll() && !s_LiveShowExportDescription.getExportProjectAll() && (!s_LiveShowExportDescription.getIncludeJingles() || !o_JingleView.getSelected())) continue;
            o_LiveShowObjectInterface = o_JingleView.getLiveShowObject();
            s_LiveShowExportDescription.addLiveShowJingleObject(s_LiveShowExportDescription.getLiveShowVIP("Media"), (LiveShowObjectInterface)o_LiveShowObjectInterface);
        }
        m_Statistic_Project = LiveShowProjectDescription.calculateProjectStatistic((boolean)false, (LiveShow_ExportDescription)s_LiveShowExportDescription);
        m_Size_Project = (double)((long)((double)LiveShowInternalFrame_Export.getDiskSpaceEstimated(null, false) / 1048576.0 * 10.0 + 0.5)) / 10.0;
        m_Statistic_Selected = LiveShowProjectDescription.calculateProjectStatistic((boolean)true, (LiveShow_ExportDescription)s_LiveShowExportDescription);
        m_Size_Selection = (double)((long)((double)LiveShowInternalFrame_Export.getDiskSpaceEstimated(null, true) / 1048576.0 * 10.0 + 0.5)) / 10.0;
    }

    public void refresh() {
        this.jLabel_StatisticProject.setText(m_Statistic_Project);
        this.jLabel_StatisticSelection.setText(m_Statistic_Selected);
        boolean boolSaveButtonEnabled = false;
        if (s_LiveShowExportDescription.getExportProjectAll()) {
            boolSaveButtonEnabled = true;
            this.jRadioButton_ProjectAll.setSelected(true);
            this.jCheckBox_Jingles.setEnabled(false);
            this.jCheckBox_Jingles.setForeground(Color.GRAY);
            this.jLabel_StatisticProject.setForeground(Color.WHITE);
            this.jLabel_StatisticSelection.setForeground(Color.GRAY);
            this.jLabel_ProjectSizeMB.setForeground(Color.WHITE);
            this.jLabel_SelectionSizeMB.setForeground(Color.GRAY);
        } else {
            this.jRadioButton_Selection.setSelected(true);
            this.jCheckBox_Jingles.setSelected(s_LiveShowExportDescription.getIncludeJingles());
            this.jCheckBox_Jingles.setEnabled(true);
            this.jCheckBox_Jingles.setForeground(Color.WHITE);
            this.jLabel_StatisticProject.setForeground(Color.GRAY);
            this.jLabel_StatisticSelection.setForeground(Color.WHITE);
            this.jLabel_ProjectSizeMB.setForeground(Color.GRAY);
            this.jLabel_SelectionSizeMB.setForeground(Color.WHITE);
            boolSaveButtonEnabled = false;
            for (int intVIP = 0; intVIP < s_LiveShowExportDescription.getLiveShowVIPCount(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = s_LiveShowExportDescription.getLiveShowVIP(intVIP);
                if (o_LiveShowVIP == null) continue;
                if (o_LiveShowVIP.getSelectedObjectsCount() > 0) {
                    boolSaveButtonEnabled = true;
                    break;
                }
                if (!s_LiveShowExportDescription.getIncludeJingles() || s_LiveShowExportDescription.getLiveShowJingleObjectCount(o_LiveShowVIP) <= 0) continue;
                boolSaveButtonEnabled = true;
                break;
            }
        }
        if (m_Size_Project > 0.0) {
            this.jLabel_ProjectSizeMB.setText("~ " + String.valueOf(m_Size_Project) + " MB");
        } else {
            this.jLabel_ProjectSizeMB.setText("< 1 MB");
        }
        if (m_Size_Selection > 0.0) {
            this.jLabel_SelectionSizeMB.setText("~ " + String.valueOf(m_Size_Selection) + " MB");
        } else {
            this.jLabel_SelectionSizeMB.setText("< 1 MB");
        }
        this.jButton_Save.setEnabled(boolSaveButtonEnabled);
    }

    private void export() {
        s_LiveShowExportDescription.setSaveProject(false);
        if (s_LiveShowExportDescription.getExportProjectAll()) {
            LiveShowInternalFrame_Export.exportProject(this.jTextFieldDescription.getText());
        } else {
            LiveShowInternalFrame_Export.exportSelectedObjects(this.jTextFieldDescription.getText());
        }
        this.setVisible(false);
    }

    public static void exportProject(String p_Description) {
        if (p_Description == null) {
            p_Description = "";
        }
        if (s_LiveShowProjectDescription_Project == null) {
            s_LiveShowProjectDescription_Project = new LiveShowProjectDescription(LiveShow_ExportDescription.s_LastFile);
        }
        s_LiveShowProjectDescription_Project.setProjectDescription(p_Description);
        if (LiveShowProjectDescription.showSaveProjectDescription((LiveShowProjectDescription)s_LiveShowProjectDescription_Project, (boolean)true)) {
            LiveShow_ExportDescription.s_LastFile = new File(s_LiveShowProjectDescription_Project.getProjectPathName() + ".lsp");
            if (!LiveShowInternalFrame_Export.checkDiskSpaceEstimated(s_LiveShowProjectDescription_Project, false)) {
                return;
            }
            Runnable o_Runnable = new Runnable(){

                @Override
                public void run() {
                    LiveShowProjectDesktop.s_SelfReference.saveProject(s_LiveShowProjectDescription_Project, s_LiveShowExportDescription);
                    LiveShowProjectDesktop.s_SelfReference.writeIni();
                }
            };
            JobHandler.addJob((Runnable)o_Runnable);
        }
    }

    public static void exportSelectedObjects(String p_Description) {
        if (p_Description == null) {
            p_Description = "";
        }
        if (s_LiveShowProjectDescription_SelectedObjects == null) {
            s_LiveShowProjectDescription_SelectedObjects = new LiveShowProjectDescription(LiveShow_ExportDescription.s_LastFile);
        }
        s_LiveShowProjectDescription_SelectedObjects.setProjectDescription(p_Description);
        if (LiveShowProjectDescription.showSaveProjectDescription((LiveShowProjectDescription)s_LiveShowProjectDescription_SelectedObjects, (boolean)true)) {
            LiveShow_ExportDescription.s_LastFile = new File(s_LiveShowProjectDescription_SelectedObjects.getProjectPathName() + ".lsp");
            if (!LiveShowInternalFrame_Export.checkDiskSpaceEstimated(s_LiveShowProjectDescription_SelectedObjects, true)) {
                return;
            }
            Runnable o_Runnable = new Runnable(){

                @Override
                public void run() {
                    LiveShowProjectDesktop.s_SelfReference.saveProject(s_LiveShowProjectDescription_SelectedObjects, s_LiveShowExportDescription);
                    LiveShowProjectDesktop.s_SelfReference.writeIni();
                }
            };
            JobHandler.addJob((Runnable)o_Runnable);
        }
    }

    public static long getDiskSpaceEstimated(LiveShowProjectDescription p_LiveShowProjectDescription, boolean p_OnlySelection) {
        long longBytesCount = 0L;
        File o_ExportDirectory = null;
        ArrayList<Object> o_SourceObjects = new ArrayList<Object>();
        if (p_LiveShowProjectDescription != null) {
            try {
                o_ExportDirectory = new File(p_LiveShowProjectDescription.getProjectPath());
            }
            catch (Exception e) {
                o_ExportDirectory = null;
            }
        }
        for (int intVIP = 0; intVIP < s_LiveShowExportDescription.getLiveShowVIPCount(); ++intVIP) {
            LiveShowVIP o_LiveShowVIP = s_LiveShowExportDescription.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            longBytesCount += o_LiveShowVIP.getDiskSpaceEstimated(o_ExportDirectory, p_OnlySelection, o_SourceObjects);
            if (!s_LiveShowExportDescription.getIncludeJingles()) continue;
            longBytesCount += LiveShowProjectDesktop.getLiveShowInternalFrame_PlayJingles().getDiskSpaceEstimated(o_ExportDirectory, p_OnlySelection, o_SourceObjects);
        }
        return longBytesCount;
    }

    public static boolean checkDiskSpaceEstimated(LiveShowProjectDescription p_LiveShowProjectDescription, boolean p_OnlySelection) {
        File o_ExportDirectory;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        long longBytesCount = 0L;
        try {
            o_ExportDirectory = new File(p_LiveShowProjectDescription.getProjectPath());
        }
        catch (Exception e) {
            o_ExportDirectory = null;
        }
        longBytesCount = LiveShowInternalFrame_Export.getDiskSpaceEstimated(p_LiveShowProjectDescription, p_OnlySelection);
        long longFreeBytes = o_ExportDirectory.getFreeSpace();
        if (longBytesCount > longFreeBytes) {
            double longMissingMegaBytes = (double)(-((long)((double)(longFreeBytes - longBytesCount) / 1048576.0 * 10.0 + 0.5))) / 10.0;
            StringBuffer o_StringBuffer = new StringBuffer();
            o_StringBuffer.append("<html>");
            o_StringBuffer.append(longMissingMegaBytes);
            o_StringBuffer.append(FREESPACEMISSING_REASON);
            o_StringBuffer.append("<br>");
            o_StringBuffer.append(FREESPACEMISSING_REMARK);
            o_StringBuffer.append("</html>");
            JOptionDialog.showMessageDialog(null, (Object)o_StringBuffer.toString(), (String)(FREESPACEMISSING_TITEL + o_ExportDirectory.getAbsolutePath()), (int)0);
            return false;
        }
        return true;
    }

    static {
        s_LiveShowExportDescription = new LiveShow_ExportDescription();
        s_IconCheckBox_Unselected = new ImageIcon(LiveShowInternalFrame_Export.class.getResource("/IconsPackage/CheckBox_Black_Unselected.png"));
        s_IconCheckBox_Selected = new ImageIcon(LiveShowInternalFrame_Export.class.getResource("/IconsPackage/CheckBox_Black_Selected.png"));
        FREESPACEMISSING_TITEL = "Not enough diskspace: ";
        FREESPACEMISSING_REASON = " MB of free diskspace are missing.";
        FREESPACEMISSING_REMARK = "Use another partition or free diskspace and try again!";
        m_Size_Project = 0.0;
        m_Size_Selection = 0.0;
    }
}

