/*
 * Decompiled with CFR 0.152.
 */
package LiveShowMediaPackage;

import FileToolPackage.FileTools;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import MainPackage.LiveShowProjectDesktop;
import MediaObjectPackage.MediaSource;
import MediaObjectPackage.MediaSourceListener;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaVIP;
import MediaVirtualPackage.MediaSource_Client;
import StartPackage.LiveShowMediaSystem;
import SynchronizationPackage.JobHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;

public class LiveShowMediaManagement
implements MediaSourceListener {
    private LiveShowProjectDesktop m_LiveShowDesktop;
    private ArrayList<MediaSource_Client> m_LiveShowMediaSource_Clients;
    private LiveShowMediaVIP m_LiveShowMediaVIP;
    private File m_LastOpenedPath;
    private static LiveShowMediaManagement s_SelfReference;
    private LiveCloseSemaphore m_LiveCloseSemaphore;

    public LiveShowMediaManagement(LiveShowProjectDesktop p_LiveShowDesktop) {
        this.initMembers();
        this.m_LiveShowDesktop = p_LiveShowDesktop;
    }

    private void initMembers() {
        s_SelfReference = this;
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowMediaSource_Clients = new ArrayList();
        this.m_LastOpenedPath = FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_LiveShowMediaVIP = null;
        if (this.m_LiveShowMediaSource_Clients != null) {
            for (int intMediaSource = this.m_LiveShowMediaSource_Clients.size() - 1; intMediaSource >= 0; --intMediaSource) {
                MediaSource_Client o_LiveShowMediaSource_Client = this.m_LiveShowMediaSource_Clients.get(intMediaSource);
                if (o_LiveShowMediaSource_Client == null) continue;
                o_LiveShowMediaSource_Client.close();
            }
            this.m_LiveShowMediaSource_Clients.clear();
        }
        this.m_LiveShowDesktop = null;
        LiveShow_MediaPlayer.poolClear();
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void closeProject() {
        LiveShowMediaSystem.closeProject();
    }

    public boolean newLiveShowMediaVIP() {
        boolean boolSuccess = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        LiveShowMediaVIP o_LiveShowMediaVIP = new LiveShowMediaVIP(true);
        if (o_LiveShowMediaVIP != null) {
            this.setLiveShowMediaVIP(o_LiveShowMediaVIP);
            boolSuccess = true;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolSuccess;
    }

    public void closeLiveShowMediaVIP() {
        if (this.m_LiveShowMediaVIP == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowMediaVIP.close();
        LiveShowMediaSystem.removeLiveShowMediaVIP((LiveShowMediaVIP)this.m_LiveShowMediaVIP);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setLiveShowMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP) {
        if (this.m_LiveShowMediaVIP == p_LiveShowMediaVIP) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowMediaVIP = p_LiveShowMediaVIP;
        LiveShowMediaSystem.setLiveShowMediaVIP((LiveShowMediaVIP)this.m_LiveShowMediaVIP);
        this.m_LiveShowDesktop.eventLiveShowMediaVIP(this.m_LiveShowMediaVIP);
        if (this.m_LiveShowMediaVIP != null) {
            this.m_LiveShowMediaVIP.setFrameMaxObjects(this.m_LiveShowMediaVIP.calculateFrameMaxObjects(null));
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public LiveShowMediaVIP getLiveShowMediaVIP() {
        return this.m_LiveShowMediaVIP;
    }

    public static LiveShowMediaVIP getLiveShowVIP() {
        if (s_SelfReference == null) {
            return null;
        }
        return s_SelfReference.getLiveShowMediaVIP();
    }

    public void deleteAllJumps() {
        if (this.m_LiveShowMediaVIP == null) {
            return;
        }
        int intSceneBridgeCount = this.m_LiveShowMediaVIP.getLiveShowSceneBridgeCount();
        for (int intSceneBridge = 0; intSceneBridge < intSceneBridgeCount; ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowMediaVIP.getLiveShowSceneBridge(intSceneBridge);
            o_LiveShowSceneBridge.setJumpSceneBridge(null);
        }
    }

    public boolean loadMediaFile() {
        File o_SelectedFile = null;
        boolean boolLoad = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        o_SelectedFile = LiveShowMediaSystem.loadMediaFile((String)LiveShowMediaSystem.LOAD_MEDIAFILE, (File)LiveShowMediaSystem.getLastOpenedFilePath());
        if (o_SelectedFile != null) {
            if (o_SelectedFile.isDirectory()) {
                boolLoad = false;
            } else {
                int intAnswer;
                boolLoad = true;
                if (!FileTools.checkWritable((File)o_SelectedFile.getParentFile()) && (intAnswer = LiveShowMediaSystem.showOptionPane_WarningWritable((File)o_SelectedFile, (File)o_SelectedFile.getParentFile())) == 1) {
                    boolLoad = false;
                }
                if (boolLoad) {
                    LiveShowMediaSystem.setLastOpenedFilePath((File)o_SelectedFile);
                    File o_ProblemFile = LiveShowMediaSystem.checkMediaFileNameDuplicated_load((File)o_SelectedFile);
                    if (o_ProblemFile != null) {
                        MediaSource_Client o_LiveShowMediaSource_Client = (MediaSource_Client)LiveShowMediaSystem.getLiveShowMediaSourceByFileName((String)o_ProblemFile.getName());
                        LiveShowProjectDesktop.getLiveShowInternalFrame_MediaSourceView().setSelectedMediaSource(o_LiveShowMediaSource_Client);
                        LiveShowProjectDesktop.toFrontInternalFrame(LiveShowProjectDesktop.getLiveShowInternalFrame_MediaSourceView());
                        if (FileTools.getCheckSum_MD5_Partial((File)o_ProblemFile).equals(FileTools.getCheckSum_MD5_Partial((File)o_SelectedFile))) {
                            intAnswer = LiveShowMediaSystem.showOptionPane_WarningFileDuplication_SameContent((File)o_SelectedFile, (File)o_ProblemFile);
                            if (intAnswer == 1) {
                                boolLoad = false;
                            } else {
                                o_SelectedFile = o_ProblemFile;
                            }
                        } else {
                            intAnswer = LiveShowMediaSystem.showOptionPane_WarningFileDuplication((File)o_SelectedFile, (File)o_ProblemFile);
                            if (intAnswer == 1) {
                                boolLoad = false;
                            }
                        }
                    }
                }
            }
        }
        if (boolLoad) {
            this.loadMediaFile(o_SelectedFile, -1L, -1L, true);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolLoad;
    }

    public void loadMediaFile(LiveShowMediaObject p_LiveShowMediaObject) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        String stringSourceString = p_LiveShowMediaObject.getDescription().getSourceString();
        if (stringSourceString == null) {
            return;
        }
        File o_File = new File(stringSourceString);
        this.loadMediaFile(o_File, p_LiveShowMediaObject.getFrameStartOffset(), p_LiveShowMediaObject.getFrameStartOffset() + p_LiveShowMediaObject.getFrameLength(), false);
    }

    public void loadMediaFile(MediaSource_Client p_LiveShowMediaSource_Client) {
        if (p_LiveShowMediaSource_Client == null) {
            return;
        }
        File o_File = p_LiveShowMediaSource_Client.getFile();
        this.loadMediaFile(o_File, -1L, -1L, false);
    }

    public void loadMediaFile(final File p_MediaFile, final long p_SectionStart, final long p_SectionEnd, final boolean p_AnalyzeVideo) {
        if (p_MediaFile == null) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!LiveShowMediaManagement.this.m_LiveCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveShowNotification o_LiveShowNotification = new LiveShowNotification(LiveShowMediaSystem.LOAD_MEDIAFILE, 0L, 0L, false);
                o_LiveShowNotification.setActionText(p_MediaFile.getName());
                MediaSource_Client o_MediaSource_Client = LiveShowMediaSystem.createMediaSource((File)p_MediaFile);
                if (o_MediaSource_Client != null) {
                    o_MediaSource_Client.addMediaSourceListener((MediaSourceListener)s_SelfReference);
                    LiveShowMediaManagement.this.eventMediaSourceOpened((MediaSource)o_MediaSource_Client, o_MediaSource_Client.getFile(), p_SectionStart, p_SectionEnd);
                    if (p_AnalyzeVideo) {
                        o_MediaSource_Client.analyzeVideo();
                    }
                }
                o_LiveShowNotification.close();
                LiveShowMediaManagement.this.m_LiveCloseSemaphore.leaveWorkerSection();
            }
        };
        JobHandler.addJob((Runnable)o_Runnable);
    }

    public void eventMediaSourceInvalidFile(MediaSource p_LiveShowMediaSource, File p_MediaFile) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventMediaSourceClosing(MediaSource p_LiveShowMediaSource) {
        if (p_LiveShowMediaSource == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowMediaSource_Clients.remove(p_LiveShowMediaSource);
        this.m_LiveShowDesktop.eventMediaSourceClosing(p_LiveShowMediaSource);
        p_LiveShowMediaSource.removeMediaSourceListener((MediaSourceListener)s_SelfReference);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventMediaSourceOpened(MediaSource p_LiveShowMediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowMediaSource_Clients.add((MediaSource_Client)p_LiveShowMediaSource);
        this.m_LiveShowDesktop.eventMediaSourceOpened(p_LiveShowMediaSource, p_MediaFile, p_SectionStart, p_SectionEnd);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
    }

    public void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        LiveShowMediaSystem.setHelpFocusListener((WindowFocusListener)p_HelpFocusListener);
    }
}

