/*
 * Decompiled with CFR 0.152.
 */
package LiveShowDMXPackage;

import DMXVirtualPackage.LiveShowDMXVIP;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import MainPackage.LiveShowProjectDesktop;
import StartPackage.LiveShowDMXSystem;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.event.WindowFocusListener;
import java.io.File;
import javax.swing.filechooser.FileSystemView;

public class LiveShowDMXManagement {
    private static LiveShowDMXManagement s_SelfReference;
    private LiveShowProjectDesktop m_LiveShowDesktop;
    private LiveShowDMXVIP m_LiveShowDMXVIP;
    private File m_LastOpenedPath;
    private LiveCloseSemaphore m_LiveCloseSemaphore;

    public LiveShowDMXManagement(LiveShowProjectDesktop p_LiveShowDesktop) {
        this.initMembers();
        this.m_LiveShowDesktop = p_LiveShowDesktop;
        s_SelfReference = this;
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LastOpenedPath = FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        if (this.m_LiveShowDMXVIP != null) {
            this.m_LiveShowDMXVIP.close();
        }
        this.m_LiveShowDMXVIP = null;
        this.m_LiveShowDesktop = null;
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void closeProject() {
        LiveShowDMXSystem.closeProject();
    }

    public boolean newLiveShowDMXVIP() {
        boolean boolSuccess = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        this.closeLiveShowDMXVIP();
        LiveShowDMXVIP o_LiveShowDMXVIP = new LiveShowDMXVIP(true);
        if (o_LiveShowDMXVIP != null) {
            this.setLiveShowDMXVIP(o_LiveShowDMXVIP);
            boolSuccess = true;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolSuccess;
    }

    public void closeLiveShowDMXVIP() {
        if (this.m_LiveShowDMXVIP == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowDMXVIP.close();
        LiveShowDMXSystem.removeLiveShowDMXVIP((LiveShowDMXVIP)null);
        this.m_LiveShowDMXVIP = null;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        if (this.m_LiveShowDMXVIP == p_LiveShowDMXVIP) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveShowDMXVIP != null) {
            this.m_LiveShowDMXVIP.close();
        }
        this.m_LiveShowDMXVIP = p_LiveShowDMXVIP;
        LiveShowDMXSystem.setLiveShowDMXVIP((LiveShowDMXVIP)this.m_LiveShowDMXVIP);
        if (this.m_LiveShowDMXVIP != null) {
            this.m_LiveShowDMXVIP.setFrameMaxObjects(this.m_LiveShowDMXVIP.calculateFrameMaxObjects(null));
        }
        this.m_LiveShowDesktop.eventLiveShowDMXVIP(this.m_LiveShowDMXVIP);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public LiveShowDMXVIP getLiveShowDMXVIP() {
        return this.m_LiveShowDMXVIP;
    }

    public static LiveShowDMXVIP getLiveShowVIP() {
        if (s_SelfReference == null) {
            return null;
        }
        return s_SelfReference.getLiveShowDMXVIP();
    }

    public void deleteAllJumps() {
        if (this.m_LiveShowDMXVIP == null) {
            return;
        }
        int intSceneBridgeCount = this.m_LiveShowDMXVIP.getLiveShowSceneBridgeCount();
        for (int intSceneBridge = 0; intSceneBridge < intSceneBridgeCount; ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowDMXVIP.getLiveShowSceneBridge(intSceneBridge);
            o_LiveShowSceneBridge.setJumpSceneBridge(null);
        }
    }

    public void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        LiveShowDMXSystem.setHelpFocusListener((WindowFocusListener)p_HelpFocusListener);
    }
}

