/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.Eurolite_USB_DMX_Pro_MK2_Configuration;
import GUIDPackage.HardwareGUID;
import LiveCommSerial.CommSerialPortConnection;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import LiveCommSerial.CommSerialPortException;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class Eurolite_USB_DMX_Pro_MK2
implements DMXHardwareInterface,
DMXHardwarePluginInterface,
CommSerialPortEventListener {
    public static final int SOFTWAREVERSION = 1;
    public static int s_OSFlag = -1;
    public static int s_OSARchitectureFlag = -1;
    public static final int CONNECTION_TYPE = 1;
    public static final byte MESSAGELABEL_A0 = -96;
    public static final byte MESSAGELABEL_A1 = -95;
    public static final byte MESSAGELABEL_A2 = -94;
    public static final byte MESSAGELABEL_A3 = -93;
    public static final byte MESSAGELABEL_FE = -2;
    private static final int ANSWER_UNREADY = 0;
    private static final int ANSWER_OK = 1;
    private static final int ANSWER_WRONG = 2;
    private static final int ANSWER_UNEXPECTED = 3;
    public static final int ADDRESS_FIRST = 0;
    public static final int ADDRESS_LAST = 511;
    private boolean m_HardwareCheck_OK;
    private String m_FirmwareVersion;
    private int m_DMXPluginType;
    public static final int DMXPLUGIN_COUNT = 1;
    private static final String PARAM_DIVIDER = ";";
    private String m_ID;
    private boolean m_DebugOn;
    private boolean m_DebugFailureOn;
    private ImageIcon m_IconInterface;
    private ImageIcon m_IconLogo;
    private Eurolite_USB_DMX_Pro_MK2_Configuration m_Eurolite_USB_DMX_Pro_MK2_Configuration;
    private CommSerialPortConnection m_CommSerialPortConnection;
    private int m_ConnectionStatus;
    private String m_CommPortName;
    private int m_CommBaudrate;
    private Charset m_Charset;
    private EuroliteMessage m_ActualEuroliteMessage;
    private int[] m_ArrayPluginValues;
    private int[] m_ArrayAllNewValues;
    private DMXHardwarePluginFeedbackInterface m_PluggedUniverse;
    private ArrayList<DMXHardwareFeedbackInterface> m_DMXHardwareFeedbackInterfaces;
    public static final int REQUESTTIMEOUT = 15000;
    private final Object m_SyncRequest = new Object();
    private final Object m_SyncAnswerMessage = new Object();
    private final Object m_SyncHardwareCheck = new Object();
    private RequestTimeOut m_RequestTimeOut;
    private final Object m_SyncHardwareFeedbackInterface = new Object();
    private final Object m_SyncDMXPlugins = new Object();
    private boolean m_RequestHardwareReady;
    public static ArrayList<RequestTimeOut> s_RequestTimeOuts = new ArrayList();
    public static final Object s_SyncRequestTimeOuts = new Object();

    public Eurolite_USB_DMX_Pro_MK2() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_HardwareCheck_OK = false;
        this.m_ID = HardwareGUID.getUID();
        this.m_Charset = Charset.forName("ISO-8859-15");
        this.m_ActualEuroliteMessage = null;
        this.m_PluggedUniverse = null;
        this.m_ArrayPluginValues = new int[512];
        this.m_ArrayAllNewValues = new int[512];
        this.m_RequestTimeOut = new RequestTimeOut();
        this.m_DMXHardwareFeedbackInterfaces = new ArrayList();
        this.m_DebugOn = false;
        this.m_DebugFailureOn = false;
        this.m_CommBaudrate = 250000;
        this.m_ConnectionStatus = 2;
        if (s_OSFlag <= 0) {
            Eurolite_USB_DMX_Pro_MK2.checkOS();
        }
        this.m_IconInterface = new ImageIcon(this.getClass().getResource("/Image/Interface.png"));
        this.m_IconLogo = new ImageIcon(this.getClass().getResource("/Image/Logo.png"));
        this.m_DMXPluginType = 0;
        this.m_RequestHardwareReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " close");
        }
        this.disconnect();
        CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
        if (o_CommSerialPortConnection != null) {
            o_CommSerialPortConnection.close();
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
        }
        for (int intOutput = 0; intOutput < 1; ++intOutput) {
            this.requestDMXPlugConnection(this, null);
        }
        Object object2 = this.m_SyncHardwareFeedbackInterface;
        synchronized (object2) {
            if (this.m_Eurolite_USB_DMX_Pro_MK2_Configuration != null) {
                this.m_Eurolite_USB_DMX_Pro_MK2_Configuration.close();
            }
            if (this.m_DMXHardwareFeedbackInterfaces != null) {
                this.m_DMXHardwareFeedbackInterfaces.clear();
            }
        }
        this.m_IconInterface = null;
        this.m_IconLogo = null;
    }

    @Override
    public String getID() {
        return this.m_ID;
    }

    @Override
    public void setID(String p_ID) {
        this.m_ID = p_ID == null ? HardwareGUID.getUID() : p_ID;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.m_DMXPluginType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_DMXPluginType = in.readInt();
    }

    @Override
    public ImageIcon getIconInterface() {
        return this.m_IconInterface;
    }

    @Override
    public ImageIcon getIconLogo() {
        return this.m_IconLogo;
    }

    @Override
    public void showConfigurationDialog(Frame p_Frame) {
        if (this.m_Eurolite_USB_DMX_Pro_MK2_Configuration == null) {
            this.m_Eurolite_USB_DMX_Pro_MK2_Configuration = new Eurolite_USB_DMX_Pro_MK2_Configuration(p_Frame, false, this, this.m_DebugOn);
        }
        this.m_Eurolite_USB_DMX_Pro_MK2_Configuration.setVisible(true);
        if (this.m_ConnectionStatus != 5) {
            this.m_Eurolite_USB_DMX_Pro_MK2_Configuration.refreshCommPorts();
        }
    }

    public Eurolite_USB_DMX_Pro_MK2_Configuration getConfigurationEurolite_USB_DMX_Pro_MK2() {
        return this.m_Eurolite_USB_DMX_Pro_MK2_Configuration;
    }

    @Override
    public void closeConfigurationDialog() {
        if (this.m_Eurolite_USB_DMX_Pro_MK2_Configuration != null) {
            this.m_Eurolite_USB_DMX_Pro_MK2_Configuration.setVisible(false);
        }
    }

    public static String staticInterfaceName() {
        return "<html><b>Eurolite USB DMX512 Pro MK2/Cable</b></html>";
    }

    @Override
    public String getInterfaceName() {
        return Eurolite_USB_DMX_Pro_MK2.staticInterfaceName();
    }

    @Override
    public String getInterfaceDescription() {
        return "<html>DMX USBPlugin via virtual CommPort<br>512 DMX addresses</html>";
    }

    @Override
    public int getInterfaceVersionGroup() {
        return 1;
    }

    public static String staticManufacturerName() {
        return "Eurolite";
    }

    @Override
    public String getManufacturerName() {
        return Eurolite_USB_DMX_Pro_MK2.staticManufacturerName();
    }

    @Override
    public String getManufacturerAddress() {
        return "<html><b>Steinigke Showtechnik GmbH/b><br>Andreas-Bauer-Str. 5<br>97297 Waldb\u00fcttelbrunn<br>Germany<br></html>";
    }

    @Override
    public String getManufacturerHomepage() {
        return "<html>www.steinigke.de</html>";
    }

    @Override
    public int getConnectionType() {
        return 1;
    }

    public void setComm_Port(String p_CommPortName) {
        this.m_CommPortName = p_CommPortName;
    }

    public String getComm_Port() {
        return this.m_CommPortName;
    }

    public void setComm_BaudRate(int p_BaudRate) {
        this.m_CommBaudrate = p_BaudRate;
    }

    public int getComm_BaudRate() {
        return this.m_CommBaudrate;
    }

    public int getComm_DataBits() {
        return 8;
    }

    public int getComm_StopBits() {
        return 1;
    }

    public int getComm_Parity() {
        return 0;
    }

    @Override
    public boolean connect(String p_ConnectionParam) {
        CommSerialPortConnection o_CommSerialPortConnection;
        if (this.m_CommSerialPortConnection == null) {
            this.m_CommSerialPortConnection = new CommSerialPortConnection();
            this.m_CommSerialPortConnection.addCommSerialPortEventListener((CommSerialPortEventListener)this);
        }
        if ((o_CommSerialPortConnection = this.m_CommSerialPortConnection) == null) {
            return false;
        }
        String[] arrayParams = p_ConnectionParam.split(PARAM_DIVIDER);
        if (arrayParams.length < 2) {
            return false;
        }
        this.m_CommPortName = arrayParams[0];
        this.m_CommBaudrate = Integer.valueOf(arrayParams[1]);
        if (this.m_DebugOn) {
            System.out.println("Eurolite USB DMX Pro MK2connect() Param: Port " + this.m_CommPortName + "Baud " + this.m_CommBaudrate);
        }
        boolean boolConnected = o_CommSerialPortConnection.connect(this.m_CommPortName, this.m_CommBaudrate, this.getComm_DataBits(), this.getComm_StopBits(), this.getComm_Parity());
        return boolConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect() {
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return true;
            }
            if (this.m_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " disconnect");
            }
            o_CommSerialPortConnection.disconnect();
            Object object2 = this.m_SyncAnswerMessage;
            synchronized (object2) {
                if (this.m_ActualEuroliteMessage != null) {
                    this.m_ActualEuroliteMessage.clear();
                }
                this.m_ActualEuroliteMessage = null;
            }
        }
        this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
        return true;
    }

    public boolean getIsConnected() {
        return this.m_ConnectionStatus == 5;
    }

    @Override
    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    @Override
    public int getConnectionStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return this.m_ConnectionStatus;
    }

    private void setConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        this.m_ConnectionStatus = p_ConnectionStatus;
        for (int intValue = 0; intValue < this.m_ArrayPluginValues.length; ++intValue) {
            this.m_ArrayPluginValues[intValue] = 0;
        }
        if (this.m_ConnectionStatus == 5) {
            this.setDMXPluginType(this.m_DMXPluginType);
        }
        this.fireConnectionStatus(p_ConnectionStatus, p_Remark);
    }

    @Override
    public String getConnectionParameters() {
        String stringParams = this.m_CommPortName + PARAM_DIVIDER + String.valueOf(this.m_CommBaudrate);
        return stringParams;
    }

    @Override
    public int getAddressCount() {
        return 512;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.contains(p_DMXHardwareFeedbackInterface)) {
                return;
            }
            this.m_DMXHardwareFeedbackInterfaces.add(p_DMXHardwareFeedbackInterface);
        }
        if (p_DMXHardwareFeedbackInterface != null) {
            p_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus(this, this, this.m_ConnectionStatus, this.getClass().getName() + " addDMXHardwareFeedbackInterface()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            boolRemoved = this.m_DMXHardwareFeedbackInterfaces.remove(p_DMXHardwareFeedbackInterface);
        }
    }

    @Override
    public int getDMXPluginCount() {
        return 1;
    }

    @Override
    public String getDMXPluginInfo(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return "";
        }
        return this.getDMXPluginInfo();
    }

    @Override
    public int getDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return 0;
    }

    @Override
    public boolean changeDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_DMXPlugInType) {
        return false;
    }

    @Override
    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        return o_DMXUniverseFeedbackInterface;
    }

    @Override
    public boolean requestDMXPlugConnection(DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        return this.requestDMXPlugConnection(this, p_DMXUniverseFeedbackInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestDMXPlugConnection(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXUniverseFeedbackInterface == p_DMXUniverseFeedbackInterface) {
            return true;
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPlugin(this, p_DMXHardwarePluginInterface, null);
        }
        Object object = this.m_SyncRequest;
        synchronized (object) {
            Object object2 = this.m_SyncDMXPlugins;
            synchronized (object2) {
                this.m_PluggedUniverse = p_DMXUniverseFeedbackInterface;
            }
        }
        if (p_DMXUniverseFeedbackInterface != null) {
            p_DMXUniverseFeedbackInterface.eventPlugin(this, p_DMXHardwarePluginInterface, p_DMXUniverseFeedbackInterface);
        }
        this.firePlugStatus(p_DMXHardwarePluginInterface, o_DMXUniverseFeedbackInterface, p_DMXUniverseFeedbackInterface);
        if (this.m_PluggedUniverse != null) {
            switch (this.m_DMXPluginType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.fireReadValuesSuccess(p_DMXHardwarePluginInterface, this.m_ArrayPluginValues);
                }
            }
        }
        return true;
    }

    @Override
    public int[] getDMXPluginValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return this.m_ArrayPluginValues;
    }

    @Override
    public void setDebugOn(boolean p_DebugOn) {
        this.m_DebugOn = p_DebugOn;
    }

    @Override
    public void setDebugFailureOn(boolean p_DebugOn) {
        this.m_DebugFailureOn = p_DebugOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestCheckHardware() {
        this.m_HardwareCheck_OK = false;
        boolean boolError = false;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            long longTimeUsed;
            CommSerialPortConnection.ByteArray_Write o_SendBytes;
            RequestTimeOut o_RequestTimeOut = Eurolite_USB_DMX_Pro_MK2.getPool_RequestTimeOut();
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.m_DebugOn) {
                System.out.println("Eurolite_USB_DMX_Pro_MK2 requestCheckHardware");
            }
            if ((o_SendBytes = this.getByteCode_CheckHardware()) == null) {
                return false;
            }
            try {
                Object object2 = this.m_SyncHardwareCheck;
                synchronized (object2) {
                    this.m_RequestHardwareReady = false;
                    this.m_CommSerialPortConnection.sendBreak();
                    o_CommSerialPortConnection.write(o_SendBytes);
                    o_RequestTimeOut.start();
                    while (!this.m_RequestHardwareReady) {
                        long longWaitStart;
                        for (long longWaitTime = 15000L; longWaitTime > 0L && !this.m_RequestHardwareReady; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                            longWaitStart = System.nanoTime() / 1000000L;
                            this.m_SyncHardwareCheck.wait(longWaitTime);
                        }
                        if (!o_RequestTimeOut.isTimedOut(15000L)) continue;
                    }
                    longTimeUsed = o_RequestTimeOut.stop();
                    o_RequestTimeOut.close();
                }
            }
            catch (InterruptedException e_InterruptedException) {
                if (this.m_DebugOn) {
                    System.out.println("Eurolite USB DMX Pro MK2 requestCheckHardware InterruptedException");
                }
                return false;
            }
            if (longTimeUsed >= 15000L) {
                if (this.m_DebugOn || this.m_DebugFailureOn) {
                    System.out.println("Eurolite USB DMX Pro MK2 requestCheckHardware TimedOut");
                }
                boolError = true;
            }
        }
        if (boolError) {
            this.fireCheckConnectionFailed(910, "Request Check Connection TimeOut");
            return false;
        }
        if (this.m_HardwareCheck_OK) {
            try {
                Thread.sleep(3500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireCheckConnectionSuccess();
            return true;
        }
        return false;
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_CheckHardware() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)2);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            o_ByteCode[0] = -103;
            o_ByteCode[1] = 32;
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_CheckHardware(EuroliteMessage p_EuroliteMessage) {
        boolean boolOk = true;
        if (p_EuroliteMessage == null) {
            this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
            boolOk = false;
        }
        if (boolOk && p_EuroliteMessage.getMessageLabel() != -2) {
            this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
            boolOk = false;
        }
        int intMessageDataLength = 0;
        byte[] o_DataArray = null;
        if (boolOk) {
            intMessageDataLength = p_EuroliteMessage.getMessageDataLength();
            o_DataArray = p_EuroliteMessage.getMessageDataArray();
            if (o_DataArray == null || intMessageDataLength < 3 || o_DataArray.length != intMessageDataLength) {
                this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
                boolOk = false;
            }
        }
        if (boolOk) {
            String stringSoftwareVersion;
            this.m_FirmwareVersion = stringSoftwareVersion = new String(o_DataArray, Charset.forName("ISO-8859-15"));
        }
        this.m_HardwareCheck_OK = boolOk;
        Object object = this.m_SyncHardwareCheck;
        synchronized (object) {
            this.m_RequestHardwareReady = true;
            this.m_SyncHardwareCheck.notifyAll();
        }
        return boolOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCheckConnectionFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck(this, false, p_Remark);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, 910, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCheckConnectionSuccess() {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            this.m_RequestHardwareReady = true;
            this.m_HardwareCheck_OK = true;
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck(this, true, "");
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionSuccess");
        }
        this.setConnectionStatus(5, this.getClass().getName() + " fireCheckConnectionSuccess()");
    }

    @Override
    public boolean requestHardwareInfo() {
        if (!this.m_HardwareCheck_OK) {
            this.fireHardwareInfoFailed(900, "Hardware Not Checked");
            return false;
        }
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        o_StringBuffer.append("Eurolite USB DMX Pro MK2");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("SoftwareVersion: ");
        o_StringBuffer.append(this.m_FirmwareVersion);
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</html>");
        this.fireHardwareInfoSuccess(o_StringBuffer.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInfoFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireHardwareInfoFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInfoSuccess(String p_Info) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareInfo(this, p_Info);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin(int p_Index) {
        return this;
    }

    @Override
    public boolean requestWriteValues(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        return this.requestWriteValues(this, p_ChangedAddresses, p_AllValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestWriteValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        if (this.m_DMXPluginType == 1) {
            return false;
        }
        if (p_AllValues == null) {
            return false;
        }
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        int intAddressCount = p_ChangedAddresses.size();
        if (intAddressCount <= 0) {
            return true;
        }
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        if (this.m_ArrayAllNewValues == null) {
            this.m_ArrayAllNewValues = new int[p_AllValues.length];
        }
        System.arraycopy(p_AllValues, 0, this.m_ArrayAllNewValues, 0, p_AllValues.length);
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        if (o_DMXHardwarePluginFeedbackInterface == null) {
            return false;
        }
        boolean boolError = false;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (o_DMXHardwarePluginFeedbackInterface == null) {
                return false;
            }
            CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_WriteValuesMultiple(0, 511, this.m_ArrayAllNewValues);
            if (o_SendBytes == null) {
                return false;
            }
            try {
                Object object2 = this.m_SyncHardwareCheck;
                synchronized (object2) {
                    o_CommSerialPortConnection.write(o_SendBytes);
                    this.m_RequestTimeOut.start();
                    this.m_RequestTimeOut.stop();
                }
            }
            catch (Exception e_Exception) {
                if (this.m_DebugOn) {
                    System.out.println("Eurolite requestWriteValues InterruptedException");
                }
                return false;
            }
            if (this.m_RequestTimeOut.isTimedOut(15000L)) {
                if (this.m_DebugOn || this.m_DebugFailureOn) {
                    System.out.println("Eurolite requestWriteValues TimedOut");
                }
                boolError = true;
            }
        }
        if (boolError) {
            this.fireWriteValuesFailed(this, 952, "Write Values multiple timeout");
            return false;
        }
        return this.parseAnswer_WriteValuesMultiple(p_DMXHardwarePluginInterface, 0, 511, p_AllValues);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_WriteValuesMultiple(int p_AddressFirst, int p_AddressLast, int[] p_AllValues) {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)518);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            o_ByteCode[0] = 126;
            o_ByteCode[1] = 6;
            o_ByteCode[2] = 1;
            o_ByteCode[3] = 2;
        }
        catch (Exception e) {
            return null;
        }
        o_ByteCode[4] = 0;
        for (int intByte = 0; intByte < 512; ++intByte) {
            o_ByteCode[intByte + 5] = (byte)(p_AllValues[intByte] & 0xFF);
        }
        o_ByteCode[517] = -25;
        return o_ByteArray_Write;
    }

    public boolean parseAnswer_WriteValuesMultiple(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddress, int p_EndAddress, int[] p_AllValues) {
        int intAddressCount = p_EndAddress - p_StartAddress + 1;
        System.arraycopy(p_AllValues, p_StartAddress, this.m_ArrayPluginValues, p_StartAddress, intAddressCount);
        this.fireWriteValuesSuccess(p_DMXHardwarePluginInterface, this.m_ArrayPluginValues);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed");
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginException(this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginWriteValues(this, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
        }
    }

    @Override
    public boolean requestReadValues(ArrayList<Integer> p_Addresses) {
        return this.requestReadValues(this, p_Addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestReadValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses) {
        if (this.m_DMXPluginType == 0) {
            return false;
        }
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        if (o_DMXHardwarePluginFeedbackInterface == null) {
            return false;
        }
        boolean boolError = false;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (o_DMXHardwarePluginFeedbackInterface == null) {
                return false;
            }
            CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_ReadValuesOnlyChanged();
            if (o_SendBytes == null) {
                return false;
            }
            try {
                Object object2 = this.m_SyncHardwareCheck;
                synchronized (object2) {
                    o_CommSerialPortConnection.write(o_SendBytes);
                    this.m_RequestTimeOut.start();
                    this.m_RequestTimeOut.stop();
                }
            }
            catch (Exception e_Exception) {
                if (this.m_DebugOn) {
                    System.out.println("Eurolite requestWriteValues InterruptedException");
                }
                return false;
            }
            if (this.m_RequestTimeOut.isTimedOut(15000L)) {
                if (this.m_DebugOn || this.m_DebugFailureOn) {
                    System.out.println("Eurolite requestWriteValues TimedOut");
                }
                boolError = true;
            }
        }
        if (boolError) {
            this.fireReadValuesFailed(this, 952, "Write Values multiple timeout");
            return false;
        }
        return true;
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_ReadValuesOnlyChanged() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)6);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            o_ByteCode[0] = 126;
            o_ByteCode[1] = 8;
            o_ByteCode[2] = 1;
            o_ByteCode[3] = 0;
        }
        catch (Exception e) {
            return null;
        }
        o_ByteCode[4] = 1;
        o_ByteCode[5] = -25;
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReadValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXIntput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadValuesFailed");
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginException(this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReadValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginReadValues(this, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
        }
    }

    @Override
    public int getPluginIndex() {
        return 0;
    }

    @Override
    public DMXHardwareInterface getDMXHardwareInterface() {
        return this;
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin_Output(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin_Input(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    @Override
    public String getDMXPluginInfo() {
        StringBuilder stringInfo = new StringBuilder();
        stringInfo.append(this.getPluginIndex() + 1);
        stringInfo.append(") ");
        if (this.m_DMXPluginType == 0) {
            stringInfo.append("Output");
        } else {
            stringInfo.append("Input");
        }
        return stringInfo.toString();
    }

    public void setDMXPluginType(int p_DMXPluginType) {
        boolean boolChanged = false;
        CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
        switch (p_DMXPluginType) {
            case 0: {
                if (this.m_DMXPluginType != p_DMXPluginType) {
                    boolChanged = true;
                }
                this.m_DMXPluginType = p_DMXPluginType;
                break;
            }
            case 1: {
                if (this.m_DMXPluginType != p_DMXPluginType) {
                    boolChanged = true;
                }
                this.m_DMXPluginType = p_DMXPluginType;
                break;
            }
        }
        if (boolChanged) {
            this.fireHardwareInterfacePluginChanged(this);
            for (int intIndex = 0; intIndex < this.m_ArrayPluginValues.length; ++intIndex) {
                this.m_ArrayPluginValues[intIndex] = 0;
            }
        }
        switch (this.m_DMXPluginType) {
            case 0: {
                if (o_CommSerialPortConnection == null) break;
                CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_WriteValuesMultiple(0, 511, this.m_ArrayPluginValues);
                o_CommSerialPortConnection.write(o_SendBytes);
                break;
            }
            case 1: {
                if (o_CommSerialPortConnection == null) break;
                CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_ReadValuesOnlyChanged();
                o_CommSerialPortConnection.write(o_SendBytes);
            }
        }
    }

    @Override
    public int getDMXPluginType() {
        return this.m_DMXPluginType;
    }

    @Override
    public boolean changeDMXPluginType(int p_DMXPlugInType) {
        return true;
    }

    @Override
    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse() {
        return this.m_PluggedUniverse;
    }

    @Override
    public int[] getDMXPluginValues() {
        return this.m_ArrayPluginValues;
    }

    @Override
    public void propertyChanged(DMXHardwarePluginFeedbackInterface p_DMXHardwarePluginFeedbackInterface) {
        this.fireHardwareInterfacePluginChanged(this);
    }

    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
        if (this.m_DebugOn) {
            System.out.println("DMX4All_MiniUSBDMXInterface Comm Connection: " + p_ConnectionStatus);
        }
        switch (p_ConnectionStatus) {
            case 0: {
                this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.remove(this);
                break;
            }
            case 1: {
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.add(this);
                this.setConnectionStatus(4, this.getClass().getName() + " eventCommSerialPortConnection()");
            }
        }
    }

    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
    }

    private void parseEuroliteMessage(EuroliteMessage p_EuroliteMessage) {
        if (p_EuroliteMessage == null) {
            return;
        }
        byte byteMessageLabel = p_EuroliteMessage.getMessageLabel();
        switch (byteMessageLabel) {
            case -96: {
                break;
            }
            case -95: {
                break;
            }
            case -94: {
                break;
            }
            case -93: {
                break;
            }
            case -2: {
                this.parseAnswer_CheckHardware(p_EuroliteMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseReceivedBytes(byte[] p_BytesReadenAll, int p_DataLenght) {
        if (p_BytesReadenAll == null) {
            return;
        }
        if (p_DataLenght <= 0) {
            return;
        }
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
            int intByteOffset = 0;
            while (intByteOffset < p_DataLenght) {
                if (this.m_ActualEuroliteMessage == null) {
                    this.m_ActualEuroliteMessage = new EuroliteMessage();
                }
                intByteOffset = this.m_ActualEuroliteMessage.parseBytes(p_BytesReadenAll, intByteOffset, p_DataLenght);
                if (!this.m_ActualEuroliteMessage.getMessageReady()) continue;
                this.parseEuroliteMessage(this.m_ActualEuroliteMessage);
                this.m_ActualEuroliteMessage.clear();
            }
        }
    }

    public void eventCommSerialPortDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
        this.parseReceivedBytes(p_BytesReadenAll, p_DataLenght);
    }

    public void eventCommSerialPortException(Exception p_Exception) {
        if (this.m_DebugOn) {
            System.out.println("Comm Exception: " + p_Exception.toString());
        }
        CommSerialPortException o_CommSerialPortException = (CommSerialPortException)p_Exception;
        switch (o_CommSerialPortException.getExceptionType()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 256: {
                this.fireException(910, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 32: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus(this, this, p_ConnectionStatus, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        Object object2 = this.m_SyncDMXPlugins;
        synchronized (object2) {
            o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this);
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPluginConnectionStatus(this, this, p_ConnectionStatus, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePlugStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePlugin(this, p_DMXHardwarePluginInterface, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInterfacePluginChanged(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginChanged(this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        if (o_DMXHardwarePluginFeedbackInterface != null) {
            o_DMXHardwarePluginFeedbackInterface.eventPluginChanged(this, p_DMXHardwarePluginInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        Object object2 = this.m_SyncDMXPlugins;
        synchronized (object2) {
            o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this);
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPluginException(this, null, p_ExceptionType, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestTimeOut getPool_RequestTimeOut() {
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            if (s_RequestTimeOuts.size() <= 0) {
                RequestTimeOut o_RequestTimeOut = new RequestTimeOut();
                return o_RequestTimeOut;
            }
            RequestTimeOut o_RequestTimeOut = s_RequestTimeOuts.get(s_RequestTimeOuts.size() - 1);
            s_RequestTimeOuts.remove(s_RequestTimeOuts.size() - 1);
            o_RequestTimeOut.initMembers();
            return o_RequestTimeOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPool_RequestTimeOut(RequestTimeOut p_RequestTimeOut) {
        if (p_RequestTimeOut == null) {
            return;
        }
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            s_RequestTimeOuts.add(p_RequestTimeOut);
        }
    }

    @Override
    public boolean requestWriteMIDIMessage(byte[] p_MIDIBytes) {
        return false;
    }

    public static int checkOS() {
        String stringOS = System.getProperty("os.name").toLowerCase();
        s_OSFlag = stringOS.indexOf("win") >= 0 ? (stringOS.indexOf("10") >= 0 ? 5 : (stringOS.indexOf("8") >= 0 ? 4 : (stringOS.indexOf("7") >= 0 ? 3 : (stringOS.indexOf("vista") >= 0 ? 2 : (stringOS.indexOf("xp") >= 0 ? 1 : 0))))) : (stringOS.indexOf("mac") >= 0 ? 1000 : (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0 ? 100 : (stringOS.indexOf("sunos") >= 0 ? 10000 : -1)));
        return s_OSFlag;
    }

    public static class EuroliteMessage {
        public static byte STARTBYTE = (byte)104;
        public static byte STARTBYTE_CHECKHARDWARE = (byte)-104;
        public static byte ENDBYTE = (byte)104;
        private byte m_MessageStartByte;
        private boolean m_MessageStartByte_IsSet;
        private byte m_MessageEndByte;
        private boolean m_MessageEndByte_IsSet;
        private byte m_MessageLabel;
        private boolean m_MessageLabel_IsSet;
        private byte m_MessageDirection;
        private boolean m_MessageDirectionIsSet;
        private byte m_MessageDataLength_LSB;
        private boolean m_MessageLength_LSB_IsSet;
        private byte m_MessageDataLength_MSB;
        private boolean m_MessageLength_MSB_IsSet;
        private int m_MessageDataLength;
        private byte m_MessageChecksum;
        private boolean m_MessageChecksum_IsSet;
        private byte[] m_MessageDataArray;
        private int m_MessageDataBytesReceived;
        private boolean m_MessageReady;

        public EuroliteMessage() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_MessageStartByte = 0;
            this.m_MessageStartByte_IsSet = false;
            this.m_MessageEndByte = 0;
            this.m_MessageEndByte_IsSet = false;
            this.m_MessageLabel = 0;
            this.m_MessageLabel_IsSet = false;
            this.m_MessageDirection = 0;
            this.m_MessageDirectionIsSet = false;
            this.m_MessageDataLength_LSB = 0;
            this.m_MessageLength_LSB_IsSet = false;
            this.m_MessageDataLength_MSB = 0;
            this.m_MessageLength_MSB_IsSet = false;
            this.m_MessageDataLength = 0;
            this.m_MessageChecksum = 0;
            this.m_MessageChecksum_IsSet = false;
            this.m_MessageDataArray = null;
            this.m_MessageDataBytesReceived = 0;
            this.m_MessageReady = false;
        }

        public void clear() {
            this.m_MessageStartByte = 0;
            this.m_MessageStartByte_IsSet = false;
            this.m_MessageEndByte = 0;
            this.m_MessageEndByte_IsSet = false;
            this.m_MessageLabel = 0;
            this.m_MessageLabel_IsSet = false;
            this.m_MessageDirectionIsSet = false;
            this.m_MessageDirection = 0;
            this.m_MessageDataLength_LSB = 0;
            this.m_MessageLength_LSB_IsSet = false;
            this.m_MessageDataLength_MSB = 0;
            this.m_MessageLength_MSB_IsSet = false;
            this.m_MessageDataLength = 0;
            this.m_MessageChecksum = 0;
            this.m_MessageChecksum_IsSet = false;
            this.m_MessageDataArray = null;
            this.m_MessageDataBytesReceived = 0;
            this.m_MessageReady = false;
        }

        public int parseBytes(byte[] p_BytesReadenAll, int p_Offset, int p_DataLenght) {
            if (p_BytesReadenAll == null) {
                return -1;
            }
            if (p_DataLenght <= 0) {
                return -1;
            }
            int intBytesOffset = p_Offset;
            if (intBytesOffset < p_DataLenght && !this.m_MessageStartByte_IsSet) {
                this.m_MessageStartByte = p_BytesReadenAll[intBytesOffset];
                ++intBytesOffset;
                if (this.m_MessageStartByte != STARTBYTE && this.m_MessageStartByte != STARTBYTE_CHECKHARDWARE) {
                    while (intBytesOffset < p_DataLenght - 1 && this.m_MessageStartByte != STARTBYTE && this.m_MessageStartByte != STARTBYTE_CHECKHARDWARE) {
                        this.m_MessageStartByte = p_BytesReadenAll[intBytesOffset];
                        ++intBytesOffset;
                    }
                    if (Math.abs(this.m_MessageStartByte) != STARTBYTE && this.m_MessageStartByte != STARTBYTE_CHECKHARDWARE) {
                        return intBytesOffset;
                    }
                }
                this.m_MessageStartByte_IsSet = true;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageDirectionIsSet) {
                this.m_MessageDirection = p_BytesReadenAll[intBytesOffset];
                this.m_MessageDirectionIsSet = true;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLabel_IsSet) {
                this.m_MessageLabel = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLabel_IsSet = true;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLength_LSB_IsSet) {
                this.m_MessageDataLength_LSB = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLength_LSB_IsSet = true;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLength_MSB_IsSet) {
                this.m_MessageDataLength_MSB = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLength_MSB_IsSet = true;
                ++intBytesOffset;
                this.m_MessageDataLength = Byte.toUnsignedInt(this.m_MessageDataLength_MSB) * 256 + Byte.toUnsignedInt(this.m_MessageDataLength_LSB);
                if (this.m_MessageDataLength > 0) {
                    this.m_MessageDataArray = new byte[this.m_MessageDataLength];
                    this.m_MessageDataBytesReceived = 0;
                }
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageChecksum_IsSet) {
                this.m_MessageChecksum = p_BytesReadenAll[intBytesOffset];
                this.m_MessageChecksum_IsSet = true;
                ++intBytesOffset;
            }
            while (intBytesOffset < p_DataLenght && this.m_MessageDataBytesReceived < this.m_MessageDataLength) {
                this.m_MessageDataArray[this.m_MessageDataBytesReceived] = p_BytesReadenAll[intBytesOffset];
                ++this.m_MessageDataBytesReceived;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageEndByte_IsSet) {
                this.m_MessageEndByte = p_BytesReadenAll[intBytesOffset];
                if (Math.abs(this.m_MessageEndByte) != ENDBYTE) {
                    // empty if block
                }
                this.m_MessageEndByte_IsSet = true;
                ++intBytesOffset;
                this.m_MessageReady = true;
            }
            return intBytesOffset;
        }

        public boolean getMessageReady() {
            return this.m_MessageReady;
        }

        public byte getMessageLabel() {
            return this.m_MessageLabel;
        }

        public int getMessageDataLength() {
            return this.m_MessageDataLength;
        }

        public byte[] getMessageDataArray() {
            return this.m_MessageDataArray;
        }
    }

    public static class RequestTimeOut {
        Long m_DateStart;
        Long m_DateEnd;
        boolean m_Closed;
        final Object m_SyncObject = new Object();

        public RequestTimeOut() {
            this.initMembers();
        }

        public void initMembers() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                Eurolite_USB_DMX_Pro_MK2.addPool_RequestTimeOut(this);
            }
        }

        public void start() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
        }

        public long stop() {
            this.m_DateEnd = System.nanoTime() / 1000000L;
            return this.getTimeUsed();
        }

        public boolean isTimedOut(long p_MillisecondsOfAllowedDuration) {
            return this.m_DateEnd != null ? this.m_DateEnd - this.m_DateStart >= p_MillisecondsOfAllowedDuration : System.nanoTime() / 1000000L - this.m_DateStart >= p_MillisecondsOfAllowedDuration;
        }

        public long getTimeUsed() {
            if (this.m_DateEnd != null) {
                return this.m_DateEnd - this.m_DateStart;
            }
            return System.nanoTime() / 1000000L - this.m_DateStart;
        }
    }
}

