/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import SwingComponents.MouseAdapter_Delayed;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JControlSlider
extends ControlObject
implements Externalizable {
    public static final String PROP_TRACKINSETS = "trackInsets";
    public static final String PROP_TRACKSLOTWIDTH = "trackSlotWidth";
    public static final String PROP_TRACKSLOTVISIBLE = "trackSlotVisible";
    public static final String PROP_ADJUSTERLENGTH = "adjusterLength";
    public static final String PROP_ADJUSTERCOLOR = "adjusterColor";
    public static final String PROP_ADJUSTERIMAGE = "adjusterImage";
    protected SliderTrack m_Track;
    protected ControlObject.ControlDimension m_ControlDimension;

    public JControlSlider() {
        this.initMembers();
        this.initComponents();
        this.calculateInnerItems();
    }

    private void initMembers() {
        this.setName("JControlSlider");
        this.m_ControlDimension = super.createNewControlDimension();
        this.m_ControlDimension.setDimensionName("Slider");
        this.m_ControlDimension.setOrientation(1);
        this.m_ControlDimension.getControlBlocks().setBlocksTextRotation(-90.0);
        this.m_ControlDimension.setTicksAlignment(0);
        this.m_ControlDimension.setLabelsAlignment(2);
        this.m_ControlDimension.setBlocksAlignment(2);
        this.m_ControlDimension.setLabelsMirrored(true);
        this.m_Track = new SliderTrack(this);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        this.setPreferredSize(new Dimension(50, 170));
    }

    private Object readResolve() {
        this.m_ControlDimension = this.getControlDimension(0);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        super.writeExternal(p_ObjectOutput);
        this.m_ControlDimension.writeExternal(p_ObjectOutput);
        this.m_Track.writeExternal(p_ObjectOutput);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        super.readExternal(p_ObjectInput);
        this.m_ControlDimension.readExternal(p_ObjectInput);
        this.m_Track.readExternal(p_ObjectInput);
        this.calculateInnerItems();
    }

    private void initComponents() {
        this.add(this.m_Track, this.m_Track.getConstraints(), 0);
        this.setVisible(true);
    }

    @Override
    public void setToolTipText(String p_ToolTipText) {
        super.setToolTipText(p_ToolTipText);
        if (this.m_Track == null) {
            return;
        }
        this.m_Track.setToolTipText(p_ToolTipText);
        this.m_Track.getAdjuster().setToolTipText(p_ToolTipText);
    }

    @Override
    public void setForeground(Color p_Color) {
        this.m_Track.setForeground(p_Color);
        super.setForeground(p_Color);
    }

    public ControlObject.ControlDimension getControlDimension() {
        return this.m_ControlDimension;
    }

    public void setMouseMoveFactor(double p_MouseMoveFactor) {
        this.m_ControlDimension.setMouseMoveFactor(p_MouseMoveFactor);
    }

    public double getMouseMoveFactor() {
        return this.m_ControlDimension.getMouseMoveFactor();
    }

    @Override
    public double[] getValuesFromInnerComponentPosition(JComponent p_Component, int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_Track.getX() + p_Component.getX(), p_Y - this.m_Track.getY() + p_Component.getY());
    }

    @Override
    public double[] getValuesFromComponentPosition(int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_Track.getX(), p_Y - this.m_Track.getY());
    }

    public double[] getValuesFromTrackPosition(int p_X, int p_Y) {
        int intLength = 1;
        int intPosition = 0;
        double[] doubleResults = new double[1];
        if (this.m_ControlDimension.getOrientation() == 1) {
            int intOffset = this.getAdjusterLength() / 2;
            intLength = this.m_Track.getSize().height - this.getAdjusterLength();
            intPosition = p_Y - intOffset;
            if (!this.m_ControlDimension.getInverted()) {
                intPosition = intLength - intPosition;
            }
        } else {
            int intOffset = this.getAdjusterLength() / 2;
            intLength = this.m_Track.getSize().width - this.getAdjusterLength();
            intPosition = p_X - intOffset;
            if (this.m_ControlDimension.getInverted()) {
                intPosition = intLength - intPosition;
            }
        }
        doubleResults[0] = this.m_ControlDimension.getValueMinimum() + (double)intPosition / (double)intLength * (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
        return doubleResults;
    }

    @Override
    public void setJarResources(JarResources p_JarResources) {
        JarResources oldValue = this.m_Resources;
        this.m_Resources = p_JarResources;
        if (this.m_Resources != null) {
            Image o_Image = null;
            byte[] o_Bytes = this.m_IsMaster ? this.m_Resources.getResource("LiveShowControls/ControlSliderAdjusterMainImage") : this.m_Resources.getResource("LiveShowControls/ControlSliderAdjusterImage");
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAdjusterImage(o_Image);
            o_Image = null;
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlSliderBackground");
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = this.m_Resources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("Control_Foreground");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.setForeground(o_Color);
                    o_Field = o_Class.getDeclaredField("Control_Background");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.setAdjusterImage(null);
            this.setBackgroundImage(null);
        }
        this.firePropertyChange("jarResources", oldValue, this.m_Resources);
        this.revalidate();
        this.repaint();
    }

    public Insets getTrackInsets() {
        return this.m_Track.getTrackInsets();
    }

    public void setTrackInsets(Insets p_Insets) {
        this.m_Track.setTrackInsets(p_Insets);
    }

    public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
        this.m_Track.setTrackInsets(p_Top, p_Left, p_Bottom, p_Right);
    }

    public int getTrackSlotWidth() {
        return this.m_Track.getTrackSlotWidth();
    }

    public void setTrackSlotWidth(int p_TrackSlotWidth) {
        this.m_Track.setTrackSlotWidth(p_TrackSlotWidth);
    }

    public boolean getTrackSlotVisible() {
        return this.m_Track.getTrackSlotVisible();
    }

    public void setTrackSlotVisible(boolean p_Visible) {
        this.m_Track.setTrackSlotVisible(p_Visible);
    }

    @Override
    public void calculateDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
    }

    public int getAdjusterLength() {
        return this.m_Track.getAdjuster().getAdjusterLength();
    }

    public void setAdjusterLength(int p_AdjusterLength) {
        this.m_Track.getAdjuster().setAdjusterLength(p_AdjusterLength);
        this.calculateInnerItems();
    }

    public Image getAdjusterImage() {
        return this.m_Track.getAdjuster().getAdjusterImage();
    }

    public void setAdjusterImage(Image p_AdjusterImage) {
        this.m_Track.getAdjuster().setAdjusterImage(p_AdjusterImage);
    }

    public Color getAdjusterColor() {
        return this.m_Track.getAdjuster().getAdjusterColor();
    }

    public void setAdjusterColor(Color p_AdjusterColor) {
        this.m_Track.getAdjuster().setAdjusterColor(p_AdjusterColor);
    }

    @Override
    public void calculateInnerItems() {
        if (this.m_Track == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_TrackInsets = this.m_Track.getTrackInsets();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        o_TrackConstraints.width = o_ThisRectangle.width - o_TrackInsets.left - o_TrackInsets.right;
        o_TrackConstraints.height = o_ThisRectangle.height - o_TrackInsets.top - o_TrackInsets.bottom;
        o_TrackConstraints.x = o_TrackInsets.left;
        o_TrackConstraints.y = o_TrackInsets.top;
        this.calculateAdjuster();
        this.m_ControlDimension.calculateDisplayItems();
        this.m_ControlDimension.getControlTicks().calculate();
        this.m_ControlDimension.recalculateControlLabels();
        this.m_ControlDimension.getControlBlocks().calculate();
        this.m_ControlDimension.getControlLabels().calculate();
    }

    @Override
    public double calculatePixelPerValueLabel(ControlObject.ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return -1.0;
        }
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        int intValueLength = p_ControlDimension.getOrientation() == 1 ? o_TrackConstraints.getHeight() - this.getAdjusterLength() : o_TrackConstraints.getWidth() - this.getAdjusterLength();
        double doublePixelPerValue = (double)intValueLength / (p_ControlDimension.getValueMaximum() - p_ControlDimension.getValueMinimum());
        return doublePixelPerValue;
    }

    @Override
    public void calculateAdjuster() {
        if (this.m_Track != null) {
            this.m_Track.calculateAdjuster();
        }
        this.m_ControlDimension.setValueAdjusted(this.m_ControlDimension.getValue());
    }

    @Override
    public void calculateTicks(ControlObject.ControlTicks p_Ticks) {
        if (p_Ticks == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_TicksInsets = p_Ticks.getTicksInsets();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        o_TicksConstraints.width = o_ThisRectangle.width - o_TicksInsets.left - o_TicksInsets.right;
        o_TicksConstraints.height = o_ThisRectangle.height - o_TicksInsets.top - o_TicksInsets.bottom;
        o_TicksConstraints.x = o_TicksInsets.left;
        o_TicksConstraints.y = o_TicksInsets.top;
        p_Ticks.revalidate();
    }

    @Override
    public void paintTicks(Graphics p_Graphics, ControlObject.ControlTicks p_Ticks) {
        int intTrackValuePos;
        double doubleValue;
        int intPixelWide;
        int intTickLength;
        int intTickStart;
        double doubleJump;
        int intPassCount;
        int intValueLength;
        int intOffset;
        if (p_Ticks == null) {
            return;
        }
        if (p_Ticks.getTicksMajor() <= 0.0 && p_Ticks.getTicksMinor() <= 0.0) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = p_Ticks.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_TicksConstraints.getY() + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getHeight() - this.getAdjusterLength();
        } else {
            intOffset = o_TrackConstraints.getX() - o_TicksConstraints.getX() + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getWidth() - this.getAdjusterLength();
        }
        if (intValueLength <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)p_Graphics.create();
        g2d.setColor(this.getForeground());
        double doubleDistance = this.calculatePixelPerValueLabel(o_ControlDimension);
        int intTickLongest = p_Ticks.getTicksMajorLength() > p_Ticks.getTicksMinorLength() ? p_Ticks.getTicksMajorLength() : p_Ticks.getTicksMinorLength();
        if (p_Ticks.getTicksMajor() > 0.0 && p_Ticks.getTicksMajorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMajor() < 7.0) {
                intPassCount = (int)(7.0 / (doubleDistance * p_Ticks.getTicksMajor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMajor() * (double)intPassCount;
            p_Ticks.setTicksMajorPassCount(intPassCount);
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMajorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        if (p_Ticks.getTicksMinor() > 0.0 && p_Ticks.getTicksMinorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMinor() < 5.0) {
                intPassCount = (int)(5.0 / (doubleDistance * p_Ticks.getTicksMinor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMinor() * (double)intPassCount;
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMinorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        g2d.dispose();
    }

    @Override
    public void calculateLabels(ControlObject.ControlLabels p_Labels) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Labels == null) {
            return;
        }
        if (this.m_Track == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Labels.getControlDimension();
        Insets o_LabelsInsets = p_Labels.getLabelsInsets();
        AbsoluteConstraints o_LabelsConstraints = p_Labels.getConstraints();
        o_LabelsConstraints.width = o_ThisRectangle.width - o_LabelsInsets.left - o_LabelsInsets.right;
        o_LabelsConstraints.height = o_ThisRectangle.height - o_LabelsInsets.top - o_LabelsInsets.bottom;
        o_LabelsConstraints.x = o_LabelsInsets.left;
        o_LabelsConstraints.y = o_LabelsInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        double doubleLabelFactor1 = 1.0;
        double doubleLabelFactor2 = 1.0;
        double doubleLabelFactor = 1.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_LabelsConstraints.y + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getHeight() - this.getAdjusterLength();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.width / (double)p_Labels.getLabelsSize().width;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().height;
        } else {
            intOffset = o_TrackConstraints.getX() - o_LabelsConstraints.x + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getWidth() - this.getAdjusterLength();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.height / (double)p_Labels.getLabelsSize().height;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().width;
        }
        if (doubleLabelFactor2 <= 0.0) {
            doubleLabelFactor2 = doubleLabelFactor1;
        }
        if (!p_Labels.getLabelsSizeFixed()) {
            doubleLabelFactor = doubleLabelFactor1 < doubleLabelFactor2 ? doubleLabelFactor1 : doubleLabelFactor2;
            if (doubleLabelFactor > 1.0) {
                doubleLabelFactor = 1.0;
            }
        } else {
            doubleLabelFactor = 1.0;
        }
        for (int intLabel = 0; intLabel < p_Labels.getControlLabelsCount(); ++intLabel) {
            int intLabelStart;
            ControlObject.ControlLabels.ControlLabel o_ControlLabel = p_Labels.getControlLabel(intLabel);
            if (o_ControlLabel == null) continue;
            AbsoluteConstraints o_LabelConstraints = o_ControlLabel.getConstraints();
            int intLabelPos = (int)(doubleDistance * (o_ControlLabel.getControlLabelDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            o_LabelConstraints.width = (int)((double)p_Labels.getLabelsSize().width * doubleLabelFactor);
            o_LabelConstraints.height = (int)((double)p_Labels.getLabelsSize().height * doubleLabelFactor);
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intLabelPos = intValueLength - intLabelPos;
                }
                intLabelPos -= o_LabelConstraints.height / 2;
                if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(2);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(4);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                    intLabelStart = o_LabelsConstraints.width - o_LabelConstraints.width;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(4);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(2);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_LabelsConstraints.width / 2 - o_LabelConstraints.width / 2;
                    o_ControlLabel.setHorizontalAlignment(0);
                    o_ControlLabel.setVerticalAlignment(0);
                }
                o_LabelConstraints.x = intLabelStart;
                o_LabelConstraints.y = intLabelPos + intOffset;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intLabelPos = intValueLength - intLabelPos;
            }
            intLabelPos -= o_LabelConstraints.width / 2;
            if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(1);
                } else {
                    o_ControlLabel.setVerticalAlignment(3);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                intLabelStart = o_LabelsConstraints.height - o_LabelConstraints.height;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(3);
                } else {
                    o_ControlLabel.setVerticalAlignment(1);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_LabelsConstraints.height / 2 - o_LabelConstraints.height / 2;
                o_ControlLabel.setVerticalAlignment(0);
                o_ControlLabel.setHorizontalAlignment(0);
            }
            o_LabelConstraints.x = intLabelPos + intOffset;
            o_LabelConstraints.y = intLabelStart;
        }
        p_Labels.revalidate();
    }

    @Override
    public void paintLabels(Graphics p_Graphics, ControlObject.ControlLabels p_ControlLabels) {
    }

    @Override
    public void calculateBlocks(ControlObject.ControlBlocks p_Blocks) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Blocks == null) {
            return;
        }
        if (this.m_Track == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Blocks.getControlDimension();
        Insets o_BlocksInsets = p_Blocks.getBlocksInsets();
        AbsoluteConstraints o_BlocksConstraints = p_Blocks.getConstraints();
        o_BlocksConstraints.width = o_ThisRectangle.width - o_BlocksInsets.left - o_BlocksInsets.right;
        o_BlocksConstraints.height = o_ThisRectangle.height - o_BlocksInsets.top - o_BlocksInsets.bottom;
        o_BlocksConstraints.x = o_BlocksInsets.left;
        o_BlocksConstraints.y = o_BlocksInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        double doubleBlockWidth = 0.0;
        double doubleBlockHeight = 0.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_BlocksConstraints.y + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getHeight() - this.getAdjusterLength();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockWidth = o_BlocksConstraints.width < p_Blocks.getBlocksSize().width ? (double)o_BlocksConstraints.width : (double)p_Blocks.getBlocksSize().width;
        } else {
            intOffset = o_TrackConstraints.getX() - o_BlocksConstraints.x + this.getAdjusterLength() / 2;
            intValueLength = o_TrackConstraints.getWidth() - this.getAdjusterLength();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockHeight = o_BlocksConstraints.height < p_Blocks.getBlocksSize().height ? (double)o_BlocksConstraints.height : (double)p_Blocks.getBlocksSize().height;
        }
        int intStartPos = 0;
        int intEndPos = 0;
        for (int intBlock = 0; intBlock < p_Blocks.getControlBlocksCount(); ++intBlock) {
            int intLabelStart;
            ControlObject.ControlBlocks.ControlBlock o_ControlBlock = p_Blocks.getControlBlock(intBlock);
            if (o_ControlBlock == null) continue;
            AbsoluteConstraints o_BlockConstraints = o_ControlBlock.getConstraints();
            int intDefaultPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            intStartPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueStart() - o_ControlDimension.getValueMinimum()));
            intEndPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueEnd() - o_ControlDimension.getValueMinimum()));
            o_BlockConstraints.width = (int)doubleBlockWidth;
            o_BlockConstraints.height = (int)doubleBlockHeight;
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intStartPos = intValueLength - intStartPos;
                    intEndPos = intValueLength - intEndPos;
                    intDefaultPos = intValueLength - intDefaultPos;
                    o_BlockConstraints.height = intStartPos - intEndPos;
                    o_BlockConstraints.y = intEndPos + intOffset;
                } else {
                    o_BlockConstraints.height = intEndPos - intStartPos;
                    o_BlockConstraints.y = intStartPos + intOffset;
                }
                if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(2);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(4);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                    intLabelStart = o_BlocksConstraints.width - o_BlockConstraints.width;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(4);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(2);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_BlocksConstraints.width / 2 - o_BlockConstraints.width / 2;
                    o_ControlBlock.setHorizontalAlignment(0);
                    o_ControlBlock.setVerticalAlignment(0);
                }
                o_BlockConstraints.x = intLabelStart;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intStartPos = intValueLength - intStartPos;
                intEndPos = intValueLength - intEndPos;
                intDefaultPos = intValueLength - intDefaultPos;
                o_BlockConstraints.width = intStartPos - intEndPos;
                o_BlockConstraints.x = intEndPos + intOffset;
            } else {
                o_BlockConstraints.width = intEndPos - intStartPos;
                o_BlockConstraints.x = intStartPos + intOffset;
            }
            if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(1);
                } else {
                    o_ControlBlock.setVerticalAlignment(3);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                intLabelStart = o_BlocksConstraints.height - o_BlockConstraints.height;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(3);
                } else {
                    o_ControlBlock.setVerticalAlignment(1);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_BlocksConstraints.height / 2 - o_BlockConstraints.height / 2;
                o_ControlBlock.setVerticalAlignment(0);
                o_ControlBlock.setHorizontalAlignment(0);
            }
            o_BlockConstraints.y = intLabelStart;
        }
        p_Blocks.revalidate();
    }

    @Override
    public void paintBlocks(Graphics p_Graphics, ControlObject.ControlBlocks p_ControlBlocks) {
    }

    public ControlObject.ControlTicks getControlTicks() {
        return this.m_ControlDimension.getControlTicks();
    }

    public boolean getTicksVisible() {
        return this.m_ControlDimension.getTicksVisible();
    }

    public void setTicksVisible(boolean p_TicksVisible) {
        this.m_ControlDimension.setTicksVisible(p_TicksVisible);
    }

    public double getTicksMajor() {
        return this.m_ControlDimension.getTicksMajor();
    }

    public void setTicksMajor(double p_TicksMajor) {
        this.m_ControlDimension.setTicksMajor(p_TicksMajor);
    }

    public double getTicksMinor() {
        return this.m_ControlDimension.getTicksMinor();
    }

    public void setTicksMinor(double p_TicksMinor) {
        this.m_ControlDimension.setTicksMinor(p_TicksMinor);
    }

    public int getTicksAlignment() {
        return this.m_ControlDimension.getTicksAlignment();
    }

    public void setTicksAlignment(int p_TicksAlignment) {
        this.m_ControlDimension.setTicksAlignment(p_TicksAlignment);
    }

    public int getTicksMajorLength() {
        return this.m_ControlDimension.getTicksMajorLength();
    }

    public void setTicksMajorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMajorLength(p_TicksLength);
    }

    public int getTicksMinorLength() {
        return this.m_ControlDimension.getTicksMinorLength();
    }

    public void setTicksMinorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMinorLength(p_TicksLength);
    }

    public boolean getTicksMirrored() {
        return this.m_ControlDimension.getTicksMirrored();
    }

    public void setTicksMirrored(boolean p_TicksMirrored) {
        this.m_ControlDimension.setTicksMirrored(p_TicksMirrored);
    }

    public Insets getTicksInsets() {
        return this.m_ControlDimension.getTicksInsets();
    }

    public void setTicksInsets(Insets p_TicksInsets) {
        this.m_ControlDimension.setTicksInsets(p_TicksInsets);
    }

    public boolean getLabelsAutomatic() {
        return this.m_ControlDimension.getLabelsAutomatic();
    }

    public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
        this.m_ControlDimension.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsVisible() {
        return this.m_ControlDimension.getLabelsVisible();
    }

    public void setLabelsVisible(boolean p_LabelsVisible) {
        this.m_ControlDimension.setLabelsVisible(p_LabelsVisible);
    }

    public Insets getLabelsInsets() {
        return this.m_ControlDimension.getLabelsInsets();
    }

    public void setLabelsInsets(Insets p_LabelsInsets) {
        this.m_ControlDimension.setLabelsInsets(p_LabelsInsets);
    }

    public int getLabelsAlignment() {
        return this.m_ControlDimension.getLabelsAlignment();
    }

    public void setLabelsAlignment(int p_LabelsAlignment) {
        this.m_ControlDimension.setLabelsAlignment(p_LabelsAlignment);
    }

    public boolean getLabelsMirrored() {
        return this.m_ControlDimension.getLabelsMirrored();
    }

    public void setLabelsMirrored(boolean p_LabelsMirrored) {
        this.m_ControlDimension.setLabelsMirrored(p_LabelsMirrored);
    }

    public Font getLabelsFont() {
        return this.m_ControlDimension.getLabelsFont();
    }

    public void setLabelsFont(Font p_LabelsFont) {
        this.m_ControlDimension.setLabelsFont(p_LabelsFont);
    }

    public void setLabelsTextRotation(double p_Degree) {
        this.m_ControlDimension.setLabelsTextRotation(p_Degree);
    }

    public Border getLabelsBorder() {
        return this.m_ControlDimension.getLabelsBorder();
    }

    public void setLabelsBorder(Border p_LabelsBorder) {
        this.m_ControlDimension.setLabelsBorder(p_LabelsBorder);
    }

    public ControlLabelModel getControlLabelModel() {
        return this.m_ControlDimension.getControlLabelModel();
    }

    public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
        this.m_ControlDimension.setControlLabelModel(p_ControlLabelModel);
    }

    public Dimension getLabelsSize() {
        return this.m_ControlDimension.getLabelsSize();
    }

    public void setLabelsSize(Dimension p_LabelsSize) {
        this.m_ControlDimension.setLabelsSize(p_LabelsSize);
    }

    public void setLabelsSizeFixed(boolean p_LabelsSizeFixed) {
        this.m_ControlDimension.setLabelsSizeFixed(p_LabelsSizeFixed);
    }

    public boolean getLabelsSizeFixed() {
        return this.m_ControlDimension.getLabelsSizeFixed();
    }

    public boolean getBlocksVisible() {
        return this.m_ControlDimension.getBlocksVisible();
    }

    public void setBlocksVisible(boolean p_BlocksVisible) {
        this.m_ControlDimension.setBlocksVisible(p_BlocksVisible);
    }

    public Insets getBlocksInsets() {
        return this.m_ControlDimension.getBlocksInsets();
    }

    public void setBlocksInsets(Insets p_BlocksInsets) {
        this.m_ControlDimension.setBlocksInsets(p_BlocksInsets);
    }

    public int getBlocksAlignment() {
        return this.m_ControlDimension.getBlocksAlignment();
    }

    public void setBlocksAlignment(int p_BlocksAlignment) {
        this.m_ControlDimension.setBlocksAlignment(p_BlocksAlignment);
    }

    public boolean getBlocksMirrored() {
        return this.m_ControlDimension.getBlocksMirrored();
    }

    public void setBlocksMirrored(boolean p_BlocksMirrored) {
        this.m_ControlDimension.setBlocksMirrored(p_BlocksMirrored);
    }

    public Font getBlocksFont() {
        return this.m_ControlDimension.getBlocksFont();
    }

    public void setBlocksFont(Font p_BlocksFont) {
        this.m_ControlDimension.setBlocksFont(p_BlocksFont);
    }

    public void setBlocksTextRotation(double p_Degree) {
        this.m_ControlDimension.setBlocksTextRotation(p_Degree);
    }

    public Border getBlocksBorder() {
        return this.m_ControlDimension.getBlocksBorder();
    }

    public void setBlocksBorder(Border p_BlocksBorder) {
        this.m_ControlDimension.setBlocksBorder(p_BlocksBorder);
    }

    public ControlBlockModel getControlBlockModel() {
        return this.m_ControlDimension.getControlBlockModel();
    }

    public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
        this.m_ControlDimension.setControlBlockModel(p_ControlBlockModel);
    }

    public Dimension getBlocksSize() {
        return this.m_ControlDimension.getBlocksSize();
    }

    public void setBlocksSize(Dimension p_BlocksSize) {
        this.m_ControlDimension.setBlocksSize(p_BlocksSize);
    }

    public int getOrientation() {
        return this.m_ControlDimension.getOrientation();
    }

    public void setOrientation(int p_Orientation) {
        this.m_ControlDimension.setOrientation(p_Orientation);
    }

    public boolean getInverted() {
        return this.m_ControlDimension.getInverted();
    }

    public void setInverted(boolean p_Inverted) {
        this.m_ControlDimension.setInverted(p_Inverted);
    }

    @Override
    public void adjustToValue(ControlObject.ControlDimension p_ControlDimension, double p_Value, boolean p_ManuallySet) {
        if (p_ControlDimension == null) {
            return;
        }
        if (this.m_ControlDimension != p_ControlDimension) {
            return;
        }
        p_ControlDimension.adjustToValue(p_Value, p_ManuallySet);
    }

    public double getValue() {
        return this.m_ControlDimension.getValue();
    }

    public double getValueNew() {
        return this.m_ControlDimension.getValueNew();
    }

    public double getValueOld() {
        return this.m_ControlDimension.getValueOld();
    }

    public void setValue(double p_Value, double p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension.setValue(p_Value, p_ValueDiff, p_ActionFlag);
    }

    public void setValue(double p_Value) {
        double doubleValueDiff = p_Value - this.m_ControlDimension.getValue();
        this.m_ControlDimension.setValue(p_Value, doubleValueDiff, 0);
    }

    public int getValueInt() {
        return this.m_ControlDimension.getValueInt();
    }

    public void setValueInt(int p_Value, int p_ActionFlag) {
        this.m_ControlDimension.setValueInt(p_Value, p_Value - this.m_ControlDimension.getValueInt(), p_ActionFlag);
    }

    public double getValueTransformed() {
        return this.m_ControlDimension.getValueTransformed();
    }

    public void setValueTransformed(double p_MultipliedValue, int p_ActionFlag) {
        this.m_ControlDimension.setValueTransformed(p_MultipliedValue, p_ActionFlag);
    }

    public double getValueMultiplier() {
        return this.m_ControlDimension.getValueMultiplier();
    }

    public void setValueMultiplier(double p_ValueMultiplier) {
        this.m_ControlDimension.setValueMultiplier(p_ValueMultiplier);
    }

    public double getValueOffset() {
        return this.m_ControlDimension.getValueOffset();
    }

    public void setValueOffset(double p_ValueOffset) {
        this.m_ControlDimension.setValueOffset(p_ValueOffset);
    }

    public double getSnapDistance() {
        return this.m_ControlDimension.getSnapDistance();
    }

    public void setSnapDistance(double p_SnapDistance) {
        this.m_ControlDimension.setSnapDistance(p_SnapDistance);
    }

    public double getSnapDistanceTransformed() {
        return this.m_ControlDimension.getSnapDistanceTransformed();
    }

    public void setSnapDistanceTransformed(double p_SnapDistanceTransformed) {
        this.m_ControlDimension.setSnapDistanceTransformed(p_SnapDistanceTransformed);
    }

    public double getValueMaximum() {
        return this.m_ControlDimension.getValueMaximum();
    }

    public void setValueMaximum(double p_Maximum) {
        this.m_ControlDimension.setValueMaximum(p_Maximum);
    }

    public double getValueMinimum() {
        return this.m_ControlDimension.getValueMinimum();
    }

    public void setValueMinimum(double p_Minimum) {
        this.m_ControlDimension.setValueMinimum(p_Minimum);
    }

    public double getMouseWheelStep() {
        return this.m_ControlDimension.getMouseWheelStep();
    }

    public void setMouseWheelStep(double p_ValueDifference) {
        this.m_ControlDimension.setMouseWheelStep(p_ValueDifference);
    }

    public static class SliderAdjuster
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension;
        protected int m_AdjusterLength;
        protected Color m_AdjusterColor;
        protected BufferedImage m_AdjusterImage;
        protected SliderAdjuster m_SelfReference;
        protected AbsoluteConstraints m_AdjusterConstraints;
        protected int m_DragPos;
        protected int m_OldPos;
        protected Rectangle m_RectSize;
        protected Rectangle m_OldRectSize;
        protected boolean m_RepaintFlag;
        protected BufferedImage m_Image;
        protected int m_OldOrientation;
        private Insets m_InsetsParent;
        private double m_OldValue;

        public SliderAdjuster(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension = p_ControlObject.getControlDimension(0);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.m_RectSize = new Rectangle();
            this.m_OldRectSize = new Rectangle();
            this.m_RepaintFlag = true;
            this.m_AdjusterLength = 40;
            this.m_AdjusterColor = Color.LIGHT_GRAY;
            this.m_AdjusterImage = null;
            this.m_OldOrientation = 1;
            this.m_Image = null;
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeInt(this.m_AdjusterLength);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_AdjusterColor);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_AdjusterImage);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_AdjusterLength = p_ObjectInput.readInt();
            this.m_AdjusterColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            Image o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            this.m_RepaintFlag = true;
            this.repaint();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_AdjusterConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        if (m_ControlDimension.getOrientation() == 1) {
                            m_DragPos = me.getYOnScreen();
                            m_OldPos = me.getYOnScreen();
                            m_OldValue = m_ControlDimension.getValue();
                        } else {
                            m_DragPos = me.getXOnScreen();
                            m_OldPos = me.getXOnScreen();
                            m_OldValue = m_ControlDimension.getValue();
                        }
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        int intDiffPos;
                        int intLength = 1;
                        int intPosition = 0;
                        if (m_ControlDimension.getOrientation() == 1) {
                            intLength = this.getParent().getHeight() - m_AdjusterLength;
                            intPosition = me.getYOnScreen() - m_DragPos;
                            intDiffPos = me.getYOnScreen() - m_OldPos;
                            m_OldPos = me.getYOnScreen();
                            if (!m_ControlDimension.getInverted()) {
                                intPosition = -intPosition;
                                intDiffPos = -intDiffPos;
                            }
                        } else {
                            intLength = this.getParent().getWidth() - m_AdjusterLength;
                            intPosition = me.getXOnScreen() - m_DragPos;
                            intDiffPos = me.getXOnScreen() - m_OldPos;
                            m_OldPos = me.getXOnScreen();
                            if (m_ControlDimension.getInverted()) {
                                intPosition = -intPosition;
                                intDiffPos = -intDiffPos;
                            }
                        }
                        double doubleValueDiff = (double)intDiffPos / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                        double doubleValue = m_OldValue + (double)intPosition / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                        m_ControlDimension.setValue(doubleValue, doubleValueDiff, 4);
                        m_ControlObject.setValueManuallyIsReady();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent me) {
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
            this.addMouseMotionListener((MouseMotionListener)o_MouseAdapter_Delayed);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_AdjusterConstraints;
        }

        @Override
        public void setForeground(Color p_Color) {
            super.setForeground(p_Color);
        }

        public int getAdjusterLength() {
            return this.m_AdjusterLength;
        }

        public void setAdjusterLength(int p_AdjusterLength) {
            int oldValue = this.m_AdjusterLength;
            this.m_AdjusterLength = p_AdjusterLength;
            if (oldValue != this.m_AdjusterLength) {
                this.firePropertyChange(JControlSlider.PROP_ADJUSTERLENGTH, oldValue, this.m_AdjusterLength);
                this.repaint();
            }
        }

        public Image getAdjusterImage() {
            return this.m_AdjusterImage;
        }

        public void setAdjusterImage(Image p_AdjusterImage) {
            BufferedImage oldValue = this.m_AdjusterImage;
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)p_AdjusterImage);
            this.m_RepaintFlag = true;
            this.firePropertyChange(JControlSlider.PROP_ADJUSTERIMAGE, oldValue, this.m_AdjusterImage);
            this.repaint();
        }

        public Color getAdjusterColor() {
            return this.m_AdjusterColor;
        }

        public void setAdjusterColor(Color p_AdjusterColor) {
            Color oldValue = this.m_AdjusterColor;
            this.m_AdjusterColor = p_AdjusterColor;
            if (!oldValue.equals(this.m_AdjusterColor)) {
                this.firePropertyChange(JControlSlider.PROP_ADJUSTERCOLOR, oldValue, this.m_AdjusterColor);
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            this.m_InsetsParent = this.getInsets(this.m_InsetsParent);
            this.m_RectSize.setRect(this.m_InsetsParent.left, this.m_InsetsParent.top, this.getWidth() - this.m_InsetsParent.left - this.m_InsetsParent.right, this.getHeight() - this.m_InsetsParent.top - this.m_InsetsParent.bottom);
            if (this.m_RectSize.getWidth() != this.m_OldRectSize.getWidth()) {
                // empty if block
            }
            if (this.m_RectSize.getHeight() != this.m_OldRectSize.getHeight()) {
                // empty if block
            }
            this.m_OldRectSize.setRect(this.m_RectSize.getX(), this.m_RectSize.getY(), this.m_RectSize.getWidth(), this.m_RectSize.getHeight());
            if (this.m_AdjusterImage != null) {
                if (this.m_RepaintFlag || this.m_OldOrientation != this.m_ControlDimension.getOrientation()) {
                    this.m_Image = this.m_ControlDimension.getOrientation() == 1 ? this.m_AdjusterImage : ImagesTools.rotateImage90_right((BufferedImage)this.m_AdjusterImage);
                    this.m_OldOrientation = this.m_ControlDimension.getOrientation();
                }
                p_Graphics.drawImage(this.m_Image, this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width, this.m_RectSize.height, 0, 0, this.m_Image.getWidth(), this.m_Image.getHeight(), this);
            } else {
                p_Graphics.setColor(this.m_AdjusterColor);
                p_Graphics.fillRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width - 1, this.m_RectSize.height - 1);
                p_Graphics.setColor(this.getForeground());
                p_Graphics.drawRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width - 1, this.m_RectSize.height - 1);
                if (this.m_ControlDimension.getOrientation() == 1) {
                    p_Graphics.drawLine(0, this.m_RectSize.height / 2, this.m_RectSize.width, this.m_RectSize.height / 2);
                } else {
                    p_Graphics.drawLine(this.m_RectSize.width / 2, 0, this.m_RectSize.width / 2, this.m_RectSize.height);
                }
            }
            this.m_RepaintFlag = false;
        }
    }

    protected static class SliderTrack
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension;
        protected SliderAdjuster m_Adjuster;
        protected int m_TrackSlotWidth;
        protected boolean m_TrackSlotVisible;
        protected Insets m_TrackInsets;
        protected SliderTrack m_SelfReference;
        protected AbsoluteLayout m_LayoutManager;
        protected AbsoluteConstraints m_TrackConstraints;
        protected Rectangle m_RectInside;
        protected int m_DragPos;
        protected int m_OldPos;
        protected double m_OldValue;
        private Runnable m_Runnable_Revalidate = new Runnable(){

            @Override
            public void run() {
                m_Adjuster.revalidate();
            }
        };

        public SliderTrack(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension = p_ControlObject.getControlDimension(0);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.setBackground(Color.LIGHT_GRAY);
            this.m_TrackSlotWidth = 3;
            this.m_TrackSlotVisible = true;
            this.m_TrackInsets = this.m_ControlDimension.getOrientation() == 1 ? new Insets(5, 18, 5, 18) : new Insets(18, 5, 18, 5);
            this.m_Adjuster = new SliderAdjuster(this.m_ControlObject);
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeInt(this.m_TrackSlotWidth);
            p_ObjectOutput.writeBoolean(this.m_TrackSlotVisible);
            ImagesTools.writeInsets((ObjectOutput)p_ObjectOutput, (Insets)this.m_TrackInsets);
            this.m_Adjuster.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_TrackSlotWidth = p_ObjectInput.readInt();
            this.m_TrackSlotVisible = p_ObjectInput.readBoolean();
            this.m_TrackInsets = ImagesTools.readInsets((ObjectInput)p_ObjectInput);
            this.m_Adjuster.readExternal(p_ObjectInput);
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_TrackConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.add(this.m_Adjuster, this.m_Adjuster.getConstraints(), 0);
            this.setVisible(true);
            MouseAdapter_Delayed o_MouseInputListener = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        if (m_ControlDimension.getOrientation() == 1) {
                            m_DragPos = me.getY();
                            m_OldPos = me.getY();
                            m_OldValue = m_ControlDimension.getValue();
                        } else {
                            m_DragPos = me.getX();
                            m_OldPos = me.getX();
                            m_OldValue = m_ControlDimension.getValue();
                        }
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        ControlObject.ControlLabels o_Labels = m_ControlDimension.getControlLabels();
                        Component o_Component = o_Labels.getComponentAt(me.getX() - o_Labels.getLabelsInsets().left + m_TrackInsets.left, me.getY() - o_Labels.getLabelsInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlLabels.ControlLabel) {
                            ((ControlObject.ControlLabels.ControlLabel)((Object)o_Component)).setValue(2);
                            return;
                        }
                        ControlObject.ControlBlocks o_Blocks = m_ControlDimension.getControlBlocks();
                        o_Component = o_Blocks.getComponentAt(me.getX() - o_Blocks.getBlocksInsets().left + m_TrackInsets.left, me.getY() - o_Blocks.getBlocksInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlBlocks.ControlBlock) {
                            ((ControlObject.ControlBlocks.ControlBlock)((Object)o_Component)).setValue(2);
                            return;
                        }
                        double doubleNewValue = m_ControlObject.getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[0];
                        double doubleValueDiff = doubleNewValue - m_ControlDimension.getValue();
                        m_ControlDimension.setValue(m_ControlObject.getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[0], doubleValueDiff, 2);
                        m_ControlObject.setValueManuallyIsReady();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        int intDiffPos;
                        int intLength = 1;
                        int intPosition = 0;
                        double doubleOldValue = m_ControlDimension.getValue();
                        if (m_ControlDimension.getOrientation() == 1) {
                            intLength = this.getParent().getHeight() - m_Adjuster.getAdjusterLength();
                            intPosition = me.getY() - m_DragPos;
                            intDiffPos = me.getY() - m_OldPos;
                            m_OldPos = me.getY();
                        } else {
                            intLength = this.getParent().getWidth() - m_Adjuster.getAdjusterLength();
                            intPosition = me.getX() - m_DragPos;
                            intDiffPos = me.getX() - m_OldPos;
                            m_OldPos = me.getX();
                        }
                        if (!m_ControlDimension.getInverted()) {
                            intPosition = -intPosition;
                            intDiffPos = -intDiffPos;
                        }
                        double doubleValueDiff = m_ControlDimension.getMouseMoveFactor() * ((double)intDiffPos / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum()));
                        double doubleNewValue = m_OldValue + m_ControlDimension.getMouseMoveFactor() * ((double)intPosition / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum()));
                        m_ControlDimension.setValue(doubleNewValue, doubleValueDiff, 4);
                        m_ControlObject.setValueManuallyIsReady();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent e) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, e);
                }
            };
            this.addMouseListener((MouseListener)o_MouseInputListener);
            this.addMouseMotionListener((MouseMotionListener)o_MouseInputListener);
            this.m_ControlDimension.setMouseMoveFactor(0.5);
        }

        @Override
        public void setForeground(Color p_Color) {
            this.m_Adjuster.setForeground(p_Color);
            super.setForeground(p_Color);
        }

        public SliderAdjuster getAdjuster() {
            return this.m_Adjuster;
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_TrackConstraints;
        }

        public int getTrackSlotWidth() {
            return this.m_TrackSlotWidth;
        }

        public void setTrackSlotWidth(int p_TrackSlotWidth) {
            double oldValue = this.m_TrackSlotWidth;
            this.m_TrackSlotWidth = p_TrackSlotWidth;
            if (oldValue != (double)this.m_TrackSlotWidth) {
                this.firePropertyChange(JControlSlider.PROP_TRACKSLOTWIDTH, oldValue, (double)this.m_TrackSlotWidth);
            }
        }

        public boolean getTrackSlotVisible() {
            return this.m_TrackSlotVisible;
        }

        public void setTrackSlotVisible(boolean p_Visible) {
            boolean oldValue = this.m_TrackSlotVisible;
            this.m_TrackSlotVisible = p_Visible;
            if (oldValue != this.m_TrackSlotVisible) {
                this.firePropertyChange(JControlSlider.PROP_TRACKSLOTVISIBLE, oldValue, this.m_TrackSlotVisible);
            }
        }

        public Insets getTrackInsets() {
            return this.m_TrackInsets;
        }

        public void setTrackInsets(Insets p_Insets) {
            Insets oldValue = this.m_TrackInsets;
            this.m_TrackInsets = p_Insets;
            if (!this.m_TrackInsets.equals(p_Insets)) {
                this.m_ControlObject.calculateInnerItems();
                this.firePropertyChange(JControlSlider.PROP_TRACKINSETS, oldValue, this.m_TrackInsets);
            }
        }

        public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
            this.setTrackInsets(new Insets(p_Top, p_Left, p_Bottom, p_Right));
        }

        private void calculateAdjuster() {
            int intAdjusterY;
            int intAdjusterX;
            int intAdjusterWidth;
            int intAdjusterHight;
            int intValueLength;
            boolean boolChanged = false;
            if (this.m_ControlDimension.getOrientation() == 1) {
                intValueLength = this.m_TrackConstraints.height - this.m_Adjuster.getAdjusterLength();
                intAdjusterHight = this.m_Adjuster.getAdjusterLength();
                intAdjusterWidth = this.m_TrackConstraints.width;
            } else {
                intValueLength = this.m_TrackConstraints.width - this.m_Adjuster.getAdjusterLength();
                intAdjusterHight = this.m_TrackConstraints.height;
                intAdjusterWidth = this.m_Adjuster.getAdjusterLength();
            }
            int intValueMidPosition = (int)((double)intValueLength * (this.m_ControlDimension.getValue() - this.m_ControlDimension.getValueMinimum()) / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()));
            if (!this.m_ControlDimension.getInverted()) {
                if (this.m_ControlDimension.getOrientation() == 1) {
                    intValueMidPosition = intValueLength - intValueMidPosition;
                }
            } else if (this.m_ControlDimension.getOrientation() == 0) {
                intValueMidPosition = intValueLength - intValueMidPosition;
            }
            if (this.m_ControlDimension.getOrientation() == 1) {
                intAdjusterX = 0;
                intAdjusterY = intValueMidPosition;
            } else {
                intAdjusterX = intValueMidPosition;
                intAdjusterY = 0;
            }
            AbsoluteConstraints o_AbsoluteConstraints = this.m_Adjuster.getConstraints();
            if (o_AbsoluteConstraints == null) {
                return;
            }
            if (o_AbsoluteConstraints.x != intAdjusterX) {
                boolChanged = true;
            } else if (o_AbsoluteConstraints.y != intAdjusterY) {
                boolChanged = true;
            } else if (o_AbsoluteConstraints.height != intAdjusterHight || o_AbsoluteConstraints.width != intAdjusterWidth) {
                boolChanged = true;
            }
            if (!boolChanged) {
                return;
            }
            o_AbsoluteConstraints.x = intAdjusterX;
            o_AbsoluteConstraints.y = intAdjusterY;
            o_AbsoluteConstraints.width = intAdjusterWidth;
            o_AbsoluteConstraints.height = intAdjusterHight;
            this.m_Adjuster.revalidate();
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            if (this.m_TrackSlotVisible) {
                this.m_RectInside = this.getBounds(this.m_RectInside);
                Graphics2D g2d = (Graphics2D)p_Graphics;
                if (this.m_ControlDimension.getOrientation() == 1) {
                    this.m_RectInside.height -= this.m_Adjuster.getAdjusterLength();
                    this.m_RectInside.x = (int)((double)(this.m_RectInside.width - this.m_TrackSlotWidth) / 2.0 + 0.5);
                    this.m_RectInside.y = this.m_Adjuster.getAdjusterLength() / 2;
                    this.m_RectInside.width = this.m_TrackSlotWidth;
                } else {
                    this.m_RectInside.width -= this.m_Adjuster.getAdjusterLength();
                    this.m_RectInside.y = (int)((double)(this.m_RectInside.height - this.m_TrackSlotWidth) / 2.0 + 0.5);
                    this.m_RectInside.x = this.m_Adjuster.getAdjusterLength() / 2;
                    this.m_RectInside.height = this.m_TrackSlotWidth;
                }
                g2d.setColor(Color.BLACK);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.x, this.m_RectInside.y + this.m_RectInside.height);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y + this.m_RectInside.height, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y + this.m_RectInside.height);
                g2d.drawLine(this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y + this.m_RectInside.height);
                ++this.m_RectInside.x;
                ++this.m_RectInside.y;
                --this.m_RectInside.width;
                --this.m_RectInside.height;
                g2d.setColor(this.getParent().getBackground());
                g2d.fillRect(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.width, this.m_RectInside.height);
            }
            super.paintComponent(p_Graphics);
        }
    }
}

