/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JControlMeter
extends ControlObject {
    public static final String PROP_METERBARINSETS = "meterBarInsets";
    public static final String PROP_METERBARWIDTH = "meterBarWidth";
    public static final String PROP_METERBARVISIBLE = "meterBarOpaque";
    public static final String PROP_METERBAROPAQUE = "meterBarColor";
    public static final String PROP_METERBARIMAGE = "meterBarImage";
    public static final String PROP_METERBARCOLOR = "meterBarColor";
    protected MeterBar m_MeterBar;
    protected ControlObject.ControlDimension m_ControlDimension;
    protected Rectangle m_ThisRectangle;

    public JControlMeter() {
        this.initMembers();
        this.initComponents();
        this.calculateInnerItems();
    }

    private void initMembers() {
        this.setName("JControlMeter");
        this.m_ControlDimension = super.createNewControlDimension();
        this.m_ControlDimension.setOrientation(1);
        this.m_ControlDimension.getControlBlocks().setBlocksTextRotation(-90.0);
        this.m_ControlDimension.setTicksAlignment(0);
        this.m_ControlDimension.setLabelsAlignment(2);
        this.m_ControlDimension.setBlocksAlignment(2);
        this.m_ControlDimension.setLabelsMirrored(true);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        this.m_MeterBar = new MeterBar(this);
    }

    private Object readResolve() {
        this.m_ControlDimension = this.getControlDimension(0);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        super.writeExternal(p_ObjectOutput);
        this.m_ControlDimension.writeExternal(p_ObjectOutput);
        this.m_MeterBar.writeExternal(p_ObjectOutput);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        super.readExternal(p_ObjectInput);
        this.m_ControlDimension.readExternal(p_ObjectInput);
        this.m_MeterBar.readExternal(p_ObjectInput);
        this.calculateInnerItems();
    }

    private void initComponents() {
        this.add(this.m_MeterBar, this.m_MeterBar.getConstraints(), 0);
        this.setVisible(true);
    }

    @Override
    public void setToolTipText(String p_ToolTipText) {
        super.setToolTipText(p_ToolTipText);
        if (this.m_MeterBar == null) {
            return;
        }
    }

    public ControlObject.ControlDimension getControlDimension() {
        return this.m_ControlDimension;
    }

    public ControlObject.ControlDisplayItem createControlDisplayItem(Object p_SourceObject, String p_ListenToProperty) {
        return this.m_ControlDimension.createControlDisplayItem(p_SourceObject, p_ListenToProperty);
    }

    public void removeControlDisplayItem(Object p_SourceObject, String p_ListenToProperty) {
        ControlObject.ControlDisplayItem o_ControlDisplayItem = this.m_ControlDimension.getControlDisplayItem(p_SourceObject, p_ListenToProperty);
        if (o_ControlDisplayItem == null) {
            return;
        }
        this.removeControlDisplayItem(o_ControlDisplayItem);
    }

    public void removeControlDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
        this.m_ControlDimension.removeControlDisplayItem(p_ControlDisplayItem);
    }

    public void clearControlDisplayItems() {
        for (int intItem = this.m_ControlDimension.getControlDisplayItemsCount() - 1; intItem >= 0; --intItem) {
            ControlObject.ControlDisplayItem o_ControlDisplayItem = this.m_ControlDimension.getControlDisplayItem(intItem);
            this.m_ControlDimension.removeControlDisplayItem(o_ControlDisplayItem);
        }
    }

    public int getControlDisplayItemsCount() {
        return this.m_ControlDimension.getControlDisplayItemsCount();
    }

    public ControlObject.ControlDisplayItem getControlDisplayItem(int p_Index) {
        return this.m_ControlDimension.getControlDisplayItem(p_Index);
    }

    public ControlObject.ControlDisplayItem getControlDisplayItem(Object p_SourceObject, String p_ListenToProperty) {
        return this.m_ControlDimension.getControlDisplayItem(p_SourceObject, p_ListenToProperty);
    }

    @Override
    public double[] getValuesFromInnerComponentPosition(JComponent p_Component, int p_X, int p_Y) {
        return this.getValuesFromMeterBarPosition(p_X - this.m_MeterBar.getX() + p_Component.getX(), p_Y - this.m_MeterBar.getY() + p_Component.getY());
    }

    @Override
    public double[] getValuesFromComponentPosition(int p_X, int p_Y) {
        return this.getValuesFromMeterBarPosition(p_X - this.m_MeterBar.getX(), p_Y - this.m_MeterBar.getY());
    }

    public double[] getValuesFromMeterBarPosition(int p_X, int p_Y) {
        int intLength = 1;
        int intPosition = 0;
        double[] doubleResults = new double[1];
        if (this.m_ControlDimension.getOrientation() == 1) {
            int intOffset = 0;
            intLength = this.m_MeterBar.getSize().height;
            intPosition = p_Y - intOffset;
            if (!this.m_ControlDimension.getInverted()) {
                intPosition = intLength - intPosition;
            }
        } else {
            int intOffset = 0;
            intLength = this.m_MeterBar.getSize().width;
            intPosition = p_X - intOffset;
            if (this.m_ControlDimension.getInverted()) {
                intPosition = intLength - intPosition;
            }
        }
        doubleResults[0] = this.m_ControlDimension.getValueMinimum() + (double)intPosition / (double)intLength * (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
        return doubleResults;
    }

    @Override
    public void calculateAdjuster() {
    }

    @Override
    public void calculateInnerItems() {
        if (this.m_MeterBar == null) {
            return;
        }
        this.m_ThisRectangle = this.getBounds(this.m_ThisRectangle);
        Insets o_TrackInsets = this.m_MeterBar.getMeterBarInsets();
        AbsoluteConstraints o_TrackConstraints = this.m_MeterBar.getConstraints();
        o_TrackConstraints.width = this.m_ThisRectangle.width - o_TrackInsets.left - o_TrackInsets.right;
        o_TrackConstraints.height = this.m_ThisRectangle.height - o_TrackInsets.top - o_TrackInsets.bottom;
        o_TrackConstraints.x = o_TrackInsets.left;
        o_TrackConstraints.y = o_TrackInsets.top;
        this.m_MeterBar.calculate();
        this.m_ControlDimension.getControlTicks().calculate();
        this.m_ControlDimension.getControlBlocks().calculate();
        this.m_ControlDimension.recalculateControlLabels();
        this.m_ControlDimension.getControlLabels().calculate();
        this.m_ControlDimension.calculateDisplayItems();
    }

    @Override
    public double calculatePixelPerValueLabel(ControlObject.ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return -1.0;
        }
        AbsoluteConstraints o_TrackConstraints = this.m_MeterBar.getConstraints();
        int intValueLength = p_ControlDimension.getOrientation() == 1 ? o_TrackConstraints.getHeight() : o_TrackConstraints.getWidth();
        double doublePixelPerValue = (double)intValueLength / (p_ControlDimension.getValueMaximum() - p_ControlDimension.getValueMinimum());
        return doublePixelPerValue;
    }

    @Override
    public void calculateTicks(ControlObject.ControlTicks p_Ticks) {
        if (p_Ticks == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_TicksInsets = p_Ticks.getTicksInsets();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        o_TicksConstraints.width = o_ThisRectangle.width - o_TicksInsets.left - o_TicksInsets.right;
        o_TicksConstraints.height = o_ThisRectangle.height - o_TicksInsets.top - o_TicksInsets.bottom;
        o_TicksConstraints.x = o_TicksInsets.left;
        o_TicksConstraints.y = o_TicksInsets.top;
        p_Ticks.revalidate();
    }

    @Override
    public void paintTicks(Graphics p_Graphics, ControlObject.ControlTicks p_Ticks) {
        int intTrackValuePos;
        double doubleValue;
        int intPixelWide;
        int intTickLength;
        int intTickStart;
        double doubleJump;
        int intPassCount;
        int intValueLength;
        int intOffset;
        if (p_Ticks == null) {
            return;
        }
        if (p_Ticks.getTicksMajor() <= 0.0 && p_Ticks.getTicksMinor() <= 0.0) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = p_Ticks.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_MeterBar.getConstraints();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_TicksConstraints.getY();
            intValueLength = o_TrackConstraints.getHeight();
        } else {
            intOffset = o_TrackConstraints.getX() - o_TicksConstraints.getX();
            intValueLength = o_TrackConstraints.getWidth();
        }
        if (intValueLength <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)p_Graphics.create();
        g2d.setColor(super.getForeground());
        double doubleDistance = this.calculatePixelPerValueLabel(o_ControlDimension);
        int intTickLongest = p_Ticks.getTicksMajorLength() > p_Ticks.getTicksMinorLength() ? p_Ticks.getTicksMajorLength() : p_Ticks.getTicksMinorLength();
        if (p_Ticks.getTicksMajor() > 0.0 && p_Ticks.getTicksMajorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMajor() < 7.0) {
                intPassCount = (int)(7.0 / (doubleDistance * p_Ticks.getTicksMajor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMajor() * (double)intPassCount;
            p_Ticks.setTicksMajorPassCount(intPassCount);
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMajorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        if (p_Ticks.getTicksMinor() > 0.0 && p_Ticks.getTicksMinorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMinor() < 5.0) {
                intPassCount = (int)(5.0 / (doubleDistance * p_Ticks.getTicksMinor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMinor() * (double)intPassCount;
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMinorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        g2d.dispose();
    }

    @Override
    public void calculateLabels(ControlObject.ControlLabels p_Labels) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Labels == null) {
            return;
        }
        if (this.m_MeterBar == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Labels.getControlDimension();
        Insets o_LabelsInsets = p_Labels.getLabelsInsets();
        AbsoluteConstraints o_LabelsConstraints = p_Labels.getConstraints();
        o_LabelsConstraints.width = o_ThisRectangle.width - o_LabelsInsets.left - o_LabelsInsets.right;
        o_LabelsConstraints.height = o_ThisRectangle.height - o_LabelsInsets.top - o_LabelsInsets.bottom;
        o_LabelsConstraints.x = o_LabelsInsets.left;
        o_LabelsConstraints.y = o_LabelsInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_MeterBar.getConstraints();
        double doubleLabelFactor1 = 1.0;
        double doubleLabelFactor2 = 1.0;
        double doubleLabelFactor = 1.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_LabelsConstraints.y;
            intValueLength = o_TrackConstraints.getHeight();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.width / (double)p_Labels.getLabelsSize().width;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().height;
        } else {
            intOffset = o_TrackConstraints.getX() - o_LabelsConstraints.x;
            intValueLength = o_TrackConstraints.getWidth();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.height / (double)p_Labels.getLabelsSize().height;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().width;
        }
        if (doubleLabelFactor2 <= 0.0) {
            doubleLabelFactor2 = doubleLabelFactor1;
        }
        if (!p_Labels.getLabelsSizeFixed()) {
            doubleLabelFactor = doubleLabelFactor1 < doubleLabelFactor2 ? doubleLabelFactor1 : doubleLabelFactor2;
            if (doubleLabelFactor > 1.0) {
                doubleLabelFactor = 1.0;
            }
        } else {
            doubleLabelFactor = 1.0;
        }
        for (int intLabel = 0; intLabel < p_Labels.getControlLabelsCount(); ++intLabel) {
            int intLabelStart;
            ControlObject.ControlLabels.ControlLabel o_ControlLabel = p_Labels.getControlLabel(intLabel);
            if (o_ControlLabel == null) continue;
            AbsoluteConstraints o_LabelConstraints = o_ControlLabel.getConstraints();
            int intLabelPos = (int)(doubleDistance * (o_ControlLabel.getControlLabelDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            o_LabelConstraints.width = (int)((double)p_Labels.getLabelsSize().width * doubleLabelFactor);
            o_LabelConstraints.height = (int)((double)p_Labels.getLabelsSize().height * doubleLabelFactor);
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intLabelPos = intValueLength - intLabelPos;
                }
                intLabelPos -= o_LabelConstraints.height / 2;
                if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(2);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(4);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                    intLabelStart = o_LabelsConstraints.width - o_LabelConstraints.width;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(4);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(2);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_LabelsConstraints.width / 2 - o_LabelConstraints.width / 2;
                    o_ControlLabel.setHorizontalAlignment(0);
                    o_ControlLabel.setVerticalAlignment(0);
                }
                o_LabelConstraints.x = intLabelStart;
                o_LabelConstraints.y = intLabelPos + intOffset;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intLabelPos = intValueLength - intLabelPos;
            }
            intLabelPos -= o_LabelConstraints.width / 2;
            if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(1);
                } else {
                    o_ControlLabel.setVerticalAlignment(3);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                intLabelStart = o_LabelsConstraints.height - o_LabelConstraints.height;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(3);
                } else {
                    o_ControlLabel.setVerticalAlignment(1);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_LabelsConstraints.height / 2 - o_LabelConstraints.height / 2;
                o_ControlLabel.setVerticalAlignment(0);
                o_ControlLabel.setHorizontalAlignment(0);
            }
            o_LabelConstraints.x = intLabelPos + intOffset;
            o_LabelConstraints.y = intLabelStart;
        }
        p_Labels.revalidate();
    }

    @Override
    public void paintLabels(Graphics p_Graphics, ControlObject.ControlLabels p_ControlLabels) {
    }

    @Override
    public void calculateBlocks(ControlObject.ControlBlocks p_Blocks) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Blocks == null) {
            return;
        }
        if (this.m_MeterBar == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Blocks.getControlDimension();
        Insets o_BlocksInsets = p_Blocks.getBlocksInsets();
        AbsoluteConstraints o_BlocksConstraints = p_Blocks.getConstraints();
        o_BlocksConstraints.width = o_ThisRectangle.width - o_BlocksInsets.left - o_BlocksInsets.right;
        o_BlocksConstraints.height = o_ThisRectangle.height - o_BlocksInsets.top - o_BlocksInsets.bottom;
        o_BlocksConstraints.x = o_BlocksInsets.left;
        o_BlocksConstraints.y = o_BlocksInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_MeterBar.getConstraints();
        double doubleBlockWidth = 0.0;
        double doubleBlockHeight = 0.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_BlocksConstraints.y;
            intValueLength = o_TrackConstraints.getHeight();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockWidth = o_BlocksConstraints.width < p_Blocks.getBlocksSize().width ? (double)o_BlocksConstraints.width : (double)p_Blocks.getBlocksSize().width;
        } else {
            intOffset = o_TrackConstraints.getX() - o_BlocksConstraints.x;
            intValueLength = o_TrackConstraints.getWidth();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockHeight = o_BlocksConstraints.height < p_Blocks.getBlocksSize().height ? (double)o_BlocksConstraints.height : (double)p_Blocks.getBlocksSize().height;
        }
        int intStartPos = 0;
        int intEndPos = 0;
        for (int intBlock = 0; intBlock < p_Blocks.getControlBlocksCount(); ++intBlock) {
            int intLabelStart;
            ControlObject.ControlBlocks.ControlBlock o_ControlBlock = p_Blocks.getControlBlock(intBlock);
            if (o_ControlBlock == null) continue;
            AbsoluteConstraints o_BlockConstraints = o_ControlBlock.getConstraints();
            int intDefaultPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            intStartPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueStart() - o_ControlDimension.getValueMinimum()));
            intEndPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueEnd() - o_ControlDimension.getValueMinimum()));
            o_BlockConstraints.width = (int)doubleBlockWidth;
            o_BlockConstraints.height = (int)doubleBlockHeight;
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intStartPos = intValueLength - intStartPos;
                    intEndPos = intValueLength - intEndPos;
                    intDefaultPos = intValueLength - intDefaultPos;
                    o_BlockConstraints.height = intStartPos - intEndPos;
                    o_BlockConstraints.y = intEndPos + intOffset;
                } else {
                    o_BlockConstraints.height = intEndPos - intStartPos;
                    o_BlockConstraints.y = intStartPos + intOffset;
                }
                if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(2);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(4);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                    intLabelStart = o_BlocksConstraints.width - o_BlockConstraints.width;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(4);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(2);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_BlocksConstraints.width / 2 - o_BlockConstraints.width / 2;
                    o_ControlBlock.setHorizontalAlignment(0);
                    o_ControlBlock.setVerticalAlignment(0);
                }
                o_BlockConstraints.x = intLabelStart;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intStartPos = intValueLength - intStartPos;
                intEndPos = intValueLength - intEndPos;
                intDefaultPos = intValueLength - intDefaultPos;
                o_BlockConstraints.width = intStartPos - intEndPos;
                o_BlockConstraints.x = intEndPos + intOffset;
            } else {
                o_BlockConstraints.width = intEndPos - intStartPos;
                o_BlockConstraints.x = intStartPos + intOffset;
            }
            if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(1);
                } else {
                    o_ControlBlock.setVerticalAlignment(3);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                intLabelStart = o_BlocksConstraints.height - o_BlockConstraints.height;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(3);
                } else {
                    o_ControlBlock.setVerticalAlignment(1);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_BlocksConstraints.height / 2 - o_BlockConstraints.height / 2;
                o_ControlBlock.setVerticalAlignment(0);
                o_ControlBlock.setHorizontalAlignment(0);
            }
            o_BlockConstraints.y = intLabelStart;
        }
        p_Blocks.revalidate();
    }

    @Override
    public void paintBlocks(Graphics p_Graphics, ControlObject.ControlBlocks p_ControlBlocks) {
    }

    @Override
    public void setJarResources(JarResources p_JarResources) {
        JarResources oldValue = this.m_Resources;
        this.m_Resources = p_JarResources;
        if (this.m_Resources != null) {
            byte[] o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlMeterBarMinImage");
            Image o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setMeterBarMinImage(o_Image);
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlMeterBarMaxImage");
            o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setMeterBarMaxImage(o_Image);
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlMeterBackground");
            o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = this.m_Resources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("MeterBar_Foreground");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.setForeground(o_Color);
                    o_Field = o_Class.getDeclaredField("MeterBar_MaxColor");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setMeterBarMaxColor(o_Color);
                    o_Field = o_Class.getDeclaredField("MeterBar_MinColor");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setMeterBarMinColor(o_Color);
                    o_Field = o_Class.getDeclaredField("MeterBar_Background");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.setMeterBarMinImage(null);
            this.setMeterBarMinImage(null);
            this.setMeterBarMaxImage(null);
            this.setBackgroundImage(null);
        }
        this.firePropertyChange("jarResources", oldValue, this.m_Resources);
        this.revalidate();
        this.repaint();
    }

    public int getMeterBarWidth() {
        return this.m_MeterBar.getMeterBarWidth();
    }

    public void setMeterBarWidth(int p_MeterBarWidth) {
        this.m_MeterBar.setMeterBarWidth(p_MeterBarWidth);
    }

    public boolean getMeterBarVisible() {
        return this.m_MeterBar.getMeterBarVisible();
    }

    public void setMeterBarVisible(boolean p_Visible) {
        this.m_MeterBar.setMeterBarVisible(p_Visible);
    }

    public boolean getMeterBarOpaque() {
        return this.m_MeterBar.getMeterBarOpaque();
    }

    public void setMeterBarOpaque(boolean p_BarOpaque) {
        this.m_MeterBar.setMeterBarOpaque(p_BarOpaque);
    }

    public Insets getMeterBarInsets() {
        return this.m_MeterBar.getMeterBarInsets();
    }

    public void setMeterBarInsets(Insets p_Insets) {
        this.m_MeterBar.setMeterBarInsets(p_Insets);
    }

    public void setMeterBarInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
        this.setMeterBarInsets(new Insets(p_Top, p_Left, p_Bottom, p_Right));
    }

    public Image getMeterBarMaxImage() {
        return this.m_MeterBar.getMeterBarMaxImage();
    }

    public void setMeterBarMaxImage(Image p_BarImage) {
        this.m_MeterBar.setMeterBarMaxImage(p_BarImage);
    }

    public Image getMeterBarMinImage() {
        return this.m_MeterBar.getMeterBarMinImage();
    }

    public void setMeterBarMinImage(Image p_BarImage) {
        this.m_MeterBar.setMeterBarMinImage(p_BarImage);
    }

    public Color getMeterBarMaxColor() {
        return this.m_MeterBar.getMeterBarMaxColor();
    }

    public void setMeterBarMaxColor(Color p_BarColor) {
        this.m_MeterBar.setMeterBarMaxColor(p_BarColor);
    }

    public Color getMeterBarMinColor() {
        return this.m_MeterBar.getMeterBarMinColor();
    }

    public void setMeterBarMinColor(Color p_BarColor) {
        this.m_MeterBar.setMeterBarMinColor(p_BarColor);
    }

    @Override
    public void calculateDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
        if (p_ControlDisplayItem == null) {
            return;
        }
        if (this.m_MeterBar == null) {
            return;
        }
        Rectangle rectMeterBar = this.m_MeterBar.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_ControlDisplayItem.getControlDimension();
        AbsoluteConstraints o_Constraints = p_ControlDisplayItem.getConstraints();
        double doubleValue = p_ControlDisplayItem.getValueDisplay();
        int intValuePos = this.m_MeterBar.calculateValuePos(doubleValue);
        if (o_ControlDimension.getOrientation() == 1) {
            o_Constraints.x = rectMeterBar.x;
            o_Constraints.width = rectMeterBar.width;
            o_Constraints.y = rectMeterBar.y + intValuePos - 4;
            o_Constraints.height = 9;
        } else {
            o_Constraints.x = rectMeterBar.x + rectMeterBar.width - intValuePos - 4;
            o_Constraints.width = 9;
            o_Constraints.y = rectMeterBar.y;
            o_Constraints.height = rectMeterBar.height;
        }
        p_ControlDisplayItem.revalidate();
    }

    public ControlObject.ControlTicks getControlTicks() {
        return this.m_ControlDimension.getControlTicks();
    }

    public boolean getTicksVisible() {
        return this.m_ControlDimension.getTicksVisible();
    }

    public void setTicksVisible(boolean p_TicksVisible) {
        this.m_ControlDimension.setTicksVisible(p_TicksVisible);
    }

    public double getTicksMajor() {
        return this.m_ControlDimension.getTicksMajor();
    }

    public void setTicksMajor(double p_TicksMajor) {
        this.m_ControlDimension.setTicksMajor(p_TicksMajor);
    }

    public double getTicksMinor() {
        return this.m_ControlDimension.getTicksMinor();
    }

    public void setTicksMinor(double p_TicksMinor) {
        this.m_ControlDimension.setTicksMinor(p_TicksMinor);
    }

    public int getTicksAlignment() {
        return this.m_ControlDimension.getTicksAlignment();
    }

    public void setTicksAlignment(int p_TicksAlignment) {
        this.m_ControlDimension.setTicksAlignment(p_TicksAlignment);
    }

    public int getTicksMajorLength() {
        return this.m_ControlDimension.getTicksMajorLength();
    }

    public void setTicksMajorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMajorLength(p_TicksLength);
    }

    public int getTicksMinorLength() {
        return this.m_ControlDimension.getTicksMinorLength();
    }

    public void setTicksMinorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMinorLength(p_TicksLength);
    }

    public boolean getTicksMirrored() {
        return this.m_ControlDimension.getTicksMirrored();
    }

    public void setTicksMirrored(boolean p_TicksMirrored) {
        this.m_ControlDimension.setTicksMirrored(p_TicksMirrored);
    }

    public Insets getTicksInsets() {
        return this.m_ControlDimension.getTicksInsets();
    }

    public void setTicksInsets(Insets p_TicksInsets) {
        this.m_ControlDimension.setTicksInsets(p_TicksInsets);
    }

    public boolean getLabelsAutomatic() {
        return this.m_ControlDimension.getLabelsAutomatic();
    }

    public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
        this.m_ControlDimension.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsVisible() {
        return this.m_ControlDimension.getLabelsVisible();
    }

    public void setLabelsVisible(boolean p_LabelsVisible) {
        this.m_ControlDimension.setLabelsVisible(p_LabelsVisible);
    }

    public Insets getLabelsInsets() {
        return this.m_ControlDimension.getLabelsInsets();
    }

    public void setLabelsInsets(Insets p_LabelsInsets) {
        this.m_ControlDimension.setLabelsInsets(p_LabelsInsets);
    }

    public int getLabelsAlignment() {
        return this.m_ControlDimension.getLabelsAlignment();
    }

    public void setLabelsAlignment(int p_LabelsAlignment) {
        this.m_ControlDimension.setLabelsAlignment(p_LabelsAlignment);
    }

    public boolean getLabelsMirrored() {
        return this.m_ControlDimension.getLabelsMirrored();
    }

    public void setLabelsMirrored(boolean p_LabelsMirrored) {
        this.m_ControlDimension.setLabelsMirrored(p_LabelsMirrored);
    }

    public Font getLabelsFont() {
        return this.m_ControlDimension.getLabelsFont();
    }

    public void setLabelsFont(Font p_LabelsFont) {
        this.m_ControlDimension.setLabelsFont(p_LabelsFont);
    }

    public void setLabelsTextRotation(double p_Degree) {
        this.m_ControlDimension.setLabelsTextRotation(p_Degree);
    }

    public Border getLabelsBorder() {
        return this.m_ControlDimension.getLabelsBorder();
    }

    public void setLabelsBorder(Border p_LabelsBorder) {
        this.m_ControlDimension.setLabelsBorder(p_LabelsBorder);
    }

    public ControlLabelModel getControlLabelModel() {
        return this.m_ControlDimension.getControlLabelModel();
    }

    public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
        this.m_ControlDimension.setControlLabelModel(p_ControlLabelModel);
    }

    public Dimension getLabelsSize() {
        return this.m_ControlDimension.getLabelsSize();
    }

    public void setLabelsSize(Dimension p_LabelsSize) {
        this.m_ControlDimension.setLabelsSize(p_LabelsSize);
    }

    public void setLabelsSizeFixed(boolean p_LabelsSizeFixed) {
        this.m_ControlDimension.setLabelsSizeFixed(p_LabelsSizeFixed);
    }

    public boolean getLabelsSizeFixed() {
        return this.m_ControlDimension.getLabelsSizeFixed();
    }

    public boolean getBlocksVisible() {
        return this.m_ControlDimension.getBlocksVisible();
    }

    public void setBlocksVisible(boolean p_BlocksVisible) {
        this.m_ControlDimension.setBlocksVisible(p_BlocksVisible);
    }

    public Insets getBlocksInsets() {
        return this.m_ControlDimension.getBlocksInsets();
    }

    public void setBlocksInsets(Insets p_BlocksInsets) {
        this.m_ControlDimension.setBlocksInsets(p_BlocksInsets);
    }

    public int getBlocksAlignment() {
        return this.m_ControlDimension.getBlocksAlignment();
    }

    public void setBlocksAlignment(int p_BlocksAlignment) {
        this.m_ControlDimension.setBlocksAlignment(p_BlocksAlignment);
    }

    public boolean getBlocksMirrored() {
        return this.m_ControlDimension.getBlocksMirrored();
    }

    public void setBlocksMirrored(boolean p_BlocksMirrored) {
        this.m_ControlDimension.setBlocksMirrored(p_BlocksMirrored);
    }

    public Font getBlocksFont() {
        return this.m_ControlDimension.getBlocksFont();
    }

    public void setBlocksFont(Font p_BlocksFont) {
        this.m_ControlDimension.setBlocksFont(p_BlocksFont);
    }

    public void setBlocksTextRotation(double p_Degree) {
        this.m_ControlDimension.setBlocksTextRotation(p_Degree);
    }

    public Border getBlocksBorder() {
        return this.m_ControlDimension.getBlocksBorder();
    }

    public void setBlocksBorder(Border p_BlocksBorder) {
        this.m_ControlDimension.setBlocksBorder(p_BlocksBorder);
    }

    public ControlBlockModel getControlBlockModel() {
        return this.m_ControlDimension.getControlBlockModel();
    }

    public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
        this.m_ControlDimension.setControlBlockModel(p_ControlBlockModel);
    }

    public Dimension getBlocksSize() {
        return this.m_ControlDimension.getBlocksSize();
    }

    public void setBlocksSize(Dimension p_BlocksSize) {
        this.m_ControlDimension.setBlocksSize(p_BlocksSize);
    }

    public int getOrientation() {
        return this.m_ControlDimension.getOrientation();
    }

    public void setOrientation(int p_Orientation) {
        this.m_ControlDimension.setOrientation(p_Orientation);
    }

    public boolean getInverted() {
        return this.m_ControlDimension.getInverted();
    }

    public void setInverted(boolean p_Inverted) {
        this.m_ControlDimension.setInverted(p_Inverted);
    }

    @Override
    public void adjustToValue(ControlObject.ControlDimension p_ControlDimension, double p_Value, boolean p_ManuallySet) {
        if (p_ControlDimension == null) {
            return;
        }
        if (this.m_ControlDimension != p_ControlDimension) {
            return;
        }
        p_ControlDimension.adjustToValue(p_Value, p_ManuallySet);
    }

    public double getValue() {
        return this.m_ControlDimension.getValue();
    }

    public void setValue(double p_Value) {
        this.m_ControlDimension.setValue(p_Value, p_Value - this.m_ControlDimension.getValue(), 0);
    }

    public void setValue(double p_Value, double p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension.setValue(p_Value, p_ValueDiff, p_ActionFlag);
    }

    public double getValueOld() {
        return this.m_ControlDimension.getValueOld();
    }

    public int getValueInt() {
        return this.m_ControlDimension.getValueInt();
    }

    public void setValueInt(int p_Value, int p_ActionFlag) {
        this.m_ControlDimension.setValueInt(p_Value, p_Value - this.m_ControlDimension.getValueInt(), p_ActionFlag);
    }

    public double getValueTransformed() {
        return this.m_ControlDimension.getValueTransformed();
    }

    public void setValueTransformed(double p_MultipliedValue, int p_ActionFlag) {
        this.m_ControlDimension.setValueTransformed(p_MultipliedValue, p_ActionFlag);
    }

    public double getValueMultiplier() {
        return this.m_ControlDimension.getValueMultiplier();
    }

    public void setValueMultiplier(double p_ValueMultiplier) {
        this.m_ControlDimension.setValueMultiplier(p_ValueMultiplier);
    }

    public double getValueOffset() {
        return this.m_ControlDimension.getValueOffset();
    }

    public void setValueOffset(double p_ValueOffset) {
        this.m_ControlDimension.setValueOffset(p_ValueOffset);
    }

    public double getSnapDistance() {
        return this.m_ControlDimension.getSnapDistance();
    }

    public void setSnapDistance(double p_SnapDistance) {
        this.m_ControlDimension.setSnapDistance(p_SnapDistance);
    }

    public double getSnapDistanceTransformed() {
        return this.m_ControlDimension.getSnapDistanceTransformed();
    }

    public void setSnapDistanceTransformed(double p_SnapDistanceTransformed) {
        this.m_ControlDimension.setSnapDistanceTransformed(p_SnapDistanceTransformed);
    }

    public double getValueMaximum() {
        return this.m_ControlDimension.getValueMaximum();
    }

    public void setValueMaximum(double p_Maximum) {
        this.m_ControlDimension.setValueMaximum(p_Maximum);
    }

    public double getValueMinimum() {
        return this.m_ControlDimension.getValueMinimum();
    }

    public void setValueMinimum(double p_Minimum) {
        this.m_ControlDimension.setValueMinimum(p_Minimum);
    }

    public double getMouseWheelStep() {
        return this.m_ControlDimension.getMouseWheelStep();
    }

    public void setMouseWheelStep(double p_ValueDifference) {
        this.m_ControlDimension.setMouseWheelStep(p_ValueDifference);
    }

    protected static class MeterBar
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private ControlObject m_ControlObject;
        private ControlObject.ControlDimension m_ControlDimension;
        private AbsoluteLayout m_LayoutManager;
        protected int m_MeterBarWidth;
        protected boolean m_MeterBarVisible;
        protected boolean m_MeterBarOpaque;
        protected Insets m_MeterBarInsets;
        protected BufferedImage m_MeterBarMinImage;
        protected BufferedImage m_MeterBarMaxImage;
        protected Color m_MeterBarMinColor;
        protected Color m_MeterBarMaxColor;
        protected MeterBar m_SelfReference;
        protected AbsoluteConstraints m_TrackConstraints;
        protected Rectangle m_RectInside;
        protected Rectangle m_RectValueMin;
        protected Rectangle m_RectValueMax;
        protected Rectangle m_RectRest;
        protected Rectangle m_OldRectSize;
        private boolean m_RepaintFlag;
        protected BufferedImage m_MinImage;
        protected BufferedImage m_MaxImage;
        protected int m_OldOrientation;

        public MeterBar(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension = p_ControlObject.getControlDimension(0);
            this.initMembers();
            this.initComponents();
            this.calculate();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.setBackground(Color.LIGHT_GRAY);
            this.m_MeterBarWidth = 5;
            this.m_MeterBarVisible = true;
            this.m_MeterBarOpaque = false;
            this.m_MeterBarInsets = this.m_ControlDimension.getOrientation() == 1 ? new Insets(17, 18, 17, 18) : new Insets(18, 17, 18, 17);
            this.m_MeterBarMinColor = new Color(180, 0, 0);
            this.m_MeterBarMaxColor = new Color(255, 0, 0);
            this.m_OldOrientation = 1;
            this.m_RepaintFlag = true;
            this.m_OldRectSize = new Rectangle(0, 0, 0, 0);
            this.m_RectInside = new Rectangle(0, 0, 0, 0);
            this.m_RectValueMin = new Rectangle();
            this.m_RectValueMax = new Rectangle();
            this.m_RectRest = new Rectangle();
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeBoolean(this.m_MeterBarVisible);
            p_ObjectOutput.writeBoolean(this.m_MeterBarOpaque);
            p_ObjectOutput.writeInt(this.m_MeterBarWidth);
            ImagesTools.writeInsets((ObjectOutput)p_ObjectOutput, (Insets)this.m_MeterBarInsets);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_MeterBarMinColor);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_MeterBarMaxColor);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_MeterBarMinImage);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_MeterBarMaxImage);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_MeterBarVisible = p_ObjectInput.readBoolean();
            this.m_MeterBarOpaque = p_ObjectInput.readBoolean();
            this.m_MeterBarWidth = p_ObjectInput.readInt();
            this.m_MeterBarInsets = ImagesTools.readInsets((ObjectInput)p_ObjectInput);
            this.m_MeterBarMinColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            this.m_MeterBarMaxColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            Image o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_MeterBarMinImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_MeterBarMaxImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            this.calculate();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_TrackConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.setVisible(true);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_TrackConstraints;
        }

        public int getMeterBarWidth() {
            return this.m_MeterBarWidth;
        }

        public void setMeterBarWidth(int p_MeterBarWidth) {
            double oldValue = this.m_MeterBarWidth;
            this.m_MeterBarWidth = p_MeterBarWidth;
            this.firePropertyChange(JControlMeter.PROP_METERBARWIDTH, oldValue, (double)this.m_MeterBarWidth);
        }

        public boolean getMeterBarVisible() {
            return this.m_MeterBarVisible;
        }

        public void setMeterBarVisible(boolean p_Visible) {
            boolean oldValue = this.m_MeterBarVisible;
            this.m_MeterBarVisible = p_Visible;
            this.firePropertyChange(JControlMeter.PROP_METERBARVISIBLE, oldValue, this.m_MeterBarVisible);
        }

        public boolean getMeterBarOpaque() {
            return this.m_MeterBarOpaque;
        }

        public void setMeterBarOpaque(boolean p_BarOpaque) {
            boolean oldValue = this.m_MeterBarOpaque;
            this.m_MeterBarOpaque = p_BarOpaque;
            this.firePropertyChange("meterBarColor", oldValue, this.m_MeterBarOpaque);
        }

        public Insets getMeterBarInsets() {
            return this.m_MeterBarInsets;
        }

        public void setMeterBarInsets(Insets p_Insets) {
            Insets oldValue = this.m_MeterBarInsets;
            this.m_MeterBarInsets = p_Insets;
            this.m_ControlObject.calculateInnerItems();
            this.firePropertyChange(JControlMeter.PROP_METERBARINSETS, oldValue, this.m_MeterBarInsets);
        }

        public void setMeterBarInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
            this.setMeterBarInsets(new Insets(p_Top, p_Left, p_Bottom, p_Right));
        }

        public Image getMeterBarMaxImage() {
            return this.m_MeterBarMaxImage;
        }

        public void setMeterBarMaxImage(Image p_BarImage) {
            BufferedImage oldValue = this.m_MeterBarMaxImage;
            this.m_MeterBarMaxImage = ImagesTools.convertToBufferedImage((Image)p_BarImage);
            this.firePropertyChange(JControlMeter.PROP_METERBARIMAGE, oldValue, this.m_MeterBarMaxImage);
            this.m_RepaintFlag = true;
            this.calculate();
        }

        public Image getMeterBarMinImage() {
            return this.m_MeterBarMinImage;
        }

        public void setMeterBarMinImage(Image p_BarImage) {
            BufferedImage oldValue = this.m_MeterBarMinImage;
            this.m_MeterBarMinImage = ImagesTools.convertToBufferedImage((Image)p_BarImage);
            this.firePropertyChange(JControlMeter.PROP_METERBARIMAGE, oldValue, this.m_MeterBarMinImage);
            this.m_RepaintFlag = true;
            this.calculate();
        }

        public Color getMeterBarMaxColor() {
            return this.m_MeterBarMaxColor;
        }

        public void setMeterBarMaxColor(Color p_BarColor) {
            Color oldValue = this.m_MeterBarMaxColor;
            this.m_MeterBarMaxColor = p_BarColor;
            this.firePropertyChange("meterBarColor", oldValue, this.m_MeterBarMaxColor);
            this.calculate();
        }

        public Color getMeterBarMinColor() {
            return this.m_MeterBarMinColor;
        }

        public void setMeterBarMinColor(Color p_BarColor) {
            Color oldValue = this.m_MeterBarMinColor;
            this.m_MeterBarMinColor = p_BarColor;
            this.firePropertyChange("meterBarColor", oldValue, this.m_MeterBarMinColor);
            this.calculate();
        }

        public void calculate() {
            this.revalidate();
            this.repaint();
        }

        public int calculateValuePos(double p_Value) {
            int intWide = this.m_ControlDimension.getOrientation() == 1 ? this.m_TrackConstraints.getHeight() : this.m_TrackConstraints.getWidth();
            if (p_Value < this.m_ControlDimension.getValueMinimum()) {
                p_Value = this.m_ControlDimension.getValueMinimum();
            }
            if (p_Value > this.m_ControlDimension.getValueMaximum()) {
                p_Value = this.m_ControlDimension.getValueMaximum();
            }
            double doubleDistance = (double)intWide / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
            int intValuePos = (int)((p_Value - this.m_ControlDimension.getValueMinimum()) * doubleDistance);
            if (!this.m_ControlDimension.getInverted()) {
                intValuePos = intWide - intValuePos;
            }
            return intValuePos;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            boolean boolWidthChanged = false;
            boolean boolHeightChanged = false;
            double doubleValueDisplayMax = this.m_ControlDimension.getValueMinimum();
            double doubleValueDisplayMin = this.m_ControlDimension.getValueMaximum();
            for (int intDisplay = 0; intDisplay < this.m_ControlDimension.getControlDisplayItemsCount(); ++intDisplay) {
                double doubleValueDisplay = this.m_ControlDimension.getControlDisplayItem(intDisplay).getValueDisplay();
                if (doubleValueDisplayMax < doubleValueDisplay) {
                    doubleValueDisplayMax = doubleValueDisplay;
                }
                if (!(doubleValueDisplayMin > doubleValueDisplay)) continue;
                doubleValueDisplayMin = doubleValueDisplay;
            }
            if (doubleValueDisplayMin > doubleValueDisplayMax) {
                doubleValueDisplayMin = doubleValueDisplayMax;
            }
            if (this.m_MeterBarVisible) {
                float floatFactorY;
                float floatFactorX;
                int intValuePosMax;
                int intValuePosMin;
                this.m_RectInside.setBounds(this.m_TrackConstraints.x, this.m_TrackConstraints.y, this.m_TrackConstraints.width, this.m_TrackConstraints.height);
                if (this.m_ControlDimension.getOrientation() == 1) {
                    this.m_RectInside.x = (int)((double)(this.m_RectInside.width - this.m_MeterBarWidth) / 2.0 + 0.5);
                    this.m_RectInside.y = 0;
                    this.m_RectInside.width = this.m_MeterBarWidth;
                    double doubleDistance = (double)this.m_RectInside.height / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
                    intValuePosMin = (int)((doubleValueDisplayMin - this.m_ControlDimension.getValueMinimum()) * doubleDistance);
                    intValuePosMax = (int)((doubleValueDisplayMax - this.m_ControlDimension.getValueMinimum()) * doubleDistance);
                    if (!this.m_ControlDimension.getInverted()) {
                        intValuePosMin = this.m_RectInside.height - intValuePosMin;
                        intValuePosMax = this.m_RectInside.height - intValuePosMax;
                    }
                } else {
                    this.m_RectInside.y = (int)((double)(this.m_RectInside.height - this.m_MeterBarWidth) / 2.0 + 0.5);
                    this.m_RectInside.x = 0;
                    this.m_RectInside.height = this.m_MeterBarWidth;
                    double doubleDistance = (double)this.m_RectInside.width / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
                    intValuePosMin = (int)((doubleValueDisplayMin - this.m_ControlDimension.getValueMinimum()) * doubleDistance);
                    intValuePosMax = (int)((doubleValueDisplayMax - this.m_ControlDimension.getValueMinimum()) * doubleDistance);
                    if (this.m_ControlDimension.getInverted()) {
                        intValuePosMin = this.m_RectInside.width - intValuePosMin;
                        intValuePosMax = this.m_RectInside.width - intValuePosMax;
                    }
                }
                if (this.m_RectInside.getWidth() != this.m_OldRectSize.getWidth()) {
                    boolWidthChanged = true;
                }
                if (this.m_RectInside.getHeight() != this.m_OldRectSize.getHeight()) {
                    boolHeightChanged = true;
                }
                this.m_OldRectSize.setRect(this.m_RectInside.getX(), this.m_RectInside.getY(), this.m_RectInside.getWidth(), this.m_RectInside.getHeight());
                if (this.m_RectInside.getWidth() <= 0.0 || this.m_RectInside.getHeight() <= 0.0) {
                    return;
                }
                if (this.m_RepaintFlag || this.m_OldOrientation != this.m_ControlDimension.getOrientation()) {
                    if (this.m_ControlDimension.getOrientation() == 1) {
                        this.m_MaxImage = this.m_MeterBarMaxImage;
                        this.m_MinImage = this.m_MeterBarMinImage;
                    } else {
                        if (this.m_MeterBarMaxImage != null) {
                            this.m_MaxImage = ImagesTools.rotateImage90_right((BufferedImage)this.m_MeterBarMaxImage);
                        }
                        if (this.m_MeterBarMinImage != null) {
                            this.m_MinImage = ImagesTools.rotateImage90_right((BufferedImage)this.m_MeterBarMinImage);
                        }
                    }
                    if (this.m_ControlDimension.getInverted()) {
                        if (this.m_MeterBarMaxImage != null) {
                            this.m_MaxImage = ImagesTools.rotateImage180((BufferedImage)this.m_MeterBarMaxImage);
                        }
                        if (this.m_MeterBarMinImage != null) {
                            this.m_MinImage = ImagesTools.rotateImage180((BufferedImage)this.m_MeterBarMinImage);
                        }
                    }
                    this.m_OldOrientation = this.m_ControlDimension.getOrientation();
                }
                Graphics2D g2d = (Graphics2D)p_Graphics;
                g2d.setColor(Color.BLACK);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.x, this.m_RectInside.y + this.m_RectInside.height);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(this.m_RectInside.x, this.m_RectInside.y + this.m_RectInside.height, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y + this.m_RectInside.height);
                g2d.drawLine(this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y, this.m_RectInside.x + this.m_RectInside.width, this.m_RectInside.y + this.m_RectInside.height);
                ++this.m_RectInside.x;
                ++this.m_RectInside.y;
                --this.m_RectInside.width;
                --this.m_RectInside.height;
                if (this.m_RectInside.width == 0) {
                    this.m_RectInside.width = 1;
                }
                if (this.m_RectInside.height == 0) {
                    this.m_RectInside.height = 1;
                }
                if (this.m_ControlDimension.getOrientation() == 1) {
                    if (!this.m_ControlDimension.getInverted()) {
                        this.m_RectValueMin.setRect(this.m_RectInside.x, intValuePosMin, this.m_RectInside.width, this.m_RectInside.height - intValuePosMin);
                        this.m_RectValueMax.setRect(this.m_RectInside.x, intValuePosMax, this.m_RectInside.width, intValuePosMin - intValuePosMax);
                        this.m_RectRest.setRect(this.m_RectInside.x, 0.0, this.m_RectInside.width, intValuePosMax);
                    } else {
                        this.m_RectValueMin.setRect(this.m_RectInside.x, 0.0, this.m_RectInside.width, intValuePosMin - 0);
                        this.m_RectValueMax.setRect(this.m_RectInside.x, intValuePosMin, this.m_RectInside.width, intValuePosMax - intValuePosMin);
                        this.m_RectRest.setRect(this.m_RectInside.x, intValuePosMax, this.m_RectInside.width, this.m_RectInside.height - intValuePosMax);
                    }
                } else if (!this.m_ControlDimension.getInverted()) {
                    this.m_RectValueMin.setRect(0.0, this.m_RectInside.y, intValuePosMin - 0, this.m_RectInside.height);
                    this.m_RectValueMax.setRect(intValuePosMin, this.m_RectInside.y, intValuePosMax - intValuePosMin, this.m_RectInside.height);
                    this.m_RectRest.setRect(intValuePosMax, this.m_RectInside.y, this.m_RectInside.width - intValuePosMax, this.m_RectInside.height);
                } else {
                    this.m_RectValueMin.setRect(intValuePosMin, this.m_RectInside.y, this.m_RectInside.width - intValuePosMin, this.m_RectInside.height);
                    this.m_RectValueMax.setRect(intValuePosMax, this.m_RectInside.y, intValuePosMin - intValuePosMax, intValuePosMin);
                    this.m_RectRest.setRect(0.0, this.m_RectInside.y, intValuePosMax - 0, this.m_RectInside.height);
                }
                if (this.m_MaxImage != null) {
                    floatFactorX = (float)this.m_MaxImage.getWidth() / (float)this.m_RectInside.width;
                    floatFactorY = (float)this.m_MaxImage.getHeight() / (float)this.m_RectInside.height;
                    g2d.drawImage(this.m_MaxImage, this.m_RectValueMax.x, this.m_RectValueMax.y, this.m_RectValueMax.x + this.m_RectValueMax.width, this.m_RectValueMax.y + this.m_RectValueMax.height, (int)((double)((float)(this.m_RectValueMax.x - this.m_RectInside.x) * floatFactorX) + 0.5), (int)((double)((float)(this.m_RectValueMax.y - this.m_RectInside.y) * floatFactorY) + 0.5), (int)((double)((float)(this.m_RectValueMax.x - this.m_RectInside.x + this.m_RectValueMax.width) * floatFactorX) + 0.5), (int)((double)((float)(this.m_RectValueMax.y - this.m_RectInside.y + this.m_RectValueMax.height) * floatFactorY) + 0.5), this);
                } else {
                    g2d.setColor(this.m_MeterBarMaxColor);
                    g2d.fillRect(this.m_RectValueMax.x, this.m_RectValueMax.y, this.m_RectValueMax.width, this.m_RectValueMax.height);
                }
                if (this.m_MinImage != null) {
                    floatFactorX = (float)this.m_MinImage.getWidth() / (float)this.m_RectInside.width;
                    floatFactorY = (float)this.m_MinImage.getHeight() / (float)this.m_RectInside.height;
                    g2d.drawImage(this.m_MinImage, this.m_RectValueMin.x, this.m_RectValueMin.y, this.m_RectValueMin.x + this.m_RectValueMin.width, this.m_RectValueMin.y + this.m_RectValueMin.height, (int)((double)((float)(this.m_RectValueMin.x - this.m_RectInside.x) * floatFactorX) + 0.5), (int)((double)((float)(this.m_RectValueMin.y - this.m_RectInside.y) * floatFactorY) + 0.5), (int)((double)((float)(this.m_RectValueMin.x - this.m_RectInside.x + this.m_RectValueMin.width) * floatFactorX) + 0.5), (int)((double)((float)(this.m_RectValueMin.y - this.m_RectInside.y + this.m_RectValueMin.height) * floatFactorY) + 0.5), this);
                } else {
                    g2d.setColor(this.m_MeterBarMinColor);
                    g2d.fillRect(this.m_RectValueMin.x, this.m_RectValueMin.y, this.m_RectValueMin.width, this.m_RectValueMin.height);
                }
                if (this.m_MeterBarOpaque) {
                    g2d.setColor(this.getParent().getBackground());
                    g2d.fillRect(this.m_RectRest.x, this.m_RectRest.y, this.m_RectRest.width, this.m_RectRest.height);
                }
            }
            this.m_RepaintFlag = false;
            super.paintComponent(p_Graphics);
        }
    }
}

