/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControls.CorrectionModel;
import LiveShowControls.JControlMeter;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JControlCorrection
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_GRIDCLICKED = "jcontrolcorrectionGridClicked";
    public static Border s_BorderSelected = new LineBorder(Color.BLUE, 2);
    private ArrayList<Double> m_HelplineXPositions;
    private CorrectionGrid m_CorrectionGrid;
    private JButton jButton_FixPoints;
    private JControlMeter jControlMeterInput;
    private JControlMeter jControlMeterOutput;

    public JControlCorrection() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
    }

    private void initComponents() {
        this.jControlMeterOutput = new JControlMeter();
        this.jControlMeterInput = new JControlMeter();
        this.jButton_FixPoints = new JButton();
        this.setLayout(new GridBagLayout());
        this.jControlMeterOutput.setForeground(new Color(255, 255, 255));
        this.jControlMeterOutput.setToolTipText("output");
        this.jControlMeterOutput.setLabelsAutomatic(true);
        this.jControlMeterOutput.setMeterBarInsets(new Insets(10, 15, 10, 0));
        this.jControlMeterOutput.setMeterBarMaxColor(new Color(204, 204, 204));
        this.jControlMeterOutput.setMeterBarMinColor(new Color(153, 153, 153));
        this.jControlMeterOutput.setMeterBarWidth(3);
        this.jControlMeterOutput.setPreferredSize(new Dimension(35, 50));
        this.jControlMeterOutput.setTicksInsets(new Insets(0, 15, 0, 0));
        this.jControlMeterOutput.setTicksMajor(5.0);
        this.jControlMeterOutput.setTicksMinor(2.5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jControlMeterOutput, gridBagConstraints);
        this.jControlMeterInput.setForeground(new Color(255, 255, 255));
        this.jControlMeterInput.setToolTipText("input");
        this.jControlMeterInput.setLabelsAutomatic(true);
        this.jControlMeterInput.setLabelsInsets(new Insets(15, 0, 0, 0));
        this.jControlMeterInput.setLabelsMirrored(false);
        this.jControlMeterInput.setMeterBarInsets(new Insets(0, 10, 15, 10));
        this.jControlMeterInput.setMeterBarMaxColor(new Color(204, 204, 204));
        this.jControlMeterInput.setMeterBarMinColor(new Color(153, 153, 153));
        this.jControlMeterInput.setMeterBarWidth(3);
        this.jControlMeterInput.setOrientation(0);
        this.jControlMeterInput.setPreferredSize(new Dimension(50, 30));
        this.jControlMeterInput.setTicksInsets(new Insets(0, 0, 15, 0));
        this.jControlMeterInput.setTicksMajor(5.0);
        this.jControlMeterInput.setTicksMinor(2.5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jControlMeterInput, gridBagConstraints);
        this.jButton_FixPoints.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Object_Fixed.png")));
        this.jButton_FixPoints.setToolTipText("Fix point's input value");
        this.jButton_FixPoints.setContentAreaFilled(false);
        this.jButton_FixPoints.setIconTextGap(0);
        this.jButton_FixPoints.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_FixPoints.setMaximumSize(new Dimension(24, 24));
        this.jButton_FixPoints.setMinimumSize(new Dimension(24, 24));
        this.jButton_FixPoints.setPreferredSize(new Dimension(24, 24));
        this.jButton_FixPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlCorrection.this.jButton_FixPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jButton_FixPoints, gridBagConstraints);
    }

    private void jButton_FixPointsActionPerformed(ActionEvent evt) {
        if (this.getFixPoints()) {
            this.setFixPoints(false);
        } else {
            this.setFixPoints(true);
        }
    }

    private void initComponentsFurther() {
        this.m_CorrectionGrid = new CorrectionGrid(this, this.jControlMeterInput, this.jControlMeterOutput);
        this.m_CorrectionGrid.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 1;
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 1.0;
        o_GridBagConstraints.fill = 1;
        o_GridBagConstraints.insets = new Insets(this.jControlMeterOutput.getMeterBarInsets().top, this.jControlMeterInput.getMeterBarInsets().left, this.jControlMeterOutput.getMeterBarInsets().bottom, this.jControlMeterInput.getMeterBarInsets().right);
        this.add((Component)this.m_CorrectionGrid, o_GridBagConstraints);
        this.m_CorrectionGrid.setVisible(true);
        CorrectionModel o_CorrectionModel = new CorrectionModel();
        this.setCorrectionModel(o_CorrectionModel);
        this.jButton_FixPoints.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jControlMeterInput.getControlDimension().addPropertyChangeListener(this);
        this.jControlMeterOutput.getControlDimension().addPropertyChangeListener(this);
    }

    public void refresh() {
        CorrectionModel o_CorrectionModel = this.m_CorrectionGrid.getCorrectionModel();
        if (o_CorrectionModel == null) {
            this.jButton_FixPoints.setBorder(null);
            this.jButton_FixPoints.setBorderPainted(false);
            this.jButton_FixPoints.setEnabled(false);
        } else {
            if (o_CorrectionModel.getFixPoints()) {
                this.jButton_FixPoints.setBorder(s_BorderSelected);
                this.jButton_FixPoints.setBorderPainted(true);
            } else {
                this.jButton_FixPoints.setBorder(null);
                this.jButton_FixPoints.setBorderPainted(false);
            }
            this.jButton_FixPoints.setEnabled(true);
        }
    }

    public void setCorrectionModel(CorrectionModel p_CorrectionModel) {
        this.m_CorrectionGrid.setCorrectionModel(p_CorrectionModel);
    }

    public CorrectionModel getCorrectionModel() {
        return this.m_CorrectionGrid.getCorrectionModel();
    }

    public void setFixPoints(boolean p_FixPoints) {
        this.m_CorrectionGrid.setFixPoints(p_FixPoints);
    }

    public boolean getFixPoints() {
        return this.m_CorrectionGrid.getFixPoints();
    }

    public void gridClicked(double p_X, double p_Y) {
        Point2D.Double o_Point2D = new Point2D.Double(p_X, p_Y);
        this.firePropertyChange(PROP_GRIDCLICKED, null, o_Point2D);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.jControlMeterInput.getControlDimension()) {
            if ("value".equals(evt.getPropertyName())) {
                double doubleValueNormed = this.jControlMeterInput.getValue() / this.jControlMeterInput.getValueMaximum();
                this.gridClicked(doubleValueNormed, Double.NaN);
            }
        } else if (evt.getSource() == this.jControlMeterOutput.getControlDimension() && "value".equals(evt.getPropertyName())) {
            double doubleValueNormed = this.jControlMeterOutput.getValue() / this.jControlMeterInput.getValueMaximum();
            this.gridClicked(Double.NaN, doubleValueNormed);
        }
    }

    public static class CorrectionGrid
    extends JPanel
    implements PropertyChangeListener {
        private JControlCorrection m_JControlCorrection;
        private JControlMeter m_JControlMeter_Input;
        private JControlMeter m_JControlMeter_Output;
        private CorrectionModel m_CorrectionModel;
        private ArrayList<JLabelCorrectionPoint> m_JLabelCorrectionPoints;
        private Runnable m_RunnableRefreshPoints;
        private boolean m_FixPoints;
        private Dimension m_OldSize;
        private final Object m_SyncObject = new Object();

        public CorrectionGrid(JControlCorrection p_JControlCorrection, JControlMeter p_JControlMeter_Input, JControlMeter p_JControlMeter_Output) {
            this.initMembers();
            this.m_JControlCorrection = p_JControlCorrection;
            this.m_JControlMeter_Input = p_JControlMeter_Input;
            this.m_JControlMeter_Output = p_JControlMeter_Output;
            this.initComponents();
        }

        private void initMembers() {
            this.m_CorrectionModel = null;
            this.m_FixPoints = true;
            this.m_OldSize = new Dimension(0, 0);
            this.m_JLabelCorrectionPoints = new ArrayList();
            this.m_RunnableRefreshPoints = new Runnable(){

                @Override
                public void run() {
                    this.refreshPoints();
                }
            };
        }

        private void initComponents() {
            this.setLayout(new AbsoluteLayout());
            this.setBackground(Color.WHITE);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (this.getWidth() == ((CorrectionGrid)this).m_OldSize.width && this.getHeight() == ((CorrectionGrid)this).m_OldSize.height) {
                        return;
                    }
                    m_OldSize.setSize(this.getWidth(), this.getHeight());
                    EventQueueHandler.invokeLater((Runnable)m_RunnableRefreshPoints);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent p_MouseEvent) {
                    int intX = p_MouseEvent.getX();
                    int intY = this.getHeight() - p_MouseEvent.getY();
                    double doubleXNormed = (double)intX / (double)this.getWidth();
                    double doubleYNormed = (double)intY / (double)this.getHeight();
                    m_JControlCorrection.gridClicked(doubleXNormed, doubleYNormed);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCorrectionModel(CorrectionModel p_CorrectionModel) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_CorrectionModel == p_CorrectionModel) {
                    return;
                }
                if (this.m_CorrectionModel != null) {
                    this.m_CorrectionModel.removePropertyChangeListener(this);
                }
                this.m_CorrectionModel = p_CorrectionModel;
                if (this.m_CorrectionModel != null) {
                    this.m_CorrectionModel.addPropertyChangeListener(this);
                    this.m_CorrectionModel.setFixPoints(this.m_FixPoints);
                }
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRefreshPoints);
                this.m_JControlCorrection.refresh();
            }
        }

        public CorrectionModel getCorrectionModel() {
            return this.m_CorrectionModel;
        }

        public void setFixPoints(boolean p_FixPoints) {
            this.m_FixPoints = p_FixPoints;
            if (this.m_CorrectionModel != null) {
                this.m_CorrectionModel.setFixPoints(p_FixPoints);
            }
            this.m_JControlCorrection.refresh();
        }

        public boolean getFixPoints() {
            if (this.m_CorrectionModel != null) {
                return this.m_CorrectionModel.getFixPoints();
            }
            return this.m_FixPoints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPoints() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_CorrectionModel == null) {
                    this.m_JLabelCorrectionPoints.clear();
                } else {
                    JLabelCorrectionPoint o_JLabelCorrectionPoint;
                    int intPointsCount = this.m_CorrectionModel.getCorrectionPointCount();
                    int intLabelsCount = this.m_JLabelCorrectionPoints.size();
                    for (int intPoint = 0; intPoint < intPointsCount; ++intPoint) {
                        Point2D.Double o_Point2D = this.m_CorrectionModel.getCorrectionPoint(intPoint);
                        if (o_Point2D == null) continue;
                        if (intPoint < intLabelsCount) {
                            o_JLabelCorrectionPoint = this.m_JLabelCorrectionPoints.get(intPoint);
                        } else {
                            o_JLabelCorrectionPoint = new JLabelCorrectionPoint(this);
                            this.m_JControlMeter_Input.createControlDisplayItem(o_JLabelCorrectionPoint, "valueX");
                            this.m_JControlMeter_Output.createControlDisplayItem(o_JLabelCorrectionPoint, "valueY");
                            this.m_JLabelCorrectionPoints.add(o_JLabelCorrectionPoint);
                            intLabelsCount = this.m_JLabelCorrectionPoints.size();
                            this.add((Component)o_JLabelCorrectionPoint, o_JLabelCorrectionPoint.getAbsoluteConstraints());
                        }
                        o_JLabelCorrectionPoint.setCorrectionPoint(o_Point2D);
                        o_JLabelCorrectionPoint.refresh();
                        o_JLabelCorrectionPoint.setVisible(true);
                    }
                    for (int intLabel = intLabelsCount - 1; intLabel >= intPointsCount; --intLabel) {
                        if (intLabel < 0) continue;
                        o_JLabelCorrectionPoint = this.m_JLabelCorrectionPoints.get(intLabel);
                        this.m_JLabelCorrectionPoints.remove(intLabel);
                        this.m_JControlMeter_Input.removeControlDisplayItem(o_JLabelCorrectionPoint, "valueX");
                        this.m_JControlMeter_Output.removeControlDisplayItem(o_JLabelCorrectionPoint, "valueY");
                        this.remove(o_JLabelCorrectionPoint);
                        o_JLabelCorrectionPoint.close();
                        o_JLabelCorrectionPoint.setVisible(false);
                    }
                }
            }
            this.revalidate();
            if (!SwingUtilities.isEventDispatchThread()) {
                System.out.println(this.getClass().getName() + "refreshPoints");
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics p_Graphics) {
            super.paint(p_Graphics);
            if (this.m_CorrectionModel == null) {
                return;
            }
            if (this.m_CorrectionModel.getCorrectionPointCount() < 2) {
                return;
            }
            Color oldColor = p_Graphics.getColor();
            p_Graphics.setColor(Color.BLACK);
            this.m_CorrectionModel.draw(p_Graphics, this.getWidth(), this.getHeight());
            p_Graphics.setColor(oldColor);
        }

        private void setPointSelected(Point2D.Double p_CorrectionPoint) {
            for (int intLabel = 0; intLabel < this.m_JLabelCorrectionPoints.size(); ++intLabel) {
                JLabelCorrectionPoint o_JLabelCorrectionPoint = this.m_JLabelCorrectionPoints.get(intLabel);
                if (o_JLabelCorrectionPoint.getCorrectionPoint().equals(p_CorrectionPoint)) {
                    o_JLabelCorrectionPoint.setSelected(true);
                    continue;
                }
                o_JLabelCorrectionPoint.setSelected(false);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof CorrectionModel) {
                if ("correctionmodelPointAdded".equals(evt.getPropertyName())) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableRefreshPoints);
                }
                if ("correctionmodelPointRemoved".equals(evt.getPropertyName())) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableRefreshPoints);
                } else if ("correctionmodelPointMoved".equals(evt.getPropertyName())) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableRefreshPoints);
                } else if ("correctionmodelPointSelected".equals(evt.getPropertyName())) {
                    this.setPointSelected((Point2D.Double)evt.getNewValue());
                } else if ("correctionmodelPointsFIXED".equals(evt.getPropertyName())) {
                    this.m_JControlCorrection.refresh();
                }
            }
        }

        public static class JLabelCorrectionPoint
        extends JLabel
        implements MouseListener,
        MouseMotionListener {
            public static final String PROP_VALUEX = "valueX";
            public static final String PROP_VALUEY = "valueY";
            public static Dimension s_Dimension = new Dimension(16, 16);
            public static Border s_Border = new LineBorder(Color.BLACK, 1);
            private CorrectionGrid m_CorrectionGrid;
            private AbsoluteConstraints m_AbsoluteConstraints;
            private Point2D.Double m_CorrectionPoint;
            private int m_PressedX;
            private int m_PressedY;
            private double m_DisplayMaxValue;

            public JLabelCorrectionPoint(CorrectionGrid p_CorrectionGrid) {
                this.m_CorrectionGrid = p_CorrectionGrid;
                this.initMembers();
                this.initComponentsFurther();
                this.m_DisplayMaxValue = this.m_CorrectionGrid.m_JControlMeter_Input.getValueMaximum();
            }

            private void initMembers() {
            }

            private void initComponentsFurther() {
                this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
                super.setBorder(s_Border);
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.m_AbsoluteConstraints.height = JLabelCorrectionPoint.s_Dimension.height;
                this.m_AbsoluteConstraints.width = JLabelCorrectionPoint.s_Dimension.width;
            }

            public void close() {
                this.setVisible(false);
            }

            public void setCorrectionPoint(Point2D.Double p_CorrectionPoint) {
                double oldValueX = -1.0;
                double oldValueY = -1.0;
                this.m_CorrectionPoint = p_CorrectionPoint;
                if (this.m_CorrectionPoint != null) {
                    this.firePropertyChange(PROP_VALUEX, oldValueX, this.m_CorrectionPoint.getX() * this.m_DisplayMaxValue);
                    this.firePropertyChange(PROP_VALUEY, oldValueY, this.m_CorrectionPoint.getY() * this.m_DisplayMaxValue);
                }
            }

            public Point2D.Double getCorrectionPoint() {
                return this.m_CorrectionPoint;
            }

            public double getValueX() {
                if (this.m_CorrectionPoint == null) {
                    return 0.0;
                }
                return this.m_CorrectionPoint.getX();
            }

            public double getValueY() {
                if (this.m_CorrectionPoint == null) {
                    return 0.0;
                }
                return this.m_CorrectionPoint.getY();
            }

            public void setSelected(boolean p_Selected) {
                if (p_Selected) {
                    super.setBackground(Color.BLUE);
                    super.setOpaque(true);
                } else {
                    this.setOpaque(false);
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    System.out.println(this.getClass().getName() + "setSelected");
                }
                this.repaint();
            }

            public void refresh() {
                if (this.m_CorrectionPoint == null) {
                    this.setVisible(false);
                } else {
                    this.m_CorrectionPoint.getX();
                    this.m_AbsoluteConstraints.x = (int)((double)this.m_CorrectionGrid.getWidth() * this.m_CorrectionPoint.getX() + 0.5) - JLabelCorrectionPoint.s_Dimension.width / 2;
                    this.m_AbsoluteConstraints.y = this.m_CorrectionGrid.getHeight() - (int)((double)this.m_CorrectionGrid.getHeight() * this.m_CorrectionPoint.getY() + 0.5) - JLabelCorrectionPoint.s_Dimension.height / 2;
                }
                this.m_CorrectionGrid.revalidate();
            }

            public AbsoluteConstraints getAbsoluteConstraints() {
                return this.m_AbsoluteConstraints;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.m_CorrectionGrid.getCorrectionModel() == null) {
                    return;
                }
                this.m_CorrectionGrid.getCorrectionModel().setSelectedCorrectionPoint(this.m_CorrectionPoint);
                this.m_PressedX = e.getX();
                this.m_PressedY = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.m_CorrectionGrid == null) {
                    return;
                }
                CorrectionModel o_CorrectionModel = this.m_CorrectionGrid.m_CorrectionModel;
                if (o_CorrectionModel == null) {
                    return;
                }
                double doubleX = this.m_CorrectionPoint.getX() + ((double)e.getX() - (double)this.m_PressedX) / (double)this.m_CorrectionGrid.getWidth();
                double doubleY = this.m_CorrectionPoint.getY() - ((double)e.getY() - (double)this.m_PressedY) / (double)this.m_CorrectionGrid.getHeight();
                o_CorrectionModel.moveCorrectionPoint(this.m_CorrectionPoint, doubleX, doubleY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
    }
}

