/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import LiveShowObjectPackage.SinglePropertyChangeSupport;
import ToolsGraphics.GraphicsTools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class CorrectionModel
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String PROP_CORRECTIONMODEL_POINTADDED = "correctionmodelPointAdded";
    public static final String PROP_CORRECTIONMODEL_POINTREMOVED = "correctionmodelPointRemoved";
    public static final String PROP_CORRECTIONMODEL_POINTSELECTED = "correctionmodelPointSelected";
    public static final String PROP_CORRECTIONMODEL_POINTMOVED = "correctionmodelPointMoved";
    public static final String PROP_CORRECTIONMODEL_POINTSINTERPOLATED = "correctionmodelPointsInterpolated";
    public static final String PROP_CORRECTIONMODEL_POINTSFIXED = "correctionmodelPointsFIXED";
    public static String ID_LINEAR = "linear";
    public static String NAME_LINEAR = "linear";
    private String m_ID;
    private String m_Name;
    private ArrayList<Point2D.Double> m_CorrectionPoints;
    private boolean m_FixPoints;
    private Point2D.Double m_SelectedCorrectionPoint;
    private Point2D.Double m_SelectedCorrectionPointPrevious;
    private Point2D.Double m_SelectedCorrectionPointNext;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncObject = new Object();
    private ArrayList<GraphicsTools.Spline> m_Splines;
    private static Stroke s_BasicStroke_2Points = new BasicStroke(2.0f);

    public CorrectionModel() {
        this.initMembers();
        this.resetToLinear();
    }

    private void initMembers() {
        this.m_ID = ID_LINEAR;
        this.m_Name = NAME_LINEAR;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_CorrectionPoints = new ArrayList();
        this.m_Splines = new ArrayList();
        this.m_FixPoints = false;
        this.m_SelectedCorrectionPoint = null;
        this.m_SelectedCorrectionPointPrevious = null;
        this.m_SelectedCorrectionPointNext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setSelectedCorrectionPoint(null);
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_PropertyChangeSupport.clear();
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        Object object = this.m_SyncObject;
        synchronized (object) {
            out.writeUTF(this.m_ID);
            out.writeUTF(this.m_Name);
            out.writeInt(this.m_CorrectionPoints.size());
            for (int intPoint = 0; intPoint < this.m_CorrectionPoints.size(); ++intPoint) {
                Point2D.Double o_CorrectionPoint = this.m_CorrectionPoints.get(intPoint);
                out.writeDouble(o_CorrectionPoint.getX());
                out.writeDouble(o_CorrectionPoint.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        ArrayList<Point2D.Double> o_CorrectionPoints = new ArrayList<Point2D.Double>();
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_ID = in.readUTF();
            this.m_Name = in.readUTF();
            this.clear();
            int intCotrectionPointCount = in.readInt();
            for (int intPoint = 0; intPoint < intCotrectionPointCount; ++intPoint) {
                Point2D.Double o_CorrectionPoint = new Point2D.Double();
                double doubleX = in.readDouble();
                double doubleY = in.readDouble();
                o_CorrectionPoint.setLocation(doubleX, doubleY);
                o_CorrectionPoints.add(o_CorrectionPoint);
            }
            this.addCorrectionPoints(o_CorrectionPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        Object object = this.m_SyncObject;
        synchronized (object) {
            longBytesCount += (long)(this.m_ID.length() * 2);
            longBytesCount += (long)(this.m_Name.length() * 2);
            longBytesCount += 4L;
            for (int intPoint = 0; intPoint < this.m_CorrectionPoints.size(); ++intPoint) {
                longBytesCount += 8L;
                longBytesCount += 8L;
            }
        }
        return longBytesCount;
    }

    public static boolean save(CorrectionModel p_CorrectionModel, File p_File) {
        if (p_CorrectionModel == null) {
            return false;
        }
        if (p_File == null) {
            return false;
        }
        FileOutputStream o_FileOutputStream = null;
        ObjectOutput o_ObjectOutput = null;
        boolean boolSuccess = false;
        try {
            o_FileOutputStream = new FileOutputStream(p_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            p_CorrectionModel.writeExternal(o_ObjectOutput);
            boolSuccess = true;
        }
        catch (Exception e) {
            boolSuccess = false;
        }
        try {
            if (o_ObjectOutput != null) {
                o_ObjectOutput.close();
            }
            if (o_FileOutputStream != null) {
                o_FileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return boolSuccess;
    }

    public static CorrectionModel load(File p_File) {
        CorrectionModel o_CorrectionModel;
        if (p_File == null) {
            return null;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        try {
            o_FileInputStream = new FileInputStream(p_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            o_CorrectionModel = new CorrectionModel();
            o_CorrectionModel.readExternal(o_ObjectInput);
        }
        catch (Exception e) {
            o_CorrectionModel = null;
        }
        try {
            if (o_ObjectInput != null) {
                o_ObjectInput.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_CorrectionModel;
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void setID(String p_ID) {
        this.m_ID = p_ID;
    }

    public String getID() {
        return this.m_ID;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        this.m_Name = p_Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.setSelectedCorrectionPoint(null);
            this.m_CorrectionPoints.clear();
            for (int intSpline = this.m_Splines.size() - 1; intSpline >= 0; --intSpline) {
                GraphicsTools.Spline o_Spline = this.m_Splines.get(intSpline);
                o_Spline.close();
                this.m_Splines.remove(intSpline);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToLinear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.clear();
            Point2D.Double o_CorrectionPoint = new Point2D.Double(0.0, 0.0);
            this.addCorrectionPoint(o_CorrectionPoint, false);
            o_CorrectionPoint = new Point2D.Double(1.0, 1.0);
            this.addCorrectionPoint(o_CorrectionPoint, false);
            this.interpolatePoints();
        }
    }

    public void copyTo(CorrectionModel p_CorrectionModel) {
        if (p_CorrectionModel == null) {
            return;
        }
        p_CorrectionModel.clear();
        p_CorrectionModel.addCorrectionPoints(this.m_CorrectionPoints);
    }

    public boolean equals(Object p_CorrectionModel) {
        if (p_CorrectionModel == null) {
            return false;
        }
        if (!(p_CorrectionModel instanceof CorrectionModel)) {
            return false;
        }
        CorrectionModel o_CorrectionModel = (CorrectionModel)p_CorrectionModel;
        if (this.getCorrectionPointCount() != o_CorrectionModel.getCorrectionPointCount()) {
            return false;
        }
        for (int intPoint = 0; intPoint < this.getCorrectionPointCount(); ++intPoint) {
            Point2D.Double o_CorrectionPointSelf = this.getCorrectionPoint(intPoint);
            Point2D.Double o_CorrectionPointForeign = o_CorrectionModel.getCorrectionPoint(intPoint);
            if (o_CorrectionPointSelf.getX() != o_CorrectionPointForeign.getX()) {
                return false;
            }
            if (o_CorrectionPointSelf.getY() == o_CorrectionPointForeign.getY()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpolatePoints() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intSpline = 0; intSpline < this.m_Splines.size(); ++intSpline) {
                GraphicsTools.Spline o_Spline = this.m_Splines.get(intSpline);
                if (!o_Spline.getDirty()) continue;
                o_Spline.calculateSpline();
            }
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_CORRECTIONMODEL_POINTSINTERPOLATED, null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNormedValue(double p_InputValue) {
        GraphicsTools.Spline o_Spline = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            double doubleInputValue = p_InputValue;
            if (doubleInputValue < 0.0) {
                doubleInputValue = 0.0;
            }
            if (doubleInputValue > 1.0) {
                doubleInputValue = 1.0;
            }
            for (int intSpline = 0; intSpline < this.m_Splines.size(); ++intSpline) {
                o_Spline = this.m_Splines.get(intSpline);
                if (o_Spline.getXMin() <= doubleInputValue && o_Spline.getXMax() >= doubleInputValue) {
                    GraphicsTools.Spline o_SplineNext;
                    if (o_Spline.getXMax() != doubleInputValue || intSpline >= this.m_Splines.size() - 1 || !((o_SplineNext = this.m_Splines.get(intSpline + 1)).getXMin() <= doubleInputValue)) break;
                    o_Spline = o_SplineNext;
                    break;
                }
                o_Spline = null;
            }
            if (o_Spline == null) {
                return 0.0;
            }
            return o_Spline.getValue(doubleInputValue);
        }
    }

    public Point2D.Double createCorrectionPoinNormed(double p_InputValue) {
        if (p_InputValue < 0.0) {
            return null;
        }
        if (p_InputValue > 1.0) {
            return null;
        }
        double doubleInputValueNormed = p_InputValue;
        double doubleOutputValueNormed = this.getNormedValue(doubleInputValueNormed);
        Point2D.Double o_NewCorrectionPoint = new Point2D.Double(p_InputValue, doubleOutputValueNormed);
        this.addCorrectionPoint(o_NewCorrectionPoint);
        return o_NewCorrectionPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCorrectionPoints(ArrayList<Point2D.Double> p_CorrectionPoints) {
        if (p_CorrectionPoints == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPoint = 0; intPoint < p_CorrectionPoints.size(); ++intPoint) {
                Point2D.Double o_CorrectionPoint = p_CorrectionPoints.get(intPoint);
                o_CorrectionPoint = new Point2D.Double(o_CorrectionPoint.getX(), o_CorrectionPoint.getY());
                this.addCorrectionPoint(o_CorrectionPoint, false);
            }
        }
        this.interpolatePoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAddPoint(Point2D.Double p_CorrectionPoint) {
        if (p_CorrectionPoint.getX() < 0.0) {
            p_CorrectionPoint.setLocation(0.0, p_CorrectionPoint.getY());
        }
        if (p_CorrectionPoint.getX() > 1.0) {
            p_CorrectionPoint.setLocation(1.0, p_CorrectionPoint.getY());
        }
        if (p_CorrectionPoint.getY() < 0.0) {
            p_CorrectionPoint.setLocation(p_CorrectionPoint.getX(), 0.0);
        }
        if (p_CorrectionPoint.getY() > 1.0) {
            p_CorrectionPoint.setLocation(p_CorrectionPoint.getX(), 1.0);
        }
        boolean boolAdd = false;
        int intPointAddIndex = 0;
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPoint = 0; intPoint < this.m_CorrectionPoints.size(); ++intPoint) {
                Point2D.Double o_CorrectionPoint = this.m_CorrectionPoints.get(intPoint);
                if (p_CorrectionPoint.getX() == o_CorrectionPoint.getX()) {
                    Point2D.Double o_CorrectionPoint_Previous;
                    Point2D.Double o_CorrectionPoint_Next;
                    if (p_CorrectionPoint.getY() == o_CorrectionPoint.getY()) {
                        intPointAddIndex = -1;
                        boolAdd = false;
                        break;
                    }
                    if (intPoint + 1 < this.m_CorrectionPoints.size() && (o_CorrectionPoint_Next = this.m_CorrectionPoints.get(intPoint + 1)).getX() == p_CorrectionPoint.getX()) {
                        boolAdd = false;
                        intPointAddIndex = -1;
                        break;
                    }
                    if (intPoint >= 1 && (o_CorrectionPoint_Previous = this.m_CorrectionPoints.get(intPoint - 1)).getX() == p_CorrectionPoint.getX()) {
                        boolAdd = false;
                        intPointAddIndex = -1;
                        break;
                    }
                    intPointAddIndex = p_CorrectionPoint.getY() > o_CorrectionPoint.getY() ? intPoint + 1 : intPoint;
                    boolAdd = true;
                    break;
                }
                if (p_CorrectionPoint.getX() < o_CorrectionPoint.getX()) {
                    boolAdd = true;
                    intPointAddIndex = intPoint;
                    break;
                }
                intPointAddIndex = intPoint + 1;
            }
        }
        return intPointAddIndex;
    }

    public void addCorrectionPoint(Point2D.Double p_CorrectionPoint) {
        this.addCorrectionPoint(p_CorrectionPoint, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCorrectionPoint(Point2D.Double p_CorrectionPoint, boolean p_Interpolate) {
        int intPointAddIndex;
        if (p_CorrectionPoint == null) {
            return;
        }
        Point2D.Double o_CorrectionPointPrevious = null;
        Point2D.Double o_CorrectionPointNext = null;
        Point2D.Double o_CorrectionPointFound = null;
        GraphicsTools.Spline o_SplinePrevious = null;
        int intIndexPrevious = -1;
        GraphicsTools.Spline o_SplineNext = null;
        int intIndexNext = -1;
        GraphicsTools.Spline o_Spline = null;
        int intIndex = -1;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intPointAddIndex = this.checkAddPoint(p_CorrectionPoint);
            if (intPointAddIndex < 0) {
                return;
            }
            this.m_CorrectionPoints.add(intPointAddIndex, p_CorrectionPoint);
            Point2D.Double o_CorrectionPoint = p_CorrectionPoint;
            if (intPointAddIndex > 0) {
                o_CorrectionPointPrevious = this.m_CorrectionPoints.get(intPointAddIndex - 1);
            }
            if (intPointAddIndex < this.m_CorrectionPoints.size() - 1) {
                o_CorrectionPointNext = this.m_CorrectionPoints.get(intPointAddIndex + 1);
            }
            if (o_CorrectionPointPrevious != null) {
                o_SplinePrevious = this.findSpline(o_CorrectionPointPrevious);
            }
            if (o_CorrectionPointNext != null) {
                o_SplineNext = this.findSpline(o_CorrectionPointNext);
            }
            if (o_SplinePrevious != null) {
                intIndexPrevious = this.m_Splines.indexOf(o_SplinePrevious);
                if (o_SplinePrevious.getXMin() <= o_CorrectionPoint.getX() && o_SplinePrevious.getXMax() >= o_CorrectionPoint.getX()) {
                    o_CorrectionPointFound = o_SplinePrevious.getPoint(o_CorrectionPoint.getX());
                    if (o_CorrectionPointFound != null) {
                        if (o_CorrectionPointFound.getY() > o_CorrectionPoint.getY()) {
                            o_Spline = o_SplinePrevious.split(o_CorrectionPointFound);
                            o_SplinePrevious.addPoint(o_CorrectionPoint);
                            intIndex = intIndexPrevious + 1;
                            this.m_Splines.add(intIndex, o_Spline);
                        } else {
                            o_Spline = new GraphicsTools.Spline();
                            o_Spline.addPoint(o_CorrectionPoint);
                            intIndex = intIndexPrevious + 1;
                            this.m_Splines.add(intIndex, o_Spline);
                        }
                    } else {
                        o_SplinePrevious.addPoint(o_CorrectionPoint);
                        o_Spline = o_SplinePrevious;
                    }
                } else if (o_SplineNext == null) {
                    o_SplinePrevious.addPoint(o_CorrectionPoint);
                    o_Spline = o_SplinePrevious;
                } else if (o_SplineNext.getXMin() > o_CorrectionPoint.getX()) {
                    o_SplinePrevious.addPoint(o_CorrectionPoint);
                    o_Spline = o_SplinePrevious;
                } else {
                    o_Spline = null;
                }
            }
            if (o_SplineNext != null && o_Spline == null) {
                intIndexNext = this.m_Splines.indexOf(o_SplineNext);
                if (o_SplineNext.getXMin() <= o_CorrectionPoint.getX() && o_SplineNext.getXMax() >= o_CorrectionPoint.getX()) {
                    o_CorrectionPointFound = o_SplineNext.getPoint(o_CorrectionPoint.getX());
                    if (o_CorrectionPointFound != null) {
                        if (o_CorrectionPointFound.getY() > o_CorrectionPoint.getY()) {
                            o_Spline = o_SplineNext.split(o_CorrectionPointFound);
                            o_SplineNext.addPoint(o_CorrectionPoint);
                            intIndex = intIndexNext + 1;
                            this.m_Splines.add(intIndex, o_Spline);
                        } else {
                            o_Spline = new GraphicsTools.Spline();
                            o_Spline.addPoint(o_CorrectionPoint);
                            intIndex = intIndexNext + 1;
                            this.m_Splines.add(intIndex, o_Spline);
                        }
                    } else {
                        o_SplineNext.addPoint(o_CorrectionPoint);
                        o_Spline = o_SplineNext;
                    }
                } else {
                    o_SplineNext = null;
                }
            }
            if (o_Spline == null) {
                o_Spline = new GraphicsTools.Spline();
                o_Spline.addPoint(o_CorrectionPoint);
                intIndex = intIndexPrevious > 0 ? intIndexPrevious + 1 : 0;
                this.m_Splines.add(intIndex, o_Spline);
            }
        }
        if (p_Interpolate) {
            this.interpolatePoints();
        }
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CORRECTIONMODEL_POINTADDED, intPointAddIndex, null, (Object)p_CorrectionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCorrectionPoint(Point2D.Double p_CorrectionPoint) {
        int intIndex;
        if (p_CorrectionPoint == null) {
            return;
        }
        Point2D.Double o_CorrectionPoint = null;
        Point2D.Double o_CorrectionPointPrevious = null;
        Point2D.Double o_CorrectionPointNext = null;
        GraphicsTools.Spline o_SplinePrevious = null;
        GraphicsTools.Spline o_SplineNext = null;
        boolean boolMergePrevious = false;
        boolean boolMergeNext = false;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intIndex = this.m_CorrectionPoints.indexOf(p_CorrectionPoint);
            if (intIndex < 0) {
                for (int intPoint = 0; intPoint < this.m_CorrectionPoints.size(); ++intPoint) {
                    o_CorrectionPoint = this.m_CorrectionPoints.get(intPoint);
                    if (p_CorrectionPoint.getX() != o_CorrectionPoint.getX() || p_CorrectionPoint.getY() != o_CorrectionPoint.getY()) continue;
                    intIndex = intPoint;
                    break;
                }
            } else {
                o_CorrectionPoint = p_CorrectionPoint;
            }
            if (intIndex == 0) {
                return;
            }
            if (intIndex == this.m_CorrectionPoints.size() - 1) {
                return;
            }
            if (intIndex >= 0) {
                if (this.m_SelectedCorrectionPoint == o_CorrectionPoint) {
                    this.setSelectedCorrectionPoint(null);
                }
                GraphicsTools.Spline o_Spline = this.findSpline(o_CorrectionPoint);
                if (intIndex >= 1) {
                    o_CorrectionPointPrevious = this.m_CorrectionPoints.get(intIndex - 1);
                    o_SplinePrevious = this.findSpline(o_CorrectionPointPrevious);
                    if (o_SplinePrevious != null && o_SplinePrevious != o_Spline) {
                        boolMergePrevious = true;
                    } else {
                        boolMergePrevious = false;
                        o_SplinePrevious = null;
                    }
                }
                if (intIndex < this.m_CorrectionPoints.size() - 1) {
                    o_CorrectionPointNext = this.m_CorrectionPoints.get(intIndex + 1);
                    o_SplineNext = this.findSpline(o_CorrectionPointNext);
                    if (o_SplineNext != null && o_SplineNext != o_Spline) {
                        boolMergeNext = true;
                    } else {
                        boolMergeNext = false;
                        o_SplineNext = null;
                    }
                }
                if (o_Spline != null) {
                    o_Spline.removePoint(o_CorrectionPoint);
                    if (boolMergePrevious) {
                        o_SplinePrevious.merge(o_Spline);
                        this.m_Splines.remove(o_Spline);
                        o_Spline.close();
                        o_Spline = null;
                    }
                    if (boolMergeNext) {
                        o_Spline.merge(o_SplineNext);
                        this.m_Splines.remove(o_SplineNext);
                        o_SplineNext.close();
                        o_SplineNext = null;
                    }
                }
                this.m_CorrectionPoints.remove(o_CorrectionPoint);
            }
        }
        this.interpolatePoints();
        if (o_CorrectionPoint != null) {
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CORRECTIONMODEL_POINTREMOVED, intIndex, (Object)o_CorrectionPoint, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCorrectionPoint(Point2D.Double p_CorrectionPoint, double p_NewX, double p_NewY) {
        Point2D.Double o_CorrectionPoint;
        int intIndex;
        if (p_CorrectionPoint == null) {
            return;
        }
        boolean boolSplitSplinePrevious = false;
        boolean boolSplitSplineNext = false;
        boolean boolMergeSplinePrevious = false;
        boolean boolMergeSplineNext = false;
        GraphicsTools.Spline o_SplineNext = null;
        GraphicsTools.Spline o_SplinePrevious = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            GraphicsTools.Spline o_SplineNew;
            intIndex = this.m_CorrectionPoints.indexOf(p_CorrectionPoint);
            if (intIndex < 0) {
                return;
            }
            if (this.m_SelectedCorrectionPoint != p_CorrectionPoint) {
                return;
            }
            int intSplineIndex = this.findSplineIndex(p_CorrectionPoint);
            if (intSplineIndex < 0) {
                return;
            }
            GraphicsTools.Spline o_Spline = this.m_Splines.get(intSplineIndex);
            if (o_Spline == null) {
                return;
            }
            o_CorrectionPoint = this.m_SelectedCorrectionPoint;
            if (p_NewX < 0.0) {
                p_NewX = 0.0;
            }
            if (p_NewX > 1.0) {
                p_NewX = 1.0;
            }
            if (p_NewY < 0.0) {
                p_NewY = 0.0;
            }
            if (p_NewY > 1.0) {
                p_NewY = 1.0;
            }
            if (this.m_FixPoints) {
                p_NewX = o_CorrectionPoint.getX();
            }
            if (intIndex == 0) {
                p_NewX = 0.0;
            }
            if (intIndex == this.m_CorrectionPoints.size() - 1) {
                p_NewX = 1.0;
            }
            if (this.m_SelectedCorrectionPointPrevious != null) {
                if (p_NewX <= this.m_SelectedCorrectionPointPrevious.getX()) {
                    p_NewX = this.m_SelectedCorrectionPointPrevious.getX();
                }
                if (p_NewY < this.m_SelectedCorrectionPointPrevious.getY()) {
                    p_NewY = this.m_SelectedCorrectionPointPrevious.getY();
                }
            }
            if (this.m_SelectedCorrectionPointNext != null) {
                if (p_NewX >= this.m_SelectedCorrectionPointNext.getX()) {
                    p_NewX = this.m_SelectedCorrectionPointNext.getX();
                }
                if (p_NewY > this.m_SelectedCorrectionPointNext.getY()) {
                    p_NewY = this.m_SelectedCorrectionPointNext.getY();
                }
            }
            if (this.m_SelectedCorrectionPointPrevious != null) {
                o_SplinePrevious = this.findSpline(this.m_SelectedCorrectionPointPrevious);
                if (p_NewX == this.m_SelectedCorrectionPointPrevious.getX()) {
                    p_NewX = this.m_SelectedCorrectionPointPrevious.getX();
                    if (o_Spline == o_SplinePrevious) {
                        boolSplitSplinePrevious = true;
                    }
                } else if (o_Spline != o_SplinePrevious) {
                    boolMergeSplinePrevious = true;
                }
            }
            if (this.m_SelectedCorrectionPointNext != null) {
                o_SplineNext = this.findSpline(this.m_SelectedCorrectionPointNext);
                if (p_NewX == this.m_SelectedCorrectionPointNext.getX()) {
                    p_NewX = this.m_SelectedCorrectionPointNext.getX();
                    if (o_Spline == o_SplineNext) {
                        boolSplitSplineNext = true;
                    }
                } else if (o_Spline != o_SplineNext) {
                    boolMergeSplineNext = true;
                }
            }
            o_Spline.movePoint(o_CorrectionPoint, p_NewX, p_NewY);
            if (boolSplitSplinePrevious && (o_SplineNew = o_Spline.split(o_CorrectionPoint)) != null) {
                this.m_Splines.add(intSplineIndex + 1, o_SplineNew);
            }
            if (boolSplitSplineNext && (o_SplineNew = o_Spline.split(this.m_SelectedCorrectionPointNext)) != null) {
                this.m_Splines.add(intSplineIndex + 1, o_SplineNew);
            }
            if (boolMergeSplinePrevious && o_SplinePrevious != null) {
                o_SplinePrevious.merge(o_Spline);
                this.m_Splines.remove(o_Spline);
                o_Spline.close();
                o_Spline = o_SplinePrevious;
                o_SplinePrevious = null;
            }
            if (boolMergeSplineNext && o_SplineNext != null) {
                o_Spline.merge(o_SplineNext);
                this.m_Splines.remove(o_SplineNext);
                o_SplineNext.close();
                o_SplineNext = null;
            }
        }
        this.interpolatePoints();
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CORRECTIONMODEL_POINTMOVED, intIndex, null, (Object)o_CorrectionPoint);
    }

    public int getCorrectionPointCount() {
        return this.m_CorrectionPoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D.Double getCorrectionPoint(int p_Index) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_CorrectionPoints.size()) {
                return null;
            }
            return this.m_CorrectionPoints.get(p_Index);
        }
    }

    public int getIndexOf(Point2D.Double p_CorrectionPoint) {
        return this.m_CorrectionPoints.indexOf(p_CorrectionPoint);
    }

    public void setFixPoints(boolean p_FixPoints) {
        boolean oldValue = this.m_FixPoints;
        this.m_FixPoints = p_FixPoints;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_CORRECTIONMODEL_POINTSFIXED, oldValue, this.m_FixPoints);
    }

    public boolean getFixPoints() {
        return this.m_FixPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedCorrectionPoint(int p_Index) {
        Point2D.Double o_CorrectionPoint;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_CorrectionPoints.size()) {
                return;
            }
            o_CorrectionPoint = this.m_CorrectionPoints.get(p_Index);
        }
        this.setSelectedCorrectionPoint(o_CorrectionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedCorrectionPoint(Point2D.Double p_CorrectionPoint) {
        Point2D.Double newValue = null;
        Point2D.Double oldValue = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            oldValue = this.m_SelectedCorrectionPoint;
            if (p_CorrectionPoint == null) {
                this.m_SelectedCorrectionPoint = null;
                this.m_SelectedCorrectionPointPrevious = null;
                this.m_SelectedCorrectionPointNext = null;
            } else {
                int intIndex = this.m_CorrectionPoints.indexOf(p_CorrectionPoint);
                if (intIndex >= 0) {
                    newValue = p_CorrectionPoint;
                } else {
                    for (int intPoint = 0; intPoint < this.m_CorrectionPoints.size(); ++intPoint) {
                        newValue = this.m_CorrectionPoints.get(intPoint);
                        if (newValue.getX() != p_CorrectionPoint.getX() || newValue.getY() != p_CorrectionPoint.getY()) continue;
                        intIndex = intPoint;
                        break;
                    }
                }
                if (newValue != null) {
                    this.m_SelectedCorrectionPoint = newValue;
                    this.m_SelectedCorrectionPointPrevious = intIndex >= 1 ? this.m_CorrectionPoints.get(intIndex - 1) : null;
                    this.m_SelectedCorrectionPointNext = intIndex < this.m_CorrectionPoints.size() - 1 ? this.m_CorrectionPoints.get(intIndex + 1) : null;
                }
            }
        }
        if (oldValue != this.m_SelectedCorrectionPoint) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CORRECTIONMODEL_POINTSELECTED, (Object)oldValue, (Object)this.m_SelectedCorrectionPoint);
        }
    }

    public Point2D.Double getSelectedCorrectionPoint() {
        return this.m_SelectedCorrectionPoint;
    }

    public int findSplineIndex(Point2D.Double p_CorrectionPoint) {
        if (p_CorrectionPoint == null) {
            return -1;
        }
        for (int intSpline = 0; intSpline < this.m_Splines.size(); ++intSpline) {
            GraphicsTools.Spline o_Spline = this.m_Splines.get(intSpline);
            if (!o_Spline.contains(p_CorrectionPoint)) continue;
            return intSpline;
        }
        return -1;
    }

    public GraphicsTools.Spline findSpline(Point2D.Double p_CorrectionPoint) {
        if (p_CorrectionPoint == null) {
            return null;
        }
        int intSplineIndex = this.findSplineIndex(p_CorrectionPoint);
        if (intSplineIndex < 0) {
            return null;
        }
        return this.m_Splines.get(intSplineIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics p_Graphics, int p_Width, int p_Height) {
        if (p_Width == 0 || p_Height == 0) {
            return;
        }
        Point o_DrawPoint = new Point(0, 0);
        Point o_DrawPointLast = null;
        Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
        Color o_ColorOld = o_Graphics2D.getColor();
        Stroke o_OldStroke = o_Graphics2D.getStroke();
        o_Graphics2D.setStroke(s_BasicStroke_2Points);
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intSpline = 0; intSpline < this.m_Splines.size(); ++intSpline) {
                GraphicsTools.Spline o_Spline = this.m_Splines.get(intSpline);
                int intXStart = (int)(o_Spline.getXMin() * (double)p_Width + 0.5);
                int intXEnd = (int)(o_Spline.getXMax() * (double)p_Width + 0.5);
                for (int intX = intXStart; intX <= intXEnd; ++intX) {
                    double doubleValueSpline = o_Spline.getValue((double)intX / (double)p_Width);
                    o_DrawPoint.setLocation(intX, p_Height - (int)(doubleValueSpline * (double)p_Height + 0.5));
                    if (o_DrawPointLast != null) {
                        o_Graphics2D.drawLine(o_DrawPointLast.x, o_DrawPointLast.y, o_DrawPoint.x, o_DrawPoint.y);
                    } else {
                        o_DrawPointLast = new Point(0, 0);
                    }
                    o_DrawPointLast.setLocation(o_DrawPoint.x, o_DrawPoint.y);
                    o_Graphics2D.setColor(o_ColorOld);
                }
                o_Graphics2D.setColor(Color.RED);
            }
        }
        o_Graphics2D.setStroke(o_OldStroke);
        p_Graphics.setColor(o_ColorOld);
    }
}

