/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlObjects;

import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlDisplayInterface;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import SwingComponents.MouseAdapter_Delayed;
import SwingComponents.RotationLabelUI;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.BackgroundComponent;
import ToolsGraphics.BackgroundComponentInterface;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.LabelUI;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public abstract class ControlObject
extends JComponent
implements BackgroundComponentInterface,
ComponentListener,
Externalizable,
ValueSelectionInterface {
    static final int SOFTWAREVERSION = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final String PROP_VALUE = "value";
    public static final String PROP_VALUEDDED = "valueAdded";
    public static final String PROP_VALUEFACTOR = "valueFactor";
    public static final String PROP_VALUEADJUSTED = "valueAdjustedManually";
    public static final String PROP_VALUECHANGEDMANUALLY = "valueChangedManually";
    public static final String PROP_JARRESOURCES = "jarResources";
    public static final String PROP_VALUEMULTIPLIER = "valueMultiplier";
    public static final String PROP_VALUEOFFSET = "valueOffset";
    public static final String PROP_SNAPDISTANCE = "snapDistance";
    public static final String PROP_VALUEMAXIMUM = "valueMaximum";
    public static final String PROP_VALUEMINIMUM = "valueMinimum";
    public static final String PROP_VALUEMOUSEWHEEL = "valueMouseWheel";
    public static final String PROP_VALUEMOUSEMOVEFACTOR = "valueMouseMoveFactor";
    public static final String PROP_ADJUSTER_ACTIVEDIMENSION = "adjusterActiveDimension";
    public static final String PROP_CONTROLDIMENSIONNAME = "controlDimensionName";
    public static final String PROP_CONTROLMASTER = "controlMaster";
    public static final String PROP_ORIENTATION = "orientation";
    public static final String PROP_INVERTED = "inverted";
    public static final String PROP_TICKSVISIBLE = "ticksVisible";
    public static final String PROP_TICKSINSETS = "ticksInsets";
    public static final String PROP_TICKSMAJOR = "ticksMajor";
    public static final String PROP_TICKSMINOR = "ticksMinor";
    public static final String PROP_TICKSMAJORPASSCOUNT = "ticksMajorPassCount";
    public static final String PROP_TICKSALIGNMENT = "ticksAlignment";
    public static final String PROP_TICKSMAJORLENGTH = "ticksMajorLength";
    public static final String PROP_TICKSMINORLENGTH = "ticksMajorLength";
    public static final String PROP_TICKSMIRRORED = "ticksMirrored";
    public static final String PROP_CONTROLGROUP = "controlGroup";
    public static final String PROP_LABELSVISIBLE = "labelsVisible";
    public static final String PROP_LABELSMODEL = "labelsModel";
    public static final String PROP_LABELSINSETS = "labelsInsets";
    public static final String PROP_LABELSALIGNMENT = "labelsAlignment";
    public static final String PROP_LABELSMIRRORED = "labelsMirrored";
    public static final String PROP_LABELSSIZE = "labelsSize";
    public static final String PROP_LABELSSIZEFIXED = "labelsSizeFixed";
    public static final String PROP_LABELSFONT = "labelsFont";
    public static final String PROP_LABELSROTATION = "blocksRotation";
    public static final String PROP_LABELSBORDER = "labelsBorder";
    public static final String PROP_LABELSAUTOMATIC = "labelsAutomatic";
    public static final String PROP_BLOCKSVISIBLE = "blocksVisible";
    public static final String PROP_BLOCKSMODEL = "blocksModel";
    public static final String PROP_BLOCKSINSETS = "blocksInsets";
    public static final String PROP_BLOCKSALIGNMENT = "blocksAlignment";
    public static final String PROP_BLOCKSMIRRORED = "blocksMirrored";
    public static final String PROP_BLOCKSSIZE = "blocksSize";
    public static final String PROP_BLOCKSFONT = "blocksFont";
    public static final String PROP_BLOCKSROTATION = "blocksRotation";
    public static final String PROP_BLOCKSBORDER = "blocksBorder";
    public static final int ACTIONFLAG_NOTHING = 0;
    public static final int ACTIONFLAG_MOUSECLICKED = 2;
    public static final int ACTIONFLAG_MOUSEDRAGGED = 4;
    public static final int ACTIONFLAG_MOUSEWHEEL = 8;
    public static final int ACTIONFLAG_CONTROLGROUP = 16;
    public static final int ACTIONFLAG_VIRTUAL = 32;
    public static final int PASSCOUNT_TRIGGER = 7;
    private static ValueSelection s_ValueSelection;
    protected boolean m_IsInvertedSecondary;
    protected boolean m_IsMaster;
    protected Color m_Foreground;
    protected BackgroundComponent m_BackgroundComponent;
    protected ArrayList<ControlDimension> m_ControlDimensions;
    protected ArrayList<Double> m_Values;
    protected ControlDimension m_ActiveDimension;
    protected TableAndListModel.ListModel<ControlDimension> m_ControlDimensionListModel;
    protected ControlDimensionCellRenderer m_ControlDimensionCellRenderer;
    protected int m_ActionsBlocking;
    protected ArrayList<ControlGroup> m_ArrayListControlGroups;
    private final Object m_SyncControlGroups = new Object();
    protected JarResources m_Resources;
    protected AbsoluteLayout m_LayoutManager;
    protected ControlObject m_ControlObjectSelfReference;
    private Rectangle m_RectInside;
    private Runnable m_RunnableSetValueManuallyIsReady;
    private boolean m_MousePressed;
    private Runnable m_RunnableMousePressedRelease;
    private Runnable m_RunnableRepaint;
    private Runnable m_RunnableRevalidateRepaint;
    private Dimension m_OldSize;

    public ControlObject() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_OldSize = new Dimension(0, 0);
        this.m_Foreground = Color.BLACK;
        this.m_Resources = null;
        this.m_ArrayListControlGroups = new ArrayList();
        this.m_BackgroundComponent = new BackgroundComponent();
        this.setBackgroundStyle(0);
        this.setBackgroundOpaque(false);
        this.setBackground(Color.LIGHT_GRAY);
        this.m_ActionsBlocking = 28;
        this.readResolve();
        this.m_ControlDimensions = new ArrayList();
        this.m_Values = new ArrayList();
        this.m_IsInvertedSecondary = false;
        this.m_IsMaster = false;
        this.m_MousePressed = false;
        this.addComponentListener(this);
        this.m_RunnableSetValueManuallyIsReady = new Runnable(){

            @Override
            public void run() {
                try {
                    ControlObject.this.firePropertyChange(ControlObject.PROP_VALUECHANGEDMANUALLY, false, true);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_RunnableMousePressedRelease = new Runnable(){

            @Override
            public void run() {
                ControlObject.this.m_MousePressed = false;
            }
        };
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                ControlObject.this.repaint();
            }
        };
        this.m_RunnableRevalidateRepaint = new Runnable(){

            @Override
            public void run() {
                ControlObject.this.revalidate();
                ControlObject.this.repaint();
            }
        };
    }

    private Object readResolve() {
        this.m_ControlObjectSelfReference = this;
        this.m_ActiveDimension = this.m_ControlDimensions != null && this.m_ControlDimensions.size() > 0 ? this.m_ControlDimensions.get(0) : null;
        this.m_ControlDimensionListModel = new TableAndListModel.ListModel(false);
        this.m_ControlDimensionCellRenderer = new ControlDimensionCellRenderer();
        this.initComponents();
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(1);
        p_ObjectOutput.writeUTF(this.getName());
        p_ObjectOutput.writeUTF(this.getToolTipText());
        ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.getForeground());
        p_ObjectOutput.writeInt(this.m_ActionsBlocking);
        p_ObjectOutput.writeObject(this.m_BackgroundComponent);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = p_ObjectInput.readInt();
        this.setName(p_ObjectInput.readUTF());
        String stringToolTip = p_ObjectInput.readUTF();
        this.setToolTipText(stringToolTip);
        this.setForeground(ImagesTools.readColor((ObjectInput)p_ObjectInput));
        this.m_ActionsBlocking = p_ObjectInput.readInt();
        this.m_BackgroundComponent = (BackgroundComponent)p_ObjectInput.readObject();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater((Runnable)this.m_RunnableRevalidateRepaint);
        } else {
            this.repaint();
        }
    }

    private void initComponents() {
        this.m_LayoutManager = new AbsoluteLayout();
        this.setLayout(this.m_LayoutManager);
        Dimension o_Dimension = new Dimension(50, 170);
        this.setSize(o_Dimension);
        this.setPreferredSize(o_Dimension);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (ControlObject.this.m_ActiveDimension == null) {
                    return;
                }
                double doubleValue = ControlObject.this.m_ActiveDimension.getValue();
                double doubleJump = ControlObject.this.m_ActiveDimension.getMouseWheelStep();
                if (ControlObject.this.m_ActiveDimension.getSnapDistance() > doubleJump) {
                    doubleJump = ControlObject.this.m_ActiveDimension.getSnapDistance();
                }
                if (ControlObject.this.m_ActiveDimension.getValueMaximum() - ControlObject.this.m_ActiveDimension.getValueMinimum() < doubleJump) {
                    doubleJump = (ControlObject.this.m_ActiveDimension.getValueMaximum() - ControlObject.this.m_ActiveDimension.getValueMinimum()) / 3.0;
                }
                doubleValue = !ControlObject.this.m_ActiveDimension.getInverted() ? (doubleValue -= (double)e.getWheelRotation() * doubleJump) : (doubleValue += (double)e.getWheelRotation() * doubleJump);
                double doubleValueDiff = doubleValue - ControlObject.this.m_ActiveDimension.getValue();
                ControlObject.this.setMousePressed(true);
                ControlObject.this.m_ActiveDimension.setValue(doubleValue, doubleValueDiff, 8);
                ControlObject.this.setValueManuallyIsReady();
                ControlObject.this.setMousePressed(false);
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ControlObject.this.m_ControlDimensions == null || ControlObject.this.m_ControlDimensions.size() <= 0) {
                    ControlObject.this.setActiveDimension(null);
                    return;
                }
                int intDimension = ControlObject.this.m_ControlDimensions.indexOf(ControlObject.this.m_ActiveDimension);
                ControlObject.this.setActiveDimension(++intDimension);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                for (int intGroup = 0; intGroup < ControlObject.this.m_ArrayListControlGroups.size(); ++intGroup) {
                    ControlGroup o_ControlGroup = ControlObject.this.m_ArrayListControlGroups.get(intGroup);
                    if (o_ControlGroup == null) continue;
                    o_ControlGroup.refreshOverhead();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ControlObject.this.m_ActiveDimension == null) {
                    if (ControlObject.this.m_ControlDimensions != null && ControlObject.this.m_ControlDimensions.size() > 0) {
                        ControlObject.this.m_ActiveDimension = ControlObject.this.m_ControlDimensions.get(0);
                    }
                    ControlObject.this.firePropertyChange(ControlObject.PROP_ADJUSTER_ACTIVEDIMENSION, null, ControlObject.this.m_ActiveDimension);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void setMousePressed(boolean p_MousePressed) {
        if (!p_MousePressed) {
            EventQueueHandler.invokeLater((Runnable)this.m_RunnableMousePressedRelease);
            return;
        }
        this.m_MousePressed = p_MousePressed;
    }

    public boolean getMousePressed() {
        return this.m_MousePressed;
    }

    public void setActiveDimension(int p_DimensionIndex) {
        ControlDimension o_ControlDimension;
        if (this.m_ControlDimensions == null || this.m_ControlDimensions.size() <= 0) {
            o_ControlDimension = null;
        } else {
            if (p_DimensionIndex < 0 || p_DimensionIndex >= this.m_ControlDimensions.size()) {
                p_DimensionIndex = 0;
            }
            o_ControlDimension = this.m_ControlDimensions.get(p_DimensionIndex);
        }
        this.setActiveDimension(o_ControlDimension);
    }

    public void setActiveDimension(ControlDimension p_ActiveDimension) {
        ControlDimension oldValue = this.m_ActiveDimension;
        if (p_ActiveDimension == null) {
            this.m_ActiveDimension = null;
        } else if (this.m_ControlDimensions == null || this.m_ControlDimensions.size() <= 0) {
            this.m_ActiveDimension = null;
        } else {
            int intDimension = this.m_ControlDimensions.indexOf(p_ActiveDimension);
            if (intDimension < 0) {
                intDimension = 0;
            }
            this.m_ActiveDimension = this.m_ControlDimensions.get(intDimension);
        }
        this.firePropertyChange(PROP_ADJUSTER_ACTIVEDIMENSION, oldValue, this.m_ActiveDimension);
    }

    public ControlDimension getActiveDimension() {
        return this.m_ActiveDimension;
    }

    @Override
    public void setName(String p_Name) {
        super.setName(p_Name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        super.addPropertyChangeListener(p_PropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        super.removePropertyChangeListener(p_PropertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        super.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        super.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void fireMouseListenerEvent(JComponent p_JComponent, MouseEvent p_MouseEvent) {
        MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent((Component)p_MouseEvent.getComponent(), (int)p_MouseEvent.getID(), (long)p_MouseEvent.getWhen(), (int)p_MouseEvent.getModifiers(), (int)p_MouseEvent.getX(), (int)p_MouseEvent.getY(), (int)p_MouseEvent.getXOnScreen(), (int)p_MouseEvent.getYOnScreen(), (int)p_MouseEvent.getClickCount(), (boolean)p_MouseEvent.isPopupTrigger(), (int)p_MouseEvent.getButton());
        int intMouseEvent = p_MouseEvent.getID();
        block14: for (int intListener = 0; intListener < this.getMouseListeners().length; ++intListener) {
            MouseListener o_MouseListener = this.getMouseListeners()[intListener];
            if (o_MouseListener == null) continue;
            if (o_MouseListener instanceof MouseAdapter_Delayed) {
                MouseAdapter_Delayed o_MouseAdapter_Delayed = (MouseAdapter_Delayed)o_MouseListener;
                switch (intMouseEvent) {
                    case 504: {
                        o_MouseAdapter_Delayed.mouseEntered_Delayed(o_MouseEvent);
                        break;
                    }
                    case 505: {
                        o_MouseAdapter_Delayed.mouseExited_Delayed(o_MouseEvent);
                        break;
                    }
                    case 501: {
                        o_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                        break;
                    }
                    case 502: {
                        o_MouseAdapter_Delayed.mouseReleased_Delayed(o_MouseEvent);
                        break;
                    }
                    case 500: {
                        o_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                    }
                }
                continue;
            }
            switch (intMouseEvent) {
                case 504: {
                    o_MouseListener.mouseEntered(o_MouseEvent);
                    continue block14;
                }
                case 505: {
                    o_MouseListener.mouseExited(o_MouseEvent);
                    continue block14;
                }
                case 501: {
                    o_MouseListener.mousePressed(o_MouseEvent);
                    continue block14;
                }
                case 502: {
                    o_MouseListener.mouseReleased(o_MouseEvent);
                    continue block14;
                }
                case 500: {
                    o_MouseListener.mouseClicked(o_MouseEvent);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        this.m_OldSize.setSize(this.getWidth(), this.getHeight());
        this.calculateInnerItems();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setInvertedSecondary(boolean p_IsInvertedSecndary) {
        this.m_IsInvertedSecondary = p_IsInvertedSecndary;
    }

    public boolean getInvertedSecondary() {
        return this.m_IsInvertedSecondary;
    }

    public void setControlMaster(boolean p_ControlMaster) {
        if (this.m_IsMaster == p_ControlMaster) {
            return;
        }
        boolean oldValue = this.m_IsMaster;
        this.m_IsMaster = p_ControlMaster;
        this.firePropertyChange(PROP_CONTROLMASTER, oldValue, this.m_IsMaster);
        this.setJarResources(this.m_Resources);
    }

    public boolean getControlMaster() {
        return this.m_IsMaster;
    }

    public JarResources getJarResources() {
        return this.m_Resources;
    }

    public abstract void setJarResources(JarResources var1);

    public abstract double[] getValuesFromInnerComponentPosition(JComponent var1, int var2, int var3);

    public abstract double[] getValuesFromComponentPosition(int var1, int var2);

    public abstract double calculatePixelPerValueLabel(ControlDimension var1);

    public abstract void calculateAdjuster();

    public abstract void calculateInnerItems();

    public abstract void calculateTicks(ControlTicks var1);

    public abstract void paintTicks(Graphics var1, ControlTicks var2);

    public abstract void calculateLabels(ControlLabels var1);

    public abstract void paintLabels(Graphics var1, ControlLabels var2);

    public abstract void calculateBlocks(ControlBlocks var1);

    public abstract void paintBlocks(Graphics var1, ControlBlocks var2);

    public abstract void calculateDisplayItem(ControlDisplayItem var1);

    @Override
    public void paintComponent(Graphics p_Graphics) {
        if (this.m_BackgroundComponent != null) {
            this.m_BackgroundComponent.paintComponentBackground(p_Graphics, (JComponent)this);
        }
        if (this.m_ArrayListControlGroups.size() > 0) {
            this.m_RectInside = this.getBounds(this.m_RectInside);
            Graphics o_Graphics = p_Graphics.create();
            for (int intGroup = 0; intGroup < this.m_ArrayListControlGroups.size(); ++intGroup) {
                ControlGroup o_ControlGroup = this.m_ArrayListControlGroups.get(intGroup);
                if (o_ControlGroup == null) continue;
                o_ControlGroup.paintGroup(this, o_Graphics, this.m_RectInside, intGroup);
            }
            o_Graphics.dispose();
        }
        super.paintComponent(p_Graphics);
    }

    @Override
    public void setForeground(Color p_Color) {
        if (p_Color == null) {
            return;
        }
        this.m_Foreground = p_Color;
        if (this.m_ControlDimensions == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
            ControlDimension o_ControlDimension = this.m_ControlDimensions.get(intDimension);
            if (o_ControlDimension == null) continue;
            o_ControlDimension.getControlTicks().setForeground(p_Color);
            o_ControlDimension.getControlLabels().setForeground(p_Color);
            o_ControlDimension.getControlBlocks().setForeground(p_Color);
        }
    }

    @Override
    public Color getForeground() {
        return this.m_Foreground;
    }

    public void setBackgroundComponent(BackgroundComponent p_BackgroundComponent) {
        if (p_BackgroundComponent != null) {
            this.m_BackgroundComponent = p_BackgroundComponent;
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public BackgroundComponent getBackgroundComponent() {
        return this.m_BackgroundComponent;
    }

    @Override
    public void setOpaque(boolean p_Opaque) {
        super.setOpaque(false);
    }

    public boolean getOpaque() {
        return super.isOpaque();
    }

    public void setBackgroundOpaque(boolean p_Opaque) {
        if (this.m_BackgroundComponent == null) {
            return;
        }
        if (this.m_BackgroundComponent.setOpaque(p_Opaque)) {
            this.firePropertyChange("backgroundOpaque", this.m_BackgroundComponent.getOpaque(), p_Opaque);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public boolean getBackgroundOpaque() {
        if (this.m_BackgroundComponent == null) {
            return false;
        }
        return this.m_BackgroundComponent.getOpaque();
    }

    public void setBackgroundStyle(int p_BackgroundStyle) {
        if (this.m_BackgroundComponent.setBackgroundStyle(p_BackgroundStyle)) {
            this.firePropertyChange("backgroundStyle", this.m_BackgroundComponent.getBackgroundStyle(), p_BackgroundStyle);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public int getBackgroundStyle() {
        return this.m_BackgroundComponent.getBackgroundStyle();
    }

    @Override
    public void setBackground(Color p_BackgroundColor) {
        boolean boolRepaint = false;
        Color o_BackgroundColorSuper = super.getBackground();
        super.setBackground(p_BackgroundColor);
        if (this.m_BackgroundComponent != null && this.m_BackgroundComponent.setBackground(p_BackgroundColor)) {
            this.firePropertyChange("background", this.getBackground(), p_BackgroundColor);
            boolRepaint = true;
        }
        if (!p_BackgroundColor.equals(o_BackgroundColorSuper)) {
            super.setBackground(p_BackgroundColor);
            boolRepaint = false;
        }
        if (boolRepaint) {
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public void setBackgroundImage(Image p_BackgroundImage) {
        if (p_BackgroundImage == null) {
            this.m_BackgroundComponent.setBackgroundStyle(0);
        } else {
            this.m_BackgroundComponent.setBackgroundStyle(2);
        }
        if (this.m_BackgroundComponent.setBackgroundImage(p_BackgroundImage)) {
            this.firePropertyChange("backgroundImage", this.m_BackgroundComponent.getBackgroundImage(), p_BackgroundImage);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public Image getBackgroundImage() {
        return this.m_BackgroundComponent.getBackgroundImage();
    }

    public void setBackgroundImageFile(String p_BackgroundImageFile) {
        Image o_OldImage = this.m_BackgroundComponent.getBackgroundImage();
        boolean boolDirty = false;
        boolDirty = this.m_BackgroundComponent.setBackgroundImage(p_BackgroundImageFile);
        if (boolDirty) {
            this.firePropertyChange("backgroundImage", o_OldImage, this.m_BackgroundComponent.getBackgroundImage());
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public Color getBackgroundGradientColorFrom() {
        return this.m_BackgroundComponent.getBackgroundGradientColorFrom();
    }

    public void setBackgroundGradientColorFrom(Color p_BackgroundGradientColorFrom) {
        if (this.m_BackgroundComponent.setBackgroundGradientColorFrom(p_BackgroundGradientColorFrom)) {
            this.firePropertyChange("backgroundGradientColorFrom", this.m_BackgroundComponent.getBackgroundGradientColorFrom(), p_BackgroundGradientColorFrom);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public Color getBackgroundGradientColorTo() {
        return this.m_BackgroundComponent.getBackgroundGradientColorTo();
    }

    public void setBackgroundGradientColorTo(Color p_BackgroundGradientColorTo) {
        if (this.m_BackgroundComponent.setBackgroundGradientColorTo(p_BackgroundGradientColorTo)) {
            this.firePropertyChange("backgroundGradientColorTo", this.m_BackgroundComponent.getBackgroundGradientColorTo(), p_BackgroundGradientColorTo);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public int getBackgroundGradientAngle() {
        return this.m_BackgroundComponent.getBackgroundGradientAngle();
    }

    public void setBackgroundGradientAngle(int p_BackgroundGradientAngle) {
        if (this.m_BackgroundComponent.setBackgroundGradientAngle(p_BackgroundGradientAngle)) {
            this.firePropertyChange("backgroundGradientAngle", this.m_BackgroundComponent.getBackgroundGradientAngle(), p_BackgroundGradientAngle);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public void addChangeListener(ChangeListener p_ChangeListener) {
        this.listenerList.add(ChangeListener.class, p_ChangeListener);
    }

    public void removeChangeListener(ChangeListener p_ChangeListener) {
        this.listenerList.remove(ChangeListener.class, p_ChangeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void addDimensionPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener, int p_DimensionIndex) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (p_PropertyName == null) {
            return;
        }
        ControlDimension o_ControlDimension = this.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return;
        }
        o_ControlDimension.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removeDimensionPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener, int p_DimensionIndex) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (p_PropertyName == null) {
            return;
        }
        ControlDimension o_ControlDimension = this.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return;
        }
        o_ControlDimension.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getControlGroupCount() {
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            return this.m_ArrayListControlGroups.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlGroup getControlGroup(int p_Index) {
        ControlGroup o_ControlGroup;
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (p_Index >= this.m_ArrayListControlGroups.size()) {
                return null;
            }
            if (p_Index < 0) {
                return null;
            }
            o_ControlGroup = this.m_ArrayListControlGroups.get(p_Index);
        }
        return o_ControlGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ControlGroup> getControlGroups() {
        ArrayList<ControlGroup> o_ControlGroups;
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            o_ControlGroups = new ArrayList<ControlGroup>(this.m_ArrayListControlGroups);
        }
        return o_ControlGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlGroup(ControlGroup p_ControlGroup) {
        ArrayList<ControlGroup> oldValue;
        if (p_ControlGroup == null) {
            return;
        }
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (this.m_ArrayListControlGroups.contains(p_ControlGroup)) {
                return;
            }
            oldValue = this.m_ArrayListControlGroups;
            this.m_ArrayListControlGroups.add(p_ControlGroup);
            for (int intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                ControlDimension o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                if (o_ControlDimension == null) continue;
                o_ControlDimension.addPropertyChangeListener(p_ControlGroup);
            }
        }
        this.firePropertyChange(PROP_CONTROLGROUP, oldValue, this.m_ArrayListControlGroups);
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater((Runnable)this.m_RunnableRevalidateRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlGroup(ControlGroup p_ControlGroup) {
        ArrayList<ControlGroup> oldValue;
        if (p_ControlGroup == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            oldValue = this.m_ArrayListControlGroups;
            boolRemoved = this.m_ArrayListControlGroups.remove(p_ControlGroup);
            if (boolRemoved) {
                for (int intDimension = this.m_ControlDimensions.size() - 1; intDimension >= 0; --intDimension) {
                    ControlDimension o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                    if (o_ControlDimension == null) continue;
                    o_ControlDimension.removePropertyChangeListener(p_ControlGroup);
                }
            }
        }
        if (boolRemoved) {
            this.firePropertyChange(PROP_CONTROLGROUP, oldValue, this.m_ArrayListControlGroups);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater((Runnable)this.m_RunnableRevalidateRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshControlGroups(ControlDimension p_ControlDimension) {
        ArrayList<ControlGroup> o_ControlGroups;
        if (p_ControlDimension == null) {
            return;
        }
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (this.m_ArrayListControlGroups == null) {
                return;
            }
            if (this.m_ArrayListControlGroups.size() <= 0) {
                return;
            }
            o_ControlGroups = new ArrayList<ControlGroup>(this.m_ArrayListControlGroups.size());
            o_ControlGroups.addAll(this.m_ArrayListControlGroups);
        }
        for (int intControlGroup = 0; intControlGroup < o_ControlGroups.size(); ++intControlGroup) {
            ControlGroup o_ControlGroup = (ControlGroup)o_ControlGroups.get(intControlGroup);
            if (o_ControlGroup == null) continue;
            o_ControlGroup.refreshValues(p_ControlDimension);
        }
        o_ControlGroups.clear();
    }

    public void setVisibleOnScreen(boolean p_IsVisible) {
        for (int intControlDimension = 0; intControlDimension < this.m_ControlDimensions.size(); ++intControlDimension) {
            ControlDimension o_ControlDimension = this.getControlDimension(intControlDimension);
            if (o_ControlDimension == null) continue;
            o_ControlDimension.setVisibleOnScreen(p_IsVisible);
        }
    }

    public void setValueManuallyIsReady() {
        EventQueueHandler.invokeLater((Runnable)this.m_RunnableSetValueManuallyIsReady);
    }

    public abstract void adjustToValue(ControlDimension var1, double var2, boolean var4);

    public ValueSelection showValueSelection(ValueSelectionInterface p_ValueSelectionInterface, ArrayList<ControlDimension> p_ControlDimensions, int p_X, int p_Y) {
        if (p_ControlDimensions == null || p_ControlDimensions.size() <= 0) {
            return null;
        }
        if (s_ValueSelection == null) {
            s_ValueSelection = new ValueSelection();
        }
        s_ValueSelection.showSelection(p_ValueSelectionInterface, p_ControlDimensions, p_X, p_Y);
        return s_ValueSelection;
    }

    @Override
    public void setValuesSelected(ArrayList<Double> p_Values, ArrayList<ControlDimension> p_ControlDimensions) {
        if (p_Values == null || p_Values.size() <= 0) {
            return;
        }
        if (p_ControlDimensions == null || p_ControlDimensions.size() <= 0) {
            return;
        }
        for (int intControlDimension = 0; intControlDimension < p_ControlDimensions.size(); ++intControlDimension) {
            ControlDimension o_ControlDimension = p_ControlDimensions.get(intControlDimension);
            if (o_ControlDimension == null) continue;
            if (intControlDimension >= p_Values.size()) break;
            double doubleValueNew = p_Values.get(intControlDimension);
            double doubleValueDiff = doubleValueNew - o_ControlDimension.getValue();
            o_ControlDimension.setValue(doubleValueNew, doubleValueDiff, 2);
            ControlObject o_ControlObject = o_ControlDimension.getControlObject();
            if (o_ControlObject == this || o_ControlObject == null) continue;
            o_ControlObject.setValueManuallyIsReady();
        }
        this.setValueManuallyIsReady();
    }

    @Override
    public ControlLabelModel.ControlLabelList getControlLabelListSelected(ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return null;
        }
        ControlLabelModel o_ControlLabelModel = p_ControlDimension.getControlLabelModel();
        if (o_ControlLabelModel == null) {
            return null;
        }
        return o_ControlLabelModel.getSelectedControlLabelList();
    }

    @Override
    public ArrayList<Double> getValues() {
        ArrayList<Double> o_Values = new ArrayList<Double>(this.getControlDimensionCount());
        for (int intDimension = 0; intDimension < this.getControlDimensionCount(); ++intDimension) {
            ControlDimension o_ControlDimension = this.getControlDimension(intDimension);
            if (o_ControlDimension == null) continue;
            o_Values.add(o_ControlDimension.getValue());
        }
        return o_Values;
    }

    public double getValue(int p_DimensionIndex) {
        ControlDimension o_ControlDimension = this.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return 0.0;
        }
        return o_ControlDimension.getValue();
    }

    public ControlDimension createNewControlDimension() {
        if (this.m_ControlDimensions == null) {
            return null;
        }
        ControlDimension o_ControlDimension = new ControlDimension(this, this.m_ControlDimensions.size());
        this.addControlDimension(o_ControlDimension);
        return o_ControlDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlDimension(ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return;
        }
        if (this.m_ControlDimensions == null) {
            return;
        }
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (this.m_ControlDimensions.contains(p_ControlDimension)) {
                return;
            }
            this.m_ControlDimensions.add(p_ControlDimension);
            this.m_Values.add(p_ControlDimension.getValue());
        }
        this.m_ControlDimensionListModel.add((Object)p_ControlDimension);
    }

    public int getControlDimensionCount() {
        if (this.m_ControlDimensions == null) {
            return 0;
        }
        return this.m_ControlDimensions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlDimension getControlDimension(int p_Index) {
        if (this.m_ControlDimensions == null) {
            return null;
        }
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ControlDimensions.size()) {
                return null;
            }
            return this.m_ControlDimensions.get(p_Index);
        }
    }

    public int indexOf(ControlDimension p_ControlDimension) {
        if (this.m_ControlDimensions == null) {
            return -1;
        }
        return this.m_ControlDimensions.indexOf(p_ControlDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeControlDimension(ControlDimension p_ControlDimension) {
        int intIndex;
        if (this.m_ControlDimensions == null) {
            return -1;
        }
        Object object = this.m_SyncControlGroups;
        synchronized (object) {
            if (!this.m_ControlDimensions.contains(p_ControlDimension)) {
                return -1;
            }
            intIndex = this.m_ControlDimensions.indexOf(p_ControlDimension);
            this.m_ControlDimensions.remove(p_ControlDimension);
            this.m_Values.remove(intIndex);
            this.m_ControlDimensionListModel.remove((Object)p_ControlDimension);
            for (int intDimension = intIndex; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                ControlDimension o_ControlDimension = this.m_ControlDimensions.get(intIndex);
                if (o_ControlDimension == null) continue;
                o_ControlDimension.setDimensionIndex(intDimension);
            }
        }
        return intIndex;
    }

    public TableAndListModel.ListModel<ControlDimension> getControlDimensionListModel() {
        return this.m_ControlDimensionListModel;
    }

    public ControlDimensionCellRenderer getControlDimensionCellRenderer() {
        if (this.m_ControlDimensionCellRenderer == null) {
            this.m_ControlDimensionCellRenderer = new ControlDimensionCellRenderer();
        }
        return this.m_ControlDimensionCellRenderer;
    }

    public void addActionsBlocking(int p_ActionsActive) {
        if ((this.m_ActionsBlocking & p_ActionsActive) != 0) {
            return;
        }
        this.m_ActionsBlocking += p_ActionsActive;
    }

    public void removeActionsBlocking(int p_ActionsActive) {
        if ((this.m_ActionsBlocking & p_ActionsActive) == 0) {
            return;
        }
        this.m_ActionsBlocking -= p_ActionsActive;
    }

    public int getActionsBlocking() {
        return this.m_ActionsBlocking;
    }

    public static class ValueSelection
    extends JDialog {
        public static Icon s_Icon = new ImageIcon(ValueSelection.class.getResource("/IconsPackage/Slider.png"));
        public static Dimension s_PreferredSize = new Dimension(250, 300);
        private JScrollPane jScrollPane_Labels;
        private ControlLabelModel.ControlLabelList m_ControlLabelList;
        private JList jList_Labels;
        private ArrayList<Double> m_ActualValues;
        private ValueSelectionInterface m_ValueSelectionInterface;
        private ArrayList<ControlDimension> m_ControlDimensions;

        public ValueSelection() {
            super((Window)null, "", Dialog.ModalityType.MODELESS);
            super.setAlwaysOnTop(true);
            this.initMembers();
            this.initComponents();
            this.setPreferredSize(new Dimension(250, 300));
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
        }

        private void initMembers() {
            this.m_ActualValues = new ArrayList(1);
            this.m_ActualValues.add(0.0);
        }

        private void initComponents() {
            this.setIconImage(((ImageIcon)s_Icon).getImage());
            this.setDefaultCloseOperation(1);
            this.setResizable(true);
            this.setUndecorated(false);
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            JPanel o_JPanel = new JPanel(o_GridBagLayout);
            o_JPanel.setPreferredSize(new Dimension(32, 150));
            this.setContentPane(o_JPanel);
            this.jScrollPane_Labels = new JScrollPane();
            this.jList_Labels = new JList();
            this.jList_Labels.setFixedCellHeight(30);
            this.jList_Labels.setCellRenderer(new ControlLabelModel.ControlLabelDescriptionCellRenderer());
            this.jList_Labels.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = (ControlLabelModel.ControlLabelDescription)jList_Labels.getSelectedValue();
                    if (o_ControlLabelDescription != null) {
                        double doubleValue = o_ControlLabelDescription.getValueDefault();
                        m_ActualValues.set(0, doubleValue);
                        if (m_ValueSelectionInterface != null) {
                            m_ValueSelectionInterface.setValuesSelected(m_ActualValues, m_ControlDimensions);
                        }
                    }
                    this.setVisible(false);
                }
            });
            this.jScrollPane_Labels.setViewportView(this.jList_Labels);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_JPanel.add((Component)this.jScrollPane_Labels, gridBagConstraints);
            this.setMinimumSize(s_PreferredSize);
            this.setPreferredSize(s_PreferredSize);
            this.pack();
        }

        public void close() {
            this.dispose();
        }

        public void showSelection(ValueSelectionInterface p_ValueSelectionInterface, ArrayList<ControlDimension> p_ControlDimensions, int p_X, int p_Y) {
            ControlDimension o_ControlDimension;
            int intDimension;
            if (p_ValueSelectionInterface == null) {
                return;
            }
            if (p_ControlDimensions == null || p_ControlDimensions.size() <= 0) {
                return;
            }
            this.m_ValueSelectionInterface = p_ValueSelectionInterface;
            this.m_ControlDimensions = p_ControlDimensions;
            ControlObject o_ControlObject = this.m_ControlDimensions.get(0).getControlObject();
            super.setTitle(o_ControlObject.getName());
            this.m_ControlLabelList = p_ValueSelectionInterface.getControlLabelListSelected(p_ControlDimensions.get(0));
            this.jList_Labels.setModel(this.m_ControlLabelList);
            if (this.m_ActualValues.size() != this.m_ControlDimensions.size()) {
                this.m_ActualValues.clear();
                for (intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                    o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                    this.m_ActualValues.add(o_ControlDimension.getValue());
                }
            }
            for (intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                this.m_ActualValues.set(intDimension, o_ControlDimension.getValue());
            }
            ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelList.getControlLabelDescriptionFromValue(this.m_ActualValues.get(0));
            int intIndex = this.m_ControlLabelList.getIndexOf(o_ControlLabelDescription);
            this.jList_Labels.setSelectedIndex(intIndex);
            this.jList_Labels.ensureIndexIsVisible(intIndex);
            this.setLocation(p_X, p_Y);
            this.setVisible(true);
        }

        @Override
        public void setLocation(int p_XOnScreen, int p_YOnScreen) {
            Dimension o_Dimension = this.getPreferredSize();
            int intX = p_XOnScreen;
            int intY = p_YOnScreen;
            GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription((int)p_XOnScreen, (int)p_YOnScreen);
            if (o_GraphicsDeviceDescription == null) {
                o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription((int)0);
            }
            if (o_GraphicsDeviceDescription != null) {
                if (intX < o_GraphicsDeviceDescription.getX()) {
                    intX = o_GraphicsDeviceDescription.getX();
                }
                if (intX + o_Dimension.width > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth()) {
                    intX = o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() - o_Dimension.width;
                }
                if (intY < o_GraphicsDeviceDescription.getY()) {
                    intY = o_GraphicsDeviceDescription.getY();
                }
                if (intY + o_Dimension.height > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) {
                    intY = o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight() - o_Dimension.height;
                }
            }
            super.setLocation(intX, intY);
        }
    }

    public static class ControlBlocks
    extends JComponent
    implements ListDataListener,
    PropertyChangeListener,
    Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlDimension m_ControlDimension;
        protected ControlBlockModel m_ControlBlockModel;
        protected ControlBlockModel.ControlBlockList m_ControlBlockList;
        protected ArrayList<ControlBlock> m_ArrayListBlocks;
        protected AbsoluteLayout m_LayoutManager;
        protected boolean m_BlocksVisible;
        protected Insets m_BlocksInsets;
        protected int m_BlocksAlignment;
        protected boolean m_BlocksMirrored;
        protected Dimension m_BlocksSize;
        protected Font m_BlocksFont;
        protected Border m_BlocksBorder;
        protected Color m_Foreground;
        protected AbsoluteConstraints m_BlocksConstraints;
        protected double m_BlocksTextRotation;
        protected RotationLabelUI m_RotationLabelUI;
        private Runnable m_RunnableRepaint;

        public ControlBlocks(ControlDimension p_ControlDimension) {
            this.m_ControlDimension = p_ControlDimension;
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_ControlBlockModel = null;
            this.m_BlocksVisible = true;
            this.m_ArrayListBlocks = new ArrayList();
            this.m_BlocksInsets = new Insets(0, 0, 0, 0);
            this.m_BlocksSize = new Dimension(16, 16);
            this.m_BlocksMirrored = false;
            this.m_BlocksTextRotation = 0.0;
            this.m_BlocksBorder = new BevelBorder(1);
            this.m_Foreground = Color.BLACK;
            this.m_RunnableRepaint = new Runnable(){

                @Override
                public void run() {
                    this.revalidate();
                    this.repaint();
                }
            };
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeBoolean(this.m_BlocksVisible);
            p_ObjectOutput.writeInt(this.m_BlocksAlignment);
            p_ObjectOutput.writeBoolean(this.m_BlocksMirrored);
            p_ObjectOutput.writeDouble(this.m_BlocksTextRotation);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Foreground);
            p_ObjectOutput.writeObject(this.m_BlocksSize);
            p_ObjectOutput.writeObject(this.m_BlocksFont);
            p_ObjectOutput.writeObject(this.m_BlocksInsets);
            p_ObjectOutput.writeObject(this.m_BlocksBorder);
            this.m_ControlBlockModel.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_BlocksVisible = p_ObjectInput.readBoolean();
            this.setVisible(this.m_BlocksVisible);
            this.m_BlocksAlignment = p_ObjectInput.readInt();
            this.m_BlocksMirrored = p_ObjectInput.readBoolean();
            this.m_BlocksTextRotation = p_ObjectInput.readDouble();
            this.m_RotationLabelUI.setRotationDegree(this.m_BlocksTextRotation);
            this.m_Foreground = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            this.m_BlocksSize = (Dimension)p_ObjectInput.readObject();
            this.m_BlocksFont = (Font)p_ObjectInput.readObject();
            this.m_BlocksInsets = (Insets)p_ObjectInput.readObject();
            this.m_BlocksBorder = (Border)p_ObjectInput.readObject();
            if (this.m_ControlBlockModel == null) {
                this.m_ControlBlockModel = this.m_ControlDimension == null ? new ControlBlockModel(0.0, 0.0) : new ControlBlockModel(this.m_ControlDimension.getValueMinimum(), this.m_ControlDimension.getValueMaximum());
            }
            this.m_ControlBlockModel.clearControlBlockLists();
            this.m_ControlBlockModel.readExternal(p_ObjectInput);
            this.setControlBlockModel(this.m_ControlBlockModel);
            this.calculate();
        }

        private void initComponents() {
            this.m_RotationLabelUI = new RotationLabelUI(this.m_BlocksTextRotation);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_BlocksConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.setOpaque(false);
            this.setVisible(this.m_BlocksVisible);
            if (this.m_ControlDimension == null) {
                this.setControlBlockModel(new ControlBlockModel(0.0, 0.0));
            } else {
                this.setControlBlockModel(new ControlBlockModel(this.m_ControlDimension.getValueMinimum(), this.m_ControlDimension.getValueMaximum()));
                this.setForeground(this.m_ControlDimension.getControlObject().getForeground());
            }
        }

        public ControlDimension getControlDimension() {
            return this.m_ControlDimension;
        }

        @Override
        public void setForeground(Color p_Color) {
            if (p_Color == null) {
                return;
            }
            if (this.m_Foreground.equals(p_Color)) {
                return;
            }
            this.m_Foreground = p_Color;
            for (int intLabel = 0; intLabel < this.m_ArrayListBlocks.size(); ++intLabel) {
                this.m_ArrayListBlocks.get(intLabel).setForeground(this.m_Foreground);
            }
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_BlocksConstraints;
        }

        public boolean getBlocksVisible() {
            return this.m_BlocksVisible;
        }

        public void setBlocksVisible(boolean p_BlocksVisible) {
            boolean oldValue = this.m_BlocksVisible;
            this.m_BlocksVisible = p_BlocksVisible;
            if (this.m_BlocksVisible != oldValue) {
                this.setVisible(this.m_BlocksVisible);
                this.firePropertyChange(ControlObject.PROP_BLOCKSVISIBLE, oldValue, this.m_BlocksVisible);
            }
        }

        public Insets getBlocksInsets() {
            return this.m_BlocksInsets;
        }

        public void setBlocksInsets(Insets p_BlocksInsets) {
            Insets oldValue = this.m_BlocksInsets;
            this.m_BlocksInsets = p_BlocksInsets;
            if (!this.m_BlocksInsets.equals(oldValue)) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSINSETS, oldValue, this.m_BlocksInsets);
            }
        }

        public int getBlocksAlignment() {
            return this.m_BlocksAlignment;
        }

        public void setBlocksAlignment(int p_BlocksAlignment) {
            if (p_BlocksAlignment != 0 && p_BlocksAlignment != 2 && p_BlocksAlignment != 4 && p_BlocksAlignment != 3 && p_BlocksAlignment != 1) {
                p_BlocksAlignment = 0;
            }
            int oldValue = this.m_BlocksAlignment;
            this.m_BlocksAlignment = p_BlocksAlignment;
            if (oldValue != this.m_BlocksAlignment) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSALIGNMENT, oldValue, this.m_BlocksAlignment);
            }
        }

        public boolean getBlocksMirrored() {
            return this.m_BlocksMirrored;
        }

        public void setBlocksMirrored(boolean p_BlocksMirrored) {
            boolean oldValue = this.m_BlocksMirrored;
            this.m_BlocksMirrored = p_BlocksMirrored;
            if (oldValue != this.m_BlocksMirrored) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSMIRRORED, oldValue, this.m_BlocksMirrored);
            }
        }

        public Font getBlocksFont() {
            return this.m_BlocksFont;
        }

        public void setBlocksFont(Font p_BlocksFont) {
            Font oldValue = this.m_BlocksFont;
            this.m_BlocksFont = p_BlocksFont;
            if (oldValue != this.m_BlocksFont) {
                for (int intBlock = 0; intBlock < this.m_ArrayListBlocks.size(); ++intBlock) {
                    this.m_ArrayListBlocks.get(intBlock).setFont(this.m_BlocksFont);
                }
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSFONT, oldValue, this.m_BlocksFont);
            }
        }

        public void setBlocksTextRotation(double p_Degree) {
            double oldValue = this.m_BlocksTextRotation;
            this.m_BlocksTextRotation = p_Degree;
            if (oldValue != this.m_BlocksTextRotation) {
                this.m_RotationLabelUI.setRotationDegree(this.m_BlocksTextRotation);
                this.firePropertyChange("blocksRotation", oldValue, this.m_BlocksTextRotation);
                if (!SwingUtilities.isEventDispatchThread()) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
                } else {
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        public Border getBlocksBorder() {
            return this.m_BlocksBorder;
        }

        public void setBlocksBorder(Border p_BlocksBorder) {
            Border oldValue = this.m_BlocksBorder;
            this.m_BlocksBorder = p_BlocksBorder;
            if (oldValue != this.m_BlocksBorder) {
                for (int intBlock = 0; intBlock < this.m_ArrayListBlocks.size(); ++intBlock) {
                    this.m_ArrayListBlocks.get(intBlock).setBorder(this.m_BlocksBorder);
                }
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSBORDER, oldValue, this.m_BlocksBorder);
            }
        }

        public ControlBlockModel getControlBlockModel() {
            return this.m_ControlBlockModel;
        }

        public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
            if (this.m_ControlBlockModel != null) {
                this.m_ControlBlockModel.removePropertyChangeListener(this);
                this.setSelectedControlBlockList(null);
            }
            ControlBlockModel oldValue = this.m_ControlBlockModel;
            this.m_ControlBlockModel = p_ControlBlockModel;
            if (this.m_ControlBlockModel != null) {
                this.m_ControlBlockModel.addPropertyChangeListener(this);
                this.setSelectedControlBlockList(this.m_ControlBlockModel.getSelectedControlBlockList());
            }
            this.firePropertyChange(ControlObject.PROP_BLOCKSMODEL, oldValue, p_ControlBlockModel);
        }

        public void setSelectedControlBlockList(ControlBlockModel.ControlBlockList p_ControlBlockList) {
            ControlBlock o_ControlBlock;
            int intBlock;
            if (this.m_ControlBlockList == p_ControlBlockList) {
                return;
            }
            if (this.m_ControlBlockList != null) {
                this.m_ControlBlockList.removeListDataListener(this);
                this.m_ControlBlockList.removePropertyChangeListener(this);
            }
            for (intBlock = this.m_ArrayListBlocks.size() - 1; intBlock >= 0; --intBlock) {
                o_ControlBlock = this.m_ArrayListBlocks.get(intBlock);
                if (o_ControlBlock == null) continue;
                o_ControlBlock.setVisible(false);
                this.remove((Component)((Object)o_ControlBlock));
            }
            this.m_ArrayListBlocks.clear();
            this.m_ControlBlockList = p_ControlBlockList;
            if (this.m_ControlBlockList != null) {
                this.m_ControlBlockList.addListDataListener(this);
                this.m_ControlBlockList.addPropertyChangeListener(this);
                for (intBlock = 0; intBlock < this.m_ControlBlockModel.getControlBlockDescriptionSize(); ++intBlock) {
                    o_ControlBlock = new ControlBlock();
                    o_ControlBlock.setForeground(this.m_Foreground);
                    o_ControlBlock.setControlBlockDescription(this.m_ControlBlockModel.getControlBlockDescription(intBlock));
                    o_ControlBlock.setFont(this.m_BlocksFont);
                    o_ControlBlock.setUI((LabelUI)this.m_RotationLabelUI);
                    this.m_ArrayListBlocks.add(o_ControlBlock);
                    this.add((Component)((Object)o_ControlBlock), o_ControlBlock.getConstraints());
                }
            }
            this.calculate();
        }

        @Override
        public void intervalAdded(ListDataEvent p_ListDataEvent) {
            if (p_ListDataEvent == null) {
                return;
            }
            for (int intDescription = p_ListDataEvent.getIndex0(); intDescription <= p_ListDataEvent.getIndex1(); ++intDescription) {
                ControlBlockModel.ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockModel.getControlBlockDescription(intDescription);
                ControlBlock o_ControlBlock = new ControlBlock();
                o_ControlBlock.setForeground(this.m_Foreground);
                o_ControlBlock.setControlBlockDescription(o_ControlBlockDescription);
                o_ControlBlock.setFont(this.m_BlocksFont);
                o_ControlBlock.setBorder(this.m_BlocksBorder);
                this.m_ArrayListBlocks.add(intDescription, o_ControlBlock);
                this.add((Component)((Object)o_ControlBlock), o_ControlBlock.getConstraints());
                this.setComponentZOrder((Component)((Object)o_ControlBlock), 0);
                o_ControlBlock.setVisible(true);
            }
            this.calculate();
        }

        @Override
        public void intervalRemoved(ListDataEvent p_ListDataEvent) {
            ControlBlock o_ControlBlock;
            if (p_ListDataEvent == null) {
                return;
            }
            ArrayList<ControlBlock> o_ControlBlocks = new ArrayList<ControlBlock>();
            for (int intDescription = p_ListDataEvent.getIndex0(); intDescription <= p_ListDataEvent.getIndex1(); ++intDescription) {
                try {
                    o_ControlBlock = this.m_ArrayListBlocks.get(p_ListDataEvent.getIndex0());
                    if (o_ControlBlock == null) continue;
                    o_ControlBlocks.add(o_ControlBlock);
                    continue;
                }
                catch (Exception error) {
                    // empty catch block
                }
            }
            for (int intBlock = 0; intBlock < o_ControlBlocks.size(); ++intBlock) {
                o_ControlBlock = (ControlBlock)((Object)o_ControlBlocks.get(intBlock));
                o_ControlBlock.setVisible(false);
                this.m_ArrayListBlocks.remove((Object)o_ControlBlock);
                this.remove((Component)((Object)o_ControlBlock));
            }
            o_ControlBlocks.clear();
            this.calculate();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e == null) {
                return;
            }
            for (int intDescription = e.getIndex0(); intDescription <= e.getIndex1(); ++intDescription) {
                ControlBlock o_ControlBlock = this.m_ArrayListBlocks.get(intDescription);
                if (o_ControlBlock == null) continue;
                ControlBlockModel.ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockModel.getControlBlockDescription(intDescription);
                o_ControlBlock.setControlBlockDescription(o_ControlBlockDescription);
            }
            this.calculate();
        }

        public ControlBlock getControlBlock(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_ArrayListBlocks.size()) {
                return null;
            }
            return this.m_ArrayListBlocks.get(p_Index);
        }

        public int getControlBlocksCount() {
            if (this.m_ArrayListBlocks == null) {
                return 0;
            }
            return this.m_ArrayListBlocks.size();
        }

        public Dimension getBlocksSize() {
            return this.m_BlocksSize;
        }

        public void setBlocksSize(Dimension p_BlocksSize) {
            Dimension oldValue = this.m_BlocksSize;
            this.m_BlocksSize = p_BlocksSize;
            if (oldValue != this.m_BlocksSize) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_BLOCKSSIZE, oldValue, this.m_BlocksSize);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlBlockModel && "listSelected".equals(evt.getPropertyName())) {
                IndexedPropertyChangeEvent ievt = (IndexedPropertyChangeEvent)evt;
                int intIndex = ievt.getIndex();
                if (this.m_ControlDimension != null) {
                    ControlBlockModel.ControlBlockList o_ControlBlockList = this.m_ControlBlockModel.getSelectedControlBlockList();
                    this.setSelectedControlBlockList(o_ControlBlockList);
                }
            }
            this.firePropertyChange(ControlObject.PROP_BLOCKSMODEL, this.m_ControlBlockModel, this.m_ControlBlockModel);
        }

        public double getMinimalDistance() {
            if (this.m_ControlBlockModel == null) {
                return -1.0;
            }
            return this.m_ControlBlockModel.getMinimalDistance();
        }

        public void calculate() {
            this.setVisible(this.m_BlocksVisible);
            if (this.m_ControlDimension != null) {
                this.m_ControlDimension.getControlObject().calculateBlocks(this);
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            if (this.m_ControlDimension != null) {
                this.m_ControlDimension.getControlObject().paintBlocks(p_Graphics, this);
            }
        }

        public class ControlBlock
        extends JLabelBackground {
            protected ControlBlockModel.ControlBlockDescription m_ControlBlockDescription;
            protected double m_ValueStart;
            protected double m_ValueEnd;
            protected double m_ValueDefault;
            protected String m_Text;
            protected Image m_Image;
            protected boolean m_Visible;
            protected AbsoluteConstraints m_Constraints;
            protected Border m_Border;

            public ControlBlock() {
                this.initMembers();
            }

            private void initMembers() {
                this.readResolve();
                this.setName("ControlBlock");
            }

            private Object readResolve() {
                this.initComponents();
                return this;
            }

            private void initComponents() {
                this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
                this.setFont(ControlBlocks.this.m_BlocksFont);
                this.setBackgroundOpaque(false);
                this.setVisible(true);
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ControlBlock.this.setValue(2);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
                this.m_Border = new BevelBorder(1);
                this.setBorder(this.m_Border);
                this.setUI((LabelUI)ControlBlocks.this.m_RotationLabelUI);
            }

            public void setValue(int p_Action) {
                double doubleValueDiff = this.m_ValueDefault - ControlBlocks.this.m_ControlDimension.getValue();
                ControlBlocks.this.m_ControlDimension.setValue(this.m_ValueDefault, doubleValueDiff, p_Action);
                ControlBlocks.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
            }

            public void setText(String p_Text) {
                super.setText(p_Text);
            }

            public ControlBlockModel.ControlBlockDescription getControlBlockDescription() {
                return this.m_ControlBlockDescription;
            }

            public void setControlBlockDescription(ControlBlockModel.ControlBlockDescription p_ControlBlockDescription) {
                this.m_ControlBlockDescription = p_ControlBlockDescription;
                this.refresh();
            }

            public void refresh() {
                this.m_ValueStart = this.m_ControlBlockDescription.getValueStart();
                this.m_ValueEnd = this.m_ControlBlockDescription.getValueEnd();
                this.m_ValueDefault = this.m_ControlBlockDescription.getValueDefault();
                this.m_Text = this.m_ControlBlockDescription.getBlockText();
                this.m_Image = this.m_ControlBlockDescription.getBlockImage();
                this.m_Visible = this.m_ControlBlockDescription.getVisible();
                this.setBackgroundImage(this.m_Image);
                Color o_Color = this.m_ControlBlockDescription.getBlockColor();
                this.setBackground(o_Color);
                if (this.m_Image != null) {
                    this.setText("");
                    this.setBackgroundStyle(2);
                    this.setBackgroundOpaque(true);
                } else if (o_Color != null) {
                    this.setText("");
                    this.setBackgroundStyle(0);
                    this.setBackgroundOpaque(true);
                } else {
                    if (this.m_Text == null) {
                        this.setText("");
                    } else {
                        this.setText(this.m_Text);
                    }
                    Color o_ForeColor = this.getForeground();
                    this.setBackgroundStyle(0);
                    this.setBackgroundOpaque(false);
                }
                this.setToolTipText(this.m_Text);
                this.setVisible(this.m_Visible);
                if (!SwingUtilities.isEventDispatchThread()) {
                    EventQueueHandler.invokeLater((Runnable)ControlBlocks.this.m_RunnableRepaint);
                } else {
                    this.revalidate();
                    this.repaint();
                }
            }

            public AbsoluteConstraints getConstraints() {
                return this.m_Constraints;
            }
        }
    }

    public static class ControlLabels
    extends JComponent
    implements ListDataListener,
    PropertyChangeListener,
    Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlDimension m_ControlDimension;
        protected ControlLabelModel m_ControlLabelModel;
        protected ControlLabelModel.ControlLabelList m_ControlLabelList;
        protected ArrayList<ControlLabel> m_ArrayListLabels;
        protected AbsoluteLayout m_LayoutManager;
        protected boolean m_LabelsVisible;
        protected Insets m_LabelsInsets;
        protected int m_LabelsAlignment;
        protected boolean m_LabelsMirrored;
        protected Dimension m_LabelsSize;
        protected boolean m_LabelsSizeFixed;
        protected Font m_LabelsFont;
        protected Border m_LabelsBorder;
        protected AbsoluteConstraints m_LabelsConstraints;
        protected Color m_Foreground;
        protected double m_LabelsTextRotation;
        protected RotationLabelUI m_RotationLabelUI;
        private Runnable m_RunnableRepaint;

        public ControlLabels(ControlDimension p_ControlDimension) {
            this.m_ControlDimension = p_ControlDimension;
            this.initMembers();
            this.initComponents();
            this.readResolve();
        }

        private void initMembers() {
            this.m_LabelsVisible = true;
            this.m_LabelsMirrored = false;
            this.m_LabelsTextRotation = 0.0;
            this.m_Foreground = Color.BLACK;
            this.m_LabelsSize = new Dimension(16, 16);
            this.m_LabelsSizeFixed = true;
            this.m_LabelsFont = new Font("Serif", 0, 9);
            this.m_LabelsInsets = new Insets(0, 0, 0, 0);
            this.m_LabelsBorder = null;
            this.m_ArrayListLabels = new ArrayList();
            this.m_RunnableRepaint = new Runnable(){

                @Override
                public void run() {
                    this.revalidate();
                    this.repaint();
                }
            };
        }

        private Object readResolve() {
            this.calculate();
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeBoolean(this.m_LabelsVisible);
            p_ObjectOutput.writeInt(this.m_LabelsAlignment);
            p_ObjectOutput.writeBoolean(this.m_LabelsMirrored);
            p_ObjectOutput.writeDouble(this.m_LabelsTextRotation);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Foreground);
            p_ObjectOutput.writeObject(this.m_LabelsSize);
            p_ObjectOutput.writeBoolean(this.m_LabelsSizeFixed);
            p_ObjectOutput.writeObject(this.m_LabelsFont);
            p_ObjectOutput.writeObject(this.m_LabelsInsets);
            p_ObjectOutput.writeObject(this.m_LabelsBorder);
            this.m_ControlLabelModel.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_LabelsVisible = p_ObjectInput.readBoolean();
            this.setVisible(this.m_LabelsVisible);
            this.m_LabelsAlignment = p_ObjectInput.readInt();
            this.m_LabelsMirrored = p_ObjectInput.readBoolean();
            this.m_LabelsTextRotation = p_ObjectInput.readDouble();
            this.m_RotationLabelUI.setRotationDegree(this.m_LabelsTextRotation);
            this.m_Foreground = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            this.m_LabelsSize = (Dimension)p_ObjectInput.readObject();
            this.m_LabelsSizeFixed = p_ObjectInput.readBoolean();
            this.m_LabelsFont = (Font)p_ObjectInput.readObject();
            this.m_LabelsInsets = (Insets)p_ObjectInput.readObject();
            this.m_LabelsBorder = (Border)p_ObjectInput.readObject();
            if (this.m_ControlLabelModel == null) {
                if (this.m_ControlDimension == null) {
                    this.m_ControlLabelModel = new ControlLabelModel("", 0.0, 0.0);
                } else {
                    String stringName = "";
                    if (this.m_ControlDimension.getControlObject() != null) {
                        stringName = this.m_ControlDimension.getControlObject().getName();
                    }
                    this.m_ControlLabelModel = new ControlLabelModel(stringName, this.m_ControlDimension.getValueMinimum(), this.m_ControlDimension.getValueMaximum());
                }
            }
            this.m_ControlLabelModel.clearControlLabelLists();
            this.m_ControlLabelModel.readExternal(p_ObjectInput);
            this.setControlLabelModel(this.m_ControlLabelModel);
            this.calculate();
        }

        private void initComponents() {
            this.m_RotationLabelUI = new RotationLabelUI(this.m_LabelsTextRotation);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_LabelsConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.setOpaque(false);
            this.setVisible(this.m_LabelsVisible);
            if (this.m_ControlDimension == null) {
                this.setControlLabelModel(new ControlLabelModel("", 0.0, 0.0));
            } else {
                String stringName = "";
                if (this.m_ControlDimension.getControlObject() != null) {
                    stringName = this.m_ControlDimension.getControlObject().getName();
                }
                this.setControlLabelModel(new ControlLabelModel(stringName, this.m_ControlDimension.getValueMinimum(), this.m_ControlDimension.getValueMaximum()));
                this.setForeground(this.m_ControlDimension.getControlObject().getForeground());
            }
        }

        public ControlDimension getControlDimension() {
            return this.m_ControlDimension;
        }

        @Override
        public void setForeground(Color p_Color) {
            if (p_Color == null) {
                return;
            }
            if (this.m_Foreground.equals(p_Color)) {
                return;
            }
            this.m_Foreground = p_Color;
            for (int intLabel = 0; intLabel < this.m_ArrayListLabels.size(); ++intLabel) {
                this.m_ArrayListLabels.get(intLabel).setForeground(this.m_Foreground);
            }
            super.setForeground(p_Color);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_LabelsConstraints;
        }

        public boolean getLabelsVisible() {
            return this.m_LabelsVisible;
        }

        public void setLabelsVisible(boolean p_LabelsVisible) {
            boolean oldValue = this.m_LabelsVisible;
            this.m_LabelsVisible = p_LabelsVisible;
            if (this.m_LabelsVisible != oldValue) {
                this.setVisible(this.m_LabelsVisible);
                this.firePropertyChange(ControlObject.PROP_LABELSVISIBLE, oldValue, this.m_LabelsVisible);
            }
        }

        public Insets getLabelsInsets() {
            return this.m_LabelsInsets;
        }

        public void setLabelsInsets(Insets p_LabelsInsets) {
            Insets oldValue = this.m_LabelsInsets;
            this.m_LabelsInsets = p_LabelsInsets;
            if (!this.m_LabelsInsets.equals(oldValue)) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_LABELSINSETS, oldValue, this.m_LabelsInsets);
            }
        }

        public int getLabelsAlignment() {
            return this.m_LabelsAlignment;
        }

        public void setLabelsAlignment(int p_LabelsAlignment) {
            if (p_LabelsAlignment != 0 && p_LabelsAlignment != 2 && p_LabelsAlignment != 4 && p_LabelsAlignment != 3 && p_LabelsAlignment != 1) {
                p_LabelsAlignment = 0;
            }
            int oldValue = this.m_LabelsAlignment;
            this.m_LabelsAlignment = p_LabelsAlignment;
            if (oldValue != this.m_LabelsAlignment) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_LABELSALIGNMENT, oldValue, this.m_LabelsAlignment);
            }
        }

        public boolean getLabelsMirrored() {
            return this.m_LabelsMirrored;
        }

        public void setLabelsMirrored(boolean p_LabelsMirrored) {
            boolean oldValue = this.m_LabelsMirrored;
            this.m_LabelsMirrored = p_LabelsMirrored;
            if (oldValue != this.m_LabelsMirrored) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_LABELSMIRRORED, oldValue, this.m_LabelsMirrored);
            }
        }

        public Font getLabelsFont() {
            return this.m_LabelsFont;
        }

        public void setLabelsFont(Font p_LabelsFont) {
            Font oldValue = this.m_LabelsFont;
            this.m_LabelsFont = p_LabelsFont;
            for (int intLabel = 0; intLabel < this.m_ArrayListLabels.size(); ++intLabel) {
                this.m_ArrayListLabels.get(intLabel).setFont(this.m_LabelsFont);
            }
            this.calculate();
            this.firePropertyChange(ControlObject.PROP_LABELSFONT, oldValue, this.m_LabelsFont);
        }

        public void setLabelsTextRotation(double p_Degree) {
            double oldValue = this.m_LabelsTextRotation;
            this.m_LabelsTextRotation = p_Degree;
            if (oldValue != this.m_LabelsTextRotation) {
                this.m_RotationLabelUI.setRotationDegree(this.m_LabelsTextRotation);
                this.firePropertyChange("blocksRotation", oldValue, this.m_LabelsTextRotation);
                if (!SwingUtilities.isEventDispatchThread()) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
                } else {
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        public double getLabelsTextRotation() {
            return this.m_LabelsTextRotation;
        }

        public Border getLabelsBorder() {
            return this.m_LabelsBorder;
        }

        public void setLabelsBorder(Border p_LabelsBorder) {
            Border oldValue = this.m_LabelsBorder;
            this.m_LabelsBorder = p_LabelsBorder;
            for (int intLabel = 0; intLabel < this.m_ArrayListLabels.size(); ++intLabel) {
                this.m_ArrayListLabels.get(intLabel).setBorder(this.m_LabelsBorder);
            }
            this.calculate();
            this.firePropertyChange(ControlObject.PROP_LABELSBORDER, oldValue, this.m_LabelsBorder);
        }

        public boolean getLabelsAutomatic() {
            if (this.m_ControlLabelModel == null) {
                return false;
            }
            return this.m_ControlLabelModel.getLabelsAutomatic();
        }

        public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
            if (this.m_ControlLabelModel == null) {
                return;
            }
            boolean oldValue = this.m_ControlLabelModel.getLabelsAutomatic();
            this.m_ControlLabelModel.setLabelsAutomatic(p_LabelsAutomatic);
            if (oldValue != p_LabelsAutomatic) {
                if (this.m_ControlDimension != null) {
                    this.m_ControlDimension.recalculateControlLabels();
                }
                this.firePropertyChange(ControlObject.PROP_LABELSAUTOMATIC, oldValue, p_LabelsAutomatic);
            }
        }

        public ControlLabelModel getControlLabelModel() {
            return this.m_ControlLabelModel;
        }

        public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
            ControlLabelModel.ControlLabelList o_ControlLabelList;
            if (this.m_ControlLabelModel == p_ControlLabelModel && this.m_ControlLabelList == (o_ControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList())) {
                return;
            }
            if (this.m_ControlLabelModel != null) {
                this.m_ControlLabelModel.removePropertyChangeListener(this);
                this.setSelectedControlLableList(null);
            }
            ControlLabelModel oldValue = this.m_ControlLabelModel;
            this.m_ControlLabelModel = p_ControlLabelModel;
            if (this.m_ControlLabelModel != null) {
                this.m_ControlLabelModel.addPropertyChangeListener(this);
                this.setSelectedControlLableList(this.m_ControlLabelModel.getSelectedControlLabelList());
            }
            this.firePropertyChange(ControlObject.PROP_LABELSMODEL, oldValue, p_ControlLabelModel);
        }

        public void setSelectedControlLableList(ControlLabelModel.ControlLabelList p_ControlLabelList) {
            ControlLabel o_ControlLabel;
            int intLabel;
            if (this.m_ControlLabelList == p_ControlLabelList) {
                return;
            }
            if (this.m_ControlLabelList != null) {
                this.m_ControlLabelList.removeListDataListener(this);
                this.m_ControlLabelList.removePropertyChangeListener(this);
            }
            for (intLabel = this.m_ArrayListLabels.size() - 1; intLabel >= 0; --intLabel) {
                o_ControlLabel = this.m_ArrayListLabels.get(intLabel);
                if (o_ControlLabel == null) continue;
                o_ControlLabel.setVisible(false);
                this.remove((Component)((Object)o_ControlLabel));
            }
            this.m_ArrayListLabels.clear();
            this.m_ControlLabelList = p_ControlLabelList;
            if (this.m_ControlLabelList != null) {
                this.m_ControlLabelList.addListDataListener(this);
                this.m_ControlLabelList.addPropertyChangeListener(this);
                for (intLabel = 0; intLabel < this.m_ControlLabelList.getControlLabelDescriptionSize(); ++intLabel) {
                    o_ControlLabel = new ControlLabel();
                    o_ControlLabel.setForeground(this.m_Foreground);
                    o_ControlLabel.setControlLabelDescription(this.m_ControlLabelList.getControlLabelDescription(intLabel));
                    o_ControlLabel.setFont(this.m_LabelsFont);
                    o_ControlLabel.setUI((LabelUI)this.m_RotationLabelUI);
                    this.m_ArrayListLabels.add(o_ControlLabel);
                    o_ControlLabel.setVisible(true);
                    this.add((Component)((Object)o_ControlLabel), o_ControlLabel.getConstraints());
                }
                if (this.m_ControlLabelList.getLabelsAutomatic() && this.m_ControlDimension != null) {
                    this.m_ControlDimension.recalculateControlLabels();
                }
            }
            this.calculate();
        }

        public ControlLabel getControlLabel(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_ArrayListLabels.size()) {
                return null;
            }
            return this.m_ArrayListLabels.get(p_Index);
        }

        public int getControlLabelsCount() {
            if (this.m_ArrayListLabels == null) {
                return 0;
            }
            return this.m_ArrayListLabels.size();
        }

        public Dimension getLabelsSize() {
            return this.m_LabelsSize;
        }

        public void setLabelsSize(Dimension p_LabelsSize) {
            Dimension oldValue = this.m_LabelsSize;
            this.m_LabelsSize = p_LabelsSize;
            this.calculate();
            this.firePropertyChange(ControlObject.PROP_LABELSSIZE, oldValue, this.m_LabelsSize);
        }

        public void setLabelsSizeFixed(boolean p_LabelsSizeFixed) {
            boolean oldValue = this.m_LabelsSizeFixed;
            this.m_LabelsSizeFixed = p_LabelsSizeFixed;
            this.calculate();
            this.firePropertyChange(ControlObject.PROP_LABELSSIZEFIXED, oldValue, this.m_LabelsSizeFixed);
        }

        public boolean getLabelsSizeFixed() {
            return this.m_LabelsSizeFixed;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlLabelModel && "listSelected".equals(evt.getPropertyName())) {
                IndexedPropertyChangeEvent ievt = (IndexedPropertyChangeEvent)evt;
                int intIndex = ievt.getIndex();
                if (this.m_ControlDimension != null) {
                    ControlLabelModel.ControlLabelList o_ControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList();
                    this.setSelectedControlLableList(o_ControlLabelList);
                    intIndex = this.m_ControlLabelModel.getSelectedControlLabelListIndex();
                    ControlBlockModel o_ControlBlockModel = this.m_ControlDimension.getControlBlockModel();
                    o_ControlBlockModel.setSelectedBlockList(intIndex);
                }
            }
            this.firePropertyChange(ControlObject.PROP_LABELSMODEL, this.m_ControlLabelModel, this.m_ControlLabelModel);
        }

        public double getMinimalLabelsDistance() {
            if (this.m_ControlLabelModel == null) {
                return -1.0;
            }
            return this.m_ControlLabelModel.getMinimalDistance();
        }

        public void calculate() {
            this.setVisible(this.m_LabelsVisible);
            if (this.m_ControlDimension != null && this.m_ControlDimension.getControlObject() != null) {
                this.m_ControlDimension.getControlObject().calculateLabels(this);
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            if (this.m_ControlDimension != null) {
                this.m_ControlDimension.getControlObject().paintLabels(p_Graphics, this);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent p_ListDataEvent) {
            if (p_ListDataEvent == null) {
                return;
            }
            ControlLabelModel.ControlLabelList o_ControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList();
            for (int intDescription = p_ListDataEvent.getIndex0(); intDescription <= p_ListDataEvent.getIndex1(); ++intDescription) {
                ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelModel.getControlLabelDescription(intDescription);
                ControlLabel o_ControlLabel = new ControlLabel();
                o_ControlLabel.setForeground(this.m_Foreground);
                o_ControlLabel.setControlLabelDescription(o_ControlLabelDescription);
                o_ControlLabel.setFont(this.m_LabelsFont);
                this.m_ArrayListLabels.add(intDescription, o_ControlLabel);
                this.add((Component)((Object)o_ControlLabel), o_ControlLabel.getConstraints());
                this.setComponentZOrder((Component)((Object)o_ControlLabel), 0);
            }
            this.calculate();
        }

        @Override
        public void intervalRemoved(ListDataEvent p_ListDataEvent) {
            ControlLabel o_ControlLabel;
            if (p_ListDataEvent == null) {
                return;
            }
            ArrayList<ControlLabel> o_ControlLabels = new ArrayList<ControlLabel>();
            for (int intDescription = p_ListDataEvent.getIndex0(); intDescription <= p_ListDataEvent.getIndex1(); ++intDescription) {
                try {
                    o_ControlLabel = this.m_ArrayListLabels.get(p_ListDataEvent.getIndex0());
                    if (o_ControlLabel == null) continue;
                    o_ControlLabels.add(o_ControlLabel);
                    continue;
                }
                catch (Exception error) {
                    // empty catch block
                }
            }
            for (int intLabel = 0; intLabel < o_ControlLabels.size(); ++intLabel) {
                o_ControlLabel = (ControlLabel)((Object)o_ControlLabels.get(intLabel));
                o_ControlLabel.setVisible(false);
                this.m_ArrayListLabels.remove((Object)o_ControlLabel);
                this.remove((Component)((Object)o_ControlLabel));
            }
            o_ControlLabels.clear();
            this.calculate();
        }

        @Override
        public void contentsChanged(ListDataEvent p_ListDataEvent) {
            if (p_ListDataEvent == null) {
                return;
            }
            for (int intDescription = p_ListDataEvent.getIndex0(); intDescription <= p_ListDataEvent.getIndex1(); ++intDescription) {
                ControlLabel o_ControlLabel;
                try {
                    o_ControlLabel = this.m_ArrayListLabels.get(intDescription);
                }
                catch (Exception error) {
                    continue;
                }
                if (o_ControlLabel == null) continue;
                ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelModel.getControlLabelDescription(intDescription);
                o_ControlLabel.setControlLabelDescription(o_ControlLabelDescription);
            }
            this.calculate();
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }

        public class ControlLabel
        extends JLabelBackground {
            protected ControlLabelModel.ControlLabelDescription m_ControlLabelDescription;
            protected double m_ValueStart;
            protected double m_ValueEnd;
            protected double m_ValueDefault;
            protected String m_Text;
            protected Image m_Image;
            protected boolean m_Visible;
            protected AbsoluteConstraints m_Constraints;

            public ControlLabel() {
                this.initMembers();
            }

            private void initMembers() {
                this.readResolve();
            }

            private Object readResolve() {
                this.initComponents();
                return this;
            }

            private void initComponents() {
                this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
                this.setFont(ControlLabels.this.m_LabelsFont);
                this.setUI((LabelUI)ControlLabels.this.m_RotationLabelUI);
                this.setBackgroundOpaque(false);
                this.setVisible(true);
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ControlLabel.this.setValue(2);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
            }

            public void setValue(int p_Action) {
                double doubleValueDiff = this.m_ValueDefault - ControlLabels.this.m_ControlDimension.getValue();
                if (ControlLabels.this.m_ControlDimension != null) {
                    ControlLabels.this.m_ControlDimension.setValue(this.m_ValueDefault, doubleValueDiff, p_Action);
                }
                ControlLabels.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
            }

            public ControlLabelModel.ControlLabelDescription getControlLabelDescription() {
                return this.m_ControlLabelDescription;
            }

            public void setControlLabelDescription(ControlLabelModel.ControlLabelDescription p_ControlLabelDescription) {
                this.m_ControlLabelDescription = p_ControlLabelDescription;
                this.refresh();
            }

            public void refresh() {
                this.m_ValueStart = this.m_ControlLabelDescription.getValueStart();
                this.m_ValueEnd = this.m_ControlLabelDescription.getValueEnd();
                this.m_ValueDefault = this.m_ControlLabelDescription.getValueDefault();
                this.m_Text = this.m_ControlLabelDescription.getLabelText();
                this.m_Image = this.m_ControlLabelDescription.getLabelImage();
                this.m_Visible = this.m_ControlLabelDescription.getVisible();
                this.setToolTipText(this.m_Text);
                this.setForeground(ControlLabels.this.m_Foreground);
                this.setBackgroundImage(this.m_Image);
                Color o_Color = this.m_ControlLabelDescription.getLabelColor();
                this.setBackground(o_Color);
                if (this.m_Image != null) {
                    this.setText("");
                    this.setBackgroundStyle(2);
                    this.setBackgroundOpaque(true);
                    this.setBorder(ControlLabels.this.m_LabelsBorder);
                } else if (o_Color != null) {
                    this.setText("");
                    this.setBackgroundStyle(0);
                    this.setBackgroundOpaque(true);
                    this.setBorder(ControlLabels.this.m_LabelsBorder);
                } else {
                    if (this.m_Text == null) {
                        this.setText("");
                    } else {
                        this.setText(this.m_Text);
                    }
                    this.setBorder(null);
                    this.setBackgroundStyle(0);
                    this.setBackgroundOpaque(false);
                }
                this.setToolTipText(this.m_Text);
                this.setVisible(this.m_Visible);
                if (!SwingUtilities.isEventDispatchThread()) {
                    EventQueueHandler.invokeLater((Runnable)ControlLabels.this.m_RunnableRepaint);
                } else {
                    this.revalidate();
                    this.repaint();
                }
            }

            public AbsoluteConstraints getConstraints() {
                return this.m_Constraints;
            }
        }
    }

    public static class ControlTicks
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlDimension m_ControlDimension;
        protected boolean m_TicksVisible;
        protected int m_TicksAlignment;
        protected int m_TicksMajorLength;
        protected int m_TicksMinorLength;
        protected boolean m_TicksMirrored;
        protected Insets m_TicksInsets;
        protected double m_TicksMajor;
        protected double m_TicksMinor;
        protected int m_TicksMajorPassCount;
        protected AbsoluteConstraints m_TickConstraints;
        protected ControlTicks m_SelfReference;
        private Runnable m_RunnableRepaint;

        public ControlTicks(ControlDimension p_ControlDimension) {
            this.m_ControlDimension = p_ControlDimension;
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_TicksMinor = 5.0;
            this.m_TicksMinorLength = 5;
            this.m_TicksMajor = 10.0;
            this.m_TicksMajorLength = 10;
            this.m_TicksAlignment = 0;
            this.m_TicksMirrored = false;
            this.m_TicksVisible = true;
            this.m_TicksInsets = new Insets(0, 0, 0, 0);
            this.m_SelfReference = this;
            this.m_TicksMajorPassCount = 1;
            this.m_RunnableRepaint = new Runnable(){

                @Override
                public void run() {
                    this.revalidate();
                    this.repaint();
                }
            };
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeDouble(this.m_TicksMinor);
            p_ObjectOutput.writeInt(this.m_TicksMinorLength);
            p_ObjectOutput.writeDouble(this.m_TicksMajor);
            p_ObjectOutput.writeInt(this.m_TicksMajorLength);
            p_ObjectOutput.writeInt(this.m_TicksAlignment);
            p_ObjectOutput.writeBoolean(this.m_TicksMirrored);
            p_ObjectOutput.writeBoolean(this.m_TicksVisible);
            p_ObjectOutput.writeObject(this.m_TicksInsets);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_TicksMinor = p_ObjectInput.readDouble();
            this.m_TicksMinorLength = p_ObjectInput.readInt();
            this.m_TicksMajor = p_ObjectInput.readDouble();
            this.m_TicksMajorLength = p_ObjectInput.readInt();
            this.m_TicksAlignment = p_ObjectInput.readInt();
            this.m_TicksMirrored = p_ObjectInput.readBoolean();
            this.m_TicksVisible = p_ObjectInput.readBoolean();
            this.m_TicksInsets = (Insets)p_ObjectInput.readObject();
            this.calculate();
        }

        private void initComponents() {
            this.m_TickConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.setOpaque(false);
            this.setVisible(this.m_TicksVisible);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        this.requestFocus();
                        return;
                    }
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        int intDimensionIndex = m_ControlDimension.getDimensionIndex();
                        if (intDimensionIndex > 0) {
                            double doubleValueNew = m_ControlDimension.getControlObject().getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[intDimensionIndex];
                            double doubleValueDiff = doubleValueNew - m_ControlDimension.getValue();
                            m_ControlDimension.setValue(doubleValueNew, doubleValueDiff, 2);
                            m_ControlDimension.getControlObject().setValueManuallyIsReady();
                        }
                        return;
                    }
                }
            });
        }

        public ControlDimension getControlDimension() {
            return this.m_ControlDimension;
        }

        public boolean getTicksVisible() {
            return this.m_TicksVisible;
        }

        public void setTicksVisible(boolean p_TicksVisible) {
            boolean oldValue = this.m_TicksVisible;
            this.m_TicksVisible = p_TicksVisible;
            if (this.m_TicksVisible != oldValue) {
                this.setVisible(this.m_TicksVisible);
                this.firePropertyChange(ControlObject.PROP_TICKSVISIBLE, oldValue, this.m_TicksVisible);
            }
        }

        public double getTicksMajor() {
            return this.m_TicksMajor;
        }

        public void setTicksMajor(double p_TicksMajor) {
            if (p_TicksMajor > this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()) {
                p_TicksMajor = this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum();
            }
            if (p_TicksMajor < 0.0) {
                p_TicksMajor = 0.0;
            }
            double oldValue = this.m_TicksMajor;
            this.m_TicksMajor = p_TicksMajor;
            if (oldValue != this.m_TicksMajor) {
                this.m_ControlDimension.getControlObject().calculateInnerItems();
                this.firePropertyChange(ControlObject.PROP_TICKSMAJOR, oldValue, this.m_TicksMajor);
            }
        }

        public int getTicksMajorPassCount() {
            return this.m_TicksMajorPassCount;
        }

        public void setTicksMajorPassCount(int p_PassCount) {
            if (p_PassCount <= 0) {
                return;
            }
            int oldValue = this.m_TicksMajorPassCount;
            this.m_TicksMajorPassCount = p_PassCount;
            if (oldValue != this.m_TicksMajorPassCount) {
                this.firePropertyChange(ControlObject.PROP_TICKSMAJORPASSCOUNT, oldValue, this.m_TicksMajorPassCount);
                this.m_ControlDimension.recalculateControlLabels();
            }
        }

        public double getTicksMinor() {
            return this.m_TicksMinor;
        }

        public void setTicksMinor(double p_TicksMinor) {
            if (p_TicksMinor > this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()) {
                p_TicksMinor = this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum();
            }
            if (p_TicksMinor < 0.0) {
                p_TicksMinor = 0.0;
            }
            double oldValue = this.m_TicksMinor;
            this.m_TicksMinor = p_TicksMinor;
            if (oldValue != this.m_TicksMinor) {
                this.m_ControlDimension.getControlObject().calculateInnerItems();
                this.firePropertyChange(ControlObject.PROP_TICKSMINOR, oldValue, this.m_TicksMinor);
            }
        }

        public int getTicksAlignment() {
            return this.m_TicksAlignment;
        }

        public void setTicksAlignment(int p_TicksAlignment) {
            if (p_TicksAlignment != 0 && p_TicksAlignment != 2 && p_TicksAlignment != 4 && p_TicksAlignment != 3 && p_TicksAlignment != 1) {
                p_TicksAlignment = 0;
            }
            int oldValue = this.m_TicksAlignment;
            this.m_TicksAlignment = p_TicksAlignment;
            if (oldValue != this.m_TicksAlignment) {
                this.firePropertyChange(ControlObject.PROP_TICKSALIGNMENT, oldValue, this.m_TicksAlignment);
                this.calculate();
            }
        }

        public int getTicksMajorLength() {
            return this.m_TicksMajorLength;
        }

        public void setTicksMajorLength(int p_TicksLength) {
            if (p_TicksLength < 0) {
                p_TicksLength = 0;
            }
            int oldValue = this.m_TicksMajorLength;
            this.m_TicksMajorLength = p_TicksLength;
            if (oldValue != this.m_TicksMajorLength) {
                this.calculate();
                this.firePropertyChange("ticksMajorLength", oldValue, this.m_TicksMajorLength);
            }
        }

        public int getTicksMinorLength() {
            return this.m_TicksMinorLength;
        }

        public void setTicksMinorLength(int p_TicksLength) {
            if (p_TicksLength < 0) {
                p_TicksLength = 0;
            }
            int oldValue = this.m_TicksMinorLength;
            this.m_TicksMinorLength = p_TicksLength;
            if (oldValue != this.m_TicksMinorLength) {
                this.calculate();
                this.firePropertyChange("ticksMajorLength", oldValue, this.m_TicksMinorLength);
            }
        }

        public boolean getTicksMirrored() {
            return this.m_TicksMirrored;
        }

        public void setTicksMirrored(boolean p_TicksMirrored) {
            boolean oldValue = this.m_TicksMirrored;
            this.m_TicksMirrored = p_TicksMirrored;
            if (oldValue != this.m_TicksMirrored) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_TICKSMIRRORED, oldValue, this.m_TicksMirrored);
            }
        }

        public Insets getTicksInsets() {
            return this.m_TicksInsets;
        }

        public void setTicksInsets(Insets p_TicksInsets) {
            Insets oldValue = this.m_TicksInsets;
            this.m_TicksInsets = p_TicksInsets;
            if (!oldValue.equals(this.m_TicksInsets)) {
                this.calculate();
                this.firePropertyChange(ControlObject.PROP_TICKSINSETS, oldValue, this.m_TicksInsets);
            }
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_TickConstraints;
        }

        public void calculate() {
            this.setVisible(this.m_TicksVisible);
            this.m_ControlDimension.getControlObject().calculateTicks(this);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater((Runnable)this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            this.m_ControlDimension.getControlObject().paintTicks(p_Graphics, this);
        }
    }

    public static class ControlDisplayItem
    extends JComponent
    implements ChangeListener,
    PropertyChangeListener,
    Externalizable {
        protected ControlDimension m_ControlDimension;
        protected Object m_SourceObject;
        protected String m_PropertyToListen;
        protected String m_Name;
        protected double m_ValueDisplay;
        protected ControlDisplayItem m_SelfReference;
        protected AbsoluteConstraints m_Contraints;
        protected Runnable m__Runnable_AdjustValueDisplay;
        private Rectangle m_RectArrows;
        private int[] m_XPoints = new int[7];
        private int[] m_YPoints = new int[7];

        public ControlDisplayItem(ControlDimension p_ControlDimension, Object p_SourceObject, String p_PropertyName) {
            this.m_SourceObject = p_SourceObject;
            this.m_ControlDimension = p_ControlDimension;
            this.initMembers();
            this.initComponents();
            this.setListenToProperty(p_PropertyName);
        }

        private void initMembers() {
            this.m_ValueDisplay = 0.0;
            this.m_PropertyToListen = null;
            this.m__Runnable_AdjustValueDisplay = new Runnable(){

                @Override
                public void run() {
                    try {
                        this.doAdjustValueDisplay();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            };
            this.setBorder(null);
            this.m_RectArrows = new Rectangle();
            this.m_XPoints = new int[7];
            this.m_YPoints = new int[7];
            this.readResolve();
        }

        private void initComponents() {
            this.m_Contraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.setToolTipText(null);
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeUTF(this.m_Name);
            p_ObjectOutput.writeUTF(this.m_PropertyToListen);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            this.m_Name = p_ObjectInput.readUTF();
            this.m_PropertyToListen = p_ObjectInput.readUTF();
        }

        public void close() {
            if (this.m_SourceObject != null) {
                this.setListenToProperty(null);
            }
            this.m_SourceObject = null;
        }

        public ControlDimension getControlDimension() {
            return this.m_ControlDimension;
        }

        @Override
        public void setName(String p_Name) {
            super.setName(p_Name);
        }

        public String getListenToProperty() {
            return this.m_PropertyToListen;
        }

        public void setListenToProperty(String p_PropertyName) {
            Method o_Method;
            if (p_PropertyName != null && p_PropertyName.equals(this.m_PropertyToListen)) {
                return;
            }
            if (p_PropertyName == null && this.m_PropertyToListen == null) {
                return;
            }
            if (this.m_PropertyToListen != null && this.m_SourceObject != null) {
                o_Method = null;
                try {
                    o_Method = this.m_SourceObject.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    if (o_Method != null) {
                        o_Method.invoke(this.m_SourceObject, this.m_PropertyToListen, this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.m_PropertyToListen = p_PropertyName;
            if (this.m_SourceObject != null && this.m_PropertyToListen != null && this.m_PropertyToListen.length() > 1) {
                o_Method = null;
                try {
                    o_Method = this.m_SourceObject.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                    if (o_Method != null) {
                        o_Method.invoke(this.m_SourceObject, this.m_PropertyToListen, this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    String stringFirstCharacter = this.m_PropertyToListen.substring(0, 1);
                    stringFirstCharacter = stringFirstCharacter.toUpperCase(Locale.ENGLISH);
                    StringBuffer stringMethodName = new StringBuffer();
                    stringMethodName.append("get");
                    stringMethodName.append(stringFirstCharacter);
                    stringMethodName.append(this.m_PropertyToListen.substring(1, this.m_PropertyToListen.length()));
                    o_Method = this.m_SourceObject.getClass().getDeclaredMethod(stringMethodName.toString(), new Class[0]);
                    if (o_Method != null) {
                        double doubleValue = (Double)o_Method.invoke(this.m_SourceObject, new Object[0]);
                        this.adjustValueDisplay(doubleValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Object getSourceObject() {
            return this.m_SourceObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.m_PropertyToListen == null) {
                return;
            }
            if (this.m_PropertyToListen.equals(evt.getPropertyName())) {
                Object o_NewValue = evt.getNewValue();
                if (!(o_NewValue instanceof Number)) {
                    return;
                }
                this.adjustValueDisplay((Number)o_NewValue);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object o_Source = e.getSource();
            if (o_Source instanceof ControlDisplayInterface) {
                this.adjustValueDisplay(((ControlDisplayInterface)o_Source).getValue());
                return;
            }
            Class<?> o_SourceClass = o_Source.getClass();
            try {
                Method o_MethodGetValue = o_SourceClass.getDeclaredMethod("getValue", new Class[0]);
                this.adjustValueDisplay((Number)o_MethodGetValue.invoke(o_Source, new Object[0]));
            }
            catch (Exception error) {
                return;
            }
        }

        public void adjustValueDisplay(Number p_ValueDisplay) {
            if (this.m_ValueDisplay == p_ValueDisplay.doubleValue()) {
                return;
            }
            this.m_ValueDisplay = p_ValueDisplay.doubleValue();
            EventQueueHandler.invokeLater((Runnable)this.m__Runnable_AdjustValueDisplay);
        }

        private void doAdjustValueDisplay() {
            ControlObject o_ControlObject;
            if (this.m_ControlDimension != null && (o_ControlObject = this.m_ControlDimension.getControlObject()) != null) {
                o_ControlObject.calculateDisplayItem(this);
            }
        }

        public double getValueDisplay() {
            return this.m_ValueDisplay;
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_Contraints;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            Graphics2D g2d = (Graphics2D)p_Graphics;
            this.m_RectArrows = this.getBounds(this.m_RectArrows);
            g2d.setColor(this.getParent().getForeground());
            if (this.m_ControlDimension.getOrientation() == 1) {
                this.m_XPoints[0] = 0;
                this.m_YPoints[0] = 0;
                this.m_XPoints[1] = this.m_RectArrows.height;
                this.m_YPoints[1] = this.m_RectArrows.height / 2;
                this.m_XPoints[2] = 0;
                this.m_YPoints[2] = this.m_RectArrows.height;
                g2d.fillPolygon(this.m_XPoints, this.m_YPoints, 3);
                this.m_XPoints[0] = this.m_RectArrows.width;
                this.m_YPoints[0] = 0;
                this.m_XPoints[1] = this.m_RectArrows.width - this.m_RectArrows.height;
                this.m_YPoints[1] = this.m_RectArrows.height / 2;
                this.m_XPoints[2] = this.m_RectArrows.width;
                this.m_YPoints[2] = this.m_RectArrows.height;
                g2d.fillPolygon(this.m_XPoints, this.m_YPoints, 3);
            } else {
                this.m_XPoints[0] = 0;
                this.m_YPoints[0] = 0;
                this.m_XPoints[1] = this.m_RectArrows.width / 2;
                this.m_YPoints[1] = this.m_RectArrows.width;
                this.m_XPoints[2] = this.m_RectArrows.width;
                this.m_YPoints[2] = 0;
                g2d.fillPolygon(this.m_XPoints, this.m_YPoints, 3);
                this.m_XPoints[0] = 0;
                this.m_YPoints[0] = this.m_RectArrows.height;
                this.m_XPoints[1] = this.m_RectArrows.width / 2;
                this.m_YPoints[1] = this.m_RectArrows.height - this.m_RectArrows.width;
                this.m_XPoints[2] = this.m_RectArrows.width;
                this.m_YPoints[2] = this.m_RectArrows.height;
                g2d.fillPolygon(this.m_XPoints, this.m_YPoints, 3);
            }
            super.paintComponent(p_Graphics);
        }
    }

    public static class ControlDimension
    implements PropertyChangeListener,
    Externalizable {
        protected ControlDimension m_ControlDimensionSelfReference;
        protected ControlObject m_ControlObject;
        protected ControlDimension m_PartnerControlDimension;
        protected boolean m_IsVisibleOnScreen;
        protected double m_Value;
        protected double m_ValueNew;
        protected double m_ValueOld;
        protected double m_ValueLastSet;
        protected double m_ValueAdjusted;
        protected ControlTicks m_ControlTicks;
        protected ControlLabels m_ControlLabels;
        protected ControlBlocks m_ControlBlocks;
        protected ControlBlocks.ControlBlock m_ActiveBlock;
        protected ControlFunctionModel m_ControlFunctionModel;
        protected String m_DimensionName;
        protected int m_Index;
        protected ArrayList<ControlDisplayItem> m_ArrayListDisplayItems;
        protected int m_Orientation;
        protected boolean m_Inverted;
        protected double m_ValueMultiplier;
        protected double m_ValueOffset;
        protected double m_ValueSnapDistance;
        protected double m_ValueMin;
        protected double m_ValueMax;
        protected double m_ValueWheelJump;
        protected double m_ValueMouseMoveFactor;
        protected double m_PixelPerValue;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        protected Runnable m_Runnable_SetValue;
        protected Runnable m_Runnable_AdjustToValue;
        private final Object m_SyncDisplayItems = new Object();
        private final Object m_SyncValue = new Object();
        protected ChangeEvent m_ChangeEvent = null;

        public ControlDimension(ControlObject p_ControlObject, int p_Index) {
            this.m_ControlObject = p_ControlObject;
            this.m_Index = p_Index;
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_PartnerControlDimension = null;
            this.m_Orientation = 1;
            this.m_Inverted = false;
            this.m_ValueMax = 100.0;
            this.m_ValueMin = 0.0;
            this.m_ValueOffset = 0.0;
            this.m_ValueMultiplier = 1.0;
            this.m_ValueSnapDistance = 0.0;
            this.m_ValueWheelJump = 5.0;
            this.m_ValueMouseMoveFactor = 0.1;
            this.m_DimensionName = "Dimension";
            this.m_ControlDimensionSelfReference = this;
            this.m_ArrayListDisplayItems = new ArrayList();
            this.m_ControlDimensionSelfReference = this;
            this.m_IsVisibleOnScreen = false;
            this.m_Value = this.m_ValueMin;
            this.m_ValueOld = this.m_ValueMin;
            this.m_ValueNew = this.m_ValueMin;
            this.m_ValueLastSet = this.m_ValueMin;
            this.m_ValueAdjusted = -1.0;
            this.m_PixelPerValue = 1.0;
            this.m_ControlTicks = new ControlTicks(this);
            this.m_ControlTicks.setForeground(this.m_ControlObject.getForeground());
            this.m_ControlLabels = new ControlLabels(this);
            this.m_ControlLabels.setForeground(this.m_ControlObject.getForeground());
            this.recalculateControlLabels();
            this.m_ControlBlocks = new ControlBlocks(this);
            this.m_ControlBlocks.setForeground(this.m_ControlObject.getForeground());
            this.m_ControlFunctionModel = new ControlFunctionModel(this.m_ValueMin, this.m_ValueMax);
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
            this.m_Runnable_SetValue = new Runnable(){

                @Override
                public void run() {
                    try {
                        this.doSetValue();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            };
            this.m_Runnable_AdjustToValue = new Runnable(){

                @Override
                public void run() {
                    try {
                        this.doAdjustToValue();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            };
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(this.m_Orientation);
            p_ObjectOutput.writeBoolean(this.m_Inverted);
            p_ObjectOutput.writeDouble(this.m_ValueMin);
            p_ObjectOutput.writeDouble(this.m_ValueMax);
            p_ObjectOutput.writeDouble(this.m_ValueOffset);
            p_ObjectOutput.writeDouble(this.m_ValueMultiplier);
            p_ObjectOutput.writeDouble(this.m_ValueSnapDistance);
            p_ObjectOutput.writeDouble(this.m_ValueWheelJump);
            p_ObjectOutput.writeUTF(this.m_DimensionName);
            this.m_ControlTicks.writeExternal(p_ObjectOutput);
            this.m_ControlLabels.writeExternal(p_ObjectOutput);
            this.m_ControlBlocks.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            this.m_Orientation = p_ObjectInput.readInt();
            this.m_Inverted = p_ObjectInput.readBoolean();
            this.m_ValueMin = p_ObjectInput.readDouble();
            this.m_ValueMax = p_ObjectInput.readDouble();
            this.m_ValueOffset = p_ObjectInput.readDouble();
            this.m_ValueMultiplier = p_ObjectInput.readDouble();
            this.m_ValueSnapDistance = p_ObjectInput.readDouble();
            this.m_ValueWheelJump = p_ObjectInput.readDouble();
            this.m_DimensionName = p_ObjectInput.readUTF();
            this.m_ControlTicks.readExternal(p_ObjectInput);
            this.m_ControlLabels.readExternal(p_ObjectInput);
            this.recalculateControlLabels();
            this.m_ControlBlocks.readExternal(p_ObjectInput);
            if (this.m_ControlObject != null) {
                this.m_ControlObject.calculateInnerItems();
            }
        }

        private void initComponents() {
            this.m_ControlObject.add(this.m_ControlTicks, this.m_ControlTicks.getConstraints(), -1);
            this.m_ControlObject.add(this.m_ControlBlocks, this.m_ControlBlocks.getConstraints(), 0);
            this.m_ControlObject.add(this.m_ControlLabels, this.m_ControlLabels.getConstraints(), 0);
        }

        public ControlObject getControlObject() {
            return this.m_ControlObject;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }

        public void setDimensionIndex(int p_Index) {
            this.m_Index = p_Index < 0 ? 0 : p_Index;
            if (this.m_ControlObject != null) {
                this.m_ControlObject.calculateInnerItems();
            }
        }

        public int getDimensionIndex() {
            return this.m_Index;
        }

        public String getDimensionName() {
            return this.m_DimensionName;
        }

        public void setDimensionName(String p_Name) {
            String oldValue = this.m_DimensionName;
            this.m_DimensionName = p_Name == null ? "" : p_Name;
            if (!this.m_DimensionName.equals(oldValue)) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_CONTROLDIMENSIONNAME, (Object)oldValue, (Object)this.m_DimensionName);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_CONTROLDIMENSIONNAME, oldValue, this.m_DimensionName);
                }
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.m_ControlDimensionListModel.changedElement((Object)this);
                }
            }
        }

        public void setPartnerControlDimension(ControlDimension p_PartnerControlDimension) {
            this.m_PartnerControlDimension = p_PartnerControlDimension;
        }

        public ControlDimension getPartnerControlDimension() {
            return this.m_PartnerControlDimension;
        }

        public void fireStateChanged() {
            ChangeListener[] o_Listeners = this.m_ControlObject.getChangeListeners();
            if (this.m_ChangeEvent == null) {
                this.m_ChangeEvent = new ChangeEvent(this);
            }
            for (int i = 0; i < o_Listeners.length; ++i) {
                o_Listeners[i].stateChanged(this.m_ChangeEvent);
            }
        }

        public void fireVetoableStateChanged(PropertyChangeEvent p_PropertyChangeEvent) throws PropertyVetoException {
            if (p_PropertyChangeEvent == null) {
                return;
            }
            VetoableChangeListener[] o_listeners = this.m_ControlObject.getVetoableChangeListeners();
            for (int i = 0; i < o_listeners.length; ++i) {
                if (o_listeners[i] != VetoableChangeListener.class) continue;
                o_listeners[i + 1].vetoableChange(p_PropertyChangeEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlDisplayItem createControlDisplayItem(Object p_SourceObject, String p_PropertyName) {
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                ControlDisplayItem o_ControlDisplayItem;
                for (int intControlDisplayItem = 0; intControlDisplayItem < this.m_ArrayListDisplayItems.size(); ++intControlDisplayItem) {
                    o_ControlDisplayItem = this.m_ArrayListDisplayItems.get(intControlDisplayItem);
                    if (o_ControlDisplayItem == null || o_ControlDisplayItem.getSourceObject() != p_SourceObject || !p_PropertyName.equals(o_ControlDisplayItem.getListenToProperty())) continue;
                    return o_ControlDisplayItem;
                }
                o_ControlDisplayItem = new ControlDisplayItem(this, p_SourceObject, p_PropertyName);
                o_ControlDisplayItem.setVisible(true);
                this.m_ArrayListDisplayItems.add(o_ControlDisplayItem);
                if (this.m_ControlObject != null) {
                    final ControlDisplayItem f_ControlDisplayItem = o_ControlDisplayItem;
                    Runnable o_Runnable = new Runnable(){

                        @Override
                        public void run() {
                            m_ControlObject.add(f_ControlDisplayItem, f_ControlDisplayItem.getConstraints(), 0);
                            m_ControlObject.calculateDisplayItem(f_ControlDisplayItem);
                        }
                    };
                    EventQueueHandler.invokeLater((Runnable)o_Runnable);
                }
                return o_ControlDisplayItem;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlDisplayItem removeControlDisplayItem(final ControlDisplayItem p_ControlDisplayItem) {
            if (p_ControlDisplayItem == null) {
                return null;
            }
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                if (this.m_ArrayListDisplayItems.remove(p_ControlDisplayItem)) {
                    if (this.m_ControlObject != null) {
                        Runnable o_Runnable = new Runnable(){

                            @Override
                            public void run() {
                                p_ControlDisplayItem.setVisible(false);
                                m_ControlObject.remove(p_ControlDisplayItem);
                                m_ControlObject.revalidate();
                                m_ControlObject.repaint();
                            }
                        };
                        EventQueueHandler.invokeLater((Runnable)o_Runnable);
                    }
                    p_ControlDisplayItem.close();
                    return p_ControlDisplayItem;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<ControlDisplayItem> getControlDisplayItems() {
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                return this.m_ArrayListDisplayItems;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getControlDisplayItemsCount() {
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                if (this.m_ArrayListDisplayItems == null) {
                    return 0;
                }
                return this.m_ArrayListDisplayItems.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlDisplayItem getControlDisplayItem(int p_Index) {
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                if (this.m_ArrayListDisplayItems == null || this.m_ArrayListDisplayItems.size() <= 0) {
                    return null;
                }
                if (p_Index < 0 || p_Index >= this.m_ArrayListDisplayItems.size()) {
                    return null;
                }
                return this.m_ArrayListDisplayItems.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlDisplayItem getControlDisplayItem(Object p_SourceObject, String p_ListenToProperty) {
            if (p_SourceObject == null) {
                return null;
            }
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                if (this.m_ArrayListDisplayItems == null || this.m_ArrayListDisplayItems.size() <= 0) {
                    return null;
                }
                for (int intDisplayItem = 0; intDisplayItem < this.m_ArrayListDisplayItems.size(); ++intDisplayItem) {
                    ControlDisplayItem o_ControlDisplayItem = this.m_ArrayListDisplayItems.get(intDisplayItem);
                    if (o_ControlDisplayItem == null || o_ControlDisplayItem.getSourceObject() != p_SourceObject || !o_ControlDisplayItem.getListenToProperty().equals(p_ListenToProperty)) continue;
                    return o_ControlDisplayItem;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateDisplayItems() {
            ArrayList<ControlDisplayItem> o_ControlDisplayItems;
            Object object = this.m_SyncDisplayItems;
            synchronized (object) {
                if (this.m_ArrayListDisplayItems == null || this.m_ArrayListDisplayItems.size() <= 0) {
                    return;
                }
                o_ControlDisplayItems = new ArrayList<ControlDisplayItem>(this.m_ArrayListDisplayItems.size());
                o_ControlDisplayItems.addAll(this.m_ArrayListDisplayItems);
            }
            for (int intDisplayItem = 0; intDisplayItem < o_ControlDisplayItems.size(); ++intDisplayItem) {
                ControlDisplayItem o_ControlDisplayItem = (ControlDisplayItem)o_ControlDisplayItems.get(intDisplayItem);
                if (this.m_ControlObject == null) continue;
                this.m_ControlObject.calculateDisplayItem(o_ControlDisplayItem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustToValue(double p_Value, boolean p_ManuallySet) {
            if (this.m_ControlObject != null && this.m_ControlObject.getControlMaster()) {
                return;
            }
            Object object = this.m_SyncValue;
            synchronized (object) {
                if (this.m_Value == p_Value) {
                    return;
                }
                if (p_Value < this.m_ValueMin) {
                    p_Value = this.m_ValueMin;
                } else if (p_Value > this.m_ValueMax) {
                    p_Value = this.m_ValueMax;
                }
                this.m_ValueOld = this.m_Value;
                this.m_ValueNew = p_Value;
                this.m_Value = p_Value;
            }
            if (!p_ManuallySet) {
                this.m_ValueLastSet = p_Value;
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.refreshControlGroups(this);
                }
            }
            EventQueueHandler.invokeLater((Runnable)this.m_Runnable_AdjustToValue);
        }

        public void setValueAdjusted(double p_ValueAdjusted) {
            this.m_ValueAdjusted = p_ValueAdjusted;
        }

        private void doAdjustToValue() {
            if (this.m_ControlObject != null && this.m_IsVisibleOnScreen && this.m_ValueAdjusted != this.m_Value) {
                this.m_ControlObject.calculateAdjuster();
            }
            if (this.m_ControlObject != null) {
                this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUE, this.m_ValueOld, this.m_Value);
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEADJUSTED, (Object)this.m_ValueOld, (Object)this.m_Value);
            }
        }

        public double getValue() {
            return this.m_Value;
        }

        public double getValueOld() {
            return this.m_ValueOld;
        }

        public void addValue(double p_Difference) {
            if (p_Difference == 0.0) {
                return;
            }
            this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEDDED, (Object)0.0, (Object)p_Difference);
        }

        public int getValuePercent() {
            if (this.m_ValueMax == this.m_ValueMin) {
                return 0;
            }
            int intValuePercent = (int)((this.m_Value - this.m_ValueMin) / (this.m_ValueMax - this.m_ValueMin) * 100.0 + 0.5);
            return intValuePercent;
        }

        public double getValueNormed() {
            double doubleValueNormed = (this.m_Value - this.m_ValueMin) / (this.m_ValueMax - this.m_ValueMin);
            return doubleValueNormed;
        }

        public double getValueNormed(double p_Value) {
            double doubleValueNormed = (p_Value - this.m_ValueMin) / (this.m_ValueMax - this.m_ValueMin);
            return doubleValueNormed;
        }

        public double getValue(double p_ValueNormed) {
            double doubleValue = p_ValueNormed * (this.m_ValueMax - this.m_ValueMin) + this.m_ValueMin;
            return doubleValue;
        }

        public void setValueWithoutFirePropertyChange(double p_Value) {
            this.m_Value = p_Value;
        }

        public void setValue(double p_Value) {
            this.setValue(p_Value, 0.0, 0);
        }

        public void setValue(double p_Value, int p_ActionFlag) {
            this.setValue(p_Value, 0.0, p_ActionFlag);
        }

        public void setValuePercent(int p_ValuePercent, Integer p_ActionFlag) {
            if (this.m_ValueMax == this.m_ValueMin) {
                return;
            }
            double doubleValue = this.m_ValueMin + (this.m_ValueMax - this.m_ValueMin) * ((double)p_ValuePercent / 100.0);
            double doubleValueDiff = doubleValue - this.m_Value;
            if (p_ActionFlag == null) {
                boolean bl = false;
            }
            this.setValue(doubleValue, doubleValueDiff, p_ActionFlag);
        }

        public void setValueNormed(double p_ValueNormed, int p_ActionFlag) {
            if (p_ValueNormed < 0.0) {
                p_ValueNormed = 0.0;
            }
            double doubleValue = this.m_ValueMin + (this.m_ValueMax - this.m_ValueMin) * p_ValueNormed;
            double doubleValueDiff = doubleValue - this.m_Value;
            this.setValue(doubleValue, doubleValueDiff, p_ActionFlag);
        }

        public void setValueWithoutGroups(double p_Value, double p_ValueDiff, int p_ActionFlag) {
            this.setValue(p_Value, p_ValueDiff, p_ActionFlag, false);
        }

        public void setValue(double p_Value, double p_ValueDiff, int p_ActionFlag) {
            this.setValue(p_Value, p_ValueDiff, p_ActionFlag, true);
        }

        public void setVisibleOnScreen(boolean p_IsVisible) {
            if (this.m_IsVisibleOnScreen == p_IsVisible) {
                return;
            }
            this.m_IsVisibleOnScreen = p_IsVisible;
            if (this.m_IsVisibleOnScreen) {
                EventQueueHandler.invokeLater((Runnable)this.m_Runnable_AdjustToValue);
            }
        }

        public void setValue(double p_Value, double p_ValueDiff, int p_ActionFlag, boolean p_SetGroupValues) {
            ControlGroup o_ControlGroup;
            this.m_ValueLastSet = p_Value;
            if (p_ActionFlag == 4 || p_ActionFlag == 2 || p_ActionFlag == 8) {
                for (int intControlGroup = 0; intControlGroup < this.m_ControlObject.getControlGroupCount(); ++intControlGroup) {
                    o_ControlGroup = this.m_ControlObject.getControlGroup(intControlGroup);
                    if (o_ControlGroup == null) continue;
                    o_ControlGroup.checkOverhead(this, p_ValueDiff, p_Value, p_ActionFlag);
                }
            }
            double doubleValue = this.checkSnapping(p_Value);
            if (this.m_ActiveBlock != null && (p_ActionFlag & this.m_ControlObject.getActionsBlocking()) != 0) {
                if (doubleValue < this.m_ActiveBlock.getControlBlockDescription().getValueStart()) {
                    doubleValue = this.m_ActiveBlock.getControlBlockDescription().getValueStart();
                } else if (doubleValue > this.m_ActiveBlock.getControlBlockDescription().getValueEnd()) {
                    doubleValue = this.m_ActiveBlock.getControlBlockDescription().getValueEnd();
                }
            }
            double doubleValueChecked = doubleValue;
            this.m_ValueNew = doubleValue = this.checkSnapping(doubleValueChecked);
            if (p_SetGroupValues && (p_ActionFlag == 4 || p_ActionFlag == 2 || p_ActionFlag == 8)) {
                for (int intControlGroup = 0; intControlGroup < this.m_ControlObject.getControlGroupCount(); ++intControlGroup) {
                    o_ControlGroup = this.m_ControlObject.getControlGroup(intControlGroup);
                    if (o_ControlGroup == null) continue;
                    o_ControlGroup.setGroupValues(this, p_Value);
                }
            }
            if (EventQueue.isDispatchThread()) {
                this.doSetValue();
            } else {
                EventQueueHandler.invokeLater((Runnable)this.m_Runnable_SetValue);
            }
        }

        public void setValue_InputExternal(double p_Value) {
            if (this.m_ValueNew == p_Value) {
                return;
            }
            this.m_ValueNew = p_Value;
            this.doSetValue();
            this.m_ValueLastSet = p_Value;
            if (this.m_ControlObject != null) {
                this.m_ControlObject.refreshControlGroups(this);
            }
            EventQueueHandler.invokeLater((Runnable)this.m_Runnable_AdjustToValue);
        }

        public double getValueLastSet() {
            return this.m_ValueLastSet;
        }

        public double getValueNew() {
            return this.m_ValueNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSetValue() {
            double oldValue = this.m_Value;
            Object object = this.m_SyncValue;
            synchronized (object) {
                if (this.m_Value == this.m_ValueNew) {
                    return;
                }
                this.m_Value = this.m_ValueNew;
                this.m_ActiveBlock = this.findBlock(this.m_Value);
                this.m_ValueOld = oldValue;
            }
            if (this.m_ControlObject != null) {
                this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUE, oldValue, this.m_Value);
                if (this.m_ControlObject.getControlMaster()) {
                    double doubleOldValueFactor = (oldValue - this.m_ValueMin) / (this.m_ValueMax - this.m_ValueMin);
                    double doubleNewValueFactor = (this.m_Value - this.m_ValueMin) / (this.m_ValueMax - this.m_ValueMin);
                    if (this.m_ControlObject.getInvertedSecondary()) {
                        doubleOldValueFactor = 1.0 - doubleOldValueFactor;
                        doubleNewValueFactor = 1.0 - doubleNewValueFactor;
                    }
                    if (this.m_PropertyChangeSupport != null) {
                        this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEFACTOR, (Object)doubleOldValueFactor, (Object)doubleNewValueFactor);
                    }
                } else if (this.m_PropertyChangeSupport != null) {
                    this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUE, (Object)-1.0, (Object)this.m_Value);
                }
            }
            if (oldValue != this.m_Value && this.m_ControlObject != null && this.m_ValueAdjusted != this.m_Value) {
                this.m_ControlObject.calculateAdjuster();
            }
        }

        public int getValueInt() {
            return (int)this.m_Value;
        }

        public void setValueInt(int p_Value, int p_ValueDiff, int p_ActionFlag) {
            this.setValue(p_Value, p_ValueDiff, p_ActionFlag);
        }

        public double getValueTransformed() {
            return this.m_Value * this.m_ValueMultiplier + this.m_ValueOffset;
        }

        public void setValueTransformed(double p_MultipliedValue, int p_ActionFlag) {
            double doubleValueNew = (p_MultipliedValue - this.m_ValueOffset) / this.m_ValueMultiplier;
            this.setValue(doubleValueNew, doubleValueNew - this.m_Value, p_ActionFlag);
        }

        public double calcValueTransformed(double p_Value) {
            return p_Value * this.m_ValueMultiplier + this.m_ValueOffset;
        }

        public double calcValueTransformedReverse(double p_MultipliedValue) {
            return (p_MultipliedValue - this.m_ValueOffset) / this.m_ValueMultiplier;
        }

        public double getValueMultiplier() {
            return this.m_ValueMultiplier;
        }

        public void setValueMultiplier(double p_ValueMultiplier) {
            if (p_ValueMultiplier == 0.0) {
                return;
            }
            double oldValue = this.m_ValueMultiplier;
            this.m_ValueMultiplier = p_ValueMultiplier;
            if (oldValue != this.m_ValueMultiplier) {
                this.fireStateChanged();
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEMULTIPLIER, (Object)oldValue, (Object)this.m_ValueMultiplier);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEMULTIPLIER, oldValue, this.m_ValueMultiplier);
                }
            }
        }

        public double getValueOffset() {
            return this.m_ValueOffset;
        }

        public void setValueOffset(double p_ValueOffset) {
            double oldValue = this.m_ValueOffset;
            this.m_ValueOffset = p_ValueOffset;
            if (oldValue != this.m_ValueOffset) {
                this.fireStateChanged();
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEOFFSET, (Object)oldValue, (Object)this.m_ValueOffset);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEOFFSET, oldValue, this.m_ValueOffset);
                }
            }
        }

        public double checkSnapping(double p_Value) {
            double doubleSnapDistance;
            if (p_Value < this.m_ValueMin) {
                p_Value = this.m_ValueMin;
            }
            if (p_Value > this.m_ValueMax) {
                p_Value = this.m_ValueMax;
            }
            if ((doubleSnapDistance = this.m_ValueSnapDistance > this.m_ValueMax - this.m_ValueMin ? this.m_ValueMax - this.m_ValueMin : this.m_ValueSnapDistance) > 0.0) {
                long intSnapIndex = Math.round((p_Value - this.m_ValueMin) / doubleSnapDistance);
                if ((p_Value = this.m_ValueMin + (double)intSnapIndex * doubleSnapDistance) < this.m_ValueMin) {
                    p_Value += doubleSnapDistance;
                }
                if (p_Value > this.m_ValueMax) {
                    p_Value -= doubleSnapDistance;
                }
            }
            return p_Value;
        }

        public double getSnapDistance() {
            return this.m_ValueSnapDistance;
        }

        public void setSnapDistance(double p_SnapDistance) {
            if (p_SnapDistance < 0.0) {
                p_SnapDistance = 0.0;
            }
            double oldValue = this.m_ValueSnapDistance;
            this.m_ValueSnapDistance = p_SnapDistance;
            if (oldValue != this.m_ValueSnapDistance) {
                this.setValue(this.m_Value, 0.0, 0);
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_SNAPDISTANCE, (Object)oldValue, (Object)this.m_ValueSnapDistance);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_SNAPDISTANCE, oldValue, this.m_ValueSnapDistance);
                }
            }
        }

        public double getSnapDistanceTransformed() {
            return this.calcValueTransformed(this.m_ValueSnapDistance);
        }

        public void setSnapDistanceTransformed(double p_SnapDistanceTransformed) {
            if (p_SnapDistanceTransformed < 0.0) {
                p_SnapDistanceTransformed = 0.0;
            }
            double doubleInsideDistance = p_SnapDistanceTransformed / this.m_ValueMultiplier;
            this.setSnapDistance(doubleInsideDistance);
        }

        public double getValueMaximum() {
            return this.m_ValueMax;
        }

        public void setValueMaximum(double p_Maximum) {
            if (p_Maximum < this.m_ValueMin) {
                this.setValueMinimum(p_Maximum);
                return;
            }
            double oldValue = this.m_ValueMax;
            this.m_ValueMax = p_Maximum;
            if (oldValue != this.m_ValueMax) {
                this.setValue(this.m_Value, 0.0, 0);
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEMAXIMUM, (Object)oldValue, (Object)this.m_ValueMax);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.calculateInnerItems();
                }
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEMAXIMUM, oldValue, this.m_ValueMax);
                }
                if (this.m_ControlLabels.getControlLabelModel() != null) {
                    this.m_ControlLabels.getControlLabelModel().setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                if (this.m_ControlBlocks.getControlBlockModel() != null) {
                    this.m_ControlBlocks.getControlBlockModel().setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                if (this.m_ControlFunctionModel != null) {
                    this.m_ControlFunctionModel.setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                this.recalculateControlLabels();
            }
        }

        public double getValueMinimum() {
            return this.m_ValueMin;
        }

        public void setValueMinimum(double p_Minimum) {
            if (p_Minimum > this.m_ValueMax) {
                this.setValueMaximum(p_Minimum);
                return;
            }
            double oldValue = this.m_ValueMin;
            this.m_ValueMin = p_Minimum;
            this.setValue(this.m_Value, 0.0, 0);
            if (oldValue != this.m_ValueMin) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEMINIMUM, (Object)oldValue, (Object)this.m_ValueMin);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.calculateInnerItems();
                }
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEMINIMUM, oldValue, this.m_ValueMin);
                }
                if (this.m_ControlLabels.getControlLabelModel() != null) {
                    this.m_ControlLabels.getControlLabelModel().setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                if (this.m_ControlBlocks.getControlBlockModel() != null) {
                    this.m_ControlBlocks.getControlBlockModel().setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                if (this.m_ControlFunctionModel != null) {
                    this.m_ControlFunctionModel.setValueRange(this.m_ValueMin, this.m_ValueMax);
                }
                this.recalculateControlLabels();
            }
        }

        public double getMouseWheelStep() {
            return this.m_ValueWheelJump;
        }

        public void setMouseWheelStep(double p_ValueDifference) {
            if (p_ValueDifference > this.m_ValueMax - this.m_ValueMin) {
                p_ValueDifference = this.m_ValueMax - this.m_ValueMin;
            }
            double oldValue = this.m_ValueWheelJump;
            this.m_ValueWheelJump = p_ValueDifference;
            if (oldValue != this.m_ValueWheelJump) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEMOUSEWHEEL, (Object)oldValue, (Object)this.m_ValueWheelJump);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEMOUSEWHEEL, oldValue, this.m_ValueWheelJump);
                }
            }
        }

        public double getMouseMoveFactor() {
            return this.m_ValueMouseMoveFactor;
        }

        public void setMouseMoveFactor(double p_MouseMoveFactor) {
            double oldValue = this.m_ValueMouseMoveFactor;
            if (p_MouseMoveFactor < 0.0) {
                p_MouseMoveFactor = 0.0;
            }
            if (p_MouseMoveFactor > 1.0) {
                p_MouseMoveFactor = 1.0;
            }
            this.m_ValueMouseMoveFactor = p_MouseMoveFactor;
            if (oldValue != this.m_ValueWheelJump) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_VALUEMOUSEMOVEFACTOR, (Object)oldValue, (Object)this.m_ValueMouseMoveFactor);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_VALUEMOUSEMOVEFACTOR, oldValue, this.m_ValueMouseMoveFactor);
                }
            }
        }

        public int getOrientation() {
            return this.m_Orientation;
        }

        public void setOrientation(int p_Orientation) {
            if (p_Orientation != 1 && p_Orientation != 0) {
                return;
            }
            int oldValue = this.m_Orientation;
            this.m_Orientation = p_Orientation;
            if (oldValue != this.m_Orientation) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_ORIENTATION, oldValue, this.m_Orientation);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.calculateInnerItems();
                }
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_ORIENTATION, oldValue, this.m_Orientation);
                }
            }
        }

        public boolean getInverted() {
            return this.m_Inverted;
        }

        public void setInverted(boolean p_Inverted) {
            boolean oldValue = this.m_Inverted;
            this.m_Inverted = p_Inverted;
            if (oldValue != this.m_Inverted) {
                this.m_PropertyChangeSupport.firePropertyChange(ControlObject.PROP_INVERTED, oldValue, this.m_Inverted);
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.calculateInnerItems();
                }
                if (this.m_ControlObject != null) {
                    this.m_ControlObject.firePropertyChange(ControlObject.PROP_INVERTED, oldValue, this.m_Inverted);
                }
            }
        }

        public ControlTicks getControlTicks() {
            return this.m_ControlTicks;
        }

        public boolean getTicksVisible() {
            return this.m_ControlTicks.getTicksVisible();
        }

        public void setTicksVisible(boolean p_TicksVisible) {
            this.m_ControlTicks.setTicksVisible(p_TicksVisible);
        }

        public double getTicksMajor() {
            return this.m_ControlTicks.getTicksMajor();
        }

        public void setTicksMajor(double p_TicksMajor) {
            this.m_ControlTicks.setTicksMajor(p_TicksMajor);
        }

        public double getTicksMinor() {
            return this.m_ControlTicks.getTicksMinor();
        }

        public void setTicksMinor(double p_TicksMinor) {
            this.m_ControlTicks.setTicksMinor(p_TicksMinor);
        }

        public int getTicksAlignment() {
            return this.m_ControlTicks.getTicksAlignment();
        }

        public void setTicksAlignment(int p_TicksAlignment) {
            this.m_ControlTicks.setTicksAlignment(p_TicksAlignment);
        }

        public int getTicksMajorLength() {
            return this.m_ControlTicks.getTicksMajorLength();
        }

        public void setTicksMajorLength(int p_TicksLength) {
            this.m_ControlTicks.setTicksMajorLength(p_TicksLength);
        }

        public int getTicksMinorLength() {
            return this.m_ControlTicks.getTicksMinorLength();
        }

        public void setTicksMinorLength(int p_TicksLength) {
            this.m_ControlTicks.setTicksMinorLength(p_TicksLength);
        }

        public boolean getTicksMirrored() {
            return this.m_ControlTicks.getTicksMirrored();
        }

        public void setTicksMirrored(boolean p_TicksMirrored) {
            this.m_ControlTicks.setTicksMirrored(p_TicksMirrored);
        }

        public Insets getTicksInsets() {
            return this.m_ControlTicks.getTicksInsets();
        }

        public void setTicksInsets(Insets p_TicksInsets) {
            this.m_ControlTicks.setTicksInsets(p_TicksInsets);
        }

        public ControlLabels getControlLabels() {
            return this.m_ControlLabels;
        }

        public ControlLabels.ControlLabel findLabel(double p_Value) {
            if (this.m_ControlLabels == null) {
                return null;
            }
            ControlLabels.ControlLabel o_ControlLabel = null;
            for (int intLabel = 0; intLabel < this.m_ControlLabels.getControlLabelsCount(); ++intLabel) {
                ControlLabelModel.ControlLabelDescription o_ControlLabelDescription;
                o_ControlLabel = this.m_ControlLabels.getControlLabel(intLabel);
                if (o_ControlLabel == null || (o_ControlLabelDescription = o_ControlLabel.getControlLabelDescription()) == null) continue;
                if (o_ControlLabelDescription.getValueStart() <= p_Value && o_ControlLabelDescription.getValueEnd() >= p_Value) break;
                o_ControlLabel = null;
            }
            return o_ControlLabel;
        }

        public boolean getLabelsAutomatic() {
            return this.m_ControlLabels.getLabelsAutomatic();
        }

        public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
            this.m_ControlLabels.setLabelsAutomatic(p_LabelsAutomatic);
        }

        public boolean getLabelsVisible() {
            return this.m_ControlLabels.getLabelsVisible();
        }

        public void setLabelsVisible(boolean p_LabelsVisible) {
            this.m_ControlLabels.setLabelsVisible(p_LabelsVisible);
        }

        public Insets getLabelsInsets() {
            return this.m_ControlLabels.getLabelsInsets();
        }

        public void setLabelsInsets(Insets p_LabelsInsets) {
            this.m_ControlLabels.setLabelsInsets(p_LabelsInsets);
        }

        public int getLabelsAlignment() {
            return this.m_ControlLabels.getLabelsAlignment();
        }

        public void setLabelsAlignment(int p_LabelsAlignment) {
            this.m_ControlLabels.setLabelsAlignment(p_LabelsAlignment);
        }

        public boolean getLabelsMirrored() {
            return this.m_ControlLabels.getLabelsMirrored();
        }

        public void setLabelsMirrored(boolean p_LabelsMirrored) {
            this.m_ControlLabels.setLabelsMirrored(p_LabelsMirrored);
        }

        public Dimension getLabelsSize() {
            return this.m_ControlLabels.getLabelsSize();
        }

        public void setLabelsSize(Dimension p_LabelsSize) {
            this.m_ControlLabels.setLabelsSize(p_LabelsSize);
        }

        public void setLabelsSizeFixed(boolean p_LabelsSizeFixed) {
            this.m_ControlLabels.setLabelsSizeFixed(p_LabelsSizeFixed);
        }

        public boolean getLabelsSizeFixed() {
            return this.m_ControlLabels.getLabelsSizeFixed();
        }

        public Font getLabelsFont() {
            return this.m_ControlLabels.getLabelsFont();
        }

        public void setLabelsFont(Font p_LabelsFont) {
            this.m_ControlLabels.setLabelsFont(p_LabelsFont);
        }

        public void setLabelsTextRotation(double p_Degree) {
            this.m_ControlLabels.setLabelsTextRotation(p_Degree);
        }

        public double getLabelsTextRotation() {
            return this.m_ControlLabels.getLabelsTextRotation();
        }

        public Border getLabelsBorder() {
            return this.m_ControlLabels.getLabelsBorder();
        }

        public void setLabelsBorder(Border p_LabelsBorder) {
            this.m_ControlLabels.setLabelsBorder(p_LabelsBorder);
        }

        public ControlLabelModel getControlLabelModel() {
            return this.m_ControlLabels.getControlLabelModel();
        }

        public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
            this.m_ControlLabels.setControlLabelModel(p_ControlLabelModel);
        }

        public ControlBlocks getControlBlocks() {
            return this.m_ControlBlocks;
        }

        public ControlBlocks.ControlBlock findBlock(double p_Value) {
            if (this.m_ControlBlocks == null) {
                return null;
            }
            ControlBlocks.ControlBlock o_ControlBlocks = null;
            for (int intBlock = 0; intBlock < this.m_ControlBlocks.getControlBlocksCount(); ++intBlock) {
                ControlBlockModel.ControlBlockDescription o_ControlBlockDescription;
                o_ControlBlocks = this.m_ControlBlocks.getControlBlock(intBlock);
                if (o_ControlBlocks == null || (o_ControlBlockDescription = o_ControlBlocks.getControlBlockDescription()) == null) continue;
                if (o_ControlBlockDescription.getValueStart() <= p_Value && o_ControlBlockDescription.getValueEnd() >= p_Value) break;
                o_ControlBlocks = null;
            }
            return o_ControlBlocks;
        }

        public ControlBlocks.ControlBlock getActiveControlBlock() {
            return this.m_ActiveBlock;
        }

        public boolean getBlocksVisible() {
            return this.m_ControlBlocks.getBlocksVisible();
        }

        public void setBlocksVisible(boolean p_LabelsVisible) {
            this.m_ControlBlocks.setBlocksVisible(p_LabelsVisible);
        }

        public Insets getBlocksInsets() {
            return this.m_ControlBlocks.getBlocksInsets();
        }

        public void setBlocksInsets(Insets p_LabelsInsets) {
            this.m_ControlBlocks.setBlocksInsets(p_LabelsInsets);
        }

        public int getBlocksAlignment() {
            return this.m_ControlBlocks.getBlocksAlignment();
        }

        public void setBlocksAlignment(int p_BlocksAlignment) {
            this.m_ControlBlocks.setBlocksAlignment(p_BlocksAlignment);
        }

        public boolean getBlocksMirrored() {
            return this.m_ControlBlocks.getBlocksMirrored();
        }

        public void setBlocksMirrored(boolean p_BlocksMirrored) {
            this.m_ControlBlocks.setBlocksMirrored(p_BlocksMirrored);
        }

        public Dimension getBlocksSize() {
            return this.m_ControlBlocks.getBlocksSize();
        }

        public void setBlocksSize(Dimension p_LabelsSize) {
            this.m_ControlBlocks.setBlocksSize(p_LabelsSize);
        }

        public Font getBlocksFont() {
            return this.m_ControlBlocks.getBlocksFont();
        }

        public void setBlocksFont(Font p_LabelsFont) {
            this.m_ControlBlocks.setBlocksFont(p_LabelsFont);
        }

        public void setBlocksTextRotation(double p_Degree) {
            this.m_ControlBlocks.setBlocksTextRotation(p_Degree);
        }

        public Border getBlocksBorder() {
            return this.m_ControlBlocks.getBlocksBorder();
        }

        public void setBlocksBorder(Border p_LabelsBorder) {
            this.m_ControlBlocks.setBlocksBorder(p_LabelsBorder);
        }

        public ControlBlockModel getControlBlockModel() {
            return this.m_ControlBlocks.getControlBlockModel();
        }

        public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
            this.m_ControlBlocks.setControlBlockModel(p_ControlBlockModel);
        }

        public void recalculateControlLabels() {
            String stringValueMin;
            String stringValueMax;
            if (this.m_ControlLabels == null) {
                return;
            }
            if (!this.m_ControlLabels.getLabelsAutomatic()) {
                return;
            }
            ControlLabelModel o_ControlLabelModel = this.m_ControlLabels.getControlLabelModel();
            if (o_ControlLabelModel == null) {
                return;
            }
            double doubleTicksMajor = this.m_ControlTicks.getTicksMajor();
            int intPassCount = this.m_ControlTicks.getTicksMajorPassCount();
            double doubleValueJump = (double)intPassCount * doubleTicksMajor;
            if (doubleValueJump == (double)((int)doubleValueJump)) {
                stringValueMax = String.valueOf((int)this.m_ValueMax);
                stringValueMin = String.valueOf((int)this.m_ValueMin);
            } else {
                stringValueMax = String.valueOf(this.m_ValueMax);
                stringValueMin = String.valueOf(this.m_ValueMin);
            }
            if (this.m_ControlObject.getFont() != null) {
                int intMaxFontPixelSize = this.getOrientation() == 1 ? this.m_ControlObject.getFontMetrics(this.m_ControlLabels.getLabelsFont()).getHeight() : Math.max(this.m_ControlObject.getFontMetrics(this.m_ControlLabels.getLabelsFont()).stringWidth(stringValueMin), this.m_ControlObject.getFontMetrics(this.m_ControlObject.getFont()).stringWidth(stringValueMax));
                double doubleValueDistance = this.m_ControlObject.calculatePixelPerValueLabel(this);
                if (doubleValueDistance <= 0.0) {
                    return;
                }
                double doubleLabelsDistance = doubleValueJump * doubleValueDistance;
                while ((double)intMaxFontPixelSize > doubleLabelsDistance) {
                    doubleValueJump = (double)(intPassCount *= 2) * doubleTicksMajor;
                    doubleLabelsDistance = doubleValueJump * doubleValueDistance;
                }
            }
            int intLabelsCount = o_ControlLabelModel.getControlLabelDescriptionSize();
            for (int intLabel = intLabelsCount - 1; intLabel >= 0; --intLabel) {
                ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = o_ControlLabelModel.getControlLabelDescription(intLabel);
                if (o_ControlLabelDescription == null) continue;
                o_ControlLabelModel.removeControlLabelDescription(o_ControlLabelDescription);
            }
            int intLabelIndex = 0;
            if (doubleValueJump > 0.0) {
                for (double doubleValue = this.m_ValueMin; doubleValue <= this.m_ValueMax; doubleValue += doubleValueJump) {
                    int intValue = (int)doubleValue;
                    String stringValue = (double)intValue == doubleValue ? String.valueOf(intValue) : String.valueOf(doubleValue);
                    if (intLabelIndex >= o_ControlLabelModel.getControlLabelDescriptionSize()) {
                        ControlLabelModel.ControlLabelDescription controlLabelDescription = o_ControlLabelModel.createControlLabelDescription(doubleValue, doubleValue, (Double)doubleValue, stringValue);
                    }
                    ++intLabelIndex;
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof Number) {
                Number o_Number = (Number)evt.getNewValue();
                this.setValue(o_Number.doubleValue(), 0.0, 0);
            }
        }

        public void setControlFunctionModel(ControlFunctionModel p_ControlFunctionModel) {
            this.m_ControlFunctionModel = p_ControlFunctionModel;
        }

        public ControlFunctionModel getControlFunctionModel() {
            return this.m_ControlFunctionModel;
        }
    }

    protected static class ControlDimensionCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        protected ControlDimensionCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value instanceof ControlDimension) {
                ControlDimension o_ControlDimension = (ControlDimension)value;
                renderer.setText(o_ControlDimension.getDimensionName());
            }
            if (!isSelected) {
                // empty if block
            }
            return renderer;
        }
    }
}

