/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlObjects;

import LiveShowControlObjects.ControlObject;
import LiveShowControls.JControlGrid;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class ControlGroup
implements PropertyChangeListener,
Externalizable {
    public static final int CATEGORY_DEFAULTGROUP = 0;
    public static final int CHANGETYPE_VALUE_SAME = 0;
    public static final Color CHANGECOLOR_VALUE_SAME = Color.WHITE;
    public static final int CHANGETYPE_VALUE_DIFFERENCE = 1;
    public static final Color CHANGECOLOR_VALUE_DIFFERENCE = Color.YELLOW;
    public static final int CHANGETYPE_VALUE_ASSIMILATE = 2;
    public static final Color CHANGECOLOR_VALUE_ASSIMILATE = Color.ORANGE;
    public static final int CHANGETYPE_VALUE_PERCENT = 3;
    public static final Color CHANGECOLOR_VALUE_PERCENT = Color.GREEN;
    protected int m_ChangeType;
    protected boolean m_Active;
    protected Color m_Color;
    protected ControlObject.ControlDimension m_ActorControlDimension;
    protected ArrayList<ControlObject> m_ControlObjects;
    protected ArrayList<ArrayList<Double>> m_StartValues_Normed;
    protected ArrayList<ArrayList<Double>> m_LastValues_Normed;
    protected ArrayList<ArrayList<Double>> m_OverheadValues_Normed;
    protected int m_ControlGroup_Category;
    private final Object m_SyncControlObjects = new Object();

    public ControlGroup() {
        this.initMembers();
    }

    public ControlGroup(int p_Category) {
        this.initMembers();
        this.m_ControlGroup_Category = p_Category;
    }

    public ControlGroup(int p_Category, int p_ChangeType) {
        this.initMembers();
        this.m_ControlGroup_Category = p_Category;
        this.setChangeType(p_ChangeType);
    }

    private void initMembers() {
        this.m_ControlObjects = new ArrayList();
        this.m_ChangeType = 1;
        this.m_Color = Color.RED;
        this.m_Active = true;
        this.m_ActorControlDimension = null;
        this.m_StartValues_Normed = new ArrayList();
        this.m_LastValues_Normed = new ArrayList();
        this.m_OverheadValues_Normed = new ArrayList();
    }

    private Object readResolve() {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(this.m_ChangeType);
        p_ObjectOutput.writeBoolean(this.m_Active);
        ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Color);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        this.m_ChangeType = p_ObjectInput.readInt();
        this.m_Active = p_ObjectInput.readBoolean();
        this.m_Color = ImagesTools.readColor((ObjectInput)p_ObjectInput);
    }

    public void close() {
        this.clearControlObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlObject(ControlObject p_ControlObject) {
        if (p_ControlObject == null) {
            return;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            int intDimension;
            if (this.m_ControlObjects.contains(p_ControlObject)) {
                return;
            }
            p_ControlObject.addControlGroup(this);
            this.m_ControlObjects.add(p_ControlObject);
            ArrayList<Double> o_StartValuesDimensions_Normed = new ArrayList<Double>();
            ArrayList<Double> o_LastValuesDimensions_Normed = new ArrayList<Double>();
            ArrayList<Double> o_OverheadValuesDimensions_Normed = new ArrayList<Double>();
            for (intDimension = 0; intDimension < p_ControlObject.getControlDimensionCount(); ++intDimension) {
                o_StartValuesDimensions_Normed.add(0.0);
                o_LastValuesDimensions_Normed.add(0.0);
                o_OverheadValuesDimensions_Normed.add(0.0);
            }
            this.m_StartValues_Normed.add(o_StartValuesDimensions_Normed);
            this.m_LastValues_Normed.add(o_LastValuesDimensions_Normed);
            this.m_OverheadValues_Normed.add(o_OverheadValuesDimensions_Normed);
            for (intDimension = 0; intDimension < p_ControlObject.getControlDimensionCount(); ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = p_ControlObject.getControlDimension(intDimension);
                if (o_ControlDimension == null) continue;
                double doubleMinValue = o_ControlDimension.getValueMinimum();
                double doubleMaxValue = o_ControlDimension.getValueMaximum();
                double doubleValue = o_ControlDimension.getValue();
                double doubleValueNormed = (doubleValue - doubleMinValue) / (doubleMaxValue - doubleMinValue);
                o_StartValuesDimensions_Normed.set(intDimension, doubleValueNormed);
                o_LastValuesDimensions_Normed.set(intDimension, doubleValueNormed);
                o_OverheadValuesDimensions_Normed.set(intDimension, 0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlObject(ControlObject p_ControlObject) {
        if (p_ControlObject == null) {
            return;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            int intIndex = this.m_ControlObjects.indexOf(p_ControlObject);
            if (intIndex < 0) {
                return;
            }
            p_ControlObject.removeControlGroup(this);
            this.m_ControlObjects.remove(intIndex);
            this.m_StartValues_Normed.remove(intIndex);
            this.m_LastValues_Normed.remove(intIndex);
            this.m_OverheadValues_Normed.remove(intIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearControlObjects() {
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            int intControlObjectsCount = this.m_ControlObjects.size();
            for (int intControl = intControlObjectsCount - 1; intControl >= 0; --intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                this.removeControlObject(o_ControlObject);
            }
            this.m_ControlObjects.clear();
            this.m_StartValues_Normed.clear();
            this.m_LastValues_Normed.clear();
            this.m_OverheadValues_Normed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ControlObject p_ControlObject) {
        int intIndex;
        if (p_ControlObject == null) {
            return false;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            intIndex = this.m_ControlObjects.indexOf(p_ControlObject);
        }
        return intIndex >= 0;
    }

    public int getControlObjectCount() {
        return this.m_ControlObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlObject getControlObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            if (p_Index >= this.m_ControlObjects.size()) {
                return null;
            }
            return this.m_ControlObjects.get(p_Index);
        }
    }

    public boolean getActive() {
        return this.m_Active;
    }

    public void setActive(boolean p_Active) {
        this.m_Active = p_Active;
        this.m_ActorControlDimension = null;
    }

    public void setCategory(int p_Category) {
        this.m_ControlGroup_Category = p_Category;
    }

    public int getCategory() {
        return this.m_ControlGroup_Category;
    }

    public int getChangeType() {
        return this.m_ChangeType;
    }

    public void setChangeType(int p_ChangeType) {
        if (p_ChangeType != 0 && p_ChangeType != 1 && p_ChangeType != 3 && p_ChangeType != 2) {
            return;
        }
        this.m_ChangeType = p_ChangeType;
        switch (this.m_ChangeType) {
            case 0: {
                this.clearOverhead();
                this.setGroupColor(CHANGECOLOR_VALUE_SAME);
                break;
            }
            case 1: {
                this.setGroupColor(CHANGECOLOR_VALUE_DIFFERENCE);
                break;
            }
            case 3: {
                this.setGroupColor(CHANGECOLOR_VALUE_PERCENT);
                break;
            }
            case 2: {
                this.clearOverhead();
                this.setGroupColor(CHANGECOLOR_VALUE_ASSIMILATE);
            }
        }
    }

    public static Color getColorChangeType(int p_ChangeType) {
        switch (p_ChangeType) {
            case 0: {
                return CHANGECOLOR_VALUE_SAME;
            }
            case 1: {
                return CHANGECOLOR_VALUE_DIFFERENCE;
            }
            case 3: {
                return CHANGECOLOR_VALUE_PERCENT;
            }
            case 2: {
                return CHANGECOLOR_VALUE_ASSIMILATE;
            }
        }
        return Color.RED;
    }

    private boolean setActorControlDimension(ControlObject.ControlDimension p_ControlDimension) {
        if (this.m_ActorControlDimension != null) {
            return false;
        }
        this.m_ActorControlDimension = p_ControlDimension;
        return this.m_ActorControlDimension != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshValues(ControlObject.ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            int intObjectIndex = this.m_ControlObjects.indexOf(p_ControlDimension.getControlObject());
            if (intObjectIndex < 0) {
                return;
            }
            for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                if (o_ControlObject == null) continue;
                ArrayList<Double> o_StartPositionsDimensions_Normed = this.m_StartValues_Normed.get(intControl);
                ArrayList<Double> o_LastPositionsDimensions_Normed = this.m_LastValues_Normed.get(intControl);
                ArrayList<Double> o_OverheadValuesDimensions_Normed = this.m_OverheadValues_Normed.get(intControl);
                for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                    double doubleMinValue = o_ControlDimension.getValueMinimum();
                    double doubleMaxValue = o_ControlDimension.getValueMaximum();
                    double doubleValue = o_ControlDimension.getValue();
                    double doubleValueNormed = (doubleValue - doubleMinValue) / (doubleMaxValue - doubleMinValue);
                    o_StartPositionsDimensions_Normed.set(intDimension, doubleValueNormed);
                    o_LastPositionsDimensions_Normed.set(intDimension, doubleValueNormed);
                    o_OverheadValuesDimensions_Normed.set(intDimension, 0.0);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"value".equals(evt.getPropertyName())) {
            return;
        }
        Object o_ActorObject = evt.getSource();
        if (!(o_ActorObject instanceof ControlObject.ControlDimension)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double checkOverhead(ControlObject.ControlDimension p_ActorControlDimension, double p_ValueDiff, double p_ValueNew, int p_ActionFlag) {
        double doubleActorValue;
        if (p_ActorControlDimension == null) {
            return p_ValueNew;
        }
        if (!this.setActorControlDimension(p_ActorControlDimension)) {
            return p_ValueNew;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            ControlObject o_ActorControlObject = p_ActorControlDimension.getControlObject();
            if (o_ActorControlObject == null) {
                return p_ValueNew;
            }
            int intActorControlObjectIndex = this.m_ControlObjects.indexOf(o_ActorControlObject);
            if (intActorControlObjectIndex < 0) {
                return p_ValueNew;
            }
            int intActorControlDimensionIndex = o_ActorControlObject.indexOf(p_ActorControlDimension);
            if (intActorControlDimensionIndex < 0) {
                return p_ValueNew;
            }
            doubleActorValue = p_ValueNew;
            double doubleMinValue = p_ActorControlDimension.getValueMinimum();
            double doubleMaxValue = p_ActorControlDimension.getValueMaximum();
            double doubleActorValueNormed = (doubleActorValue - doubleMinValue) / (doubleMaxValue - doubleMinValue);
            double doubleActorLastValueNormed = this.m_LastValues_Normed.get(intActorControlObjectIndex).get(intActorControlDimensionIndex);
            if (p_ActionFlag == 8) {
                double doubleActorDiffValueNormed = p_ValueDiff / (doubleMaxValue - doubleMinValue);
                doubleActorValueNormed = doubleActorLastValueNormed + doubleActorDiffValueNormed;
            } else {
                double doubleActorOverheadValueNormed = this.m_OverheadValues_Normed.get(intActorControlObjectIndex).get(intActorControlDimensionIndex);
                if (doubleActorOverheadValueNormed > 1.0) {
                    doubleActorValueNormed = doubleActorOverheadValueNormed - 1.0 + doubleActorValueNormed;
                }
                if (doubleActorOverheadValueNormed < 0.0) {
                    doubleActorValueNormed = doubleActorOverheadValueNormed + doubleActorValueNormed;
                }
            }
            if (this.m_ChangeType == 0 || this.m_ChangeType == 2) {
                if (doubleActorValueNormed > 1.0) {
                    doubleActorValueNormed = 1.0;
                } else if (doubleActorValueNormed < 0.0) {
                    doubleActorValueNormed = 0.0;
                }
            }
            this.m_LastValues_Normed.get(intActorControlObjectIndex).set(intActorControlDimensionIndex, doubleActorValueNormed);
            if (p_ActionFlag == 8) {
                this.refreshOverhead();
            }
            doubleActorValue = doubleMinValue + doubleActorValueNormed * (doubleMaxValue - doubleMinValue);
        }
        return doubleActorValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOverhead() {
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                if (o_ControlObject == null) continue;
                for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                    double doubleLastValueNormed = this.m_LastValues_Normed.get(intControl).get(intDimension);
                    this.m_OverheadValues_Normed.get(intControl).set(intDimension, doubleLastValueNormed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOverhead() {
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                if (o_ControlObject == null) continue;
                for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                    this.m_OverheadValues_Normed.get(intControl).set(intDimension, 0.0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupValuesGrid(JControlGrid p_ActorJControlGrid, double p_ValueNewX, double p_ValueNewY) {
        if (p_ActorJControlGrid == null) {
            return;
        }
        if (p_ActorJControlGrid.getControlDimension(0) == null) {
            return;
        }
        if (p_ActorJControlGrid.getControlDimension(1) == null) {
            return;
        }
        if (!this.m_Active) {
            this.refreshValues(p_ActorJControlGrid.getControlDimension(0));
            this.refreshValues(p_ActorJControlGrid.getControlDimension(1));
            return;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            int intActorControlObjectIndex = this.m_ControlObjects.indexOf(p_ActorJControlGrid);
            if (intActorControlObjectIndex < 0) {
                return;
            }
            double doubleMinValue = p_ActorJControlGrid.getControlDimension(0).getValueMinimum();
            double doubleMaxValue = p_ActorJControlGrid.getControlDimension(0).getValueMaximum();
            double doubleActorValueNormed_X = (p_ValueNewX - doubleMinValue) / (doubleMaxValue - doubleMinValue);
            double doubleActorStartValueNormed_X = this.m_StartValues_Normed.get(intActorControlObjectIndex).get(0);
            double doubleActorDiffValueNormed_X = doubleActorValueNormed_X - doubleActorStartValueNormed_X;
            if (doubleActorStartValueNormed_X == 0.0) {
                doubleActorStartValueNormed_X = 1.0 / (doubleMaxValue - doubleMinValue);
            }
            double doubleActorPercentValueNormed_X = (doubleActorValueNormed_X - doubleActorStartValueNormed_X) / doubleActorStartValueNormed_X;
            doubleMinValue = p_ActorJControlGrid.getControlDimension(1).getValueMinimum();
            doubleMaxValue = p_ActorJControlGrid.getControlDimension(1).getValueMaximum();
            double doubleActorValueNormed_Y = (p_ValueNewY - doubleMinValue) / (doubleMaxValue - doubleMinValue);
            double doubleActorStartValueNormed_Y = this.m_StartValues_Normed.get(intActorControlObjectIndex).get(1);
            double doubleActorDiffValueNormed_Y = doubleActorValueNormed_Y - doubleActorStartValueNormed_Y;
            if (doubleActorStartValueNormed_Y == 0.0) {
                doubleActorStartValueNormed_Y = 1.0 / (doubleMaxValue - doubleMinValue);
            }
            double doubleActorPercentValueNormed_Y = (doubleActorValueNormed_Y - doubleActorStartValueNormed_Y) / doubleActorStartValueNormed_Y;
            for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                if (o_ControlObject == null || o_ControlObject == p_ActorJControlGrid || !(o_ControlObject instanceof JControlGrid)) continue;
                JControlGrid o_JControlGrid = (JControlGrid)o_ControlObject;
                o_JControlGrid.setGridAreas_AdjusterInsidefromOtherControl(p_ActorJControlGrid.getGridAreas_AdjusterInside());
                this.calculateGroupValue(o_JControlGrid, intControl, 0, doubleActorStartValueNormed_X, doubleActorValueNormed_X, doubleActorDiffValueNormed_X, doubleActorPercentValueNormed_X);
                this.calculateGroupValue(o_JControlGrid, intControl, 1, doubleActorStartValueNormed_Y, doubleActorValueNormed_Y, doubleActorDiffValueNormed_Y, doubleActorPercentValueNormed_Y);
                o_JControlGrid.setValueManuallyIsReady();
            }
            this.m_ActorControlDimension = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupValues(ControlObject.ControlDimension p_ActorControlDimension, double p_ValueNew) {
        if (p_ActorControlDimension == null) {
            return;
        }
        if (!this.m_Active) {
            this.refreshValues(p_ActorControlDimension);
            return;
        }
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            ControlObject.ControlDimension o_ActorControlDimension = this.m_ActorControlDimension;
            if (o_ActorControlDimension == null) {
                return;
            }
            ControlObject o_ActorControlObject = o_ActorControlDimension.getControlObject();
            int intActorControlObjectIndex = this.m_ControlObjects.indexOf(o_ActorControlObject);
            if (intActorControlObjectIndex < 0) {
                return;
            }
            int intActorControlDimensionIndex = o_ActorControlObject.indexOf(o_ActorControlDimension);
            if (intActorControlDimensionIndex < 0) {
                return;
            }
            double doubleActorValue = p_ValueNew;
            double doubleMinValue = p_ActorControlDimension.getValueMinimum();
            double doubleMaxValue = p_ActorControlDimension.getValueMaximum();
            double doubleActorValueNormed = (doubleActorValue - doubleMinValue) / (doubleMaxValue - doubleMinValue);
            double doubleActorStartValueNormed = this.m_StartValues_Normed.get(intActorControlObjectIndex).get(intActorControlDimensionIndex);
            double doubleActorDiffValueNormed = doubleActorValueNormed - doubleActorStartValueNormed;
            if (doubleActorStartValueNormed == 0.0) {
                doubleActorStartValueNormed = 1.0 / (doubleMaxValue - doubleMinValue);
            }
            double doubleActorPercentValueNormed = (doubleActorValueNormed - doubleActorStartValueNormed) / doubleActorStartValueNormed;
            for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
                if (o_ControlObject == null || o_ControlObject == o_ActorControlObject) continue;
                this.calculateGroupValue(o_ControlObject, intControl, intActorControlDimensionIndex, doubleActorStartValueNormed, doubleActorValueNormed, doubleActorDiffValueNormed, doubleActorPercentValueNormed);
                o_ControlObject.setValueManuallyIsReady();
            }
            this.m_ActorControlDimension = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateGroupValue(ControlObject p_ControlObject, int p_ControlIndex, int p_ActorControlDimensionIndex, double p_ActorStartValueNormed, double p_ActorValueNormed, double p_ActorDiffValueNormed, double p_ActorPercentValueNormed) {
        Object object = this.m_SyncControlObjects;
        synchronized (object) {
            double doubleValueNewNormed;
            ControlObject.ControlDimension o_ControlDimension = p_ControlObject.getControlDimension(p_ActorControlDimensionIndex);
            if (o_ControlDimension == null) {
                return;
            }
            double doubleMinValue = o_ControlDimension.getValueMinimum();
            double doubleMaxValue = o_ControlDimension.getValueMaximum();
            switch (this.m_ChangeType) {
                case 0: {
                    doubleValueNewNormed = p_ActorValueNormed;
                    double doubleValueNew = doubleMinValue + doubleValueNewNormed * (doubleMaxValue - doubleMinValue);
                    o_ControlDimension.setValueWithoutGroups(doubleValueNew, 0.0, 16);
                    break;
                }
                case 1: {
                    double doubleValueStartNormed = this.m_StartValues_Normed.get(p_ControlIndex).get(p_ActorControlDimensionIndex);
                    doubleValueNewNormed = doubleValueStartNormed + p_ActorDiffValueNormed;
                    double doubleValueNew = doubleMinValue + doubleValueNewNormed * (doubleMaxValue - doubleMinValue);
                    o_ControlDimension.setValueWithoutGroups(doubleValueNew, 0.0, 16);
                    break;
                }
                case 2: {
                    double doubleValueStartNormed = this.m_StartValues_Normed.get(p_ControlIndex).get(p_ActorControlDimensionIndex);
                    doubleValueNewNormed = p_ActorValueNormed >= p_ActorStartValueNormed ? (p_ActorStartValueNormed >= 1.0 ? 1.0 : doubleValueStartNormed + (1.0 - doubleValueStartNormed) / (1.0 - p_ActorStartValueNormed) * (p_ActorValueNormed - p_ActorStartValueNormed)) : (p_ActorStartValueNormed <= 0.0 ? 0.0 : doubleValueStartNormed + doubleValueStartNormed / p_ActorStartValueNormed * (p_ActorValueNormed - p_ActorStartValueNormed));
                    double doubleValueNew = doubleMinValue + doubleValueNewNormed * (doubleMaxValue - doubleMinValue);
                    o_ControlDimension.setValueWithoutGroups(doubleValueNew, 0.0, 16);
                    break;
                }
                case 3: {
                    double doubleValueStartNormed = this.m_StartValues_Normed.get(p_ControlIndex).get(p_ActorControlDimensionIndex);
                    doubleValueNewNormed = doubleValueStartNormed + doubleValueStartNormed * p_ActorPercentValueNormed;
                    double doubleValueNew = doubleMinValue + doubleValueNewNormed * (doubleMaxValue - doubleMinValue);
                    o_ControlDimension.setValueWithoutGroups(doubleValueNew, 0.0, 16);
                    break;
                }
                default: {
                    return;
                }
            }
            this.m_LastValues_Normed.get(p_ControlIndex).set(p_ActorControlDimensionIndex, doubleValueNewNormed);
        }
    }

    public Color getGroupColor() {
        return this.m_Color;
    }

    public void setGroupColor(Color p_Color) {
        this.m_Color = p_Color;
    }

    public void paintGroup(ControlObject p_ControlObject, Graphics p_Graphics, Rectangle p_RectInsideControl, int p_Deepth) {
        p_Graphics.setColor(this.m_Color);
        Rectangle rectGroup = new Rectangle(p_RectInsideControl);
        rectGroup.x = p_Deepth * 2;
        rectGroup.y = p_Deepth * 2;
        rectGroup.width = rectGroup.width - p_Deepth * 4 - 1;
        rectGroup.height = rectGroup.height - p_Deepth * 4 - 1;
        p_Graphics.drawRect(rectGroup.x, rectGroup.x, rectGroup.width, rectGroup.height);
    }

    public static class ControlGroupSet {
        private Object m_MembershipObject;
        private ArrayList<ControlGroup> m_ControlGroups;
        private final Object m_SyncControlGroups = new Object();

        public ControlGroupSet() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ControlGroups = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                for (int intGroup = this.m_ControlGroups.size() - 1; intGroup >= 0; --intGroup) {
                    ControlGroup o_ControlGroup = this.m_ControlGroups.get(intGroup);
                    if (o_ControlGroup == null) continue;
                    o_ControlGroup.close();
                    this.m_ControlGroups.remove(o_ControlGroup);
                }
                this.m_MembershipObject = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearControlGroups() {
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                for (int intGroup = this.m_ControlGroups.size() - 1; intGroup >= 0; --intGroup) {
                    ControlGroup o_ControlGroup = this.m_ControlGroups.get(intGroup);
                    if (o_ControlGroup == null) continue;
                    o_ControlGroup.clearControlObjects();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addControlGroup(ControlGroup p_ControlGroup) {
            if (p_ControlGroup == null) {
                return;
            }
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                if (this.m_ControlGroups.contains(p_ControlGroup)) {
                    return;
                }
                this.m_ControlGroups.add(p_ControlGroup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeonlyControlGroup(ControlGroup p_ControlGroup) {
            if (p_ControlGroup == null) {
                return;
            }
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                this.m_ControlGroups.remove(p_ControlGroup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeControlGroup(ControlGroup p_ControlGroup) {
            if (p_ControlGroup == null) {
                return;
            }
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                this.m_ControlGroups.remove(p_ControlGroup);
                p_ControlGroup.close();
            }
        }

        public int getControlGroupCount() {
            return this.m_ControlGroups.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlGroup getControlGroup(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncControlGroups;
            synchronized (object) {
                if (p_Index >= this.m_ControlGroups.size()) {
                    return null;
                }
                return this.m_ControlGroups.get(p_Index);
            }
        }

        public void setMembershipObject(Object p_Membership) {
            this.m_MembershipObject = p_Membership;
        }

        public Object getMembershipObject() {
            return this.m_MembershipObject;
        }
    }
}

