/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import SwingTextPackage.DocumentFilter_Double;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JTextFieldBytePanel
extends JPanel {
    public static final String PROP_VALUECHANGED = "valueChanged";
    @LiveLanguageString
    public static String s_ToolTipText = "value of high byte";
    @LiveLanguageString
    public static String s_Percent_ToolTipText = "value of high byte";
    @LiveLanguageString
    public static String s_Total_ToolTipText = "value of high byte";
    @LiveLanguageString
    public static String s_ByteHigh_ToolTipText = "value of high byte";
    @LiveLanguageString
    public static String s_ByteLow_ToolTipText = "value of low byte";
    private Object m_ValueSourceObject;
    private String m_LabelString;
    private double m_MinValue;
    private double m_MaxValue;
    private double m_ValueRange;
    private double m_Value;
    private double m_ValuePercent;
    private boolean m_ValuePercentManuallyChanged;
    private int m_ByteCount;
    private boolean m_OnlyInteger;
    private ArrayList<JTextField> m_TextFields_Byte;
    private ArrayList<Double> m_ByteValues;
    private Insets m_Insets;
    private Dimension m_Dimension;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncListeners = new Object();
    private JLabel jLabel_Name;
    private JTextField jTextField_Percent;
    private JTextField jTextField_Total;

    public JTextFieldBytePanel() {
        this.initMembers();
        this.initComponents();
        LiveLanguage.addLanguageListener(this, null);
        this.initComponentsFurther();
        this.setValueRange(0.0, 0.0);
    }

    public JTextFieldBytePanel(double p_MinValue, double p_MaxValue, boolean p_OnlyInteger) {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.setValueRange(p_MinValue, p_MaxValue);
    }

    private void initMembers() {
        this.m_TextFields_Byte = new ArrayList();
        this.m_ByteValues = new ArrayList();
        this.m_Insets = new Insets(3, 3, 3, 3);
        this.m_Dimension = new Dimension(40, 20);
        this.m_OnlyInteger = false;
        if (this.m_PropertyChangeSupport == null) {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        }
    }

    public void setValueSourceObject(Object p_Object) {
        this.m_ValueSourceObject = p_Object;
    }

    public Object getValueSourceObject() {
        return this.m_ValueSourceObject;
    }

    public void setLabelString(String p_LabelString) {
        if (p_LabelString == null || p_LabelString.length() <= 0) {
            this.jLabel_Name.setVisible(false);
        }
        this.jLabel_Name.setText(p_LabelString);
        this.jLabel_Name.setVisible(true);
    }

    private void initComponentsFurther() {
        this.setOpaque(false);
        this.setToolTipText(s_ToolTipText);
        this.jLabel_Name.setVisible(false);
        this.jTextField_Total.setToolTipText(s_Total_ToolTipText);
        this.jTextField_Total.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    double doubleValue;
                    double oldValue = JTextFieldBytePanel.this.m_Value;
                    try {
                        doubleValue = Double.valueOf(JTextFieldBytePanel.this.jTextField_Total.getText());
                    }
                    catch (Exception eDouble) {
                        doubleValue = 0.0;
                    }
                    JTextFieldBytePanel.this.setValue(doubleValue);
                    if (JTextFieldBytePanel.this.m_PropertyChangeSupport != null) {
                        JTextFieldBytePanel.this.m_PropertyChangeSupport.firePropertyChange(JTextFieldBytePanel.PROP_VALUECHANGED, (Object)oldValue, (Object)JTextFieldBytePanel.this.m_Value);
                    }
                }
            }
        });
        this.jTextField_Total.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                double doubleValue;
                double oldValue = JTextFieldBytePanel.this.m_Value;
                try {
                    doubleValue = Double.valueOf(JTextFieldBytePanel.this.jTextField_Total.getText());
                }
                catch (Exception eDouble) {
                    doubleValue = 0.0;
                }
                JTextFieldBytePanel.this.setValue(doubleValue);
                if (JTextFieldBytePanel.this.m_PropertyChangeSupport != null) {
                    JTextFieldBytePanel.this.m_PropertyChangeSupport.firePropertyChange(JTextFieldBytePanel.PROP_VALUECHANGED, (Object)oldValue, (Object)JTextFieldBytePanel.this.m_Value);
                }
            }
        });
        this.jTextField_Percent.setToolTipText(s_Percent_ToolTipText);
        this.jTextField_Percent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    double doubleValue;
                    if (!JTextFieldBytePanel.this.m_ValuePercentManuallyChanged) {
                        return;
                    }
                    double oldValue = JTextFieldBytePanel.this.m_Value;
                    try {
                        doubleValue = Double.valueOf(JTextFieldBytePanel.this.jTextField_Percent.getText());
                        if (doubleValue < 0.0) {
                            doubleValue = 0.0;
                        }
                        if (doubleValue > 100.0) {
                            doubleValue = 100.0;
                        }
                        doubleValue = JTextFieldBytePanel.this.m_MinValue + JTextFieldBytePanel.this.m_ValueRange * (doubleValue / 100.0);
                    }
                    catch (Exception eDouble) {
                        doubleValue = 0.0;
                    }
                    JTextFieldBytePanel.this.setValue(doubleValue);
                    if (JTextFieldBytePanel.this.m_PropertyChangeSupport != null) {
                        JTextFieldBytePanel.this.m_PropertyChangeSupport.firePropertyChange(JTextFieldBytePanel.PROP_VALUECHANGED, (Object)oldValue, (Object)JTextFieldBytePanel.this.m_Value);
                    }
                } else {
                    JTextFieldBytePanel.this.m_ValuePercentManuallyChanged = true;
                }
            }
        });
        this.jTextField_Percent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                double doubleValue;
                if (!JTextFieldBytePanel.this.m_ValuePercentManuallyChanged) {
                    return;
                }
                double oldValue = JTextFieldBytePanel.this.m_Value;
                try {
                    doubleValue = Double.valueOf(JTextFieldBytePanel.this.jTextField_Percent.getText());
                    if (doubleValue < 0.0) {
                        doubleValue = 0.0;
                    }
                    if (doubleValue > 100.0) {
                        doubleValue = 100.0;
                    }
                    doubleValue = JTextFieldBytePanel.this.m_MinValue + JTextFieldBytePanel.this.m_ValueRange * (doubleValue / 100.0);
                }
                catch (Exception eDouble) {
                    doubleValue = 0.0;
                }
                JTextFieldBytePanel.this.setValue(doubleValue);
                if (JTextFieldBytePanel.this.m_PropertyChangeSupport != null) {
                    JTextFieldBytePanel.this.m_PropertyChangeSupport.firePropertyChange(JTextFieldBytePanel.PROP_VALUECHANGED, (Object)oldValue, (Object)JTextFieldBytePanel.this.m_Value);
                }
            }
        });
        this.jTextField_Percent.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_Total.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.jTextField_Total = new JTextField();
        this.jLabel_Name = new JLabel();
        this.jTextField_Percent = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jTextField_Total.setBackground(new Color(130, 0, 0));
        this.jTextField_Total.setHorizontalAlignment(0);
        this.jTextField_Total.setText("jTextField1");
        this.jTextField_Total.setMinimumSize(new Dimension(60, 20));
        this.jTextField_Total.setPreferredSize(new Dimension(60, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Total, gridBagConstraints);
        this.jLabel_Name.setHorizontalAlignment(4);
        this.jLabel_Name.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jTextField_Percent.setBackground(new Color(0, 130, 0));
        this.jTextField_Percent.setHorizontalAlignment(0);
        this.jTextField_Percent.setText("jTextField1");
        this.jTextField_Percent.setMinimumSize(new Dimension(40, 20));
        this.jTextField_Percent.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Percent, gridBagConstraints);
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        this.m_OnlyInteger = p_OnlyIntegerValues;
        if (this.m_OnlyInteger) {
            DocumentFilter_Integer documentFilter_Integer = new DocumentFilter_Integer((JTextComponent)this.jTextField_Total);
        } else {
            DocumentFilter_Double documentFilter_Double = new DocumentFilter_Double((JTextComponent)this.jTextField_Total);
        }
        this.calculateTextFields();
    }

    public void setValueRange(double p_MinValue, double p_MaxValue) {
        this.m_MaxValue = p_MaxValue;
        this.m_MinValue = p_MinValue;
        if (this.m_OnlyInteger) {
            this.m_MaxValue = (int)this.m_MaxValue;
            this.m_MinValue = (int)this.m_MinValue;
        }
        this.m_ValueRange = this.m_MaxValue - this.m_MinValue;
        this.m_Value = this.m_MinValue;
        this.m_ValuePercent = 0.0;
        this.calculateTextFields();
    }

    private void calculateTextFields() {
        if (!this.m_OnlyInteger) {
            this.m_ByteCount = 0;
        } else {
            int intByteCount = 1;
            for (double doubleValueMax = Math.max(Math.abs(this.m_MaxValue), Math.abs(this.m_MinValue)); doubleValueMax >= 256.0; doubleValueMax /= 256.0) {
                ++intByteCount;
            }
            this.m_ByteCount = intByteCount;
        }
        if (this.m_ByteCount < this.m_TextFields_Byte.size()) {
            for (int intByte = this.m_TextFields_Byte.size() - 1; intByte >= this.m_ByteCount; --intByte) {
                JTextField o_TextField = this.m_TextFields_Byte.get(intByte);
                if (o_TextField == null) continue;
                o_TextField.setVisible(false);
                this.remove(o_TextField);
                o_TextField.setToolTipText(null);
                o_TextField.setComponentPopupMenu(null);
                this.m_TextFields_Byte.remove(o_TextField);
                this.m_ByteValues.remove(intByte);
            }
        } else if (this.m_ByteCount > this.m_TextFields_Byte.size()) {
            for (int intByte = this.m_TextFields_Byte.size(); intByte < this.m_ByteCount; ++intByte) {
                JTextField o_TextField = new JTextField();
                o_TextField.setHorizontalAlignment(0);
                o_TextField.setMinimumSize(this.m_Dimension);
                o_TextField.setPreferredSize(this.m_Dimension);
                if (intByte == 0) {
                    o_TextField.setBackground(Color.DARK_GRAY);
                    o_TextField.setToolTipText(s_ByteHigh_ToolTipText);
                } else if (intByte == this.m_ByteCount - 1) {
                    o_TextField.setBackground(new Color(130, 130, 0));
                    o_TextField.setToolTipText(s_ByteLow_ToolTipText);
                }
                o_TextField.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
                DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer((JTextComponent)o_TextField);
                o_TextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            JTextFieldBytePanel.this.calculateValue();
                        }
                    }
                });
                o_TextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        JTextFieldBytePanel.this.calculateValue();
                    }
                });
                GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                o_GridBagConstraints.gridx = intByte + 3;
                o_GridBagConstraints.gridy = 0;
                o_GridBagConstraints.insets = this.m_Insets;
                o_GridBagConstraints.fill = 2;
                o_GridBagConstraints.weightx = 1.0;
                this.add((Component)o_TextField, o_GridBagConstraints);
                this.m_TextFields_Byte.add(o_TextField);
                this.m_ByteValues.add(0.0);
                o_TextField.setEnabled(this.isEnabled());
            }
        }
        this.setValue(this.m_Value);
        this.revalidate();
    }

    public void setValue(double p_Value) {
        if (p_Value > this.m_MaxValue) {
            p_Value = this.m_MaxValue;
        }
        if (p_Value < this.m_MinValue) {
            p_Value = this.m_MinValue;
        }
        this.m_Value = p_Value;
        this.m_ValuePercent = this.m_ValueRange == 0.0 ? 0.0 : (this.m_Value - this.m_MinValue) / this.m_ValueRange;
        if (!this.m_OnlyInteger) {
            this.jTextField_Total.setText(String.valueOf(this.m_Value));
            this.jTextField_Percent.setText(String.valueOf((int)this.m_ValuePercent));
            return;
        }
        double doubleValue = this.m_Value;
        for (int intByte = this.m_ByteCount - 1; intByte >= 0; --intByte) {
            double doubleByteValue = doubleValue - (double)((int)(doubleValue / 256.0) * 256);
            doubleValue = (int)(doubleValue / 256.0);
            JTextField o_JTextField = this.m_TextFields_Byte.get(intByte);
            this.m_ByteValues.set(intByte, Double.valueOf((int)doubleByteValue));
            o_JTextField.setText(String.valueOf((int)doubleByteValue));
        }
        this.jTextField_Percent.setText(String.valueOf((int)(this.m_ValuePercent * 100.0 + 0.5)));
        if (this.m_OnlyInteger) {
            this.jTextField_Total.setText(String.valueOf((int)this.m_Value));
        } else {
            this.jTextField_Total.setText(String.valueOf(this.m_Value));
        }
        this.m_ValuePercentManuallyChanged = false;
    }

    public double getValue() {
        return this.m_Value;
    }

    public double getValue(int p_ByteIndex) {
        if (p_ByteIndex < 0 || p_ByteIndex >= this.m_ByteValues.size()) {
            return 0.0;
        }
        return this.m_ByteValues.get(p_ByteIndex);
    }

    private void calculateValue() {
        double oldValue = this.m_Value;
        if (!this.m_OnlyInteger) {
            try {
                this.m_Value = Double.valueOf(this.jTextField_Total.getText());
            }
            catch (Exception e) {
                this.m_Value = 0.0;
            }
        } else {
            double doubleValue = 0.0;
            for (int intByte = 0; intByte < this.m_ByteCount; ++intByte) {
                double doubleValueAdd;
                doubleValue *= 256.0;
                JTextField o_TextField = this.m_TextFields_Byte.get(intByte);
                if (o_TextField == null) continue;
                try {
                    doubleValueAdd = Integer.valueOf(o_TextField.getText()).intValue();
                }
                catch (Exception e) {
                    doubleValueAdd = 0.0;
                }
                doubleValue += doubleValueAdd;
            }
            if (doubleValue > this.m_MaxValue) {
                doubleValue = this.m_MaxValue;
            }
            if (doubleValue < this.m_MinValue) {
                doubleValue = this.m_MinValue;
            }
            this.setValue(doubleValue);
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_VALUECHANGED, (Object)oldValue, (Object)this.m_Value);
        }
    }

    @Override
    public void setEnabled(boolean p_Enabled) {
        super.setEnabled(p_Enabled);
        this.jTextField_Percent.setEnabled(p_Enabled);
        this.jTextField_Total.setEnabled(p_Enabled);
        for (int intTextField = 0; intTextField < this.m_TextFields_Byte.size(); ++intTextField) {
            JTextField o_TextField = this.m_TextFields_Byte.get(intTextField);
            if (o_TextField == null) continue;
            o_TextField.setEnabled(p_Enabled);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport == null) {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport == null) {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }
}

