/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlModels.JControlSettings_Dimension;
import LiveShowControlModels.JTextFieldBytePanel;
import LiveShowControlObjects.ControlObject;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JControlSettings_LabelModel
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_CONTROLOBJECT = "jcontrolsettings_dimension_Object";
    public static final String PROP_CONTROLDIMENSION = "jcontrolsettings_dimension_Dimension";
    @LiveLanguageString
    public static String LOADIMAGE = "Load image";
    public static double s_DefaultEndValue = 0.0;
    public static double s_DefaultValue = 0.0;
    public static double s_DefaultStartValue = 0.0;
    protected JControlSettings_Dimension m_ControlSettings_Dimension;
    protected ControlObject m_ControlObject;
    protected ControlObject.ControlDimension m_SelectedControlDimension;
    protected ControlLabelModel m_ControlLabelModel;
    protected ControlLabelModel.ControlLabelList m_SelectedControlLabelList;
    protected ControlLabelModel.ControlLabelDescription m_SelectedLabelDescription;
    protected Color m_LabelColor;
    protected Image m_LabelImage;
    protected boolean m_OnlyInteger;
    protected ArrayList<ArrayList<ControlLabelModel.ControlLabelList>> m_OldLabelLists;
    private JButton jButton_AddLabel;
    private JButton jButton_RemoveLabel;
    private JButton jButton_SelectLabelColor;
    private JButton jButton_SelectLabelImage;
    private JButton jButton_SelectLabelInvisible;
    private JButton jButton_SelectLabelText;
    private JLabel jLabel_Header;
    private JLabel jLabel_HighByte;
    private JLabelBackground jLabel_LabelIcon;
    private JLabel jLabel_LabelIconDescription;
    private JLabel jLabel_LabelText;
    private JLabel jLabel_Percent;
    private JLabel jLabel_ValueRange;
    private JList jList_Labels;
    private JPanel jPanel1;
    private JScrollPane jScrollPane_Labels;
    private JTextFieldBytePanel jTextFieldByte_ValueDefault;
    private JTextFieldBytePanel jTextFieldByte_ValueEnd;
    private JTextFieldBytePanel jTextFieldByte_ValueStart;
    private JTextField jTextField_LabelText;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;

    public JControlSettings_LabelModel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
        this.clear();
    }

    private void initMembers() {
        this.m_ControlLabelModel = null;
        this.m_ControlObject = null;
        this.m_LabelColor = null;
        this.m_LabelImage = null;
        this.m_ControlSettings_Dimension = null;
        this.m_OldLabelLists = new ArrayList();
        this.m_OnlyInteger = false;
    }

    private void initComponents() {
        this.jScrollPane_Labels = new JScrollPane();
        this.jList_Labels = new JList();
        this.jLabel_LabelIconDescription = new JLabel();
        this.jLabel_LabelIcon = new JLabelBackground();
        this.jLabel_LabelText = new JLabel();
        this.jTextField_LabelText = new JTextField();
        this.jToolBar1 = new JToolBar();
        this.jButton_SelectLabelImage = new JButton();
        this.jButton_SelectLabelColor = new JButton();
        this.jButton_SelectLabelText = new JButton();
        this.jButton_SelectLabelInvisible = new JButton();
        this.jToolBar2 = new JToolBar();
        this.jButton_AddLabel = new JButton();
        this.jButton_RemoveLabel = new JButton();
        this.jTextFieldByte_ValueEnd = new JTextFieldBytePanel();
        this.jTextFieldByte_ValueDefault = new JTextFieldBytePanel();
        this.jTextFieldByte_ValueStart = new JTextFieldBytePanel();
        this.jPanel1 = new JPanel();
        this.jLabel_Percent = new JLabel();
        this.jLabel_ValueRange = new JLabel();
        this.jLabel_HighByte = new JLabel();
        this.jLabel_Header = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane_Labels.setMinimumSize(new Dimension(40, 23));
        this.jScrollPane_Labels.setPreferredSize(new Dimension(100, 100));
        this.jList_Labels.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_Labels.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JControlSettings_LabelModel.this.jList_LabelsValueChanged(evt);
            }
        });
        this.jScrollPane_Labels.setViewportView(this.jList_Labels);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jScrollPane_Labels, gridBagConstraints);
        this.jLabel_LabelIconDescription.setHorizontalAlignment(0);
        this.jLabel_LabelIconDescription.setIcon(new ImageIcon(this.getClass().getResource("/ControlImages/LabelSetting_white.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_LabelIconDescription, gridBagConstraints);
        this.jLabel_LabelIcon.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel_LabelIcon.setHorizontalAlignment(0);
        this.jLabel_LabelIcon.setText("X");
        this.jLabel_LabelIcon.setMaximumSize(new Dimension(100, 100));
        this.jLabel_LabelIcon.setMinimumSize(new Dimension(32, 32));
        this.jLabel_LabelIcon.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_LabelIcon, gridBagConstraints);
        this.jLabel_LabelText.setHorizontalAlignment(0);
        this.jLabel_LabelText.setIcon(new ImageIcon(this.getClass().getResource("/ControlImages/Text_white.png")));
        this.jLabel_LabelText.setMaximumSize(new Dimension(32, 32));
        this.jLabel_LabelText.setMinimumSize(new Dimension(32, 32));
        this.jLabel_LabelText.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_LabelText, gridBagConstraints);
        this.jTextField_LabelText.setText("label");
        this.jTextField_LabelText.setToolTipText("text");
        this.jTextField_LabelText.setPreferredSize(new Dimension(25, 20));
        this.jTextField_LabelText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JControlSettings_LabelModel.this.jTextField_LabelTextFocusLost(evt);
            }
        });
        this.jTextField_LabelText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JControlSettings_LabelModel.this.jTextField_LabelTextKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextField_LabelText, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(36, 110));
        this.jToolBar1.setMinimumSize(new Dimension(36, 110));
        this.jToolBar1.setOpaque(false);
        this.jToolBar1.setPreferredSize(new Dimension(36, 110));
        this.jButton_SelectLabelImage.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Image.png")));
        this.jButton_SelectLabelImage.setToolTipText("select label's image");
        this.jButton_SelectLabelImage.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectLabelImage.setContentAreaFilled(false);
        this.jButton_SelectLabelImage.setFocusable(false);
        this.jButton_SelectLabelImage.setHorizontalTextPosition(0);
        this.jButton_SelectLabelImage.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectLabelImage.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectLabelImage.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectLabelImage.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectLabelImage.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectLabelImage.setVerticalTextPosition(3);
        this.jButton_SelectLabelImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_SelectLabelImageActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectLabelImage);
        this.jButton_SelectLabelColor.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Colors.png")));
        this.jButton_SelectLabelColor.setToolTipText("select label's color");
        this.jButton_SelectLabelColor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectLabelColor.setContentAreaFilled(false);
        this.jButton_SelectLabelColor.setFocusable(false);
        this.jButton_SelectLabelColor.setHorizontalTextPosition(0);
        this.jButton_SelectLabelColor.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectLabelColor.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectLabelColor.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectLabelColor.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectLabelColor.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectLabelColor.setVerticalTextPosition(3);
        this.jButton_SelectLabelColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_SelectLabelColorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectLabelColor);
        this.jButton_SelectLabelText.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Text.png")));
        this.jButton_SelectLabelText.setToolTipText("select text");
        this.jButton_SelectLabelText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectLabelText.setContentAreaFilled(false);
        this.jButton_SelectLabelText.setFocusable(false);
        this.jButton_SelectLabelText.setHorizontalTextPosition(0);
        this.jButton_SelectLabelText.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectLabelText.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectLabelText.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectLabelText.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectLabelText.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectLabelText.setVerticalTextPosition(3);
        this.jButton_SelectLabelText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_SelectLabelTextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectLabelText);
        this.jButton_SelectLabelInvisible.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Invisible.png")));
        this.jButton_SelectLabelInvisible.setToolTipText("select text");
        this.jButton_SelectLabelInvisible.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectLabelInvisible.setContentAreaFilled(false);
        this.jButton_SelectLabelInvisible.setFocusable(false);
        this.jButton_SelectLabelInvisible.setHorizontalTextPosition(0);
        this.jButton_SelectLabelInvisible.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectLabelInvisible.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectLabelInvisible.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectLabelInvisible.setName("");
        this.jButton_SelectLabelInvisible.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectLabelInvisible.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectLabelInvisible.setVerticalTextPosition(3);
        this.jButton_SelectLabelInvisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_SelectLabelInvisibleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectLabelInvisible);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jToolBar2.setBorder(null);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jToolBar2.setOpaque(false);
        this.jButton_AddLabel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddLabel.setToolTipText("add label");
        this.jButton_AddLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_AddLabel.setContentAreaFilled(false);
        this.jButton_AddLabel.setFocusable(false);
        this.jButton_AddLabel.setHorizontalTextPosition(0);
        this.jButton_AddLabel.setMaximumSize(new Dimension(34, 34));
        this.jButton_AddLabel.setMinimumSize(new Dimension(34, 34));
        this.jButton_AddLabel.setPreferredSize(new Dimension(34, 34));
        this.jButton_AddLabel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddLabel.setVerticalTextPosition(3);
        this.jButton_AddLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_AddLabelActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_AddLabel);
        this.jButton_RemoveLabel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveLabel.setToolTipText("remove label");
        this.jButton_RemoveLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_RemoveLabel.setContentAreaFilled(false);
        this.jButton_RemoveLabel.setFocusable(false);
        this.jButton_RemoveLabel.setHorizontalTextPosition(0);
        this.jButton_RemoveLabel.setMaximumSize(new Dimension(34, 34));
        this.jButton_RemoveLabel.setMinimumSize(new Dimension(34, 34));
        this.jButton_RemoveLabel.setPreferredSize(new Dimension(34, 34));
        this.jButton_RemoveLabel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveLabel.setVerticalTextPosition(3);
        this.jButton_RemoveLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_LabelModel.this.jButton_RemoveLabelActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_RemoveLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jToolBar2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueStart, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_Percent.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Percent, gridBagConstraints);
        this.jLabel_ValueRange.setHorizontalAlignment(2);
        this.jLabel_ValueRange.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_ValueRange, gridBagConstraints);
        this.jLabel_HighByte.setText("High-Low 0-255");
        this.jLabel_HighByte.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_HighByte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel_Header.setHorizontalAlignment(0);
        this.jLabel_Header.setText("Labels");
        this.jLabel_Header.setToolTipText("Labels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_Header, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jList_Labels.setSelectionMode(0);
        this.jTextFieldByte_ValueEnd.addPropertyChangeListener(this);
        this.jTextFieldByte_ValueDefault.addPropertyChangeListener(this);
        this.jTextFieldByte_ValueStart.addPropertyChangeListener(this);
        MouseAdapter o_MouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof JTextField) {
                    JTextField o_JTextField = (JTextField)e.getSource();
                    o_JTextField.selectAll();
                }
            }
        };
        this.jTextFieldByte_ValueEnd.addMouseListener(o_MouseAdapter);
        this.jTextFieldByte_ValueDefault.addMouseListener(o_MouseAdapter);
        this.jTextFieldByte_ValueStart.addMouseListener(o_MouseAdapter);
        this.jTextField_LabelText.addMouseListener(o_MouseAdapter);
        this.setOnlyIntegerValues(this.m_OnlyInteger);
        this.jLabel_Header.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_AddLabel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveLabel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectLabelColor.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectLabelImage.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectLabelInvisible.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectLabelText.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jButton_AddLabel.setComponentPopupMenu(null);
        this.jButton_RemoveLabel.setComponentPopupMenu(null);
        this.jButton_SelectLabelColor.setComponentPopupMenu(null);
        this.jButton_SelectLabelImage.setComponentPopupMenu(null);
        this.jButton_SelectLabelInvisible.setComponentPopupMenu(null);
        this.jButton_SelectLabelText.setComponentPopupMenu(null);
        this.jTextFieldByte_ValueEnd.removePropertyChangeListener(this);
        this.jTextFieldByte_ValueDefault.removePropertyChangeListener(this);
        this.jTextFieldByte_ValueStart.removePropertyChangeListener(this);
        LiveLanguage.removeLanguageListener(this);
        this.setSelectedControlDimension(null);
        this.setControlObject(null);
        if (this.m_OldLabelLists != null) {
            this.m_OldLabelLists.clear();
        }
        LiveLanguage.removeLanguageListener(this);
    }

    public void setControlSetting_Dimension(JControlSettings_Dimension p_ControlSettings_Dimension) {
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.removePropertyChangeListener(this);
        }
        this.m_ControlSettings_Dimension = p_ControlSettings_Dimension;
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.addPropertyChangeListener(this);
            this.setControlObject(p_ControlSettings_Dimension.getControlObject());
            this.setSelectedControlDimension(p_ControlSettings_Dimension.getSelectedControlDimension());
        } else {
            this.setSelectedControlDimension(null);
            this.setControlObject(null);
        }
    }

    public void setControlObject(ControlObject p_ControlObject) {
        if (this.m_ControlObject == p_ControlObject) {
            return;
        }
        ControlObject oldValue = this.m_ControlObject;
        if (oldValue != null) {
            this.clear();
        }
        this.m_ControlObject = p_ControlObject;
        if (this.m_ControlObject == null) {
            this.clear();
            return;
        }
        this.m_SelectedControlDimension = null;
        this.setOldLabelLists();
        this.refresh();
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        if (this.m_OnlyInteger == p_OnlyIntegerValues) {
            return;
        }
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.jTextFieldByte_ValueEnd.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.jTextFieldByte_ValueDefault.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.jTextFieldByte_ValueStart.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
        if (this.m_SelectedControlDimension != null) {
            if (this.m_OnlyInteger) {
                this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
            } else {
                this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
            }
        }
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void setOldLabelLists() {
        this.m_OldLabelLists.clear();
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ArrayList<ControlLabelModel.ControlLabelList> o_OldDimensionLabelList = new ArrayList<ControlLabelModel.ControlLabelList>();
            this.m_OldLabelLists.add(o_OldDimensionLabelList);
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
            if (o_ControlLabelModel == null) continue;
            for (int intList = 0; intList < o_ControlLabelModel.getControlLabelListSize(); ++intList) {
                ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intList).getCopy(o_ControlLabelModel);
                o_OldDimensionLabelList.add(o_ControlLabelList);
            }
        }
    }

    private void setSelectedControlDimension(ControlObject.ControlDimension p_ControlDimension) {
        if (this.m_SelectedControlDimension == p_ControlDimension) {
            return;
        }
        if (this.m_SelectedControlDimension != null) {
            this.setControlLabelModel(null);
        }
        ControlObject.ControlDimension oldValue = this.m_SelectedControlDimension;
        this.m_SelectedControlDimension = p_ControlDimension;
        if (this.m_SelectedControlDimension != null) {
            this.jTextFieldByte_ValueEnd.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.jTextFieldByte_ValueDefault.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.jTextFieldByte_ValueStart.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
        }
        this.refresh();
    }

    public ControlObject getControlObject() {
        return this.m_ControlObject;
    }

    private void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
        if (this.m_ControlLabelModel != null) {
            this.m_ControlLabelModel.removePropertyChangeListener(this);
            this.setSelectedControlLabelList(null);
        }
        this.m_ControlLabelModel = p_ControlLabelModel;
        if (this.m_ControlLabelModel != null) {
            this.setOnlyIntegerValues(this.m_ControlLabelModel.getOnlyIntegerValues());
            this.m_ControlLabelModel.addPropertyChangeListener(this);
            ControlLabelModel.ControlLabelList o_ControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList();
            this.setSelectedControlLabelList(o_ControlLabelList);
        }
    }

    public void setSelectedControlLabelList(ControlLabelModel.ControlLabelList p_ControlLabelList) {
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.removePropertyChangeListener(this);
        }
        this.m_SelectedControlLabelList = p_ControlLabelList;
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.addPropertyChangeListener(this);
            this.jList_Labels.setModel(this.m_SelectedControlLabelList);
            this.jList_Labels.setCellRenderer(this.m_ControlLabelModel.getControlLabelDescriptionCellRenderer());
        }
    }

    public void cancel() {
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ControlLabelModel o_ControlLabelModel;
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            if (o_ControlDimension == null || (o_ControlLabelModel = o_ControlDimension.getControlLabelModel()) == null) continue;
            o_ControlLabelModel.clearControlLabelLists();
            ArrayList<ControlLabelModel.ControlLabelList> o_ControlLabelLists = this.m_OldLabelLists.get(intDimension);
            for (int intList = 0; intList < o_ControlLabelLists.size(); ++intList) {
                ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelLists.get(intList);
                o_ControlLabelModel.addControlLabelList(o_ControlLabelList);
            }
            this.setOldLabelLists();
        }
    }

    public void save() {
        this.setOldLabelLists();
    }

    private void clear() {
        this.jList_Labels.setCellRenderer(null);
        this.setSelectedLabelDescription(null);
        this.jButton_AddLabel.setEnabled(false);
    }

    private void refresh() {
        if (this.m_ControlObject == null || this.m_SelectedControlDimension == null) {
            this.clear();
            return;
        }
        ControlLabelModel o_ControlLabelModel = this.m_SelectedControlDimension.getControlLabelModel();
        if (o_ControlLabelModel == null) {
            String stringName = " ";
            if (this.m_SelectedControlDimension != null && this.m_SelectedControlDimension.getControlObject() != null) {
                stringName = this.m_SelectedControlDimension.getControlObject().getName();
            }
            o_ControlLabelModel = new ControlLabelModel(stringName, this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.m_SelectedControlDimension.setControlLabelModel(o_ControlLabelModel);
        }
        this.setControlLabelModel(o_ControlLabelModel);
        this.jButton_AddLabel.setEnabled(true);
        if (this.m_OnlyInteger) {
            this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
        } else {
            this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
        }
    }

    private void setSelectedLabelDescription(ControlLabelModel.ControlLabelDescription p_LabelDescription) {
        ControlLabelModel.ControlLabelList o_ControlLabelList;
        this.m_SelectedLabelDescription = p_LabelDescription;
        if (this.m_SelectedLabelDescription == null) {
            this.jTextFieldByte_ValueEnd.setValue(0.0);
            this.jTextFieldByte_ValueEnd.setEnabled(false);
            this.jTextFieldByte_ValueDefault.setValue(0.0);
            this.jTextFieldByte_ValueDefault.setEnabled(false);
            this.jTextFieldByte_ValueStart.setValue(0.0);
            this.jTextFieldByte_ValueStart.setEnabled(false);
            this.jTextField_LabelText.setText("");
            this.jTextField_LabelText.setEnabled(false);
            this.m_LabelColor = null;
            this.m_LabelImage = null;
            this.jButton_RemoveLabel.setEnabled(false);
            this.jButton_SelectLabelImage.setEnabled(false);
            this.jButton_SelectLabelColor.setEnabled(false);
            this.jButton_SelectLabelText.setEnabled(false);
            this.jButton_SelectLabelInvisible.setEnabled(false);
        } else {
            this.jTextFieldByte_ValueEnd.setValue(p_LabelDescription.getValueEnd());
            this.jTextFieldByte_ValueEnd.setEnabled(true);
            this.jTextFieldByte_ValueDefault.setValue(p_LabelDescription.getValueDefault());
            this.jTextFieldByte_ValueDefault.setEnabled(true);
            this.jTextFieldByte_ValueStart.setValue(p_LabelDescription.getValueStart());
            this.jTextFieldByte_ValueStart.setEnabled(true);
            this.jTextField_LabelText.setText(p_LabelDescription.getLabelText());
            this.jTextField_LabelText.setEnabled(true);
            this.m_LabelColor = this.m_SelectedLabelDescription.getLabelColor();
            this.m_LabelImage = this.m_SelectedLabelDescription.getLabelImage();
            this.jButton_RemoveLabel.setEnabled(true);
            this.jButton_SelectLabelImage.setEnabled(true);
            this.jButton_SelectLabelColor.setEnabled(true);
            this.jButton_SelectLabelText.setEnabled(true);
            this.jButton_SelectLabelInvisible.setEnabled(true);
        }
        this.refreshLabelIcon();
        this.jList_Labels.setSelectedValue(this.m_SelectedLabelDescription, true);
        if (this.m_ControlLabelModel != null && (o_ControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList()) != null) {
            o_ControlLabelList.setSelectedItem(this.m_SelectedLabelDescription);
        }
    }

    private void refreshLabelIcon() {
        boolean boolVisible;
        if (this.m_SelectedLabelDescription == null) {
            this.jLabel_LabelIcon.setText("");
            this.jLabel_LabelIcon.setToolTipText(null);
            boolVisible = false;
        } else {
            this.jLabel_LabelIcon.setText(this.m_SelectedLabelDescription.getLabelText());
            this.jLabel_LabelIcon.setToolTipText(this.m_SelectedLabelDescription.getLabelText());
            boolVisible = this.m_SelectedLabelDescription.getVisible();
        }
        this.jLabel_LabelIcon.setBackgroundStyle(0);
        this.jLabel_LabelIcon.setBackgroundOpaque(false);
        this.jLabel_LabelIcon.setBackground(this.m_LabelColor);
        if (this.m_LabelColor != null) {
            this.jLabel_LabelIcon.setBackgroundOpaque(true);
            this.jLabel_LabelIcon.setText("");
        }
        this.jLabel_LabelIcon.setBackgroundImage(this.m_LabelImage);
        if (this.m_LabelImage != null) {
            this.jLabel_LabelIcon.setBackgroundStyle(3);
            this.jLabel_LabelIcon.setBackgroundOpaque(true);
            this.jLabel_LabelIcon.setText("");
        }
        if (!boolVisible) {
            this.jLabel_LabelIcon.setText("");
            this.jLabel_LabelIcon.setBackgroundOpaque(false);
            this.jTextField_LabelText.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        } else {
            this.jTextField_LabelText.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    public static void setDefaultStartValue(double p_Value) {
        s_DefaultStartValue = p_Value;
    }

    public static void setDefaultEndValue(double p_Value) {
        s_DefaultEndValue = p_Value;
    }

    public static void setDefaultValue(double p_Value) {
        s_DefaultValue = p_Value;
    }

    private void jList_LabelsValueChanged(ListSelectionEvent evt) {
        ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = (ControlLabelModel.ControlLabelDescription)this.jList_Labels.getSelectedValue();
        if (this.m_SelectedLabelDescription != o_ControlLabelDescription) {
            try {
                if (this.m_SelectedLabelDescription != null) {
                    this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setSelectedLabelDescription(o_ControlLabelDescription);
        }
    }

    private void jButton_SelectLabelImageActionPerformed(ActionEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        BufferedImage o_BufferedImage = ImagesTools.loadImageFileDialog((String)LOADIMAGE, (Component)this);
        if (o_BufferedImage == null) {
            return;
        }
        this.m_LabelColor = null;
        if (this.m_LabelImage != null) {
            this.m_LabelImage.flush();
            this.m_LabelImage = null;
        }
        this.m_LabelImage = ImagesTools.convertToBufferedImage((Image)o_BufferedImage, (Dimension)ControlLabelModel.DIMENSION_BIG);
        this.m_SelectedLabelDescription.setLabelImage(this.m_LabelImage);
        this.m_SelectedLabelDescription.setVisible(true);
        o_BufferedImage.flush();
        o_BufferedImage = null;
        this.refreshLabelIcon();
    }

    private void jButton_SelectLabelColorActionPerformed(ActionEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        Color o_Color = JColorChooser.showDialog(this, "LabelColor", this.m_LabelColor);
        if (o_Color == null) {
            return;
        }
        this.m_LabelImage = null;
        this.m_LabelColor = o_Color;
        this.m_SelectedLabelDescription.setLabelColor(this.m_LabelColor);
        this.m_SelectedLabelDescription.setVisible(true);
        this.refreshLabelIcon();
    }

    private void jButton_SelectLabelTextActionPerformed(ActionEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        this.m_LabelImage = null;
        this.m_LabelColor = null;
        this.m_SelectedLabelDescription.setLabelColor(null);
        this.m_SelectedLabelDescription.setLabelImage(null);
        this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
        this.m_SelectedLabelDescription.setVisible(true);
        this.refreshLabelIcon();
    }

    private void jButton_AddLabelActionPerformed(ActionEvent evt) {
        double doubleNewDefaultValue;
        double doubleNewEndValue;
        double doubleNewStartValue;
        ControlLabelModel o_ControlLabelModel;
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        this.m_SelectedControlDimension.setLabelsAutomatic(false);
        if (this.m_SelectedLabelDescription != null) {
            this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
        }
        if ((o_ControlLabelModel = this.m_SelectedControlDimension.getControlLabelModel()) == null) {
            return;
        }
        ControlLabelModel.ControlLabelDescription o_LastControlLabelDescription = o_ControlLabelModel.getLastControlLabelDescription();
        if (o_LastControlLabelDescription != null) {
            doubleNewStartValue = o_LastControlLabelDescription.getValueEnd() + 1.0;
            double doubleValueDiff = o_LastControlLabelDescription.getValueEnd() - o_LastControlLabelDescription.getValueStart();
            doubleNewEndValue = doubleNewStartValue + doubleValueDiff;
            doubleNewDefaultValue = (doubleNewEndValue - doubleNewStartValue) / 2.0;
        } else {
            doubleNewStartValue = s_DefaultStartValue;
            doubleNewEndValue = s_DefaultEndValue;
            doubleNewDefaultValue = s_DefaultValue;
        }
        ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = o_ControlLabelModel.createControlLabelDescription(doubleNewStartValue, doubleNewEndValue, (Double)doubleNewDefaultValue, "new");
        this.jList_Labels.setSelectedValue(o_ControlLabelDescription, true);
        this.setSelectedLabelDescription(o_ControlLabelDescription);
    }

    private void jButton_RemoveLabelActionPerformed(ActionEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        this.m_SelectedControlDimension.setLabelsAutomatic(false);
        ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = this.m_SelectedLabelDescription;
        this.jList_Labels.clearSelection();
        int intIndex = this.m_SelectedControlDimension.getControlLabelModel().getIndexOf(o_ControlLabelDescription);
        this.m_SelectedControlDimension.getControlLabelModel().removeControlLabelDescription(o_ControlLabelDescription);
        if (intIndex < 0) {
            intIndex = 0;
        }
        if (intIndex >= this.m_SelectedControlDimension.getControlLabelModel().getControlLabelDescriptionSize()) {
            intIndex = this.m_SelectedControlDimension.getControlLabelModel().getControlLabelDescriptionSize() - 1;
        }
        if (intIndex >= 0) {
            o_ControlLabelDescription = this.m_SelectedControlDimension.getControlLabelModel().getControlLabelDescription(intIndex);
            this.jList_Labels.setSelectedValue(o_ControlLabelDescription, true);
            this.setSelectedLabelDescription(o_ControlLabelDescription);
        }
    }

    private void jTextField_LabelTextFocusLost(FocusEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        try {
            this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton_SelectLabelInvisibleActionPerformed(ActionEvent evt) {
        if (this.m_SelectedLabelDescription == null) {
            return;
        }
        this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
        if (this.m_SelectedLabelDescription.getVisible()) {
            this.m_SelectedLabelDescription.setVisible(false);
        } else {
            this.m_SelectedLabelDescription.setVisible(true);
        }
        this.refreshLabelIcon();
    }

    private void jTextField_LabelTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.m_SelectedLabelDescription == null) {
                return;
            }
            try {
                this.m_SelectedLabelDescription.setLabelText(this.jTextField_LabelText.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.jTextFieldByte_ValueEnd) {
            if (this.m_SelectedLabelDescription == null) {
                return;
            }
            this.m_SelectedLabelDescription.setValueEnd(this.jTextFieldByte_ValueEnd.getValue());
        } else if (evt.getSource() == this.jTextFieldByte_ValueDefault) {
            if (this.m_SelectedLabelDescription == null) {
                return;
            }
            this.m_SelectedLabelDescription.setValueDefault(this.jTextFieldByte_ValueDefault.getValue());
        } else if (evt.getSource() == this.jTextFieldByte_ValueStart) {
            if (this.m_SelectedLabelDescription == null) {
                return;
            }
            this.m_SelectedLabelDescription.setValueStart(this.jTextFieldByte_ValueStart.getValue());
        } else if (evt.getSource() instanceof JControlSettings_Dimension) {
            if (PROP_CONTROLOBJECT.equals(evt.getPropertyName())) {
                this.setControlObject((ControlObject)evt.getNewValue());
            } else if (PROP_CONTROLDIMENSION.equals(evt.getPropertyName())) {
                this.setSelectedControlDimension((ControlObject.ControlDimension)evt.getNewValue());
            }
        } else if (evt.getSource() instanceof ControlLabelModel) {
            if ("listSelected".equals(evt.getPropertyName())) {
                if (this.m_SelectedControlDimension == null) {
                    return;
                }
                ControlLabelModel.ControlLabelList o_ControlLabelList = (ControlLabelModel.ControlLabelList)evt.getNewValue();
                this.setSelectedControlLabelList(o_ControlLabelList);
            }
        } else if (evt.getSource() instanceof ControlLabelModel.ControlLabelList) {
            if ("labelValueStart".equals(evt.getPropertyName())) {
                this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
            } else if ("labelValueDefault".equals(evt.getPropertyName())) {
                this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
            } else if ("labelValueEnd".equals(evt.getPropertyName())) {
                this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
            } else if ("labelProperties".equals(evt.getPropertyName())) {
                this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
            } else if ("labelDescriptionResorted".equals(evt.getPropertyName())) {
                this.setSelectedLabelDescription(this.m_SelectedLabelDescription);
            }
        }
    }
}

