/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowControlModels.JControlSettings_Dimension;
import LiveShowControlModels.JTextFieldBytePanel;
import LiveShowControlObjects.ControlObject;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JControlSettings_FunctionModel
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_CONTROLOBJECT = "jcontrolsettings_dimension_Object";
    public static final String PROP_CONTROLDIMENSION = "jcontrolsettings_dimension_Dimension";
    protected JControlSettings_Dimension m_ControlSettings_Dimension;
    protected ControlObject m_ControlObject;
    protected ControlObject.ControlDimension m_SelectedControlDimension;
    protected ControlFunctionModel m_ControlFunctionModel;
    protected ControlFunctionModel.ControlFunctionDescription m_SelectedFunctionDescription;
    protected Image m_FunctionImage;
    protected ControlFunctionModel.ControlFunctionType m_SelectedControlFunctionType;
    protected boolean m_OnlyInteger;
    protected ArrayList<ArrayList<ControlFunctionModel.ControlFunctionDescription>> m_OldFunctionDescriptions;
    private JButton jButton_AddFunctionDescription;
    private JButton jButton_RemoveFunctionDescription;
    private JComboBox jComboBox_FunctionType;
    private JLabelBackground jLabel_FunctionIcon;
    private JLabel jLabel_Header;
    private JLabel jLabel_HighByte;
    private JLabel jLabel_Percent;
    private JLabel jLabel_ValueRange;
    private JList jList_FunctionDescriptions;
    private JPanel jPanel1;
    private JScrollPane jScrollPane_Functions;
    private JTextFieldBytePanel jTextFieldByte_Value;
    private JToolBar jToolBar2;

    public JControlSettings_FunctionModel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
        this.clear();
    }

    private void initMembers() {
        this.m_ControlFunctionModel = null;
        this.m_ControlObject = null;
        this.m_FunctionImage = null;
        this.m_ControlSettings_Dimension = null;
        this.m_OldFunctionDescriptions = new ArrayList();
        this.m_SelectedControlFunctionType = null;
        this.m_OnlyInteger = false;
    }

    private void initComponents() {
        this.jScrollPane_Functions = new JScrollPane();
        this.jList_FunctionDescriptions = new JList();
        this.jLabel_FunctionIcon = new JLabelBackground();
        this.jToolBar2 = new JToolBar();
        this.jButton_AddFunctionDescription = new JButton();
        this.jButton_RemoveFunctionDescription = new JButton();
        this.jComboBox_FunctionType = new JComboBox();
        this.jTextFieldByte_Value = new JTextFieldBytePanel();
        this.jPanel1 = new JPanel();
        this.jLabel_Percent = new JLabel();
        this.jLabel_ValueRange = new JLabel();
        this.jLabel_HighByte = new JLabel();
        this.jLabel_Header = new JLabel();
        this.setBackground(new Color(0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.jScrollPane_Functions.setMinimumSize(new Dimension(40, 23));
        this.jScrollPane_Functions.setPreferredSize(new Dimension(100, 100));
        this.jList_FunctionDescriptions.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_FunctionDescriptions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JControlSettings_FunctionModel.this.jList_FunctionDescriptionsValueChanged(evt);
            }
        });
        this.jScrollPane_Functions.setViewportView(this.jList_FunctionDescriptions);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane_Functions, gridBagConstraints);
        this.jLabel_FunctionIcon.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel_FunctionIcon.setForeground(new Color(255, 255, 255));
        this.jLabel_FunctionIcon.setHorizontalAlignment(0);
        this.jLabel_FunctionIcon.setText("X");
        this.jLabel_FunctionIcon.setMaximumSize(new Dimension(100, 100));
        this.jLabel_FunctionIcon.setMinimumSize(new Dimension(32, 32));
        this.jLabel_FunctionIcon.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_FunctionIcon, gridBagConstraints);
        this.jToolBar2.setBorder(null);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jToolBar2.setOpaque(false);
        this.jButton_AddFunctionDescription.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddFunctionDescription.setToolTipText("add function");
        this.jButton_AddFunctionDescription.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_AddFunctionDescription.setBorderPainted(false);
        this.jButton_AddFunctionDescription.setContentAreaFilled(false);
        this.jButton_AddFunctionDescription.setFocusable(false);
        this.jButton_AddFunctionDescription.setHorizontalTextPosition(0);
        this.jButton_AddFunctionDescription.setMaximumSize(new Dimension(34, 34));
        this.jButton_AddFunctionDescription.setMinimumSize(new Dimension(34, 34));
        this.jButton_AddFunctionDescription.setPreferredSize(new Dimension(34, 34));
        this.jButton_AddFunctionDescription.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddFunctionDescription.setVerticalTextPosition(3);
        this.jButton_AddFunctionDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_FunctionModel.this.jButton_AddFunctionDescriptionActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_AddFunctionDescription);
        this.jButton_RemoveFunctionDescription.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveFunctionDescription.setToolTipText("remove function");
        this.jButton_RemoveFunctionDescription.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_RemoveFunctionDescription.setBorderPainted(false);
        this.jButton_RemoveFunctionDescription.setContentAreaFilled(false);
        this.jButton_RemoveFunctionDescription.setFocusable(false);
        this.jButton_RemoveFunctionDescription.setHorizontalTextPosition(0);
        this.jButton_RemoveFunctionDescription.setMaximumSize(new Dimension(34, 34));
        this.jButton_RemoveFunctionDescription.setMinimumSize(new Dimension(34, 34));
        this.jButton_RemoveFunctionDescription.setPreferredSize(new Dimension(34, 34));
        this.jButton_RemoveFunctionDescription.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveFunctionDescription.setVerticalTextPosition(3);
        this.jButton_RemoveFunctionDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_FunctionModel.this.jButton_RemoveFunctionDescriptionActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_RemoveFunctionDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jToolBar2, gridBagConstraints);
        this.jComboBox_FunctionType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_FunctionType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JControlSettings_FunctionModel.this.jComboBox_FunctionTypeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_FunctionType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextFieldByte_Value, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_Percent.setForeground(new Color(204, 255, 204));
        this.jLabel_Percent.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Percent, gridBagConstraints);
        this.jLabel_ValueRange.setForeground(new Color(255, 204, 255));
        this.jLabel_ValueRange.setHorizontalAlignment(2);
        this.jLabel_ValueRange.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_ValueRange, gridBagConstraints);
        this.jLabel_HighByte.setForeground(new Color(255, 255, 255));
        this.jLabel_HighByte.setText("High-Low 0-255");
        this.jLabel_HighByte.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_HighByte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel_Header.setForeground(new Color(255, 255, 255));
        this.jLabel_Header.setHorizontalAlignment(0);
        this.jLabel_Header.setText("Fixed Funtions");
        this.jLabel_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel_Header, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jList_FunctionDescriptions.setSelectionMode(0);
        this.jComboBox_FunctionType.setModel(ControlFunctionModel.ControlFunctionType.getControlFunctionTypeList());
        this.jComboBox_FunctionType.setRenderer(ControlFunctionModel.ControlFunctionType.s_ControlFunctionTypeCellRenderer);
        if (ControlFunctionModel.ControlFunctionType.getControlFunctionTypeList().size() > 0) {
            this.jComboBox_FunctionType.setSelectedIndex(0);
            this.m_SelectedControlFunctionType = (ControlFunctionModel.ControlFunctionType)this.jComboBox_FunctionType.getSelectedItem();
        }
        this.jTextFieldByte_Value.addPropertyChangeListener(this);
        this.setOnlyIntegerValues(this.m_OnlyInteger);
        this.jLabel_Header.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_AddFunctionDescription.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveFunctionDescription.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jButton_AddFunctionDescription.setComponentPopupMenu(null);
        this.jButton_RemoveFunctionDescription.setComponentPopupMenu(null);
        this.jTextFieldByte_Value.removePropertyChangeListener(this);
        LiveLanguage.removeLanguageListener(this);
        this.setSelectedControlDimension(null);
        this.setControlObject(null);
        if (this.m_OldFunctionDescriptions != null) {
            this.m_OldFunctionDescriptions.clear();
        }
        LiveLanguage.removeLanguageListener(this);
    }

    public void setControlSetting_Dimension(JControlSettings_Dimension p_ControlSettings_Dimension) {
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.removePropertyChangeListener(this);
        }
        this.m_ControlSettings_Dimension = p_ControlSettings_Dimension;
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.addPropertyChangeListener(this);
            this.setControlObject(p_ControlSettings_Dimension.getControlObject());
            this.setSelectedControlDimension(p_ControlSettings_Dimension.getSelectedControlDimension());
        } else {
            this.setSelectedControlDimension(null);
            this.setControlObject(null);
        }
    }

    public void setControlObject(ControlObject p_ControlObject) {
        if (this.m_ControlObject == p_ControlObject) {
            return;
        }
        ControlObject oldValue = this.m_ControlObject;
        if (oldValue != null) {
            this.clear();
        }
        this.m_ControlObject = p_ControlObject;
        if (this.m_ControlObject == null) {
            this.clear();
            return;
        }
        this.firePropertyChange(PROP_CONTROLOBJECT, oldValue, this.m_ControlObject);
        this.m_SelectedControlDimension = null;
        this.setOldFunctionDescriptions();
        this.refresh();
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        if (this.m_OnlyInteger == p_OnlyIntegerValues) {
            return;
        }
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.jTextFieldByte_Value.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.setSelectedFunctionDescription(this.m_SelectedFunctionDescription);
        if (this.m_SelectedControlDimension != null) {
            if (this.m_OnlyInteger) {
                this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
            } else {
                this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
            }
        }
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void setOldFunctionDescriptions() {
        this.m_OldFunctionDescriptions.clear();
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ArrayList<ControlFunctionModel.ControlFunctionDescription> o_OldDimensionFunctions = new ArrayList<ControlFunctionModel.ControlFunctionDescription>();
            this.m_OldFunctionDescriptions.add(o_OldDimensionFunctions);
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            ControlFunctionModel o_ControlFunctionModel = o_ControlDimension.getControlFunctionModel();
            if (o_ControlFunctionModel == null) continue;
            for (int intFunction = 0; intFunction < o_ControlFunctionModel.getControlFunctionDescriptionSize(); ++intFunction) {
                ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = o_ControlFunctionModel.getControlFunctionDescription(intFunction).getCopy();
                o_OldDimensionFunctions.add(o_ControlFunctionDescription);
            }
        }
    }

    private void setSelectedControlDimension(ControlObject.ControlDimension p_ControlDimension) {
        ControlFunctionModel o_ControlFunctionModel;
        if (this.m_SelectedControlDimension == p_ControlDimension) {
            return;
        }
        if (this.m_SelectedControlDimension != null && (o_ControlFunctionModel = this.m_SelectedControlDimension.getControlFunctionModel()) != null) {
            o_ControlFunctionModel.removePropertyChangeListener(this);
        }
        ControlObject.ControlDimension oldValue = this.m_SelectedControlDimension;
        this.m_SelectedControlDimension = p_ControlDimension;
        if (this.m_SelectedControlDimension != null) {
            this.jTextFieldByte_Value.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            o_ControlFunctionModel = this.m_SelectedControlDimension.getControlFunctionModel();
            if (o_ControlFunctionModel != null) {
                this.setOnlyIntegerValues(o_ControlFunctionModel.getOnlyIntegerValues());
                o_ControlFunctionModel.addPropertyChangeListener(this);
            }
        }
        this.refresh();
    }

    public ControlObject getControlObject() {
        return this.m_ControlObject;
    }

    public void cancel() {
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ControlFunctionModel o_ControlFunctionModel;
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            if (o_ControlDimension == null || (o_ControlFunctionModel = o_ControlDimension.getControlFunctionModel()) == null) continue;
            o_ControlFunctionModel.clearControlFunctionDescriptions();
            ArrayList<ControlFunctionModel.ControlFunctionDescription> o_OldDimensionFunctions = this.m_OldFunctionDescriptions.get(intDimension);
            for (int intFunction = 0; intFunction < o_OldDimensionFunctions.size(); ++intFunction) {
                ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = o_OldDimensionFunctions.get(intFunction);
                o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
            }
        }
    }

    public void save() {
        this.setOldFunctionDescriptions();
    }

    private void clear() {
        this.jList_FunctionDescriptions.setCellRenderer(null);
        this.setSelectedFunctionDescription(null);
        this.jButton_AddFunctionDescription.setEnabled(false);
    }

    private void refresh() {
        if (this.m_ControlObject == null || this.m_SelectedControlDimension == null) {
            this.clear();
            return;
        }
        ControlFunctionModel o_ControlFunctionModel = this.m_SelectedControlDimension.getControlFunctionModel();
        if (o_ControlFunctionModel == null) {
            o_ControlFunctionModel = new ControlFunctionModel(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
        }
        this.m_SelectedControlDimension.setControlFunctionModel(o_ControlFunctionModel);
        this.jList_FunctionDescriptions.setModel(o_ControlFunctionModel);
        this.jList_FunctionDescriptions.setCellRenderer(o_ControlFunctionModel.getListCellRenderer());
        this.jButton_AddFunctionDescription.setEnabled(true);
        if (this.m_OnlyInteger) {
            this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
        } else {
            this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
        }
    }

    private void setSelectedFunctionDescription(ControlFunctionModel.ControlFunctionDescription p_FunctionDescription) {
        this.m_SelectedFunctionDescription = p_FunctionDescription;
        if (this.m_SelectedFunctionDescription == null) {
            this.jTextFieldByte_Value.setValue(0.0);
            this.jTextFieldByte_Value.setEnabled(false);
            this.m_FunctionImage = null;
            this.jButton_RemoveFunctionDescription.setEnabled(false);
        } else {
            this.jTextFieldByte_Value.setValue(p_FunctionDescription.getValue());
            this.jTextFieldByte_Value.setEnabled(true);
            this.m_FunctionImage = this.m_SelectedFunctionDescription.getFunctionImage();
            ControlFunctionModel.ControlFunctionType o_ControlFunctionType = this.m_SelectedFunctionDescription.getControlFunctionType();
            if (o_ControlFunctionType != null) {
                this.jComboBox_FunctionType.setSelectedItem(o_ControlFunctionType);
            }
            this.jButton_RemoveFunctionDescription.setEnabled(true);
        }
        this.refreshFunctionIcon();
        this.jList_FunctionDescriptions.setSelectedValue(this.m_SelectedFunctionDescription, true);
    }

    private void refreshFunctionIcon() {
        if (this.m_SelectedFunctionDescription == null) {
            this.jLabel_FunctionIcon.setText("");
            this.jLabel_FunctionIcon.setToolTipText(null);
        } else {
            this.jLabel_FunctionIcon.setText(this.m_SelectedFunctionDescription.getFunctionName());
            this.jLabel_FunctionIcon.setToolTipText(this.m_SelectedFunctionDescription.getFunctionName());
        }
        this.jLabel_FunctionIcon.setBackgroundStyle(3);
        this.jLabel_FunctionIcon.setBackgroundOpaque(false);
        this.jLabel_FunctionIcon.setBackgroundImage(this.m_FunctionImage);
        if (this.m_FunctionImage != null) {
            this.jLabel_FunctionIcon.setBackgroundStyle(2);
            this.jLabel_FunctionIcon.setBackgroundOpaque(true);
            this.jLabel_FunctionIcon.setText("");
        }
    }

    private void jList_FunctionDescriptionsValueChanged(ListSelectionEvent evt) {
        ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = (ControlFunctionModel.ControlFunctionDescription)this.jList_FunctionDescriptions.getSelectedValue();
        if (this.m_SelectedFunctionDescription != o_ControlFunctionDescription) {
            this.setSelectedFunctionDescription(o_ControlFunctionDescription);
        }
    }

    private void jButton_AddFunctionDescriptionActionPerformed(ActionEvent evt) {
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        ControlFunctionModel o_ControlFunctionModel = this.m_SelectedControlDimension.getControlFunctionModel();
        if (o_ControlFunctionModel == null) {
            return;
        }
        ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = o_ControlFunctionModel.createControlFunctionDescription(this.m_SelectedControlFunctionType, 0.0);
        this.jList_FunctionDescriptions.setSelectedValue(o_ControlFunctionDescription, true);
        this.setSelectedFunctionDescription(o_ControlFunctionDescription);
    }

    private void jButton_RemoveFunctionDescriptionActionPerformed(ActionEvent evt) {
        if (this.m_SelectedFunctionDescription == null) {
            return;
        }
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = this.m_SelectedFunctionDescription;
        this.jList_FunctionDescriptions.clearSelection();
        int intIndex = this.m_SelectedControlDimension.getControlFunctionModel().getIndexOf(o_ControlFunctionDescription);
        this.m_SelectedControlDimension.getControlFunctionModel().removeControlFunctionDescription(o_ControlFunctionDescription);
        if (intIndex < 0) {
            intIndex = 0;
        }
        if (intIndex >= this.m_SelectedControlDimension.getControlFunctionModel().getControlFunctionDescriptionSize()) {
            intIndex = this.m_SelectedControlDimension.getControlFunctionModel().getControlFunctionDescriptionSize() - 1;
        }
        if (intIndex >= 0) {
            o_ControlFunctionDescription = this.m_SelectedControlDimension.getControlFunctionModel().getControlFunctionDescription(intIndex);
            this.jList_FunctionDescriptions.setSelectedValue(o_ControlFunctionDescription, true);
            this.setSelectedFunctionDescription(o_ControlFunctionDescription);
        }
    }

    private void jComboBox_FunctionTypeItemStateChanged(ItemEvent evt) {
        ControlFunctionModel.ControlFunctionType o_ControlFunctionType;
        this.m_SelectedControlFunctionType = o_ControlFunctionType = (ControlFunctionModel.ControlFunctionType)this.jComboBox_FunctionType.getSelectedItem();
        if (this.m_SelectedFunctionDescription != null) {
            this.m_SelectedFunctionDescription.setControlFunctionType(o_ControlFunctionType);
        }
        this.refreshFunctionIcon();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.jTextFieldByte_Value) {
            if (this.m_SelectedFunctionDescription == null) {
                return;
            }
            this.m_SelectedFunctionDescription.setValue(this.jTextFieldByte_Value.getValue());
        }
        if (evt.getSource() instanceof JControlSettings_Dimension) {
            if (PROP_CONTROLOBJECT.equals(evt.getPropertyName())) {
                this.setControlObject((ControlObject)evt.getNewValue());
            } else if (PROP_CONTROLDIMENSION.equals(evt.getPropertyName())) {
                this.setSelectedControlDimension((ControlObject.ControlDimension)evt.getNewValue());
            }
        } else if (evt.getSource() instanceof ControlFunctionModel) {
            if ("functionValue".equals(evt.getPropertyName())) {
                this.setSelectedFunctionDescription(this.m_SelectedFunctionDescription);
            } else if ("functionType".equals(evt.getPropertyName())) {
                this.setSelectedFunctionDescription(this.m_SelectedFunctionDescription);
            } else if ("functionProperties".equals(evt.getPropertyName())) {
                this.setSelectedFunctionDescription(this.m_SelectedFunctionDescription);
            }
        }
    }
}

