/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.JControlSettings_Dimension;
import LiveShowControlModels.JTextFieldBytePanel;
import LiveShowControlObjects.ControlObject;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JControlSettings_BlockModel
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_CONTROLOBJECT = "jcontrolsettings_dimension_Object";
    public static final String PROP_CONTROLDIMENSION = "jcontrolsettings_dimension_Dimension";
    @LiveLanguageString
    public static String LOADIMAGE = "Load image";
    public static double s_DefaultEndValue = 0.0;
    public static double s_DefaultValue = 0.0;
    public static double s_DefaultStartValue = 0.0;
    protected JControlSettings_Dimension m_ControlSettings_Dimension;
    protected ControlObject m_ControlObject;
    protected ControlObject.ControlDimension m_SelectedControlDimension;
    protected ControlBlockModel m_ControlBlockModel;
    protected ControlBlockModel.ControlBlockList m_SelectedControlLabelList;
    protected ControlBlockModel.ControlBlockDescription m_SelectedBlockDescription;
    protected Color m_BlockColor;
    protected Image m_BlockImage;
    protected boolean m_OnlyInteger;
    protected ArrayList<ArrayList<ControlBlockModel.ControlBlockList>> m_OldBlockLists;
    private JButton jButton_AddBlock;
    private JButton jButton_RemoveBlock;
    private JButton jButton_SelectBlockColor;
    private JButton jButton_SelectBlockImage;
    private JButton jButton_SelectBlockInvisible;
    private JButton jButton_SelectBlockText;
    private JLabelBackground jLabel_BlockIcon;
    private JLabel jLabel_Header;
    private JLabel jLabel_HighByte;
    private JLabel jLabel_LabelIconDescription;
    private JLabel jLabel_LabelText;
    private JLabel jLabel_Percent;
    private JLabel jLabel_ValueRange;
    private JList jList_Blocks;
    private JPanel jPanel1;
    private JScrollPane jScrollPane_Labels;
    private JTextFieldBytePanel jTextFieldByte_ValueDefault;
    private JTextFieldBytePanel jTextFieldByte_ValueEnd;
    private JTextFieldBytePanel jTextFieldByte_ValueStart;
    private JTextField jTextField_BlockText;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;

    public JControlSettings_BlockModel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.clear();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_ControlBlockModel = null;
        this.m_ControlObject = null;
        this.m_BlockColor = null;
        this.m_BlockImage = null;
        this.m_ControlSettings_Dimension = null;
        this.m_OldBlockLists = new ArrayList();
        this.m_OnlyInteger = false;
    }

    private void initComponents() {
        this.jScrollPane_Labels = new JScrollPane();
        this.jList_Blocks = new JList();
        this.jLabel_LabelIconDescription = new JLabel();
        this.jLabel_BlockIcon = new JLabelBackground();
        this.jLabel_LabelText = new JLabel();
        this.jTextField_BlockText = new JTextField();
        this.jToolBar1 = new JToolBar();
        this.jButton_SelectBlockImage = new JButton();
        this.jButton_SelectBlockColor = new JButton();
        this.jButton_SelectBlockText = new JButton();
        this.jButton_SelectBlockInvisible = new JButton();
        this.jToolBar2 = new JToolBar();
        this.jButton_AddBlock = new JButton();
        this.jButton_RemoveBlock = new JButton();
        this.jTextFieldByte_ValueEnd = new JTextFieldBytePanel();
        this.jTextFieldByte_ValueDefault = new JTextFieldBytePanel();
        this.jTextFieldByte_ValueStart = new JTextFieldBytePanel();
        this.jPanel1 = new JPanel();
        this.jLabel_Percent = new JLabel();
        this.jLabel_ValueRange = new JLabel();
        this.jLabel_HighByte = new JLabel();
        this.jLabel_Header = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane_Labels.setMinimumSize(new Dimension(40, 23));
        this.jScrollPane_Labels.setPreferredSize(new Dimension(100, 100));
        this.jList_Blocks.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_Blocks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JControlSettings_BlockModel.this.jList_BlocksValueChanged(evt);
            }
        });
        this.jScrollPane_Labels.setViewportView(this.jList_Blocks);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jScrollPane_Labels, gridBagConstraints);
        this.jLabel_LabelIconDescription.setHorizontalAlignment(0);
        this.jLabel_LabelIconDescription.setIcon(new ImageIcon(this.getClass().getResource("/ControlImages/LabelSetting_white.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel_LabelIconDescription, gridBagConstraints);
        this.jLabel_BlockIcon.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel_BlockIcon.setHorizontalAlignment(0);
        this.jLabel_BlockIcon.setText("X");
        this.jLabel_BlockIcon.setMaximumSize(new Dimension(100, 100));
        this.jLabel_BlockIcon.setMinimumSize(new Dimension(32, 32));
        this.jLabel_BlockIcon.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_BlockIcon, gridBagConstraints);
        this.jLabel_LabelText.setHorizontalAlignment(0);
        this.jLabel_LabelText.setIcon(new ImageIcon(this.getClass().getResource("/ControlImages/Text_white.png")));
        this.jLabel_LabelText.setMaximumSize(new Dimension(32, 32));
        this.jLabel_LabelText.setMinimumSize(new Dimension(32, 32));
        this.jLabel_LabelText.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_LabelText, gridBagConstraints);
        this.jTextField_BlockText.setText("label");
        this.jTextField_BlockText.setToolTipText("text");
        this.jTextField_BlockText.setPreferredSize(new Dimension(25, 20));
        this.jTextField_BlockText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JControlSettings_BlockModel.this.jTextField_BlockTextFocusLost(evt);
            }
        });
        this.jTextField_BlockText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JControlSettings_BlockModel.this.jTextField_BlockTextKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextField_BlockText, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(36, 110));
        this.jToolBar1.setMinimumSize(new Dimension(36, 110));
        this.jToolBar1.setOpaque(false);
        this.jToolBar1.setPreferredSize(new Dimension(36, 110));
        this.jButton_SelectBlockImage.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Image.png")));
        this.jButton_SelectBlockImage.setToolTipText("select label's image");
        this.jButton_SelectBlockImage.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectBlockImage.setContentAreaFilled(false);
        this.jButton_SelectBlockImage.setFocusable(false);
        this.jButton_SelectBlockImage.setHorizontalTextPosition(0);
        this.jButton_SelectBlockImage.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectBlockImage.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectBlockImage.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectBlockImage.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectBlockImage.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectBlockImage.setVerticalTextPosition(3);
        this.jButton_SelectBlockImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_SelectBlockImageActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectBlockImage);
        this.jButton_SelectBlockColor.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Colors.png")));
        this.jButton_SelectBlockColor.setToolTipText("select label's color");
        this.jButton_SelectBlockColor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectBlockColor.setContentAreaFilled(false);
        this.jButton_SelectBlockColor.setFocusable(false);
        this.jButton_SelectBlockColor.setHorizontalTextPosition(0);
        this.jButton_SelectBlockColor.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectBlockColor.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectBlockColor.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectBlockColor.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectBlockColor.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectBlockColor.setVerticalTextPosition(3);
        this.jButton_SelectBlockColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_SelectBlockColorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectBlockColor);
        this.jButton_SelectBlockText.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Text.png")));
        this.jButton_SelectBlockText.setToolTipText("select text");
        this.jButton_SelectBlockText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectBlockText.setContentAreaFilled(false);
        this.jButton_SelectBlockText.setFocusable(false);
        this.jButton_SelectBlockText.setHorizontalTextPosition(0);
        this.jButton_SelectBlockText.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectBlockText.setMaximumSize(new Dimension(34, 34));
        this.jButton_SelectBlockText.setMinimumSize(new Dimension(34, 34));
        this.jButton_SelectBlockText.setPreferredSize(new Dimension(34, 34));
        this.jButton_SelectBlockText.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectBlockText.setVerticalTextPosition(3);
        this.jButton_SelectBlockText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_SelectBlockTextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectBlockText);
        this.jButton_SelectBlockInvisible.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Invisible.png")));
        this.jButton_SelectBlockInvisible.setToolTipText("select text");
        this.jButton_SelectBlockInvisible.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_SelectBlockInvisible.setContentAreaFilled(false);
        this.jButton_SelectBlockInvisible.setFocusable(false);
        this.jButton_SelectBlockInvisible.setHorizontalTextPosition(0);
        this.jButton_SelectBlockInvisible.setMaximumSize(new Dimension(32, 32));
        this.jButton_SelectBlockInvisible.setMinimumSize(new Dimension(32, 32));
        this.jButton_SelectBlockInvisible.setPreferredSize(new Dimension(32, 32));
        this.jButton_SelectBlockInvisible.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SelectBlockInvisible.setVerticalTextPosition(3);
        this.jButton_SelectBlockInvisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_SelectBlockInvisibleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectBlockInvisible);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jToolBar2.setBorder(null);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jToolBar2.setOpaque(false);
        this.jButton_AddBlock.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddBlock.setToolTipText("add label");
        this.jButton_AddBlock.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_AddBlock.setContentAreaFilled(false);
        this.jButton_AddBlock.setFocusable(false);
        this.jButton_AddBlock.setHorizontalTextPosition(0);
        this.jButton_AddBlock.setMaximumSize(new Dimension(34, 34));
        this.jButton_AddBlock.setMinimumSize(new Dimension(34, 34));
        this.jButton_AddBlock.setPreferredSize(new Dimension(34, 34));
        this.jButton_AddBlock.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddBlock.setVerticalTextPosition(3);
        this.jButton_AddBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_AddBlockActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_AddBlock);
        this.jButton_RemoveBlock.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveBlock.setToolTipText("remove label");
        this.jButton_RemoveBlock.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_RemoveBlock.setContentAreaFilled(false);
        this.jButton_RemoveBlock.setFocusable(false);
        this.jButton_RemoveBlock.setHorizontalTextPosition(0);
        this.jButton_RemoveBlock.setMaximumSize(new Dimension(34, 34));
        this.jButton_RemoveBlock.setMinimumSize(new Dimension(34, 34));
        this.jButton_RemoveBlock.setPreferredSize(new Dimension(34, 34));
        this.jButton_RemoveBlock.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveBlock.setVerticalTextPosition(3);
        this.jButton_RemoveBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JControlSettings_BlockModel.this.jButton_RemoveBlockActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_RemoveBlock);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextFieldByte_ValueStart, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_Percent.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Percent, gridBagConstraints);
        this.jLabel_ValueRange.setHorizontalAlignment(2);
        this.jLabel_ValueRange.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_ValueRange, gridBagConstraints);
        this.jLabel_HighByte.setText("High-Low 0-255");
        this.jLabel_HighByte.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_HighByte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel_Header.setForeground(new Color(255, 255, 255));
        this.jLabel_Header.setHorizontalAlignment(0);
        this.jLabel_Header.setText("Blockade");
        this.jLabel_Header.setToolTipText("Blockade");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_Header, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jList_Blocks.setSelectionMode(0);
        this.jTextFieldByte_ValueEnd.addPropertyChangeListener(this);
        this.jTextFieldByte_ValueDefault.addPropertyChangeListener(this);
        this.jTextFieldByte_ValueStart.addPropertyChangeListener(this);
        this.setOnlyIntegerValues(this.m_OnlyInteger);
        this.jLabel_Header.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_AddBlock.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RemoveBlock.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectBlockColor.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectBlockImage.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectBlockInvisible.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_SelectBlockText.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jButton_AddBlock.setComponentPopupMenu(null);
        this.jButton_RemoveBlock.setComponentPopupMenu(null);
        this.jButton_SelectBlockColor.setComponentPopupMenu(null);
        this.jButton_SelectBlockImage.setComponentPopupMenu(null);
        this.jButton_SelectBlockInvisible.setComponentPopupMenu(null);
        this.jButton_SelectBlockText.setComponentPopupMenu(null);
        this.jTextFieldByte_ValueEnd.removePropertyChangeListener(this);
        this.jTextFieldByte_ValueDefault.removePropertyChangeListener(this);
        this.jTextFieldByte_ValueStart.removePropertyChangeListener(this);
        LiveLanguage.removeLanguageListener(this);
        this.setSelectedControlDimension(null);
        this.setControlObject(null);
        if (this.m_OldBlockLists != null) {
            this.m_OldBlockLists.clear();
        }
        LiveLanguage.removeLanguageListener(this);
    }

    public void setControlSetting_Dimension(JControlSettings_Dimension p_ControlSettings_Dimension) {
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.removePropertyChangeListener(this);
        }
        this.m_ControlSettings_Dimension = p_ControlSettings_Dimension;
        if (this.m_ControlSettings_Dimension != null) {
            this.m_ControlSettings_Dimension.addPropertyChangeListener(this);
            this.setControlObject(p_ControlSettings_Dimension.getControlObject());
            this.setSelectedControlDimension(p_ControlSettings_Dimension.getSelectedControlDimension());
        } else {
            this.setSelectedControlDimension(null);
            this.setControlObject(null);
        }
    }

    public void setControlObject(ControlObject p_ControlObject) {
        if (this.m_ControlObject == p_ControlObject) {
            return;
        }
        ControlObject oldValue = this.m_ControlObject;
        if (oldValue != null) {
            this.clear();
        }
        this.m_ControlObject = p_ControlObject;
        if (this.m_ControlObject == null) {
            this.clear();
            return;
        }
        this.firePropertyChange(PROP_CONTROLOBJECT, oldValue, this.m_ControlObject);
        this.m_SelectedControlDimension = null;
        this.setOldBlockLists();
        this.refresh();
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        if (this.m_OnlyInteger == p_OnlyIntegerValues) {
            return;
        }
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.jTextFieldByte_ValueEnd.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.jTextFieldByte_ValueDefault.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.jTextFieldByte_ValueStart.setOnlyIntegerValues(p_OnlyIntegerValues);
        this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
        if (this.m_SelectedControlDimension != null) {
            if (this.m_OnlyInteger) {
                this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
            } else {
                this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
            }
        }
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void setOldBlockLists() {
        this.m_OldBlockLists.clear();
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ArrayList<ControlBlockModel.ControlBlockList> o_OldDimensionBlockList = new ArrayList<ControlBlockModel.ControlBlockList>();
            this.m_OldBlockLists.add(o_OldDimensionBlockList);
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            ControlBlockModel o_ControlBlockModel = o_ControlDimension.getControlBlockModel();
            if (o_ControlBlockModel == null) continue;
            for (int intList = 0; intList < o_ControlBlockModel.getControlBlockListSize(); ++intList) {
                ControlBlockModel.ControlBlockList o_ControlBlockList = o_ControlBlockModel.getControlBlockList(intList).getCopy(o_ControlBlockModel);
                o_OldDimensionBlockList.add(o_ControlBlockList);
            }
        }
    }

    private void setSelectedControlDimension(ControlObject.ControlDimension p_ControlDimension) {
        if (this.m_SelectedControlDimension == p_ControlDimension) {
            return;
        }
        if (this.m_SelectedControlDimension != null) {
            this.setControlBlockModel(null);
        }
        ControlObject.ControlDimension oldValue = this.m_SelectedControlDimension;
        this.m_SelectedControlDimension = p_ControlDimension;
        if (this.m_SelectedControlDimension != null) {
            this.jTextFieldByte_ValueEnd.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.jTextFieldByte_ValueDefault.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.jTextFieldByte_ValueStart.setValueRange(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            ControlBlockModel o_ControlBlockModel = this.m_SelectedControlDimension.getControlBlockModel();
            this.setControlBlockModel(o_ControlBlockModel);
        }
        this.refresh();
    }

    public ControlObject getControlObject() {
        return this.m_ControlObject;
    }

    private void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
        if (this.m_ControlBlockModel != null) {
            this.m_ControlBlockModel.removePropertyChangeListener(this);
            this.setSelectedControlBlockList(null);
        }
        this.m_ControlBlockModel = p_ControlBlockModel;
        if (this.m_ControlBlockModel != null) {
            this.setOnlyIntegerValues(this.m_ControlBlockModel.getOnlyIntegerValues());
            this.m_ControlBlockModel.addPropertyChangeListener(this);
            ControlBlockModel.ControlBlockList o_ControlBlockList = this.m_ControlBlockModel.getSelectedControlBlockList();
            this.setSelectedControlBlockList(o_ControlBlockList);
        }
    }

    public void setSelectedControlBlockList(ControlBlockModel.ControlBlockList p_ControlLabelList) {
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.removePropertyChangeListener(this);
        }
        this.m_SelectedControlLabelList = p_ControlLabelList;
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.addPropertyChangeListener(this);
            this.jList_Blocks.setModel(this.m_SelectedControlLabelList);
            this.jList_Blocks.setCellRenderer(this.m_ControlBlockModel.getControlBlockDescriptionCellRenderer());
        }
    }

    public void cancel() {
        if (this.m_ControlObject == null) {
            return;
        }
        for (int intDimension = 0; intDimension < this.m_ControlObject.getControlDimensionCount(); ++intDimension) {
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlObject.getControlDimension(intDimension);
            ControlBlockModel o_ControlBlockModel = o_ControlDimension.getControlBlockModel();
            if (o_ControlBlockModel == null) continue;
            o_ControlBlockModel.clearControlBlockLists();
            ArrayList<ControlBlockModel.ControlBlockList> o_ControlBlockLists = this.m_OldBlockLists.get(intDimension);
            for (int intList = 0; intList < o_ControlBlockLists.size(); ++intList) {
                ControlBlockModel.ControlBlockList o_ControlBlockList = o_ControlBlockLists.get(intList);
                o_ControlBlockModel.addControlBlockList(o_ControlBlockList);
            }
            this.setOldBlockLists();
        }
    }

    public void save() {
        this.setOldBlockLists();
    }

    private void clear() {
        this.jList_Blocks.setCellRenderer(null);
        this.setSelectedBlockDescription(null);
        this.jButton_AddBlock.setEnabled(false);
    }

    private void refresh() {
        if (this.m_ControlObject == null || this.m_SelectedControlDimension == null) {
            this.clear();
            return;
        }
        ControlBlockModel o_ControlBlockModel = this.m_SelectedControlDimension.getControlBlockModel();
        if (o_ControlBlockModel == null) {
            o_ControlBlockModel = new ControlBlockModel(this.m_SelectedControlDimension.getValueMinimum(), this.m_SelectedControlDimension.getValueMaximum());
            this.m_SelectedControlDimension.setControlBlockModel(o_ControlBlockModel);
            this.setControlBlockModel(o_ControlBlockModel);
        }
        this.jButton_AddBlock.setEnabled(true);
        if (this.m_OnlyInteger) {
            this.jLabel_ValueRange.setText((int)this.m_SelectedControlDimension.getValueMinimum() + " - " + (int)this.m_SelectedControlDimension.getValueMaximum());
        } else {
            this.jLabel_ValueRange.setText(this.m_SelectedControlDimension.getValueMinimum() + " - " + this.m_SelectedControlDimension.getValueMaximum());
        }
    }

    private void setSelectedBlockDescription(ControlBlockModel.ControlBlockDescription p_BlockDescription) {
        ControlBlockModel.ControlBlockList o_ControlBlockList;
        this.m_SelectedBlockDescription = p_BlockDescription;
        if (this.m_SelectedBlockDescription == null) {
            this.jTextFieldByte_ValueEnd.setValue(0.0);
            this.jTextFieldByte_ValueEnd.setEnabled(false);
            this.jTextFieldByte_ValueDefault.setValue(0.0);
            this.jTextFieldByte_ValueDefault.setEnabled(false);
            this.jTextFieldByte_ValueStart.setValue(0.0);
            this.jTextFieldByte_ValueStart.setEnabled(false);
            this.jTextField_BlockText.setText("");
            this.jTextField_BlockText.setEnabled(false);
            this.m_BlockColor = null;
            this.m_BlockImage = null;
            this.jButton_RemoveBlock.setEnabled(false);
            this.jButton_SelectBlockImage.setEnabled(false);
            this.jButton_SelectBlockColor.setEnabled(false);
            this.jButton_SelectBlockText.setEnabled(false);
            this.jButton_SelectBlockInvisible.setEnabled(false);
        } else {
            this.jTextFieldByte_ValueEnd.setValue(p_BlockDescription.getValueEnd());
            this.jTextFieldByte_ValueEnd.setEnabled(true);
            this.jTextFieldByte_ValueDefault.setValue(p_BlockDescription.getValueDefault());
            this.jTextFieldByte_ValueDefault.setEnabled(true);
            this.jTextFieldByte_ValueStart.setValue(p_BlockDescription.getValueStart());
            this.jTextFieldByte_ValueStart.setEnabled(true);
            this.jTextField_BlockText.setText(p_BlockDescription.getBlockText());
            this.jTextField_BlockText.setEnabled(true);
            this.m_BlockColor = this.m_SelectedBlockDescription.getBlockColor();
            this.m_BlockImage = this.m_SelectedBlockDescription.getBlockImage();
            this.jButton_RemoveBlock.setEnabled(true);
            this.jButton_SelectBlockImage.setEnabled(true);
            this.jButton_SelectBlockColor.setEnabled(true);
            this.jButton_SelectBlockText.setEnabled(true);
            this.jButton_SelectBlockInvisible.setEnabled(true);
        }
        this.refreshBlockIcon();
        this.jList_Blocks.setSelectedValue(this.m_SelectedBlockDescription, true);
        if (this.m_ControlBlockModel != null && (o_ControlBlockList = this.m_ControlBlockModel.getSelectedControlBlockList()) != null) {
            o_ControlBlockList.setSelectedItem(this.m_SelectedBlockDescription);
        }
    }

    private void refreshBlockIcon() {
        boolean boolVisible;
        if (this.m_SelectedBlockDescription == null) {
            this.jLabel_BlockIcon.setText("");
            this.jLabel_BlockIcon.setToolTipText(null);
            boolVisible = false;
        } else {
            this.jLabel_BlockIcon.setText(this.m_SelectedBlockDescription.getBlockText());
            this.jLabel_BlockIcon.setToolTipText(this.m_SelectedBlockDescription.getBlockText());
            boolVisible = this.m_SelectedBlockDescription.getVisible();
        }
        this.jLabel_BlockIcon.setBackgroundStyle(0);
        this.jLabel_BlockIcon.setBackgroundOpaque(false);
        this.jLabel_BlockIcon.setBackground(this.m_BlockColor);
        if (this.m_BlockColor != null) {
            this.jLabel_BlockIcon.setBackgroundOpaque(true);
            this.jLabel_BlockIcon.setText("");
        }
        this.jLabel_BlockIcon.setBackgroundImage(this.m_BlockImage);
        if (this.m_BlockImage != null) {
            this.jLabel_BlockIcon.setBackgroundStyle(3);
            this.jLabel_BlockIcon.setBackgroundOpaque(true);
            this.jLabel_BlockIcon.setText("");
        }
        if (!boolVisible) {
            this.jLabel_BlockIcon.setText("");
            this.jLabel_BlockIcon.setBackgroundOpaque(false);
        }
    }

    public static void setDefaultStartValue(double p_Value) {
        s_DefaultStartValue = p_Value;
    }

    public static void setDefaultEndValue(double p_Value) {
        s_DefaultEndValue = p_Value;
    }

    public static void setDefaultValue(double p_Value) {
        s_DefaultValue = p_Value;
    }

    private void jList_BlocksValueChanged(ListSelectionEvent evt) {
        ControlBlockModel.ControlBlockDescription o_ControlBlockDescription = (ControlBlockModel.ControlBlockDescription)this.jList_Blocks.getSelectedValue();
        if (this.m_SelectedBlockDescription != o_ControlBlockDescription) {
            try {
                if (this.m_SelectedBlockDescription != null) {
                    this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setSelectedBlockDescription(o_ControlBlockDescription);
        }
    }

    private void jButton_SelectBlockImageActionPerformed(ActionEvent evt) {
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        BufferedImage o_BufferedImage = ImagesTools.loadImageFileDialog((String)LOADIMAGE, (Component)this);
        if (o_BufferedImage == null) {
            return;
        }
        this.m_BlockColor = null;
        if (this.m_BlockImage != null) {
            this.m_BlockImage.flush();
        }
        this.m_BlockImage = ImagesTools.convertToBufferedImage((Image)o_BufferedImage, (Dimension)ControlBlockModel.DIMENSION_BIG);
        this.m_SelectedBlockDescription.setBlockImage(this.m_BlockImage);
        this.m_SelectedBlockDescription.setVisible(true);
        o_BufferedImage.flush();
        o_BufferedImage = null;
        this.refreshBlockIcon();
    }

    private void jButton_SelectBlockColorActionPerformed(ActionEvent evt) {
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        Color o_Color = JColorChooser.showDialog(this, "LabelColor", this.m_BlockColor);
        if (o_Color == null) {
            return;
        }
        this.m_BlockImage = null;
        this.m_BlockColor = o_Color;
        this.m_SelectedBlockDescription.setBlockColor(this.m_BlockColor);
        this.m_SelectedBlockDescription.setVisible(true);
        this.refreshBlockIcon();
    }

    private void jButton_SelectBlockTextActionPerformed(ActionEvent evt) {
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        this.m_BlockImage = null;
        this.m_BlockColor = null;
        this.m_SelectedBlockDescription.setBlockColor(null);
        this.m_SelectedBlockDescription.setBlockImage(null);
        this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
        this.m_SelectedBlockDescription.setVisible(true);
        this.refreshBlockIcon();
    }

    private void jButton_AddBlockActionPerformed(ActionEvent evt) {
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        ControlBlockModel o_ControlBlockModel = this.m_SelectedControlDimension.getControlBlockModel();
        if (o_ControlBlockModel == null) {
            return;
        }
        if (this.m_SelectedBlockDescription != null) {
            this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
        }
        ControlBlockModel.ControlBlockDescription o_ControlBlockDescription = o_ControlBlockModel.createControlBlockDescription(s_DefaultStartValue, s_DefaultEndValue, (Double)s_DefaultValue, "xyz");
        this.jList_Blocks.setSelectedValue(o_ControlBlockDescription, true);
        this.setSelectedBlockDescription(o_ControlBlockDescription);
    }

    private void jButton_RemoveBlockActionPerformed(ActionEvent evt) {
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        if (this.m_SelectedControlDimension == null) {
            return;
        }
        ControlBlockModel.ControlBlockDescription o_ControlBlockDescription = this.m_SelectedBlockDescription;
        this.jList_Blocks.clearSelection();
        int intIndex = this.m_SelectedControlDimension.getControlBlockModel().getIndexOf(o_ControlBlockDescription);
        this.m_SelectedControlDimension.getControlBlockModel().removeControlBlockDescription(o_ControlBlockDescription);
        if (intIndex < 0) {
            intIndex = 0;
        }
        if (intIndex >= this.m_SelectedControlDimension.getControlBlockModel().getControlBlockDescriptionSize()) {
            intIndex = this.m_SelectedControlDimension.getControlBlockModel().getControlBlockDescriptionSize() - 1;
        }
        if (intIndex >= 0) {
            o_ControlBlockDescription = this.m_SelectedControlDimension.getControlBlockModel().getControlBlockDescription(intIndex);
            this.jList_Blocks.setSelectedValue(o_ControlBlockDescription, true);
            this.setSelectedBlockDescription(o_ControlBlockDescription);
        }
    }

    private void jTextField_BlockTextFocusLost(FocusEvent evt) {
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        try {
            this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton_SelectBlockInvisibleActionPerformed(ActionEvent evt) {
        this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
        if (this.m_SelectedBlockDescription == null) {
            return;
        }
        if (this.m_SelectedBlockDescription.getVisible()) {
            this.m_SelectedBlockDescription.setVisible(false);
        } else {
            this.m_SelectedBlockDescription.setVisible(true);
        }
        this.refreshBlockIcon();
    }

    private void jTextField_BlockTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.m_SelectedBlockDescription == null) {
                return;
            }
            try {
                this.m_SelectedBlockDescription.setBlockText(this.jTextField_BlockText.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.jTextFieldByte_ValueEnd) {
            if (this.m_SelectedBlockDescription == null) {
                return;
            }
            this.m_SelectedBlockDescription.setValueEnd(this.jTextFieldByte_ValueEnd.getValue());
        } else if (evt.getSource() == this.jTextFieldByte_ValueDefault) {
            if (this.m_SelectedBlockDescription == null) {
                return;
            }
            this.m_SelectedBlockDescription.setValueDefault(this.jTextFieldByte_ValueDefault.getValue());
        } else if (evt.getSource() == this.jTextFieldByte_ValueStart) {
            if (this.m_SelectedBlockDescription == null) {
                return;
            }
            this.m_SelectedBlockDescription.setValueStart(this.jTextFieldByte_ValueStart.getValue());
        } else if (evt.getSource() instanceof JControlSettings_Dimension) {
            if (PROP_CONTROLOBJECT.equals(evt.getPropertyName())) {
                this.setControlObject((ControlObject)evt.getNewValue());
            } else if (PROP_CONTROLDIMENSION.equals(evt.getPropertyName())) {
                this.setSelectedControlDimension((ControlObject.ControlDimension)evt.getNewValue());
            }
        } else if (evt.getSource() instanceof ControlBlockModel) {
            if ("listSelected".equals(evt.getPropertyName())) {
                if (this.m_SelectedControlDimension == null) {
                    return;
                }
                ControlBlockModel o_ControlBlockModel = this.m_SelectedControlDimension.getControlBlockModel();
                this.setControlBlockModel(o_ControlBlockModel);
            }
        } else if (evt.getSource() instanceof ControlBlockModel.ControlBlockList) {
            if ("blockValueStart".equals(evt.getPropertyName())) {
                this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
            } else if ("blockValueDefault".equals(evt.getPropertyName())) {
                this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
            } else if ("blockValueEnd".equals(evt.getPropertyName())) {
                this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
            } else if ("blockProperties".equals(evt.getPropertyName())) {
                this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
            } else if ("blockDescriptionResorted".equals(evt.getPropertyName())) {
                this.setSelectedBlockDescription(this.m_SelectedBlockDescription);
            }
        }
    }
}

