/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaPlayer_Image;
import ToolsGraphics.ImagesTools;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class LiveShow_ImagePool {
    private static HashMap<String, ImageElement> s_ImageElements = new HashMap();
    private static Object s_SyncImageElements = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        ImageElement o_ImageElement;
        if (p_LiveShow_MediaPlayer == null) {
            return;
        }
        MediaSource o_MediaSource = p_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return;
        }
        Object object = s_SyncImageElements;
        synchronized (object) {
            o_ImageElement = s_ImageElements.get(o_MediaSource.getFilePath());
            if (o_ImageElement == null) {
                o_ImageElement = new ImageElement(o_MediaSource.getFilePath());
                s_ImageElements.put(o_MediaSource.getFilePath(), o_ImageElement);
            }
        }
        o_ImageElement.addLiveShow_MediaPlayer(p_LiveShow_MediaPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        ImageElement o_ImageElement;
        if (p_LiveShow_MediaPlayer == null) {
            return;
        }
        MediaSource o_MediaSource = p_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return;
        }
        Object object = s_SyncImageElements;
        synchronized (object) {
            o_ImageElement = s_ImageElements.get(o_MediaSource.getFilePath());
            if (o_ImageElement == null) {
                return;
            }
            o_ImageElement.removeLiveShow_MediaPlayer(p_LiveShow_MediaPlayer);
            if (o_ImageElement.getLiveShow_MediaPlayerCount() <= 0) {
                s_ImageElements.remove(o_ImageElement.getFilePathName());
                o_ImageElement.close();
            }
        }
        o_ImageElement.removeLiveShow_MediaPlayer(p_LiveShow_MediaPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImage(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        ImageElement o_ImageElement;
        if (p_LiveShow_MediaPlayer == null) {
            return null;
        }
        MediaSource o_MediaSource = p_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return null;
        }
        Object object = s_SyncImageElements;
        synchronized (object) {
            o_ImageElement = s_ImageElements.get(o_MediaSource.getFilePath());
            if (o_ImageElement == null) {
                return null;
            }
        }
        return o_ImageElement.getBufferedImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSyncImage(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        ImageElement o_ImageElement;
        if (p_LiveShow_MediaPlayer == null) {
            return null;
        }
        MediaSource o_MediaSource = p_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return null;
        }
        Object object = s_SyncImageElements;
        synchronized (object) {
            o_ImageElement = s_ImageElements.get(o_MediaSource.getFilePath());
            if (o_ImageElement == null) {
                return null;
            }
        }
        return o_ImageElement.getSyncImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageElement getImageElement(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        ImageElement o_ImageElement;
        if (p_LiveShow_MediaPlayer == null) {
            return null;
        }
        MediaSource o_MediaSource = p_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return null;
        }
        Object object = s_SyncImageElements;
        synchronized (object) {
            o_ImageElement = s_ImageElements.get(o_MediaSource.getFilePath());
        }
        return o_ImageElement;
    }

    public static class ImageElement
    implements LiveShow_MediaPlayer.MediaImage {
        private String m_FilePathName;
        private BufferedImage m_BufferedImage;
        private Dimension m_ImageSize;
        private Dimension m_OriginSize;
        private Dimension m_RenderSize;
        private ArrayList<LiveShow_MediaPlayer> m_LiveShow_MediaPlayers;
        private final Object m_SyncmediaPlayers = new Object();
        private final Object m_SyncImage = new Object();

        public ImageElement(String p_FilePathName) {
            this.initMembers();
            if (p_FilePathName == null) {
                p_FilePathName = "";
            }
            this.m_FilePathName = p_FilePathName;
            this.m_ImageSize = ImagesTools.getImageSize_WithoutLoad((File)new File(this.m_FilePathName));
        }

        private void initMembers() {
            this.m_FilePathName = "";
            this.m_BufferedImage = null;
            this.m_OriginSize = new Dimension(0, 0);
            this.m_RenderSize = new Dimension(0, 0);
            this.m_LiveShow_MediaPlayers = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncmediaPlayers;
            synchronized (object) {
                this.m_LiveShow_MediaPlayers.clear();
            }
            this.closeImage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeImage() {
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_BufferedImage != null) {
                    this.m_BufferedImage.flush();
                    this.m_BufferedImage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean load(Dimension p_RenderSize) {
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_BufferedImage != null) {
                    this.m_BufferedImage.flush();
                    this.m_BufferedImage = null;
                }
                if (p_RenderSize != null) {
                    this.m_RenderSize.setSize(p_RenderSize);
                }
                try {
                    this.m_BufferedImage = ImagesTools.loadImage((File)new File(this.m_FilePathName));
                    if (this.m_BufferedImage == null) {
                        return false;
                    }
                    this.m_OriginSize.setSize(this.m_BufferedImage.getWidth(), this.m_BufferedImage.getHeight());
                }
                catch (Exception e) {
                    this.m_BufferedImage = null;
                    this.m_OriginSize.setSize(0, 0);
                    return false;
                }
                if (this.m_BufferedImage == null) {
                    this.m_OriginSize.setSize(0, 0);
                    return false;
                }
                if (this.m_BufferedImage.getWidth() != this.m_RenderSize.width || this.m_BufferedImage.getHeight() != this.m_RenderSize.height) {
                    this.m_BufferedImage = ImagesTools.resizeImage((Image)this.m_BufferedImage, (int)this.m_RenderSize.width, (int)this.m_RenderSize.height);
                    this.m_OriginSize.setSize(this.m_BufferedImage.getWidth(), this.m_BufferedImage.getHeight());
                }
                return true;
            }
        }

        public Object getSyncImage() {
            return this.m_SyncImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImage getBufferedImage() {
            Object object = this.m_SyncImage;
            synchronized (object) {
                return this.m_BufferedImage;
            }
        }

        @Override
        public long getImageNumber() {
            return 0L;
        }

        @Override
        public long getTimeStamp() {
            return 0L;
        }

        public Dimension getImageSize() {
            return this.m_ImageSize;
        }

        public Dimension getOriginSize() {
            return this.m_OriginSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestSnapShot(String p_ID, BufferedImage p_SnapShotImage, Rectangle p_SnapShotRect, long p_Milliseconds, LiveShow_MediaPlayer.SnapshotEventListener p_SnapshotEventListener) {
            if (p_SnapShotImage == null) {
                return false;
            }
            Object object = this.m_SyncImage;
            synchronized (object) {
                int intNewWidth;
                int intNewHeight;
                double doubleWidthFactor;
                double doubleHeightFactor;
                BufferedImage o_BufferedImage = this.getBufferedImage();
                if (o_BufferedImage == null) {
                    this.load(new Dimension(p_SnapShotImage.getWidth(), p_SnapShotImage.getHeight()));
                    o_BufferedImage = this.getBufferedImage();
                    if (o_BufferedImage == null) {
                        return false;
                    }
                }
                if ((doubleHeightFactor = (double)p_SnapShotImage.getHeight() / (double)o_BufferedImage.getHeight()) < (doubleWidthFactor = (double)p_SnapShotImage.getWidth() / (double)o_BufferedImage.getWidth())) {
                    intNewHeight = (int)((double)o_BufferedImage.getHeight() * doubleHeightFactor);
                    intNewWidth = (int)((double)o_BufferedImage.getWidth() * doubleHeightFactor);
                } else {
                    intNewHeight = (int)((double)o_BufferedImage.getHeight() * doubleWidthFactor);
                    intNewWidth = (int)((double)o_BufferedImage.getWidth() * doubleWidthFactor);
                }
                int intX = (p_SnapShotImage.getWidth() - intNewWidth) / 2;
                int intY = (p_SnapShotImage.getHeight() - intNewHeight) / 2;
                Graphics2D o_Graphics2D = p_SnapShotImage.createGraphics();
                o_Graphics2D.setBackground(LiveShow_MediaPlayer_Image.COLOR_TRANSPARENT);
                o_Graphics2D.clearRect(0, 0, p_SnapShotImage.getWidth(), p_SnapShotImage.getHeight());
                o_Graphics2D.dispose();
                o_Graphics2D = p_SnapShotImage.createGraphics();
                if (o_Graphics2D == null) {
                    return false;
                }
                o_Graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                o_Graphics2D.drawImage(o_BufferedImage, intX, intY, intX + intNewWidth, intY + intNewHeight, 0, 0, o_BufferedImage.getWidth(), o_BufferedImage.getHeight(), null);
                o_Graphics2D.dispose();
                if (p_SnapShotRect == null) {
                    p_SnapShotRect = new Rectangle();
                }
                p_SnapShotRect.setRect(intX, intY, intNewWidth, intNewHeight);
            }
            p_SnapshotEventListener.eventSnapshotImage(p_ID, p_Milliseconds, p_SnapShotImage, p_SnapShotRect);
            return true;
        }

        public String getFilePathName() {
            return this.m_FilePathName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
            if (p_LiveShow_MediaPlayer == null) {
                return;
            }
            Object object = this.m_SyncmediaPlayers;
            synchronized (object) {
                if (this.m_LiveShow_MediaPlayers.contains(p_LiveShow_MediaPlayer)) {
                    return;
                }
                this.m_LiveShow_MediaPlayers.add(p_LiveShow_MediaPlayer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
            if (p_LiveShow_MediaPlayer == null) {
                return;
            }
            Object object = this.m_SyncmediaPlayers;
            synchronized (object) {
                this.m_LiveShow_MediaPlayers.remove(p_LiveShow_MediaPlayer);
            }
        }

        public int getLiveShow_MediaPlayerCount() {
            return this.m_LiveShow_MediaPlayers.size();
        }
    }
}

