/*
 * Decompiled with CFR 0.152.
 */
package LicensePackage;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class MacNetworkInterfaces {
    private static final int NETWORKINTERFACE_TYPE_UNKNOWN = 0;
    private static final int NETWORKINTERFACE_TYPE_HARDWARE = 1;
    private static final int NETWORKINTERFACE_TYPE_LOOPBACK = 2;
    private static final int NETWORKINTERFACE_TYPE_VIRTUAL = 3;
    private static final int NETWORKINTERFACE_TYPE_PSEUDO = 4;
    private static final int NETWORKINTERFACE_TYPE_INTERNAL = 5;
    private static NetworkInterfaceWrapper s_DefaultNetworkInterfaceWrapper;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_Hardware;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_Virtual;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_Pseudo;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_Internal;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_LoopBack;
    private static ArrayList<NetworkInterfaceWrapper> s_NetworkInterfaceWrappers_Unknown;
    private static final Object s_SyncObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNetworkInterfaces() {
        Enumeration<NetworkInterface> o_NetworkInterfaces = null;
        Object object = s_SyncObject;
        synchronized (object) {
            s_DefaultNetworkInterfaceWrapper = null;
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_Hardware);
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_Internal);
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_LoopBack);
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_Pseudo);
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_Virtual);
            MacNetworkInterfaces.clear(s_NetworkInterfaceWrappers_Unknown);
            try {
                o_NetworkInterfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (Exception e) {
                o_NetworkInterfaces = null;
            }
            if (o_NetworkInterfaces == null || !o_NetworkInterfaces.hasMoreElements()) {
                return;
            }
            while (o_NetworkInterfaces.hasMoreElements()) {
                NetworkInterface o_NetworkInterface = o_NetworkInterfaces.nextElement();
                NetworkInterfaceWrapper o_NetworkInterfaceWrapper = new NetworkInterfaceWrapper(o_NetworkInterface);
                if (o_NetworkInterfaceWrapper.isDefault() && (s_DefaultNetworkInterfaceWrapper == null || s_DefaultNetworkInterfaceWrapper.getMacAddress().length() < 8)) {
                    s_DefaultNetworkInterfaceWrapper = o_NetworkInterfaceWrapper;
                }
                if (o_NetworkInterfaceWrapper.isTypeHardware()) {
                    MacNetworkInterfaces.add(s_NetworkInterfaceWrappers_Hardware, o_NetworkInterfaceWrapper);
                }
                if (o_NetworkInterfaceWrapper.isTypeInternal()) {
                    MacNetworkInterfaces.add(s_NetworkInterfaceWrappers_Internal, o_NetworkInterfaceWrapper);
                }
                if (o_NetworkInterfaceWrapper.isTypeLoopBack()) {
                    MacNetworkInterfaces.add(s_NetworkInterfaceWrappers_LoopBack, o_NetworkInterfaceWrapper);
                }
                if (o_NetworkInterfaceWrapper.isTypePseudo()) {
                    MacNetworkInterfaces.add(s_NetworkInterfaceWrappers_Pseudo, o_NetworkInterfaceWrapper);
                }
                if (!o_NetworkInterfaceWrapper.isTypeUnknown()) continue;
                MacNetworkInterfaces.add(s_NetworkInterfaceWrappers_Unknown, o_NetworkInterfaceWrapper);
            }
        }
    }

    private static void clear(ArrayList<NetworkInterfaceWrapper> p_NetworkInterfaceWrappers) {
        if (p_NetworkInterfaceWrappers == null) {
            return;
        }
        for (int intWrapper = p_NetworkInterfaceWrappers.size() - 1; intWrapper >= 0; --intWrapper) {
            NetworkInterfaceWrapper o_NetworkInterfaceWrapper = p_NetworkInterfaceWrappers.get(intWrapper);
            if (o_NetworkInterfaceWrapper != null) {
                o_NetworkInterfaceWrapper.close();
            }
            p_NetworkInterfaceWrappers.remove(intWrapper);
        }
    }

    private static void add(ArrayList<NetworkInterfaceWrapper> p_NetworkInterfaceWrappers, NetworkInterfaceWrapper p_NetworkInterfaceWrapper) {
        if (p_NetworkInterfaceWrappers == null) {
            return;
        }
        if (p_NetworkInterfaceWrapper == null) {
            return;
        }
        boolean boolFound = false;
        NetworkInterface o_NetworkInterfaceToAdd = p_NetworkInterfaceWrapper.getNetworkInterface();
        for (int intWrapper = 0; intWrapper < p_NetworkInterfaceWrappers.size(); ++intWrapper) {
            NetworkInterfaceWrapper o_NetworkInterfaceWrapper = p_NetworkInterfaceWrappers.get(intWrapper);
            NetworkInterface o_NetworkInterface = o_NetworkInterfaceWrapper.getNetworkInterface();
            if (o_NetworkInterface == null || !o_NetworkInterface.equals(o_NetworkInterfaceToAdd)) continue;
            boolFound = true;
            break;
        }
        if (!boolFound) {
            if (p_NetworkInterfaceWrapper.isDefault()) {
                p_NetworkInterfaceWrappers.add(0, p_NetworkInterfaceWrapper);
            } else {
                p_NetworkInterfaceWrappers.add(p_NetworkInterfaceWrapper);
            }
        }
    }

    public static NetworkInterfaceWrapper getDefaultNetworkInterfaceWrapper() {
        return s_DefaultNetworkInterfaceWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_Hardware() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_Hardware.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_Hardware);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_LoopBack() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_LoopBack.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_LoopBack);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_Internal() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_Internal.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_Internal);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_Pseudo() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_Pseudo.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_Pseudo);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_Virual() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_Virtual.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_Virtual);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterfaceWrapper> getNetworkInterfaceWrappers_Unknown() {
        ArrayList<NetworkInterfaceWrapper> o_NetworkInterfaceWrappers;
        Object object = s_SyncObject;
        synchronized (object) {
            o_NetworkInterfaceWrappers = new ArrayList<NetworkInterfaceWrapper>(s_NetworkInterfaceWrappers_Unknown.size());
            o_NetworkInterfaceWrappers.addAll(s_NetworkInterfaceWrappers_Unknown);
        }
        return o_NetworkInterfaceWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printInfo() {
        Object object = s_SyncObject;
        synchronized (object) {
            NetworkInterfaceWrapper o_NetworkInterface;
            int intInterface;
            System.out.println("DEFAULT NETWORKINTERFACES");
            if (s_DefaultNetworkInterfaceWrapper == null) {
                System.out.print("---");
            } else {
                MacNetworkInterfaces.printNetworkInterfaceInfo(s_DefaultNetworkInterfaceWrapper);
            }
            System.out.println();
            System.out.println("HARDWARE NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_Hardware.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_Hardware.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
            System.out.println("PSEUDO NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_Pseudo.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_Pseudo.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
            System.out.println("Internal NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_Internal.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_Internal.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
            System.out.println("VIRTUAL NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_Virtual.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_Virtual.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
            System.out.println("LOOPBACK NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_LoopBack.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_LoopBack.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
            System.out.println("UNKNOWN NETWORKINTERFACES");
            for (intInterface = 0; intInterface < s_NetworkInterfaceWrappers_Unknown.size(); ++intInterface) {
                o_NetworkInterface = s_NetworkInterfaceWrappers_Unknown.get(intInterface);
                MacNetworkInterfaces.printNetworkInterfaceInfo(o_NetworkInterface);
                System.out.println();
            }
            System.out.println();
        }
    }

    public static void printNetworkInterfaceInfo(NetworkInterfaceWrapper p_NetworkInterfaceWrapper) {
        if (p_NetworkInterfaceWrapper == null) {
            return;
        }
        NetworkInterface o_NetworkInterface = p_NetworkInterfaceWrapper.getNetworkInterface();
        if (o_NetworkInterface == null) {
            return;
        }
        System.out.println(p_NetworkInterfaceWrapper.getDisplayName() + "(" + p_NetworkInterfaceWrapper.getName() + "):");
        System.out.print("      IsUP: ");
        System.out.println(p_NetworkInterfaceWrapper.isUp());
        System.out.print("      MAC Address: ");
        String stringMacAddress = p_NetworkInterfaceWrapper.getMacAddress();
        System.out.println(stringMacAddress);
        System.out.print("      IP Addresses: ");
        Enumeration<InetAddress> o_InetAddresses = o_NetworkInterface.getInetAddresses();
        boolean boolFirst = true;
        while (o_InetAddresses.hasMoreElements()) {
            InetAddress o_InetAddress = o_InetAddresses.nextElement();
            if (!boolFirst) {
                System.out.print(", ");
            }
            System.out.print(o_InetAddress.getHostAddress());
            boolFirst = false;
        }
        System.out.println();
    }

    public static String getMacAddress(NetworkInterface p_NetworkInterface) {
        byte[] bytesHardwareAddress;
        if (p_NetworkInterface == null) {
            return "";
        }
        try {
            bytesHardwareAddress = p_NetworkInterface.getHardwareAddress();
        }
        catch (Exception e) {
            return "";
        }
        return MacNetworkInterfaces.getMacAddress(bytesHardwareAddress);
    }

    public static String getMacAddress(byte[] p_HardwareAddress) {
        if (p_HardwareAddress == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int i = 0; i < p_HardwareAddress.length; ++i) {
            o_StringBuilder.append(String.format("%02X%s", p_HardwareAddress[i], i < p_HardwareAddress.length - 1 ? "-" : ""));
        }
        return o_StringBuilder.toString();
    }

    static {
        s_NetworkInterfaceWrappers_Hardware = new ArrayList();
        s_NetworkInterfaceWrappers_Virtual = new ArrayList();
        s_NetworkInterfaceWrappers_Pseudo = new ArrayList();
        s_NetworkInterfaceWrappers_Internal = new ArrayList();
        s_NetworkInterfaceWrappers_LoopBack = new ArrayList();
        s_NetworkInterfaceWrappers_Unknown = new ArrayList();
        s_SyncObject = new Object();
    }

    public static class NetworkInterfaceWrapper {
        private NetworkInterface m_NetworkInterface;
        private boolean m_IsDefault;
        private String m_MacAddress;
        private byte[] m_HardwareAddress;
        private int m_NetworkInterface_Type;

        public NetworkInterfaceWrapper(NetworkInterface p_NetworkInterface) {
            this.initMembers();
            this.m_NetworkInterface = p_NetworkInterface;
            this.checkNetworkInterface();
        }

        private void initMembers() {
            this.m_NetworkInterface = null;
            this.m_NetworkInterface_Type = 0;
            this.m_IsDefault = false;
            this.m_MacAddress = "";
            this.m_HardwareAddress = null;
        }

        public void close() {
            this.initMembers();
        }

        public void checkNetworkInterface() {
            if (this.m_NetworkInterface == null) {
                this.m_MacAddress = "";
                this.m_HardwareAddress = null;
                this.m_IsDefault = false;
                this.m_NetworkInterface_Type = 0;
                return;
            }
            try {
                this.m_HardwareAddress = this.m_NetworkInterface.getHardwareAddress();
                this.m_MacAddress = MacNetworkInterfaces.getMacAddress(this.m_NetworkInterface);
            }
            catch (Exception e) {
                this.m_HardwareAddress = null;
                this.m_MacAddress = "";
            }
            try {
                InetAddress o_LocalHost = InetAddress.getLocalHost();
                NetworkInterface o_NetworkInterfaceDefault = NetworkInterface.getByInetAddress(o_LocalHost);
                if (o_NetworkInterfaceDefault != null && this.m_NetworkInterface.equals(o_NetworkInterfaceDefault)) {
                    this.m_IsDefault = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.m_NetworkInterface.isLoopback()) {
                    this.m_NetworkInterface_Type = 2;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_NetworkInterface_Type = this.m_NetworkInterface.isVirtual() ? 3 : (this.m_HardwareAddress == null ? 5 : (this.m_HardwareAddress.length >= 3 && this.m_HardwareAddress[0] == 0 && this.m_HardwareAddress[1] == 0 && this.m_HardwareAddress[2] == 0 ? 4 : 1));
        }

        public NetworkInterface getNetworkInterface() {
            return this.m_NetworkInterface;
        }

        public String getMacAddress() {
            return this.m_MacAddress;
        }

        public byte[] getHardwareAddress() {
            return (byte[])this.m_HardwareAddress.clone();
        }

        public String getName() {
            NetworkInterface o_NetworkInterface = this.m_NetworkInterface;
            if (o_NetworkInterface == null) {
                return "";
            }
            return o_NetworkInterface.getName();
        }

        public String getDisplayName() {
            NetworkInterface o_NetworkInterface = this.m_NetworkInterface;
            if (o_NetworkInterface == null) {
                return "";
            }
            return o_NetworkInterface.getDisplayName();
        }

        public boolean isDefault() {
            return this.m_IsDefault;
        }

        public boolean isTypeHardware() {
            return this.m_NetworkInterface_Type == 1;
        }

        public boolean isTypeLoopBack() {
            return this.m_NetworkInterface_Type == 2;
        }

        public boolean isTypeInternal() {
            return this.m_NetworkInterface_Type == 5;
        }

        public boolean isTypePseudo() {
            return this.m_NetworkInterface_Type == 4;
        }

        public boolean isTypeUnknown() {
            return this.m_NetworkInterface_Type == 0;
        }

        public boolean isUp() {
            NetworkInterface o_NetworkInterface = this.m_NetworkInterface;
            if (o_NetworkInterface == null) {
                return false;
            }
            try {
                return o_NetworkInterface.isUp();
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

