/*
 * Decompiled with CFR 0.152.
 */
package LicensePackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LicenseGraphicPackage.JDialog_License;
import LicenseGraphicPackage.LicenseUnlock;
import LicensePackage.MacNetworkInterfaces;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class License {
    public static final ImageIcon s_ImageIcon = new ImageIcon(License.class.getResource("/LicenseGraphicPackage/LiveShow_Icon_show_small.png"));
    public static final int SOFTWAREVERSION = 2;
    @LiveLanguageString
    public static String LICENSE_HEADER_DEMO = "Demo-Version";
    @LiveLanguageString
    public static String LICENSE_BUTTON_LICENSE = "  license  ";
    @LiveLanguageString
    public static String LICENSE_HEADER_DEMO_FINISHED = "Demo-Version Finished";
    @LiveLanguageString
    public static String LICENSE_HRADER_LICENSED = "Licensed:";
    @LiveLanguageString
    public static String LICENSE_UNLOCK_HELP_1 = "<html>1.) log in at www.liveshowsoftware.de<br>2.) at menu 'License' enter the Code: </html>";
    @LiveLanguageString
    public static String LICENSE_UNLOCK_HELP_2 = "<html>3.) enter the diplayed unlock code: </html>";
    public static final int LICENSETYPE_DEMOMODE_DAYS = 10;
    public static final int LICENSETYPE_DEMOMODE_DAYS_DEFAULT = 30;
    @LiveLanguageString
    public static String LICENSE_DEMOCONTENT_DAYS_LEFT = "Days left:";
    public static final int LICENSETYPE_DEMOMODE_STARTDAYS = 11;
    public static final int LICENSETYPE_DEMOMODE_STARTDAYS_DEFAULT = 15;
    @LiveLanguageString
    public static String LICENSE_DEMOCONTENT_STARTDAYS_LEFT = "Start Days left:";
    public static final int DEFAULTLICENSETYPE = 11;
    private static String DEMOMODE_FILESTART = ".profilelsl/profile.dat";
    private static String CODE_CHARACTERS = "0123456789ABCDEFHIJKLMNPQRSTUVWXYZ";
    private static int MACADDRESSEPART_LENGTH = 6;
    private static String MACADDRESSEPART_NULLSTRING = "000000";
    private static int HEXADECIMAL_BASE = 16;
    private static int LICENSEPART_LENGTH = 10;
    private static String LICENSE_NULLSTRING = "0000000000";
    private static int HASHCODE_BASE = 7;
    private static int HASHCODEPART_LENGTH = 6;
    private static String HASHCODE_NULLSTRING = "000000";
    private ArrayList<MacNetworkInterfaces.NetworkInterfaceWrapper> m_NetworkInterfaceWrappers_Hardware;
    private int m_LicenseType;
    private int m_SoftwareVersionReaden;
    private String m_UserName;
    private String m_UserNameReaden;
    private String m_LicenseStringCalculated;
    private String m_LicenseStringReaden;
    private String m_LicenseStringUnlock;
    private boolean m_LicenseIsDemo;
    private boolean m_LicenseOK;
    private File m_LicenseFile;
    private File m_LicenseDemoModeStartFile;
    private int m_DemoModeStartCount_Max;
    private int m_DemoModeStartsCount;
    private int m_DemoModeDaysCount_Max;
    private int m_DemoModeDaysCount;
    private Calendar m_CalendarLastStart;
    private Calendar m_CalendarFirstStart;
    private String m_ProgramName;
    private Icon m_ProgramIcon;
    private String m_ProgramCopyRight;
    private String m_ProgramHomePageURL;
    private JDialog_License m_JDialog_License;
    private Dimension m_JDialog_License_Size;
    private boolean m_StopAutoClose;

    public License() {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, "License");
    }

    private void initMembers() {
        this.m_LicenseType = 11;
        this.m_DemoModeStartCount_Max = 15;
        this.m_DemoModeStartsCount = 0;
        this.m_DemoModeDaysCount_Max = 30;
        this.m_DemoModeDaysCount = 0;
        this.m_CalendarFirstStart = Calendar.getInstance();
        this.m_CalendarLastStart = Calendar.getInstance();
        this.m_LicenseIsDemo = true;
        this.m_LicenseDemoModeStartFile = new File(System.getProperty("user.home") + File.separator + DEMOMODE_FILESTART);
        this.m_UserName = System.getProperty("user.name");
        this.m_LicenseOK = false;
        this.m_LicenseFile = null;
        this.m_JDialog_License = null;
        this.m_JDialog_License_Size = null;
        this.refreshNetworkInterfaces();
    }

    private void setLicenseType(int p_LicenseType) {
        this.m_LicenseType = p_LicenseType;
    }

    private void setLicenseDemoModeStartDaysMax(int p_StartDaysMax) {
        this.m_DemoModeStartCount_Max = p_StartDaysMax;
    }

    private void setLicenseDemoModeDaysMax(int p_DaysMax) {
        this.m_DemoModeDaysCount_Max = p_DaysMax;
    }

    public void setProgramName(String p_ProgramName) {
        this.m_ProgramName = p_ProgramName;
    }

    public String getProgramName() {
        return this.m_ProgramName;
    }

    public void setProgramIcon(Icon p_Icon) {
        this.m_ProgramIcon = p_Icon;
    }

    public Icon getProgramIcon() {
        return this.m_ProgramIcon;
    }

    public void setProgramCopyRight(String p_CopyRight) {
        this.m_ProgramCopyRight = p_CopyRight;
    }

    public String getProgramCopyRight() {
        return this.m_ProgramCopyRight;
    }

    public void setProgramHomePage(String p_HomepageURL) {
        this.m_ProgramHomePageURL = p_HomepageURL;
    }

    public String getProgramHomePage() {
        return this.m_ProgramHomePageURL;
    }

    public void setLicenseFile(File p_LicenseFile) {
        this.m_LicenseFile = p_LicenseFile;
    }

    public void setLicenseStartFile(File p_LicenseFile) {
        this.m_LicenseDemoModeStartFile = p_LicenseFile;
    }

    public boolean checkLicense() {
        if (this.m_LicenseFile == null) {
            return false;
        }
        return this.checkLicense(this.m_LicenseFile);
    }

    public boolean checkLicense(File p_LicenseFile) {
        boolean boolOk = true;
        this.m_LicenseFile = p_LicenseFile;
        this.m_LicenseIsDemo = true;
        if (this.readLicenseFile(p_LicenseFile)) {
            if (this.checkLicenseString(this.m_LicenseStringReaden)) {
                this.m_LicenseIsDemo = false;
                boolOk = true;
                License.writeLicenseFile(p_LicenseFile, this.m_LicenseStringReaden, this.m_UserName);
            } else if (this.m_UserNameReaden != null && this.m_UserNameReaden.equals(this.m_UserName)) {
                this.m_LicenseIsDemo = false;
                boolOk = true;
            } else {
                this.m_LicenseIsDemo = true;
                boolOk = false;
            }
        } else {
            boolOk = false;
        }
        if (!boolOk) {
            this.m_LicenseIsDemo = true;
            if (this.checkStartFile()) {
                boolOk = true;
            }
        } else if (this.m_LicenseDemoModeStartFile.exists()) {
            try {
                this.m_LicenseDemoModeStartFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_LicenseOK = boolOk;
        return this.m_LicenseOK;
    }

    public boolean getLicenseOK() {
        return this.m_LicenseOK;
    }

    public boolean getLicenseIsDemo() {
        return this.m_LicenseIsDemo;
    }

    public String getLicenseStringReaden() {
        return this.m_LicenseStringReaden;
    }

    private boolean checkStartFile() {
        boolean boolOK = true;
        int intYearLast = 0;
        int intMonthLast = 0;
        int intDayLast = 0;
        boolean intSoftwareVersion = false;
        Calendar o_CalendarNow = Calendar.getInstance();
        int intYearNow = o_CalendarNow.get(1);
        int intMonthNow = o_CalendarNow.get(2);
        int intDayNow = o_CalendarNow.get(5);
        if (!this.readDemoModeStartFile()) {
            boolOK = false;
        }
        if (!boolOK) {
            return boolOK;
        }
        switch (this.m_LicenseType) {
            case 11: {
                intYearLast = this.m_CalendarLastStart.get(1);
                intMonthLast = this.m_CalendarLastStart.get(2);
                intDayLast = this.m_CalendarLastStart.get(5);
                if (intYearLast != intYearNow || intMonthLast != intMonthNow || intDayLast != intDayNow || this.m_DemoModeStartsCount == 0) {
                    ++this.m_DemoModeStartsCount;
                }
                if (this.m_DemoModeStartsCount <= this.m_DemoModeStartCount_Max) break;
                boolOK = false;
                break;
            }
            case 10: {
                intYearLast = this.m_CalendarFirstStart.get(1);
                intMonthLast = this.m_CalendarFirstStart.get(2);
                intDayLast = this.m_CalendarFirstStart.get(5);
                long longMillisecondsFirst = this.m_CalendarFirstStart.getTimeInMillis();
                long longMillisecondsNow = System.currentTimeMillis();
                long longDays = (int)((double)(longMillisecondsNow - longMillisecondsFirst) / 8.64E7);
                if (longDays <= (long)this.m_DemoModeDaysCount_Max) break;
                boolOK = false;
                break;
            }
            default: {
                boolOK = false;
            }
        }
        if (!boolOK) {
            return boolOK;
        }
        boolOK = this.writeDemoModeStartFile();
        return boolOK;
    }

    public void resetDemoModeStartFile() {
        this.m_DemoModeStartsCount = 0;
        this.writeDemoModeStartFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readDemoModeStartFile() {
        File o_FileStartDir;
        boolean boolOK = true;
        int intYearLast = 0;
        int intMonthLast = 0;
        int intDayLast = 0;
        int intSoftwareVersion = 0;
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInputStream = null;
        File o_FileUserHome = new File(System.getProperty("user.home"));
        if (!o_FileUserHome.exists()) {
            return false;
        }
        if (this.m_LicenseDemoModeStartFile == null) {
            this.m_LicenseDemoModeStartFile = new File(o_FileUserHome.getAbsolutePath() + File.separator + DEMOMODE_FILESTART);
        }
        if (!(o_FileStartDir = this.m_LicenseDemoModeStartFile.getParentFile()).exists() || !this.m_LicenseDemoModeStartFile.exists()) {
            ++this.m_DemoModeDaysCount;
            ++this.m_DemoModeStartsCount;
            if (!this.writeDemoModeStartFile()) {
                return false;
            }
        }
        try {
            this.m_LicenseDemoModeStartFile.setReadable(true);
            o_FileInputStream = new FileInputStream(this.m_LicenseDemoModeStartFile);
            o_ObjectInputStream = new ObjectInputStream(o_FileInputStream);
            intSoftwareVersion = o_ObjectInputStream.readInt();
            this.m_DemoModeStartsCount = o_ObjectInputStream.readInt();
            intYearLast = o_ObjectInputStream.readInt();
            intMonthLast = o_ObjectInputStream.readInt();
            intDayLast = o_ObjectInputStream.readInt();
            this.m_CalendarFirstStart.set(1, intYearLast);
            this.m_CalendarFirstStart.set(2, intMonthLast);
            this.m_CalendarFirstStart.set(5, intDayLast);
            intYearLast = o_ObjectInputStream.readInt();
            intMonthLast = o_ObjectInputStream.readInt();
            intDayLast = o_ObjectInputStream.readInt();
            this.m_CalendarLastStart.set(1, intYearLast);
            this.m_CalendarLastStart.set(2, intMonthLast);
            this.m_CalendarLastStart.set(5, intDayLast);
            boolOK = true;
        }
        catch (Exception e) {
            boolOK = false;
        }
        finally {
            try {
                if (o_ObjectInputStream != null) {
                    o_ObjectInputStream.close();
                    o_ObjectInputStream = null;
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                    o_FileInputStream = null;
                }
            }
            catch (Exception exception) {}
        }
        return boolOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeDemoModeStartFile() {
        block23: {
            boolean boolOK = true;
            FileOutputStream o_FileOutputStream = null;
            ObjectOutputStream o_ObjectOutputStream = null;
            File o_FileUserHome = new File(System.getProperty("user.home"));
            if (!o_FileUserHome.exists()) {
                return false;
            }
            if (this.m_LicenseDemoModeStartFile == null) {
                this.m_LicenseDemoModeStartFile = new File(o_FileUserHome.getAbsolutePath() + File.separator + DEMOMODE_FILESTART);
            }
            File o_FileStartDir = this.m_LicenseDemoModeStartFile.getParentFile();
            try {
                if (!o_FileStartDir.exists()) {
                    boolOK = o_FileStartDir.mkdir();
                }
            }
            catch (Exception e) {
                boolOK = false;
            }
            if (!boolOK) {
                return false;
            }
            if (!this.m_LicenseDemoModeStartFile.exists()) {
                try {
                    boolOK = this.m_LicenseDemoModeStartFile.createNewFile();
                }
                catch (Exception e) {
                    boolOK = false;
                }
            }
            if (!boolOK) {
                return false;
            }
            try {
                this.m_LicenseDemoModeStartFile.setWritable(true);
                o_FileOutputStream = new FileOutputStream(this.m_LicenseDemoModeStartFile);
                o_ObjectOutputStream = new ObjectOutputStream(o_FileOutputStream);
                o_ObjectOutputStream.writeInt(2);
                o_ObjectOutputStream.writeInt(this.m_DemoModeStartsCount);
                int intYearNow = this.m_CalendarFirstStart.get(1);
                int intMonthNow = this.m_CalendarFirstStart.get(2);
                int intDayNow = this.m_CalendarFirstStart.get(5);
                o_ObjectOutputStream.writeInt(intYearNow);
                o_ObjectOutputStream.writeInt(intMonthNow);
                o_ObjectOutputStream.writeInt(intDayNow);
                Calendar o_CalendarNow = Calendar.getInstance();
                intYearNow = o_CalendarNow.get(1);
                intMonthNow = o_CalendarNow.get(2);
                intDayNow = o_CalendarNow.get(5);
                o_ObjectOutputStream.writeInt(intYearNow);
                o_ObjectOutputStream.writeInt(intMonthNow);
                o_ObjectOutputStream.writeInt(intDayNow);
            }
            catch (Exception e) {
                boolOK = false;
                return boolOK;
            }
            finally {
                try {
                    if (o_ObjectOutputStream != null) {
                        o_ObjectOutputStream.close();
                    }
                    if (o_FileOutputStream != null) {
                        o_FileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                if (boolOK) break block23;
                return false;
            }
        }
        return true;
    }

    private void refreshNetworkInterfaces() {
        if (this.m_NetworkInterfaceWrappers_Hardware == null) {
            MacNetworkInterfaces.checkNetworkInterfaces();
            this.m_NetworkInterfaceWrappers_Hardware = MacNetworkInterfaces.getNetworkInterfaceWrappers_Hardware();
        }
    }

    public String getLicenseStringCalculated() {
        if (this.m_LicenseStringCalculated == null || this.m_LicenseStringCalculated.length() <= 0 || LICENSE_NULLSTRING.equals(this.m_LicenseStringCalculated)) {
            this.m_LicenseStringCalculated = this.calculateLicenseString();
        }
        return this.m_LicenseStringCalculated;
    }

    private String calculateLicenseString() {
        String stringLicense;
        String stringMacAddressConcat = this.calculateMACString();
        String stringLicensePart = this.getLicensePartFromMACAddresses(stringMacAddressConcat);
        if (stringLicensePart == null) {
            this.m_LicenseStringCalculated = LICENSE_NULLSTRING + HASHCODE_NULLSTRING;
            return this.m_LicenseStringCalculated;
        }
        String stringHashCodePart = this.calculateHashCode(stringLicensePart);
        if (stringHashCodePart == null) {
            this.m_LicenseStringCalculated = LICENSE_NULLSTRING + HASHCODE_NULLSTRING;
            return this.m_LicenseStringCalculated;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(stringLicensePart);
        o_StringBuilder.append(stringHashCodePart);
        this.m_LicenseStringCalculated = stringLicense = o_StringBuilder.toString();
        return this.m_LicenseStringCalculated;
    }

    private String calculateMACString() {
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intInterface = 0; intInterface < 2; ++intInterface) {
            String stringMacAddress = this.getMacAddress(intInterface);
            if (stringMacAddress == null || stringMacAddress.length() < 17) {
                o_StringBuilder.append(MACADDRESSEPART_NULLSTRING);
                continue;
            }
            stringMacAddress = stringMacAddress.replace("-", "");
            if ((stringMacAddress = stringMacAddress.replace(":", "")).length() < MACADDRESSEPART_LENGTH) {
                o_StringBuilder.append(MACADDRESSEPART_NULLSTRING);
                continue;
            }
            o_StringBuilder.append(stringMacAddress.substring(stringMacAddress.length() - MACADDRESSEPART_LENGTH, stringMacAddress.length()).toUpperCase());
        }
        return o_StringBuilder.toString();
    }

    private String getLicensePartFromMACAddresses(String p_MacAddressesConcat) {
        char o_Char;
        if (p_MacAddressesConcat == null) {
            return null;
        }
        if (p_MacAddressesConcat.length() != MACADDRESSEPART_LENGTH * 2) {
            return null;
        }
        long longStringValue = 0L;
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intChar = 0; intChar < p_MacAddressesConcat.length(); ++intChar) {
            o_Char = p_MacAddressesConcat.charAt(intChar);
            longStringValue = (long)((double)longStringValue + (double)this.getValueOfChar(o_Char) * Math.pow(16.0, p_MacAddressesConcat.length() - intChar - 1));
        }
        o_StringBuilder.delete(0, o_StringBuilder.length());
        for (int intPower = LICENSEPART_LENGTH - 1; intPower >= 0; --intPower) {
            int intValue = (int)((double)longStringValue / Math.pow(CODE_CHARACTERS.length(), intPower));
            longStringValue = (long)((double)longStringValue - (double)intValue * Math.pow(CODE_CHARACTERS.length(), intPower));
            o_Char = this.getCharOfValue(intValue);
            o_StringBuilder.append(o_Char);
        }
        return o_StringBuilder.toString();
    }

    private String getMACAddressesFromLicense(String p_LicenseString) {
        char o_Char;
        String stringLicensePart = this.getLicensePart(p_LicenseString);
        if (stringLicensePart == null) {
            return null;
        }
        long longStringValue = 0L;
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intChar = 0; intChar < stringLicensePart.length(); ++intChar) {
            o_Char = stringLicensePart.charAt(intChar);
            longStringValue = (long)((double)longStringValue + (double)this.getValueOfChar(o_Char) * Math.pow(CODE_CHARACTERS.length(), stringLicensePart.length() - intChar - 1));
        }
        o_StringBuilder.delete(0, o_StringBuilder.length());
        for (int intPower = MACADDRESSEPART_LENGTH * 2 - 1; intPower >= 0; --intPower) {
            int intValue = (int)((double)longStringValue / Math.pow(16.0, intPower));
            longStringValue = (long)((double)longStringValue - (double)intValue * Math.pow(16.0, intPower));
            o_Char = this.getCharOfValue(intValue);
            o_StringBuilder.append(o_Char);
        }
        return o_StringBuilder.toString();
    }

    private String calculateHashCode(String p_LicensePart) {
        int intPower;
        if (p_LicensePart == null) {
            return HASHCODE_NULLSTRING;
        }
        if (p_LicensePart.length() != LICENSEPART_LENGTH) {
            return HASHCODE_NULLSTRING;
        }
        int intHashSum = 0;
        try {
            p_LicensePart = new String(p_LicensePart.getBytes("UTF-8"), Charset.forName("UTF-8"));
            p_LicensePart = p_LicensePart.toUpperCase();
            intPower = p_LicensePart.length();
            for (int intChar = 0; intChar < p_LicensePart.length(); ++intChar) {
                Character o_Char = Character.valueOf(p_LicensePart.charAt(intChar));
                int intCharValue = this.getValueOfChar(o_Char.charValue());
                if (intCharValue < 0) {
                    return HASHCODE_NULLSTRING;
                }
                intHashSum = (int)((double)intHashSum + (double)intCharValue * Math.pow(HASHCODE_BASE, --intPower));
            }
        }
        catch (Exception e) {
            return "00";
        }
        StringBuilder stringBuilderResult = new StringBuilder();
        for (intPower = HASHCODEPART_LENGTH - 1; intPower >= 0; --intPower) {
            int intChar = (int)((double)intHashSum / Math.pow(CODE_CHARACTERS.length(), intPower));
            intHashSum = (int)((double)intHashSum - (double)intChar * Math.pow(CODE_CHARACTERS.length(), intPower));
            stringBuilderResult.append(this.getCharOfValue(intChar));
        }
        return stringBuilderResult.toString();
    }

    private boolean checkHashCode(String p_LicenseString) {
        int intCharValue;
        char o_Char;
        int intChar;
        String stringLicensePart = this.getLicensePart(p_LicenseString);
        if (stringLicensePart == null) {
            return false;
        }
        String stringHashCodePart = this.getHasCodePart(p_LicenseString);
        if (stringHashCodePart == null) {
            return false;
        }
        int intPower = stringLicensePart.length();
        int intLicenseValue = 0;
        for (intChar = 0; intChar < stringLicensePart.length(); ++intChar) {
            o_Char = stringLicensePart.charAt(intChar);
            intCharValue = this.getValueOfChar(o_Char);
            if (intCharValue < 0) {
                return false;
            }
            intLicenseValue = (int)((double)intLicenseValue + (double)intCharValue * Math.pow(HASHCODE_BASE, --intPower));
        }
        intPower = stringHashCodePart.length();
        int intHasCodeValue = 0;
        for (intChar = 0; intChar < stringHashCodePart.length(); ++intChar) {
            o_Char = stringHashCodePart.charAt(intChar);
            intCharValue = this.getValueOfChar(o_Char);
            if (intCharValue < 0) {
                return false;
            }
            intHasCodeValue = (int)((double)intHasCodeValue + (double)intCharValue * Math.pow(CODE_CHARACTERS.length(), --intPower));
        }
        return intHasCodeValue == intLicenseValue;
    }

    private int getValueOfChar(char p_Char) {
        int intPos = CODE_CHARACTERS.indexOf(p_Char);
        return intPos;
    }

    private char getCharOfValue(int p_Value) {
        if (p_Value < 0) {
            return '-';
        }
        if (p_Value >= CODE_CHARACTERS.length()) {
            return '-';
        }
        return CODE_CHARACTERS.charAt(p_Value);
    }

    private String getLicensePart(String p_LicenseString) {
        if (p_LicenseString == null) {
            return null;
        }
        if (p_LicenseString.length() < LICENSEPART_LENGTH) {
            return null;
        }
        return p_LicenseString.substring(0, LICENSEPART_LENGTH).toUpperCase();
    }

    private String getHasCodePart(String p_LicenseString) {
        if (p_LicenseString == null) {
            return null;
        }
        if (p_LicenseString.length() != LICENSEPART_LENGTH + HASHCODEPART_LENGTH) {
            return null;
        }
        return p_LicenseString.substring(LICENSEPART_LENGTH, p_LicenseString.length()).toUpperCase();
    }

    public String calculateLicenseUnlockString(String p_LicenseString) {
        if (p_LicenseString == null) {
            return null;
        }
        if (p_LicenseString.length() != LICENSEPART_LENGTH + HASHCODEPART_LENGTH) {
            return null;
        }
        String stringLicensePart = this.getLicensePart(p_LicenseString);
        if (stringLicensePart == null) {
            return null;
        }
        if (LICENSE_NULLSTRING.equals(stringLicensePart)) {
            return null;
        }
        StringBuffer o_StringBuffer = new StringBuffer();
        byte[] o_Bytes = stringLicensePart.getBytes(Charset.forName("UTF-8"));
        byte[] o_BytesEncoded = License.encryptBytes(o_Bytes);
        for (int intByte = 0; intByte < o_BytesEncoded.length; intByte += 2) {
            int o_Byte;
            int intCharPos = o_Byte = o_BytesEncoded[intByte];
            char o_Char = this.getCharOfValue(intCharPos);
            o_StringBuffer.append(o_Char);
            o_Byte = o_BytesEncoded[intByte + 1];
            intCharPos = o_Byte >> 4;
            o_Char = this.getCharOfValue(intCharPos);
            o_StringBuffer.append(o_Char);
        }
        this.m_LicenseStringUnlock = o_StringBuffer.toString();
        return this.m_LicenseStringUnlock;
    }

    private static byte[] encryptBytes(byte[] p_ByteArray) {
        if (p_ByteArray == null) {
            return null;
        }
        byte[] o_Bytes = new byte[p_ByteArray.length * 2];
        for (int intByte = 0; intByte < p_ByteArray.length; ++intByte) {
            o_Bytes[intByte * 2] = (byte)(p_ByteArray[intByte] & 0xF);
            o_Bytes[intByte * 2 + 1] = (byte)(p_ByteArray[intByte] & 0xF0);
        }
        return o_Bytes;
    }

    private static byte[] decryptBytes(byte[] p_ByteArray) {
        if (p_ByteArray == null) {
            return null;
        }
        byte[] o_Bytes = new byte[p_ByteArray.length / 2];
        for (int intByte = 0; intByte < p_ByteArray.length; intByte += 2) {
            o_Bytes[intByte / 2] = (byte)(p_ByteArray[intByte] | p_ByteArray[intByte + 1]);
        }
        return o_Bytes;
    }

    private static byte[] decryptBytes(ArrayList<Byte> p_ByteArray) {
        if (p_ByteArray == null) {
            return null;
        }
        byte[] o_Bytes = new byte[p_ByteArray.size() / 2];
        for (int intByte = 0; intByte < p_ByteArray.size(); intByte += 2) {
            o_Bytes[intByte / 2] = (byte)(p_ByteArray.get(intByte) | p_ByteArray.get(intByte + 1));
        }
        return o_Bytes;
    }

    public boolean checkLicenseUnlockString(String p_UnlockString) {
        if (p_UnlockString == null) {
            return false;
        }
        p_UnlockString = p_UnlockString.replace(" ", "");
        p_UnlockString = p_UnlockString.replace("-", "");
        p_UnlockString = p_UnlockString.replace(":", "");
        String stringLicensePart = this.getLicensePartFromUnlock(p_UnlockString = p_UnlockString.toUpperCase());
        if (this.checkLicenseString(stringLicensePart)) {
            this.m_LicenseOK = true;
            this.m_LicenseIsDemo = false;
            return License.writeLicenseFile(this.m_LicenseFile, this.m_LicenseStringCalculated, this.m_UserName);
        }
        return false;
    }

    private String getLicensePartFromUnlock(String p_UnlockString) {
        if (p_UnlockString == null) {
            return null;
        }
        if (p_UnlockString.length() != LICENSE_NULLSTRING.length() * 2) {
            return null;
        }
        byte[] o_BytesEncoded = new byte[p_UnlockString.length()];
        for (int intChar = 0; intChar < p_UnlockString.length(); intChar += 2) {
            char o_Char = p_UnlockString.charAt(intChar);
            int intCharPos = this.getValueOfChar(o_Char);
            o_BytesEncoded[intChar] = (byte)intCharPos;
            o_Char = p_UnlockString.charAt(intChar + 1);
            intCharPos = this.getValueOfChar(o_Char);
            o_BytesEncoded[intChar + 1] = (byte)(intCharPos << 4);
        }
        byte[] o_BytesDecoded = License.decryptBytes(o_BytesEncoded);
        String stringLicensePart = new String(o_BytesDecoded, Charset.forName("UTF-8"));
        return stringLicensePart;
    }

    public boolean checkLicenseString(String p_LicenseString) {
        if (p_LicenseString == null) {
            return false;
        }
        String stringMACAddressConcat = this.getMACAddressesFromLicense(p_LicenseString);
        if (stringMACAddressConcat == null) {
            return false;
        }
        if (stringMACAddressConcat.length() != MACADDRESSEPART_LENGTH * 2) {
            return false;
        }
        this.refreshNetworkInterfaces();
        for (int intPosIDString = 0; intPosIDString < stringMACAddressConcat.length(); intPosIDString += MACADDRESSEPART_LENGTH) {
            String stringSubID = stringMACAddressConcat.substring(intPosIDString, intPosIDString + MACADDRESSEPART_LENGTH);
            if (MACADDRESSEPART_NULLSTRING.equals(stringSubID)) continue;
            for (int intInterface = 0; intInterface < 2; ++intInterface) {
                String stringMacAddress = this.getMacAddress(intInterface);
                if (stringMacAddress == null || stringMacAddress.length() < 17) continue;
                stringMacAddress = stringMacAddress.replace("-", "");
                stringMacAddress = stringMacAddress.replace(":", "");
                if (!(stringMacAddress = stringMacAddress.toUpperCase()).contains(stringSubID)) continue;
                return true;
            }
        }
        return false;
    }

    public String getMacAddress(int p_Index) {
        if (p_Index < 0) {
            return "";
        }
        if (p_Index > 1) {
            return "";
        }
        String stringMacAddress = "";
        String stringOS = System.getProperty("os.name").toLowerCase();
        boolean boolFoundMacLinux = false;
        if (stringOS.indexOf("mac") >= 0) {
            stringMacAddress = License.getMacAddress_MACOSX(p_Index);
            if (stringMacAddress != null && stringMacAddress.length() == 17) {
                boolFoundMacLinux = true;
            }
        } else if ((stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0) && (stringMacAddress = License.getMacAddress_LINUX(p_Index)) != null && stringMacAddress.length() == 17) {
            boolFoundMacLinux = true;
        }
        if (boolFoundMacLinux) {
            return stringMacAddress;
        }
        if (this.m_NetworkInterfaceWrappers_Hardware == null || this.m_NetworkInterfaceWrappers_Hardware.size() <= 0) {
            return "";
        }
        stringMacAddress = this.m_NetworkInterfaceWrappers_Hardware.size() == 1 ? (p_Index > 0 ? "" : this.m_NetworkInterfaceWrappers_Hardware.get(0).getMacAddress()) : this.m_NetworkInterfaceWrappers_Hardware.get(p_Index).getMacAddress();
        return stringMacAddress;
    }

    public static String getMacAddress_MACOSX(int p_InterfaceIndex) {
        if (p_InterfaceIndex < 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        try {
            Process o_Process = Runtime.getRuntime().exec("networksetup -getmacaddress en" + String.valueOf(p_InterfaceIndex));
            BufferedReader o_BufferedReader = new BufferedReader(new InputStreamReader(o_Process.getInputStream()));
            o_StringBuilder.delete(0, o_StringBuilder.length());
            int intChar = o_BufferedReader.read();
            while (intChar >= 0) {
                o_StringBuilder.append((char)intChar);
                intChar = o_BufferedReader.read();
            }
            String stringReaden = o_StringBuilder.toString();
            String[] o_StringsReaden = stringReaden.split(" ");
            if (o_StringsReaden.length < 3) {
                return "";
            }
            return o_StringsReaden[2].trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMacAddress_LINUX(int p_InterfaceIndex) {
        String stringReaden;
        int intChar;
        BufferedReader o_BufferedReader;
        Process o_Process;
        if (p_InterfaceIndex < 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        try {
            o_Process = Runtime.getRuntime().exec("ls /sys/class/net");
            o_BufferedReader = new BufferedReader(new InputStreamReader(o_Process.getInputStream()));
            o_StringBuilder.delete(0, o_StringBuilder.length());
            intChar = o_BufferedReader.read();
            while (intChar >= 0) {
                o_StringBuilder.append((char)intChar);
                intChar = o_BufferedReader.read();
            }
            stringReaden = o_StringBuilder.toString();
            stringReaden = stringReaden.trim();
        }
        catch (Exception e) {
            return "";
        }
        String[] o_StringsReaden = stringReaden.split("\n");
        int intNetworkIndex = 0;
        for (int intNetwork = 0; intNetwork < o_StringsReaden.length; ++intNetwork) {
            if (o_StringsReaden[intNetwork].contains("lo")) {
                ++intNetworkIndex;
                continue;
            }
            if (intNetworkIndex != p_InterfaceIndex) {
                ++intNetworkIndex;
                continue;
            }
            try {
                o_Process = Runtime.getRuntime().exec("cat /sys/class/net/" + o_StringsReaden[intNetwork].trim() + "/address");
                o_BufferedReader = new BufferedReader(new InputStreamReader(o_Process.getInputStream()));
                o_StringBuilder.delete(0, o_StringBuilder.length());
                intChar = o_BufferedReader.read();
                while (intChar >= 0) {
                    o_StringBuilder.append((char)intChar);
                    intChar = o_BufferedReader.read();
                }
                stringReaden = o_StringBuilder.toString();
                stringReaden = stringReaden.trim();
            }
            catch (Exception e) {
                return "";
            }
            return stringReaden;
        }
        return "";
    }

    public String getUserName() {
        String stringUserName = System.getProperty("user.name");
        return stringUserName;
    }

    public String getComputerName() {
        Map<String, String> env = System.getenv();
        String stringComputerName = env.containsKey("COMPUTERNAME") ? env.get("COMPUTERNAME") : (env.containsKey("HOSTNAME") ? env.get("HOSTNAME") : "");
        return stringComputerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readLicenseFile(File p_LicenseFile) {
        boolean boolOK;
        block22: {
            if (p_LicenseFile == null) {
                return false;
            }
            if (!p_LicenseFile.exists()) {
                return false;
            }
            boolOK = true;
            FileInputStream o_FileInputStream = null;
            byte[] o_ByteArray = new byte[1024];
            ArrayList<Byte> o_Bytes = new ArrayList<Byte>();
            try {
                int len;
                o_FileInputStream = new FileInputStream(p_LicenseFile);
                while ((len = o_FileInputStream.read(o_ByteArray)) >= 0) {
                    for (int intByte = 0; intByte < len; ++intByte) {
                        o_Bytes.add(o_ByteArray[intByte]);
                    }
                }
                byte[] o_BytesDecrypted = License.decryptBytes(o_Bytes);
                String stringContent = new String(o_BytesDecrypted, Charset.forName("UTF-8"));
                String[] stringContentParts = stringContent.split(";");
                if (stringContentParts.length < 2) {
                    boolOK = false;
                }
                if (!boolOK) break block22;
                try {
                    this.m_SoftwareVersionReaden = Integer.decode(stringContentParts[0]);
                    this.m_LicenseStringReaden = stringContentParts[1];
                    if (this.m_SoftwareVersionReaden > 1) {
                        if (stringContentParts.length < 3) {
                            boolOK = false;
                        }
                        this.m_UserNameReaden = stringContentParts[2];
                    }
                }
                catch (Exception e) {
                    boolOK = false;
                }
            }
            catch (Exception e) {
                boolOK = false;
            }
            finally {
                if (o_FileInputStream != null) {
                    try {
                        o_FileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!boolOK) {
            this.m_SoftwareVersionReaden = 0;
            this.m_LicenseStringReaden = "";
        }
        return boolOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeLicenseFile(File p_LicenseFile, String p_LicenseString, String p_UserName) {
        if (p_LicenseFile == null) {
            return false;
        }
        if (p_LicenseString == null) {
            return false;
        }
        FileOutputStream o_FileOutputStream = null;
        boolean boolOK = true;
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append(2);
        o_StringBuffer.append(";");
        o_StringBuffer.append(p_LicenseString);
        o_StringBuffer.append(";");
        o_StringBuffer.append(p_UserName);
        String stringLicenseContent = o_StringBuffer.toString();
        byte[] o_Bytes_Content = stringLicenseContent.getBytes(Charset.forName("UTF-8"));
        byte[] o_Bytes_Encrypted = License.encryptBytes(o_Bytes_Content);
        try {
            if (p_LicenseFile.exists()) {
                p_LicenseFile.delete();
            }
            p_LicenseFile.createNewFile();
            o_FileOutputStream = new FileOutputStream(p_LicenseFile);
            o_FileOutputStream.write(o_Bytes_Encrypted);
        }
        catch (Exception e) {
            boolOK = false;
        }
        finally {
            if (o_FileOutputStream != null) {
                try {
                    o_FileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return boolOK;
    }

    public void setLicenseDialog_Size(Dimension p_Size) {
        this.m_JDialog_License_Size = p_Size;
        if (this.m_JDialog_License == null) {
            return;
        }
        if (this.m_JDialog_License_Size == null) {
            return;
        }
        this.m_JDialog_License.setPreferredSize(this.m_JDialog_License_Size);
    }

    public void showLicenseDialog(final int p_MilliSecondsLicenseOK, final int p_MilliSecondsLicenseFALSE) {
        JDialog_License o_JDialog_License = this.m_JDialog_License;
        if (o_JDialog_License == null) {
            o_JDialog_License = new JDialog_License(null, true, this);
            if (this.m_JDialog_License_Size != null) {
                o_JDialog_License.setPreferredSize(this.m_JDialog_License_Size);
            }
            this.m_JDialog_License = o_JDialog_License;
        }
        this.m_StopAutoClose = false;
        Runnable o_RunnableClose = new Runnable(){

            @Override
            public void run() {
                try {
                    if (License.this.m_LicenseOK && !License.this.m_LicenseIsDemo) {
                        Thread.sleep(p_MilliSecondsLicenseOK);
                    } else {
                        Thread.sleep(p_MilliSecondsLicenseFALSE);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (License.this.m_StopAutoClose) {
                    return;
                }
                License.this.closeLicenseDialog();
            }
        };
        if (this.m_LicenseOK && p_MilliSecondsLicenseOK > 0) {
            Thread o_ThreadCloseDialog = new Thread(o_RunnableClose);
            o_ThreadCloseDialog.start();
        }
        o_JDialog_License.refreshContent();
        o_JDialog_License.setVisible(true);
    }

    public void showLicenseDialogUnlock() {
        this.m_StopAutoClose = true;
        JDialog_License o_JDialog_License = this.m_JDialog_License;
        if (o_JDialog_License == null) {
            this.m_JDialog_License = o_JDialog_License = new JDialog_License(null, true, this);
            if (this.m_JDialog_License_Size != null) {
                this.m_JDialog_License.setPreferredSize(this.m_JDialog_License_Size);
            }
        }
        o_JDialog_License.showDialogUnlock();
        o_JDialog_License.setVisible(true);
    }

    public void stopAutoClose() {
        this.m_StopAutoClose = true;
    }

    public void closeLicenseDialog() {
        JDialog_License o_JDialog_License = this.m_JDialog_License;
        if (o_JDialog_License == null) {
            return;
        }
        o_JDialog_License.setVisible(false);
        o_JDialog_License.dispose();
        this.m_JDialog_License = null;
    }

    public String getLicenseHeader() {
        if (!this.m_LicenseOK) {
            return LICENSE_HEADER_DEMO_FINISHED;
        }
        if (!this.m_LicenseIsDemo) {
            return LICENSE_HRADER_LICENSED;
        }
        return LICENSE_HEADER_DEMO;
    }

    public String getLicenseContent() {
        StringBuffer o_StringBuffer = new StringBuffer();
        if (!this.m_LicenseIsDemo) {
            o_StringBuffer.append("<html>");
            o_StringBuffer.append("<center>");
            String stringContent = this.getComputerName();
            if (stringContent != null && stringContent.length() > 0) {
                o_StringBuffer.append(stringContent);
                o_StringBuffer.append("<br>");
            }
            if ((stringContent = this.getUserName()) != null && stringContent.length() > 0) {
                o_StringBuffer.append(stringContent);
            }
        } else {
            switch (this.m_LicenseType) {
                case 11: {
                    o_StringBuffer.append("<html>");
                    o_StringBuffer.append("<center>");
                    o_StringBuffer.append(LICENSE_DEMOCONTENT_STARTDAYS_LEFT);
                    o_StringBuffer.append("<br>");
                    o_StringBuffer.append(this.m_DemoModeStartCount_Max - this.m_DemoModeStartsCount);
                    o_StringBuffer.append("</html>");
                    break;
                }
                case 10: {
                    o_StringBuffer.append("<html>");
                    o_StringBuffer.append("<center>");
                    o_StringBuffer.append(LICENSE_DEMOCONTENT_DAYS_LEFT);
                    o_StringBuffer.append("<br>");
                    o_StringBuffer.append(this.m_DemoModeDaysCount_Max - this.m_DemoModeDaysCount);
                    o_StringBuffer.append("</html>");
                    break;
                }
                default: {
                    o_StringBuffer.append("");
                }
            }
        }
        return o_StringBuffer.toString();
    }

    public String getLicenseUserName() {
        return this.getUserName();
    }

    public String getLicenseComputerName() {
        return this.getComputerName();
    }

    public static void main(String[] args) {
        final String[] o_Arguments = new String[args.length];
        System.arraycopy(args, 0, o_Arguments, 0, args.length);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String stringLicenseString;
                String stringPassword;
                License o_License = new License();
                LicenseUnlock o_JDialog_License = new LicenseUnlock(null, true, o_License);
                if (o_Arguments.length >= 2) {
                    stringPassword = o_Arguments[0];
                    stringLicenseString = o_Arguments[1];
                    stringLicenseString = stringLicenseString.replace(" ", "");
                } else {
                    stringPassword = "";
                    stringLicenseString = "---";
                }
                if (!"hagi".equals(stringPassword)) {
                    o_JDialog_License.setVisible(true);
                    return;
                }
                o_License.setProgramName("<html><center>liveShow<br>Software</center></html>");
                o_License.setProgramCopyRight("copyright by \u00a9 Hans-J\u00fcrgen Blickle");
                o_License.setProgramIcon(new ImageIcon(this.getClass().getResource("/LicenseGraphicPackage/LiveShowIconRGB_Back_Round_64.png")));
                o_License.setProgramHomePage("www.liveshowsoftware.de");
                o_License.setLicenseFile(new File(System.getProperty("user.home") + File.separator + "license.lic"));
                o_License.checkLicense();
                String stringLicenseUnlock = o_License.calculateLicenseUnlockString(stringLicenseString);
                System.out.println(stringLicenseString + " -> Unlock: " + stringLicenseUnlock);
                System.out.println();
                System.out.println();
                stringLicenseString = o_License.getLicenseStringCalculated();
                stringLicenseUnlock = o_License.calculateLicenseUnlockString(stringLicenseString);
                System.out.println("LicenseString complete: " + stringLicenseString);
                System.out.println("LicensePart: " + o_License.getLicensePart(stringLicenseString));
                System.out.println("HashCodePart: " + o_License.getHasCodePart(stringLicenseString));
                System.out.println();
                System.out.println("HASHCODE VALID: " + o_License.checkHashCode(stringLicenseString));
                System.out.println();
                System.out.println("LicenseStringUnlock: " + stringLicenseUnlock);
                System.out.println("LicenseString from LicenseUnlockString: " + o_License.getLicensePartFromUnlock(stringLicenseUnlock));
                System.out.println();
                o_License.showLicenseDialog(2000, 6000);
                if (!o_License.getLicenseOK()) {
                    System.out.println("LICENSE NOT OK -> Should exit the program");
                }
            }
        });
    }
}

