/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Header;
import ArtNetPackage.ArtNet_Op;
import java.util.ArrayList;

public class ArtNet_Op_ArtDMX
extends ArtNet_Op {
    public static final int OP_SIZE = 520;
    public static final int OP_CODE = 20480;
    public static final Object s_SyncPool = new Object();
    public static ArrayList<ArtNet_Op_ArtDMX> s_Pool = new ArrayList();
    private byte m_ProtocolRevision_High;
    private byte m_ProtocolRevision_Low;
    private byte m_Physical;
    private byte m_Sequence;
    private int m_UniverseNumber;
    private byte m_SubUni;
    private byte m_Net;
    private int m_Length;
    private byte m_LengthHigh;
    private byte m_LengthLow;
    private int[] m_DMXDataInt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtDMX getFromPool() {
        ArtNet_Op_ArtDMX o_ArtNet_Op_ArtDMX;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtDMX = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtDMX.refresh();
            } else {
                o_ArtNet_Op_ArtDMX = new ArtNet_Op_ArtDMX();
            }
        }
        return o_ArtNet_Op_ArtDMX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtDMX getFromPool(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        ArtNet_Op_ArtDMX o_ArtNet_Op_ArtDMX;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtDMX = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtDMX.refresh(p_ArtNet_Header, p_ArtNetData_Bytes);
            } else {
                o_ArtNet_Op_ArtDMX = new ArtNet_Op_ArtDMX(p_ArtNet_Header, p_ArtNetData_Bytes);
            }
        }
        return o_ArtNet_Op_ArtDMX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(ArtNet_Op_ArtDMX p_ArtNet_Op_ArtDMX) {
        if (p_ArtNet_Op_ArtDMX == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            s_Pool.add(p_ArtNet_Op_ArtDMX);
        }
    }

    private void initMembers() {
        this.m_ProtocolRevision_Low = (byte)14;
        this.m_ProtocolRevision_High = 0;
        this.m_Physical = 0;
        this.m_Sequence = 0;
        this.m_UniverseNumber = 0;
        this.m_Net = 0;
        this.m_SubUni = 0;
        this.m_Length = 0;
        this.m_LengthHigh = 0;
        this.m_LengthLow = 0;
        this.m_DMXDataInt = null;
    }

    @Override
    public void close() {
        if (this.m_Closed) {
            return;
        }
        super.close();
        ArtNet_Op_ArtDMX.addToPool(this);
    }

    public byte getProtocolRevisionHigh() {
        return this.m_ProtocolRevision_High;
    }

    public byte getProtocolRevisionLow() {
        return this.m_ProtocolRevision_Low;
    }

    public int getProtocolRevision() {
        int intRevicion = 0;
        intRevicion += this.m_ProtocolRevision_High;
        return intRevicion <<= 8;
    }

    public void setPhysical(byte p_Physical) {
        if (this.m_Physical == p_Physical) {
            return;
        }
        this.m_Physical = p_Physical;
        this.m_Changed = true;
    }

    public byte getPhysical() {
        return this.m_Physical;
    }

    public byte getSequence() {
        return this.m_Sequence;
    }

    public void setSequence(byte p_Sequence) {
        if (this.m_Sequence == p_Sequence) {
            return;
        }
        this.m_Sequence = p_Sequence;
        this.m_Changed = true;
    }

    public int getNetSwitch() {
        return this.m_Net;
    }

    public int getSubUni() {
        return this.m_SubUni;
    }

    public int getSubSwitch() {
        int intSubSwitch = this.m_SubUni >> 4 & 0xF;
        return intSubSwitch;
    }

    public int getPortAddress() {
        int intPort = this.m_SubUni & 0xF;
        return intPort;
    }

    public int getUniverseNumber() {
        int intUniverseNumber = 0;
        intUniverseNumber += (this.m_Net & 0x7F) << 8;
        this.m_UniverseNumber = intUniverseNumber += this.m_SubUni & 0xFF;
        return this.m_UniverseNumber;
    }

    public void setUniverseNumber(int p_UniverseNumber) {
        if (this.m_UniverseNumber == p_UniverseNumber) {
            return;
        }
        int intUniverseNumber = this.m_UniverseNumber = p_UniverseNumber;
        this.m_Net = (byte)(intUniverseNumber >> 8 & 0x7F);
        this.m_SubUni = (byte)(intUniverseNumber & 0xFF);
        this.m_Changed = true;
    }

    public int getLength() {
        int intLength = 0;
        intLength += (this.m_LengthHigh & 0xFF) << 8;
        this.m_Length = intLength += this.m_LengthLow & 0xFF;
        return intLength;
    }

    public void setLength(int p_Length) {
        if (p_Length < 0) {
            p_Length = 0;
        }
        if (this.m_Length == p_Length) {
            return;
        }
        this.m_Length = p_Length;
        this.m_LengthHigh = (byte)(this.m_Length >> 8 & 0xFF);
        this.m_LengthLow = (byte)(this.m_Length & 0xFF);
        this.m_Changed = true;
    }

    public void setDMXData(int[] p_DMXDataInt) {
        this.m_DMXDataInt = p_DMXDataInt;
    }

    public int[] getDMXData(int[] p_DMXDataInt, int p_Length) {
        if (p_DMXDataInt == null) {
            p_DMXDataInt = new int[512];
        }
        int intOffset = 18;
        int intLength = p_DMXDataInt.length < 512 ? p_DMXDataInt.length : 512;
        this.getLength();
        if (intLength > this.m_Length) {
            intLength = this.m_Length;
        }
        for (int intByte = 0; intByte < intLength; ++intByte) {
            try {
                byte byteDMXValue = this.m_ArtNetData_Bytes.getByte(intOffset);
                p_DMXDataInt[intByte] = Byte.toUnsignedInt(byteDMXValue);
                ++intOffset;
                continue;
            }
            catch (Exception e) {
                return p_DMXDataInt;
            }
        }
        return p_DMXDataInt;
    }

    public ArtNet_Op_ArtDMX(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super(20480, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public void refresh(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super.refresh(20480, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public boolean received(ArtNetData_Bytes p_ArtNetData_Bytes) {
        if (p_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            return false;
        }
        int intOffset = 10;
        try {
            this.m_ProtocolRevision_High = p_ArtNetData_Bytes.getByte(intOffset);
            this.m_ProtocolRevision_Low = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Sequence = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Physical = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_SubUni = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Net = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_LengthHigh = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_LengthLow = p_ArtNetData_Bytes.getByte(++intOffset);
            ++intOffset;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ArtNet_Op_ArtDMX() {
        super(20480, 530);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    public void refresh() {
        super.refresh(20480, 530);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    @Override
    public byte[] getSendDataBytes() {
        ArtNetData_Bytes o_ArtNetData_Bytes = this.m_ArtNetData_Bytes;
        if (o_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            return null;
        }
        if (this.m_Changed) {
            int intOffset = 10;
            try {
                intOffset += o_ArtNetData_Bytes.setByte(this.m_ProtocolRevision_High, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_ProtocolRevision_Low, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_Sequence, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_Physical, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_SubUni, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_Net, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_LengthHigh, intOffset);
                intOffset += o_ArtNetData_Bytes.setByte(this.m_LengthLow, intOffset);
                int intDMXBytesCount = o_ArtNetData_Bytes.setBytesFromIntegerArray(this.m_DMXDataInt, intOffset, 0, this.m_Length);
                if (intDMXBytesCount < this.m_Length) {
                    this.setLength(intDMXBytesCount);
                    o_ArtNetData_Bytes.setByte(this.m_LengthHigh, intOffset - 2);
                    o_ArtNetData_Bytes.setByte(this.m_LengthLow, intOffset - 1);
                }
                this.m_Size = intOffset += intDMXBytesCount;
                this.m_Valid = true;
            }
            catch (Exception e) {
                this.m_Valid = false;
            }
            if (!this.m_Valid) {
                return null;
            }
            this.m_Changed = false;
        }
        return o_ArtNetData_Bytes.getData(this.m_Size);
    }
}

