/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class ArtNetData_Bytes {
    public static final Charset CHARSET = Charset.forName("ISO-8859-1");
    public static String s_ParseError = "ParseError";
    protected int m_Size;
    protected byte[] m_Data;
    protected int m_DataReceivedCount;
    protected int m_DataReceiveRestCount;
    protected int m_DataFilledCount;
    protected int m_DataFilledRestCount;
    protected boolean m_Closed;
    protected final Object m_SyncObject = new Object();
    private static final Object s_SyncPool = new Object();
    private static int s_PoolMaxSize = 600;
    private static int s_PoolMaxSize_PerSize = 20;
    private static HashMap<Integer, ArrayList<ArtNetData_Bytes>> s_Pool_ArtNetData_Bytes = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNetData_Bytes getPoolArtNetData_Bytes(int p_Size) {
        Object object = s_SyncPool;
        synchronized (object) {
            ArrayList<ArtNetData_Bytes> o_ListArtNetData_Bytes = s_Pool_ArtNetData_Bytes.get(p_Size);
            if (o_ListArtNetData_Bytes == null || o_ListArtNetData_Bytes.size() <= 0) {
                return new ArtNetData_Bytes(p_Size);
            }
            ArtNetData_Bytes o_ArtNetData_Bytes = o_ListArtNetData_Bytes.get(o_ListArtNetData_Bytes.size() - 1);
            o_ListArtNetData_Bytes.remove(o_ListArtNetData_Bytes.size() - 1);
            o_ArtNetData_Bytes.initMembers();
            return o_ArtNetData_Bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPoolArtNetDataBytes(ArtNetData_Bytes p_ArtNetData_Bytes) {
        if (p_ArtNetData_Bytes == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            int intSize = p_ArtNetData_Bytes.getSize();
            ArrayList<ArtNetData_Bytes> o_ListArtNetData_Bytes = s_Pool_ArtNetData_Bytes.get(intSize);
            if (o_ListArtNetData_Bytes == null) {
                if (s_Pool_ArtNetData_Bytes.size() > s_PoolMaxSize) {
                    return;
                }
                o_ListArtNetData_Bytes = new ArrayList();
                s_Pool_ArtNetData_Bytes.put(intSize, o_ListArtNetData_Bytes);
            }
            if (o_ListArtNetData_Bytes.size() > s_PoolMaxSize_PerSize) {
                return;
            }
            o_ListArtNetData_Bytes.add(p_ArtNetData_Bytes);
        }
    }

    public ArtNetData_Bytes(int p_Size) {
        this.m_Size = p_Size;
        this.initMembers();
        this.m_Data = new byte[p_Size];
        this.initMembersFurther();
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_DataReceivedCount = 0;
        this.m_DataFilledCount = 0;
        this.m_DataReceiveRestCount = this.m_Size;
        this.m_DataFilledRestCount = this.m_Size;
    }

    private void initMembersFurther() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
            ArtNetData_Bytes.addPoolArtNetDataBytes(this);
        }
    }

    public boolean getByteData(int p_Offset, byte[] p_Destination, int p_StartByte, int p_Length) {
        if (p_Destination == null) {
            return false;
        }
        if (p_Destination.length <= 0) {
            return false;
        }
        int intBytesToCopy = p_Length;
        if (p_Offset + p_Length > this.m_Size) {
            intBytesToCopy = this.m_Size - p_Offset;
        }
        if (p_StartByte + p_Length > p_Destination.length && p_Destination.length - p_StartByte < intBytesToCopy) {
            intBytesToCopy = p_Destination.length - p_StartByte;
        }
        System.arraycopy(this.m_Data, p_Offset, p_Destination, p_StartByte, intBytesToCopy);
        for (int intByte = intBytesToCopy; intByte < p_Length; ++intByte) {
            p_Destination[intByte] = 0;
        }
        return true;
    }

    public boolean getByteDataInt(int p_Offset, ArrayList<Integer> p_Destination, int p_StartByte, int p_Length) {
        if (p_Destination == null) {
            return false;
        }
        if (p_Destination.size() <= 0) {
            return false;
        }
        int intBytesToCopy = p_Length;
        if (p_Offset + p_Length > this.m_Size) {
            intBytesToCopy = this.m_Size - p_Offset;
        }
        if (p_StartByte + p_Length > p_Destination.size() && p_Destination.size() - p_StartByte < intBytesToCopy) {
            intBytesToCopy = p_Destination.size() - p_StartByte;
        }
        System.arraycopy(this.m_Data, p_Offset, p_Destination, p_StartByte, intBytesToCopy);
        for (int intByte = intBytesToCopy; intByte < p_Length; ++intByte) {
            p_Destination.set(intByte, this.m_Data[intByte] & 0xFF);
        }
        return true;
    }

    public int setByteArray(byte[] p_ByteArray, int p_SrcStartByte, int p_DestOffset, int p_Length) {
        int intBytesToCopy = p_Length;
        if (p_SrcStartByte + p_Length > p_ByteArray.length) {
            intBytesToCopy = p_ByteArray.length - p_SrcStartByte;
        }
        if (intBytesToCopy > this.m_Size - p_DestOffset) {
            intBytesToCopy = this.m_Size - p_DestOffset;
        }
        if (intBytesToCopy > 0) {
            System.arraycopy(p_ByteArray, p_SrcStartByte, this.m_Data, p_DestOffset, intBytesToCopy);
        }
        return intBytesToCopy;
    }

    public int setBytesFromIntList(ArrayList<Integer> p_IntegerArray, int p_Offset, int p_Length) {
        if (p_IntegerArray == null) {
            return 0;
        }
        if (p_IntegerArray.size() <= 0) {
            return 0;
        }
        int intBytesToCopy = p_Length;
        if (p_Length > p_IntegerArray.size()) {
            intBytesToCopy = p_IntegerArray.size();
        }
        if (intBytesToCopy > this.m_Size - p_Offset) {
            intBytesToCopy = this.m_Size - p_Offset;
        }
        for (int intByte = 0; intByte < intBytesToCopy; ++intByte) {
            this.m_Data[p_Offset + intByte] = (byte)(p_IntegerArray.get(intByte) & 0xFF);
        }
        return intBytesToCopy;
    }

    public int[] getIntegerArray(int p_StartByte, int p_Length) {
        int intByte;
        int intBytesToCopy = p_StartByte + p_Length > this.m_Size ? this.m_Size - p_StartByte : p_Length;
        int[] o_Bytes = new int[intBytesToCopy];
        for (intByte = 0; intByte < intBytesToCopy; ++intByte) {
            o_Bytes[intByte] = this.m_Data[p_StartByte + intByte] & 0xFF;
        }
        for (intByte = intBytesToCopy; intByte < o_Bytes.length; ++intByte) {
            o_Bytes[intByte] = 0;
        }
        return o_Bytes;
    }

    public int setBytesFromIntegerArray(int[] p_IntegerArray, int p_Offset, int p_StartByte, int p_Length) {
        int intBytesToCopy = p_Length;
        if (p_Offset + p_Length > this.m_Data.length) {
            intBytesToCopy = this.m_Data.length - p_Offset;
        }
        if (intBytesToCopy > p_IntegerArray.length - p_StartByte) {
            intBytesToCopy = p_IntegerArray.length - p_StartByte;
        }
        for (int intByte = 0; intByte < intBytesToCopy; ++intByte) {
            this.m_Data[p_Offset + intByte] = (byte)(p_IntegerArray[p_StartByte + intByte] & 0xFF);
        }
        return intBytesToCopy;
    }

    public byte getByte(int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        return this.m_Data[p_Offset];
    }

    public int setByte(int p_Value, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        this.m_Data[p_Offset] = (byte)(p_Value & 0xFF);
        return 1;
    }

    public int setInt16(int p_Value, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        this.m_Data[p_Offset + 0] = (byte)(p_Value & 0xFF);
        this.m_Data[p_Offset + 1] = (byte)((p_Value & 0xFF00) >> 8);
        return 2;
    }

    public int getInt16(int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        int intValue = 0;
        intValue += this.m_Data[p_Offset] & 0xFF;
        return intValue += (this.m_Data[p_Offset + 1] & 0xFF) << 8;
    }

    public int setInt(int p_Value, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        this.m_Data[p_Offset + 0] = (byte)(p_Value & 0xFF);
        this.m_Data[p_Offset + 1] = (byte)((p_Value & 0xFF00) >> 8);
        this.m_Data[p_Offset + 2] = (byte)((p_Value & 0xFF0000) >> 16);
        this.m_Data[p_Offset + 3] = (byte)((p_Value & 0xFF000000) >> 24);
        return 4;
    }

    public int getInt(int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        int intValue = 0;
        intValue += this.m_Data[p_Offset] & 0xFF;
        intValue += (this.m_Data[p_Offset + 1] & 0xFF) << 8;
        intValue += (this.m_Data[p_Offset + 2] & 0xFF) << 16;
        return intValue += (this.m_Data[p_Offset + 3] & 0xFF) << 24;
    }

    public int setLong(long p_Value, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 8) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        this.m_Data[p_Offset + 0] = (byte)(p_Value & 0xFFL);
        this.m_Data[p_Offset + 1] = (byte)((p_Value & 0xFF00L) >> 8);
        this.m_Data[p_Offset + 2] = (byte)((p_Value & 0xFF0000L) >> 16);
        this.m_Data[p_Offset + 3] = (byte)((p_Value & 0xFF000000L) >> 24);
        this.m_Data[p_Offset + 4] = (byte)((p_Value & 0xFF00000000L) >> 32);
        this.m_Data[p_Offset + 5] = (byte)((p_Value & 0xFF0000000000L) >> 40);
        this.m_Data[p_Offset + 6] = (byte)((p_Value & 0xFF000000000000L) >> 48);
        this.m_Data[p_Offset + 7] = (byte)((p_Value & 0xFF00000000000000L) >> 56);
        return 8;
    }

    public long getLong(int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + 8) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        long intValue = 0L;
        intValue += (long)(this.m_Data[p_Offset] & 0xFF);
        intValue += (long)(this.m_Data[p_Offset + 1] & 0xFF) << 8;
        intValue += (long)(this.m_Data[p_Offset + 2] & 0xFF) << 16;
        intValue += (long)(this.m_Data[p_Offset + 3] & 0xFF) << 24;
        intValue += (long)(this.m_Data[p_Offset + 4] & 0xFF) << 32;
        intValue += (long)(this.m_Data[p_Offset + 5] & 0xFF) << 40;
        intValue += (long)(this.m_Data[p_Offset + 6] & 0xFF) << 48;
        return intValue += (long)(this.m_Data[p_Offset + 7] & 0xFF) << 56;
    }

    public String getString(int p_Offset, int p_Length) throws Exception {
        int intPos;
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        for (intPos = 0; intPos < p_Length && this.m_Data[p_Offset + intPos] != 0; ++intPos) {
        }
        if (intPos >= p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        return new String(this.m_Data, p_Offset, intPos, CHARSET);
    }

    public int setString(String p_String, int p_Offset, int p_Length) throws Exception {
        if (p_String == null) {
            throw new Exception(s_ParseError);
        }
        if (p_Offset < 0) {
            throw new Exception(s_ParseError);
        }
        int intMaxStringLength = p_Length - 1;
        if (intMaxStringLength < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (this.m_Data == null || this.m_Size < p_Offset + p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        StringBuilder o_StringBuilder = new StringBuilder(p_Length);
        if (p_String.length() > intMaxStringLength) {
            o_StringBuilder.append(p_String, 0, intMaxStringLength);
        } else {
            o_StringBuilder.append(p_String);
        }
        System.arraycopy(o_StringBuilder.toString().getBytes(CHARSET), 0, this.m_Data, p_Offset, o_StringBuilder.length());
        if (o_StringBuilder.length() < p_Length) {
            this.m_Data[p_Offset + p_String.length()] = 0;
        }
        return p_Length;
    }

    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_ReceivedLength) {
        if (this.m_DataReceiveRestCount == 0) {
            return p_Offset;
        }
        this.m_DataReceiveRestCount = this.m_Size - this.m_DataReceivedCount;
        int intBytesToRead = p_ReceivedLength - p_Offset >= this.m_DataReceiveRestCount ? this.m_DataReceiveRestCount : p_ReceivedLength - p_Offset;
        System.arraycopy(p_Data, p_Offset, this.m_Data, this.m_DataReceivedCount, intBytesToRead);
        this.m_DataReceivedCount += intBytesToRead;
        this.m_DataReceiveRestCount -= intBytesToRead;
        if (this.m_DataReceiveRestCount == 0) {
            // empty if block
        }
        return p_Offset + intBytesToRead;
    }

    public boolean isReceived() {
        return this.m_DataReceiveRestCount <= 0;
    }

    public void resetReceive() {
        this.m_DataReceivedCount = 0;
        this.m_DataReceiveRestCount = this.m_Size;
    }

    protected void setError() {
    }

    public int getSize() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Size;
    }

    public byte[] getData(int p_Size) {
        if (p_Size != this.m_Data.length) {
            return null;
        }
        return this.m_Data;
    }

    public boolean isFilled() {
        return this.m_DataFilledRestCount <= 0;
    }

    public int fillByteArray(byte[] p_ByteArray, int p_Offset) {
        if (p_ByteArray == null) {
            return p_Offset;
        }
        if (this.m_DataFilledRestCount <= 0) {
            return p_Offset;
        }
        int intByteArrayOffset = p_Offset;
        int intBytesToFill = this.m_Size - this.m_DataFilledCount;
        if (p_ByteArray.length - intByteArrayOffset < intBytesToFill) {
            intBytesToFill = p_ByteArray.length - intByteArrayOffset;
        }
        try {
            System.arraycopy(this.m_Data, this.m_DataFilledCount, p_ByteArray, intByteArrayOffset, intBytesToFill);
            intByteArrayOffset += intBytesToFill;
            this.m_DataFilledCount += intBytesToFill;
            this.m_DataFilledRestCount -= intBytesToFill;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intByteArrayOffset;
    }

    public void resetFilled() {
        this.m_DataFilledCount = 0;
        this.m_DataFilledRestCount = this.m_Size;
    }

    public static interface ACNData_BytesListener {
        public void eventChanged(ArtNetData_Bytes var1);
    }
}

