/*
 * Decompiled with CFR 0.152.
 */
package ACN_Direct_1_31_Package;

import ACN_Direct_1_31_Package.ACN_Direct_Data_Bytes;
import ACN_Direct_1_31_Package.ACN_Direct_Receiver;
import ACN_Direct_1_31_Package.ACN_Direct_Sender;
import NetworkTools.UDP_Transport_Multicast;
import ProtocolPackage.Protocols;
import java.net.InetAddress;
import java.util.ArrayList;

public class ACN_Direct_ProtocolConfiguration_ACN_1_31
extends Protocols.ProtocolConfiguration
implements Protocols.ProtocolSenderInterface {
    public static final int SOFTWAREVERSION = 1;
    public static int ACN_REFRESHTIME = 2000;
    public static int ACN_TIMEOUT = 2500;
    public static int SocketSOTimeout = 1000;
    private int m_UniverseNumber;
    private InetAddress m_MulticastInetAddress;
    private int m_MulticastPort;
    private int m_TimeoutSeconds;
    private UDP_Transport_Multicast m_UDP_Transport_Multicast;
    private ACN_Direct_Sender m_ACNSender;
    private ACN_Direct_Receiver m_ACNReceiver;
    private ACNInterpreter m_ACNInterpreter;
    private int m_ConnectionStatus;
    private InetAddress m_LocalInetAddress;

    public ACN_Direct_ProtocolConfiguration_ACN_1_31(Protocols.ProtocolLANInterface p_ProtocolLANInterface) {
        super(3, p_ProtocolLANInterface);
        this.initMembers();
        this.setDMXUniverseNumber(0);
    }

    private void initMembers() {
        this.m_UniverseNumber = 0;
        this.m_MulticastPort = Protocols.ACN_1_31_PORT;
        this.m_TimeoutSeconds = 1;
        this.m_ConnectionStatus = 2;
        this.m_LocalInetAddress = null;
    }

    @Override
    public void close() {
        this.disconnect();
        this.m_ACNInterpreter = null;
    }

    public void setACNInterpreter(ACNInterpreter p_ACNInterpreter) {
        this.m_ACNInterpreter = p_ACNInterpreter;
    }

    public int getDMXUniverseNumber() {
        return this.m_UniverseNumber;
    }

    public void setDMXUniverseNumber(int p_DMXUniverseNumber) {
        if (this.m_UniverseNumber == p_DMXUniverseNumber) {
            return;
        }
        this.m_UniverseNumber = p_DMXUniverseNumber;
        InetAddress o_InetAddress = this.constructMulticastInetAddress();
        if (o_InetAddress != null) {
            this.m_MulticastInetAddress = o_InetAddress;
        }
    }

    public void setTimeout_Milliseconds(int p_Seconds) {
        this.m_TimeoutSeconds = p_Seconds < 0 ? 0 : p_Seconds;
    }

    public static int getTimeout_Milliseconds() {
        return ACN_REFRESHTIME;
    }

    private InetAddress constructMulticastInetAddress() {
        InetAddress o_InetAddress;
        int intUniverse = this.m_UniverseNumber;
        int intLow = intUniverse & 0xFF;
        int intHigh = (intUniverse >>>= 8) & 0xFF;
        StringBuilder stringInetAddress = new StringBuilder();
        stringInetAddress.append("239.255.");
        stringInetAddress.append(intHigh);
        stringInetAddress.append(".");
        stringInetAddress.append(intLow);
        try {
            o_InetAddress = InetAddress.getByName(stringInetAddress.toString());
        }
        catch (Exception e) {
            o_InetAddress = null;
        }
        return o_InetAddress;
    }

    public int connect(InetAddress p_LocalInetAddress, int p_LocalPort) {
        if (p_LocalInetAddress == null) {
            return 2;
        }
        if (p_LocalPort < 0) {
            p_LocalPort = 0;
        }
        this.disconnect();
        this.m_UDP_Transport_Multicast = new UDP_Transport_Multicast();
        boolean boolSuccess = this.m_UDP_Transport_Multicast.bind(p_LocalInetAddress, Integer.valueOf(p_LocalPort));
        if (boolSuccess) {
            this.m_UDP_Transport_Multicast.setSOTimeout(SocketSOTimeout);
            boolSuccess = this.m_UDP_Transport_Multicast.joinGroup(this.getRemoteInetAddress(), Protocols.ACN_1_31_PORT);
        }
        if (boolSuccess) {
            this.m_LocalInetAddress = p_LocalInetAddress;
            this.m_ConnectionStatus = 5;
            this.m_ACNReceiver = new ACN_Direct_Receiver(this);
            this.m_ACNReceiver.setUDP_Transport(this.m_UDP_Transport_Multicast);
            this.m_ACNSender = new ACN_Direct_Sender(this);
            this.m_ACNSender.setUDP_Transport(this.m_UDP_Transport_Multicast);
            this.m_ACNSender.setActive(true);
            this.m_ACNReceiver.setActive(true);
            this.m_ConnectionStatus = 5;
        } else {
            this.m_ConnectionStatus = 2;
        }
        return this.m_ConnectionStatus;
    }

    @Override
    public boolean disconnect() {
        this.m_LocalInetAddress = null;
        UDP_Transport_Multicast o_UDP_Transport = this.m_UDP_Transport_Multicast;
        this.m_UDP_Transport_Multicast = null;
        ACN_Direct_Receiver o_ACNReceiver = this.m_ACNReceiver;
        this.m_ACNReceiver = null;
        ACN_Direct_Sender o_ACNSender = this.m_ACNSender;
        this.m_ACNSender = null;
        if (this.m_ConnectionStatus <= 2) {
            return true;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.close();
        }
        if (o_ACNReceiver != null) {
            o_ACNReceiver.close();
        }
        if (o_ACNSender != null) {
            o_ACNSender.close();
        }
        this.m_ConnectionStatus = 2;
        return true;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        return this.m_LocalInetAddress;
    }

    @Override
    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    public void eventReceivedACN_1_31(ACN_Direct_Data_Bytes p_ACN_1_31_Frame, InetAddress p_RemoteInetAddress) {
        if (p_ACN_1_31_Frame == null) {
            return;
        }
        ACNInterpreter o_ACNInterpreter = this.m_ACNInterpreter;
        if (o_ACNInterpreter == null) {
            return;
        }
        o_ACNInterpreter.eventReceivedACN_1_31(this, p_ACN_1_31_Frame, p_RemoteInetAddress);
    }

    public InetAddress getRemoteInetAddress() {
        return this.m_MulticastInetAddress;
    }

    public int getRemotePort() {
        return this.m_MulticastPort;
    }

    @Override
    public byte[] getLocalUUID() {
        Protocols.ProtocolLANInterface o_ProtocolLANInterface = this.m_ProtocolLANInterface;
        if (o_ProtocolLANInterface == null) {
            return null;
        }
        return o_ProtocolLANInterface.getLocalUUID();
    }

    public String getSourceName() {
        Protocols.ProtocolLANInterface o_ProtocolLANInterface = this.m_ProtocolLANInterface;
        if (o_ProtocolLANInterface == null) {
            return null;
        }
        return o_ProtocolLANInterface.getSourceName();
    }

    @Override
    public boolean writeValues(Protocols.ProtocolPlugInInterface p_ProtocolPlugInInterface, InetAddress p_RemoteAddress, int p_SequenceNumber, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        boolean boolSended = false;
        ACN_Direct_Sender o_ACNSender = this.m_ACNSender;
        if (o_ACNSender == null) {
            return false;
        }
        int intUniverseNumber = this.getDMXUniverseNumber();
        if (intUniverseNumber < 0) {
            return false;
        }
        boolSended = o_ACNSender.sendDMXUniverseValues(this.getRemoteInetAddress(), intUniverseNumber, p_ChangedAddresses, p_AllValues, this.getLANProtocolType());
        if (boolSended) {
            // empty if block
        }
        return boolSended;
    }

    public static interface ACNInterpreter {
        public void eventReceivedACN_1_31(ACN_Direct_ProtocolConfiguration_ACN_1_31 var1, ACN_Direct_Data_Bytes var2, InetAddress var3);
    }
}

