/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import java.util.ArrayList;
import java.util.HashMap;

public class ACN_ByteData {
    public static HashMap<Integer, ArrayList<ACN_ByteData>> s_Pool = new HashMap();
    public static final Object s_SyncPool = new Object();
    public static int s_MaxPoolSIze = 100;
    public static int s_MaxPoolListSize = 200;
    protected int m_Size;
    protected byte[] m_Data;
    protected int m_DataReceivedCount;
    protected int m_DataReceiveRestCount;
    protected int m_DataFilledCount;
    protected int m_DataFilledRestCount;
    protected boolean m_Closed;
    protected ArrayList<ACN_ByteDataListener> m_Listeners;
    protected final Object m_SyncListeners = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolAddEmpty(ACN_ByteData p_ACN_ByteData) {
        if (p_ACN_ByteData == null) {
            return;
        }
        int intSize = p_ACN_ByteData.getSize();
        Object object = s_SyncPool;
        synchronized (object) {
            ArrayList<ACN_ByteData> o_ListACN_ByteData = s_Pool.get(intSize);
            if (o_ListACN_ByteData == null) {
                if (s_Pool.size() >= s_MaxPoolSIze) {
                    return;
                }
                o_ListACN_ByteData = new ArrayList();
                s_Pool.put(intSize, o_ListACN_ByteData);
            } else if (o_ListACN_ByteData.size() >= s_MaxPoolListSize) {
                return;
            }
            o_ListACN_ByteData.add(p_ACN_ByteData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ACN_ByteData poolGet(int p_Size) {
        if (p_Size < 0) {
            p_Size = 0;
        }
        ACN_ByteData o_ACN_ByteData = null;
        Object object = s_SyncPool;
        synchronized (object) {
            ArrayList<ACN_ByteData> o_ListACN_ByteData = s_Pool.get(p_Size);
            if (o_ListACN_ByteData != null && o_ListACN_ByteData.size() > 0) {
                o_ACN_ByteData = o_ListACN_ByteData.get(o_ListACN_ByteData.size() - 1);
                o_ListACN_ByteData.remove(o_ListACN_ByteData.size() - 1);
                o_ACN_ByteData.refresh();
                return o_ACN_ByteData;
            }
        }
        return new ACN_ByteData(p_Size);
    }

    public ACN_ByteData(int p_Size) {
        this.initMembers();
        if (p_Size < 0) {
            p_Size = 0;
        }
        this.m_Size = p_Size;
        this.initMembersFurther();
    }

    private void initMembers() {
        this.m_DataReceivedCount = 0;
        this.m_DataFilledCount = 0;
        this.m_Listeners = new ArrayList();
    }

    private void initMembersFurther() {
        this.m_Data = new byte[this.m_Size];
        for (int intByte = 0; intByte < this.m_Size; ++intByte) {
            this.m_Data[intByte] = 0;
        }
        this.m_DataReceiveRestCount = this.m_Size;
        this.m_DataFilledRestCount = this.m_Size;
        this.m_Closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.m_DataReceivedCount = 0;
        this.m_DataFilledCount = 0;
        for (int intByte = 0; intByte < this.m_Data.length; ++intByte) {
            this.m_Data[intByte] = 0;
        }
        this.m_DataReceiveRestCount = this.m_Size;
        this.m_DataFilledRestCount = this.m_Size;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_Listeners.clear();
        }
        this.m_Closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_Listeners.clear();
        }
        ACN_ByteData.poolAddEmpty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeByExtendedClass() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_Listeners.clear();
        }
    }

    public byte getByte(int p_Index) {
        if (p_Index < 0) {
            return 0;
        }
        if (p_Index >= this.m_Data.length) {
            return 0;
        }
        return this.m_Data[p_Index];
    }

    public void setByte(int p_Index, byte p_Byte) {
        if (p_Index < 0) {
            return;
        }
        if (p_Index >= this.m_Data.length) {
            return;
        }
        this.m_Data[p_Index] = p_Byte;
        this.fireEventChanged();
    }

    public byte[] getByteArray(int p_StartByte, int p_Length) {
        int intBytesToCopy = p_StartByte + p_Length > this.m_Data.length ? this.m_Data.length - p_StartByte : p_Length;
        byte[] o_Bytes = new byte[p_Length];
        System.arraycopy(this.m_Data, p_StartByte, o_Bytes, 0, intBytesToCopy);
        for (int intByte = intBytesToCopy; intByte < p_Length; ++intByte) {
            o_Bytes[intByte] = 0;
        }
        return o_Bytes;
    }

    public void setByteArray(byte[] p_ByteArray, int p_Offset, int p_StartByte, int p_Length) {
        int intBytesToCopy = p_Length;
        if (p_Offset + p_Length > p_ByteArray.length) {
            intBytesToCopy = p_ByteArray.length - p_Offset;
        }
        if (intBytesToCopy > this.m_Data.length - p_StartByte) {
            intBytesToCopy = this.m_Data.length - p_StartByte;
        }
        System.arraycopy(p_ByteArray, p_Offset, this.m_Data, p_StartByte, intBytesToCopy);
        this.fireEventChanged();
    }

    public int[] getIntegerArray(int p_StartByte, int p_Length) {
        int intByte;
        int intBytesToCopy = p_StartByte + p_Length > this.m_Data.length ? this.m_Data.length - p_StartByte : p_Length;
        int[] o_Bytes = new int[intBytesToCopy];
        for (intByte = 0; intByte < intBytesToCopy; ++intByte) {
            o_Bytes[intByte] = this.m_Data[p_StartByte + intByte] & 0xFF;
        }
        for (intByte = intBytesToCopy; intByte < o_Bytes.length; ++intByte) {
            o_Bytes[intByte] = 0;
        }
        return o_Bytes;
    }

    public void setIntegerArray(int[] p_IntegerArray, int p_Offset, int p_StartByte, int p_Length) {
        int intBytesToCopy = p_Length;
        if (p_Offset + p_Length > p_IntegerArray.length) {
            intBytesToCopy = p_IntegerArray.length - p_Offset;
        }
        if (intBytesToCopy > this.m_Data.length - p_StartByte) {
            intBytesToCopy = this.m_Data.length - p_StartByte;
        }
        for (int intByte = 0; intByte < intBytesToCopy; ++intByte) {
            this.m_Data[p_StartByte + intByte] = (byte)(p_IntegerArray[p_Offset + intByte] & 0xFF);
        }
        this.fireEventChanged();
    }

    public int getInt() {
        if (this.m_Data == null) {
            return 0;
        }
        if (this.m_Data.length == 0) {
            return 0;
        }
        int intResult = 0;
        int intLength = this.m_Data.length >= 32 ? 32 : this.m_Data.length;
        for (int intByte = 0; intByte < intLength; ++intByte) {
            intResult += this.m_Data[intByte] & 0xFF;
            if (intByte >= intLength - 1) continue;
            intResult <<= 8;
        }
        return intResult;
    }

    public void setInt(int p_Int) {
        int intParam = p_Int;
        int intLength = this.m_Data.length;
        for (int intByte = intLength - 1; intByte >= 0; --intByte) {
            if (intByte < 32) {
                this.m_Data[intByte] = (byte)(intParam & 0xFF);
                intParam >>= 8;
                continue;
            }
            this.m_Data[intByte] = 0;
        }
        this.fireEventChanged();
    }

    public String getString() {
        return this.getString("UTF-8");
    }

    public String getString(String p_CharsetName) {
        String stringResult;
        try {
            stringResult = new String(this.m_Data, p_CharsetName);
        }
        catch (Exception e) {
            return null;
        }
        return stringResult;
    }

    public void setString(String p_String) {
        this.setString(p_String, "UTF-8");
    }

    public void setString(String p_String, String p_CharsetName) {
        byte[] o_StringArray = null;
        int intLength = 0;
        if (p_String != null) {
            try {
                o_StringArray = p_String.getBytes(p_CharsetName);
                intLength = o_StringArray.length;
            }
            catch (Exception e) {
                intLength = 0;
                o_StringArray = new byte[]{};
            }
        }
        int intLengthMax = intLength > this.m_Data.length ? this.m_Data.length : intLength;
        System.arraycopy(o_StringArray, 0, this.m_Data, 0, intLengthMax);
        for (int intByte = intLengthMax; intByte < this.m_Data.length; ++intByte) {
            this.m_Data[intByte] = 0;
        }
        this.fireEventChanged();
    }

    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length) {
        if (this.m_DataReceiveRestCount == 0) {
            return p_Offset;
        }
        this.m_DataReceiveRestCount = this.m_Data.length - this.m_DataReceivedCount;
        int intBytesToRead = p_Length - p_Offset >= this.m_DataReceiveRestCount ? this.m_DataReceiveRestCount : p_Length - p_Offset;
        System.arraycopy(p_Data, p_Offset, this.m_Data, this.m_DataReceivedCount, intBytesToRead);
        this.m_DataReceivedCount += intBytesToRead;
        this.m_DataReceiveRestCount -= intBytesToRead;
        if (this.m_DataReceiveRestCount == 0 && !this.analyze()) {
            return -1;
        }
        return p_Offset + intBytesToRead;
    }

    public boolean isReceived() {
        return this.m_DataReceiveRestCount <= 0;
    }

    public void resetReceive() {
        this.m_DataReceivedCount = 0;
        this.m_DataReceiveRestCount = this.m_Size;
    }

    protected void setError() {
    }

    public void setSize(int p_Size) {
        if (p_Size < 0) {
            return;
        }
        if (p_Size == this.m_Data.length) {
            return;
        }
        byte[] o_NewByteArray = new byte[p_Size];
        int intBytesToCopy = o_NewByteArray.length > this.m_Data.length ? this.m_Data.length : o_NewByteArray.length;
        System.arraycopy(this.m_Data, 0, o_NewByteArray, 0, intBytesToCopy);
        for (int intByte = intBytesToCopy; intByte < o_NewByteArray.length; ++intByte) {
            o_NewByteArray[intByte] = 0;
        }
        this.m_DataReceiveRestCount += o_NewByteArray.length - this.m_Data.length;
        if (this.m_DataReceiveRestCount < 0) {
            this.m_DataReceiveRestCount = 0;
        }
        if (this.m_DataReceivedCount > o_NewByteArray.length) {
            this.m_DataReceivedCount = o_NewByteArray.length;
        }
        this.m_DataFilledRestCount += o_NewByteArray.length - this.m_Data.length;
        if (this.m_DataFilledRestCount < 0) {
            this.m_DataFilledRestCount = 0;
        }
        if (this.m_DataFilledCount > o_NewByteArray.length) {
            this.m_DataReceivedCount = o_NewByteArray.length;
        }
        this.m_Data = o_NewByteArray;
        this.fireEventChanged();
    }

    public int getSize() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.length;
    }

    public byte[] getData() {
        return this.m_Data;
    }

    public boolean analyze() {
        return true;
    }

    public boolean isFilled() {
        return this.m_DataFilledRestCount <= 0;
    }

    public int fillByteArray(byte[] p_ByteArray, int p_Offset) {
        if (p_ByteArray == null) {
            return p_Offset;
        }
        if (this.m_DataFilledRestCount <= 0) {
            return p_Offset;
        }
        int intByteArrayOffset = p_Offset;
        int intBytesToFill = this.m_Data.length - this.m_DataFilledCount;
        if (p_ByteArray.length - intByteArrayOffset < intBytesToFill) {
            intBytesToFill = p_ByteArray.length - intByteArrayOffset;
        }
        try {
            System.arraycopy(this.m_Data, this.m_DataFilledCount, p_ByteArray, intByteArrayOffset, intBytesToFill);
            intByteArrayOffset += intBytesToFill;
            this.m_DataFilledCount += intBytesToFill;
            this.m_DataFilledRestCount -= intBytesToFill;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intByteArrayOffset;
    }

    public void resetFilled() {
        this.m_DataFilledCount = 0;
        this.m_DataFilledRestCount = this.m_Size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ACN_ByteDataListener p_ACN_ByteDataListener) {
        if (p_ACN_ByteDataListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.contains(p_ACN_ByteDataListener)) {
                return;
            }
            this.m_Listeners.add(p_ACN_ByteDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ACN_ByteDataListener p_ACN_ByteDataListener) {
        if (p_ACN_ByteDataListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_Listeners.contains(p_ACN_ByteDataListener)) {
                return;
            }
            this.m_Listeners.remove(p_ACN_ByteDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEventChanged() {
        ArrayList<ACN_ByteDataListener> o_ACN_ByteDataListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.size() <= 0) {
                return;
            }
            o_ACN_ByteDataListeners = new ArrayList<ACN_ByteDataListener>(this.m_Listeners.size());
            o_ACN_ByteDataListeners.addAll(this.m_Listeners);
        }
        for (int intListener = 0; intListener < o_ACN_ByteDataListeners.size(); ++intListener) {
            ACN_ByteDataListener o_ACN_ByteDataListener = (ACN_ByteDataListener)o_ACN_ByteDataListeners.get(intListener);
            o_ACN_ByteDataListener.eventChanged(this);
        }
    }

    public static interface ACN_ByteDataListener {
        public void eventChanged(ACN_ByteData var1);
    }
}

