/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import ACN_1_17_Package.ACNData_Interface;
import ACN_1_17_Package.ACN_ByteData;
import ACN_1_17_Package.ACN_PDU;
import ACN_1_17_Package.ACN_RootLayer;
import java.util.ArrayList;

public class ACNDataPackage {
    public static String ERRORSTRING_WRONGPREAMBLE = "Wrong Preamble";
    private Preample m_Preample;
    private Postample m_Postample;
    private int m_PositionReceived;
    private int m_PositionFilled;
    private boolean m_IsReceived;
    private boolean m_HasReceivedData;
    private boolean m_IsFilled;
    private boolean m_HasFilledData;
    protected ArrayList<ACN_PDU> m_ACN_PDUs;

    public ACNDataPackage() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_PositionReceived = 0;
        this.m_PositionFilled = 0;
        this.m_IsReceived = false;
        this.m_HasReceivedData = false;
        this.m_IsFilled = false;
        this.m_HasFilledData = false;
        this.m_Preample = new Preample(this);
        this.m_Postample = new Postample(0);
        this.m_ACN_PDUs = new ArrayList();
    }

    public void close() {
        if (this.m_Postample != null) {
            this.m_Preample.close();
        }
        for (int intPDU = this.m_ACN_PDUs.size() - 1; intPDU >= 0; --intPDU) {
            ACN_PDU o_Acn_pdu = this.m_ACN_PDUs.get(intPDU);
            this.m_ACN_PDUs.remove(o_Acn_pdu);
            o_Acn_pdu.close();
        }
        if (this.m_Postample != null) {
            this.m_Postample.close();
        }
    }

    public Preample getPreample() {
        return this.m_Preample;
    }

    public Postample getPostample() {
        return this.m_Postample;
    }

    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length) {
        ACN_PDU o_ACN_PDU = null;
        int intNewOffset = p_Offset;
        if (!this.m_Preample.isReceived()) {
            if ((intNewOffset = this.m_Preample.eventDataReceived(p_Data, intNewOffset, p_Length)) < 0) {
                this.resetReceived();
                return intNewOffset;
            }
            if (!this.m_Preample.isReceived()) {
                return intNewOffset;
            }
            if (this.m_Preample.getPostampleSize() > 0) {
                this.m_Postample.setSize(this.m_Preample.getPostampleSize());
            }
        }
        while (intNewOffset < p_Length - this.m_Preample.getPostampleSize()) {
            if (this.m_ACN_PDUs.size() > 0 && (o_ACN_PDU = this.m_ACN_PDUs.get(this.m_ACN_PDUs.size() - 1)).isReceived()) {
                o_ACN_PDU = null;
            }
            if (o_ACN_PDU == null) {
                o_ACN_PDU = new ACN_PDU(this.m_PositionReceived, null, ACN_RootLayer.getInstance());
                this.m_ACN_PDUs.add(o_ACN_PDU);
            }
            intNewOffset = o_ACN_PDU.eventDataReceived(p_Data, intNewOffset, p_Length, this.m_PositionReceived);
            this.m_PositionReceived += intNewOffset - p_Offset;
            if (o_ACN_PDU.isReceived()) continue;
            return intNewOffset;
        }
        if (this.m_Postample.getSize() > 0 && !this.m_Postample.isReceived()) {
            intNewOffset = this.m_Postample.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_Postample.isReceived()) {
                return intNewOffset;
            }
        }
        this.m_IsReceived = true;
        return intNewOffset;
    }

    public boolean isReceived() {
        return this.m_IsReceived;
    }

    public void resetReceived() {
        if (!this.m_HasReceivedData) {
            return;
        }
        this.m_HasReceivedData = false;
        this.m_Preample.resetReceive();
        for (int intPDU = 0; intPDU < this.m_ACN_PDUs.size(); ++intPDU) {
            this.m_ACN_PDUs.get(intPDU).resetReceive();
        }
        this.m_Postample.resetReceive();
        this.m_IsReceived = false;
    }

    public int getACNRootCount() {
        return this.m_ACN_PDUs.size();
    }

    public ACN_RootLayer.ACN_Root getACN_Root(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_ACN_PDUs.size()) {
            return null;
        }
        return (ACN_RootLayer.ACN_Root)this.m_ACN_PDUs.get(p_Index).getACNData();
    }

    public void addACNRoot(ACN_RootLayer.ACN_Root p_ACN_Root) {
        if (p_ACN_Root == null) {
            return;
        }
        ACN_PDU o_Acn_pdu = p_ACN_Root.getACN_PDU();
        if (this.m_ACN_PDUs.contains(o_Acn_pdu)) {
            return;
        }
        this.m_ACN_PDUs.add(o_Acn_pdu);
    }

    public int getByteSize() {
        int intByteSize = 0;
        if (this.m_Preample != null) {
            intByteSize += this.m_Preample.getSize();
        }
        for (int intPDU = 0; intPDU < this.m_ACN_PDUs.size(); ++intPDU) {
            ACN_PDU o_ACN_PDU = this.m_ACN_PDUs.get(intPDU);
            intByteSize += o_ACN_PDU.calculateSize();
        }
        if (this.m_Postample != null) {
            intByteSize += this.m_Postample.getSize();
        }
        return intByteSize;
    }

    public byte[] createByteArray() {
        byte[] o_ByteArray = new byte[this.getByteSize()];
        int intOffset = 0;
        if (this.m_Preample != null) {
            intOffset = this.m_Preample.fillByteArray(o_ByteArray, intOffset);
        }
        int intNewOffset = this.fillByteArray(o_ByteArray, intOffset, this.m_PositionFilled);
        this.m_PositionFilled += intNewOffset - intOffset;
        intOffset = intNewOffset;
        if (this.m_Postample != null) {
            intOffset = this.m_Postample.fillByteArray(o_ByteArray, intOffset);
        }
        return o_ByteArray;
    }

    public int fillByteArray(byte[] p_ByteArray, int p_Offset, int p_Position) {
        int intNewOffset = p_Offset;
        int intNewPosition = p_Position;
        for (int intObject = 0; intObject < this.m_ACN_PDUs.size(); ++intObject) {
            ACN_PDU o_ACN_PDU = this.m_ACN_PDUs.get(intObject);
            intNewOffset = o_ACN_PDU.fillByteArray(p_ByteArray, intNewOffset, intNewPosition);
            if (!o_ACN_PDU.isFilled()) {
                return intNewOffset;
            }
            intNewPosition = p_Position + intNewOffset - p_Offset;
        }
        return intNewOffset;
    }

    public boolean isFilled() {
        return this.m_IsFilled;
    }

    public void resetFilled() {
        if (!this.m_HasFilledData) {
            return;
        }
        this.m_HasFilledData = false;
        this.m_Preample.resetFilled();
        for (int intPDU = 0; intPDU < this.m_ACN_PDUs.size(); ++intPDU) {
            this.m_ACN_PDUs.get(intPDU).resetFilled();
        }
        this.m_Postample.resetFilled();
        this.m_IsFilled = false;
    }

    public void setError(ACNData_Interface p_ACNData_Interface, ACN_PDU p_ACN_PDU, String p_ErrorCause) {
    }

    public static class Postample
    extends ACN_ByteData {
        public Postample(int p_Size) {
            super(p_Size);
            this.initMembers();
            if (p_Size >= 0) {
                this.m_Data = new byte[p_Size];
            }
        }

        private void initMembers() {
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        @Override
        public boolean analyze() {
            return true;
        }
    }

    public static class Preample
    extends ACN_ByteData {
        private ACNDataPackage m_DataPackage;
        private int m_PostampleSize;

        public Preample(ACNDataPackage p_DataPackage) {
            super(16);
            this.initMembers();
            this.m_DataPackage = p_DataPackage;
        }

        private void initMembers() {
            this.m_Data[0] = 0;
            this.m_Data[1] = 16;
            this.m_Data[2] = 0;
            this.m_Data[3] = 0;
            this.m_Data[4] = 65;
            this.m_Data[5] = 83;
            this.m_Data[6] = 67;
            this.m_Data[7] = 45;
            this.m_Data[8] = 69;
            this.m_Data[9] = 49;
            this.m_Data[10] = 46;
            this.m_Data[11] = 49;
            this.m_Data[12] = 55;
            this.m_Data[13] = 0;
            this.m_Data[14] = 0;
            this.m_Data[15] = 0;
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        @Override
        public boolean analyze() {
            if (this.m_DataReceiveRestCount > 0) {
                return false;
            }
            boolean boolError = false;
            if (this.m_Data[0] != 0) {
                boolError = true;
            }
            if (this.m_Data[1] != 16) {
                boolError = true;
            }
            this.m_PostampleSize = (this.m_Data[2] & 0xFF) << 8 | this.m_Data[3] & 0xFF;
            if (this.m_Data[4] != 65) {
                boolError = true;
            }
            if (this.m_Data[5] != 83) {
                boolError = true;
            }
            if (this.m_Data[6] != 67) {
                boolError = true;
            }
            if (this.m_Data[7] != 45) {
                boolError = true;
            }
            if (this.m_Data[8] != 69) {
                boolError = true;
            }
            if (this.m_Data[9] != 49) {
                boolError = true;
            }
            if (this.m_Data[10] != 46) {
                boolError = true;
            }
            if (this.m_Data[11] != 49) {
                boolError = true;
            }
            if (this.m_Data[12] != 55) {
                boolError = true;
            }
            if (this.m_Data[13] != 0) {
                boolError = true;
            }
            if (this.m_Data[14] != 0) {
                boolError = true;
            }
            if (this.m_Data[15] != 0) {
                boolError = true;
            }
            if (boolError) {
                this.m_DataPackage.setError(null, null, ERRORSTRING_WRONGPREAMBLE);
            }
            return !boolError;
        }

        public int getPostampleSize() {
            return this.m_PostampleSize;
        }
    }

    public static interface DataPackageListener {
        public void setError(ACNDataPackage var1, ACNData_Interface var2, ACN_PDU var3, String var4);
    }
}

