/*
 * Decompiled with CFR 0.152.
 */
package SocketMessagePackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LiveDBConnectionDescription
implements Externalizable {
    static final long serialVersionUID = -2880899033060077636L;
    public static final int SOFTWAREVERSION = 1;
    public static String DEFAULT_SERVERURL = "";
    public static int DEFAULT_SERVERPORT = 15111;
    public static final int USERSTATUS_NORMAL = 0;
    public static final int USERSTATUS_ADMIN = 1000;
    public static final int USERSTATUS_SUPERADMIN = 99999;
    private String m_ServerID;
    private String m_ServerTaskID;
    private String m_ServerLocalURL;
    private String m_ServerLocalIP;
    private int m_ServerPort;
    private String m_ServerName;
    private String m_ServerLongName;
    private String m_ClientLocalIP;
    private int m_ClientLocalPort;
    private boolean m_ClientLocalIP_TryAll;
    private String m_ClientRemoteIP;
    private String m_ServerRemoteURL;
    private String m_ServerRemoteIP;
    private String m_ServerVersion;
    private String m_ClientVersion;
    private String m_ClientLicense;
    private String m_ClientMacAddress;
    private String m_ConnectionRemark;
    private String m_ClientUserName;
    private int m_ClientUserStatus;

    public static void setDefaults(String p_ServerURL, Integer p_ServerPort) {
        if (p_ServerURL != null) {
            DEFAULT_SERVERURL = p_ServerURL;
        }
        if (p_ServerPort != null) {
            DEFAULT_SERVERPORT = p_ServerPort;
        }
    }

    public static LiveDBConnectionDescription createConnectionDescription_ClientSide(String p_ServerRemoteURL, int p_ServerPort, String p_ClientLocalIP, boolean p_TryAllInterfaces, String p_ClientVersion, String p_ClientLicense, String p_ClientMACAddress, String p_ClientUserName, int p_ClientUserStatus) {
        LiveDBConnectionDescription o_ClientConnectionDescription = new LiveDBConnectionDescription();
        o_ClientConnectionDescription.setClientLocalIP(p_ClientLocalIP);
        o_ClientConnectionDescription.setClientTryAllInterfaces(p_TryAllInterfaces);
        o_ClientConnectionDescription.setServerRemoteURL(p_ServerRemoteURL);
        o_ClientConnectionDescription.setServerPort(p_ServerPort);
        o_ClientConnectionDescription.setClientVersion(p_ClientVersion);
        o_ClientConnectionDescription.setClientLicense(p_ClientLicense);
        o_ClientConnectionDescription.setClientMacAddress(p_ClientMACAddress);
        o_ClientConnectionDescription.setClientUserName(p_ClientUserName);
        o_ClientConnectionDescription.setClientUserStatus(p_ClientUserStatus);
        return o_ClientConnectionDescription;
    }

    public static LiveDBConnectionDescription createConnectionDescription_ServerSide(String p_ServerLocalURL, int p_ServerPort, String p_ServerID, String p_ServerTaskID, String p_ServerName, String p_ServerLongName, String p_ServerVersion) {
        LiveDBConnectionDescription o_ServerConnectionDescription = new LiveDBConnectionDescription();
        o_ServerConnectionDescription.setServerLocalURL(p_ServerLocalURL);
        o_ServerConnectionDescription.setServerPort(p_ServerPort);
        o_ServerConnectionDescription.setServerID(p_ServerID);
        o_ServerConnectionDescription.setServerTaskID(p_ServerTaskID);
        o_ServerConnectionDescription.setServerName(p_ServerName);
        o_ServerConnectionDescription.setServerLongName(p_ServerLongName);
        o_ServerConnectionDescription.setServerVersion(p_ServerVersion);
        return o_ServerConnectionDescription;
    }

    public LiveDBConnectionDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_ServerID = "";
        this.m_ServerTaskID = "";
        this.m_ServerLocalURL = DEFAULT_SERVERURL;
        this.m_ServerLocalIP = DEFAULT_SERVERURL;
        this.m_ServerRemoteURL = DEFAULT_SERVERURL;
        this.m_ServerRemoteIP = DEFAULT_SERVERURL;
        this.m_ServerPort = DEFAULT_SERVERPORT;
        this.m_ServerName = "";
        this.m_ServerLongName = "";
        this.m_ServerVersion = "";
        this.m_ClientLocalIP = "localhost";
        this.m_ClientLocalIP_TryAll = false;
        this.m_ClientLocalPort = 0;
        this.m_ClientRemoteIP = "";
        this.m_ClientVersion = "";
        this.m_ClientLicense = "";
        this.m_ClientMacAddress = "";
        this.m_ConnectionRemark = "";
        this.m_ClientUserName = "";
        this.m_ClientUserStatus = 0;
    }

    public String getServerID() {
        return this.m_ServerID;
    }

    public void setServerID(String p_ServerID) {
        if (p_ServerID == null) {
            return;
        }
        this.m_ServerID = p_ServerID;
    }

    public String getServerTaskID() {
        return this.m_ServerTaskID;
    }

    public void setServerTaskID(String p_ServerTaskID) {
        if (p_ServerTaskID == null) {
            return;
        }
        this.m_ServerTaskID = p_ServerTaskID;
    }

    public String getServerLocalURL() {
        return this.m_ServerLocalURL;
    }

    public void setServerLocalURL(String p_ServerLocalURL) {
        if (p_ServerLocalURL == null) {
            return;
        }
        this.m_ServerLocalURL = p_ServerLocalURL;
    }

    public String getServerLocalIP() {
        return this.m_ServerLocalIP;
    }

    public void setServerLocalIP(String p_ServerLocalIP) {
        if (p_ServerLocalIP == null) {
            return;
        }
        this.m_ServerLocalIP = p_ServerLocalIP;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }

    public void setServerPort(int p_ServerPort) {
        this.m_ServerPort = p_ServerPort;
    }

    public String getServerName() {
        return this.m_ServerName;
    }

    public void setServerName(String p_ServerName) {
        if (p_ServerName == null) {
            return;
        }
        this.m_ServerName = p_ServerName;
    }

    public String getServerLongName() {
        return this.m_ServerLongName;
    }

    public void setServerLongName(String p_ServerLongName) {
        if (p_ServerLongName == null) {
            return;
        }
        this.m_ServerLongName = p_ServerLongName;
    }

    public String getClientLocalIP() {
        return this.m_ClientLocalIP;
    }

    public void setClientLocalIP(String p_ClientLocalIP) {
        if (p_ClientLocalIP == null) {
            p_ClientLocalIP = "";
        }
        this.m_ClientLocalIP = p_ClientLocalIP;
    }

    public void setClientTryAllInterfaces(boolean p_TryAll) {
        this.m_ClientLocalIP_TryAll = p_TryAll;
    }

    public boolean getClientTryAllInterfeces() {
        return this.m_ClientLocalIP_TryAll;
    }

    public int getClientLocalPort() {
        return this.m_ClientLocalPort;
    }

    public void setClientLocalPort(int p_ClientLocalPort) {
        if (p_ClientLocalPort < 0 || p_ClientLocalPort > 65534) {
            p_ClientLocalPort = 0;
        }
        this.m_ClientLocalPort = p_ClientLocalPort;
    }

    public String getServerRemoteURL() {
        return this.m_ServerRemoteURL;
    }

    public void setServerRemoteURL(String p_ServerURL) {
        if (p_ServerURL == null) {
            return;
        }
        this.m_ServerRemoteURL = p_ServerURL;
    }

    public String getServerRemoteIP() {
        return this.m_ServerRemoteIP;
    }

    public void setServerRemoteIP(String p_ServerIP) {
        if (p_ServerIP == null) {
            return;
        }
        this.m_ServerRemoteIP = p_ServerIP;
    }

    public void setClientRemoteIP(String p_ClientRemoteIP) {
        if (p_ClientRemoteIP == null) {
            return;
        }
        this.m_ClientRemoteIP = p_ClientRemoteIP;
    }

    public String getClientRemoteIP() {
        return this.m_ClientRemoteIP;
    }

    public void setServerVersion(String p_ServerVersion) {
        if (p_ServerVersion == null) {
            return;
        }
        this.m_ServerVersion = p_ServerVersion;
    }

    public String getServerVersion() {
        return this.m_ServerVersion;
    }

    public void setClientVersion(String p_ClientVersion) {
        if (p_ClientVersion == null) {
            return;
        }
        this.m_ClientVersion = p_ClientVersion;
    }

    public String getClientVersion() {
        return this.m_ClientVersion;
    }

    public void setClientLicense(String p_ClientLicense) {
        if (p_ClientLicense == null) {
            return;
        }
        this.m_ClientLicense = p_ClientLicense;
    }

    public String getClientLicense() {
        return this.m_ClientLicense;
    }

    public String getClientMacAddress() {
        return this.m_ClientMacAddress;
    }

    public void setClientMacAddress(String p_MacAddress) {
        if (p_MacAddress == null || p_MacAddress.length() <= 0) {
            return;
        }
        this.m_ClientMacAddress = p_MacAddress;
    }

    public void setConnectionRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        this.m_ConnectionRemark = p_Remark;
    }

    public String getConnectionRemark() {
        return this.m_ConnectionRemark;
    }

    public void setClientUserName(String p_ClientUserName) {
        if (p_ClientUserName == null) {
            return;
        }
        this.m_ClientUserName = p_ClientUserName;
    }

    public String getClientUserName() {
        return this.m_ClientUserName;
    }

    public void setClientUserStatus(int p_UserStatus) {
        this.m_ClientUserStatus = p_UserStatus;
    }

    public int getClientUserStatus() {
        return this.m_ClientUserStatus;
    }

    public LiveDBConnectionDescription clone(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (p_LiveDBConnectionDescription == null) {
            p_LiveDBConnectionDescription = new LiveDBConnectionDescription();
        }
        p_LiveDBConnectionDescription.setServerID(this.m_ServerID);
        p_LiveDBConnectionDescription.setServerTaskID(this.m_ServerTaskID);
        p_LiveDBConnectionDescription.setServerName(this.m_ServerName);
        p_LiveDBConnectionDescription.setServerLongName(this.m_ServerLongName);
        p_LiveDBConnectionDescription.setServerRemoteIP(this.m_ServerRemoteIP);
        p_LiveDBConnectionDescription.setServerLocalIP(this.m_ServerLocalIP);
        p_LiveDBConnectionDescription.setServerRemoteURL(this.m_ServerRemoteURL);
        p_LiveDBConnectionDescription.setServerLocalURL(this.m_ServerLocalURL);
        p_LiveDBConnectionDescription.setServerPort(this.m_ServerPort);
        p_LiveDBConnectionDescription.setServerVersion(this.m_ServerVersion);
        p_LiveDBConnectionDescription.setClientLocalIP(this.m_ClientLocalIP);
        p_LiveDBConnectionDescription.setClientTryAllInterfaces(this.m_ClientLocalIP_TryAll);
        p_LiveDBConnectionDescription.setClientLocalPort(this.m_ClientLocalPort);
        p_LiveDBConnectionDescription.setClientVersion(this.m_ClientVersion);
        p_LiveDBConnectionDescription.setClientLicense(this.m_ClientLicense);
        p_LiveDBConnectionDescription.setClientRemoteIP(this.m_ClientRemoteIP);
        p_LiveDBConnectionDescription.setClientMacAddress(this.m_ClientMacAddress);
        p_LiveDBConnectionDescription.setConnectionRemark(this.m_ConnectionRemark);
        p_LiveDBConnectionDescription.setClientUserName(this.m_ClientUserName);
        p_LiveDBConnectionDescription.setClientUserStatus(this.m_ClientUserStatus);
        return p_LiveDBConnectionDescription;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ServerID);
        out.writeUTF(this.m_ServerTaskID);
        out.writeUTF(this.m_ServerLocalURL);
        out.writeUTF(this.m_ServerLocalIP);
        out.writeInt(this.m_ServerPort);
        out.writeUTF(this.m_ServerName);
        out.writeUTF(this.m_ServerLongName);
        out.writeUTF(this.m_ClientLocalIP);
        out.writeInt(this.m_ClientLocalPort);
        out.writeBoolean(this.m_ClientLocalIP_TryAll);
        out.writeUTF(this.m_ClientRemoteIP);
        out.writeUTF(this.m_ServerRemoteURL);
        out.writeUTF(this.m_ServerRemoteIP);
        out.writeUTF(this.m_ServerVersion);
        out.writeUTF(this.m_ClientVersion);
        out.writeUTF(this.m_ClientLicense);
        out.writeUTF(this.m_ClientMacAddress);
        out.writeUTF(this.m_ConnectionRemark);
        out.writeUTF(this.m_ClientUserName);
        out.writeInt(this.m_ClientUserStatus);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ServerID = in.readUTF();
        this.m_ServerTaskID = in.readUTF();
        this.m_ServerLocalURL = in.readUTF();
        this.m_ServerLocalIP = in.readUTF();
        this.m_ServerPort = in.readInt();
        this.m_ServerName = in.readUTF();
        this.m_ServerLongName = in.readUTF();
        this.m_ClientLocalIP = in.readUTF();
        this.m_ClientLocalPort = in.readInt();
        this.m_ClientLocalIP_TryAll = in.readBoolean();
        this.m_ClientRemoteIP = in.readUTF();
        this.m_ServerRemoteURL = in.readUTF();
        this.m_ServerRemoteIP = in.readUTF();
        this.m_ServerVersion = in.readUTF();
        this.m_ClientVersion = in.readUTF();
        this.m_ClientLicense = in.readUTF();
        this.m_ClientMacAddress = in.readUTF();
        this.m_ConnectionRemark = in.readUTF();
        this.m_ClientUserName = in.readUTF();
        this.m_ClientUserStatus = in.readInt();
    }
}

