/*
 * Decompiled with CFR 0.152.
 */
package com.liveshowsound;

import com.liveshowsound.Device;
import com.liveshowsound.PlayBuffer;
import java.awt.EventQueue;
import java.nio.ByteBuffer;

public class DirectSound {
    public static native void setDebugOn(boolean var0);

    public static native int getDeviceCount();

    public static Device getDevice(int p_Index) {
        int intResult;
        Device o_Device = new Device();
        try {
            intResult = DirectSound.getDevice(o_Device, p_Index);
        }
        catch (Exception e) {
            return null;
        }
        if (intResult < 0) {
            return null;
        }
        return o_Device;
    }

    public static native int refreshDevices();

    public static native int getDevice(Device var0, int var1);

    public static native int initDirectSound(int var0, int var1);

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DirectSound.setDebugOn(true);
                DirectSound.initDirectSound(44100, 16);
                DirectSound.refreshDevices();
                System.out.println(DirectSound.getDeviceCount());
                final Device o_Device = DirectSound.getDevice(1);
                if (o_Device != null) {
                    System.out.println("Device: " + o_Device.getName() + " " + o_Device.getDescription());
                    System.out.println("     nativePointer: " + o_Device.getNativePointer());
                    System.out.println("     GUID: " + o_Device.getGUID());
                    System.out.println("     Channels: " + o_Device.getChannels());
                    final ByteBuffer o_ByteBuffer = ByteBuffer.allocate(44100 * o_Device.getAudioFormat().getFrameSize());
                    for (int i = 0; i < 44100; ++i) {
                        o_ByteBuffer.put(i, (byte)0);
                    }
                    try {
                        final PlayBuffer o_PlayBuffer = o_Device.createPlayBuffer(2048, 512);
                        System.out.println("     BufferSize: " + o_PlayBuffer.getBufferSize());
                        Thread o_Thread_Write = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    o_PlayBuffer.start();
                                    int intDataWritten = 0;
                                    intDataWritten = o_PlayBuffer.write(o_ByteBuffer, 0, 44100 * o_Device.getAudioFormat().getFrameSize());
                                    System.out.println("              Data written: " + intDataWritten);
                                    o_PlayBuffer.drainStop();
                                    try {
                                        Thread.sleep(3000L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    o_PlayBuffer.start();
                                    intDataWritten = o_PlayBuffer.write(o_ByteBuffer, 0, 44100 * o_Device.getAudioFormat().getFrameSize());
                                    System.out.println("              Data written: " + intDataWritten);
                                    o_PlayBuffer.drainStop();
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                }
                            }
                        });
                        o_Thread_Write.start();
                        try {
                            o_Thread_Write.join(10000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        o_PlayBuffer.close();
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                System.out.println("END");
            }
        });
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0 && Integer.valueOf(System.getProperty("sun.arch.data.model")) >= 64) {
            System.loadLibrary("import/LiveSHOW_DirectSound" + System.getProperty("sun.arch.data.model"));
        }
    }
}

