/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import CommListModelPackage.ListModel_SerialPorts;
import DMXHardwarePackage.DMX4All_MiniUSBDMXInterface;
import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveCommSerial.CommSerialPortConnection;
import SwingComponents.PopUpToolTip;
import SwingModelPackage.TableAndListModel;
import ToolPackage.HelpDialog;
import com.fazecast.jSerialComm.SerialPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DMX4All_MiniUSBDMXInterface_Configuration
extends JDialog
implements DMXHardwareFeedbackInterface {
    private DMX4All_MiniUSBDMXInterface m_DMX4All_MiniUSBDMXInterface;
    private TableAndListModel.ListModelWrapper<SerialPort> m_ListModelWrapper_SerialPorts;
    private HelpDialog m_HelpDialog;
    private boolean m_DebugOn;
    private static Locale m_LanguageLocale;
    private JButton jButton_CheckConnection;
    private JButton jButton_Disconnect;
    private JButton jButton_HardwareInfo;
    private JButton jButton_InternationalPins;
    private JButton jButton_MartinPins;
    private JButton jButton_RebootHardware;
    private JButton jButton_RefreshPortList;
    private JComboBox jComboBox_BaudRate;
    private JComboBox jComboBox_CommPort;
    private JLabel jLabel_BaudRate;
    private JLabel jLabel_BetterBaudrate;
    private JLabel jLabel_CommPort;
    private JLabel jLabel_ConnectionChecked;
    private JLabel jLabel_ConnectionCommException;
    private JLabel jLabel_ConnectionHardwareException;
    private JLabel jLabel_ConnectionStatus;
    private JLabel jLabel_ConnectionTry;
    private JLabel jLabel_DetectCommPorts;
    private JLabel jLabel_Help;
    private JLabel jLabel_Image;
    private JLabel jLabel_Logo;
    private JLabel jLabel_Name;
    private JLabel jLabel_NoCommPorts;
    private JLabel jLabel_UniverseLabel;
    private JLabel jLabel_UniverseName;
    private JPanel jPanel1;
    private JPanel jPanel_Connection;
    private JPanel jPanel_LogoImage;

    public DMX4All_MiniUSBDMXInterface_Configuration(Frame parent, boolean modal, DMX4All_MiniUSBDMXInterface p_DMX4All_MiniUSBDMXInterface, boolean p_DebugOn) {
        super(parent, modal);
        this.m_DebugOn = p_DebugOn;
        this.m_DMX4All_MiniUSBDMXInterface = p_DMX4All_MiniUSBDMXInterface;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, (String)this.getClass().getSimpleName());
        this.m_DMX4All_MiniUSBDMXInterface.addDMXHardwareFeedbackInterface(this);
        this.clearDisplay();
        this.disableActions();
        this.getContentPane().setBackground(Color.WHITE);
        int intConnectionStatus = this.m_DMX4All_MiniUSBDMXInterface.getConnectionStatus();
        if (intConnectionStatus == 5) {
            this.eventHardwareCheck(this.m_DMX4All_MiniUSBDMXInterface, true, "");
        } else {
            this.eventHardwareConnectionStatus(this.m_DMX4All_MiniUSBDMXInterface, this.m_DMX4All_MiniUSBDMXInterface, intConnectionStatus, null);
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.m_DMX4All_MiniUSBDMXInterface.getDMXPluggedInUniverse();
        if (o_DMXUniverseFeedbackInterface == null) {
            this.jLabel_UniverseName.setText("-");
        } else {
            this.jLabel_UniverseName.setText(o_DMXUniverseFeedbackInterface.getName());
        }
        this.setAlwaysOnTop(true);
    }

    private void initComponentsFurther() {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Image/Interface.gif")).getImage());
        ListModel_SerialPorts o_ListModel_SerialPorts = new ListModel_SerialPorts();
        this.m_ListModelWrapper_SerialPorts = o_ListModel_SerialPorts.createListModelWrapper();
        this.jComboBox_CommPort.setModel(this.m_ListModelWrapper_SerialPorts);
        this.jComboBox_CommPort.setRenderer(o_ListModel_SerialPorts.getListRenderer());
        this.jComboBox_CommPort.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jComboBox_BaudRate.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_CheckConnection.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Disconnect.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_HardwareInfo.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_InternationalPins.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_MartinPins.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RebootHardware.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_RefreshPortList.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_InternationalPins.setVisible(false);
        this.jButton_MartinPins.setVisible(false);
        this.jButton_RebootHardware.setVisible(false);
        this.jLabel_Logo.setBackground(Color.WHITE);
        this.jLabel_Image.setBackground(Color.WHITE);
    }

    public void close() {
        if (this.m_DMX4All_MiniUSBDMXInterface != null) {
            this.m_DMX4All_MiniUSBDMXInterface.removeDMXHardwareFeedbackInterface(this);
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void clearDisplay() {
        this.jLabel_ConnectionChecked.setVisible(false);
        this.jLabel_ConnectionCommException.setVisible(false);
        this.jLabel_ConnectionHardwareException.setVisible(false);
        this.jLabel_ConnectionTry.setVisible(false);
        this.jLabel_BetterBaudrate.setVisible(false);
        this.jLabel_NoCommPorts.setVisible(false);
        this.jLabel_DetectCommPorts.setVisible(false);
    }

    private void enableActions() {
        this.jComboBox_CommPort.setEnabled(false);
        this.jComboBox_BaudRate.setEnabled(false);
        this.jButton_RefreshPortList.setEnabled(false);
        this.jButton_CheckConnection.setEnabled(false);
        this.jButton_Disconnect.setEnabled(true);
        this.jButton_HardwareInfo.setEnabled(true);
        this.jButton_InternationalPins.setEnabled(true);
        this.jButton_MartinPins.setEnabled(true);
        this.jButton_RebootHardware.setEnabled(true);
    }

    private void disableActions() {
        this.jComboBox_CommPort.setEnabled(true);
        this.jComboBox_BaudRate.setEnabled(true);
        this.jButton_RefreshPortList.setEnabled(true);
        this.jButton_CheckConnection.setEnabled(true);
        this.jButton_Disconnect.setEnabled(false);
        this.jButton_HardwareInfo.setEnabled(false);
        this.jButton_InternationalPins.setEnabled(false);
        this.jButton_MartinPins.setEnabled(false);
        this.jButton_RebootHardware.setEnabled(false);
    }

    public void refreshCommPorts() {
        this.clearDisplay();
        this.jLabel_DetectCommPorts.setVisible(true);
        Runnable o_RunnableDetectCommports = new Runnable(){

            @Override
            public void run() {
                ArrayList<SerialPort> o_SerialPorts = CommSerialPortConnection.getSerialPorts();
                DMX4All_MiniUSBDMXInterface_Configuration.this.m_ListModelWrapper_SerialPorts.clear();
                for (int intPort = 0; intPort < o_SerialPorts.size(); ++intPort) {
                    DMX4All_MiniUSBDMXInterface_Configuration.this.m_ListModelWrapper_SerialPorts.add((Object)o_SerialPorts.get(intPort));
                }
                Runnable o_RinRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_CommPort.getModel().getSize() > 0) {
                            DMX4All_MiniUSBDMXInterface_Configuration.this.clearDisplay();
                            if (DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.getComm_Port() != null && DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.getComm_Port().length() > 0) {
                                DMX4All_MiniUSBDMXInterface_Configuration.this.setSelectedSerialPort(DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.getComm_Port());
                            } else {
                                DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_CommPort.setSelectedIndex(0);
                            }
                        } else {
                            DMX4All_MiniUSBDMXInterface_Configuration.this.clearDisplay();
                            DMX4All_MiniUSBDMXInterface_Configuration.this.jLabel_NoCommPorts.setVisible(true);
                        }
                    }
                };
                EventQueue.invokeLater(o_RinRunnable);
            }
        };
        Thread o_Thread = new Thread(o_RunnableDetectCommports, "DMX4All_RefreshCommPorts");
        o_Thread.start();
    }

    public void setSelectedSerialPort(String p_SerialPortName) {
        int intPortCount = this.m_ListModelWrapper_SerialPorts.getSize();
        if (intPortCount <= 0) {
            return;
        }
        for (int intPort = 0; intPort < intPortCount; ++intPort) {
            SerialPort o_SerialPort = (SerialPort)this.m_ListModelWrapper_SerialPorts.get(intPort);
            if (o_SerialPort == null || !o_SerialPort.getSystemPortName().equals(p_SerialPortName)) continue;
            this.jComboBox_CommPort.setSelectedItem(o_SerialPort);
            return;
        }
        this.jComboBox_CommPort.setSelectedItem(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel_Help = new JLabel();
        this.jLabel_Name = new JLabel();
        this.jLabel_CommPort = new JLabel();
        this.jLabel_BaudRate = new JLabel();
        this.jComboBox_CommPort = new JComboBox();
        this.jComboBox_BaudRate = new JComboBox();
        this.jLabel_ConnectionStatus = new JLabel();
        this.jButton_CheckConnection = new JButton();
        this.jButton_RefreshPortList = new JButton();
        this.jButton_InternationalPins = new JButton();
        this.jButton_MartinPins = new JButton();
        this.jButton_HardwareInfo = new JButton();
        this.jButton_RebootHardware = new JButton();
        this.jButton_Disconnect = new JButton();
        this.jLabel_UniverseLabel = new JLabel();
        this.jLabel_UniverseName = new JLabel();
        this.jPanel_Connection = new JPanel();
        this.jLabel_ConnectionChecked = new JLabel();
        this.jLabel_ConnectionCommException = new JLabel();
        this.jLabel_ConnectionHardwareException = new JLabel();
        this.jLabel_ConnectionTry = new JLabel();
        this.jLabel_BetterBaudrate = new JLabel();
        this.jLabel_NoCommPorts = new JLabel();
        this.jLabel_DetectCommPorts = new JLabel();
        this.jPanel_LogoImage = new JPanel();
        this.jLabel_Logo = new JLabel();
        this.jLabel_Image = new JLabel();
        this.setTitle("DMX4All");
        this.setBackground(new Color(0, 0, 0));
        this.setMinimumSize(new Dimension(400, 570));
        this.setPreferredSize(new Dimension(500, 550));
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_Help.setIcon(new ImageIcon(this.getClass().getResource("/ToolPackage/Icon_Question32.png")));
        this.jLabel_Help.setToolTipText("Help");
        this.jLabel_Help.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jLabel_HelpMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Help, gridBagConstraints);
        this.jLabel_Name.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Name.setHorizontalAlignment(0);
        this.jLabel_Name.setText("DMX4All USB-DMX-Interface");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jLabel_CommPort.setHorizontalAlignment(4);
        this.jLabel_CommPort.setText("Comm Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_CommPort, gridBagConstraints);
        this.jLabel_BaudRate.setHorizontalAlignment(4);
        this.jLabel_BaudRate.setText("BaudRate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 13;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_BaudRate, gridBagConstraints);
        this.jComboBox_CommPort.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_CommPort.setMinimumSize(new Dimension(100, 25));
        this.jComboBox_CommPort.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_CommPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_CommPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_CommPort, gridBagConstraints);
        this.jComboBox_BaudRate.setModel(new DefaultComboBoxModel<String>(new String[]{"19200", "38400"}));
        this.jComboBox_BaudRate.setSelectedItem("38400");
        this.jComboBox_BaudRate.setMinimumSize(new Dimension(100, 25));
        this.jComboBox_BaudRate.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_BaudRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_BaudRateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_BaudRate, gridBagConstraints);
        this.jLabel_ConnectionStatus.setBackground(new Color(255, 0, 0));
        this.jLabel_ConnectionStatus.setToolTipText("Connection Status");
        this.jLabel_ConnectionStatus.setMaximumSize(new Dimension(30, 30));
        this.jLabel_ConnectionStatus.setMinimumSize(new Dimension(30, 30));
        this.jLabel_ConnectionStatus.setOpaque(true);
        this.jLabel_ConnectionStatus.setPreferredSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_ConnectionStatus, gridBagConstraints);
        this.jButton_CheckConnection.setText("Check Hardware Connection");
        this.jButton_CheckConnection.setToolTipText("<html>Connect the hardware to the Comm-Port.<br>Check hardware's connection.</html>");
        this.jButton_CheckConnection.setMaximumSize(new Dimension(100, 25));
        this.jButton_CheckConnection.setMinimumSize(new Dimension(100, 25));
        this.jButton_CheckConnection.setPreferredSize(new Dimension(100, 25));
        this.jButton_CheckConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_CheckConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_CheckConnection, gridBagConstraints);
        this.jButton_RefreshPortList.setIcon(new ImageIcon(this.getClass().getResource("/Image/Edit_Refresh.png")));
        this.jButton_RefreshPortList.setToolTipText("Refresh the list of Commports");
        this.jButton_RefreshPortList.setContentAreaFilled(false);
        this.jButton_RefreshPortList.setIconTextGap(0);
        this.jButton_RefreshPortList.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_RefreshPortList.setMaximumSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.setMinimumSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.setPreferredSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_RefreshPortListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_RefreshPortList, gridBagConstraints);
        this.jButton_InternationalPins.setText("Set International Pins");
        this.jButton_InternationalPins.setToolTipText("Sets the pins of the hardware as international used.");
        this.jButton_InternationalPins.setMaximumSize(new Dimension(100, 25));
        this.jButton_InternationalPins.setMinimumSize(new Dimension(100, 25));
        this.jButton_InternationalPins.setPreferredSize(new Dimension(100, 25));
        this.jButton_InternationalPins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_InternationalPinsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_InternationalPins, gridBagConstraints);
        this.jButton_MartinPins.setText("Set Martin Pins");
        this.jButton_MartinPins.setToolTipText("Sets the pins of the hardware as used by Martin - Devices.");
        this.jButton_MartinPins.setMaximumSize(new Dimension(100, 25));
        this.jButton_MartinPins.setMinimumSize(new Dimension(100, 25));
        this.jButton_MartinPins.setPreferredSize(new Dimension(100, 25));
        this.jButton_MartinPins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_MartinPinsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_MartinPins, gridBagConstraints);
        this.jButton_HardwareInfo.setText("Show Hardware Info");
        this.jButton_HardwareInfo.setToolTipText("Shows the information about the hardware.");
        this.jButton_HardwareInfo.setMaximumSize(new Dimension(100, 25));
        this.jButton_HardwareInfo.setMinimumSize(new Dimension(100, 25));
        this.jButton_HardwareInfo.setPreferredSize(new Dimension(100, 25));
        this.jButton_HardwareInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_HardwareInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_HardwareInfo, gridBagConstraints);
        this.jButton_RebootHardware.setText("Reboot Hardware");
        this.jButton_RebootHardware.setToolTipText("Reboots the hardware.");
        this.jButton_RebootHardware.setMaximumSize(new Dimension(100, 25));
        this.jButton_RebootHardware.setMinimumSize(new Dimension(100, 25));
        this.jButton_RebootHardware.setPreferredSize(new Dimension(100, 25));
        this.jButton_RebootHardware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_RebootHardwareActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_RebootHardware, gridBagConstraints);
        this.jButton_Disconnect.setText("Disconnect Hardware");
        this.jButton_Disconnect.setToolTipText("Disconect the hardware.");
        this.jButton_Disconnect.setMaximumSize(new Dimension(100, 25));
        this.jButton_Disconnect.setMinimumSize(new Dimension(100, 25));
        this.jButton_Disconnect.setPreferredSize(new Dimension(100, 25));
        this.jButton_Disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMX4All_MiniUSBDMXInterface_Configuration.this.jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Disconnect, gridBagConstraints);
        this.jLabel_UniverseLabel.setHorizontalAlignment(4);
        this.jLabel_UniverseLabel.setText("Universe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseLabel, gridBagConstraints);
        this.jLabel_UniverseName.setHorizontalAlignment(0);
        this.jLabel_UniverseName.setText("-");
        this.jLabel_UniverseName.setToolTipText("");
        this.jLabel_UniverseName.setMaximumSize(new Dimension(100, 25));
        this.jLabel_UniverseName.setMinimumSize(new Dimension(100, 25));
        this.jLabel_UniverseName.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseName, gridBagConstraints);
        this.jPanel_Connection.setLayout(new GridBagLayout());
        this.jLabel_ConnectionChecked.setHorizontalAlignment(0);
        this.jLabel_ConnectionChecked.setText("<html><center><b>Succesfully Connected</b><br>\nHardware is ok!</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionChecked, gridBagConstraints);
        this.jLabel_ConnectionCommException.setHorizontalAlignment(0);
        this.jLabel_ConnectionCommException.setText("<html><center><b>Exception CommPort</b><br>Connection to Comm Port failed</center></html> ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionCommException, gridBagConstraints);
        this.jLabel_ConnectionHardwareException.setHorizontalAlignment(0);
        this.jLabel_ConnectionHardwareException.setText("<html><center><b>Exception Interface</b><br>Interface does not react<br>- perhabs CommPort is wrong or in use<br>- Check if the hardware is plugged in</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionHardwareException, gridBagConstraints);
        this.jLabel_ConnectionTry.setHorizontalAlignment(0);
        this.jLabel_ConnectionTry.setText("<html><c><b>Try Connection</b></c></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionTry, gridBagConstraints);
        this.jLabel_BetterBaudrate.setForeground(new Color(255, 102, 0));
        this.jLabel_BetterBaudrate.setHorizontalAlignment(0);
        this.jLabel_BetterBaudrate.setText("<html><center><b>Lower Baudrate choosed</b><br>\nIt is better to use the higher Baudrate</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_BetterBaudrate, gridBagConstraints);
        this.jLabel_NoCommPorts.setHorizontalAlignment(0);
        this.jLabel_NoCommPorts.setText("<html><center><b>No Comm-Ports detected</b><br> Is your device connected to the pc?!<br>Exists another device (like Bluetooth-Handy) which blocks the ports?</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_NoCommPorts, gridBagConstraints);
        this.jLabel_DetectCommPorts.setHorizontalAlignment(0);
        this.jLabel_DetectCommPorts.setText("<html><center><b>Search Commports</b><br> This may take a while</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Connection.add((Component)this.jLabel_DetectCommPorts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_Connection, gridBagConstraints);
        this.jPanel_LogoImage.setBackground(new Color(255, 255, 255));
        this.jPanel_LogoImage.setMaximumSize(new Dimension(120, Integer.MAX_VALUE));
        this.jPanel_LogoImage.setMinimumSize(new Dimension(120, 200));
        this.jPanel_LogoImage.setName("");
        this.jPanel_LogoImage.setPreferredSize(new Dimension(120, 200));
        this.jPanel_LogoImage.setLayout(new GridBagLayout());
        this.jLabel_Logo.setBackground(new Color(255, 255, 255));
        this.jLabel_Logo.setForeground(new Color(255, 255, 255));
        this.jLabel_Logo.setHorizontalAlignment(0);
        this.jLabel_Logo.setIcon(new ImageIcon(this.getClass().getResource("/Image/Logo.gif")));
        this.jLabel_Logo.setMaximumSize(new Dimension(100, 80));
        this.jLabel_Logo.setMinimumSize(new Dimension(100, 80));
        this.jLabel_Logo.setPreferredSize(new Dimension(100, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_LogoImage.add((Component)this.jLabel_Logo, gridBagConstraints);
        this.jLabel_Image.setBackground(new Color(255, 255, 255));
        this.jLabel_Image.setForeground(new Color(255, 255, 255));
        this.jLabel_Image.setIcon(new ImageIcon(this.getClass().getResource("/Image/Interface.gif")));
        this.jLabel_Image.setMaximumSize(new Dimension(100, 80));
        this.jLabel_Image.setMinimumSize(new Dimension(100, 80));
        this.jLabel_Image.setName("");
        this.jLabel_Image.setPreferredSize(new Dimension(100, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_LogoImage.add((Component)this.jLabel_Image, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_LogoImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jComboBox_CommPortActionPerformed(ActionEvent evt) {
    }

    private void jButton_CheckConnectionActionPerformed(ActionEvent evt) {
        this.clearDisplay();
        this.jLabel_ConnectionTry.setVisible(true);
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                String stringBaudRate;
                SerialPort o_SerialPort = (SerialPort)DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_CommPort.getSelectedItem();
                if (o_SerialPort != null) {
                    DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.setComm_Port(o_SerialPort.getSystemPortName());
                }
                if ((stringBaudRate = (String)DMX4All_MiniUSBDMXInterface_Configuration.this.jComboBox_BaudRate.getSelectedItem()) != null) {
                    DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.setComm_BaudRate(Integer.valueOf(stringBaudRate));
                }
                if (DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.connect(DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.getConnectionParameters())) {
                    DMX4All_MiniUSBDMXInterface_Configuration.this.m_DMX4All_MiniUSBDMXInterface.requestCheckHardware();
                }
            }
        };
        EventQueue.invokeLater(o_Runnable);
    }

    private void jComboBox_BaudRateActionPerformed(ActionEvent evt) {
        String stringBaudRate = (String)this.jComboBox_BaudRate.getSelectedItem();
        if (stringBaudRate.equals("19200")) {
            this.jLabel_BetterBaudrate.setVisible(true);
        } else {
            this.jLabel_BetterBaudrate.setVisible(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void jButton_RefreshPortListActionPerformed(ActionEvent evt) {
        this.refreshCommPorts();
    }

    private void jButton_HardwareInfoActionPerformed(ActionEvent evt) {
        if (this.m_DMX4All_MiniUSBDMXInterface != null) {
            this.m_DMX4All_MiniUSBDMXInterface.requestHardwareInfo();
        }
    }

    private void jButton_InternationalPinsActionPerformed(ActionEvent evt) {
        if (this.m_DMX4All_MiniUSBDMXInterface == null) {
            return;
        }
        this.m_DMX4All_MiniUSBDMXInterface.command_SetInternationalPins();
    }

    private void jButton_MartinPinsActionPerformed(ActionEvent evt) {
        if (this.m_DMX4All_MiniUSBDMXInterface == null) {
            return;
        }
        this.m_DMX4All_MiniUSBDMXInterface.command_SetMartinPins();
    }

    private void jButton_RebootHardwareActionPerformed(ActionEvent evt) {
        if (this.m_DMX4All_MiniUSBDMXInterface == null) {
            return;
        }
        this.m_DMX4All_MiniUSBDMXInterface.command_RebootHardware();
    }

    private void jButton_DisconnectActionPerformed(ActionEvent evt) {
        this.m_DMX4All_MiniUSBDMXInterface.disconnect();
        this.refreshCommPorts();
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.isAltDown()) {
            // empty if block
        }
    }

    private void jLabel_HelpMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            if (this.m_HelpDialog == null) {
                this.m_HelpDialog = new HelpDialog((Window)this);
            }
            this.m_HelpDialog.setFileBase("DMX4All_MiniUSBDMXInterface");
            this.m_HelpDialog.setVisible(true);
        }
    }

    public void eventHardwareConnectionStatus(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ConnectionStatus, String p_Remark) {
        switch (p_ConnectionStatus) {
            case 2: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                this.disableActions();
                break;
            }
            case 3: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS);
                break;
            }
            case 4: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED);
                break;
            }
            case 5: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                break;
            }
            default: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
            }
        }
    }

    public void eventHardwareCheck(DMXHardwareInterface p_DMXHardwareInterface, boolean p_Valid, String p_Remark) {
        if (p_Valid) {
            this.clearDisplay();
            this.disableActions();
            this.jLabel_ConnectionChecked.setVisible(true);
            this.enableActions();
            if (this.m_DMX4All_MiniUSBDMXInterface != null) {
                this.m_DMX4All_MiniUSBDMXInterface.requestHardwareInfo();
            }
        }
    }

    public void eventHardwareInfo(DMXHardwareInterface p_DMXHardwareInterface, String p_Info) {
        this.jLabel_ConnectionChecked.setText(p_Info);
        if (p_Info.toLowerCase().contains("mini")) {
            this.jButton_InternationalPins.setVisible(true);
            this.jButton_MartinPins.setVisible(true);
            this.jButton_RebootHardware.setVisible(true);
        } else {
            this.jButton_InternationalPins.setVisible(false);
            this.jButton_MartinPins.setVisible(false);
            this.jButton_RebootHardware.setVisible(false);
        }
    }

    public void eventHardwareException(DMXHardwareInterface p_DMXHardwareInterface, int p_ExceptionType, String p_ExceptionString) {
        this.clearDisplay();
        switch (p_ExceptionType) {
            case 900: {
                this.jLabel_ConnectionCommException.setVisible(true);
                this.disableActions();
                break;
            }
            case 910: {
                this.jLabel_ConnectionHardwareException.setVisible(true);
                this.disableActions();
                break;
            }
            case 950: 
            case 951: {
                this.jLabel_ConnectionHardwareException.setVisible(true);
            }
        }
    }

    public void eventHardwarePlugin(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        if (p_NewDMXUniverseFeedbackInterface == null) {
            this.jLabel_UniverseName.setText("-");
        } else {
            this.jLabel_UniverseName.setText(p_NewDMXUniverseFeedbackInterface.getName());
        }
    }

    public void eventHardwarePluginAdded(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
    }

    public void eventHardwarePluginRemoved(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
    }

    public void eventHardwarePluginChanged(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
    }
}

