/*
 * Decompiled with CFR 0.152.
 */
package LiveDBSerializingPackage;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LiveDBObjectDeserializing {
    public static <T extends Serializable> T deserialize(byte[] p_ByteArray) throws ClassNotFoundException, IOException {
        Serializable o_Object;
        ByteArrayInputStream o_ByteArrayInputStream = null;
        if (p_ByteArray == null || p_ByteArray.length <= 0) {
            throw new IOException();
        }
        o_ByteArrayInputStream = new ByteArrayInputStream(p_ByteArray);
        try {
            ObjectInputStream o_ObjectInputStream = new ObjectInputStream(o_ByteArrayInputStream);
            o_Object = (Serializable)o_ObjectInputStream.readObject();
            o_ObjectInputStream.close();
            o_ObjectInputStream = null;
            o_ByteArrayInputStream.close();
            o_ByteArrayInputStream = null;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return (T)o_Object;
    }

    public static <T extends Serializable> T deserialize(ByteBuffer p_InputByteBuffer) throws ClassNotFoundException, IOException {
        if (p_InputByteBuffer == null) {
            throw new IOException();
        }
        if (p_InputByteBuffer.capacity() <= 0) {
            throw new IOException();
        }
        return LiveDBObjectDeserializing.deserialize(p_InputByteBuffer.array());
    }

    public static <T extends Serializable> T deserialize(FileInputStream p_FileStream) throws ClassNotFoundException, IOException {
        if (p_FileStream == null) {
            throw new IOException("No FileSTream");
        }
        ByteBuffer o_ByteBufferLength = ByteBuffer.allocate(4);
        o_ByteBufferLength.clear();
        if (p_FileStream.available() < 4) {
            throw new IOException("File does not contain a object");
        }
        p_FileStream.read(o_ByteBufferLength.array());
        o_ByteBufferLength.position(0);
        o_ByteBufferLength.limit(4);
        int intByteBufferLength = o_ByteBufferLength.getInt();
        if (p_FileStream.available() < intByteBufferLength) {
            throw new IOException("File does not contain a object");
        }
        ByteBuffer o_ByteBuffer = ByteBuffer.allocate(intByteBufferLength);
        p_FileStream.read(o_ByteBuffer.array());
        T o_Object = LiveDBObjectDeserializing.deserialize(o_ByteBuffer);
        return o_Object;
    }
}

