/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import CommListModelPackage.ListModel_SerialPorts;
import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.Enttec_DMX_USB_Pro_MK2;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveCommSerial.CommSerialPortConnection;
import SwingComponents.PopUpToolTip;
import SwingModelPackage.TableAndListModel;
import ToolPackage.HelpDialog;
import com.fazecast.jSerialComm.SerialPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Enttec_DMX_USB_Pro_MK2_Configuration
extends JDialog
implements DMXHardwareFeedbackInterface {
    private Enttec_DMX_USB_Pro_MK2 m_Enttec_DMX_USB_Pro_MK2;
    private TableAndListModel.ListModelWrapper<SerialPort> m_ListModelWrapper_SerialPorts;
    private HelpDialog m_HelpDialog;
    private boolean m_DebugOn;
    private static Locale m_LanguageLocale;
    private JButton jButton_CheckConnection;
    private JButton jButton_Disconnect;
    private JButton jButton_HardwareInfo;
    private JButton jButton_RefreshPortList;
    private JComboBox jComboBox_BaudRate;
    private JComboBox jComboBox_CommPort;
    private JComboBox jComboBox_Port1_InOutput;
    private JComboBox jComboBox_Port2_InOutput;
    private JLabel jLabel_BaudRate;
    private JLabel jLabel_BetterBaudrate;
    private JLabel jLabel_CommPort;
    private JLabel jLabel_ConnectionChecked;
    private JLabel jLabel_ConnectionCommException;
    private JLabel jLabel_ConnectionHardwareException;
    private JLabel jLabel_ConnectionStatus;
    private JLabel jLabel_ConnectionTry;
    private JLabel jLabel_DetectCommPorts;
    private JLabel jLabel_Help;
    private JLabel jLabel_Image;
    private JLabel jLabel_Logo;
    private JLabel jLabel_Name;
    private JLabel jLabel_NoCommPorts;
    private JLabel jLabel_Port1_Output;
    private JLabel jLabel_Port2_Output;
    private JLabel jLabel_UniverseLabel_Port1;
    private JLabel jLabel_UniverseLabel_Port2;
    private JLabel jLabel_UniverseName_Port1;
    private JLabel jLabel_UniverseName_Port2;
    private JPanel jPanel1;
    private JPanel jPanel_Connection;
    private JPanel jPanel_LogoImage;

    public Enttec_DMX_USB_Pro_MK2_Configuration(Frame parent, boolean modal, Enttec_DMX_USB_Pro_MK2 p_Enttec_DMX_USB_Pro, boolean p_DebugOn) {
        super(parent, modal);
        this.m_DebugOn = p_DebugOn;
        this.m_Enttec_DMX_USB_Pro_MK2 = p_Enttec_DMX_USB_Pro;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, (String)this.getClass().getSimpleName());
        this.m_Enttec_DMX_USB_Pro_MK2.addDMXHardwareFeedbackInterface(this);
        this.clearDisplay();
        this.disableActions();
        this.getContentPane().setBackground(Color.WHITE);
        int intConnectionStatus = this.m_Enttec_DMX_USB_Pro_MK2.getConnectionStatus();
        if (intConnectionStatus == 5) {
            this.eventHardwareCheck(this.m_Enttec_DMX_USB_Pro_MK2, true, "");
        } else {
            this.eventHardwareConnectionStatus(this.m_Enttec_DMX_USB_Pro_MK2, null, intConnectionStatus, null);
        }
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(0);
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = o_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXUniverseFeedbackInterface == null) {
            this.jLabel_UniverseName_Port1.setText("-");
        } else {
            this.jLabel_UniverseName_Port1.setText(o_DMXUniverseFeedbackInterface.getName());
        }
        o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(1);
        o_DMXUniverseFeedbackInterface = o_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 2) {
            this.jLabel_UniverseName_Port2.setText("Midi");
        } else if (o_DMXUniverseFeedbackInterface == null) {
            this.jLabel_UniverseName_Port2.setText("-");
        } else {
            this.jLabel_UniverseName_Port2.setText(o_DMXUniverseFeedbackInterface.getName());
        }
        this.setAlwaysOnTop(true);
    }

    private void initComponentsFurther() {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Image/Interface.png")).getImage());
        ListModel_SerialPorts o_ListModel_SerialPorts = new ListModel_SerialPorts();
        this.m_ListModelWrapper_SerialPorts = o_ListModel_SerialPorts.createListModelWrapper();
        this.jComboBox_CommPort.setModel(this.m_ListModelWrapper_SerialPorts);
        this.jComboBox_CommPort.setRenderer(o_ListModel_SerialPorts.getListRenderer());
        this.jComboBox_Port1_InOutput.setEnabled(false);
        this.jComboBox_Port2_InOutput.setEnabled(false);
        this.jComboBox_CommPort.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_BaudRate.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_Port1_InOutput.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_Port2_InOutput.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_CheckConnection.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Disconnect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_HardwareInfo.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RefreshPortList.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_BaudRate.setVisible(false);
        this.jLabel_BaudRate.setVisible(false);
    }

    public void close() {
        if (this.m_Enttec_DMX_USB_Pro_MK2 != null) {
            this.m_Enttec_DMX_USB_Pro_MK2.removeDMXHardwareFeedbackInterface(this);
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void clearDisplay() {
        this.jLabel_ConnectionChecked.setVisible(false);
        this.jLabel_ConnectionCommException.setVisible(false);
        this.jLabel_ConnectionHardwareException.setVisible(false);
        this.jLabel_ConnectionTry.setVisible(false);
        this.jLabel_BetterBaudrate.setVisible(false);
        this.jLabel_NoCommPorts.setVisible(false);
        this.jLabel_DetectCommPorts.setVisible(false);
    }

    private void enableActions() {
        this.jComboBox_CommPort.setEnabled(false);
        this.jComboBox_BaudRate.setEnabled(false);
        this.jComboBox_Port1_InOutput.setEnabled(false);
        this.jComboBox_Port2_InOutput.setEnabled(false);
        this.jButton_RefreshPortList.setEnabled(false);
        this.jButton_CheckConnection.setEnabled(false);
        this.jButton_Disconnect.setEnabled(true);
        this.jButton_HardwareInfo.setEnabled(true);
    }

    private void disableActions() {
        this.jComboBox_CommPort.setEnabled(true);
        this.jComboBox_BaudRate.setEnabled(true);
        if (this.m_Enttec_DMX_USB_Pro_MK2 != null) {
            DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(0);
            if (this.m_Enttec_DMX_USB_Pro_MK2.getDMXPluginType(o_DMXHardwarePluginInterface) == 0) {
                if (this.jComboBox_Port1_InOutput.getSelectedIndex() != 0) {
                    this.jComboBox_Port1_InOutput.setSelectedIndex(0);
                }
            } else if (this.m_Enttec_DMX_USB_Pro_MK2.getDMXPluginType(o_DMXHardwarePluginInterface) == 1 && this.jComboBox_Port1_InOutput.getSelectedIndex() != 1) {
                this.jComboBox_Port1_InOutput.setSelectedIndex(1);
            }
            if (this.m_Enttec_DMX_USB_Pro_MK2.getDMXPluginType(o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(1)) == 0) {
                if (this.jComboBox_Port2_InOutput.getSelectedIndex() != 0) {
                    this.jComboBox_Port2_InOutput.setSelectedIndex(0);
                }
            } else if (this.m_Enttec_DMX_USB_Pro_MK2.getDMXPluginType(o_DMXHardwarePluginInterface) == 1) {
                if (this.jComboBox_Port2_InOutput.getSelectedIndex() != 1) {
                    this.jComboBox_Port2_InOutput.setSelectedIndex(1);
                }
            } else if (this.m_Enttec_DMX_USB_Pro_MK2.getDMXPluginType(o_DMXHardwarePluginInterface) == 2 && this.jComboBox_Port2_InOutput.getSelectedIndex() != 2) {
                this.jComboBox_Port2_InOutput.setSelectedIndex(2);
            }
        }
        this.jComboBox_Port1_InOutput.setEnabled(true);
        this.jComboBox_Port2_InOutput.setEnabled(true);
        this.jButton_RefreshPortList.setEnabled(true);
        this.jButton_CheckConnection.setEnabled(true);
        this.jButton_Disconnect.setEnabled(false);
        this.jButton_HardwareInfo.setEnabled(false);
    }

    public void refreshCommPorts() {
        this.clearDisplay();
        this.jLabel_DetectCommPorts.setVisible(true);
        Runnable o_RunnableDetectCommports = new Runnable(){

            @Override
            public void run() {
                ArrayList o_SerialPorts = CommSerialPortConnection.getSerialPorts();
                Enttec_DMX_USB_Pro_MK2_Configuration.this.m_ListModelWrapper_SerialPorts.clear();
                for (int intPort = 0; intPort < o_SerialPorts.size(); ++intPort) {
                    Enttec_DMX_USB_Pro_MK2_Configuration.this.m_ListModelWrapper_SerialPorts.add(o_SerialPorts.get(intPort));
                }
                Runnable o_RinRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_CommPort.getModel().getSize() > 0) {
                            Enttec_DMX_USB_Pro_MK2_Configuration.this.clearDisplay();
                            if (Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.getComm_Port() != null && Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.getComm_Port().length() > 0) {
                                Enttec_DMX_USB_Pro_MK2_Configuration.this.setSelectedSerialPort(Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.getComm_Port());
                            } else {
                                Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_CommPort.setSelectedIndex(0);
                            }
                        } else {
                            Enttec_DMX_USB_Pro_MK2_Configuration.this.clearDisplay();
                            Enttec_DMX_USB_Pro_MK2_Configuration.this.jLabel_NoCommPorts.setVisible(true);
                        }
                    }
                };
                EventQueue.invokeLater(o_RinRunnable);
            }
        };
        Thread o_Thread = new Thread(o_RunnableDetectCommports, "DMX4All_RefreshCommPorts");
        o_Thread.start();
    }

    public void setSelectedSerialPort(String p_SerialPortName) {
        int intPortCount = this.m_ListModelWrapper_SerialPorts.getSize();
        if (intPortCount <= 0) {
            return;
        }
        for (int intPort = 0; intPort < intPortCount; ++intPort) {
            SerialPort o_SerialPort = (SerialPort)this.m_ListModelWrapper_SerialPorts.get(intPort);
            if (o_SerialPort == null || !o_SerialPort.getSystemPortName().equals(p_SerialPortName)) continue;
            this.jComboBox_CommPort.setSelectedItem(o_SerialPort);
            return;
        }
        this.jComboBox_CommPort.setSelectedItem(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel_Help = new JLabel();
        this.jLabel_Name = new JLabel();
        this.jLabel_CommPort = new JLabel();
        this.jLabel_BaudRate = new JLabel();
        this.jComboBox_CommPort = new JComboBox();
        this.jComboBox_BaudRate = new JComboBox();
        this.jLabel_ConnectionStatus = new JLabel();
        this.jButton_CheckConnection = new JButton();
        this.jButton_RefreshPortList = new JButton();
        this.jButton_HardwareInfo = new JButton();
        this.jButton_Disconnect = new JButton();
        this.jLabel_UniverseLabel_Port2 = new JLabel();
        this.jLabel_UniverseName_Port2 = new JLabel();
        this.jLabel_Port1_Output = new JLabel();
        this.jComboBox_Port1_InOutput = new JComboBox();
        this.jLabel_Port2_Output = new JLabel();
        this.jComboBox_Port2_InOutput = new JComboBox();
        this.jLabel_UniverseName_Port1 = new JLabel();
        this.jLabel_UniverseLabel_Port1 = new JLabel();
        this.jPanel_Connection = new JPanel();
        this.jLabel_ConnectionChecked = new JLabel();
        this.jLabel_ConnectionCommException = new JLabel();
        this.jLabel_ConnectionHardwareException = new JLabel();
        this.jLabel_ConnectionTry = new JLabel();
        this.jLabel_BetterBaudrate = new JLabel();
        this.jLabel_NoCommPorts = new JLabel();
        this.jLabel_DetectCommPorts = new JLabel();
        this.jPanel_LogoImage = new JPanel();
        this.jLabel_Logo = new JLabel();
        this.jLabel_Image = new JLabel();
        this.setTitle("Enttec");
        this.setMinimumSize(new Dimension(400, 570));
        this.setPreferredSize(new Dimension(500, 550));
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_Help.setIcon(new ImageIcon(this.getClass().getResource("/ToolPackage/Icon_Question32.png")));
        this.jLabel_Help.setToolTipText("Help");
        this.jLabel_Help.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jLabel_HelpMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Help, gridBagConstraints);
        this.jLabel_Name.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Name.setHorizontalAlignment(0);
        this.jLabel_Name.setText("Enttec DMX USB Pro MK2");
        this.jLabel_Name.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jLabel_CommPort.setText("Comm Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_CommPort, gridBagConstraints);
        this.jLabel_BaudRate.setText("BaudRate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_BaudRate, gridBagConstraints);
        this.jComboBox_CommPort.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_CommPort.setMinimumSize(new Dimension(100, 25));
        this.jComboBox_CommPort.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_CommPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_CommPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_CommPort, gridBagConstraints);
        this.jComboBox_BaudRate.setModel(new DefaultComboBoxModel<String>(new String[]{"230400"}));
        this.jComboBox_BaudRate.setSelectedItem("38400");
        this.jComboBox_BaudRate.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_BaudRate.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_BaudRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_BaudRateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_BaudRate, gridBagConstraints);
        this.jLabel_ConnectionStatus.setBackground(new Color(255, 0, 0));
        this.jLabel_ConnectionStatus.setToolTipText("Connection Status");
        this.jLabel_ConnectionStatus.setMaximumSize(new Dimension(30, 30));
        this.jLabel_ConnectionStatus.setMinimumSize(new Dimension(30, 30));
        this.jLabel_ConnectionStatus.setOpaque(true);
        this.jLabel_ConnectionStatus.setPreferredSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_ConnectionStatus, gridBagConstraints);
        this.jButton_CheckConnection.setText("Check Hardware Connection");
        this.jButton_CheckConnection.setToolTipText("<html>Connect the hardware to the Comm-Port.<br>Check hardware's connection.</html>");
        this.jButton_CheckConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jButton_CheckConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_CheckConnection, gridBagConstraints);
        this.jButton_RefreshPortList.setIcon(new ImageIcon(this.getClass().getResource("/Image/Edit_Refresh.png")));
        this.jButton_RefreshPortList.setToolTipText("Refresh the list of Commports");
        this.jButton_RefreshPortList.setContentAreaFilled(false);
        this.jButton_RefreshPortList.setIconTextGap(0);
        this.jButton_RefreshPortList.setMaximumSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.setMinimumSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.setPreferredSize(new Dimension(32, 32));
        this.jButton_RefreshPortList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jButton_RefreshPortListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_RefreshPortList, gridBagConstraints);
        this.jButton_HardwareInfo.setText("Show Hardware Info");
        this.jButton_HardwareInfo.setToolTipText("Shows the information about the hardware.");
        this.jButton_HardwareInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jButton_HardwareInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_HardwareInfo, gridBagConstraints);
        this.jButton_Disconnect.setText("Disconnect Hardware");
        this.jButton_Disconnect.setToolTipText("Disconect the hardware.");
        this.jButton_Disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Disconnect, gridBagConstraints);
        this.jLabel_UniverseLabel_Port2.setText("Port2:");
        this.jLabel_UniverseLabel_Port2.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseLabel_Port2, gridBagConstraints);
        this.jLabel_UniverseName_Port2.setHorizontalAlignment(0);
        this.jLabel_UniverseName_Port2.setText("-");
        this.jLabel_UniverseName_Port2.setPreferredSize(new Dimension(4, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseName_Port2, gridBagConstraints);
        this.jLabel_Port1_Output.setText("Port 1");
        this.jLabel_Port1_Output.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Port1_Output, gridBagConstraints);
        this.jComboBox_Port1_InOutput.setModel(new DefaultComboBoxModel<String>(new String[]{"Output", "Input"}));
        this.jComboBox_Port1_InOutput.setSelectedItem("38400");
        this.jComboBox_Port1_InOutput.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_Port1_InOutput.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_Port1_InOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_Port1_InOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_Port1_InOutput, gridBagConstraints);
        this.jLabel_Port2_Output.setText("Port 2");
        this.jLabel_Port2_Output.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_Port2_Output, gridBagConstraints);
        this.jComboBox_Port2_InOutput.setModel(new DefaultComboBoxModel<String>(new String[]{"Output", "Input", "MIDI"}));
        this.jComboBox_Port2_InOutput.setSelectedItem("38400");
        this.jComboBox_Port2_InOutput.setMinimumSize(new Dimension(100, 20));
        this.jComboBox_Port2_InOutput.setPreferredSize(new Dimension(100, 25));
        this.jComboBox_Port2_InOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_Port2_InOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBox_Port2_InOutput, gridBagConstraints);
        this.jLabel_UniverseName_Port1.setHorizontalAlignment(0);
        this.jLabel_UniverseName_Port1.setText("-");
        this.jLabel_UniverseName_Port1.setPreferredSize(new Dimension(4, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseName_Port1, gridBagConstraints);
        this.jLabel_UniverseLabel_Port1.setText("Port1:");
        this.jLabel_UniverseLabel_Port1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_UniverseLabel_Port1, gridBagConstraints);
        this.jPanel_Connection.setLayout(new GridBagLayout());
        this.jLabel_ConnectionChecked.setHorizontalAlignment(0);
        this.jLabel_ConnectionChecked.setText("<html><center><b>Succesfully Connected</b><br>\nHardware is ok!</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionChecked, gridBagConstraints);
        this.jLabel_ConnectionCommException.setHorizontalAlignment(0);
        this.jLabel_ConnectionCommException.setText("<html><center><b>Exception CommPort</b><br>Connection to Comm Port failed</center></html> ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionCommException, gridBagConstraints);
        this.jLabel_ConnectionHardwareException.setHorizontalAlignment(0);
        this.jLabel_ConnectionHardwareException.setText("<html><center><b>Exception Interface</b><br>Interface does not react<br>- perhabs CommPort is wrong or in use<br>- Check if the hardware is plugged in</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionHardwareException, gridBagConstraints);
        this.jLabel_ConnectionTry.setHorizontalAlignment(0);
        this.jLabel_ConnectionTry.setText("<html><c><b>Try Connection</b></c></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_ConnectionTry, gridBagConstraints);
        this.jLabel_BetterBaudrate.setForeground(new Color(255, 102, 0));
        this.jLabel_BetterBaudrate.setHorizontalAlignment(0);
        this.jLabel_BetterBaudrate.setText("<html><center><b>Lower Baudrate choosed</b><br>\nIt is better to use the higher Baudrate</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_BetterBaudrate, gridBagConstraints);
        this.jLabel_NoCommPorts.setHorizontalAlignment(0);
        this.jLabel_NoCommPorts.setText("<html><center><b>No Comm-Ports detected</b><br> Is your device connected to the pc?!<br>Exists another device (like Bluetooth-Handy) which blocks the ports?</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_NoCommPorts, gridBagConstraints);
        this.jLabel_DetectCommPorts.setHorizontalAlignment(0);
        this.jLabel_DetectCommPorts.setText("<html><center><b>Search Commports</b><br> This may take a while</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Connection.add((Component)this.jLabel_DetectCommPorts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_Connection, gridBagConstraints);
        this.jPanel_LogoImage.setBackground(new Color(255, 255, 255));
        this.jPanel_LogoImage.setMaximumSize(new Dimension(120, Integer.MAX_VALUE));
        this.jPanel_LogoImage.setMinimumSize(new Dimension(120, 117));
        this.jPanel_LogoImage.setPreferredSize(new Dimension(120, 117));
        this.jPanel_LogoImage.setLayout(new GridBagLayout());
        this.jLabel_Logo.setHorizontalAlignment(0);
        this.jLabel_Logo.setIcon(new ImageIcon(this.getClass().getResource("/Image/Logo.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_LogoImage.add((Component)this.jLabel_Logo, gridBagConstraints);
        this.jLabel_Image.setIcon(new ImageIcon(this.getClass().getResource("/Image/Interface.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_LogoImage.add((Component)this.jLabel_Image, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel_LogoImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jComboBox_CommPortActionPerformed(ActionEvent evt) {
    }

    private void jButton_CheckConnectionActionPerformed(ActionEvent evt) {
        this.clearDisplay();
        this.jLabel_ConnectionTry.setVisible(true);
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                String stringBaudRate;
                SerialPort o_SerialPort = (SerialPort)Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_CommPort.getSelectedItem();
                if (o_SerialPort != null) {
                    Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.setComm_Port(o_SerialPort.getSystemPortName());
                }
                if ((stringBaudRate = (String)Enttec_DMX_USB_Pro_MK2_Configuration.this.jComboBox_BaudRate.getSelectedItem()) != null) {
                    Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.setComm_BaudRate(Integer.valueOf(stringBaudRate));
                }
                if (Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.connect(Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.getConnectionParameters())) {
                    Enttec_DMX_USB_Pro_MK2_Configuration.this.m_Enttec_DMX_USB_Pro_MK2.requestCheckHardware();
                }
            }
        };
        EventQueue.invokeLater(o_Runnable);
    }

    private void jComboBox_BaudRateActionPerformed(ActionEvent evt) {
        String stringBaudRate = (String)this.jComboBox_BaudRate.getSelectedItem();
        if (stringBaudRate.equals("19200")) {
            this.jLabel_BetterBaudrate.setVisible(true);
        } else {
            this.jLabel_BetterBaudrate.setVisible(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void jButton_RefreshPortListActionPerformed(ActionEvent evt) {
        this.refreshCommPorts();
    }

    private void jButton_HardwareInfoActionPerformed(ActionEvent evt) {
        if (this.m_Enttec_DMX_USB_Pro_MK2 != null) {
            this.m_Enttec_DMX_USB_Pro_MK2.requestHardwareInfo();
        }
    }

    private void jButton_DisconnectActionPerformed(ActionEvent evt) {
        this.m_Enttec_DMX_USB_Pro_MK2.disconnect();
        this.refreshCommPorts();
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.isAltDown()) {
            // empty if block
        }
    }

    private void jLabel_HelpMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            if (this.m_HelpDialog == null) {
                this.m_HelpDialog = new HelpDialog((Window)this);
            }
            this.m_HelpDialog.setFileBase("Enttec_DMX_USB_Pro_MK2");
            this.m_HelpDialog.setVisible(true);
        }
    }

    private void jComboBox_Port1_InOutputActionPerformed(ActionEvent evt) {
        if (this.m_Enttec_DMX_USB_Pro_MK2 == null) {
            return;
        }
        Enttec_DMX_USB_Pro_MK2.DMXHardwarePlugIn o_DMXHardwarePluginInterface = (Enttec_DMX_USB_Pro_MK2.DMXHardwarePlugIn)this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(0);
        if (o_DMXHardwarePluginInterface == null) {
            return;
        }
        if (this.jComboBox_Port1_InOutput.getSelectedIndex() == 0) {
            o_DMXHardwarePluginInterface.setDMXPluginType(0);
        } else if (this.jComboBox_Port1_InOutput.getSelectedIndex() == 1) {
            o_DMXHardwarePluginInterface.setDMXPluginType(1);
        }
    }

    private void jComboBox_Port2_InOutputActionPerformed(ActionEvent evt) {
        if (this.m_Enttec_DMX_USB_Pro_MK2 == null) {
            return;
        }
        Enttec_DMX_USB_Pro_MK2.DMXHardwarePlugIn o_DMXHardwarePluginInterface = (Enttec_DMX_USB_Pro_MK2.DMXHardwarePlugIn)this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(1);
        if (this.jComboBox_Port2_InOutput.getSelectedIndex() == 0) {
            o_DMXHardwarePluginInterface.setDMXPluginType(0);
        } else if (this.jComboBox_Port2_InOutput.getSelectedIndex() == 1) {
            o_DMXHardwarePluginInterface.setDMXPluginType(1);
        } else if (this.jComboBox_Port2_InOutput.getSelectedIndex() == 2) {
            o_DMXHardwarePluginInterface.setDMXPluginType(2);
        }
    }

    @Override
    public void eventHardwareConnectionStatus(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ConnectionStatus, String p_Remark) {
        switch (p_ConnectionStatus) {
            case 2: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                this.disableActions();
                break;
            }
            case 3: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS);
                break;
            }
            case 4: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED);
                break;
            }
            case 5: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                break;
            }
            default: {
                this.jLabel_ConnectionStatus.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
            }
        }
    }

    @Override
    public void eventHardwareCheck(DMXHardwareInterface p_DMXHardwareInterface, boolean p_Valid, String p_Remark) {
        if (p_Valid) {
            this.clearDisplay();
            this.disableActions();
            this.jLabel_ConnectionChecked.setVisible(true);
            this.enableActions();
            if (this.m_Enttec_DMX_USB_Pro_MK2 != null) {
                this.m_Enttec_DMX_USB_Pro_MK2.requestHardwareInfo();
            }
        }
    }

    @Override
    public void eventHardwareInfo(DMXHardwareInterface p_DMXHardwareInterface, String p_Info) {
        this.jLabel_ConnectionChecked.setText(p_Info);
    }

    @Override
    public void eventHardwareException(DMXHardwareInterface p_DMXHardwareInterface, int p_ExceptionType, String p_ExceptionString) {
        this.clearDisplay();
        switch (p_ExceptionType) {
            case 900: {
                this.jLabel_ConnectionCommException.setVisible(true);
                this.disableActions();
                break;
            }
            case 910: {
                this.jLabel_ConnectionHardwareException.setVisible(true);
                this.disableActions();
                break;
            }
            case 950: 
            case 951: {
                this.jLabel_ConnectionHardwareException.setVisible(true);
            }
        }
    }

    @Override
    public void eventHardwarePlugin(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(0);
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = o_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXHardwarePluginFeedbackInterface == null) {
            this.jLabel_UniverseName_Port1.setText("-");
        } else {
            this.jLabel_UniverseName_Port1.setText(o_DMXHardwarePluginFeedbackInterface.getName());
        }
        o_DMXHardwarePluginInterface = this.m_Enttec_DMX_USB_Pro_MK2.getDMXHardwarePlugin(1);
        o_DMXHardwarePluginFeedbackInterface = o_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 2) {
            this.jLabel_UniverseName_Port2.setText("Midi");
        } else if (o_DMXHardwarePluginFeedbackInterface == null) {
            this.jLabel_UniverseName_Port2.setText("-");
        } else {
            this.jLabel_UniverseName_Port2.setText(o_DMXHardwarePluginFeedbackInterface.getName());
        }
    }

    @Override
    public void eventHardwarePluginAdded(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
    }

    @Override
    public void eventHardwarePluginRemoved(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
    }

    @Override
    public void eventHardwarePluginChanged(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        if (p_DMXHardwarePluginInterface.getPluginIndex() == 0) {
            if (p_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
                this.jComboBox_Port1_InOutput.setSelectedIndex(0);
            } else if (p_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
                this.jComboBox_Port1_InOutput.setSelectedIndex(1);
            }
        } else if (p_DMXHardwarePluginInterface.getPluginIndex() == 1) {
            if (p_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
                this.jComboBox_Port2_InOutput.setSelectedIndex(0);
            } else if (p_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
                this.jComboBox_Port2_InOutput.setSelectedIndex(1);
            } else if (p_DMXHardwarePluginInterface.getDMXPluginType() == 2) {
                this.jComboBox_Port2_InOutput.setSelectedIndex(2);
            }
            DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
            if (p_DMXHardwarePluginInterface.getDMXPluginType() == 2) {
                this.jLabel_UniverseName_Port2.setText("Midi");
            } else if (o_DMXHardwarePluginFeedbackInterface == null) {
                this.jLabel_UniverseName_Port2.setText("-");
            } else {
                this.jLabel_UniverseName_Port2.setText(o_DMXHardwarePluginFeedbackInterface.getName());
            }
        }
    }
}

